#ifndef CPU_H
#define CPU_H

#define CPU_INTERRUPT_DISABLED	FALSE	/* disable interrupts */
#define CPU_NMI_CYCLES_WAIT	3	/* ppu cycles to wait before an NMI */
#define CPU_EMPTY_RAM		FALSE	/* ram is not entirely empty on first boot.. due to lockout chip? */
#define CPU_ILLEGAL_MAX		255	/* maximum number of illegal opcodes to log, 0=disable */

#define INTERRUPT_NONE		0
#define INTERRUPT_BRK		BIT(0)
#define INTERRUPT_IRQ		BIT(1)
#define INTERRUPT_NMI		BIT(2)
#define INTERRUPT_RES		BIT(3)

#define IRQ_MAPPER		BIT(4)
#define IRQ_DMC			BIT(5)
#define IRQ_FRAME		BIT(6)

#define INT_EDGE_NMI		BIT(0)
#define INT_EDGE_IRQ		BIT(1)

enum { CPU_FPT_NORMAL=0, CPU_FPT_WRAM_READ, CPU_FPT_WRAM_WRITE, CPU_FPT_PRG1A_READ, CPU_FPT_PRG1B_READ, CPU_FPT_PRG2A_READ, CPU_FPT_PRG2B_READ };

typedef __fastcall void(*fp_mapper_irq)(void);

void cpu_set_fpt(BYTE);
void cpu_set_mapper_irq(fp_mapper_irq);
void cpu_set_interrupt(WORD);
void cpu_acknowledge_interrupt(BYTE);
void cpu_set_overflow(void);
int* cpu_get_cycles_ptr(void);
void cpu_new_frame(void);
void cpu_execute(register const int);
void cpu_reset(void);
void cpu_init(void);
void cpu_clean(void);
void cpu_fill_op_cycles_lookup(void);
void __fastcall cpu_sprite_dma_transfer(register BYTE);
void __fastcall cpu_set_apu_fs_next_step(int);
void __fastcall cpu_reset_apu_fs_next_step(void);
BYTE __fastcall cpu_set_apu_dmc_next_step(void);
void __fastcall cpu_reset_apu_dmc_freq(int);
BYTE __fastcall cpu_dmc_dma_transfer(register WORD);
void cpu_set_vblank_nmi_want(void);
void cpu_do_vblank_nmi(void);
void cpu_kill_cycle(void);

#endif /* CPU_H */
