#ifndef CARTRIDGE_H
#define CARTRIDGE_H

#define CARTRIDGE_CHECK_CRC32		TRUE	/* check/fix broken iNES headers with crc32 */
#define CARTRIDGE_CHECK_CRC32_PAL	TRUE	/* apply PAL based on crc32 (only if above is true) */

#define CARTRIDGE_MIRRORING_HORIZONTAL	BIN8(00001100)
#define CARTRIDGE_MIRRORING_VERTICAL	BIN8(00001010)
#define CARTRIDGE_MIRRORING_ONE_0	0
#define CARTRIDGE_MIRRORING_ONE_1	BIN8(00001111)
#define CARTRIDGE_MIRRORING_4		BIT(7)
#define CARTRIDGE_MIRRORING_CUSTOM	BIT(6)

enum { CARTRIDGE_REGION_USA=0, CARTRIDGE_REGION_JAPAN, CARTRIDGE_REGION_EUROPE };

typedef struct {
	DWORD crc32;
	char name[STRING_SIZE];
	
	DWORD prgbanks;
	DWORD vrombanks;
	BYTE mirroring;
	BYTE type;
	BYTE mode;
	BYTE region;
	BYTE trainer;

	BYTE battery;
	DWORD battery_size;
	
	BYTE* prg[0x200];
	BYTE* vrom[0x800];
	BYTE* vram[0x10];
	
	BYTE* dummy_rom;
	BYTE* dummy_vrom;
	
	BYTE* wram;
	BYTE* cur_wrambank;
	BYTE wram_isenabled;
	BYTE wram_writeenable;
	
	BYTE* cur_prgbank[4];
	BYTE cur_prgbank_isram[4];
	BYTE* cur_patbank[8];
	BYTE cur_patbank_isram[8];
} Cartridge;

Cartridge* cartridge;


void cartridge_battery_load(void);
void cartridge_battery_save(void);

int cartridge_load(void);
void cartridge_unload(void);
void cartridge_init(void);
void cartridge_clean(void);

#endif /* CARTRIDGE_H */
