#ifndef APU_H
#define APU_H

#define APU_DMC_FREQ_PAL_FACTOR	0.929	/* ntsc->pal dmc frequency factor */
#define APU_FS_FREQ_PAL_FACTOR	1.1148	/* ntsc->pal framesequencer frequency factor */
#define APU_FS_INITIAL		0	/* initial write to 0x4017: 0: enable frame irqs on boot, 0x40: disable */
/*	confirmed behaviour: 0
	
	problems with 0x00:
	- Stars SE: locks up at boot
	
	problems with 0x40:
	dunno
*/

void __fastcall apu_write_dmc_control(register BYTE);
void __fastcall apu_write_dmc_dac(register BYTE);
void __fastcall apu_write_dmc_address(register BYTE);
void __fastcall apu_write_dmc_length(register BYTE);
void __fastcall apu_run_dmc(void); /* I just *had* to call it Run-DMC */

void __fastcall apu_write_status(register BYTE);
BYTE __fastcall apu_read_status(register WORD);

void __fastcall apu_write_fs(register BYTE);
void __fastcall apu_run_fs(void);


void apu_init(void);
void apu_clean(void);

#endif /* APU_H */
