#ifndef M68KOPS__HEADER
#define M68KOPS__HEADER

/* ======================================================================== */
/* ============================ OPCODE HANDLERS =========================== */
/* ======================================================================== */


void m68k_op_1010(void);
void m68k_op_1111(void);
void m68k_op_abcd_8_rr(void);
void m68k_op_abcd_8_mm_ax7(void);
void m68k_op_abcd_8_mm_ay7(void);
void m68k_op_abcd_8_mm_axy7(void);
void m68k_op_abcd_8_mm(void);
void m68k_op_add_8_er_d(void);
void m68k_op_add_8_er_ai(void);
void m68k_op_add_8_er_pi(void);
void m68k_op_add_8_er_pi7(void);
void m68k_op_add_8_er_pd(void);
void m68k_op_add_8_er_pd7(void);
void m68k_op_add_8_er_di(void);
void m68k_op_add_8_er_ix(void);
void m68k_op_add_8_er_aw(void);
void m68k_op_add_8_er_al(void);
void m68k_op_add_8_er_pcdi(void);
void m68k_op_add_8_er_pcix(void);
void m68k_op_add_8_er_i(void);
void m68k_op_add_16_er_d(void);
void m68k_op_add_16_er_a(void);
void m68k_op_add_16_er_ai(void);
void m68k_op_add_16_er_pi(void);
void m68k_op_add_16_er_pd(void);
void m68k_op_add_16_er_di(void);
void m68k_op_add_16_er_ix(void);
void m68k_op_add_16_er_aw(void);
void m68k_op_add_16_er_al(void);
void m68k_op_add_16_er_pcdi(void);
void m68k_op_add_16_er_pcix(void);
void m68k_op_add_16_er_i(void);
void m68k_op_add_32_er_d(void);
void m68k_op_add_32_er_a(void);
void m68k_op_add_32_er_ai(void);
void m68k_op_add_32_er_pi(void);
void m68k_op_add_32_er_pd(void);
void m68k_op_add_32_er_di(void);
void m68k_op_add_32_er_ix(void);
void m68k_op_add_32_er_aw(void);
void m68k_op_add_32_er_al(void);
void m68k_op_add_32_er_pcdi(void);
void m68k_op_add_32_er_pcix(void);
void m68k_op_add_32_er_i(void);
void m68k_op_add_8_re_ai(void);
void m68k_op_add_8_re_pi(void);
void m68k_op_add_8_re_pi7(void);
void m68k_op_add_8_re_pd(void);
void m68k_op_add_8_re_pd7(void);
void m68k_op_add_8_re_di(void);
void m68k_op_add_8_re_ix(void);
void m68k_op_add_8_re_aw(void);
void m68k_op_add_8_re_al(void);
void m68k_op_add_16_re_ai(void);
void m68k_op_add_16_re_pi(void);
void m68k_op_add_16_re_pd(void);
void m68k_op_add_16_re_di(void);
void m68k_op_add_16_re_ix(void);
void m68k_op_add_16_re_aw(void);
void m68k_op_add_16_re_al(void);
void m68k_op_add_32_re_ai(void);
void m68k_op_add_32_re_pi(void);
void m68k_op_add_32_re_pd(void);
void m68k_op_add_32_re_di(void);
void m68k_op_add_32_re_ix(void);
void m68k_op_add_32_re_aw(void);
void m68k_op_add_32_re_al(void);
void m68k_op_adda_16_d(void);
void m68k_op_adda_16_a(void);
void m68k_op_adda_16_ai(void);
void m68k_op_adda_16_pi(void);
void m68k_op_adda_16_pd(void);
void m68k_op_adda_16_di(void);
void m68k_op_adda_16_ix(void);
void m68k_op_adda_16_aw(void);
void m68k_op_adda_16_al(void);
void m68k_op_adda_16_pcdi(void);
void m68k_op_adda_16_pcix(void);
void m68k_op_adda_16_i(void);
void m68k_op_adda_32_d(void);
void m68k_op_adda_32_a(void);
void m68k_op_adda_32_ai(void);
void m68k_op_adda_32_pi(void);
void m68k_op_adda_32_pd(void);
void m68k_op_adda_32_di(void);
void m68k_op_adda_32_ix(void);
void m68k_op_adda_32_aw(void);
void m68k_op_adda_32_al(void);
void m68k_op_adda_32_pcdi(void);
void m68k_op_adda_32_pcix(void);
void m68k_op_adda_32_i(void);
void m68k_op_addi_8_d(void);
void m68k_op_addi_8_ai(void);
void m68k_op_addi_8_pi(void);
void m68k_op_addi_8_pi7(void);
void m68k_op_addi_8_pd(void);
void m68k_op_addi_8_pd7(void);
void m68k_op_addi_8_di(void);
void m68k_op_addi_8_ix(void);
void m68k_op_addi_8_aw(void);
void m68k_op_addi_8_al(void);
void m68k_op_addi_16_d(void);
void m68k_op_addi_16_ai(void);
void m68k_op_addi_16_pi(void);
void m68k_op_addi_16_pd(void);
void m68k_op_addi_16_di(void);
void m68k_op_addi_16_ix(void);
void m68k_op_addi_16_aw(void);
void m68k_op_addi_16_al(void);
void m68k_op_addi_32_d(void);
void m68k_op_addi_32_ai(void);
void m68k_op_addi_32_pi(void);
void m68k_op_addi_32_pd(void);
void m68k_op_addi_32_di(void);
void m68k_op_addi_32_ix(void);
void m68k_op_addi_32_aw(void);
void m68k_op_addi_32_al(void);
void m68k_op_addq_8_d(void);
void m68k_op_addq_8_ai(void);
void m68k_op_addq_8_pi(void);
void m68k_op_addq_8_pi7(void);
void m68k_op_addq_8_pd(void);
void m68k_op_addq_8_pd7(void);
void m68k_op_addq_8_di(void);
void m68k_op_addq_8_ix(void);
void m68k_op_addq_8_aw(void);
void m68k_op_addq_8_al(void);
void m68k_op_addq_16_d(void);
void m68k_op_addq_16_a(void);
void m68k_op_addq_16_ai(void);
void m68k_op_addq_16_pi(void);
void m68k_op_addq_16_pd(void);
void m68k_op_addq_16_di(void);
void m68k_op_addq_16_ix(void);
void m68k_op_addq_16_aw(void);
void m68k_op_addq_16_al(void);
void m68k_op_addq_32_d(void);
void m68k_op_addq_32_a(void);
void m68k_op_addq_32_ai(void);
void m68k_op_addq_32_pi(void);
void m68k_op_addq_32_pd(void);
void m68k_op_addq_32_di(void);
void m68k_op_addq_32_ix(void);
void m68k_op_addq_32_aw(void);
void m68k_op_addq_32_al(void);
void m68k_op_addx_8_rr(void);
void m68k_op_addx_16_rr(void);
void m68k_op_addx_32_rr(void);
void m68k_op_addx_8_mm_ax7(void);
void m68k_op_addx_8_mm_ay7(void);
void m68k_op_addx_8_mm_axy7(void);
void m68k_op_addx_8_mm(void);
void m68k_op_addx_16_mm(void);
void m68k_op_addx_32_mm(void);
void m68k_op_and_8_er_d(void);
void m68k_op_and_8_er_ai(void);
void m68k_op_and_8_er_pi(void);
void m68k_op_and_8_er_pi7(void);
void m68k_op_and_8_er_pd(void);
void m68k_op_and_8_er_pd7(void);
void m68k_op_and_8_er_di(void);
void m68k_op_and_8_er_ix(void);
void m68k_op_and_8_er_aw(void);
void m68k_op_and_8_er_al(void);
void m68k_op_and_8_er_pcdi(void);
void m68k_op_and_8_er_pcix(void);
void m68k_op_and_8_er_i(void);
void m68k_op_and_16_er_d(void);
void m68k_op_and_16_er_ai(void);
void m68k_op_and_16_er_pi(void);
void m68k_op_and_16_er_pd(void);
void m68k_op_and_16_er_di(void);
void m68k_op_and_16_er_ix(void);
void m68k_op_and_16_er_aw(void);
void m68k_op_and_16_er_al(void);
void m68k_op_and_16_er_pcdi(void);
void m68k_op_and_16_er_pcix(void);
void m68k_op_and_16_er_i(void);
void m68k_op_and_32_er_d(void);
void m68k_op_and_32_er_ai(void);
void m68k_op_and_32_er_pi(void);
void m68k_op_and_32_er_pd(void);
void m68k_op_and_32_er_di(void);
void m68k_op_and_32_er_ix(void);
void m68k_op_and_32_er_aw(void);
void m68k_op_and_32_er_al(void);
void m68k_op_and_32_er_pcdi(void);
void m68k_op_and_32_er_pcix(void);
void m68k_op_and_32_er_i(void);
void m68k_op_and_8_re_ai(void);
void m68k_op_and_8_re_pi(void);
void m68k_op_and_8_re_pi7(void);
void m68k_op_and_8_re_pd(void);
void m68k_op_and_8_re_pd7(void);
void m68k_op_and_8_re_di(void);
void m68k_op_and_8_re_ix(void);
void m68k_op_and_8_re_aw(void);
void m68k_op_and_8_re_al(void);
void m68k_op_and_16_re_ai(void);
void m68k_op_and_16_re_pi(void);
void m68k_op_and_16_re_pd(void);
void m68k_op_and_16_re_di(void);
void m68k_op_and_16_re_ix(void);
void m68k_op_and_16_re_aw(void);
void m68k_op_and_16_re_al(void);
void m68k_op_and_32_re_ai(void);
void m68k_op_and_32_re_pi(void);
void m68k_op_and_32_re_pd(void);
void m68k_op_and_32_re_di(void);
void m68k_op_and_32_re_ix(void);
void m68k_op_and_32_re_aw(void);
void m68k_op_and_32_re_al(void);
void m68k_op_andi_8_d(void);
void m68k_op_andi_8_ai(void);
void m68k_op_andi_8_pi(void);
void m68k_op_andi_8_pi7(void);
void m68k_op_andi_8_pd(void);
void m68k_op_andi_8_pd7(void);
void m68k_op_andi_8_di(void);
void m68k_op_andi_8_ix(void);
void m68k_op_andi_8_aw(void);
void m68k_op_andi_8_al(void);
void m68k_op_andi_16_d(void);
void m68k_op_andi_16_ai(void);
void m68k_op_andi_16_pi(void);
void m68k_op_andi_16_pd(void);
void m68k_op_andi_16_di(void);
void m68k_op_andi_16_ix(void);
void m68k_op_andi_16_aw(void);
void m68k_op_andi_16_al(void);
void m68k_op_andi_32_d(void);
void m68k_op_andi_32_ai(void);
void m68k_op_andi_32_pi(void);
void m68k_op_andi_32_pd(void);
void m68k_op_andi_32_di(void);
void m68k_op_andi_32_ix(void);
void m68k_op_andi_32_aw(void);
void m68k_op_andi_32_al(void);
void m68k_op_andi_16_toc(void);
void m68k_op_andi_16_tos(void);
void m68k_op_asr_8_s(void);
void m68k_op_asr_16_s(void);
void m68k_op_asr_32_s(void);
void m68k_op_asr_8_r(void);
void m68k_op_asr_16_r(void);
void m68k_op_asr_32_r(void);
void m68k_op_asr_16_ai(void);
void m68k_op_asr_16_pi(void);
void m68k_op_asr_16_pd(void);
void m68k_op_asr_16_di(void);
void m68k_op_asr_16_ix(void);
void m68k_op_asr_16_aw(void);
void m68k_op_asr_16_al(void);
void m68k_op_asl_8_s(void);
void m68k_op_asl_16_s(void);
void m68k_op_asl_32_s(void);
void m68k_op_asl_8_r(void);
void m68k_op_asl_16_r(void);
void m68k_op_asl_32_r(void);
void m68k_op_asl_16_ai(void);
void m68k_op_asl_16_pi(void);
void m68k_op_asl_16_pd(void);
void m68k_op_asl_16_di(void);
void m68k_op_asl_16_ix(void);
void m68k_op_asl_16_aw(void);
void m68k_op_asl_16_al(void);
void m68k_op_bhi_8(void);
void m68k_op_bls_8(void);
void m68k_op_bcc_8(void);
void m68k_op_bcs_8(void);
void m68k_op_bne_8(void);
void m68k_op_beq_8(void);
void m68k_op_bvc_8(void);
void m68k_op_bvs_8(void);
void m68k_op_bpl_8(void);
void m68k_op_bmi_8(void);
void m68k_op_bge_8(void);
void m68k_op_blt_8(void);
void m68k_op_bgt_8(void);
void m68k_op_ble_8(void);
void m68k_op_bhi_16(void);
void m68k_op_bls_16(void);
void m68k_op_bcc_16(void);
void m68k_op_bcs_16(void);
void m68k_op_bne_16(void);
void m68k_op_beq_16(void);
void m68k_op_bvc_16(void);
void m68k_op_bvs_16(void);
void m68k_op_bpl_16(void);
void m68k_op_bmi_16(void);
void m68k_op_bge_16(void);
void m68k_op_blt_16(void);
void m68k_op_bgt_16(void);
void m68k_op_ble_16(void);
void m68k_op_bhi_32(void);
void m68k_op_bls_32(void);
void m68k_op_bcc_32(void);
void m68k_op_bcs_32(void);
void m68k_op_bne_32(void);
void m68k_op_beq_32(void);
void m68k_op_bvc_32(void);
void m68k_op_bvs_32(void);
void m68k_op_bpl_32(void);
void m68k_op_bmi_32(void);
void m68k_op_bge_32(void);
void m68k_op_blt_32(void);
void m68k_op_bgt_32(void);
void m68k_op_ble_32(void);
void m68k_op_bchg_32_r_d(void);
void m68k_op_bchg_8_r_ai(void);
void m68k_op_bchg_8_r_pi(void);
void m68k_op_bchg_8_r_pi7(void);
void m68k_op_bchg_8_r_pd(void);
void m68k_op_bchg_8_r_pd7(void);
void m68k_op_bchg_8_r_di(void);
void m68k_op_bchg_8_r_ix(void);
void m68k_op_bchg_8_r_aw(void);
void m68k_op_bchg_8_r_al(void);
void m68k_op_bchg_32_s_d(void);
void m68k_op_bchg_8_s_ai(void);
void m68k_op_bchg_8_s_pi(void);
void m68k_op_bchg_8_s_pi7(void);
void m68k_op_bchg_8_s_pd(void);
void m68k_op_bchg_8_s_pd7(void);
void m68k_op_bchg_8_s_di(void);
void m68k_op_bchg_8_s_ix(void);
void m68k_op_bchg_8_s_aw(void);
void m68k_op_bchg_8_s_al(void);
void m68k_op_bclr_32_r_d(void);
void m68k_op_bclr_8_r_ai(void);
void m68k_op_bclr_8_r_pi(void);
void m68k_op_bclr_8_r_pi7(void);
void m68k_op_bclr_8_r_pd(void);
void m68k_op_bclr_8_r_pd7(void);
void m68k_op_bclr_8_r_di(void);
void m68k_op_bclr_8_r_ix(void);
void m68k_op_bclr_8_r_aw(void);
void m68k_op_bclr_8_r_al(void);
void m68k_op_bclr_32_s_d(void);
void m68k_op_bclr_8_s_ai(void);
void m68k_op_bclr_8_s_pi(void);
void m68k_op_bclr_8_s_pi7(void);
void m68k_op_bclr_8_s_pd(void);
void m68k_op_bclr_8_s_pd7(void);
void m68k_op_bclr_8_s_di(void);
void m68k_op_bclr_8_s_ix(void);
void m68k_op_bclr_8_s_aw(void);
void m68k_op_bclr_8_s_al(void);
void m68k_op_bfchg_32_d(void);
void m68k_op_bfchg_32_ai(void);
void m68k_op_bfchg_32_di(void);
void m68k_op_bfchg_32_ix(void);
void m68k_op_bfchg_32_aw(void);
void m68k_op_bfchg_32_al(void);
void m68k_op_bfclr_32_d(void);
void m68k_op_bfclr_32_ai(void);
void m68k_op_bfclr_32_di(void);
void m68k_op_bfclr_32_ix(void);
void m68k_op_bfclr_32_aw(void);
void m68k_op_bfclr_32_al(void);
void m68k_op_bfexts_32_d(void);
void m68k_op_bfexts_32_ai(void);
void m68k_op_bfexts_32_di(void);
void m68k_op_bfexts_32_ix(void);
void m68k_op_bfexts_32_aw(void);
void m68k_op_bfexts_32_al(void);
void m68k_op_bfexts_32_pcdi(void);
void m68k_op_bfexts_32_pcix(void);
void m68k_op_bfextu_32_d(void);
void m68k_op_bfextu_32_ai(void);
void m68k_op_bfextu_32_di(void);
void m68k_op_bfextu_32_ix(void);
void m68k_op_bfextu_32_aw(void);
void m68k_op_bfextu_32_al(void);
void m68k_op_bfextu_32_pcdi(void);
void m68k_op_bfextu_32_pcix(void);
void m68k_op_bfffo_32_d(void);
void m68k_op_bfffo_32_ai(void);
void m68k_op_bfffo_32_di(void);
void m68k_op_bfffo_32_ix(void);
void m68k_op_bfffo_32_aw(void);
void m68k_op_bfffo_32_al(void);
void m68k_op_bfffo_32_pcdi(void);
void m68k_op_bfffo_32_pcix(void);
void m68k_op_bfins_32_d(void);
void m68k_op_bfins_32_ai(void);
void m68k_op_bfins_32_di(void);
void m68k_op_bfins_32_ix(void);
void m68k_op_bfins_32_aw(void);
void m68k_op_bfins_32_al(void);
void m68k_op_bfset_32_d(void);
void m68k_op_bfset_32_ai(void);
void m68k_op_bfset_32_di(void);
void m68k_op_bfset_32_ix(void);
void m68k_op_bfset_32_aw(void);
void m68k_op_bfset_32_al(void);
void m68k_op_bftst_32_d(void);
void m68k_op_bftst_32_ai(void);
void m68k_op_bftst_32_di(void);
void m68k_op_bftst_32_ix(void);
void m68k_op_bftst_32_aw(void);
void m68k_op_bftst_32_al(void);
void m68k_op_bftst_32_pcdi(void);
void m68k_op_bftst_32_pcix(void);
void m68k_op_bkpt(void);
void m68k_op_bra_8(void);
void m68k_op_bra_16(void);
void m68k_op_bra_32(void);
void m68k_op_bset_32_r_d(void);
void m68k_op_bset_8_r_ai(void);
void m68k_op_bset_8_r_pi(void);
void m68k_op_bset_8_r_pi7(void);
void m68k_op_bset_8_r_pd(void);
void m68k_op_bset_8_r_pd7(void);
void m68k_op_bset_8_r_di(void);
void m68k_op_bset_8_r_ix(void);
void m68k_op_bset_8_r_aw(void);
void m68k_op_bset_8_r_al(void);
void m68k_op_bset_32_s_d(void);
void m68k_op_bset_8_s_ai(void);
void m68k_op_bset_8_s_pi(void);
void m68k_op_bset_8_s_pi7(void);
void m68k_op_bset_8_s_pd(void);
void m68k_op_bset_8_s_pd7(void);
void m68k_op_bset_8_s_di(void);
void m68k_op_bset_8_s_ix(void);
void m68k_op_bset_8_s_aw(void);
void m68k_op_bset_8_s_al(void);
void m68k_op_bsr_8(void);
void m68k_op_bsr_16(void);
void m68k_op_bsr_32(void);
void m68k_op_btst_32_r_d(void);
void m68k_op_btst_8_r_ai(void);
void m68k_op_btst_8_r_pi(void);
void m68k_op_btst_8_r_pi7(void);
void m68k_op_btst_8_r_pd(void);
void m68k_op_btst_8_r_pd7(void);
void m68k_op_btst_8_r_di(void);
void m68k_op_btst_8_r_ix(void);
void m68k_op_btst_8_r_aw(void);
void m68k_op_btst_8_r_al(void);
void m68k_op_btst_8_r_pcdi(void);
void m68k_op_btst_8_r_pcix(void);
void m68k_op_btst_8_r_i(void);
void m68k_op_btst_32_s_d(void);
void m68k_op_btst_8_s_ai(void);
void m68k_op_btst_8_s_pi(void);
void m68k_op_btst_8_s_pi7(void);
void m68k_op_btst_8_s_pd(void);
void m68k_op_btst_8_s_pd7(void);
void m68k_op_btst_8_s_di(void);
void m68k_op_btst_8_s_ix(void);
void m68k_op_btst_8_s_aw(void);
void m68k_op_btst_8_s_al(void);
void m68k_op_btst_8_s_pcdi(void);
void m68k_op_btst_8_s_pcix(void);
void m68k_op_callm_32_ai(void);
void m68k_op_callm_32_di(void);
void m68k_op_callm_32_ix(void);
void m68k_op_callm_32_aw(void);
void m68k_op_callm_32_al(void);
void m68k_op_callm_32_pcdi(void);
void m68k_op_callm_32_pcix(void);
void m68k_op_cas_8_ai(void);
void m68k_op_cas_8_pi(void);
void m68k_op_cas_8_pi7(void);
void m68k_op_cas_8_pd(void);
void m68k_op_cas_8_pd7(void);
void m68k_op_cas_8_di(void);
void m68k_op_cas_8_ix(void);
void m68k_op_cas_8_aw(void);
void m68k_op_cas_8_al(void);
void m68k_op_cas_16_ai(void);
void m68k_op_cas_16_pi(void);
void m68k_op_cas_16_pd(void);
void m68k_op_cas_16_di(void);
void m68k_op_cas_16_ix(void);
void m68k_op_cas_16_aw(void);
void m68k_op_cas_16_al(void);
void m68k_op_cas_32_ai(void);
void m68k_op_cas_32_pi(void);
void m68k_op_cas_32_pd(void);
void m68k_op_cas_32_di(void);
void m68k_op_cas_32_ix(void);
void m68k_op_cas_32_aw(void);
void m68k_op_cas_32_al(void);
void m68k_op_cas2_16(void);
void m68k_op_cas2_32(void);
void m68k_op_chk_16_d(void);
void m68k_op_chk_16_ai(void);
void m68k_op_chk_16_pi(void);
void m68k_op_chk_16_pd(void);
void m68k_op_chk_16_di(void);
void m68k_op_chk_16_ix(void);
void m68k_op_chk_16_aw(void);
void m68k_op_chk_16_al(void);
void m68k_op_chk_16_pcdi(void);
void m68k_op_chk_16_pcix(void);
void m68k_op_chk_16_i(void);
void m68k_op_chk_32_d(void);
void m68k_op_chk_32_ai(void);
void m68k_op_chk_32_pi(void);
void m68k_op_chk_32_pd(void);
void m68k_op_chk_32_di(void);
void m68k_op_chk_32_ix(void);
void m68k_op_chk_32_aw(void);
void m68k_op_chk_32_al(void);
void m68k_op_chk_32_pcdi(void);
void m68k_op_chk_32_pcix(void);
void m68k_op_chk_32_i(void);
void m68k_op_chk2cmp2_8_pcdi(void);
void m68k_op_chk2cmp2_8_pcix(void);
void m68k_op_chk2cmp2_8_ai(void);
void m68k_op_chk2cmp2_8_di(void);
void m68k_op_chk2cmp2_8_ix(void);
void m68k_op_chk2cmp2_8_aw(void);
void m68k_op_chk2cmp2_8_al(void);
void m68k_op_chk2cmp2_16_pcdi(void);
void m68k_op_chk2cmp2_16_pcix(void);
void m68k_op_chk2cmp2_16_ai(void);
void m68k_op_chk2cmp2_16_di(void);
void m68k_op_chk2cmp2_16_ix(void);
void m68k_op_chk2cmp2_16_aw(void);
void m68k_op_chk2cmp2_16_al(void);
void m68k_op_chk2cmp2_32_pcdi(void);
void m68k_op_chk2cmp2_32_pcix(void);
void m68k_op_chk2cmp2_32_ai(void);
void m68k_op_chk2cmp2_32_di(void);
void m68k_op_chk2cmp2_32_ix(void);
void m68k_op_chk2cmp2_32_aw(void);
void m68k_op_chk2cmp2_32_al(void);
void m68k_op_clr_8_d(void);
void m68k_op_clr_8_ai(void);
void m68k_op_clr_8_pi(void);
void m68k_op_clr_8_pi7(void);
void m68k_op_clr_8_pd(void);
void m68k_op_clr_8_pd7(void);
void m68k_op_clr_8_di(void);
void m68k_op_clr_8_ix(void);
void m68k_op_clr_8_aw(void);
void m68k_op_clr_8_al(void);
void m68k_op_clr_16_d(void);
void m68k_op_clr_16_ai(void);
void m68k_op_clr_16_pi(void);
void m68k_op_clr_16_pd(void);
void m68k_op_clr_16_di(void);
void m68k_op_clr_16_ix(void);
void m68k_op_clr_16_aw(void);
void m68k_op_clr_16_al(void);
void m68k_op_clr_32_d(void);
void m68k_op_clr_32_ai(void);
void m68k_op_clr_32_pi(void);
void m68k_op_clr_32_pd(void);
void m68k_op_clr_32_di(void);
void m68k_op_clr_32_ix(void);
void m68k_op_clr_32_aw(void);
void m68k_op_clr_32_al(void);
void m68k_op_cmp_8_d(void);
void m68k_op_cmp_8_ai(void);
void m68k_op_cmp_8_pi(void);
void m68k_op_cmp_8_pi7(void);
void m68k_op_cmp_8_pd(void);
void m68k_op_cmp_8_pd7(void);
void m68k_op_cmp_8_di(void);
void m68k_op_cmp_8_ix(void);
void m68k_op_cmp_8_aw(void);
void m68k_op_cmp_8_al(void);
void m68k_op_cmp_8_pcdi(void);
void m68k_op_cmp_8_pcix(void);
void m68k_op_cmp_8_i(void);
void m68k_op_cmp_16_d(void);
void m68k_op_cmp_16_a(void);
void m68k_op_cmp_16_ai(void);
void m68k_op_cmp_16_pi(void);
void m68k_op_cmp_16_pd(void);
void m68k_op_cmp_16_di(void);
void m68k_op_cmp_16_ix(void);
void m68k_op_cmp_16_aw(void);
void m68k_op_cmp_16_al(void);
void m68k_op_cmp_16_pcdi(void);
void m68k_op_cmp_16_pcix(void);
void m68k_op_cmp_16_i(void);
void m68k_op_cmp_32_d(void);
void m68k_op_cmp_32_a(void);
void m68k_op_cmp_32_ai(void);
void m68k_op_cmp_32_pi(void);
void m68k_op_cmp_32_pd(void);
void m68k_op_cmp_32_di(void);
void m68k_op_cmp_32_ix(void);
void m68k_op_cmp_32_aw(void);
void m68k_op_cmp_32_al(void);
void m68k_op_cmp_32_pcdi(void);
void m68k_op_cmp_32_pcix(void);
void m68k_op_cmp_32_i(void);
void m68k_op_cmpa_16_d(void);
void m68k_op_cmpa_16_a(void);
void m68k_op_cmpa_16_ai(void);
void m68k_op_cmpa_16_pi(void);
void m68k_op_cmpa_16_pd(void);
void m68k_op_cmpa_16_di(void);
void m68k_op_cmpa_16_ix(void);
void m68k_op_cmpa_16_aw(void);
void m68k_op_cmpa_16_al(void);
void m68k_op_cmpa_16_pcdi(void);
void m68k_op_cmpa_16_pcix(void);
void m68k_op_cmpa_16_i(void);
void m68k_op_cmpa_32_d(void);
void m68k_op_cmpa_32_a(void);
void m68k_op_cmpa_32_ai(void);
void m68k_op_cmpa_32_pi(void);
void m68k_op_cmpa_32_pd(void);
void m68k_op_cmpa_32_di(void);
void m68k_op_cmpa_32_ix(void);
void m68k_op_cmpa_32_aw(void);
void m68k_op_cmpa_32_al(void);
void m68k_op_cmpa_32_pcdi(void);
void m68k_op_cmpa_32_pcix(void);
void m68k_op_cmpa_32_i(void);
void m68k_op_cmpi_8_d(void);
void m68k_op_cmpi_8_ai(void);
void m68k_op_cmpi_8_pi(void);
void m68k_op_cmpi_8_pi7(void);
void m68k_op_cmpi_8_pd(void);
void m68k_op_cmpi_8_pd7(void);
void m68k_op_cmpi_8_di(void);
void m68k_op_cmpi_8_ix(void);
void m68k_op_cmpi_8_aw(void);
void m68k_op_cmpi_8_al(void);
void m68k_op_cmpi_8_pcdi(void);
void m68k_op_cmpi_8_pcix(void);
void m68k_op_cmpi_16_d(void);
void m68k_op_cmpi_16_ai(void);
void m68k_op_cmpi_16_pi(void);
void m68k_op_cmpi_16_pd(void);
void m68k_op_cmpi_16_di(void);
void m68k_op_cmpi_16_ix(void);
void m68k_op_cmpi_16_aw(void);
void m68k_op_cmpi_16_al(void);
void m68k_op_cmpi_16_pcdi(void);
void m68k_op_cmpi_16_pcix(void);
void m68k_op_cmpi_32_d(void);
void m68k_op_cmpi_32_ai(void);
void m68k_op_cmpi_32_pi(void);
void m68k_op_cmpi_32_pd(void);
void m68k_op_cmpi_32_di(void);
void m68k_op_cmpi_32_ix(void);
void m68k_op_cmpi_32_aw(void);
void m68k_op_cmpi_32_al(void);
void m68k_op_cmpi_32_pcdi(void);
void m68k_op_cmpi_32_pcix(void);
void m68k_op_cmpm_8_ax7(void);
void m68k_op_cmpm_8_ay7(void);
void m68k_op_cmpm_8_axy7(void);
void m68k_op_cmpm_8(void);
void m68k_op_cmpm_16(void);
void m68k_op_cmpm_32(void);
void m68k_op_cpdbcc_32(void);
void m68k_op_cpgen_32(void);
void m68k_op_cpscc_32(void);
void m68k_op_cptrapcc_32(void);
void m68k_op_dbt_16(void);
void m68k_op_dbf_16(void);
void m68k_op_dbhi_16(void);
void m68k_op_dbls_16(void);
void m68k_op_dbcc_16(void);
void m68k_op_dbcs_16(void);
void m68k_op_dbne_16(void);
void m68k_op_dbeq_16(void);
void m68k_op_dbvc_16(void);
void m68k_op_dbvs_16(void);
void m68k_op_dbpl_16(void);
void m68k_op_dbmi_16(void);
void m68k_op_dbge_16(void);
void m68k_op_dblt_16(void);
void m68k_op_dbgt_16(void);
void m68k_op_dble_16(void);
void m68k_op_divs_16_d(void);
void m68k_op_divs_16_ai(void);
void m68k_op_divs_16_pi(void);
void m68k_op_divs_16_pd(void);
void m68k_op_divs_16_di(void);
void m68k_op_divs_16_ix(void);
void m68k_op_divs_16_aw(void);
void m68k_op_divs_16_al(void);
void m68k_op_divs_16_pcdi(void);
void m68k_op_divs_16_pcix(void);
void m68k_op_divs_16_i(void);
void m68k_op_divu_16_d(void);
void m68k_op_divu_16_ai(void);
void m68k_op_divu_16_pi(void);
void m68k_op_divu_16_pd(void);
void m68k_op_divu_16_di(void);
void m68k_op_divu_16_ix(void);
void m68k_op_divu_16_aw(void);
void m68k_op_divu_16_al(void);
void m68k_op_divu_16_pcdi(void);
void m68k_op_divu_16_pcix(void);
void m68k_op_divu_16_i(void);
void m68k_op_divl_32_d(void);
void m68k_op_divl_32_ai(void);
void m68k_op_divl_32_pi(void);
void m68k_op_divl_32_pd(void);
void m68k_op_divl_32_di(void);
void m68k_op_divl_32_ix(void);
void m68k_op_divl_32_aw(void);
void m68k_op_divl_32_al(void);
void m68k_op_divl_32_pcdi(void);
void m68k_op_divl_32_pcix(void);
void m68k_op_divl_32_i(void);
void m68k_op_eor_8_d(void);
void m68k_op_eor_8_ai(void);
void m68k_op_eor_8_pi(void);
void m68k_op_eor_8_pi7(void);
void m68k_op_eor_8_pd(void);
void m68k_op_eor_8_pd7(void);
void m68k_op_eor_8_di(void);
void m68k_op_eor_8_ix(void);
void m68k_op_eor_8_aw(void);
void m68k_op_eor_8_al(void);
void m68k_op_eor_16_d(void);
void m68k_op_eor_16_ai(void);
void m68k_op_eor_16_pi(void);
void m68k_op_eor_16_pd(void);
void m68k_op_eor_16_di(void);
void m68k_op_eor_16_ix(void);
void m68k_op_eor_16_aw(void);
void m68k_op_eor_16_al(void);
void m68k_op_eor_32_d(void);
void m68k_op_eor_32_ai(void);
void m68k_op_eor_32_pi(void);
void m68k_op_eor_32_pd(void);
void m68k_op_eor_32_di(void);
void m68k_op_eor_32_ix(void);
void m68k_op_eor_32_aw(void);
void m68k_op_eor_32_al(void);
void m68k_op_eori_8_d(void);
void m68k_op_eori_8_ai(void);
void m68k_op_eori_8_pi(void);
void m68k_op_eori_8_pi7(void);
void m68k_op_eori_8_pd(void);
void m68k_op_eori_8_pd7(void);
void m68k_op_eori_8_di(void);
void m68k_op_eori_8_ix(void);
void m68k_op_eori_8_aw(void);
void m68k_op_eori_8_al(void);
void m68k_op_eori_16_d(void);
void m68k_op_eori_16_ai(void);
void m68k_op_eori_16_pi(void);
void m68k_op_eori_16_pd(void);
void m68k_op_eori_16_di(void);
void m68k_op_eori_16_ix(void);
void m68k_op_eori_16_aw(void);
void m68k_op_eori_16_al(void);
void m68k_op_eori_32_d(void);
void m68k_op_eori_32_ai(void);
void m68k_op_eori_32_pi(void);
void m68k_op_eori_32_pd(void);
void m68k_op_eori_32_di(void);
void m68k_op_eori_32_ix(void);
void m68k_op_eori_32_aw(void);
void m68k_op_eori_32_al(void);
void m68k_op_eori_16_toc(void);
void m68k_op_eori_16_tos(void);
void m68k_op_exg_32_dd(void);
void m68k_op_exg_32_aa(void);
void m68k_op_exg_32_da(void);
void m68k_op_ext_16(void);
void m68k_op_ext_32(void);
void m68k_op_extb_32(void);
void m68k_op_illegal(void);
void m68k_op_jmp_32_ai(void);
void m68k_op_jmp_32_di(void);
void m68k_op_jmp_32_ix(void);
void m68k_op_jmp_32_aw(void);
void m68k_op_jmp_32_al(void);
void m68k_op_jmp_32_pcdi(void);
void m68k_op_jmp_32_pcix(void);
void m68k_op_jsr_32_ai(void);
void m68k_op_jsr_32_di(void);
void m68k_op_jsr_32_ix(void);
void m68k_op_jsr_32_aw(void);
void m68k_op_jsr_32_al(void);
void m68k_op_jsr_32_pcdi(void);
void m68k_op_jsr_32_pcix(void);
void m68k_op_lea_32_ai(void);
void m68k_op_lea_32_di(void);
void m68k_op_lea_32_ix(void);
void m68k_op_lea_32_aw(void);
void m68k_op_lea_32_al(void);
void m68k_op_lea_32_pcdi(void);
void m68k_op_lea_32_pcix(void);
void m68k_op_link_16_a7(void);
void m68k_op_link_16(void);
void m68k_op_link_32_a7(void);
void m68k_op_link_32(void);
void m68k_op_lsr_8_s(void);
void m68k_op_lsr_16_s(void);
void m68k_op_lsr_32_s(void);
void m68k_op_lsr_8_r(void);
void m68k_op_lsr_16_r(void);
void m68k_op_lsr_32_r(void);
void m68k_op_lsr_16_ai(void);
void m68k_op_lsr_16_pi(void);
void m68k_op_lsr_16_pd(void);
void m68k_op_lsr_16_di(void);
void m68k_op_lsr_16_ix(void);
void m68k_op_lsr_16_aw(void);
void m68k_op_lsr_16_al(void);
void m68k_op_lsl_8_s(void);
void m68k_op_lsl_16_s(void);
void m68k_op_lsl_32_s(void);
void m68k_op_lsl_8_r(void);
void m68k_op_lsl_16_r(void);
void m68k_op_lsl_32_r(void);
void m68k_op_lsl_16_ai(void);
void m68k_op_lsl_16_pi(void);
void m68k_op_lsl_16_pd(void);
void m68k_op_lsl_16_di(void);
void m68k_op_lsl_16_ix(void);
void m68k_op_lsl_16_aw(void);
void m68k_op_lsl_16_al(void);
void m68k_op_move_8_d_d(void);
void m68k_op_move_8_d_ai(void);
void m68k_op_move_8_d_pi(void);
void m68k_op_move_8_d_pi7(void);
void m68k_op_move_8_d_pd(void);
void m68k_op_move_8_d_pd7(void);
void m68k_op_move_8_d_di(void);
void m68k_op_move_8_d_ix(void);
void m68k_op_move_8_d_aw(void);
void m68k_op_move_8_d_al(void);
void m68k_op_move_8_d_pcdi(void);
void m68k_op_move_8_d_pcix(void);
void m68k_op_move_8_d_i(void);
void m68k_op_move_8_ai_d(void);
void m68k_op_move_8_ai_ai(void);
void m68k_op_move_8_ai_pi(void);
void m68k_op_move_8_ai_pi7(void);
void m68k_op_move_8_ai_pd(void);
void m68k_op_move_8_ai_pd7(void);
void m68k_op_move_8_ai_di(void);
void m68k_op_move_8_ai_ix(void);
void m68k_op_move_8_ai_aw(void);
void m68k_op_move_8_ai_al(void);
void m68k_op_move_8_ai_pcdi(void);
void m68k_op_move_8_ai_pcix(void);
void m68k_op_move_8_ai_i(void);
void m68k_op_move_8_pi7_d(void);
void m68k_op_move_8_pi_d(void);
void m68k_op_move_8_pi7_ai(void);
void m68k_op_move_8_pi7_pi(void);
void m68k_op_move_8_pi7_pi7(void);
void m68k_op_move_8_pi7_pd(void);
void m68k_op_move_8_pi7_pd7(void);
void m68k_op_move_8_pi7_di(void);
void m68k_op_move_8_pi7_ix(void);
void m68k_op_move_8_pi7_aw(void);
void m68k_op_move_8_pi7_al(void);
void m68k_op_move_8_pi7_pcdi(void);
void m68k_op_move_8_pi7_pcix(void);
void m68k_op_move_8_pi7_i(void);
void m68k_op_move_8_pi_ai(void);
void m68k_op_move_8_pi_pi(void);
void m68k_op_move_8_pi_pi7(void);
void m68k_op_move_8_pi_pd(void);
void m68k_op_move_8_pi_pd7(void);
void m68k_op_move_8_pi_di(void);
void m68k_op_move_8_pi_ix(void);
void m68k_op_move_8_pi_aw(void);
void m68k_op_move_8_pi_al(void);
void m68k_op_move_8_pi_pcdi(void);
void m68k_op_move_8_pi_pcix(void);
void m68k_op_move_8_pi_i(void);
void m68k_op_move_8_pd7_d(void);
void m68k_op_move_8_pd_d(void);
void m68k_op_move_8_pd7_ai(void);
void m68k_op_move_8_pd7_pi(void);
void m68k_op_move_8_pd7_pi7(void);
void m68k_op_move_8_pd7_pd(void);
void m68k_op_move_8_pd7_pd7(void);
void m68k_op_move_8_pd7_di(void);
void m68k_op_move_8_pd7_ix(void);
void m68k_op_move_8_pd7_aw(void);
void m68k_op_move_8_pd7_al(void);
void m68k_op_move_8_pd7_pcdi(void);
void m68k_op_move_8_pd7_pcix(void);
void m68k_op_move_8_pd7_i(void);
void m68k_op_move_8_pd_ai(void);
void m68k_op_move_8_pd_pi(void);
void m68k_op_move_8_pd_pi7(void);
void m68k_op_move_8_pd_pd(void);
void m68k_op_move_8_pd_pd7(void);
void m68k_op_move_8_pd_di(void);
void m68k_op_move_8_pd_ix(void);
void m68k_op_move_8_pd_aw(void);
void m68k_op_move_8_pd_al(void);
void m68k_op_move_8_pd_pcdi(void);
void m68k_op_move_8_pd_pcix(void);
void m68k_op_move_8_pd_i(void);
void m68k_op_move_8_di_d(void);
void m68k_op_move_8_di_ai(void);
void m68k_op_move_8_di_pi(void);
void m68k_op_move_8_di_pi7(void);
void m68k_op_move_8_di_pd(void);
void m68k_op_move_8_di_pd7(void);
void m68k_op_move_8_di_di(void);
void m68k_op_move_8_di_ix(void);
void m68k_op_move_8_di_aw(void);
void m68k_op_move_8_di_al(void);
void m68k_op_move_8_di_pcdi(void);
void m68k_op_move_8_di_pcix(void);
void m68k_op_move_8_di_i(void);
void m68k_op_move_8_ix_d(void);
void m68k_op_move_8_ix_ai(void);
void m68k_op_move_8_ix_pi(void);
void m68k_op_move_8_ix_pi7(void);
void m68k_op_move_8_ix_pd(void);
void m68k_op_move_8_ix_pd7(void);
void m68k_op_move_8_ix_di(void);
void m68k_op_move_8_ix_ix(void);
void m68k_op_move_8_ix_aw(void);
void m68k_op_move_8_ix_al(void);
void m68k_op_move_8_ix_pcdi(void);
void m68k_op_move_8_ix_pcix(void);
void m68k_op_move_8_ix_i(void);
void m68k_op_move_8_aw_d(void);
void m68k_op_move_8_aw_ai(void);
void m68k_op_move_8_aw_pi(void);
void m68k_op_move_8_aw_pi7(void);
void m68k_op_move_8_aw_pd(void);
void m68k_op_move_8_aw_pd7(void);
void m68k_op_move_8_aw_di(void);
void m68k_op_move_8_aw_ix(void);
void m68k_op_move_8_aw_aw(void);
void m68k_op_move_8_aw_al(void);
void m68k_op_move_8_aw_pcdi(void);
void m68k_op_move_8_aw_pcix(void);
void m68k_op_move_8_aw_i(void);
void m68k_op_move_8_al_d(void);
void m68k_op_move_8_al_ai(void);
void m68k_op_move_8_al_pi(void);
void m68k_op_move_8_al_pi7(void);
void m68k_op_move_8_al_pd(void);
void m68k_op_move_8_al_pd7(void);
void m68k_op_move_8_al_di(void);
void m68k_op_move_8_al_ix(void);
void m68k_op_move_8_al_aw(void);
void m68k_op_move_8_al_al(void);
void m68k_op_move_8_al_pcdi(void);
void m68k_op_move_8_al_pcix(void);
void m68k_op_move_8_al_i(void);
void m68k_op_move_16_d_d(void);
void m68k_op_move_16_d_a(void);
void m68k_op_move_16_d_ai(void);
void m68k_op_move_16_d_pi(void);
void m68k_op_move_16_d_pd(void);
void m68k_op_move_16_d_di(void);
void m68k_op_move_16_d_ix(void);
void m68k_op_move_16_d_aw(void);
void m68k_op_move_16_d_al(void);
void m68k_op_move_16_d_pcdi(void);
void m68k_op_move_16_d_pcix(void);
void m68k_op_move_16_d_i(void);
void m68k_op_move_16_ai_d(void);
void m68k_op_move_16_ai_a(void);
void m68k_op_move_16_ai_ai(void);
void m68k_op_move_16_ai_pi(void);
void m68k_op_move_16_ai_pd(void);
void m68k_op_move_16_ai_di(void);
void m68k_op_move_16_ai_ix(void);
void m68k_op_move_16_ai_aw(void);
void m68k_op_move_16_ai_al(void);
void m68k_op_move_16_ai_pcdi(void);
void m68k_op_move_16_ai_pcix(void);
void m68k_op_move_16_ai_i(void);
void m68k_op_move_16_pi_d(void);
void m68k_op_move_16_pi_a(void);
void m68k_op_move_16_pi_ai(void);
void m68k_op_move_16_pi_pi(void);
void m68k_op_move_16_pi_pd(void);
void m68k_op_move_16_pi_di(void);
void m68k_op_move_16_pi_ix(void);
void m68k_op_move_16_pi_aw(void);
void m68k_op_move_16_pi_al(void);
void m68k_op_move_16_pi_pcdi(void);
void m68k_op_move_16_pi_pcix(void);
void m68k_op_move_16_pi_i(void);
void m68k_op_move_16_pd_d(void);
void m68k_op_move_16_pd_a(void);
void m68k_op_move_16_pd_ai(void);
void m68k_op_move_16_pd_pi(void);
void m68k_op_move_16_pd_pd(void);
void m68k_op_move_16_pd_di(void);
void m68k_op_move_16_pd_ix(void);
void m68k_op_move_16_pd_aw(void);
void m68k_op_move_16_pd_al(void);
void m68k_op_move_16_pd_pcdi(void);
void m68k_op_move_16_pd_pcix(void);
void m68k_op_move_16_pd_i(void);
void m68k_op_move_16_di_d(void);
void m68k_op_move_16_di_a(void);
void m68k_op_move_16_di_ai(void);
void m68k_op_move_16_di_pi(void);
void m68k_op_move_16_di_pd(void);
void m68k_op_move_16_di_di(void);
void m68k_op_move_16_di_ix(void);
void m68k_op_move_16_di_aw(void);
void m68k_op_move_16_di_al(void);
void m68k_op_move_16_di_pcdi(void);
void m68k_op_move_16_di_pcix(void);
void m68k_op_move_16_di_i(void);
void m68k_op_move_16_ix_d(void);
void m68k_op_move_16_ix_a(void);
void m68k_op_move_16_ix_ai(void);
void m68k_op_move_16_ix_pi(void);
void m68k_op_move_16_ix_pd(void);
void m68k_op_move_16_ix_di(void);
void m68k_op_move_16_ix_ix(void);
void m68k_op_move_16_ix_aw(void);
void m68k_op_move_16_ix_al(void);
void m68k_op_move_16_ix_pcdi(void);
void m68k_op_move_16_ix_pcix(void);
void m68k_op_move_16_ix_i(void);
void m68k_op_move_16_aw_d(void);
void m68k_op_move_16_aw_a(void);
void m68k_op_move_16_aw_ai(void);
void m68k_op_move_16_aw_pi(void);
void m68k_op_move_16_aw_pd(void);
void m68k_op_move_16_aw_di(void);
void m68k_op_move_16_aw_ix(void);
void m68k_op_move_16_aw_aw(void);
void m68k_op_move_16_aw_al(void);
void m68k_op_move_16_aw_pcdi(void);
void m68k_op_move_16_aw_pcix(void);
void m68k_op_move_16_aw_i(void);
void m68k_op_move_16_al_d(void);
void m68k_op_move_16_al_a(void);
void m68k_op_move_16_al_ai(void);
void m68k_op_move_16_al_pi(void);
void m68k_op_move_16_al_pd(void);
void m68k_op_move_16_al_di(void);
void m68k_op_move_16_al_ix(void);
void m68k_op_move_16_al_aw(void);
void m68k_op_move_16_al_al(void);
void m68k_op_move_16_al_pcdi(void);
void m68k_op_move_16_al_pcix(void);
void m68k_op_move_16_al_i(void);
void m68k_op_move_32_d_d(void);
void m68k_op_move_32_d_a(void);
void m68k_op_move_32_d_ai(void);
void m68k_op_move_32_d_pi(void);
void m68k_op_move_32_d_pd(void);
void m68k_op_move_32_d_di(void);
void m68k_op_move_32_d_ix(void);
void m68k_op_move_32_d_aw(void);
void m68k_op_move_32_d_al(void);
void m68k_op_move_32_d_pcdi(void);
void m68k_op_move_32_d_pcix(void);
void m68k_op_move_32_d_i(void);
void m68k_op_move_32_ai_d(void);
void m68k_op_move_32_ai_a(void);
void m68k_op_move_32_ai_ai(void);
void m68k_op_move_32_ai_pi(void);
void m68k_op_move_32_ai_pd(void);
void m68k_op_move_32_ai_di(void);
void m68k_op_move_32_ai_ix(void);
void m68k_op_move_32_ai_aw(void);
void m68k_op_move_32_ai_al(void);
void m68k_op_move_32_ai_pcdi(void);
void m68k_op_move_32_ai_pcix(void);
void m68k_op_move_32_ai_i(void);
void m68k_op_move_32_pi_d(void);
void m68k_op_move_32_pi_a(void);
void m68k_op_move_32_pi_ai(void);
void m68k_op_move_32_pi_pi(void);
void m68k_op_move_32_pi_pd(void);
void m68k_op_move_32_pi_di(void);
void m68k_op_move_32_pi_ix(void);
void m68k_op_move_32_pi_aw(void);
void m68k_op_move_32_pi_al(void);
void m68k_op_move_32_pi_pcdi(void);
void m68k_op_move_32_pi_pcix(void);
void m68k_op_move_32_pi_i(void);
void m68k_op_move_32_pd_d(void);
void m68k_op_move_32_pd_a(void);
void m68k_op_move_32_pd_ai(void);
void m68k_op_move_32_pd_pi(void);
void m68k_op_move_32_pd_pd(void);
void m68k_op_move_32_pd_di(void);
void m68k_op_move_32_pd_ix(void);
void m68k_op_move_32_pd_aw(void);
void m68k_op_move_32_pd_al(void);
void m68k_op_move_32_pd_pcdi(void);
void m68k_op_move_32_pd_pcix(void);
void m68k_op_move_32_pd_i(void);
void m68k_op_move_32_di_d(void);
void m68k_op_move_32_di_a(void);
void m68k_op_move_32_di_ai(void);
void m68k_op_move_32_di_pi(void);
void m68k_op_move_32_di_pd(void);
void m68k_op_move_32_di_di(void);
void m68k_op_move_32_di_ix(void);
void m68k_op_move_32_di_aw(void);
void m68k_op_move_32_di_al(void);
void m68k_op_move_32_di_pcdi(void);
void m68k_op_move_32_di_pcix(void);
void m68k_op_move_32_di_i(void);
void m68k_op_move_32_ix_d(void);
void m68k_op_move_32_ix_a(void);
void m68k_op_move_32_ix_ai(void);
void m68k_op_move_32_ix_pi(void);
void m68k_op_move_32_ix_pd(void);
void m68k_op_move_32_ix_di(void);
void m68k_op_move_32_ix_ix(void);
void m68k_op_move_32_ix_aw(void);
void m68k_op_move_32_ix_al(void);
void m68k_op_move_32_ix_pcdi(void);
void m68k_op_move_32_ix_pcix(void);
void m68k_op_move_32_ix_i(void);
void m68k_op_move_32_aw_d(void);
void m68k_op_move_32_aw_a(void);
void m68k_op_move_32_aw_ai(void);
void m68k_op_move_32_aw_pi(void);
void m68k_op_move_32_aw_pd(void);
void m68k_op_move_32_aw_di(void);
void m68k_op_move_32_aw_ix(void);
void m68k_op_move_32_aw_aw(void);
void m68k_op_move_32_aw_al(void);
void m68k_op_move_32_aw_pcdi(void);
void m68k_op_move_32_aw_pcix(void);
void m68k_op_move_32_aw_i(void);
void m68k_op_move_32_al_d(void);
void m68k_op_move_32_al_a(void);
void m68k_op_move_32_al_ai(void);
void m68k_op_move_32_al_pi(void);
void m68k_op_move_32_al_pd(void);
void m68k_op_move_32_al_di(void);
void m68k_op_move_32_al_ix(void);
void m68k_op_move_32_al_aw(void);
void m68k_op_move_32_al_al(void);
void m68k_op_move_32_al_pcdi(void);
void m68k_op_move_32_al_pcix(void);
void m68k_op_move_32_al_i(void);
void m68k_op_movea_16_d(void);
void m68k_op_movea_16_a(void);
void m68k_op_movea_16_ai(void);
void m68k_op_movea_16_pi(void);
void m68k_op_movea_16_pd(void);
void m68k_op_movea_16_di(void);
void m68k_op_movea_16_ix(void);
void m68k_op_movea_16_aw(void);
void m68k_op_movea_16_al(void);
void m68k_op_movea_16_pcdi(void);
void m68k_op_movea_16_pcix(void);
void m68k_op_movea_16_i(void);
void m68k_op_movea_32_d(void);
void m68k_op_movea_32_a(void);
void m68k_op_movea_32_ai(void);
void m68k_op_movea_32_pi(void);
void m68k_op_movea_32_pd(void);
void m68k_op_movea_32_di(void);
void m68k_op_movea_32_ix(void);
void m68k_op_movea_32_aw(void);
void m68k_op_movea_32_al(void);
void m68k_op_movea_32_pcdi(void);
void m68k_op_movea_32_pcix(void);
void m68k_op_movea_32_i(void);
void m68k_op_move_16_frc_d(void);
void m68k_op_move_16_frc_ai(void);
void m68k_op_move_16_frc_pi(void);
void m68k_op_move_16_frc_pd(void);
void m68k_op_move_16_frc_di(void);
void m68k_op_move_16_frc_ix(void);
void m68k_op_move_16_frc_aw(void);
void m68k_op_move_16_frc_al(void);
void m68k_op_move_16_toc_d(void);
void m68k_op_move_16_toc_ai(void);
void m68k_op_move_16_toc_pi(void);
void m68k_op_move_16_toc_pd(void);
void m68k_op_move_16_toc_di(void);
void m68k_op_move_16_toc_ix(void);
void m68k_op_move_16_toc_aw(void);
void m68k_op_move_16_toc_al(void);
void m68k_op_move_16_toc_pcdi(void);
void m68k_op_move_16_toc_pcix(void);
void m68k_op_move_16_toc_i(void);
void m68k_op_move_16_frs_d(void);
void m68k_op_move_16_frs_ai(void);
void m68k_op_move_16_frs_pi(void);
void m68k_op_move_16_frs_pd(void);
void m68k_op_move_16_frs_di(void);
void m68k_op_move_16_frs_ix(void);
void m68k_op_move_16_frs_aw(void);
void m68k_op_move_16_frs_al(void);
void m68k_op_move_16_tos_d(void);
void m68k_op_move_16_tos_ai(void);
void m68k_op_move_16_tos_pi(void);
void m68k_op_move_16_tos_pd(void);
void m68k_op_move_16_tos_di(void);
void m68k_op_move_16_tos_ix(void);
void m68k_op_move_16_tos_aw(void);
void m68k_op_move_16_tos_al(void);
void m68k_op_move_16_tos_pcdi(void);
void m68k_op_move_16_tos_pcix(void);
void m68k_op_move_16_tos_i(void);
void m68k_op_move_32_fru(void);
void m68k_op_move_32_tou(void);
void m68k_op_movec_32_cr(void);
void m68k_op_movec_32_rc(void);
void m68k_op_movem_16_re_pd(void);
void m68k_op_movem_16_re_ai(void);
void m68k_op_movem_16_re_di(void);
void m68k_op_movem_16_re_ix(void);
void m68k_op_movem_16_re_aw(void);
void m68k_op_movem_16_re_al(void);
void m68k_op_movem_32_re_pd(void);
void m68k_op_movem_32_re_ai(void);
void m68k_op_movem_32_re_di(void);
void m68k_op_movem_32_re_ix(void);
void m68k_op_movem_32_re_aw(void);
void m68k_op_movem_32_re_al(void);
void m68k_op_movem_16_er_pi(void);
void m68k_op_movem_16_er_pcdi(void);
void m68k_op_movem_16_er_pcix(void);
void m68k_op_movem_16_er_ai(void);
void m68k_op_movem_16_er_di(void);
void m68k_op_movem_16_er_ix(void);
void m68k_op_movem_16_er_aw(void);
void m68k_op_movem_16_er_al(void);
void m68k_op_movem_32_er_pi(void);
void m68k_op_movem_32_er_pcdi(void);
void m68k_op_movem_32_er_pcix(void);
void m68k_op_movem_32_er_ai(void);
void m68k_op_movem_32_er_di(void);
void m68k_op_movem_32_er_ix(void);
void m68k_op_movem_32_er_aw(void);
void m68k_op_movem_32_er_al(void);
void m68k_op_movep_16_re(void);
void m68k_op_movep_32_re(void);
void m68k_op_movep_16_er(void);
void m68k_op_movep_32_er(void);
void m68k_op_moves_8_ai(void);
void m68k_op_moves_8_pi(void);
void m68k_op_moves_8_pi7(void);
void m68k_op_moves_8_pd(void);
void m68k_op_moves_8_pd7(void);
void m68k_op_moves_8_di(void);
void m68k_op_moves_8_ix(void);
void m68k_op_moves_8_aw(void);
void m68k_op_moves_8_al(void);
void m68k_op_moves_16_ai(void);
void m68k_op_moves_16_pi(void);
void m68k_op_moves_16_pd(void);
void m68k_op_moves_16_di(void);
void m68k_op_moves_16_ix(void);
void m68k_op_moves_16_aw(void);
void m68k_op_moves_16_al(void);
void m68k_op_moves_32_ai(void);
void m68k_op_moves_32_pi(void);
void m68k_op_moves_32_pd(void);
void m68k_op_moves_32_di(void);
void m68k_op_moves_32_ix(void);
void m68k_op_moves_32_aw(void);
void m68k_op_moves_32_al(void);
void m68k_op_moveq_32(void);
void m68k_op_muls_16_d(void);
void m68k_op_muls_16_ai(void);
void m68k_op_muls_16_pi(void);
void m68k_op_muls_16_pd(void);
void m68k_op_muls_16_di(void);
void m68k_op_muls_16_ix(void);
void m68k_op_muls_16_aw(void);
void m68k_op_muls_16_al(void);
void m68k_op_muls_16_pcdi(void);
void m68k_op_muls_16_pcix(void);
void m68k_op_muls_16_i(void);
void m68k_op_mulu_16_d(void);
void m68k_op_mulu_16_ai(void);
void m68k_op_mulu_16_pi(void);
void m68k_op_mulu_16_pd(void);
void m68k_op_mulu_16_di(void);
void m68k_op_mulu_16_ix(void);
void m68k_op_mulu_16_aw(void);
void m68k_op_mulu_16_al(void);
void m68k_op_mulu_16_pcdi(void);
void m68k_op_mulu_16_pcix(void);
void m68k_op_mulu_16_i(void);
void m68k_op_mull_32_d(void);
void m68k_op_mull_32_ai(void);
void m68k_op_mull_32_pi(void);
void m68k_op_mull_32_pd(void);
void m68k_op_mull_32_di(void);
void m68k_op_mull_32_ix(void);
void m68k_op_mull_32_aw(void);
void m68k_op_mull_32_al(void);
void m68k_op_mull_32_pcdi(void);
void m68k_op_mull_32_pcix(void);
void m68k_op_mull_32_i(void);
void m68k_op_nbcd_8_d(void);
void m68k_op_nbcd_8_ai(void);
void m68k_op_nbcd_8_pi(void);
void m68k_op_nbcd_8_pi7(void);
void m68k_op_nbcd_8_pd(void);
void m68k_op_nbcd_8_pd7(void);
void m68k_op_nbcd_8_di(void);
void m68k_op_nbcd_8_ix(void);
void m68k_op_nbcd_8_aw(void);
void m68k_op_nbcd_8_al(void);
void m68k_op_neg_8_d(void);
void m68k_op_neg_8_ai(void);
void m68k_op_neg_8_pi(void);
void m68k_op_neg_8_pi7(void);
void m68k_op_neg_8_pd(void);
void m68k_op_neg_8_pd7(void);
void m68k_op_neg_8_di(void);
void m68k_op_neg_8_ix(void);
void m68k_op_neg_8_aw(void);
void m68k_op_neg_8_al(void);
void m68k_op_neg_16_d(void);
void m68k_op_neg_16_ai(void);
void m68k_op_neg_16_pi(void);
void m68k_op_neg_16_pd(void);
void m68k_op_neg_16_di(void);
void m68k_op_neg_16_ix(void);
void m68k_op_neg_16_aw(void);
void m68k_op_neg_16_al(void);
void m68k_op_neg_32_d(void);
void m68k_op_neg_32_ai(void);
void m68k_op_neg_32_pi(void);
void m68k_op_neg_32_pd(void);
void m68k_op_neg_32_di(void);
void m68k_op_neg_32_ix(void);
void m68k_op_neg_32_aw(void);
void m68k_op_neg_32_al(void);
void m68k_op_negx_8_d(void);
void m68k_op_negx_8_ai(void);
void m68k_op_negx_8_pi(void);
void m68k_op_negx_8_pi7(void);
void m68k_op_negx_8_pd(void);
void m68k_op_negx_8_pd7(void);
void m68k_op_negx_8_di(void);
void m68k_op_negx_8_ix(void);
void m68k_op_negx_8_aw(void);
void m68k_op_negx_8_al(void);
void m68k_op_negx_16_d(void);
void m68k_op_negx_16_ai(void);
void m68k_op_negx_16_pi(void);
void m68k_op_negx_16_pd(void);
void m68k_op_negx_16_di(void);
void m68k_op_negx_16_ix(void);
void m68k_op_negx_16_aw(void);
void m68k_op_negx_16_al(void);
void m68k_op_negx_32_d(void);
void m68k_op_negx_32_ai(void);
void m68k_op_negx_32_pi(void);
void m68k_op_negx_32_pd(void);
void m68k_op_negx_32_di(void);
void m68k_op_negx_32_ix(void);
void m68k_op_negx_32_aw(void);
void m68k_op_negx_32_al(void);
void m68k_op_nop(void);
void m68k_op_not_8_d(void);
void m68k_op_not_8_ai(void);
void m68k_op_not_8_pi(void);
void m68k_op_not_8_pi7(void);
void m68k_op_not_8_pd(void);
void m68k_op_not_8_pd7(void);
void m68k_op_not_8_di(void);
void m68k_op_not_8_ix(void);
void m68k_op_not_8_aw(void);
void m68k_op_not_8_al(void);
void m68k_op_not_16_d(void);
void m68k_op_not_16_ai(void);
void m68k_op_not_16_pi(void);
void m68k_op_not_16_pd(void);
void m68k_op_not_16_di(void);
void m68k_op_not_16_ix(void);
void m68k_op_not_16_aw(void);
void m68k_op_not_16_al(void);
void m68k_op_not_32_d(void);
void m68k_op_not_32_ai(void);
void m68k_op_not_32_pi(void);
void m68k_op_not_32_pd(void);
void m68k_op_not_32_di(void);
void m68k_op_not_32_ix(void);
void m68k_op_not_32_aw(void);
void m68k_op_not_32_al(void);
void m68k_op_or_8_er_d(void);
void m68k_op_or_8_er_ai(void);
void m68k_op_or_8_er_pi(void);
void m68k_op_or_8_er_pi7(void);
void m68k_op_or_8_er_pd(void);
void m68k_op_or_8_er_pd7(void);
void m68k_op_or_8_er_di(void);
void m68k_op_or_8_er_ix(void);
void m68k_op_or_8_er_aw(void);
void m68k_op_or_8_er_al(void);
void m68k_op_or_8_er_pcdi(void);
void m68k_op_or_8_er_pcix(void);
void m68k_op_or_8_er_i(void);
void m68k_op_or_16_er_d(void);
void m68k_op_or_16_er_ai(void);
void m68k_op_or_16_er_pi(void);
void m68k_op_or_16_er_pd(void);
void m68k_op_or_16_er_di(void);
void m68k_op_or_16_er_ix(void);
void m68k_op_or_16_er_aw(void);
void m68k_op_or_16_er_al(void);
void m68k_op_or_16_er_pcdi(void);
void m68k_op_or_16_er_pcix(void);
void m68k_op_or_16_er_i(void);
void m68k_op_or_32_er_d(void);
void m68k_op_or_32_er_ai(void);
void m68k_op_or_32_er_pi(void);
void m68k_op_or_32_er_pd(void);
void m68k_op_or_32_er_di(void);
void m68k_op_or_32_er_ix(void);
void m68k_op_or_32_er_aw(void);
void m68k_op_or_32_er_al(void);
void m68k_op_or_32_er_pcdi(void);
void m68k_op_or_32_er_pcix(void);
void m68k_op_or_32_er_i(void);
void m68k_op_or_8_re_ai(void);
void m68k_op_or_8_re_pi(void);
void m68k_op_or_8_re_pi7(void);
void m68k_op_or_8_re_pd(void);
void m68k_op_or_8_re_pd7(void);
void m68k_op_or_8_re_di(void);
void m68k_op_or_8_re_ix(void);
void m68k_op_or_8_re_aw(void);
void m68k_op_or_8_re_al(void);
void m68k_op_or_16_re_ai(void);
void m68k_op_or_16_re_pi(void);
void m68k_op_or_16_re_pd(void);
void m68k_op_or_16_re_di(void);
void m68k_op_or_16_re_ix(void);
void m68k_op_or_16_re_aw(void);
void m68k_op_or_16_re_al(void);
void m68k_op_or_32_re_ai(void);
void m68k_op_or_32_re_pi(void);
void m68k_op_or_32_re_pd(void);
void m68k_op_or_32_re_di(void);
void m68k_op_or_32_re_ix(void);
void m68k_op_or_32_re_aw(void);
void m68k_op_or_32_re_al(void);
void m68k_op_ori_8_d(void);
void m68k_op_ori_8_ai(void);
void m68k_op_ori_8_pi(void);
void m68k_op_ori_8_pi7(void);
void m68k_op_ori_8_pd(void);
void m68k_op_ori_8_pd7(void);
void m68k_op_ori_8_di(void);
void m68k_op_ori_8_ix(void);
void m68k_op_ori_8_aw(void);
void m68k_op_ori_8_al(void);
void m68k_op_ori_16_d(void);
void m68k_op_ori_16_ai(void);
void m68k_op_ori_16_pi(void);
void m68k_op_ori_16_pd(void);
void m68k_op_ori_16_di(void);
void m68k_op_ori_16_ix(void);
void m68k_op_ori_16_aw(void);
void m68k_op_ori_16_al(void);
void m68k_op_ori_32_d(void);
void m68k_op_ori_32_ai(void);
void m68k_op_ori_32_pi(void);
void m68k_op_ori_32_pd(void);
void m68k_op_ori_32_di(void);
void m68k_op_ori_32_ix(void);
void m68k_op_ori_32_aw(void);
void m68k_op_ori_32_al(void);
void m68k_op_ori_16_toc(void);
void m68k_op_ori_16_tos(void);
void m68k_op_pack_16_rr(void);
void m68k_op_pack_16_mm_ax7(void);
void m68k_op_pack_16_mm_ay7(void);
void m68k_op_pack_16_mm_axy7(void);
void m68k_op_pack_16_mm(void);
void m68k_op_pea_32_ai(void);
void m68k_op_pea_32_di(void);
void m68k_op_pea_32_ix(void);
void m68k_op_pea_32_aw(void);
void m68k_op_pea_32_al(void);
void m68k_op_pea_32_pcdi(void);
void m68k_op_pea_32_pcix(void);
void m68k_op_reset(void);
void m68k_op_ror_8_s(void);
void m68k_op_ror_16_s(void);
void m68k_op_ror_32_s(void);
void m68k_op_ror_8_r(void);
void m68k_op_ror_16_r(void);
void m68k_op_ror_32_r(void);
void m68k_op_ror_16_ai(void);
void m68k_op_ror_16_pi(void);
void m68k_op_ror_16_pd(void);
void m68k_op_ror_16_di(void);
void m68k_op_ror_16_ix(void);
void m68k_op_ror_16_aw(void);
void m68k_op_ror_16_al(void);
void m68k_op_rol_8_s(void);
void m68k_op_rol_16_s(void);
void m68k_op_rol_32_s(void);
void m68k_op_rol_8_r(void);
void m68k_op_rol_16_r(void);
void m68k_op_rol_32_r(void);
void m68k_op_rol_16_ai(void);
void m68k_op_rol_16_pi(void);
void m68k_op_rol_16_pd(void);
void m68k_op_rol_16_di(void);
void m68k_op_rol_16_ix(void);
void m68k_op_rol_16_aw(void);
void m68k_op_rol_16_al(void);
void m68k_op_roxr_8_s(void);
void m68k_op_roxr_16_s(void);
void m68k_op_roxr_32_s(void);
void m68k_op_roxr_8_r(void);
void m68k_op_roxr_16_r(void);
void m68k_op_roxr_32_r(void);
void m68k_op_roxr_16_ai(void);
void m68k_op_roxr_16_pi(void);
void m68k_op_roxr_16_pd(void);
void m68k_op_roxr_16_di(void);
void m68k_op_roxr_16_ix(void);
void m68k_op_roxr_16_aw(void);
void m68k_op_roxr_16_al(void);
void m68k_op_roxl_8_s(void);
void m68k_op_roxl_16_s(void);
void m68k_op_roxl_32_s(void);
void m68k_op_roxl_8_r(void);
void m68k_op_roxl_16_r(void);
void m68k_op_roxl_32_r(void);
void m68k_op_roxl_16_ai(void);
void m68k_op_roxl_16_pi(void);
void m68k_op_roxl_16_pd(void);
void m68k_op_roxl_16_di(void);
void m68k_op_roxl_16_ix(void);
void m68k_op_roxl_16_aw(void);
void m68k_op_roxl_16_al(void);
void m68k_op_rtd_32(void);
void m68k_op_rte_32(void);
void m68k_op_rtm_32(void);
void m68k_op_rtr_32(void);
void m68k_op_rts_32(void);
void m68k_op_sbcd_8_rr(void);
void m68k_op_sbcd_8_mm_ax7(void);
void m68k_op_sbcd_8_mm_ay7(void);
void m68k_op_sbcd_8_mm_axy7(void);
void m68k_op_sbcd_8_mm(void);
void m68k_op_st_8_d(void);
void m68k_op_st_8_ai(void);
void m68k_op_st_8_pi(void);
void m68k_op_st_8_pi7(void);
void m68k_op_st_8_pd(void);
void m68k_op_st_8_pd7(void);
void m68k_op_st_8_di(void);
void m68k_op_st_8_ix(void);
void m68k_op_st_8_aw(void);
void m68k_op_st_8_al(void);
void m68k_op_sf_8_d(void);
void m68k_op_sf_8_ai(void);
void m68k_op_sf_8_pi(void);
void m68k_op_sf_8_pi7(void);
void m68k_op_sf_8_pd(void);
void m68k_op_sf_8_pd7(void);
void m68k_op_sf_8_di(void);
void m68k_op_sf_8_ix(void);
void m68k_op_sf_8_aw(void);
void m68k_op_sf_8_al(void);
void m68k_op_shi_8_d(void);
void m68k_op_sls_8_d(void);
void m68k_op_scc_8_d(void);
void m68k_op_scs_8_d(void);
void m68k_op_sne_8_d(void);
void m68k_op_seq_8_d(void);
void m68k_op_svc_8_d(void);
void m68k_op_svs_8_d(void);
void m68k_op_spl_8_d(void);
void m68k_op_smi_8_d(void);
void m68k_op_sge_8_d(void);
void m68k_op_slt_8_d(void);
void m68k_op_sgt_8_d(void);
void m68k_op_sle_8_d(void);
void m68k_op_shi_8_ai(void);
void m68k_op_shi_8_pi(void);
void m68k_op_shi_8_pi7(void);
void m68k_op_shi_8_pd(void);
void m68k_op_shi_8_pd7(void);
void m68k_op_shi_8_di(void);
void m68k_op_shi_8_ix(void);
void m68k_op_shi_8_aw(void);
void m68k_op_shi_8_al(void);
void m68k_op_sls_8_ai(void);
void m68k_op_sls_8_pi(void);
void m68k_op_sls_8_pi7(void);
void m68k_op_sls_8_pd(void);
void m68k_op_sls_8_pd7(void);
void m68k_op_sls_8_di(void);
void m68k_op_sls_8_ix(void);
void m68k_op_sls_8_aw(void);
void m68k_op_sls_8_al(void);
void m68k_op_scc_8_ai(void);
void m68k_op_scc_8_pi(void);
void m68k_op_scc_8_pi7(void);
void m68k_op_scc_8_pd(void);
void m68k_op_scc_8_pd7(void);
void m68k_op_scc_8_di(void);
void m68k_op_scc_8_ix(void);
void m68k_op_scc_8_aw(void);
void m68k_op_scc_8_al(void);
void m68k_op_scs_8_ai(void);
void m68k_op_scs_8_pi(void);
void m68k_op_scs_8_pi7(void);
void m68k_op_scs_8_pd(void);
void m68k_op_scs_8_pd7(void);
void m68k_op_scs_8_di(void);
void m68k_op_scs_8_ix(void);
void m68k_op_scs_8_aw(void);
void m68k_op_scs_8_al(void);
void m68k_op_sne_8_ai(void);
void m68k_op_sne_8_pi(void);
void m68k_op_sne_8_pi7(void);
void m68k_op_sne_8_pd(void);
void m68k_op_sne_8_pd7(void);
void m68k_op_sne_8_di(void);
void m68k_op_sne_8_ix(void);
void m68k_op_sne_8_aw(void);
void m68k_op_sne_8_al(void);
void m68k_op_seq_8_ai(void);
void m68k_op_seq_8_pi(void);
void m68k_op_seq_8_pi7(void);
void m68k_op_seq_8_pd(void);
void m68k_op_seq_8_pd7(void);
void m68k_op_seq_8_di(void);
void m68k_op_seq_8_ix(void);
void m68k_op_seq_8_aw(void);
void m68k_op_seq_8_al(void);
void m68k_op_svc_8_ai(void);
void m68k_op_svc_8_pi(void);
void m68k_op_svc_8_pi7(void);
void m68k_op_svc_8_pd(void);
void m68k_op_svc_8_pd7(void);
void m68k_op_svc_8_di(void);
void m68k_op_svc_8_ix(void);
void m68k_op_svc_8_aw(void);
void m68k_op_svc_8_al(void);
void m68k_op_svs_8_ai(void);
void m68k_op_svs_8_pi(void);
void m68k_op_svs_8_pi7(void);
void m68k_op_svs_8_pd(void);
void m68k_op_svs_8_pd7(void);
void m68k_op_svs_8_di(void);
void m68k_op_svs_8_ix(void);
void m68k_op_svs_8_aw(void);
void m68k_op_svs_8_al(void);
void m68k_op_spl_8_ai(void);
void m68k_op_spl_8_pi(void);
void m68k_op_spl_8_pi7(void);
void m68k_op_spl_8_pd(void);
void m68k_op_spl_8_pd7(void);
void m68k_op_spl_8_di(void);
void m68k_op_spl_8_ix(void);
void m68k_op_spl_8_aw(void);
void m68k_op_spl_8_al(void);
void m68k_op_smi_8_ai(void);
void m68k_op_smi_8_pi(void);
void m68k_op_smi_8_pi7(void);
void m68k_op_smi_8_pd(void);
void m68k_op_smi_8_pd7(void);
void m68k_op_smi_8_di(void);
void m68k_op_smi_8_ix(void);
void m68k_op_smi_8_aw(void);
void m68k_op_smi_8_al(void);
void m68k_op_sge_8_ai(void);
void m68k_op_sge_8_pi(void);
void m68k_op_sge_8_pi7(void);
void m68k_op_sge_8_pd(void);
void m68k_op_sge_8_pd7(void);
void m68k_op_sge_8_di(void);
void m68k_op_sge_8_ix(void);
void m68k_op_sge_8_aw(void);
void m68k_op_sge_8_al(void);
void m68k_op_slt_8_ai(void);
void m68k_op_slt_8_pi(void);
void m68k_op_slt_8_pi7(void);
void m68k_op_slt_8_pd(void);
void m68k_op_slt_8_pd7(void);
void m68k_op_slt_8_di(void);
void m68k_op_slt_8_ix(void);
void m68k_op_slt_8_aw(void);
void m68k_op_slt_8_al(void);
void m68k_op_sgt_8_ai(void);
void m68k_op_sgt_8_pi(void);
void m68k_op_sgt_8_pi7(void);
void m68k_op_sgt_8_pd(void);
void m68k_op_sgt_8_pd7(void);
void m68k_op_sgt_8_di(void);
void m68k_op_sgt_8_ix(void);
void m68k_op_sgt_8_aw(void);
void m68k_op_sgt_8_al(void);
void m68k_op_sle_8_ai(void);
void m68k_op_sle_8_pi(void);
void m68k_op_sle_8_pi7(void);
void m68k_op_sle_8_pd(void);
void m68k_op_sle_8_pd7(void);
void m68k_op_sle_8_di(void);
void m68k_op_sle_8_ix(void);
void m68k_op_sle_8_aw(void);
void m68k_op_sle_8_al(void);
void m68k_op_stop(void);
void m68k_op_sub_8_er_d(void);
void m68k_op_sub_8_er_ai(void);
void m68k_op_sub_8_er_pi(void);
void m68k_op_sub_8_er_pi7(void);
void m68k_op_sub_8_er_pd(void);
void m68k_op_sub_8_er_pd7(void);
void m68k_op_sub_8_er_di(void);
void m68k_op_sub_8_er_ix(void);
void m68k_op_sub_8_er_aw(void);
void m68k_op_sub_8_er_al(void);
void m68k_op_sub_8_er_pcdi(void);
void m68k_op_sub_8_er_pcix(void);
void m68k_op_sub_8_er_i(void);
void m68k_op_sub_16_er_d(void);
void m68k_op_sub_16_er_a(void);
void m68k_op_sub_16_er_ai(void);
void m68k_op_sub_16_er_pi(void);
void m68k_op_sub_16_er_pd(void);
void m68k_op_sub_16_er_di(void);
void m68k_op_sub_16_er_ix(void);
void m68k_op_sub_16_er_aw(void);
void m68k_op_sub_16_er_al(void);
void m68k_op_sub_16_er_pcdi(void);
void m68k_op_sub_16_er_pcix(void);
void m68k_op_sub_16_er_i(void);
void m68k_op_sub_32_er_d(void);
void m68k_op_sub_32_er_a(void);
void m68k_op_sub_32_er_ai(void);
void m68k_op_sub_32_er_pi(void);
void m68k_op_sub_32_er_pd(void);
void m68k_op_sub_32_er_di(void);
void m68k_op_sub_32_er_ix(void);
void m68k_op_sub_32_er_aw(void);
void m68k_op_sub_32_er_al(void);
void m68k_op_sub_32_er_pcdi(void);
void m68k_op_sub_32_er_pcix(void);
void m68k_op_sub_32_er_i(void);
void m68k_op_sub_8_re_ai(void);
void m68k_op_sub_8_re_pi(void);
void m68k_op_sub_8_re_pi7(void);
void m68k_op_sub_8_re_pd(void);
void m68k_op_sub_8_re_pd7(void);
void m68k_op_sub_8_re_di(void);
void m68k_op_sub_8_re_ix(void);
void m68k_op_sub_8_re_aw(void);
void m68k_op_sub_8_re_al(void);
void m68k_op_sub_16_re_ai(void);
void m68k_op_sub_16_re_pi(void);
void m68k_op_sub_16_re_pd(void);
void m68k_op_sub_16_re_di(void);
void m68k_op_sub_16_re_ix(void);
void m68k_op_sub_16_re_aw(void);
void m68k_op_sub_16_re_al(void);
void m68k_op_sub_32_re_ai(void);
void m68k_op_sub_32_re_pi(void);
void m68k_op_sub_32_re_pd(void);
void m68k_op_sub_32_re_di(void);
void m68k_op_sub_32_re_ix(void);
void m68k_op_sub_32_re_aw(void);
void m68k_op_sub_32_re_al(void);
void m68k_op_suba_16_d(void);
void m68k_op_suba_16_a(void);
void m68k_op_suba_16_ai(void);
void m68k_op_suba_16_pi(void);
void m68k_op_suba_16_pd(void);
void m68k_op_suba_16_di(void);
void m68k_op_suba_16_ix(void);
void m68k_op_suba_16_aw(void);
void m68k_op_suba_16_al(void);
void m68k_op_suba_16_pcdi(void);
void m68k_op_suba_16_pcix(void);
void m68k_op_suba_16_i(void);
void m68k_op_suba_32_d(void);
void m68k_op_suba_32_a(void);
void m68k_op_suba_32_ai(void);
void m68k_op_suba_32_pi(void);
void m68k_op_suba_32_pd(void);
void m68k_op_suba_32_di(void);
void m68k_op_suba_32_ix(void);
void m68k_op_suba_32_aw(void);
void m68k_op_suba_32_al(void);
void m68k_op_suba_32_pcdi(void);
void m68k_op_suba_32_pcix(void);
void m68k_op_suba_32_i(void);
void m68k_op_subi_8_d(void);
void m68k_op_subi_8_ai(void);
void m68k_op_subi_8_pi(void);
void m68k_op_subi_8_pi7(void);
void m68k_op_subi_8_pd(void);
void m68k_op_subi_8_pd7(void);
void m68k_op_subi_8_di(void);
void m68k_op_subi_8_ix(void);
void m68k_op_subi_8_aw(void);
void m68k_op_subi_8_al(void);
void m68k_op_subi_16_d(void);
void m68k_op_subi_16_ai(void);
void m68k_op_subi_16_pi(void);
void m68k_op_subi_16_pd(void);
void m68k_op_subi_16_di(void);
void m68k_op_subi_16_ix(void);
void m68k_op_subi_16_aw(void);
void m68k_op_subi_16_al(void);
void m68k_op_subi_32_d(void);
void m68k_op_subi_32_ai(void);
void m68k_op_subi_32_pi(void);
void m68k_op_subi_32_pd(void);
void m68k_op_subi_32_di(void);
void m68k_op_subi_32_ix(void);
void m68k_op_subi_32_aw(void);
void m68k_op_subi_32_al(void);
void m68k_op_subq_8_d(void);
void m68k_op_subq_8_ai(void);
void m68k_op_subq_8_pi(void);
void m68k_op_subq_8_pi7(void);
void m68k_op_subq_8_pd(void);
void m68k_op_subq_8_pd7(void);
void m68k_op_subq_8_di(void);
void m68k_op_subq_8_ix(void);
void m68k_op_subq_8_aw(void);
void m68k_op_subq_8_al(void);
void m68k_op_subq_16_d(void);
void m68k_op_subq_16_a(void);
void m68k_op_subq_16_ai(void);
void m68k_op_subq_16_pi(void);
void m68k_op_subq_16_pd(void);
void m68k_op_subq_16_di(void);
void m68k_op_subq_16_ix(void);
void m68k_op_subq_16_aw(void);
void m68k_op_subq_16_al(void);
void m68k_op_subq_32_d(void);
void m68k_op_subq_32_a(void);
void m68k_op_subq_32_ai(void);
void m68k_op_subq_32_pi(void);
void m68k_op_subq_32_pd(void);
void m68k_op_subq_32_di(void);
void m68k_op_subq_32_ix(void);
void m68k_op_subq_32_aw(void);
void m68k_op_subq_32_al(void);
void m68k_op_subx_8_rr(void);
void m68k_op_subx_16_rr(void);
void m68k_op_subx_32_rr(void);
void m68k_op_subx_8_mm_ax7(void);
void m68k_op_subx_8_mm_ay7(void);
void m68k_op_subx_8_mm_axy7(void);
void m68k_op_subx_8_mm(void);
void m68k_op_subx_16_mm(void);
void m68k_op_subx_32_mm(void);
void m68k_op_swap_32(void);
void m68k_op_tas_8_d(void);
void m68k_op_tas_8_ai(void);
void m68k_op_tas_8_pi(void);
void m68k_op_tas_8_pi7(void);
void m68k_op_tas_8_pd(void);
void m68k_op_tas_8_pd7(void);
void m68k_op_tas_8_di(void);
void m68k_op_tas_8_ix(void);
void m68k_op_tas_8_aw(void);
void m68k_op_tas_8_al(void);
void m68k_op_trap(void);
void m68k_op_trapt(void);
void m68k_op_trapt_16(void);
void m68k_op_trapt_32(void);
void m68k_op_trapf(void);
void m68k_op_trapf_16(void);
void m68k_op_trapf_32(void);
void m68k_op_traphi(void);
void m68k_op_trapls(void);
void m68k_op_trapcc(void);
void m68k_op_trapcs(void);
void m68k_op_trapne(void);
void m68k_op_trapeq(void);
void m68k_op_trapvc(void);
void m68k_op_trapvs(void);
void m68k_op_trappl(void);
void m68k_op_trapmi(void);
void m68k_op_trapge(void);
void m68k_op_traplt(void);
void m68k_op_trapgt(void);
void m68k_op_traple(void);
void m68k_op_traphi_16(void);
void m68k_op_trapls_16(void);
void m68k_op_trapcc_16(void);
void m68k_op_trapcs_16(void);
void m68k_op_trapne_16(void);
void m68k_op_trapeq_16(void);
void m68k_op_trapvc_16(void);
void m68k_op_trapvs_16(void);
void m68k_op_trappl_16(void);
void m68k_op_trapmi_16(void);
void m68k_op_trapge_16(void);
void m68k_op_traplt_16(void);
void m68k_op_trapgt_16(void);
void m68k_op_traple_16(void);
void m68k_op_traphi_32(void);
void m68k_op_trapls_32(void);
void m68k_op_trapcc_32(void);
void m68k_op_trapcs_32(void);
void m68k_op_trapne_32(void);
void m68k_op_trapeq_32(void);
void m68k_op_trapvc_32(void);
void m68k_op_trapvs_32(void);
void m68k_op_trappl_32(void);
void m68k_op_trapmi_32(void);
void m68k_op_trapge_32(void);
void m68k_op_traplt_32(void);
void m68k_op_trapgt_32(void);
void m68k_op_traple_32(void);
void m68k_op_trapv(void);
void m68k_op_tst_8_d(void);
void m68k_op_tst_8_ai(void);
void m68k_op_tst_8_pi(void);
void m68k_op_tst_8_pi7(void);
void m68k_op_tst_8_pd(void);
void m68k_op_tst_8_pd7(void);
void m68k_op_tst_8_di(void);
void m68k_op_tst_8_ix(void);
void m68k_op_tst_8_aw(void);
void m68k_op_tst_8_al(void);
void m68k_op_tst_8_pcdi(void);
void m68k_op_tst_8_pcix(void);
void m68k_op_tst_8_i(void);
void m68k_op_tst_16_d(void);
void m68k_op_tst_16_a(void);
void m68k_op_tst_16_ai(void);
void m68k_op_tst_16_pi(void);
void m68k_op_tst_16_pd(void);
void m68k_op_tst_16_di(void);
void m68k_op_tst_16_ix(void);
void m68k_op_tst_16_aw(void);
void m68k_op_tst_16_al(void);
void m68k_op_tst_16_pcdi(void);
void m68k_op_tst_16_pcix(void);
void m68k_op_tst_16_i(void);
void m68k_op_tst_32_d(void);
void m68k_op_tst_32_a(void);
void m68k_op_tst_32_ai(void);
void m68k_op_tst_32_pi(void);
void m68k_op_tst_32_pd(void);
void m68k_op_tst_32_di(void);
void m68k_op_tst_32_ix(void);
void m68k_op_tst_32_aw(void);
void m68k_op_tst_32_al(void);
void m68k_op_tst_32_pcdi(void);
void m68k_op_tst_32_pcix(void);
void m68k_op_tst_32_i(void);
void m68k_op_unlk_32_a7(void);
void m68k_op_unlk_32(void);
void m68k_op_unpk_16_rr(void);
void m68k_op_unpk_16_mm_ax7(void);
void m68k_op_unpk_16_mm_ay7(void);
void m68k_op_unpk_16_mm_axy7(void);
void m68k_op_unpk_16_mm(void);
/* Build the opcode handler table */
void m68ki_build_opcode_table(void);

extern void (*m68ki_instruction_jump_table[0x10000])(void); /* opcode handler jump table */
extern unsigned char m68ki_cycles[][0x10000];


/* ======================================================================== */
/* ============================== END OF FILE ============================= */
/* ======================================================================== */

#endif /* M68KOPS__HEADER */


