//#include <SDL.h>
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <math.h>

#include "../neocd.h"
#include "video.h"


extern unsigned char	video_shrinky[17];
char	full_y_skip[16]={0,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1};

//-- Defines ----------------------------------------------------------------- 
#define LINE_BEGIN   mydword = *((int *)fspr) 
#define LINE_MID     mydword = *((int *)fspr+1) 
#define PIXEL_LAST   col = (mydword&0x0F); if (col) *bm = paldata[col] 
#define PIXEL_R      col = (mydword&0x0F); if (col) *bm = paldata[col]; bm-- 
#define PIXEL_F      col = (mydword&0x0F); if (col) *bm = paldata[col]; bm++ 
#define SHIFT7      mydword >>= 28 
#define SHIFT6      mydword >>= 24 
#define SHIFT5      mydword >>= 20 
#define SHIFT4      mydword >>= 16 
#define SHIFT3      mydword >>= 12 
#define SHIFT2      mydword >>= 8 
#define SHIFT1      mydword >>= 4 


//---------------------------------------------------------------------------- 
//       Without  flip           With Flip 
// 01: X0000000 00000000   00000000 0000000X 
// 02: X0000000 X0000000   0000000X 0000000X 
// 03: X0000X00 00X00000   00000X00 00X0000X 
// 04: X000X000 X000X000   000X000X 000X000X 
// 05: X00X00X0 0X00X000   000X00X0 0X00X00X 
// 06: X0X00X00 X0X00X00   00X00X0X 00X00X0X 
// 07: X0X0X0X0 0X0X0X00   00X0X0X0 0X0X0X0X 
// 08: X0X0X0X0 X0X0X0X0   0X0X0X0X 0X0X0X0X 
// 09: XX0X0X0X X0X0X0X0   0X0X0X0X X0X0X0XX 
// 10: XX0XX0X0 XX0XX0X0   0X0XX0XX 0X0XX0XX 
// 11: XXX0XX0X X0XX0XX0   0XX0XX0X X0XX0XXX 
// 12: XXX0XXX0 XXX0XXX0   0XXX0XXX 0XXX0XXX 
// 13: XXXXX0XX XX0XXXX0   0XXXX0XX XX0XXXXX 
// 14: XXXXXXX0 XXXXXXX0   0XXXXXXX 0XXXXXXX 
// 15: XXXXXXXX XXXXXXX0   0XXXXXXX XXXXXXXX 
// 16: XXXXXXXX XXXXXXXX   XXXXXXXX XXXXXXXX 

//---------------------------------------------------------------------------- 
void   video_draw_spr(unsigned int code, unsigned int color, int flipx, 
         int flipy, int sx, int sy, int zx, int zy) 
{
   int                  oy, ey, y, dy; 
   unsigned short         *bm; 
   int                  col; 
   int                  l; 
   int                  mydword; 
   unsigned char         *fspr = 0; 
   char               *l_y_skip; 
   const unsigned short   *paldata; 
   
   

   if (sx <= -8) 
      return; 


      if(zy == 16) 
       l_y_skip = full_y_skip; 
   else 
       l_y_skip = video_shrinky; 

   fspr = neogeo_spr_memory; 

   // Mish/AJP - Most clipping is done in main loop 
   oy = sy; 
     ey = sy + zy -1;    // Clip for size of zoomed object 

   if (sy < 0) 
      sy = 0; 
   if (ey >= 224) 
      ey = 223; 

   if (flipy)   // Y flip 
   { 
      dy = -8; 
   //   fspr += (code+1)*128 - 8 - (sy-oy)*8; orgin code from pc source base 
         fspr += ((code+1)<<7) - 8 - ((sy-oy)<<3); // Shift Sh4 saves 1 to 2 cycles maybe? 
   } 
   else      // normal 
   { 
      dy = 8; 
   //   fspr += code*128 + (sy-oy)*8; //orgin code from pc source base 
         fspr += ((code)<<7) + ((sy-oy)<<3); 
   } 

   paldata = &video_paletteram_pc[color*16]; 
    
   if (flipx)   // X flip 
   { 
      l=0; 
          switch(zx) { 
      case   0: 
         for (y = sy;y <= ey;y++) 
         { 
            fspr += l_y_skip[l]*dy; 
            bm  = (video_line_ptr[y]) + sx; 
            LINE_MID; 
            SHIFT7; 
            PIXEL_LAST; 
            l++; 
         } 
         break; 
      case   1: 
         for (y = sy;y <= ey;y++) 
         { 
            fspr += l_y_skip[l]*dy; 
            bm  = (video_line_ptr[y]) + sx + 1; 
            LINE_BEGIN; 
            SHIFT7; 
            PIXEL_R; 
            LINE_MID; 
            SHIFT7; 
            PIXEL_LAST; 
            l++; 
         } 
         break; 
      case   2: 
         for (y = sy;y <= ey;y++) 
         { 
            fspr += l_y_skip[l]*dy; 
            bm  = (video_line_ptr[y]) + sx + 2; 
            LINE_BEGIN; 
            SHIFT5; 
            PIXEL_R; 
            LINE_MID; 
            SHIFT2; 
            PIXEL_R; 
            SHIFT5; 
            PIXEL_LAST; 
            l++; 
         } 
         break; 
      case   3: 
         for (y = sy;y <= ey;y++) 
         { 
            fspr += l_y_skip[l]*dy; 
            bm  = (video_line_ptr[y]) + sx + 3; 
            LINE_BEGIN; 
            SHIFT3; 
            PIXEL_R; 
            SHIFT4; 
            PIXEL_R; 
            LINE_MID; 
            SHIFT3; 
            PIXEL_R; 
            SHIFT4; 
            PIXEL_LAST; 
            l++; 
         } 
         break; 
      case   4: 
         for (y = sy;y <= ey;y++) 
         { 
            fspr += l_y_skip[l]*dy; 
            bm  = (video_line_ptr[y]) + sx + 4; 
            LINE_BEGIN; 
            SHIFT3; 
            PIXEL_R; 
            SHIFT3; 
            PIXEL_R; 
            LINE_MID; 
            SHIFT1; 
            PIXEL_R; 
            SHIFT3; 
            PIXEL_R; 
            SHIFT3; 
            PIXEL_LAST; 
            l++; 
         } 
         break; 
      case   5: 
         for (y = sy;y <= ey;y++) 
         { 
            fspr += l_y_skip[l]*dy; 
            bm  = (video_line_ptr[y]) + sx + 5; 
            LINE_BEGIN; 
            SHIFT2; 
            PIXEL_R; 
            SHIFT3; 
            PIXEL_R; 
            SHIFT2; 
            PIXEL_R; 
            LINE_MID; 
            SHIFT2; 
            PIXEL_R; 
            SHIFT3; 
            PIXEL_R; 
            SHIFT2; 
            PIXEL_LAST; 
            l++; 
         } 
         break;        
      case   6: 
         for (y = sy;y <= ey;y++) 
         { 
            fspr += l_y_skip[l]*dy; 
            bm  = (video_line_ptr[y]) + sx + 6; 
            LINE_BEGIN; 
            SHIFT2; 
            PIXEL_R; 
            SHIFT2; 
            PIXEL_R; 
            SHIFT2; 
            PIXEL_R; 
            LINE_MID; 
            SHIFT1; 
            PIXEL_R; 
            SHIFT2; 
            PIXEL_R; 
            SHIFT2; 
            PIXEL_R; 
            SHIFT2; 
            PIXEL_LAST; 
            l++; 
         } 
         break; 
      case   7: 
         for (y = sy;y <= ey;y++) 
         { 
            fspr += l_y_skip[l]*dy; 
            bm  = (video_line_ptr[y]) + sx + 7; 
            LINE_BEGIN; 
            SHIFT1; 
            PIXEL_R; 
            SHIFT2; 
            PIXEL_R; 
            SHIFT2; 
            PIXEL_R; 
            SHIFT2; 
            PIXEL_R; 
            LINE_MID; 
            SHIFT1; 
            PIXEL_R; 
            SHIFT2; 
            PIXEL_R; 
            SHIFT2; 
            PIXEL_R; 
            SHIFT2; 
            PIXEL_LAST; 
            l++; 
         } 
         break;        
      case   8: 
         for (y = sy;y <= ey;y++) 
         { 
            fspr += l_y_skip[l]*dy; 
            bm  = (video_line_ptr[y]) + sx + 8; 
            LINE_BEGIN; 
            SHIFT1; 
            PIXEL_R; 
            SHIFT2; 
            PIXEL_R; 
            SHIFT2; 
            PIXEL_R; 
            SHIFT2; 
            PIXEL_R; 
            LINE_MID; 
            PIXEL_R; 
            SHIFT2; 
            PIXEL_R; 
            SHIFT2; 
            PIXEL_R; 
            SHIFT2; 
            PIXEL_R; 
            SHIFT1; 
            PIXEL_LAST; 
            l++; 
         } 
         break; 
      case   9: 
         for (y = sy;y <= ey;y++) 
         { 
            fspr += l_y_skip[l]*dy; 
            bm  = (video_line_ptr[y]) + sx + 9; 
            LINE_BEGIN; 
            SHIFT1; 
            PIXEL_R; 
            SHIFT2; 
            PIXEL_R; 
            SHIFT1; 
            PIXEL_R; 
            SHIFT2; 
            PIXEL_R; 
            SHIFT1; 
            PIXEL_R; 
            LINE_MID; 
            SHIFT1; 
            PIXEL_R; 
            SHIFT2; 
            PIXEL_R; 
            SHIFT1; 
            PIXEL_R; 
            SHIFT2; 
            PIXEL_R; 
            SHIFT1; 
            PIXEL_LAST; 
            l++; 
         } 
         break;        
      case   10: 
         for (y = sy;y <= ey;y++) 
         { 
            fspr += l_y_skip[l]*dy; 
            bm  = (video_line_ptr[y]) + sx + 10; 
            LINE_BEGIN; 
            SHIFT1; 
            PIXEL_R; 
            SHIFT1; 
            PIXEL_R; 
            SHIFT2; 
            PIXEL_R; 
            SHIFT1; 
            PIXEL_R; 
            SHIFT2; 
            PIXEL_R; 
            LINE_MID; 
            PIXEL_R; 
            SHIFT2; 
            PIXEL_R; 
            SHIFT1; 
            PIXEL_R; 
            SHIFT2; 
            PIXEL_R; 
            SHIFT1; 
            PIXEL_R; 
            SHIFT1; 
            PIXEL_LAST; 
            l++; 
         } 
         break;        
      case   11: 
         for (y = sy;y <= ey;y++) 
         { 
            fspr += l_y_skip[l]*dy; 
            bm  = (video_line_ptr[y]) + sx + 11; 
            LINE_BEGIN; 
            SHIFT1; 
            PIXEL_R; 
            SHIFT1; 
            PIXEL_R; 
            SHIFT1; 
            PIXEL_R; 
            SHIFT2;    
            PIXEL_R; 
            SHIFT1; 
            PIXEL_R; 
            SHIFT1; 
            PIXEL_R; 
            LINE_MID; 
            SHIFT1; 
            PIXEL_R; 
            SHIFT1; 
            PIXEL_R; 
            SHIFT1; 
            PIXEL_R; 
            SHIFT2;    
            PIXEL_R; 
            SHIFT1; 
            PIXEL_R; 
            SHIFT1; 
            PIXEL_LAST; 
            l++; 
         } 
         break;        
      case   12: 
         for (y = sy;y <= ey;y++) 
         { 
            fspr += l_y_skip[l]*dy; 
            bm  = (video_line_ptr[y]) + sx + 12; 
            LINE_BEGIN; 
            SHIFT1; 
            PIXEL_R; 
            SHIFT1; 
            PIXEL_R; 
            SHIFT1; 
            PIXEL_R; 
            SHIFT1; 
            PIXEL_R; 
            SHIFT2; 
            PIXEL_R; 
            SHIFT1; 
            PIXEL_R; 
            LINE_MID; 
            PIXEL_R; 
            SHIFT1; 
            PIXEL_R; 
            SHIFT2; 
            PIXEL_R; 
            SHIFT1; 
            PIXEL_R; 
            SHIFT1; 
            PIXEL_R; 
            SHIFT1; 
            PIXEL_R; 
            SHIFT1; 
            PIXEL_LAST; 
            l++; 
         } 
         break;        
      case   13: 
         for (y = sy;y <= ey;y++) 
         { 
            fspr += l_y_skip[l]*dy; 
            bm  = (video_line_ptr[y]) + sx + 13; 
            LINE_BEGIN; 
            SHIFT1; 
            PIXEL_R; 
            SHIFT1; 
            PIXEL_R; 
            SHIFT1; 
            PIXEL_R; 
            SHIFT1; 
            PIXEL_R; 
            SHIFT1; 
            PIXEL_R; 
            SHIFT1; 
            PIXEL_R; 
            SHIFT1; 
            PIXEL_R; 
            LINE_MID; 
            SHIFT1; 
            PIXEL_R; 
            SHIFT1; 
            PIXEL_R; 
            SHIFT1; 
            PIXEL_R; 
            SHIFT1; 
            PIXEL_R; 
            SHIFT1; 
            PIXEL_R; 
            SHIFT1; 
            PIXEL_R; 
            SHIFT1; 
            PIXEL_LAST; 
            l++; 
         } 
         break;        
      case   14: 
         for (y = sy;y <= ey;y++) 
         { 
            fspr += l_y_skip[l]*dy; 
            bm  = (video_line_ptr[y]) + sx + 14; 
            LINE_BEGIN; 
            SHIFT1; 
            PIXEL_R; 
            SHIFT1; 
            PIXEL_R; 
            SHIFT1; 
            PIXEL_R; 
            SHIFT1; 
            PIXEL_R; 
            SHIFT1; 
            PIXEL_R; 
            SHIFT1; 
            PIXEL_R; 
            SHIFT1; 
            PIXEL_R; 
            LINE_MID; 
            PIXEL_R; 
            SHIFT1; 
            PIXEL_R; 
            SHIFT1; 
            PIXEL_R; 
            SHIFT1; 
            PIXEL_R; 
            SHIFT1; 
            PIXEL_R; 
            SHIFT1; 
            PIXEL_R; 
            SHIFT1; 
            PIXEL_R; 
            SHIFT1; 
            PIXEL_LAST; 
            l++; 
         } 
         break; 
      case   15: 
         for (y = sy;y <= ey;y++) 
         { 
            fspr += l_y_skip[l]*dy; 
            bm  = (video_line_ptr[y]) + sx + 15; 
            LINE_BEGIN; 
            PIXEL_R; 
            SHIFT1; 
            PIXEL_R; 
            SHIFT1; 
            PIXEL_R; 
            SHIFT1; 
            PIXEL_R; 
            SHIFT1; 
            PIXEL_R; 
            SHIFT1; 
            PIXEL_R; 
            SHIFT1; 
            PIXEL_R; 
            SHIFT1; 
            PIXEL_R; 
            LINE_MID; 
            PIXEL_R; 
            SHIFT1; 
            PIXEL_R; 
            SHIFT1; 
            PIXEL_R; 
            SHIFT1; 
            PIXEL_R; 
            SHIFT1; 
            PIXEL_R; 
            SHIFT1; 
            PIXEL_R; 
            SHIFT1; 
            PIXEL_R; 
            SHIFT1; 
            PIXEL_LAST; 
            l++; 
         } 
         break;        
      } 
   } 
   else      // normal 
   { 
      l=0; 
          switch(zx) { 
      case   0: 
         for (y = sy ;y <= ey;y++) 
         { 
            fspr+=l_y_skip[l]*dy; 
            bm  = (video_line_ptr[y]) + sx; 
            LINE_BEGIN; 
            PIXEL_LAST; 
            l++; 
         } 
         break; 
      case   1: 
         for (y = sy ;y <= ey;y++) 
         { 
            fspr+=l_y_skip[l]*dy; 
            bm  = (video_line_ptr[y]) + sx; 
            LINE_BEGIN; 
            PIXEL_F; 
            LINE_MID; 
            PIXEL_LAST; 
            l++; 
         } 
         break; 
      case   2: 
         for (y = sy ;y <= ey;y++) 
         { 
            fspr+=l_y_skip[l]*dy; 
            bm  = (video_line_ptr[y]) + sx; 
            LINE_BEGIN; 
            PIXEL_F; 
            SHIFT5; 
            PIXEL_F; 
            LINE_MID; 
            SHIFT2; 
            PIXEL_LAST; 
            l++; 
         } 
         break; 
      case   3: 
         for (y = sy ;y <= ey;y++) 
         { 
            fspr+=l_y_skip[l]*dy; 
            bm  = (video_line_ptr[y]) + sx; 
            LINE_BEGIN; 
            PIXEL_F; 
            SHIFT4; 
            PIXEL_F; 
            LINE_MID; 
            PIXEL_F; 
            SHIFT4; 
            PIXEL_LAST; 
            l++; 
         } 
         break; 
      case   4: 
         for (y = sy ;y <= ey;y++) 
         { 
            fspr+=l_y_skip[l]*dy; 
            bm  = (video_line_ptr[y]) + sx; 
            LINE_BEGIN; 
            PIXEL_F; 
            SHIFT3; 
            PIXEL_F; 
            SHIFT3; 
            PIXEL_F; 
            LINE_MID; 
            SHIFT1; 
            PIXEL_F; 
            SHIFT3; 
            PIXEL_LAST; 
            l++; 
         } 
         break; 
      case   5: 
         for (y = sy ;y <= ey;y++) 
         { 
            fspr+=l_y_skip[l]*dy; 
            bm  = (video_line_ptr[y]) + sx; 
            LINE_BEGIN; 
            PIXEL_F; 
            SHIFT2; 
            PIXEL_F; 
            SHIFT3; 
            PIXEL_F; 
            LINE_MID; 
            PIXEL_F; 
            SHIFT2; 
            PIXEL_F; 
            SHIFT3; 
            PIXEL_LAST; 
            l++; 
         } 
         break; 
      case   6: 
         for (y = sy ;y <= ey;y++) 
         { 
            fspr+=l_y_skip[l]*dy; 
            bm  = (video_line_ptr[y]) + sx; 
            LINE_BEGIN; 
            PIXEL_F; 
            SHIFT2; 
            PIXEL_F; 
            SHIFT2; 
            PIXEL_F; 
            SHIFT2; 
            PIXEL_F; 
            LINE_MID; 
            SHIFT1; 
            PIXEL_F; 
            SHIFT2; 
            PIXEL_F; 
            SHIFT2; 
            PIXEL_LAST; 
            l++; 
         } 
         break; 
      case   7: 
         for (y = sy ;y <= ey;y++) 
         { 
            fspr+=l_y_skip[l]*dy; 
            bm  = (video_line_ptr[y]) + sx; 
            LINE_BEGIN; 
            PIXEL_F; 
            SHIFT2; 
            PIXEL_F; 
            SHIFT2; 
            PIXEL_F; 
            SHIFT2; 
            PIXEL_F; 
            LINE_MID; 
            PIXEL_F; 
            SHIFT2; 
            PIXEL_F; 
            SHIFT2; 
            PIXEL_F; 
            SHIFT2; 
            PIXEL_LAST; 
            l++; 
         } 
         break; 
      case   8: 
         for (y = sy ;y <= ey;y++) 
         { 
            fspr+=l_y_skip[l]*dy; 
            bm  = (video_line_ptr[y]) + sx; 
            LINE_BEGIN; 
            PIXEL_F; 
            SHIFT1; 
            PIXEL_F; 
            SHIFT2; 
            PIXEL_F; 
            SHIFT2; 
            PIXEL_F; 
            SHIFT2; 
            PIXEL_F; 
            LINE_MID; 
            PIXEL_F; 
            SHIFT2; 
            PIXEL_F; 
            SHIFT2; 
            PIXEL_F; 
            SHIFT2; 
            PIXEL_LAST; 
            l++; 
         } 
         break; 
      case   9: 
         for (y = sy ;y <= ey;y++) 
         { 
            fspr+=l_y_skip[l]*dy; 
            bm  = (video_line_ptr[y]) + sx; 
            LINE_BEGIN; 
            PIXEL_F; 
            SHIFT1; 
            PIXEL_F; 
            SHIFT2; 
            PIXEL_F; 
            SHIFT1; 
            PIXEL_F; 
            SHIFT2; 
            PIXEL_F; 
            LINE_MID; 
            PIXEL_F; 
            SHIFT1; 
            PIXEL_F; 
            SHIFT2; 
            PIXEL_F; 
            SHIFT1; 
            PIXEL_F; 
            SHIFT2; 
            PIXEL_LAST; 
            l++; 
         } 
         break; 
      case   10: 
         for (y = sy ;y <= ey;y++) 
         { 
            fspr+=l_y_skip[l]*dy; 
            bm  = (video_line_ptr[y]) + sx; 
            LINE_BEGIN; 
            PIXEL_F; 
            SHIFT1; 
            PIXEL_F; 
            SHIFT1; 
            PIXEL_F; 
            SHIFT2; 
            PIXEL_F; 
            SHIFT1; 
            PIXEL_F; 
            SHIFT2; 
            PIXEL_F; 
            LINE_MID; 
            PIXEL_F; 
            SHIFT2; 
            PIXEL_F; 
            SHIFT1; 
            PIXEL_F; 
            SHIFT2; 
            PIXEL_F; 
            SHIFT1; 
            PIXEL_LAST; 
            l++; 
         } 
         break; 
      case   11: 
         for (y = sy ;y <= ey;y++) 
         { 
            fspr+=l_y_skip[l]*dy; 
            bm  = (video_line_ptr[y]) + sx; 
            LINE_BEGIN; 
            PIXEL_F; 
            SHIFT1; 
            PIXEL_F; 
            SHIFT1; 
            PIXEL_F; 
            SHIFT2;    
            PIXEL_F; 
            SHIFT1; 
            PIXEL_F; 
            SHIFT1; 
            PIXEL_F; 
            LINE_MID; 
            PIXEL_F; 
            SHIFT1; 
            PIXEL_F; 
            SHIFT1; 
            PIXEL_F; 
            SHIFT2;    
            PIXEL_F; 
            SHIFT1; 
            PIXEL_F; 
            SHIFT1; 
            PIXEL_LAST; 
            l++; 
         } 
         break; 
      case   12: 
         for (y = sy ;y <= ey;y++) 
         { 
            fspr+=l_y_skip[l]*dy; 
            bm  = (video_line_ptr[y]) + sx; 
            LINE_BEGIN; 
            PIXEL_F; 
            SHIFT1; 
            PIXEL_F; 
            SHIFT1; 
            PIXEL_F; 
            SHIFT1; 
            PIXEL_F; 
            SHIFT1; 
            PIXEL_F; 
            SHIFT2; 
            PIXEL_F; 
            SHIFT1; 
            PIXEL_F; 
            LINE_MID; 
            PIXEL_F; 
            SHIFT1; 
            PIXEL_F; 
            SHIFT2; 
            PIXEL_F; 
            SHIFT1; 
            PIXEL_F; 
            SHIFT1; 
            PIXEL_F; 
            SHIFT1; 
            PIXEL_LAST; 
            l++; 
         } 
         break; 
      case   13: 
         for (y = sy ;y <= ey;y++) 
         { 
            fspr+=l_y_skip[l]*dy; 
            bm  = (video_line_ptr[y]) + sx; 
            LINE_BEGIN; 
            PIXEL_F; 
            SHIFT1; 
            PIXEL_F; 
            SHIFT1; 
            PIXEL_F; 
            SHIFT1; 
            PIXEL_F; 
            SHIFT1; 
            PIXEL_F; 
            SHIFT1; 
            PIXEL_F; 
            SHIFT1; 
            PIXEL_F; 
            LINE_MID; 
            PIXEL_F; 
            SHIFT1; 
            PIXEL_F; 
            SHIFT1; 
            PIXEL_F; 
            SHIFT1; 
            PIXEL_F; 
            SHIFT1; 
            PIXEL_F; 
            SHIFT1; 
            PIXEL_F; 
            SHIFT1; 
            PIXEL_LAST; 
            l++; 
         } 
         break; 
      case   14: 
         for (y = sy ;y <= ey;y++) 
         { 
            fspr+=l_y_skip[l]*dy; 
            bm  = (video_line_ptr[y]) + sx; 
            LINE_BEGIN; 
            PIXEL_F; 
            SHIFT1; 
            PIXEL_F; 
            SHIFT1; 
            PIXEL_F; 
            SHIFT1; 
            PIXEL_F; 
            SHIFT1; 
            PIXEL_F; 
            SHIFT1; 
            PIXEL_F; 
            SHIFT1; 
            PIXEL_F; 
            SHIFT1; 
            PIXEL_F; 
            LINE_MID; 
            PIXEL_F; 
            SHIFT1; 
            PIXEL_F; 
            SHIFT1; 
            PIXEL_F; 
            SHIFT1; 
            PIXEL_F; 
            SHIFT1; 
            PIXEL_F; 
            SHIFT1; 
            PIXEL_F; 
            SHIFT1; 
            PIXEL_LAST; 
            l++; 
         } 
         break; 
      case   15: 
         for (y = sy ;y <= ey;y++) 
         { 
            fspr+=l_y_skip[l]*dy; 
            bm  = (video_line_ptr[y]) + sx; 
            LINE_BEGIN; 
            PIXEL_F; 
            SHIFT1; 
            PIXEL_F; 
            SHIFT1; 
            PIXEL_F; 
            SHIFT1; 
            PIXEL_F; 
            SHIFT1; 
            PIXEL_F; 
            SHIFT1; 
            PIXEL_F; 
            SHIFT1; 
            PIXEL_F; 
            SHIFT1; 
            PIXEL_F; 
            LINE_MID; 
            PIXEL_F; 
            SHIFT1; 
            PIXEL_F; 
            SHIFT1; 
            PIXEL_F; 
            SHIFT1; 
            PIXEL_F; 
            SHIFT1; 
            PIXEL_F; 
            SHIFT1; 
            PIXEL_F; 
            SHIFT1; 
            PIXEL_F; 
            SHIFT1; 
            PIXEL_LAST; 
            l++; 
         } 
         break; 
      } 
   } 

} 
