	INCLUDE equates.h
	INCLUDE memory.h
	INCLUDE cart.h
	INCLUDE io.h
	INCLUDE z80.h
	INCLUDE z80mac.h
	INCLUDE sound.h

	EXPORT GFX_init
	EXPORT GFX_reset
	EXPORT debug_
	EXPORT AGBinput
	EXPORT EMUinput
	EXPORT paletteinit
	EXPORT PaletteTxAll
	EXPORT newframe
	EXPORT endframe
	EXPORT gfxstate
	EXPORT gammavalue
	EXPORT oambufferready
	EXPORT twitch
	EXPORT flicker
	EXPORT fpsenabled
	EXPORT FPSValue
	EXPORT vbldummy
	EXPORT vblankfptr
	EXPORT vblankinterrupt

	IMPORT RumbleInterrupt
	IMPORT StartRumbleComs

 AREA rom_code, CODE, READONLY

;----------------------------------------------------------------------------
GFX_init	;(called from main.c) only need to call once
;----------------------------------------------------------------------------
	mov addy,lr

	mov r1,#REG_BASE
	mov r0,#0x0008
	strh r0,[r1,#REG_DISPSTAT]	;vblank en


	add r0,r1,#REG_BG0HOFS		;DMA0 always goes here
	str r0,[r1,#REG_DM0DAD]
	ldr r0,=DMA0BUFF+8			;DMA0 src=
	str r0,[r1,#REG_DM0SAD]
	mov r0,#2					;1 word transfer
	strh r0,[r1,#REG_DM0CNT_L]

	add r2,r1,#REG_IE
	mov r0,#-1
	strh r0,[r2,#2]		;stop pending interrupts
	ldr r0,=irqhandler
	str r0,[r1,#-4]		;=AGB_IRQVECT
	ldr r0,=0x1081
	strh r0,[r2]		;key(0x1000),vblank(0x0001),timer1(0x0010) enable. (serial interrupt=0x0080)
	mov r0,#1
	strh r0,[r2,#8]		;master irq enable

	bx addy
;----------------------------------------------------------------------------
GFX_reset	;called with CPU reset
;----------------------------------------------------------------------------
	str lr,[sp,#-4]!

	mov r1,#0
	str r1,windowtop

	ldr r0,=gfxstate
	mov r2,#2				;2*4
	bl memset_				;clear GFX regs

	mov r0,#1
	strb r0,sprmemreload

	mov r0,#24
	strb r0,ystart

	mov r1,#REG_BASE
	ldr r0,=0x4006
	strh r0,[r1,#REG_BG0CNT]
	ldr r0,=0x428A
	strh r0,[r1,#REG_BG1CNT]


	mov r0,#AGB_OAM
	mov r1,#0x2a0
	mov r2,#0x100
	bl memset_		;no stray sprites please
	ldr r0,=OAM_BUFFER1
	mov r2,#0x180
	bl memset_
	bl BG_init

	bl paletteinit	;do palette mapping
	bl PaletteTxAll	;transfer it
	ldr pc,[sp],#4

;----------------------------------------------------------------------------
BG_init;	BG tiles
;----------------------------------------------------------------------------
	ldr r3,vrombase0			;r3 = bitplane 0
	mov r12,#AGB_VRAM			;r6=AGB BG tileset
	add r12,r12,#0x4000			;tile ram 1.5
	ldr r1,=0x0F0F0F0F
bgchr1
	ldr r0,[r3],#4				;read 3rd plane
	and r2,r1,r0,lsr#4
	and r0,r1,r0
	orr r0,r2,r0,lsl#4
	str r0,[r12],#4

	tst r12,#0x8000
	beq bgchr1

	ldr r1,=0x10101010
	mov r0,#0
bgchr3
	mov r2,#16
bgchr2
	str r0,[r12],#4
	subs r2,r2,#1
	bne bgchr2
	adds r0,r0,r1
	bcc bgchr3

	bx lr

;----------------------------------------------------------------------------
paletteinit;	r0-r3 modified.
;called by ui.c:  void map_palette(char gammavalue)
;----------------------------------------------------------------------------
	stmfd sp!,{r4-r9,lr}
	ldr r8,prombase		;proms
	mov r7,#0xE0
	ldr r6,=MAPPED_RGB
	ldrb r1,gammavalue	;gamma value = 0 -> 4
	mov r4,#32			;Green Beret bgr, r1=R, r2=G, r3=B
nomap					;map 00000000bbgggrrr  ->  0bbbbbgggggrrrrr
	ldrb r9,[r8],#1
	and r0,r9,#0xC0		;Blue ready
	bl gprefix
	mov r5,r0

	and r0,r7,r9,lsl#2	;Green ready
	bl gprefix
	orr r5,r0,r5,lsl#5

	and r0,r7,r9,lsl#5	;Red ready
	bl gprefix
	orr r5,r0,r5,lsl#5

	strh r5,[r6],#2
	subs r4,r4,#1
	bne nomap

	ldmfd sp!,{r4-r9,lr}
	bx lr

;----------------------------------------------------------------------------
gprefix
	orr r0,r0,r0,lsr#3
	orr r0,r0,r0,lsr#6
;----------------------------------------------------------------------------
gammaconvert;	takes value in r0(0-0xFF), gamma in r1(0-4),returns new value in r0=0x1F
;----------------------------------------------------------------------------
	rsb r2,r0,#0x100
	mul r3,r2,r2
	rsbs r2,r3,#0x10000
	rsb r3,r1,#4
	orr r0,r0,r0,lsl#8
	mul r2,r1,r2
	mla r0,r3,r0,r2
	mov r0,r0,lsr#13

	bx lr
;----------------------------------------------------------------------------
PaletteTxAll		; Called from ui.c
;----------------------------------------------------------------------------
	stmfd sp!,{r4-r5,r10}

	ldr globalptr,=|wram_globals0$$Base|	;need ptr regs init'd
	ldr r2,prombase		;proms
	add r2,r2,#32
	ldr r3,=MAPPED_RGB
	ldr r4,=PCEPALBUFF
	add r5,r4,#512
	mov r1,#256
nomap2
	ldrb r0,[r2],#1
	mov r0,r0,lsl#1
	ldrh r0,[r3,r0]
	strh r0,[r5],#2
	subs r1,r1,#1
	bne nomap2

	add r3,r3,#32
	mov r1,#256
nomap3
	ldrb r0,[r2],#1
	mov r0,r0,lsl#1
	ldrh r0,[r3,r0]
	strh r0,[r4],#2
	subs r1,r1,#1
	bne nomap3

	ldmfd sp!,{r4-r5,r10}
	bx lr
;----------------------------------------------------------------------------
showfps_		;fps output, r0-r3=used.
;----------------------------------------------------------------------------
	ldrb r0,fpschk
	subs r0,r0,#1
	movmi r0,#59
	strb r0,fpschk
	bxpl lr					;End if not 60 frames has passed

;	str lr,[sp,#-4]!
;	ldr r1,=StartRumbleComs
;	adr lr,ret_
;	bx r1
ret_
;	ldr lr,[sp],#4

	ldrb r0,fpsenabled
	tst r0,#1
	bxeq lr					;End if not enabled

	ldr r0,fpsvalue
	cmp r0,#0
	bxeq lr					;End if fps==0, to keep it from appearing in the menu
	mov r1,#0
	str r1,fpsvalue

	mov r1,#100
	swi 0x060000			;Division r0/r1, r0=result, r1=remainder.
	add r0,r0,#0x30
	strb r0,fpstext+5
	mov r0,r1
	mov r1,#10
	swi 0x060000			;Division r0/r1, r0=result, r1=remainder.
	add r0,r0,#0x30
	strb r0,fpstext+6
	add r1,r1,#0x30
	strb r1,fpstext+7
	

	adr r0,fpstext
	ldr r2,=DEBUGSCREEN
;	add r2,r2,r1,lsl#6
db1
	ldrb r1,[r0],#1
	orr r1,r1,#0x3100
	strh r1,[r2],#2
	tst r2,#0xE
	bne db1

	bx lr
;----------------------------------------------------------------------------
fpstext DCB "FPS:    "
fpsenabled DCB 0
fpschk	DCB 0
gammavalue DCB 0
		DCB 0
;----------------------------------------------------------------------------
debug_		;debug output, r0=val, r1=line, r2=used.
;----------------------------------------------------------------------------
 [ DEBUG
	ldr r2,=DEBUGSCREEN
	add r2,r2,r1,lsl#6
db0
	mov r0,r0,ror#28
	and r1,r0,#0x0f
	cmp r1,#9
	addhi r1,r1,#7
	add r1,r1,#0x30
	orr r1,r1,#0x4100
	strh r1,[r2],#2
	tst r2,#15
	bne db0
 ]
	bx lr
;----------------------------------------------------------------------------
	AREA wram_code2, CODE, READWRITE
irqhandler	;r0-r3,r12 are safe to use
;----------------------------------------------------------------------------
	mov r2,#REG_BASE
	mov r3,#REG_BASE
	ldr r1,[r2,#REG_IE]!
	and r1,r1,r1,lsr#16	;r1=IE&IF
	ldrh r0,[r3,#-8]
	orr r0,r0,r1
	strh r0,[r3,#-8]

		;---these CAN'T be interrupted
		ands r0,r1,#0x80
		strneh r0,[r2,#2]		;IF clear
		bne RumbleInterrupt
		;---

		;---these CAN be interrupted
		ands r0,r1,#0x01
		ldrne r12,vblankfptr
		bne jmpintr
		;----
		adreq r12,irq0
		moveq r0,r1		;if unknown interrupt occured clear it.
jmpintr
	strh r0,[r2,#2]		;IF clear

	mrs r3,spsr
	stmfd sp!,{r3,lr}
	mrs r3,cpsr
	bic r3,r3,#0x9f
	orr r3,r3,#0x1f			;--> Enable IRQ . Set CPU mode to System.
	msr cpsr_cf,r3
	stmfd sp!,{lr}
	adr lr,irq0

	mov pc,r12


irq0
	ldmfd sp!,{lr}
	mrs r3,cpsr
	bic r3,r3,#0x9f
	orr r3,r3,#0x92        		;--> Disable IRQ. Set CPU mode to IRQ
	msr cpsr_cf,r3
	ldmfd sp!,{r0,lr}
	msr spsr_cf,r0
vbldummy
	bx lr
;----------------------------------------------------------------------------
vblankfptr DCD vbldummy			;later switched to vblankinterrupt
twitch DCB 0
flicker DCB 1
		DCB 0
		DCB 0
vblankinterrupt;
;----------------------------------------------------------------------------
	stmfd sp!,{r4-r7,globalptr,lr}
	ldr globalptr,=|wram_globals0$$Base|

	bl Vbl_Sound_1
	bl showfps_

	ldr r2,=DMA0BUFF	;setup DMA buffer for scrolling:
	add r3,r2,#160*8
	ldr r1,=SCROLLBUFF
	ldrb r0,emuflags+1
	cmp r0,#SCALED
	bhs vblscaled

vblunscaled
	ldr r0,windowtop+12
	mov r6,r0
vbl6
	mov r5,r6,lsr#3
	add r6,r6,#1
	ldr r4,[r1,r5,lsl#2]
	orr r4,r4,r0,lsl#16
	str r4,[r2],#4
	str r4,[r2],#4
	cmp r2,r3
	bmi vbl6

	b vbl5

vblscaled					;(scaled)
	ldrb r0,ystart
	ldrb r5,flicker
	ldrb r4,twitch
	eors r4,r4,r5
	strb r4,twitch
	mov r6,r0
	mov r5,r6,lsr#3
	addeq r6,r6,#2
	ldreq r4,[r1,r5,lsl#2]
	addeq r4,r4,r0,lsl#16
	streq r4,[r2],#4
	streq r4,[r2],#4
		ldr r4,adjustblend
		ands r4,r4,#3
		beq vbl3
		cmp r4,#2
		bhi vbl2
vbl1
		addmi r0,r0,#1
		mov r5,r6,lsr#3
		add r6,r6,#1
		ldr r4,[r1,r5,lsl#2]
		add r4,r4,r0,lsl#16
		str r4,[r2],#4
		str r4,[r2],#4
vbl2
		mov r5,r6,lsr#3
		add r6,r6,#1
		ldr r4,[r1,r5,lsl#2]
		add r4,r4,r0,lsl#16
		str r4,[r2],#4
		str r4,[r2],#4
vbl3
		mov r5,r6,lsr#3
		add r6,r6,#2
		ldr r4,[r1,r5,lsl#2]
		add r4,r4,r0,lsl#16
		str r4,[r2],#4
		str r4,[r2],#4
	cmp r2,r3
	bmi vbl1

vbl5


	mov r1,#REG_BASE
	strh r1,[r1,#REG_DM0CNT_H]		;DMA0 stop
	strh r1,[r1,#REG_DM3CNT_H]		;DMA3 stop

	add r2,r1,#REG_DM3SAD

	ldr r0,oambufferready
	cmp r0,#0
	ldrne r4,dmaoambuffer			;DMA3 src, OAM transfer:
	movne r5,#AGB_OAM				;DMA3 dst
	movne r6,#0x84000000			;noIRQ 32bit incsrc incdst
	orrne r6,r6,#0xc0				;196 words (768 bytes)
	stmneia r2,{r4-r6}				;DMA3 go

	ldrne r4,=PCEPALBUFF			;DMA3 src, Palette transfer:
	movne r5,#AGB_PALETTE			;DMA3 dst
	movne r6,#0x84000000			;noIRQ 32bit incsrc incdst
	orrne r6,r6,#0x100				;256 words (1024 bytes)
	stmneia r2,{r4-r6}				;DMA3 go
	mov r0,#0
	str r0,oambufferready

	ldr r0,=DMA0BUFF				;setup HBLANK DMA for display scroll:
	ldr r4,[r0],#4
	str r4,[r1,#REG_BG0HOFS]		;set 1st value manually, HBL is AFTER 1st line
	ldr r4,[r0],#4
	str r4,[r1,#REG_BG1HOFS]		;set 1st value manually, HBL is AFTER 1st line
	ldr r0,=0xA660					;noIRQ hblank 32bit repeat incsrc inc_reloaddst
	strh r0,[r1,#REG_DM0CNT_H]		;DMA0 go

	mov r0,#0x1740					;1d sprites, BG0/1/2 enable. OBJ enable, DISPCNTBUFF startvalue. 0x1540
	strh r0,[r1,#REG_DISPCNT]		;set value manually

exit_vbl
	bl Vbl_Sound_2
	ldmfd sp!,{r4-r7,globalptr,pc}


;----------------------------------------------------------------------------
newframe	;called before line 0	(r0-r9 safe to use)
;----------------------------------------------------------------------------
	mov r0,#0
	str r0,scanline			;reset scanline count

;--------------------------
	bx lr

;----------------------------------------------------------------------------
endframe	;called just before screen end (~line 240)	(r0-r2 safe to use)
;----------------------------------------------------------------------------
	stmfd sp!,{r3-r9,lr}

	bl bg_finish
;--------------------------
	bl sprDMA_do
;--------------------------

	mrs r5,cpsr
	orr r1,r5,#0x80			;--> Disable IRQ.
	msr cpsr_cf,r1

	ldr r0,dmaoambuffer
	ldr r1,tmpoambuffer
	str r0,tmpoambuffer
	str r1,dmaoambuffer

	bl ScrollCopy

	mov r0,#1
	str r0,oambufferready

	adrl r0,windowtop		;load wtop, store in wtop+4.......load wtop+8, store in wtop+12
	ldmia r0,{r1-r3}		;load with post increment
	stmib r0,{r1-r3}		;store with pre increment

	msr cpsr_cf,r5			;--> restore mode,Enable IRQ.


	ldmfd sp!,{r3-r9,lr}
	bx lr
;----------------------------------------------------------------------------
ScrollCopy
;----------------------------------------------------------------------------
	ldr r2,=SCRL_RAM
	ldr r3,=SCROLLBUFF
	mov r4,#0x20
ScrolLoop
	ldrb r1,[r2,#0x20]
	ldrb r0,[r2],#1
	orr r0,r0,r1,lsl#8
	add r0,r0,#8
	str r0,[r3],#4
	subs r4,r4,#1
	bne ScrolLoop
	mov pc,lr
;----------------------------------------------------------------------------
sprDMA_do			;Called from endframe. YATX
;----------------------------------------------------------------------------
PRIORITY EQU 0x800		;0x800=AGB OBJ priority 2
	str lr,[sp,#-4]!


	ldr r9,=SPRTILELUT
	ldrb r0,sprmemreload
	tst r0,#0xff
	beq noreload
	mov r0,r9				;r0=destination
	mov r1,#0				;r1=value
	mov r2,#512				;512 tile entries
	bl memset_				;clear lut
	strb r1,sprmemreload	;clear spr mem reload.
	strb r1,sprmemalloc		;clear spr mem alloc.
noreload

	ldr addy,=EMU_RAM
	add addy,addy,#0x1100	;Source
	ldrb r0,sprBank
	and r0,r0,#0x08
	sub addy,addy,r0,lsl#5
	ldr r2,tmpoambuffer		;Destination

	ldr r1,emuflags
	and r5,r1,#0x300
	cmp r5,#SCALED_SPRITES*256
	mov r6,#0x40000000			;16x16 size
	orreq r6,r6,#0x100			;r6= scale obj

	mov r0,#0
	ldrb r4,ystart				;first scanline?
	cmp r5,#UNSCALED_AUTO*256	;do autoscroll
	bhi dm2
	movle r4,#0
	bne dm0
;	ldr r3,AGBjoypad
;	ands r3,r3,#0x300
;	eornes r3,r3,#0x300
;	bne dm0					;stop if L or R pressed (manual scroll)
	ldr r5,=EMU_RAM+0x1200
	ldrb r0,[r5,#5]		;follow sprite
	rsb r0,r0,#0x80
	adds r0,r0,r0,asr#3
	cmp r0,#16
	movmi r0,#16
	cmp r0,#80
	movpl r0,#80
	str r0,windowtop
dm0
	ldr r0,windowtop+8
dm2
	add r4,r4,r0
	ldr r5,=YSCALE_LOOKUP
	sub r5,r5,r4
	mov r8,#48				;number of sprites
	add addy,addy,r8,lsl#2	;Begin with the last sprite
dm11
	ldr r7,=0x1ff
	ldr r4,[addy,#-4]!	;GreenBeret OBJ, r4=Tile,Attrib,Xpos,Ypos.
	mov r0,r4,lsr#24	;mask Y
	cmp r0,#16
	bmi dm10			;skip if sprite Y<16
	movs r3,r4,lsr#16
	and r3,r3,#0xFF
	subcs r3,r3,#0x100	;Attrib bit7
	sub r3,r3,#8
	and r3,r3,r7		;mask X

	ldrb r0,[r5,r0]		;y = scaled y
	orr r0,r0,r6		;size + scaling
	orr r0,r0,r3,lsl#16

	and r1,r4,#0x3000	;X/Yflip
	orr r0,r0,r1,lsl#16
	str r0,[r2],#4		;store OBJ Atr 0,1. Xpos, ypos, flip, scale/rot, size, shape.

	and r1,r4,#0xFF
	and r0,r4,#0x4000
	orr r1,r1,r0,lsr#6
	bl VRAM_spr_16		;jump to spr copy, takes tile# in r1, gives new tile# in r0
ret01
	and r0,r0,#0xFF		;tile mask
	mov r0,r0,lsl#2
	and r1,r4,#0x0F00	;color
	orr r0,r0,r1,lsl#4
	orr r0,r0,#PRIORITY	;priority
	strh r0,[r2],#4		;store OBJ Atr 2. Pattern, prio & palette.
dm9
	subs r8,r8,#1
	bne dm11
	ldr pc,[sp],#4
dm10
	mov r0,#0x2a0		;double, y=160
	str r0,[r2],#8
	b dm9

;----------------------------------------------------------------------------
VRAM_spr_16;		takes tilenumber in r1, returns new tilenumber in r0
;----------------------------------------------------------------------------
	mov r7,#1
	ldr r0,[r9,r1,lsl#2]
	cmp r7,r0,lsr#16
	movle pc,lr			;allready cached
noluthit16
	bic r3,r1,#1
	ldrb r0,sprmemalloc
	orr r0,r0,#0x20000
	str r0,[r9,r3,lsl#2]
	add r3,r3,#1
	add r0,r0,#1
	str r0,[r9,r3,lsl#2]
	bic r0,r0,#1
	and r3,r1,#1
	add r0,r0,r3
	stmfd sp!,{r0-r6,lr}

	bic r1,r1,#1

	add r3,r0,#2		;allways alloc 2 tiles
	bic r3,r3,#1
	strb r3,sprmemalloc
	tst r3,#0x100
	movne r3,#0xab
	strneb r3,sprmemreload

;----------------------------------------------------------------------------
do16
	and r0,r0,#0xfe
	bic r1,r1,#0xfe00

	ldr r3,vrombase1			;r3 = bitplane 0
	add r3,r3,r1,lsl#7
	mov r6,#AGB_VRAM			;r6=AGB SPR tileset
	orr r6,r6,#0x10000			;spr ram
	add r6,r6,r0,lsl#7			;
	ldr r1,=0x0F0F0F0F

spr1
	ldr r0,[r3],#4				;read 3rd plane
	and r2,r1,r0,lsr#4
	and r0,r1,r0
	orr r0,r2,r0,lsl#4
	str r0,[r6],#4

	tst r6,#0xFC		;allways 2 16x16 tiles
	bne spr1

cachehit16
	ldmfd sp!,{r0-r6,pc}

;----------------------------------------------------------------------------

tmpoambuffer DCD OAM_BUFFER1
dmaoambuffer DCD OAM_BUFFER2

oambufferready DCD 0
pcepaletteready DCD 0
;----------------------------------------------------------------------------
	AREA wram_globals1, CODE, READWRITE

FPSValue
	DCD 0
AGBinput			;this label here for main.c to use
	DCD 0 			;AGBjoypad (why is this in gfx.s again?  um.. i forget)
EMUinput	DCD 0	;EMUjoypad (this is what PCE sees)
	DCD 1			;adjustblend
	DCD 0			;windowtop
wtop	DCD 0,0,0	;windowtop  (this label too)   L/R scrolling in unscaled mode
gfxstate
	DCB 0 ;irqControl
	DCB 0 ;irqPending
	DCB 0 ;ystart
	DCB 0 ;sprBank
	DCB 0 ;sprmemalloc
	DCB 0 ;sprmemreload
;...update load/savestate if you move things around in here
;----------------------------------------------------------------------------
	END

