	AREA wram_code1, CODE, READWRITE

	INCLUDE equates.h
	INCLUDE z80.h
	INCLUDE io.h
	INCLUDE gfx.h

	IMPORT |wram_globals0$$Base|
	IMPORT ui	;ui.c

	EXPORT CPU_reset
	EXPORT run
	EXPORT default_scanlinehook
	EXPORT sleeptime
	EXPORT novblankwait
	EXPORT gbadetect



;----------------------------------------------------------------------------
run	;r0=0 to return after frame
;----------------------------------------------------------------------------
;	mov r11,r11			;No$GBA breakpoint
	mov r1,#0
	strb r1,novblankwait

	strb r0,dontstop
	tst r0,#1
	stmeqfd sp!,{z80f-z80pc,globalptr,z80sp,lr}

	ldr globalptr,=|wram_globals0$$Base|
	b line0x
;----------------------------------------------------------------------------
;cycles ran out
;----------------------------------------------------------------------------
line0
	adr r2,cpuregs
	stmia r2,{z80f-z80pc,z80sp}	;save Z80 state
waitformulti
	ldr r1,=REG_P1		;refresh input every frame
	ldrh r0,[r1]
		eor r0,r0,#0xff
		eor r0,r0,#0x300	;r0=button state (raw)
	ldr r1,AGBjoypad
	eor r1,r1,r0
	and r1,r1,r0		;r1=button state (0->1)
	str r0,AGBjoypad

	ldrb r2,emuflags+1
	cmp r2,#SCALED
	bhs %F0			;if unscaled
	ldr r2,windowtop
	tst r0,#0x100			;R=scroll down
	addne r2,r2,#2
	cmp r2,#80
	movgt r2,#80
	tst r0,#0x200			;L=scroll up
	subne r2,r2,#2
	cmp r2,#16
	movmi r2,#16
	str r2,windowtop
0

	ldrb r2,dontstop
	tst r2,#1
	ldmeqfd sp!,{z80f-z80pc,globalptr,z80sp,lr}	;exit here if doing single frame:
	bxeq lr							;return to rommenu()

	;----anything from here til line0x won't get executed while rom menu is active---

	mov r2,#REG_BASE
	mov r3,#0x0110				;was 0x0310
	strh r3,[r2,#REG_BLDCNT]	;stop darkened screen,OBJ blend to BG0/1
	mov r3,#0x1000				;BG0/1=16, OBJ=0
	strh r3,[r2,#REG_BLDALPHA]	;Alpha values

	adr lr,line0x			;return here after doing L/R + SEL/START

	tst r1,#0x300			;if L or R was pressed
	tstne r0,#0x100
	tstne r0,#0x200			;and both L+R are held..
	ldrne r1,=ui
	bxne r1					;do menu


	ands r3,r0,#0x300		;if either L or R is pressed (not both)
	eornes r3,r3,#0x300
	bicne r0,r0,#0x0c		;	hide sel,start from EMU
	str r0,EMUjoypad
	beq line0x				;skip ahead if neither or both are pressed

;	tst r0,#0x200
;	tstne r1,#4				;L+SEL for BG adjust
;	ldrne r2,adjustblend
;	addne r2,r2,#1
;	strne r2,adjustblend

	tst r0,#0x200			;L?
	tstne r1,#8				;START?
	ldrb r2,novblankwait	;0=Normal, 1=No wait, 2=Slomo
	addne r2,r2,#1
	cmp r2,#3
	moveq r2,#0
	strb r2,novblankwait

;	tst r0,#0x100			;R?
;	tstne r1,#8				;START:
;	ldrne r1,=quickload
;	bxne r1

;	tst r0,#0x100			;R?
;	tstne r1,#4				;SELECT:
;	ldrne r1,=quicksave
;	bxne r1
line0x
	bl refreshEMUjoypads	;Z=1 if communication ok
	bne waitformulti		;waiting on other GBA..

	ldr r0,AGBjoypad
	ldr r2,fiveminutes		;sleep after 5/10/30 minutes of inactivity
	cmp r0,#0				;(left out of the loop so waiting on multi-link
	ldrne r2,sleeptime		;doesn't accelerate time)
	subs r2,r2,#1
	str r2,fiveminutes
	bleq suspend

	mov r1,#0
	str r1,scanline			;reset scanline count
	bl newframe				;display update


	ldrb r4,novblankwait
	teq r4,#1
	beq l03
l01
	mov r0,#0				;wait for next vblank.
	mov r1,#1				;VBL wait
	swi 0x040000			; Turn of CPU until IRQ if not too late allready.
	ldr r0,goemon
	cmp r0,#0
	mov r0,#0				;wait for next vblank.
	mov r1,#1				;VBL wait
	swieq 0x040000			; Turn of CPU until IRQ if not too late allready.
	teq r4,#2				;Check for slomo
	moveq r4,#0
	beq l01
l03

	ldr r0,fpsvalue
	add r0,r0,#1
	str r0,fpsvalue

	adr r0,cpuregs
	ldmia r0,{z80f-z80pc,z80sp}	;restore Z80 state

	ldr r0,cyclesperscanline
	add cycles,cycles,r0
	adr r0,line1_to_120
	str r0,nexttimeout
	str r0,nexttimeout_
	mov r1,#0		;Scanline

	ldr pc,scanlinehook
line1_to_120 ;------------------------
	ldr r0,cyclesperscanline
	add cycles,cycles,r0

	ldr r1,scanline
	add r1,r1,#1
	str r1,scanline
	cmp r1,#120
	ldrmi pc,scanlinehook
;--------------------------------------------- between 120 and 121

;	ldrb r0,lcdctrl
;	strb r0,lcdctrl0frame		;Chase HQ-GB sprites likes this

	adr addy,line121_to_240
	str addy,nexttimeout
	str addy,nexttimeout_
	ldr pc,scanlinehook
line121_to_240 ;------------------------
	ldr r0,cyclesperscanline
	add cycles,cycles,r0

	ldr r1,scanline
	add r1,r1,#1
	str r1,scanline
	cmp r1,#240
	ldrmi pc,scanlinehook

	adr addy,line241
	str addy,nexttimeout
	str addy,nexttimeout_
	ldr pc,scanlinehook
line241 ;------------------------
	bl endframe					;display update


 [ DEBUG
	mov r1,#REG_BASE			;darken screen during EMU vblank
	mov r0,#0x00f1
	strh r0,[r1,#REG_BLDCNT]
	ldrh r0,[r1,#REG_VCOUNT]
	mov r1,#19
	bl debug_
 ]
	ldrb r0,irqControl
	tst r0,#6			;IRQ enabled?, gb=4, goemon=2
	beq novbirq

	ldrb r0,z80_if_
	orr r0,r0,#0x01
	strb r0,z80_if_

novbirq
	mov r0,#24*CYCLE
	add cycles,cycles,r0

	mov r1,#241
	str r1,scanline

	adr addy,VBL_Hook
	str addy,nexttimeout
	str addy,nexttimeout_
	b _GO
VBL_Hook
	ldr r0,cyclesperscanline
	sub r0,r0,#24*CYCLE
	add cycles,cycles,r0

	adr addy,line242_to_end
	str addy,nexttimeout
	str addy,nexttimeout_
	ldr pc,scanlinehook
line242_to_end ;------------------------
	ldr r0,cyclesperscanline
	add cycles,cycles,r0

	ldr r1,scanline
	add r1,r1,#1
	str r1,scanline
	cmp r1,#264				;last scanline
	ldrmi pc,scanlinehook

	adr addy,line0
	str addy,nexttimeout
	str addy,nexttimeout_
	ldr r0,frame
	add r0,r0,#1
	str r0,frame
	ldr pc,scanlinehook

;----------------------------------------------------------
default_scanlinehook
checkScanlineIRQ
	ldr r1,scanline
	ldrb r0,scanlinemod
	tst r1,r0				;gb=0xf, goemon=0x1f
	bne noScanlineIRQ
	ldrb r2,irqControl
	tst r2,#1				;NMI enabled?
	bne Z80_nmi
noScanlineIRQ
	b checkMasterIRQ

;----------------------------------------------------------------------------
fiveminutes		DCD 5*60*60
sleeptime		DCD 5*60*60
dontstop		DCB 0
novblankwait	DCB 0
gbadetect		DCB 0
scanlinemod		DCB 0
;----------------------------------------------------------------------------
	AREA rom_code, CODE, READONLY
;----------------------------------------------------------------------------

;----------------------------------------------------------------------------
CPU_reset	;called by loadcart (r0-r9 are free to use)
;----------------------------------------------------------------------------
	str lr,[sp,#-4]!

	ldr r0,goemon
	cmp r0,#0
	moveq r0,#0x0f
	movne r0,#0x1f
	ldr r1,=scanlinemod
	strb r0,[r1]
;---Speed - 3.072MHz / 30Hz		;Green Beret.
	ldreq r0,=391*CYCLE
;---Speed - 3.072MHz / 60Hz		;Goemon.
	ldrne r0,=195*CYCLE
	bl Z80_reset
	ldr lr,[sp],#4
	bx lr

;----------------------------------------------------------------------------
	END

