	INCLUDE equates.h
	INCLUDE memory.h
	INCLUDE z80mac.h
	INCLUDE z80.h
	INCLUDE cpu.h
	INCLUDE io.h
	INCLUDE gfx.h
	INCLUDE sound.h

	IMPORT findrom ;from main.c
	IMPORT pogoshell ;from main.c
	IMPORT pogosize ;from main.c

	EXPORT loadcart
	EXPORT HuMapper_
	EXPORT bg_finish
	EXPORT savestate
	EXPORT loadstate
	EXPORT g_emuflags
	EXPORT romstart
	EXPORT romnum
	EXPORT g_scaling
	EXPORT g_cartflags
	EXPORT g_dipswitch0
	EXPORT g_dipswitch1
	EXPORT g_dipswitch2
	EXPORT g_coin0
	EXPORT g_coin1
;-------------------------------------------------------------------------------
 AREA rom_code, CODE, READONLY
;-------------------------------------------------------------------------------
;-------------------------------------------------------------------------------
loadcart ;called from C:  r0=rom number, r1=emuflags
;-------------------------------------------------------------------------------
	stmfd sp!,{r0-r1,r4-r11,lr}

	ldr r1,=findrom
	bl thumbcall_r1
	add r3,r0,#48		;r0 now points to rom image (including header)

	ldr globalptr,=|wram_globals0$$Base|	;need ptr regs init'd

	ldmfd sp!,{r0-r1}
	str r0,romnumber
	str r1,emuflags

	ldr r1,=pogoshell
	ldrb r1,[r1]
	cmp r1,#0
	addeq r3,r3,#16		;If using rombuilder skip NES header.
						;r3=rombase til end of loadcart so DON'T FUCK IT UP
	ldrne r1,=pogosize
	ldrne r1,[r1]		;Size from Pogoshell
	ldreq r1,[r3,#-32]	;size of rom in bytes (from rombuilder).
	str r3,rombase		;set rom base
	add r0,r3,#0xC000	;0xC000
	tst r1,#0x4000
	addne r0,r0,#0x4000	;Mr. Goemon
	str r0,vrombase0	;bg
	add r0,r0,#0x4000
	str r0,vrombase1	;spr
	add r0,r0,#0x10000
	str r0,prombase		;colour prom

	moveq r0,#0
	movne r0,#1
	str r0,goemon		;setup some things different for Mr. Goemon.

	ldr r4,=MEMMAPTBL_
	ldr r5,=RDMEMTBL_
	ldr r6,=WRMEMTBL_
	ldr r7,=rom_R0
	ldr r8,=rom_W
	mov r0,#0

tbloop1
;	and r1,r0,r2
	add r1,r3,r0,lsl#13
	str r1,[r4,r0,lsl#2]
	str r7,[r5,r0,lsl#2]
	str r8,[r6,r0,lsl#2]
	add r0,r0,#1
	cmp r0,#0x88
	bne tbloop1
resbg
	ldr r7,=empty_R
	ldr r8,=empty_W
tbloop2
	str r3,[r4,r0,lsl#2]
	str r7,[r5,r0,lsl#2]
	str r8,[r6,r0,lsl#2]
	add r0,r0,#1
	cmp r0,#0x100
	bne tbloop2


	ldr r1,=EMU_RAM
	ldr r7,=rom_R0
	ldr r8,=ram_W
	mov r0,#0xF8			;RAM
meml3
	str r1,[r4,r0,lsl#2]	;MemMap
	str r7,[r5,r0,lsl#2]	;RdMem
	str r8,[r6,r0,lsl#2]	;WrMem
	add r0,r0,#1			;0xF8-0xFB RAM
	cmp r0,#0xFB
	bne meml3

	ldr r7,=IO_R
	ldr r8,=IO_W
	mov r0,#0xFF			;IO
	str r7,[r5,r0,lsl#2]	;RdMem
	str r8,[r6,r0,lsl#2]	;WrMem

	ldr r0,=default_scanlinehook
	str r0,scanlinehook

	mov z80pc,#0			;(eliminates any encodePC errors during mapper*init)
	str z80pc,lastbank

	adr r4,HuMapData
	mov r5,#0x80
HuDataLoop
	mov r0,r5
	ldrb r1,[r4],#1
	bl HuMapper_
	movs r5,r5,lsr#1
	bne HuDataLoop

	ldr r0,=SCRL_RAM			;clear RAM
	mov r1,#0		
	mov r2,#0x2040/4
	bl memset_

	bl GFX_reset
	bl IO_reset
	bl Sound_reset
	bl CPU_reset
	ldmfd sp!,{r4-r11,lr}
	bx lr
;-------------------------------------------------------------------------------
HuMapData
	DCB 0xFF,0xF8,0x05,0x04,0x03,0x02,0x01,0x00			;Green Beret
;	DCB 0x07,0x06,0x05,0x04,0x01,0x00,0xFF,0xF8			;Renegade
;	DCB 0x00,0x00,0x00,0xF7,0x00,0x00,0xF8,0xFF			;PC-Engine
;-------------------------------------------------------------------------------
;-------------------------------------------------------------------------------
savestate	;called from ui.c.
;int savestate(void *here): copy state to <here>, return size
;-------------------------------------------------------------------------------
	stmfd sp!,{r4-r6,globalptr,lr}

	ldr globalptr,=|wram_globals0$$Base|

	ldr r2,rombase
	rsb r2,r2,#0				;adjust rom maps,etc so they aren't based on rombase
	bl fixromptrs				;(so savestates are valid after moving roms around)

	ldr r6,=STATEPTR			;r6=where to copy state
;	mov r6,r0					;r6=where to copy state
	mov r0,#0					;r0 holds total size (return value)

	adr r4,savelst				;r4=list of stuff to copy
	mov r3,#(lstend-savelst)/8	;r3=items in list
ss1	ldmia r4!,{r1,r2}			;r1=what to copy, r2=how much to copy
	add r0,r0,r2
ss0	ldr r5,[r1],#4
	str r5,[r6],#4
	subs r2,r2,#4
	bne ss0
	subs r3,r3,#1
	bne ss1

	ldr r2,rombase
	bl fixromptrs

	ldmfd sp!,{r4-r6,globalptr,lr}
	bx lr

savelst	DCD rominfo,8,SCRL_RAM,0x2040,cpustate,96,gfxstate,8
lstend

fixromptrs	;add r2 to some things
	ldr r3,lastbank
	add r3,r3,r2
	str r3,lastbank

	ldr r3,cpuregs+6*4	;Z80 PC
	add r3,r3,r2
	str r3,cpuregs+6*4

	mov pc,lr
;-------------------------------------------------------------------------------
loadstate	;called from ui.c
;void loadstate(int rom#,u32 *stateptr)	 (stateptr must be word aligned)
;-------------------------------------------------------------------------------
	stmfd sp!,{r4-r7,globalptr,lr}

	mov r0,#0
	ldr r6,=STATEPTR			;r6=where state is at
;	mov r6,r1		;r6=where state is at
	ldr globalptr,=|wram_globals0$$Base|

	ldr r1,[r6]		;emuflags
	bl loadcart		;cart init

	mov r0,#(lstend-savelst)/8	;read entire state
	adr r4,savelst
ls1	ldmia r4!,{r1,r2}
ls0	ldr r5,[r6],#4
	str r5,[r1],#4
	subs r2,r2,#4
	bne ls0
	subs r0,r0,#1
	bne ls1

	ldr r2,rombase		;adjust ptr shit (see savestate above)
	bl fixromptrs

	mov r0,#1
	strb r0,sprmemreload

	ldmfd sp!,{r4-r7,globalptr,lr}
	bx lr



;-------------------------------------------------------------------------------
;-------------------------------------------------------------------------------
bg_finish	;end of frame...
;-------------------------------------------------------------------------------
	stmfd sp!,{r3-r9,r11,lr}

	ldr r4,=mem_dirtytbl

;	b bg_cont

	ldr r0,windowtop+4
	ldr r1,windowtop+8
	eor r0,r0,r1
	bics r0,r0,#0xF
	bne bg_cont
	ldrb r0,[r4]
	cmp r0,#0
	ldmeqfd sp!,{r3-r9,r11,pc}
bg_cont
	mov r0,#0
	strb r0,[r4]

	ldr r1,emuflags
	tst r1,#0x200
	ldreq r4,windowtop+4		;first scanline unscaled.
	ldrneb r4,ystart			;first scanline scaled.
	moveq r0,#160
	movne r0,#224
	add r11,r4,r0				;r11 = sheight
	mov r8,#0x1000				;tilemap offset

	b bglo2

;-------------------------------------------------------------------------------
 AREA wram_code4, CODE, READWRITE
;-------------------------------------------------------------------------------

;-------------------------------------------------------------------------------
;bgchrfinish2	;end of frame...
;-------------------------------------------------------------------------------
bglo2
	bic r0,r4,#7

	ldr r3,=EMU_RAM
	add r6,r3,r0,lsl#3			;64x32 tiles
	add r5,r6,#0x800			;r5 tile, r6 attrib

	sub r3,r3,#0x40				;Scroll RAM
	ldrb r2,[r3,r0,lsr#3]!
	ldrb r3,[r3,#0x20]
	orr r2,r2,r3,lsl#8
	add r2,r2,#8
	mov r2,r2,lsr#2

	mov r9,#AGB_VRAM
	add r9,r9,r0,lsl#3
	mov r3,#32					;width
bgtrloop
	and r2,r2,#0x7e
	ldrb r0,[r5,r2,lsr#1]				;Read from GreenBeret Tilemap RAM
	ldrb r1,[r6,r2,lsr#1]				;Read from GreenBeret Colormap RAM
	tst r1,#0x40
	orrne r0,r0,#0x100			;bit 8 of tilenum
	orr r0,r0,r1,lsl#12			;color bits
	and r1,r0,#0x30000
	orr r0,r0,r1,lsr#6			;XY flip

	orr r7,r2,r2,lsl#5			;move 0x40 to 0x800
	bic r7,r7,#0x17C0
	strh r0,[r7,r9]!			;Write to GBA Tilemap RAM
	mov r0,r0,lsr#12
	and r0,r0,#0xF
	strh r0,[r7,r8]				;Write to GBA Tilemap RAM 2 (extra bgr color)
	add r2,r2,#2
	subs r3,r3,#1
	bne bgtrloop

	add r4,r4,#8
	cmp r4,r11					;160*4/3=213.33333
	ble bglo2

	ldmfd sp!,{r3-r9,r11,pc}


;----------------------------------------------------------------------------
HuMapper_	;rom paging..
;----------------------------------------------------------------------------
	stmfd sp!,{r3-r7}
	ldr r6,=MEMMAPTBL_
	ldr r2,[r6,r1,lsl#2]!
	ldr r3,[r6,#-1024]		;RDMEMTBL_
	ldr r4,[r6,#-2048]		;WRMEMTBL_

	mov r5,#0
	cmp r1,#0xFC
	movmi r5,#12

wr_tbl
	adr r6,readmem_tbl
	tst r0,#0xFF
	bne memaps				;safety
	b flush
memapl
	add r6,r6,#4
memap2
	add r3,r3,r5
	sub r2,r2,#0x2000
memaps
	movs r0,r0,lsr#1
	bcc memapl				;C=0
	strcs r3,[r6],#4		;readmem_tbl
	strcs r4,[r6,#28]		;writemem_tb
	strcs r2,[r6,#60]		;memmap_tbl
	bne memap2

;------------------------------------------
flush		;update cpu_pc & lastbank
;------------------------------------------
	ldr r1,lastbank
	sub z80pc,z80pc,r1
	encodePC

	ldmfd sp!,{r3-r7}
	mov pc,lr


;----------------------------------------------------------------------------
 AREA wram_globals2, CODE, READWRITE

romstart
	DCD 0 ;rombase
romnum
	DCD 0 ;romnumber
rominfo                 ;keep emuflags/BGmirror together for savestate/loadstate
g_emuflags	DCB 0 ;emuflags        (label this so UI.C can take a peek) see equates.h for bitfields
g_scaling	DCB SCALED_SPRITES ;(display type)
	% 2   ;(sprite follow val)
g_cartflags
	DCB 0 ;cartflags
g_dipswitch0
	DCB 0 ;dipswitch0
g_dipswitch1
	DCB 0 ;dipswitch1
g_dipswitch2
	DCB 0 ;dipswitch2
g_coin0
	DCD 0 ;coincounter0
g_coin1
	DCD 0 ;coincounter1
	DCD 0 ;vrombase0
	DCD 0 ;vrombase1
	DCD 0 ;prombase
	DCD 0 ;goemon


;----------------------------------------------------------------------------
	END

