	INCLUDE equates.h			;for the frequencytable pointer.
	INCLUDE sn76496_equ.h

	EXPORT SN76496_init
	EXPORT SN76496_reset
	EXPORT SN76496_set_mixrate
	EXPORT SN76496_set_frequency
	EXPORT SN76496_mixer
	EXPORT SN76496_w

NSEED	 	EQU 0x8000			;Noise Seed
								;These values are for the SMS/GG/MD vdp sound.
;WFEED	 	EQU 0x9000			;White Noise Feedback
;PFEED	 	EQU 0x8000			;Periodic Noise Feedback

								;These values are for the SN76496 sound chip.
WFEED	 	EQU 0x6000			;White Noise Feedback
PFEED	 	EQU 0x4000			;Periodic Noise Feedback
 AREA wram_code2, CODE, READWRITE
;----------------------------------------------------------------------------
; r0 = mixer reg.
; r1 -> r4 = pos+freq.
; r5 = noise generator.
; r6 = noise feedback.
; r7 = ch0/1 volumes.
; r8 = ch2/3 volumes.
; r9 = mixerbuffer.
; r11 = mix length.
; lr = return address.
;----------------------------------------------------------------------------
mixer
;----------------------------------------------------------------------------
mixloop

	adds r4,r4,r4,lsl#16
	movcss r5,r5,lsr#1
	eorcs r5,r5,r6
volF
	mov r0,#0x8000
	adds r1,r1,r1,lsl#16
	addpl r0,r0,r7

	adds r2,r2,r2,lsl#16
	addpl r0,r0,r7,lsr#16

	adds r3,r3,r3,lsl#16
	addpl r0,r0,r8

	tst r5,#1
	addne r0,r0,r8,lsr#16
	mov r0,r0,lsr#8
	strb r0,[r9],#1

	subs r11,r11,#1
	bhi mixloop

	bx lr
;----------------------------------------------------------------------------

 AREA rom_code, CODE, READONLY ;-- - - - - - - - - - - - - - - - - - - - - -

;----------------------------------------------------------------------------
SN76496_init						;r0=pointer to struct
;----------------------------------------------------------------------------
	stmfd sp!,{r0,lr}
	bl frequency_calculate
	ldmfd sp!,{r0,lr}
;----------------------------------------------------------------------------
SN76496_reset						;r0=pointer to struct
;----------------------------------------------------------------------------
	stmfd sp!,{lr}

;	adrl r0,SoundVariables
	mov r1,#0
	mov r2,#13						;52/4=13
r_loop
	subs r2,r2,#1
	strpl r1,[r0,r2,lsl#2]
	bhi r_loop

	ldmfd sp!,{lr}
	bx lr

;----------------------------------------------------------------------------
SN76496_set_mixrate					;r0=pointer to struct, r1 in. 0 = low, 1 = high
;----------------------------------------------------------------------------
	cmp r1,#0
	moveq r1,#924					;low,  18157Hz
	movne r1,#532					;high, 31536Hz
	str r1,mixrate
	moveq r1,#304					;low
	movne r1,#528					;high
	str r1,mixlength
	bx lr
;----------------------------------------------------------------------------
SN76496_set_frequency				;r0=pointer to struct, r1=frequency of chip.
;----------------------------------------------------------------------------
	ldr r2,mixrate
	mul r1,r2,r1
	mov r1,r1,lsr#12
	str r1,freqconv					;Frequency conversion (SN76496freq*mixrate)/4096
	bx lr
;----------------------------------------------------------------------------
frequency_calculate					;r0=pointer to struct
;----------------------------------------------------------------------------
	stmfd sp!,{r4-r6,lr}
	ldr r6,freqconv					;(sn76496/gba)*4096
	ldr r5,=FREQTBL					;Destination
	mov r4,#2048
frqloop2
	mov r0,r6
	mov r1,r4
	swi 0x060000					;BIOS Div, r0/r1.
	cmp r4,#7*2
	movmi r0,#0						;to remove real high tones.
	subs r4,r4,#2
	strh r0,[r5,r4]
	bhi frqloop2

	ldmfd sp!,{r4-r6,lr}
	bx lr

;----------------------------------------------------------------------------
SN76496_mixer						;r0 = struct-pointer
;----------------------------------------------------------------------------
	stmfd sp!,{r3-r9,r11,lr}

	adr r12,ch0freq
	ldmia r12,{r1-r9,r11}			;load freq,addr,rng, noisefb,vol0, vol1, ptr & len
;--------------------------
	bl mixer
;--------------------------
	stmia r12,{r1-r5}				;writeback freq,addr,rng

	ldmfd sp!,{r3-r9,r11,pc}

;----------------------------------------------------------------------------
SN76496_w							;r0 = struct-pointer, r1 = value
;----------------------------------------------------------------------------
	tst r1,#0x80
	andne r2,r1,#0x70
	strneb r2,sn_lastreg
	ldreqb r2,sn_lastreg
	movs r2,r2,lsr#5
	bcc SetFreq
DoVolume
	and r1,r1,#0x0F
	adr r3,Attenuation
	add r3,r3,r1
	ldrh r1,[r3,r1]
	adr r3,ch0volume
	add r3,r3,r2
	strh r1,[r3,r2]
	bx lr

SetNoiseF
	str r1,ch3reg
	tst r1,#4
	movne r3,#WFEED			;White noise
	moveq r3,#PFEED			;Periodic noise
	str r3,noisefb
	mov r3,#NSEED			;Preset seed
	str r3,rng
	ldr r3,freqconv
	ands r1,r1,#3
	moveq r2,r3,lsr#5		;These values sound ok
	movne r2,r3,lsr#6
	cmp r1,#2
	moveq r2,r3,lsr#7
	ldrhih r2,ch2freq
	strh r2,ch3freq
	bx lr

SetFreq
	cmp r2,#3				;noise channel
	beq SetNoiseF

	tst r1,#0x80
	andne r1,r1,#0x0F
	andeq r1,r1,#0x3F
	adr r3,ch0reg
	ldr r12,[r3,r2,lsl#2]
	andne r12,r12,#0x7E0
	andeq r12,r12,#0x01E
	orrne r12,r12,r1,lsl#1
	orreq r12,r12,r1,lsl#5
	str r12,[r3,r2,lsl#2]

	ldr r3,=FREQTBL
	ldrh r1,[r3,r12]
	adr r3,ch0freq
	add r3,r3,r2,lsl#2
	strh r1,[r3]
	cmp r2,#2				;ch2
	ldreq r3,ch3reg
	andeq r3,r3,#3
	cmpeq r3,#3
	streqh r1,ch3freq
	bx lr

Attenuation
	DCW 0x3FFF,0x32D5,0x2861,0x2013,0x197A,0x143D,0x1013,0x0CC5,0x0A25,0x080E,0x0666,0x0515,0x040A,0x0335,0x028C,0x0000
;----------------------------------------------------------------------------
	END

