	INCLUDE equates.h
	INCLUDE z80.h
	INCLUDE io.h
	INCLUDE gfx.h

	EXPORT empty_IO_R
	EXPORT empty_R
	EXPORT empty_W
	EXPORT ram_R
	EXPORT ram_W0
	EXPORT ram_W1
	EXPORT rom_R0
	EXPORT rom_W
	EXPORT bytecopy_
	EXPORT memset_
	EXPORT memorr_
	EXPORT mem_dirtytbl
;----------------------------------------------------------------------------
 AREA rom_code, CODE, READONLY
;----------------------------------------------------------------------------
;----------------------------------------------------------------------------
bytecopy_		;void bytecopy(u8 *dst,u8 *src,int count)
;----------------------------------------------------------------------------
	subs r2,r2,#1
	ldrplb r3,[r1,r2]
	strplb r3,[r0,r2]
	bhi bytecopy_
	bx lr

;----------------------------------------------------------------------------
empty_IO_R		;read bad IO address (error)
;----------------------------------------------------------------------------
	mov r11,r11				;No$GBA debugg
	mov r0,#0x10
	mov pc,lr
;----------------------------------------------------------------------------
empty_R			;read bad address (error)
;----------------------------------------------------------------------------
	mov r11,r11				;No$GBA debugg
	mov r0,#0
	mov pc,lr
;----------------------------------------------------------------------------
empty_W			;write bad address (error)
;----------------------------------------------------------------------------
	mov r11,r11			;No$GBA debugg
	mov r0,#0xBA
	mov pc,lr
;----------------------------------------------------------------------------
rom_W			;write ROM address (error)
;----------------------------------------------------------------------------
	mov r11,r11			;No$GBA debugg
	mov r0,#0xB0
	mov pc,lr
;----------------------------------------------------------------------------
	AREA wram_code2, CODE, READWRITE
;----------------------------------------------------------------------------
ram_W0	;ram write ($8000-$8FFF)
;----------------------------------------------------------------------------
	tst addy,#0x1000
	bne IO_W
	bic r1,addy,#0xFF000
	ldr r2,=EMU_RAM0
	strb r0,[r2,r1]
	mov r2,#-1
	strb r2,[pc]
	mov pc,lr
mem_dirtytbl
	DCB 0,0,0,0
;----------------------------------------------------------------------------
ram_W1	;ram write ($E000-$EFFF)
;----------------------------------------------------------------------------
	tst addy,#0x1000
	bne IO_W
	bic r1,addy,#0xFF000
	ldr r2,=EMU_RAM1
	strb r0,[r2,r1]
	mov pc,lr

;----------------------------------------------------------------------------
rom_R0	;rom read
;----------------------------------------------------------------------------
	ldr r1,memmap_tbl
	ldrb r0,[r1,addy]
	mov pc,lr
;----------------------------------------------------------------------------
rom_R1	;rom read
;----------------------------------------------------------------------------
	ldr r1,memmap_tbl+4
	ldrb r0,[r1,addy]
	mov pc,lr
;----------------------------------------------------------------------------
rom_R2	;rom read
;----------------------------------------------------------------------------
	ldr r1,memmap_tbl+8
	ldrb r0,[r1,addy]
	mov pc,lr
;----------------------------------------------------------------------------
rom_R3	;rom read
;----------------------------------------------------------------------------
	ldr r1,memmap_tbl+12
	ldrb r0,[r1,addy]
	mov pc,lr
;----------------------------------------------------------------------------
rom_R4	;rom read
;----------------------------------------------------------------------------
	ldr r1,memmap_tbl+16
	ldrb r0,[r1,addy]
	mov pc,lr
;----------------------------------------------------------------------------
rom_R5	;rom read
;----------------------------------------------------------------------------
	ldr r1,memmap_tbl+20
	ldrb r0,[r1,addy]
	mov pc,lr
;----------------------------------------------------------------------------
rom_R6	;rom read
;----------------------------------------------------------------------------
	ldr r1,memmap_tbl+24
	ldrb r0,[r1,addy]
	mov pc,lr
;----------------------------------------------------------------------------
rom_R7	;rom read
;----------------------------------------------------------------------------
	ldr r1,memmap_tbl+28
	ldrb r0,[r1,addy]
	mov pc,lr
;----------------------------------------------------------------------------
ram_R	;ram read
;----------------------------------------------------------------------------
	tst addy,#0x1000
	bne IO_S_R					;0x9803 read
	adr r2,memmap_tbl
	ldr r1,[r2,r1,lsr#11]		;r1=addy & 0xe000
	ldrb r0,[r1,addy]
	mov pc,lr
;----------------------------------------------------------------------------
memset_ ;r0=dest r1=data r2=word count
;	exit with r0 & r1 unchanged, r2=0
;----------------------------------------------------------------------------
	subs r2,r2,#1
	strpl r1,[r0,r2,lsl#2]
	bhi memset_
	bx lr
;----------------------------------------------------------------------------
memorr_ ;r0=dest r1=data r2=word count
;	exit with r0 & r1 unchanged, r2=0, r3 trashed
;----------------------------------------------------------------------------
	subs r2,r2,#1
	ldrpl r3,[r0,r2,lsl#2]
	orrpl r3,r3,r1
	strpl r3,[r0,r2,lsl#2]
	bhi memorr_
	bx lr
;----------------------------------------------------------------------------
	END
