	INCLUDE equates.h
	INCLUDE memory.h
	INCLUDE cart.h
	INCLUDE io.h
	INCLUDE z80.h
	INCLUDE z80mac.h
	INCLUDE sound.h

	EXPORT GFX_init
	EXPORT GFX_reset
	EXPORT debug_
	EXPORT AGBinput
	EXPORT EMUinput
	EXPORT paletteinit
	EXPORT PaletteTxAll
	EXPORT newframe
	EXPORT endframe
	EXPORT gfxstate
	EXPORT gammavalue
	EXPORT oambufferready
;	EXPORT ScrolX_L_W
;	EXPORT ScrolX_H_W
	EXPORT twitch
	EXPORT flicker
	EXPORT fpsenabled
	EXPORT FPSValue
	EXPORT vbldummy
	EXPORT vblankfptr
	EXPORT vblankinterrupt

	IMPORT RumbleInterrupt
	IMPORT StartRumbleComs

 AREA rom_code, CODE, READONLY

;----------------------------------------------------------------------------
GFX_init	;(called from main.c) only need to call once
;----------------------------------------------------------------------------
	mov addy,lr

	mov r1,#0xffffff00		;build chr decode tbl
	ldr r2,=CHR_DECODE0		;0x400
ppi0
	mov r0,#0
	tst r1,#0x01
	orrne r0,r0,#0x00000001
	tst r1,#0x02
	orrne r0,r0,#0x00000010
	tst r1,#0x04
	orrne r0,r0,#0x00000100
	tst r1,#0x08
	orrne r0,r0,#0x00001000
	tst r1,#0x10
	orrne r0,r0,#0x00010000
	tst r1,#0x20
	orrne r0,r0,#0x00100000
	tst r1,#0x40
	orrne r0,r0,#0x01000000
	tst r1,#0x80
	orrne r0,r0,#0x10000000
	str r0,[r2],#4
	adds r1,r1,#1
	bne ppi0

	mov r1,#0xffffff00		;build chr decode tbl
	ldr r2,=CHR_DECODE1		;0x200
ppi1
	mov r0,#0
	tst r1,#0x01
	orrne r0,r0,#0x0002
	tst r1,#0x02
	orrne r0,r0,#0x0020
	tst r1,#0x04
	orrne r0,r0,#0x0200
	tst r1,#0x08
	orrne r0,r0,#0x2000
	tst r1,#0x10
	orrne r0,r0,#0x0001
	tst r1,#0x20
	orrne r0,r0,#0x0010
	tst r1,#0x40
	orrne r0,r0,#0x0100
	tst r1,#0x80
	orrne r0,r0,#0x1000
	strh r0,[r2],#2
	adds r1,r1,#1
	bne ppi1

	mov r1,#REG_BASE
	mov r0,#0x0008
	strh r0,[r1,#REG_DISPSTAT]	;vblank en


	add r0,r1,#REG_BG0HOFS		;DMA0 always goes here
	str r0,[r1,#REG_DM0DAD]
	ldr r0,=DMA0BUFF+8			;DMA0 src=
	str r0,[r1,#REG_DM0SAD]
	mov r0,#2					;1 word transfer
	strh r0,[r1,#REG_DM0CNT_L]

	add r2,r1,#REG_IE
	mov r0,#-1
	strh r0,[r2,#2]		;stop pending interrupts
	ldr r0,=irqhandler
	str r0,[r1,#-4]		;=AGB_IRQVECT
	ldr r0,=0x1081
	strh r0,[r2]		;key(0x1000),vblank(0x0001),timer1(0x0010) enable. (serial interrupt=0x0080)
	mov r0,#1
	strh r0,[r2,#8]		;master irq enable

	bx addy
;----------------------------------------------------------------------------
GFX_reset	;called with CPU reset
;----------------------------------------------------------------------------
	str lr,[sp,#-4]!

	mov r1,#0
	str r1,windowtop

	ldr r0,=gfxstate
	mov r2,#2				;2*4
	bl memset_				;clear GFX regs

	mov r0,#1
	strb r0,sprmemreload

	mov r0,#32
	strb r0,ystart

	mov r1,#REG_BASE
	ldr r0,=0x000A
	strh r0,[r1,#REG_BG0CNT]
	ldr r0,=0x020E
	strh r0,[r1,#REG_BG1CNT]


	mov r0,#AGB_OAM
	mov r1,#0x2a0
	mov r2,#0x100
	bl memset_		;no stray sprites please
	ldr r0,=OAM_BUFFER1
	mov r2,#0x180
	bl memset_
	bl BG_init

	bl paletteinit	;do palette mapping
	bl PaletteTxAll	;transfer it
	ldr pc,[sp],#4

;----------------------------------------------------------------------------
BG_init;	BG tiles
;----------------------------------------------------------------------------
	stmfd sp!,{r4-r6}

	ldr r3,vrombase0			;r3 = bgr0 bitplane 0
	mov r4,#0x1000				;r4 = bgr0 bitplane 1 offset
	ldr r2,=CHR_DECODE0
	mov r12,#AGB_VRAM			;r12=AGB BG tileset
	add r12,r12,#0x8000			;tile ram 2.0
bgchr1
	ldrb r1,[r3,r4]				;read 2nd plane
	ldrb r0,[r3],#1				;read 1st plane

	ldr r0,[r2,r0,lsl#2]
	ldr r1,[r2,r1,lsl#2]
	orr r0,r1,r0,lsl#1

	str r0,[r12],#4
	tst r12,#0x4000
	beq bgchr1

	add r3,r3,#0x1000			;bgr1
bgchr2
	ldrb r1,[r3,r4]				;read 2nd plane
	ldrb r0,[r3],#1				;read 1st plane

	ldr r0,[r2,r0,lsl#2]
	ldr r1,[r2,r1,lsl#2]
	orr r0,r1,r0,lsl#1

	str r0,[r12],#4
	tst r12,#0x8000
	bne bgchr2


	ldr r3,vrombase1			;r3 = spr bitplane 0 & 1
	ldr r2,=CHR_DECODE1
obchr1
	mov r4,#8
obchr2
	ldrb r0,[r3],#1				;read 1st & 2nd plane
	ldrb r1,[r3],#3				;read 1st & 2nd plane
	mov r0,r0,lsl#1
	mov r1,r1,lsl#1
	ldrh r0,[r2,r0]
	ldrh r1,[r2,r1]
	orr r0,r0,r1,lsl#16
	str r0,[r12],#4
	tst r12,#0x1C
	bne obchr2
	sub r3,r3,#0x02
	tst r12,#0x20
	subne r3,r3,#0x1C

	tst r12,#0x4000
	beq obchr1

	ldmfd sp!,{r4-r6}
	bx lr
;----------------------------------------------------------------------------
paletteinit;	r0-r3 modified.
;called by ui.c:  void map_palette(char gammavalue)
;----------------------------------------------------------------------------
	stmfd sp!,{r4-r9,lr}
	ldr r8,prombase		;proms
	mov r7,#0x0F
	ldr r6,=MAPPED_RGB
	ldrb r1,gammavalue	;gamma value = 0 -> 4
	mov r4,#0			;Mr Do! bgr, r1=R, r2=G, r3=B
	mov r11,r11
nomap					;map 00bbggrr.00bbggrr  ->  0bbbbbgggggrrrrr
	and r0,r4,#0xE0
	and r2,r4,#0x03
	orr r0,r2,r0,lsr#3
	add r0,r0,#0x20
	ldrb r0,[r8,r0]
	and r2,r0,#0x30		;blue 1
	mov r9,r2,lsl#4
	and r2,r0,#0x0C		;green 1
	orr r9,r9,r2,lsl#2
	and r2,r0,#0x03		;red 1
	orr r9,r9,r2

	and r0,r4,#0x1F
	ldrb r0,[r8,r0]
	and r2,r0,#0x30		;blue 2
	orr r9,r9,r2,lsl#6
	and r2,r0,#0x0C		;green 2
	orr r9,r9,r2,lsl#4
	and r2,r0,#0x03		;red 2
	orr r9,r9,r2,lsl#2

	mov r0,r9,lsr#8		;Blue ready
	bl gprefix
	mov r5,r0

	and r0,r7,r9,lsr#4	;Green ready
	bl gprefix
	orr r5,r0,r5,lsl#5

	and r0,r7,r9		;Red ready
	bl gprefix
	orr r5,r0,r5,lsl#5

	strh r5,[r6],#2
	add r4,r4,#1
	cmp r4,#256			;256 CLUT
	bne nomap

	sub r6,r6,#512
	ldr r5,=PCEPALBUFF
;	mov r1,#128
;nomap3					;Bgr palette
;	subs r1,r1,#1
;	ldr r0,[r6,r1,lsl#2]
;	str r0,[r5,r1,lsl#2]
;	bne nomap3

	add r8,r8,#64		;PROM spr lut
	add r5,r5,#256*2
	mov r1,#0
nomap2					;Spr palette
	and r2,r1,#0x1F
	ldrb r0,[r8,r2]
	tst r1,#0x20
	andeq r0,r0,#0x0F
	movne r0,r0,lsr#4
	and r2,r0,#0x0C
	add r0,r0,r2,lsl#3
	mov r0,r0,lsl#1
	ldrh r0,[r6,r0]
	strh r0,[r5],#2
	add r1,r1,#1
	tst r1,#0x3
	addeq r5,r5,#0x18
	cmp r1,#64
	bne nomap2

	ldmfd sp!,{r4-r9,lr}
	bx lr
;----------------------------------------------------------------------------
gprefix
	orr r0,r0,r0,lsl#4
;----------------------------------------------------------------------------
gammaconvert;	takes value in r0(0-0xFF), gamma in r1(0-4),returns new value in r0=0x1F
;----------------------------------------------------------------------------
	rsb r2,r0,#0x100
	mul r3,r2,r2
	rsb r2,r3,#0x10000
	rsb r3,r1,#4
	orr r0,r0,r0,lsl#8
	mul r2,r1,r2
	mla r0,r3,r0,r2
	mov r0,r0,lsr#13

	bx lr
;----------------------------------------------------------------------------
PaletteTxAll		; Called from ui.c
;----------------------------------------------------------------------------
	ldr r1,=MAPPED_RGB+64*4
	ldr r2,=PCEPALBUFF
	mov r3,#16
ploop
	ldr r0,[r1],#4
	str r0,[r2],#4
	ldr r0,[r1],#4
	str r0,[r2],#28
	subs r3,r3,#1
	bne ploop

	bx lr

;----------------------------------------------------------------------------
showfps_		;fps output, r0-r3=used.
;----------------------------------------------------------------------------
	ldrb r0,fpschk
	subs r0,r0,#1
	movmi r0,#59
	strb r0,fpschk
	bxpl lr					;End if not 60 frames has passed

;	str lr,[sp,#-4]!
;	ldr r1,=StartRumbleComs
;	adr lr,ret_
;	bx r1
ret_
;	ldr lr,[sp],#4

	ldrb r0,fpsenabled
	tst r0,#1
	bxeq lr					;End if not enabled

	ldr r0,fpsvalue
	cmp r0,#0
	bxeq lr					;End if fps==0, to keep it from appearing in the menu
	mov r1,#0
	str r1,fpsvalue

	mov r1,#100
	swi 0x060000			;Division r0/r1, r0=result, r1=remainder.
	add r0,r0,#0x30
	strb r0,fpstext+5
	mov r0,r1
	mov r1,#10
	swi 0x060000			;Division r0/r1, r0=result, r1=remainder.
	add r0,r0,#0x30
	strb r0,fpstext+6
	add r1,r1,#0x30
	strb r1,fpstext+7
	

	adr r0,fpstext
	ldr r2,=DEBUGSCREEN
;	add r2,r2,r1,lsl#6
db1
	ldrb r1,[r0],#1
	orr r1,r1,#0x4100
	strh r1,[r2],#2
	tst r2,#0xE
	bne db1

	bx lr
;----------------------------------------------------------------------------
fpstext DCB "FPS:    "
fpsenabled DCB 0
fpschk	DCB 0
gammavalue DCB 0
		DCB 0
;----------------------------------------------------------------------------
debug_		;debug output, r0=val, r1=line, r2=used.
;----------------------------------------------------------------------------
 [ DEBUG
	ldr r2,=DEBUGSCREEN
	add r2,r2,r1,lsl#6
db0
	mov r0,r0,ror#28
	and r1,r0,#0x0f
	cmp r1,#9
	addhi r1,r1,#7
	add r1,r1,#0x30
	orr r1,r1,#0x4100
	strh r1,[r2],#2
	tst r2,#15
	bne db0
 ]
	bx lr
;----------------------------------------------------------------------------
;----------------------------------------------------------------------------
	AREA wram_code1, CODE, READWRITE
irqhandler	;r0-r3,r12 are safe to use
;----------------------------------------------------------------------------
	mov r2,#REG_BASE
	mov r3,#REG_BASE
	ldr r1,[r2,#REG_IE]!
	and r1,r1,r1,lsr#16	;r1=IE&IF
	ldrh r0,[r3,#-8]
	orr r0,r0,r1
	strh r0,[r3,#-8]

		;---these CAN'T be interrupted
		ands r0,r1,#0x80
		strneh r0,[r2,#2]		;IF clear
		bne RumbleInterrupt
		;---

		;---these CAN be interrupted
		ands r0,r1,#0x01
		ldrne r12,vblankfptr
		bne jmpintr
		;----
		adreq r12,irq0
		moveq r0,r1		;if unknown interrupt occured clear it.
jmpintr
	strh r0,[r2,#2]		;IF clear

	mrs r3,spsr
	stmfd sp!,{r3,lr}
	mrs r3,cpsr
	bic r3,r3,#0x9f
	orr r3,r3,#0x1f			;--> Enable IRQ . Set CPU mode to System.
	msr cpsr_cf,r3
	stmfd sp!,{lr}
	adr lr,irq0

	mov pc,r12


irq0
	ldmfd sp!,{lr}
	mrs r3,cpsr
	bic r3,r3,#0x9f
	orr r3,r3,#0x92        		;--> Disable IRQ. Set CPU mode to IRQ
	msr cpsr_cf,r3
	ldmfd sp!,{r0,lr}
	msr spsr_cf,r0
vbldummy
	bx lr
;----------------------------------------------------------------------------
vblankfptr DCD vbldummy			;later switched to vblankinterrupt
twitch DCB 0
flicker DCB 1
		DCB 0
		DCB 0
vblankinterrupt;
;----------------------------------------------------------------------------
	stmfd sp!,{r4-r7,globalptr,lr}
	ldr globalptr,=|wram_globals0$$Base|

	bl Vbl_Sound_1
	bl showfps_

	ldr r2,=DMA0BUFF	;setup DMA buffer for scrolling:
	add r3,r2,#160*8
	ldr r1,scrollY_bak
	ldrb r0,emuflags+1
	cmp r0,#SCALED
	bhs vblscaled

vblunscaled
	ldr r0,windowtop+12
	add r1,r1,r0
	mov r4,#8
	orr r0,r4,r0,lsl#16
	orr r1,r4,r1,lsl#16
vbl6
	stmia r2!,{r0,r1}
	cmp r2,r3
	bmi vbl6
	b vbl5

vblscaled					;(scaled)
	ldrb r0,ystart
	ldrb r5,flicker
	ldrb r4,twitch
	eors r4,r4,r5
	strb r4,twitch
	mov r0,r0,lsl#16
	orr r0,r0,#8
	add r1,r0,r1,lsl#16
	stmeqia r2!,{r0,r1}
		ldr r4,adjustblend
		ands r4,r4,#3
		beq vbl3
		cmp r4,#2
		bhi vbl2
vbl1
		addmi r0,r0,#0x00010000
		addmi r1,r1,#0x00010000
		stmia r2!,{r0,r1}
vbl2
		stmia r2!,{r0,r1}
vbl3
		stmia r2!,{r0,r1}

		stmia r2!,{r0,r1}

		stmia r2!,{r0,r1}
	cmp r2,r3
	bmi vbl1

vbl5


	mov r1,#REG_BASE
	strh r1,[r1,#REG_DM0CNT_H]		;DMA0 stop
	strh r1,[r1,#REG_DM3CNT_H]		;DMA3 stop

	add r2,r1,#REG_DM3SAD

	ldr r0,oambufferready
	cmp r0,#0
	ldrne r4,dmaoambuffer			;DMA3 src, OAM transfer:
	movne r5,#AGB_OAM				;DMA3 dst
	movne r6,#0x84000000			;noIRQ 32bit incsrc incdst
	orrne r6,r6,#0xc0				;96 sprites (768 bytes)
	stmneia r2,{r4-r6}				;DMA3 go

	ldrne r4,=PCEPALBUFF			;DMA3 src, Palette transfer:
	movne r5,#AGB_PALETTE			;DMA3 dst
	movne r6,#0x84000000			;noIRQ 32bit incsrc incdst
	orrne r6,r6,#0x100				;256 words (1024 bytes)
	stmneia r2,{r4-r6}				;DMA3 go
	mov r0,#0
	str r0,oambufferready

	ldr r0,=DMA0BUFF				;setup HBLANK DMA for display scroll:
	ldr r4,[r0],#4
	str r4,[r1,#REG_BG0HOFS]		;set 1st value manually, HBL is AFTER 1st line
	ldr r4,[r0],#4
	str r4,[r1,#REG_BG1HOFS]		;set 1st value manually, HBL is AFTER 1st line
	ldr r0,=0xA660					;noIRQ hblank 32bit repeat incsrc inc_reloaddst
	strh r0,[r1,#REG_DM0CNT_H]		;DMA0 go

	mov r0,#0x1740					;1d sprites, BG0/1/2 enable. OBJ enable, DISPCNTBUFF startvalue. 0x1540
	strh r0,[r1,#REG_DISPCNT]		;set value manually

exit_vbl
	bl Vbl_Sound_2
	ldmfd sp!,{r4-r7,globalptr,pc}


;------------------------------------------------------------------------------
newframe	;called before line 0	(r0-r9 safe to use)
;------------------------------------------------------------------------------
	mov r0,#0
	str r0,scanline			;reset scanline count
;--------------------------
	bx lr

;----------------------------------------------------------------------------
endframe	;called just before screen end (~line 240)	(r0-r2 safe to use)
;----------------------------------------------------------------------------
	stmfd sp!,{r3-r9,lr}

	bl bg_finish
;--------------------------
	bl sprDMA_do
;--------------------------
	ldr r0,scrollY
	str r0,scrollY_bak

	mrs r5,cpsr
	orr r1,r5,#0x80			;--> Disable IRQ.
	msr cpsr_cf,r1

	ldr r0,dmaoambuffer
	ldr r1,tmpoambuffer
	str r0,tmpoambuffer
	str r1,dmaoambuffer

	mov r0,#1
	str r0,oambufferready

	adrl r0,windowtop		;load wtop, store in wtop+4.......load wtop+8, store in wtop+12
	ldmia r0,{r1-r3}		;load with post increment
	stmib r0,{r1-r3}		;store with pre increment

	msr cpsr_cf,r5			;--> restore mode,Enable IRQ.


	ldmfd sp!,{r3-r9,lr}
	bx lr
;----------------------------------------------------------------------------
sprDMA_do			;Called from endframe. YATX
;----------------------------------------------------------------------------
PRIORITY EQU 0x800				;0x800=AGB OBJ priority 2
	str lr,[sp,#-4]!


	ldr addy,=SPR_RAM			;Source
	ldr r2,tmpoambuffer			;Destination

	ldr r1,emuflags
	and r5,r1,#0x300
	cmp r5,#SCALED_SPRITES*256
	mov r6,#0x40000000			;16x16 size
	orreq r6,r6,#0x100			;r6= scale obj

	mov r0,#0
	ldrb r4,ystart				;first scanline?
	cmp r5,#UNSCALED_AUTO*256	;do autoscroll
	bhi dm2
	movle r4,#0
	bne dm0
;	ldr r3,AGBjoypad
;	ands r3,r3,#0x300
;	eornes r3,r3,#0x300
;	bne dm0						;stop if L or R pressed (manual scroll)
	ldr r5,=EMU_RAM1
	ldrb r0,[r5,#0x1C6]			;follow memory
	add r0,r0,r0,lsr#2
	mov r0,r0,lsr#2
	add r0,r0,#0x0B
	cmp r0,#0x20
	movmi r0,#0x20
	cmp r0,#0x40
	movpl r0,#0x40
	str r0,windowtop
dm0
	ldr r0,windowtop+8
dm2
	add r4,r4,r0
	ldr r5,=YSCALE_LOOKUP
	sub r5,r5,r4
	ldr r7,=0xff
	mov r8,#64					;number of sprites
dm11
	ldr r4,[addy],#4			;Mr. Do! OBJ, r4=Ypos,Tile,Attrib,Ypos.
	rsb r0,r4,#0x00
	and r0,r7,r0,lsr#8			;mask Y
	sub r3,r4,#0x08000000
	and r3,r3,#0xFF000000

	ldrb r0,[r5,r0]				;y = scaled y
	orr r0,r0,r6				;size + scaling
	orr r0,r0,r3,lsr#8

	and r1,r4,#0x300000
	orr r0,r0,r1,lsl#8
	str r0,[r2],#4				;store OBJ Atr 0,1. Xpos, ypos, flip, scale/rot, size, shape.

	and r0,r4,#0xFF
	mov r0,r0,lsl#2
	and r1,r4,#0x0F0000			;color
	orr r0,r0,r1,lsr#4
	orr r0,r0,#PRIORITY			;priority
	strh r0,[r2],#4				;store OBJ Atr 2. Pattern, palette.
dm9
	subs r8,r8,#1
	bne dm11
	ldr pc,[sp],#4

;----------------------------------------------------------------------------

tmpoambuffer	DCD OAM_BUFFER1
dmaoambuffer	DCD OAM_BUFFER2

oambufferready	DCD 0
pcepaletteready	DCD 0
;----------------------------------------------------------------------------
	AREA wram_globals1, CODE, READWRITE

FPSValue
	DCD 0
AGBinput			;this label here for main.c to use
	DCD 0 			;AGBjoypad (why is this in gfx.s again?  um.. i forget)
EMUinput	DCD 0	;EMUjoypad (this is what EMU sees)
	DCD 1			;adjustblend
	DCD 0			;windowtop
wtop	DCD 0,0,0	;windowtop  (this label too)   L/R scrolling in unscaled mode
gfxstate
	DCD 0 ;scrollY
	DCD 0 ;scrollY_bak

	DCB 0 ;irqControl
	DCB 0 ;irqPending
	DCB 0 ;ystart
	DCB 0 ;sprBank
	DCB 0 ;sprmemalloc
	DCB 0 ;sprmemreload
;...update load/savestate if you move things around in here
;----------------------------------------------------------------------------
	END

