	INCLUDE equates.h
	INCLUDE memory.h
	INCLUDE io.h
	INCLUDE sn76496.h
	INCLUDE sn76496_equ.h

	EXPORT Sound_init
	EXPORT Sound_reset
	EXPORT soundmode
	EXPORT Vbl_Sound_1
	EXPORT Vbl_Sound_2
	EXPORT SN_0_W
	EXPORT SN_1_W

;----------------------------------------------------------------------------

 AREA rom_code, CODE, READONLY ;-- - - - - - - - - - - - - - - - - - - - - -

;----------------------------------------------------------------------------
Sound_init
;----------------------------------------------------------------------------
	stmfd sp!,{r3-r5,lr}
	mov r5,#REG_BASE

;	ldrh r0,[r5,#REG_SGBIAS]
;	bic r0,r0,#0xc000				;just change bits we know about.
;	orr r0,r0,#0x8000				;PWM 7-bit 131.072kHz
;	strh r0,[r5,#REG_SGBIAS]

	ldr r2,soundmode				;if r2=0, no sound.
	cmp r2,#1

	movmi r0,#0
;	ldreq r0,=0xbb0c0000			;use directsound A&B->L&R, 100% volume, timer 0. CRAP!
	ldreq r0,=0xbb000000			;use directsound A&B->L&R, 50% volume, timer 0
;	ldreq r0,=0x9a0c0000			;use directsound A->L & B->R, 100% volume, timer 0
	str r0,[r5,#REG_SGCNT_L]

	moveq r0,#0x80
	strh r0,[r5,#REG_SGCNT_X]		;sound master enable

	mov r0,#0						;triangle reset
	str r0,[r5,#REG_SG3CNT_L]		;sound3 disable, mute, write bank 0

									;Mixer channels
	strh r5,[r5,#REG_DM1CNT_H]		;DMA1 stop, SN76496-0
	strh r5,[r5,#REG_DM2CNT_H]		;DMA2 stop, SN76496-1
	add r0,r5,#REG_FIFO_A_L			;DMA1 destination..
	str r0,[r5,#REG_DM1DAD]
	add r0,r5,#REG_FIFO_B_L			;DMA2 destination..
	str r0,[r5,#REG_DM2DAD]
	ldr r0,pcmptr0
	str r0,[r5,#REG_DM1SAD]			;DMA1 src=..
	add r0,r0,#PCMWAVSIZE*2
	str r0,[r5,#REG_DM2SAD]			;DMA2 src=..

	mov r4,#1						;mixrate

	adr r0,SN76496_0
	mov r1,r4
	bl SN76496_set_mixrate			;sound, 0=low, 1=high mixrate
	ldr r1,=4000000
	bl SN76496_set_frequency		;sound, chip frequency
	bl SN76496_init					;sound

	adr r0,SN76496_1
	mov r1,r4
	bl SN76496_set_mixrate			;sound, 0=low, 1=high mixrate
	ldr r1,=4000000
	bl SN76496_set_frequency		;sound, chip frequency
	bl SN76496_init					;sound


	ldr r2,soundmode				;if r2=0, no sound.
	cmp r2,#1

	add r1,r5,#REG_TM0CNT_L			;timer 0 controls sample rate:
	mov r4,#0
	str r4,[r1]						;stop timer 0
	ldr r3,mixrate					; 924=Low, 532=High.
	mov r2,#0x10000					;frequency = 0
	subeq r4,r2,r3					;frequency = 0x1000000/r3 Hz
	orreq r4,r4,#0x800000			;timer 0 on
	str r4,[r1]

	ldmfd sp!,{r3-r5,lr}
	bx lr

;----------------------------------------------------------------------------
Sound_reset
;----------------------------------------------------------------------------
	stmfd sp!,{lr}
	adr r0,SN76496_0
	bl SN76496_reset				;sound
	adr r0,SN76496_1
	bl SN76496_reset				;sound
	ldmfd sp!,{lr}
	bx lr

;----------------------------------------------------------------------------
Vbl_Sound_1
;----------------------------------------------------------------------------
	ldr r0,soundmode				;if r0=0, no sound.
	cmp r0,#0
	moveq pc,lr


	mov r1,#REG_BASE
	strh r1,[r1,#REG_DM1CNT_H]		;DMA1 stop
	strh r1,[r1,#REG_DM2CNT_H]		;DMA2 stop
	ldr r2,pcmptr0
	str r2,[r1,#REG_DM1SAD]			;DMA1 src=..
	add r0,r2,#PCMWAVSIZE*2
	str r0,[r1,#REG_DM2SAD]			;DMA2 src=..
	ldr r0,=0xB640					;noIRQ fifo 32bit repeat incsrc fixeddst
	strh r0,[r1,#REG_DM1CNT_H]		;DMA1 go
	strh r0,[r1,#REG_DM2CNT_H]		;DMA2 go

	ldr r1,pcmptr1
	str r1,pcmptr0
	str r2,pcmptr1

	adr r0,SN76496_0
	str r1,pcmptr
	adr r0,SN76496_1
	add r1,r1,#PCMWAVSIZE*2
	str r1,pcmptr

	mov pc,lr
;----------------------------------------------------------------------------
Vbl_Sound_2
;----------------------------------------------------------------------------
	;update DMA buffer for PCM
	ldr r0,soundmode				;if r0=0, no sound.
	cmp r0,#0
	moveq pc,lr

	stmfd sp!,{lr}
	adr r0,SN76496_0
	bl SN76496_Mixer
	adr r0,SN76496_1
	bl SN76496_Mixer
	ldmfd sp!,{pc}

;----------------------------------------------------------------------------
SN_0_W
;----------------------------------------------------------------------------
	stmfd sp!,{r3,lr}
	mov r1,r0
	adr r0,SN76496_0
	bl SN76496_W
	ldmfd sp!,{r3,pc}
;----------------------------------------------------------------------------
SN_1_W
;----------------------------------------------------------------------------
	stmfd sp!,{r3,lr}
	mov r1,r0
	adr r0,SN76496_1
	bl SN76496_W
	ldmfd sp!,{r3,pc}

;----------------------------------------------------------------------------

soundmode	DCD 1		;soundmode (OFF/ON)

pcmptr0 DCD PCMWAV
pcmptr1 DCD PCMWAV+PCMWAVSIZE

SN76496_0
		% 68
SN76496_1
		% 68
;----------------------------------------------------------------------------
	END

