	INCLUDE equates.h
	INCLUDE memory.h
	INCLUDE gfx.h
	INCLUDE cart.h
	INCLUDE z80.h
	INCLUDE sound.h

	EXPORT IO_reset
	EXPORT IO_S_R
	EXPORT IO_R
	EXPORT IO_W
	EXPORT Z80_IN
	EXPORT Z80_OUT
	EXPORT Z80_IN_C
	EXPORT Z80_OUT_C
	EXPORT joycfg
	EXPORT spriteinit
	EXPORT suspend
	EXPORT refreshEMUjoypads
	EXPORT resetSIO
	EXPORT thumbcall_r1
	EXPORT gettime
	EXPORT Bin2BCD
	EXPORT vbaprint
	EXPORT waitframe
	EXPORT LZ77UnCompVram
	EXPORT CheckGBAVersion


 AREA rom_code, CODE, READONLY ;-- - - - - - - - - - - - - - - - - - - - - -

vbaprint
	swi 0xFF0000		;!!!!!!! Doesn't work on hardware !!!!!!!
	bx lr
LZ77UnCompVram
	swi 0x120000
	bx lr
waitframe
VblWait
	mov r0,#0				;don't wait if not necessary
	mov r1,#1				;VBL wait
	swi 0x040000			; Turn of CPU until VBLIRQ if not too late allready.
	bx lr
CheckGBAVersion
	ldr r0,=0x5AB07A6E		;Fool proofing
	mov r12,#0
	swi 0x0D0000			;GetBIOSChecksum
	ldr r1,=0xABBE687E		;Proto GBA
	cmp r0,r1
	moveq r12,#1
	ldr r1,=0xBAAE187F		;Normal GBA
	cmp r0,r1
	moveq r12,#2
	ldr r1,=0xBAAE1880		;Nintendo DS
	cmp r0,r1
	moveq r12,#4
	mov r0,r12
	bx lr

scaleparms;	   NH     FH     NV     FV
	DCD 0x0000,0x0100,0xff01,0x0120,0xfee0,OAM_BUFFER1+6,AGB_OAM+774
;----------------------------------------------------------------------------
IO_reset
;----------------------------------------------------------------------------
	adr r6,scaleparms		;set sprite scaling params
	ldmia r6,{r0-r6}

	mov r7,#2
scaleloop
	strh r1,[r5],#8				;buffer1, buffer2
	strh r0,[r5],#8
	strh r0,[r5],#8
	strh r3,[r5],#232
		strh r2,[r5],#8
		strh r0,[r5],#8
		strh r0,[r5],#8
		strh r3,[r5],#232
			strh r1,[r5],#8
			strh r0,[r5],#8
			strh r0,[r5],#8
			strh r4,[r5],#232
	subs r7,r7,#1
	bne scaleloop

	strh r2,[r6],#8				;7000200
	strh r0,[r6],#8
	strh r0,[r6],#8
	strh r4,[r6]


	ldrb r0,emuflags+1
	;..to spriteinit
;----------------------------------------------------------------------------
spriteinit	;build yscale_lookup tbl (called by ui.c) r0=scaletype
;called by ui.c:  void spriteinit(char scaletype) (pass scaletype in r0 because globals ptr isn't set up to read it)
;----------------------------------------------------------------------------
	ldr r3,=YSCALE_LOOKUP
	cmp r0,#SCALED
	bpl si1

;------------------ unscaled
si5
	sub r3,r3,#16
	sub r2,r3,#224-160
	mov r0,#164
si2	strb r0,[r2],#1
	cmp r2,r3
	bne si2

	add r2,r3,#256+16
	mov r0,#-15
si3	strb r0,[r3],#1
	add r0,r0,#1
	cmp r0,#164
	movpl r0,#164
	cmp r2,r3
	bne si3
	bx lr

;------------------ scaled
si1
	sub r3,r3,#240-224
;	mov r0,#0x0000c000		;0.75
;	ldr r1,=0xfff10000		;-(16)*0.75
	ldr r0,=0x0000D555		;5/6
	ldr r1,=0xfff20000		;-(16)*0.75
si4	mov r2,r1,lsr#16
	strb r2,[r3],#1
	add r1,r1,r0
	cmp r2,#0xe0
	bne si4
	bx lr
;----------------------------------------------------------------------------
suspend	;called from ui.c and z80.s
;----------------------------------------------------------------------------
	mov r3,#REG_BASE

	ldr r1,=REG_P1CNT
	ldr r0,=0xc00c			;interrupt on start+sel
	strh r0,[r3,r1]

	ldrh r1,[r3,#REG_SGCNT_L]
	strh r3,[r3,#REG_SGCNT_L]	;sound off

	ldrh r0,[r3,#REG_DISPCNT]
	orr r0,r0,#0x80
	strh r0,[r3,#REG_DISPCNT]	;LCD off

	swi 0x030000

	ldrh r0,[r3,#REG_DISPCNT]
	bic r0,r0,#0x80
	strh r0,[r3,#REG_DISPCNT]	;LCD on

	strh r1,[r3,#REG_SGCNT_L]	;sound on

	bx lr
;----------------------------------------------------------------------------
gettime	;called from ui.c
;----------------------------------------------------------------------------
	ldr r3,=0x080000c4		;base address for RTC
	mov r1,#1
	strh r1,[r3,#4]			;enable RTC
	mov r1,#7
	strh r1,[r3,#2]			;enable write

	mov r1,#1
	strh r1,[r3]
	mov r1,#5
	strh r1,[r3]			;State=Command

	mov r2,#0x65			;r2=Command, YY:MM:DD 00 hh:mm:ss
	mov addy,#8
RTCLoop1
	mov r1,#2
	and r1,r1,r2,lsr#6
	orr r1,r1,#4
	strh r1,[r3]
	mov r1,r2,lsr#6
	orr r1,r1,#5
	strh r1,[r3]
	mov r2,r2,lsl#1
	subs addy,addy,#1
	bne RTCLoop1

	mov r1,#5
	strh r1,[r3,#2]			;enable read
	mov r2,#0
	mov addy,#32
RTCLoop2
	mov r1,#4
	strh r1,[r3]
	mov r1,#5
	strh r1,[r3]
	ldrh r1,[r3]
	and r1,r1,#2
	mov r2,r2,lsr#1
	orr r2,r2,r1,lsl#30
	subs addy,addy,#1
	bne RTCLoop2

	mov r0,#0
	mov addy,#24
RTCLoop3
	mov r1,#4
	strh r1,[r3]
	mov r1,#5
	strh r1,[r3]
	ldrh r1,[r3]
	and r1,r1,#2
	mov r0,r0,lsr#1
	orr r0,r0,r1,lsl#22
	subs addy,addy,#1
	bne RTCLoop3

	bx lr
;----------------------------------------------------------------------------
Bin2BCD		;called from ui.c
;----------------------------------------------------------------------------
	stmfd sp!,{r4}

	mov r1,#0
	adr r3,BCD_table				;BCD
	ldr r12,=0x11111110				;carry count mask value

Bin2BCD_loop
	ldr r2,[r3],#4					;BCD (read BCD table)
	movs r0,r0,lsr#1				;test bit

	bcc Bin2BCD_loop_check
Bin2BCD_calc
	add r4,r2,r1					;r4 = r2 + r1
	eor r2,r1,r2					;r2 = r1 XOR r2
	eor r2,r4,r2					;r2 = r4 XOR r2
	bic r2,r12,r2					;r2 = 0x11111110 AND NOT r2
	orr r2,r2,r2,lsr#1				;r2 = r2 OR (r2 LSR 1)
	sub r1,r4,r2,lsr#2				;r1 = r4 -  (r2 LSR 2)

Bin2BCD_loop_check
	bne Bin2BCD_loop
	mov r0,r1

	ldmfd sp!,{r4}
	bx lr

BCD_table
	DCD 0x06666667
	DCD 0x06666668
	DCD 0x0666666a
	DCD 0x0666666e
	DCD 0x0666667c
	DCD 0x06666698
	DCD 0x066666ca
	DCD 0x0666678e
	DCD 0x066668bc
	DCD 0x06666b78
	DCD 0x0666768a
	DCD 0x066686ae
	DCD 0x0666a6fc
	DCD 0x0666e7f8
	DCD 0x0667c9ea
	DCD 0x06698dce
	DCD 0x066cbb9c
	DCD 0x067976d8
	DCD 0x068c87aa
	DCD 0x06b8a8ee
	DCD 0x076aebdc
	DCD 0x086fd7b8
	DCD 0x0a7fa96a
	DCD 0x0e9eec6e
	DCD 0x1cddd87c
	DCD 0x39bbaa98
	DCD 0x6d76eeca

;----------------------------------------------------------------------------
resetSIO	;r0=joycfg
;----------------------------------------------------------------------------
	bic r0,r0,#0x0f000000
	str r0,joycfg

	mov r2,#2		;only 2 players.
	mov r1,r0,lsr#29
	cmp r1,#0x6
	moveq r2,#4		;all 4 players
	cmp r1,#0x5
	moveq r2,#3		;3 players.
	str r2,nrplayers

	mov r2,#REG_BASE
	add r2,r2,#0x100

	mov r1,#0
	strh r1,[r2,#REG_RCNT]

	tst r0,#0x80000000
	moveq r1,#0x2000
	movne r1,   #0x6000
	addne r1,r1,#0x0002	;16bit multiplayer, 57600bps
	strh r1,[r2,#REG_SIOCNT]

	bx lr
;----------------------------------------------------------------------------
refreshEMUjoypads	;call every frame
;----------------------------------------------------------------------------

		ldr r4,frame
		movs r0,r4,lsr#2 ;C=frame&2 (autofire alternates every other frame)
	ldr r4,EMUjoypad
	mov r0,r4,lsr#4
		ldr r2,joycfg
		andcs r4,r4,r2
		movcss addy,r4,lsr#10	;L?
		andcs r4,r4,r2,lsr#16
	and r0,r0,#0x0f
	adr r1,rlud2lrud
	ldrb r0,[r1,r0]
	mov r1,#0
	tst r4,#0x1					;A
	orrne r1,r1,#0xC0			;Coin 1 & 2
	tst r4,#0x2					;B
	orrne r0,r0,#0x60			;Start 1 & 2
	tst r4,#0xC					;Select/Start
	orrne r0,r0,#0x10			;Shoot

	tst r2,#0x20000000			;Player2?
	orrne r1,r1,r0
	andne r1,r1,#0x9F
	andeq r1,r1,#0x40
	andne r0,r0,#0xC0
	andeq r0,r0,#0xBF

	strb r0,joy0state
	strb r1,joy1state
	ands r0,r0,#0		;Z=1
	mov pc,lr

joycfg DCD 0x40ff01ff ;byte0=auto mask, byte1=(saves R), byte2=R auto mask
;bit 31=single/multi, 30,29=1P/2P, 27=(multi) link active, 24=reset signal received
nrplayers DCD 0		;Number of players in multilink.
joySerial DCB 0
joy0state DCB 0
joy1state DCB 0
joy2state DCB 0
rlud2lrud	DCB 0x00,0x08,0x02,0x0a, 0x01,0x09,0x03,0x0b, 0x04,0x0c,0x06,0x0e, 0x05,0x0d,0x07,0x0f

;----------------------------------------------------------------------------
Input0_R		;Player1, Start
;----------------------------------------------------------------------------
;	mov r11,r11					;No$GBA breakpoint
	ldrb r0,joy0state
	eor r0,r0,#0xFF
	mov pc,lr
;----------------------------------------------------------------------------
Input1_R		;Player2, Coins
;----------------------------------------------------------------------------
;	mov r11,r11					;No$GBA breakpoint
	ldrb r0,joy1state
	eor r0,r0,#0xFF
	mov pc,lr
;----------------------------------------------------------------------------
;Input2_R		;Coins, Start & Service
;----------------------------------------------------------------------------
;	mov r11,r11					;No$GBA breakpoint
;	ldrb r0,joy2state
;	eor r0,r0,#0xFF
;	mov pc,lr
;----------------------------------------------------------------------------
Input2_R
;----------------------------------------------------------------------------
	ldrb r0,dipswitch0
	eor r0,r0,#0xFF
	mov pc,lr
;----------------------------------------------------------------------------
Input3_R
;----------------------------------------------------------------------------
	ldrb r0,dipswitch1
	eor r0,r0,#0xFF
	mov pc,lr

;----------------------------------------------------------------------------
;--------------------------------------------------
	INCLUDE visoly.s
 AREA wram_code1, CODE, READWRITE
;-- - - - - - - - - - - - - - - - - - - - - -

thumbcall_r1 bx r1

;----------------------------------------------------------------------------
IO_S_R		;I/O secret read, 0x9803
;----------------------------------------------------------------------------
	mov r0,#0
	sub r1,addy,#0x9800
	cmp r1,#3
	bxne lr
	mov addy,z80hl,lsr#16
	and r1,addy,#0xE000
	adr r2,readmem_tbl
	ldr pc,[r2,r1,lsr#11]	;in: addy,r1=addy&0xE000 (for rom_R)
;----------------------------------------------------------------------------
IO_R		;I/O read, 0xA000-0xBFFFF
;----------------------------------------------------------------------------
;	mov r11,r11					;No$GBA breakpoint
	subs r1,addy,#0xA000
	beq Input0_R
	cmp r1,#0x01
	beq Input1_R
	cmp r1,#0x02
	beq Input2_R
	cmp r1,#0x03
	beq Input3_R
	b empty_IO_R


;----------------------------------------------------------------------------
Z80_IN_C
;----------------------------------------------------------------------------
	mov addy,z80bc,lsr#16
;----------------------------------------------------------------------------
Z80_IN
;----------------------------------------------------------------------------
	mov r11,r11					;No$GBA breakpoint
	bx lr
;----------------------------------------------------------------------------
Z80_OUT_C
;----------------------------------------------------------------------------
	mov addy,z80bc,lsr#16
;----------------------------------------------------------------------------
Z80_OUT
;----------------------------------------------------------------------------
	mov r11,r11					;No$GBA breakpoint
	bx lr
;----------------------------------------------------------------------------
IO_W		;I/O write, 0x9000-0x9FFFF & 0xF000-0xFFFFF
;----------------------------------------------------------------------------
;	mov r11,r11					;No$GBA breakpoint
	tst addy,#0x6000
	bne High_W
	ands r1,addy,#0x6F00
	beq Spr_W					;0x9000 - 0x90FF
	and r1,addy,#0xFF00
	cmp r1,#0x9800
	bxne lr

	ands r1,addy,#0xFF
	beq Flip_W					;0x9800
	cmp r1,#1
	beq SN_0_W				;0x9801
	cmp r1,#2
	beq SN_1_W				;0x9802
	bx lr

High_W
	tst addy,#0x0800
	beq Scrl_x_W				;0xF000 - 0xF7FF
	bne Scrl_y_W				;0xF800 - 0xFFFF
;----------------------------------------------------------------------------
Spr_W
;----------------------------------------------------------------------------
	and r1,addy,#0xFF
	ldr r2,=SPR_RAM
	strb r0,[r2,r1]
	bx lr

;----------------------------------------------------------------------------
Scrl_x_W
;----------------------------------------------------------------------------
	bx lr
;----------------------------------------------------------------------------
Scrl_y_W
;----------------------------------------------------------------------------
	strb r0,scrollY
	bx lr
;----------------------------------------------------------------------------
Flip_W
;----------------------------------------------------------------------------
	strb r0,irqControl
	bx lr
;----------------------------------------------------------------------------
WatchDog_W
;----------------------------------------------------------------------------
	bx lr
;----------------------------------------------------------------------------
Coin_W
;----------------------------------------------------------------------------
;	mov r11,r11				;No$GBA breakpoint
	tst r0,#1
	ldrne r1,coincounter0
	addne r1,r1,#1
	strne r1,coincounter0
;	tst r0,#2
;	ldrne r1,coincounter1
;	addne r1,r1,#1
;	strne r1,coincounter1
	bx lr
;----------------------------------------------------------------------------
	END
