#define STRICT
#include <windows.h>
#include <mmsystem.h>
#include <process.h>
#include "wintimer.h"
#include "winthread.h"

static struct SFrameTimerThreadParams {
	HWND hWnd;
	DWORD ms;
	void (*FrameTimerProc)(void *tParams);
	void *tParams;
	HANDLE FrameTimerThread;
	HANDLE hFrameTimerThreadEvent;
	BOOL init_success;
	BOOL exit;
} FrameTimerThreadParams = {
	0,
	0,
	NULL,
	NULL,
	0,
	FALSE,
	FALSE,
	TRUE,
};
static HANDLE hFrameTimerEvent0 = FALSE;
static HANDLE hFrameTimerThreadEvent0 = FALSE;
static HANDLE hFrameTimerThreadEvent1 = FALSE;
static unsigned FrameTimerThreadID;

static unsigned __stdcall FrameTimerThread(void *tParams)
{
	SFrameTimerThreadParams *tp = (SFrameTimerThreadParams *)tParams;
	win_init_thread(tp->hWnd);

	TIMECAPS tc;
	if(timeGetDevCaps(&tc, sizeof(TIMECAPS))== TIMERR_NOERROR)
		timeBeginPeriod(tc.wPeriodMin);
	else
		tc.wPeriodMin = 0;

	HANDLE hFrameTimerEvent = OpenEvent(EVENT_MODIFY_STATE, FALSE, "wintimer-hFrameTimerEvent");
	HANDLE hFrameTimerWaitEvent = OpenEvent(SYNCHRONIZE, FALSE, "wintimer-hFrameTimerEvent");
	UINT uDelay = (UINT)tc.wPeriodMin;
	UINT TimerID;

	if(hFrameTimerEvent == FALSE ||
	   hFrameTimerWaitEvent == FALSE ||
	   (TimerID = timeSetEvent(uDelay,
							   0,
							   (LPTIMECALLBACK)hFrameTimerEvent,
							   0,
							   TIME_PERIODIC | TIME_CALLBACK_EVENT_SET)) == (UINT)NULL) {

		if(hFrameTimerWaitEvent != FALSE)
			CloseHandle(hFrameTimerWaitEvent);
		if(hFrameTimerEvent != FALSE)
			CloseHandle(hFrameTimerEvent);

		if(tc.wPeriodMin)
			timeEndPeriod(tc.wPeriodMin);

		SetEvent(tp->hFrameTimerThreadEvent);
		win_exit_thread();
		_endthreadex(0);
		return 0;
	}

	tp->init_success = TRUE;
	SetEvent(tp->hFrameTimerThreadEvent);

	// NTSC
	if(tp->ms == 16) {
		int NtscMsCount6 = 0;
		DWORD NtscMs[6] = {16, 17, 17, 16, 17, 17};
		DWORD last_ms = timeGetTime();
		while(tp->exit == FALSE) {
			WaitForSingleObject(hFrameTimerWaitEvent, INFINITE);
			DWORD cur_ms = timeGetTime();
			while((cur_ms - last_ms) >= NtscMs[NtscMsCount6]) {
				last_ms = last_ms + NtscMs[NtscMsCount6];
				tp->FrameTimerProc(tp->tParams);
				NtscMsCount6 = (NtscMsCount6 + 1) % 6;
			}
		}
	}
	// PAL
	else if(tp->ms == 20) {
		DWORD last_ms = timeGetTime();
		while(tp->exit == FALSE) {
			WaitForSingleObject(hFrameTimerWaitEvent, INFINITE);
			DWORD cur_ms = timeGetTime();
			while((cur_ms - last_ms) >= tp->ms) {
				last_ms = last_ms + tp->ms;
				tp->FrameTimerProc(tp->tParams);
			}
		}
	}
	// ms
	else {
		DWORD last_ms = timeGetTime();
		while(tp->exit == FALSE) {
			WaitForSingleObject(hFrameTimerWaitEvent, INFINITE);
			DWORD cur_ms = timeGetTime();
			while((cur_ms - last_ms) >= tp->ms) {
				last_ms = last_ms + tp->ms;
				tp->FrameTimerProc(tp->tParams);
			}
		}
	}

	timeKillEvent(TimerID);

	CloseHandle(hFrameTimerWaitEvent);
	CloseHandle(hFrameTimerEvent);

	if(tc.wPeriodMin)
		timeEndPeriod(tc.wPeriodMin);

	win_exit_thread();
	_endthreadex(0);
	return 0;
}


static void ReleaseFrameTimer()
{
	//Release FrameTimer
	if(FrameTimerThreadParams.exit == FALSE) {
		SetThreadPriority(FrameTimerThreadParams.FrameTimerThread,
						  THREAD_PRIORITY_NORMAL);
		FrameTimerThreadParams.exit = TRUE;
		WaitForSingleObject(FrameTimerThreadParams.FrameTimerThread, INFINITE);
		CloseHandle(FrameTimerThreadParams.FrameTimerThread);
		FrameTimerThreadParams.FrameTimerThread = 0;
	}
	if(FrameTimerThreadParams.hFrameTimerThreadEvent != FALSE) {
		CloseHandle(FrameTimerThreadParams.hFrameTimerThreadEvent);
		FrameTimerThreadParams.hFrameTimerThreadEvent = FALSE;
	}
	if(hFrameTimerThreadEvent1 != FALSE) {
		CloseHandle(hFrameTimerThreadEvent1);
		hFrameTimerThreadEvent1 = FALSE;
	}
	if(hFrameTimerThreadEvent0 != FALSE) {
		CloseHandle(hFrameTimerThreadEvent0);
		hFrameTimerThreadEvent0 = FALSE;
	}
	if(hFrameTimerEvent0 != FALSE) {
		CloseHandle(hFrameTimerEvent0);
		hFrameTimerEvent0 = FALSE;
	}
}

BOOL SetupFrameTimer(DWORD ms,
					 void (*FrameTimerProc)(void *tParams),
					 void *tParams, HWND hWnd)
{
	ReleaseFrameTimer();
	if(ms == 0)
		return true;

	if(FrameTimerProc == NULL)
		return false;

	hFrameTimerEvent0 = CreateEvent(NULL, FALSE, FALSE, "wintimer-hFrameTimerEvent");
	hFrameTimerThreadEvent0 = CreateEvent(NULL, FALSE, FALSE, "wintimer-hFrameTimerThreadEvent");

	if(hFrameTimerEvent0 == FALSE ||
	   hFrameTimerThreadEvent0 == FALSE) {
		ReleaseFrameTimer();
		return false;
	}

	hFrameTimerThreadEvent1 = OpenEvent(SYNCHRONIZE,
										FALSE,
										"wintimer-hFrameTimerThreadEvent");
	FrameTimerThreadParams.hFrameTimerThreadEvent = OpenEvent(EVENT_MODIFY_STATE,
															  FALSE,
															  "wintimer-hFrameTimerThreadEvent");

	if(hFrameTimerThreadEvent1 == FALSE ||
	   FrameTimerThreadParams.hFrameTimerThreadEvent == FALSE) {
		ReleaseFrameTimer();
		return false;
	}

	//Set thread params.
	FrameTimerThreadParams.hWnd = hWnd;
	FrameTimerThreadParams.ms = ms;
	FrameTimerThreadParams.FrameTimerProc = FrameTimerProc;
	FrameTimerThreadParams.tParams = tParams;
	FrameTimerThreadParams.init_success = FALSE;
	FrameTimerThreadParams.exit = FALSE;

	FrameTimerThreadParams.FrameTimerThread = (HANDLE)_beginthreadex(NULL,
																	 0,
																	 &FrameTimerThread,
																	 &FrameTimerThreadParams,
																	 0,
																	 &FrameTimerThreadID);
	if((int)FrameTimerThreadParams.FrameTimerThread == 0) {
		FrameTimerThreadParams.exit = TRUE;
		ReleaseFrameTimer();
		return false;
	}

	// init_success?
	WaitForSingleObject(hFrameTimerThreadEvent1, INFINITE);
	if(FrameTimerThreadParams.init_success == FALSE) {
		//Wait thread end.
		WaitForSingleObject(FrameTimerThreadParams.FrameTimerThread, INFINITE);
		FrameTimerThreadParams.exit = TRUE;
		CloseHandle(FrameTimerThreadParams.FrameTimerThread);
		FrameTimerThreadParams.FrameTimerThread = 0;
		ReleaseFrameTimer();
		return false;
	}
	SetThreadPriority(FrameTimerThreadParams.FrameTimerThread, THREAD_PRIORITY_TIME_CRITICAL);
	return true;
}

