#define STRICT
#include <windows.h>
#include <mmsystem.h>
#include <objbase.h>
#include "winthread.h"

//This is Allegro - A game programming library's code
typedef HRESULT(CALLBACK * _CoInitializeEx_ptr) (LPVOID, DWORD);
static _CoInitializeEx_ptr _CoInitializeEx = NULL;
#define _COINIT_MULTITHREADED 0
static int first_call = 1;

/* win_init_thread:
 *  initializes com
 */
void win_init_thread(HWND hWnd)
{
	HMODULE ole32 = NULL;

	if (first_call) {
		first_call = 0;
		ole32 = GetModuleHandle("OLE32.DLL");
		if (ole32 != NULL) {
			 _CoInitializeEx = (_CoInitializeEx_ptr) GetProcAddress(
								ole32, "CoInitializeEx");
		}
		else {
			MessageBox(hWnd,
			"OLE32.DLL can't be loaded.", "Warning", MB_ICONWARNING + MB_OK);
		}

		if (_CoInitializeEx == NULL) {
			MessageBox(hWnd,
				"Microsoft Distributed COM is not installed on this system. If you have problems "
				"with this application, please install the DCOM update. You can find it on the "
				"Microsoft homepage.", "DCOM not found", MB_ICONWARNING + MB_OK);
		}
	}

	if (_CoInitializeEx != NULL)
		_CoInitializeEx(NULL, _COINIT_MULTITHREADED);
	else
		CoInitialize(NULL);
	return;
}


/* win_exit_thread:
 *  shutdown com
 */
void win_exit_thread()
{
	CoUninitialize();
}

