#ifndef _WINDRAW_H_
#define _WINDRAW_H_

#include <ddraw.h>

struct SDirectX
{
	HWND  hWnd;
	DWORD dwStyleWindowed;
	DWORD dwStyleFullScreen;

	//Client Rect, .left == 0 .top == 0
	RECT ClientRect;

	//Screen xy Client Rect
	RECT sClientRect;

	bool DDAvailable;
	HRESULT dErr;

	LPDIRECTDRAW lpDD;
	LPDIRECTDRAWCLIPPER lpDDClipper;
	LPDIRECTDRAWPALETTE lpDDPalette;

	LPDIRECTDRAWSURFACE lpDDSPrimary;
	LPDIRECTDRAWSURFACE lpDDSBack;
	LPDIRECTDRAWSURFACE lpDDSOffScreen;

	LPDIRECTDRAWSURFACE2 lpDDSPrimary2;
	LPDIRECTDRAWSURFACE2 lpDDSBack2;
	LPDIRECTDRAWSURFACE2 lpDDSOffScreen2;

	int Width, Height;
	char Depth;
	unsigned char Windowed;
	unsigned char NeedClipper;
	unsigned char ForceClipper;
	unsigned char ForceWindowedDirectDrawClipper;
	unsigned char DisableHardwareScale;
	bool DoubleBuffered, OffScreenVRAM, BackBufferVRAM, wait_for_vsync;
	DDPIXELFORMAT DDPixelFormat;
    unsigned int NumFlipFrames;
	bool ScreenCleared;
};

struct SSurface {
	unsigned char *Surface;
	unsigned int Pitch;
	unsigned int Width;
	unsigned int Height;
};

//DirectX proc
bool DirectX_SetDisplayMode(int pWidth, int pHeight, char pDepth,
							unsigned char pWindowed, bool pDoubleBuffered);
void DirectX_Initialize0();
bool DirectX_Initialize(HWND hWnd, DWORD dwStyleWindowed, DWORD dwStyleFullScreen);
void DirectX_DeInitialize();
void DirectX_ClearPrimarySurface();
void DirectX_ClearOffscreenSurface();
void DirectX_ClearBackbufferSurface();
void DirectX_FillPrimarySurface(RECT *clrRect);
void DirectX_FillOffscreenSurface(RECT *clrRect);
void DirectX_FillBackbufferSurface(RECT *clrRect);
void DirectX_SetClipper(unsigned char clipflag, long dWidth, long dHeight,
						unsigned char topmost);
bool LockSurface2 (LPDIRECTDRAWSURFACE2 lpDDSurface, SSurface *lpSurface);

/*****************
 default settings
*****************/
extern bool DirectX_OffScreenVRAM_def;
extern bool DirectX_BackBufferVRAM_def;
extern bool DirectX_wait_for_vsync_def;
extern unsigned char DirectX_DisableHardwareScale_def;

//DirectX struct
extern struct SDirectX DirectX;

struct DDisplayMode {
	int Width;
	int Height;
	char Depth;
};

#endif /* _WINDRAW_H_ */

