#define STRICT
#include <windows.h>
#include <mmsystem.h>
#include "windraw.h"

struct SDirectX DirectX;

/*****************
 default settings
*****************/
bool DirectX_OffScreenVRAM_def = FALSE;
bool DirectX_BackBufferVRAM_def = FALSE;
bool DirectX_wait_for_vsync_def = FALSE;
unsigned char DirectX_DisableHardwareScale_def = FALSE;

void DirectX_Initialize0()
{
	//set default value
	DirectX.hWnd = NULL;
	DirectX.lpDD = NULL;
	DirectX.lpDDClipper = NULL;
	DirectX.lpDDPalette = NULL;

	DirectX.lpDDSPrimary = NULL;
	DirectX.lpDDSBack = NULL;
	DirectX.lpDDSOffScreen = NULL;

	DirectX.lpDDSPrimary2 = NULL;
	DirectX.lpDDSBack2 = NULL;
	DirectX.lpDDSOffScreen2 = NULL;

	DirectX.Width = DirectX.Height = -1;
	DirectX.Depth = -1;
	DirectX.Windowed = TRUE;
	DirectX.NeedClipper = TRUE;
	DirectX.ForceClipper = FALSE;
	DirectX.ForceWindowedDirectDrawClipper = FALSE;
	DirectX.DoubleBuffered = FALSE;
	DirectX.OffScreenVRAM = DirectX_OffScreenVRAM_def;
	DirectX.BackBufferVRAM = DirectX_BackBufferVRAM_def;
	DirectX.wait_for_vsync = DirectX_wait_for_vsync_def;

	DirectX.DDAvailable = FALSE;
	DirectX.DisableHardwareScale = DirectX_DisableHardwareScale_def;
	DirectX.NumFlipFrames = 1;
}

bool DirectX_Initialize(HWND hwnd, DWORD dwStyleW, DWORD dwStyleF)
{
    //DirectX_Initialize
	DirectX.hWnd = hwnd;
	DirectX.dwStyleWindowed = dwStyleW;
	DirectX.dwStyleFullScreen = dwStyleF;

	DirectX.dErr = DirectDrawCreate(NULL, &DirectX.lpDD, NULL);
	if(DirectX.dErr != DD_OK)
		return FALSE;
	else
		DirectX.DDAvailable = TRUE;

	DirectX.dErr = DirectX.lpDD -> CreateClipper(0, &DirectX.lpDDClipper, NULL);
	if(DirectX.dErr != DD_OK) {
		DirectX.lpDD -> Release();
		DirectX.lpDD = NULL;
		return FALSE;
	}
	DirectX.dErr = DirectX.lpDDClipper -> SetHWnd(0, DirectX.hWnd);
	if(DirectX.dErr != DD_OK) {
		DirectX.lpDDClipper -> Release();
		DirectX.lpDDClipper = NULL;
		DirectX.lpDD -> Release();
		DirectX.lpDD = NULL;
		return FALSE;
	}
	return TRUE;
}

void DirectX_DeInitialize()
{
	if(DirectX.lpDD != NULL)
	{
		if(!DirectX.Windowed)
			DirectX.lpDD -> RestoreDisplayMode();

		if(DirectX.lpDDSPrimary != NULL)
		{
			DirectX.lpDDSPrimary -> Release();
			DirectX.lpDDSPrimary = NULL;
		}
		if(DirectX.lpDDSOffScreen != NULL)
		{
			DirectX.lpDDSOffScreen -> Release();
			DirectX.lpDDSOffScreen = NULL;
		}
		if(DirectX.lpDDSPrimary2 != NULL)
		{
			DirectX.lpDDSPrimary2 -> Release();
			DirectX.lpDDSPrimary2 = NULL;
		}
		if(DirectX.lpDDSOffScreen2 != NULL)
		{
			DirectX.lpDDSOffScreen2 -> PageUnlock(0);
			DirectX.lpDDSOffScreen2 -> Release();
			DirectX.lpDDSOffScreen2 = NULL;
		}
		if(DirectX.lpDDClipper != NULL)
		{
			DirectX.lpDDClipper -> Release();
			DirectX.lpDDClipper = NULL;
		}
		if(DirectX.lpDDPalette != NULL)
		{
			DirectX.lpDDPalette -> Release();
			DirectX.lpDDPalette = NULL;
		}
		DirectX.lpDD -> Release();
		DirectX.lpDD = NULL;
		DirectX.DDAvailable = FALSE;
		DirectX.NumFlipFrames = 1;
	}
}

bool DirectX_SetDisplayMode(int pWidth, int pHeight, 
							char pDepth, unsigned char pWindowed, bool pDoubleBuffered)
{
	DDSURFACEDESC ddsd;
	DDSCAPS ddscaps;
	PALETTEENTRY PaletteEntries[256];

	if(pDepth == 0)
		pDepth = DirectX.Depth;

	if(DirectX.lpDDSPrimary != NULL)
	{
		DirectX.lpDDSPrimary -> Release();
		DirectX.lpDDSPrimary = NULL;
	}
	if(DirectX.lpDDSOffScreen != NULL)
	{
		DirectX.lpDDSOffScreen -> Release();
		DirectX.lpDDSOffScreen = NULL;
	}
	if(DirectX.lpDDSPrimary2 != NULL)
	{
		DirectX.lpDDSPrimary2 -> Release();
		DirectX.lpDDSPrimary2 = NULL;
	}
	if(DirectX.lpDDSOffScreen2 != NULL)
	{
		DirectX.lpDDSOffScreen2 -> PageUnlock(0);
		DirectX.lpDDSOffScreen2 -> Release();
		DirectX.lpDDSOffScreen2 = NULL;
	}
	if(DirectX.lpDDPalette != NULL)
	{
		DirectX.lpDDPalette -> Release();
		DirectX.lpDDPalette = NULL;
	}

	DirectX.NumFlipFrames = 1;

    if(!DirectX.DDAvailable)
        return FALSE;

	DirectX.lpDD -> FlipToGDISurface();

	//Window mode
	if(pWindowed)
	{	
		pDoubleBuffered = FALSE;
		if(!DirectX.Windowed) {
			DirectX.lpDD -> RestoreDisplayMode();
			SetWindowLong(DirectX.hWnd, GWL_STYLE, DirectX.dwStyleWindowed);
		}
		FillMemory((PVOID)&ddsd, sizeof(ddsd), 0);
		ddsd.dwSize = sizeof(ddsd);
		ddsd.dwFlags = DDSD_PIXELFORMAT;
		DirectX.dErr = DirectX.lpDD -> GetDisplayMode(&ddsd);
		if(DirectX.dErr != DD_OK)
		{	pDepth = 8;	}
		else
		{
		if(ddsd.ddpfPixelFormat.dwFlags&DDPF_RGB)
		{	pDepth = (char)ddsd.ddpfPixelFormat.dwRGBBitCount;	}
		else
		{	pDepth = 8;	}
		}
		DirectX.dErr = DirectX.lpDD -> SetCooperativeLevel(DirectX.hWnd, DDSCL_NORMAL|DDSCL_ALLOWREBOOT);
	} 

	//Fullscreen mode
	else 
	{
		SetWindowLong(DirectX.hWnd, GWL_STYLE, DirectX.dwStyleFullScreen);
		SetWindowPos(DirectX.hWnd, HWND_TOP, 0, 0, 0, 0, SWP_DRAWFRAME|SWP_FRAMECHANGED|SWP_NOMOVE|SWP_NOSIZE);

		if(DirectX.Windowed || pWidth != DirectX.Width || pHeight != DirectX.Height || pDepth != DirectX.Depth)
		{	
			DirectX.dErr = DirectX.lpDD -> SetCooperativeLevel(DirectX.hWnd, DDSCL_ALLOWMODEX | DDSCL_EXCLUSIVE |
															   DDSCL_FULLSCREEN | DDSCL_ALLOWREBOOT);

			if(DirectX.dErr == DD_OK)
				DirectX.dErr = DirectX.lpDD -> SetDisplayMode(pWidth, pHeight, pDepth);
		}
	}

	if(DirectX.dErr != DD_OK)
		return FALSE;

	FillMemory((PVOID)&ddsd, sizeof(ddsd), 0);

	//Fullscreen mode with backbuffer
	if(!pWindowed && pDoubleBuffered)
	{
		ddsd.dwSize = sizeof(ddsd);
		ddsd.dwFlags = DDSD_CAPS | DDSD_BACKBUFFERCOUNT;
		ddsd.ddsCaps.dwCaps = DDSCAPS_PRIMARYSURFACE | DDSCAPS_COMPLEX | DDSCAPS_FLIP;
		ddsd.dwBackBufferCount = 1;
	}
	//Fullscreen mode without backbuffer
	else if(!pWindowed && !pDoubleBuffered)
	{
		ddsd.dwSize = sizeof(ddsd);
		ddsd.dwFlags = DDSD_CAPS;
		ddsd.ddsCaps.dwCaps = DDSCAPS_PRIMARYSURFACE;
	}
	//Window mode
	else
	{
		ddsd.dwSize = sizeof(ddsd);
		ddsd.dwFlags = DDSD_CAPS;
		ddsd.ddsCaps.dwCaps = DDSCAPS_PRIMARYSURFACE;
	}
	

	//Create PrimarySurface
	DirectX.dErr = DirectX.lpDD -> CreateSurface(&ddsd, &DirectX.lpDDSPrimary, NULL);

	//Create PrimarySurface Failed
	if(DirectX.dErr != DD_OK)
	{
		if(pDoubleBuffered)
		{
			FillMemory((PVOID)&ddsd, sizeof(ddsd), 0);
			ddsd.dwSize = sizeof(ddsd);
			ddsd.dwFlags = DDSD_CAPS;
			ddsd.ddsCaps.dwCaps = DDSCAPS_PRIMARYSURFACE;
			pDoubleBuffered = FALSE;
			DirectX.dErr = DirectX.lpDD -> CreateSurface(&ddsd, &DirectX.lpDDSPrimary, NULL);
		}
		if(DirectX.dErr != DD_OK)
			return FALSE;
	}

	FillMemory((PVOID)&DirectX.DDPixelFormat, sizeof(DirectX.DDPixelFormat), 0);
	DirectX.DDPixelFormat.dwSize = sizeof(DirectX.DDPixelFormat);
	DirectX.lpDDSPrimary -> GetPixelFormat(&DirectX.DDPixelFormat);

	if(!pWindowed && DirectX.lpDDClipper) {
		if(DirectX.lpDDSPrimary) {
			DirectX.lpDDSPrimary -> SetClipper(NULL);
		}
		DirectX.lpDDClipper -> Release();
		DirectX.lpDDClipper = NULL;
	}

	if(FAILED(DirectX.lpDDSPrimary -> QueryInterface(IID_IDirectDrawSurface2, (void **)&DirectX.lpDDSPrimary2)))
	{   return FALSE;  }
	else
	{
		DirectX.lpDDSPrimary -> Release();
		DirectX.lpDDSPrimary = NULL;
	}

	if(!pWindowed && pDoubleBuffered)
	{
	    RECT Src;
		if(!DirectX.BackBufferVRAM)
			ddscaps.dwCaps = DDSCAPS_BACKBUFFER;
		else
			ddscaps.dwCaps = DDSCAPS_BACKBUFFER | DDSCAPS_VIDEOMEMORY;
		if(DirectX.lpDDSPrimary2 != NULL)
		{	DirectX.dErr = DirectX.lpDDSPrimary2 -> GetAttachedSurface(&ddscaps, &DirectX.lpDDSBack2);	}
		if(DirectX.dErr != DD_OK)
			return FALSE;

		Src.left = 0; Src.right = pWidth;
		Src.top = 0; Src.bottom = pHeight;
		if(DirectX.lpDDSPrimary2 != NULL)
		{	DirectX.lpDDSBack2 -> BltFast(0, 0, DirectX.lpDDSPrimary2, &Src, DDBLTFAST_WAIT);	}
	}
	else
	{	
		DirectX.lpDDSBack = NULL;	
		DirectX.lpDDSBack2 = NULL;
	}

	ddsd.dwSize = sizeof(ddsd);
	ddsd.dwFlags = DDSD_CAPS | DDSD_HEIGHT | DDSD_WIDTH;
	if(!DirectX.OffScreenVRAM)
		ddsd.ddsCaps.dwCaps = DDSCAPS_OFFSCREENPLAIN | DDSCAPS_SYSTEMMEMORY;
	else
		ddsd.ddsCaps.dwCaps = DDSCAPS_OFFSCREENPLAIN | DDSCAPS_VIDEOMEMORY;
	ddsd.dwWidth = 256 * 2;
	ddsd.dwHeight = 239 * 2;
	
	DirectX.dErr = DirectX.lpDD -> CreateSurface(&ddsd, &DirectX.lpDDSOffScreen, NULL);
	if(DirectX.dErr != DD_OK)
		return FALSE;

	if(DirectX.lpDDSPrimary2 != NULL) {
	if(FAILED(DirectX.lpDDSOffScreen -> QueryInterface(IID_IDirectDrawSurface2, (void **)&DirectX.lpDDSOffScreen2)))
	{    return FALSE;    }
	else
	{
		DirectX.lpDDSOffScreen2 -> PageLock(0);
		DirectX.lpDDSOffScreen -> Release();
		DirectX.lpDDSOffScreen = NULL;
	}
	}

	if(pDepth == 8)
	{
		for(int i = 0; i < 256; i++) {
			PaletteEntries[i].peRed = 0;
			PaletteEntries[i].peGreen = 0;
			PaletteEntries[i].peBlue = 0;
			PaletteEntries[i].peFlags = PC_NOCOLLAPSE;
		}
		DirectX.dErr = DirectX.lpDD -> CreatePalette(DDPCAPS_8BIT|DDPCAPS_ALLOW256,
													 PaletteEntries,
													 &DirectX.lpDDPalette,
													 NULL);
		if(DirectX.dErr != DD_OK)
		{
			DirectX.lpDDPalette = NULL;
			return FALSE;
		}
	}

	//Get display mode
	FillMemory((PVOID)&ddsd, sizeof(ddsd), 0);
	ddsd.dwSize = sizeof( ddsd);
	ddsd.dwFlags = DDSD_HEIGHT | DDSD_WIDTH;
	DirectX.lpDD -> GetDisplayMode(&ddsd);

	//Sleep
	if(DirectX.Windowed != pWindowed ||
	   DirectX.Width != (int)ddsd.dwWidth ||
	   DirectX.Height != (int)ddsd.dwHeight ||
	   DirectX.Depth != pDepth) {
		Sleep(500);
	}
	DirectX.Windowed = pWindowed;
	DirectX.Depth = pDepth;
	DirectX.Height = ddsd.dwHeight;
	DirectX.Width = ddsd.dwWidth;
	DirectX.DoubleBuffered = pDoubleBuffered;
	if(DirectX.lpDDSBack2 != NULL)
		DirectX.NumFlipFrames = 2;

	DirectX_ClearOffscreenSurface();
	DirectX_ClearPrimarySurface();
	DirectX_ClearBackbufferSurface();
	return TRUE;
}

bool LockSurface2 (LPDIRECTDRAWSURFACE2 lpDDSurface, SSurface *lpSurface)
{
    DDSURFACEDESC ddsd;
    HRESULT hResult;
    int retry;

	ZeroMemory(&ddsd, sizeof(DDSURFACEDESC));
    ddsd.dwSize = sizeof(ddsd);

    retry = 0;
    while(TRUE)
    {
        hResult = lpDDSurface -> Lock(NULL, &ddsd, DDLOCK_WAIT, NULL);

        if(hResult == DD_OK)
        {
            lpSurface -> Width = ddsd.dwWidth;
            lpSurface -> Height = ddsd.dwHeight;
            lpSurface -> Pitch = ddsd.lPitch;
            lpSurface -> Surface = (unsigned char *)ddsd.lpSurface;
            return TRUE;
        }

        if(hResult == DDERR_SURFACELOST)
        {
            retry++;
            if( retry > 5)
            {	return FALSE;	}

            hResult = lpDDSurface -> Restore();
            DirectX.ScreenCleared = TRUE;
            if (hResult != DD_OK)
            {	return FALSE;	}

            continue;
        }

        if( hResult != DDERR_WASSTILLDRAWING)
            return FALSE;
    }
}

//Zero clear Surface2
static inline void DirectX_ClearSurface2(LPDIRECTDRAWSURFACE2 lpDDS2)
{
	SSurface clr;

	if(lpDDS2 == NULL ||
	   LockSurface2 (lpDDS2, &clr) == false)
		return;

	int pb = DirectX.Depth >> 3;

	for(int y = 0; y < clr.Height; y++)
		FillMemory((PVOID)(clr.Surface + clr.Pitch * y), clr.Width * pb, 0);

	lpDDS2->Unlock (clr.Surface);
}

//Zero Fill Surface2
static inline void DirectX_FillSurface2(LPDIRECTDRAWSURFACE2 lpDDS2,
										RECT *clrRect)
{
	SSurface clr;

	if(lpDDS2 == NULL ||
	   LockSurface2 (lpDDS2, &clr) == false)
		return;

	int pb = DirectX.Depth >> 3;
	
	if(clrRect->top >= 0 &&
	   clrRect->left >= 0 &&
	   clrRect->bottom <= clr.Height &&
	   clrRect->right <= clr.Width) {

		int w = clrRect->right - clrRect->left;

		for(int y = clrRect->top; y < clrRect->bottom; y++)
			FillMemory((PVOID)(clr.Surface + clr.Pitch * y + clrRect->left * pb),
					   w * pb, 0);
	}

	lpDDS2->Unlock (clr.Surface);
}

//Zero clear OffscreenSurface
void DirectX_ClearOffscreenSurface()
{
	if(DirectX.lpDDSOffScreen2)
		DirectX_ClearSurface2(DirectX.lpDDSOffScreen2);
}

//Zero clear PrimarySurface
void DirectX_ClearPrimarySurface()
{
	if(DirectX.Windowed)
		return;
	if(DirectX.lpDDSPrimary2)
		DirectX_ClearSurface2(DirectX.lpDDSPrimary2);
}

//Zero clear BackbufferSurface
void DirectX_ClearBackbufferSurface()
{
	if(DirectX.Windowed)
		return;
	if(DirectX.lpDDSBack2)
		DirectX_ClearSurface2(DirectX.lpDDSBack2);
}

//Zero Fill OffscreenSurface
void DirectX_FillOffscreenSurface(RECT *clrRect)
{
	if(DirectX.lpDDSOffScreen2)
		DirectX_FillSurface2(DirectX.lpDDSOffScreen2,
							 clrRect);
}

//Zero Fill PrimarySurface
void DirectX_FillPrimarySurface(RECT *clrRect)
{
	if(DirectX.Windowed)
		return;
	if(DirectX.lpDDSPrimary2)
		DirectX_FillSurface2(DirectX.lpDDSPrimary2,
							 clrRect);
}

//Zero Fill BackbufferSurface
void DirectX_FillBackbufferSurface(RECT *clrRect)
{
	if(DirectX.Windowed)
		return;
	if(DirectX.lpDDSBack2)
		DirectX_FillSurface2(DirectX.lpDDSBack2,
							 clrRect);
}

void DirectX_SetClipper(unsigned char clipflag, long dWidth, long dHeight,
						unsigned char topmost)
{
	if(!DirectX.DDAvailable || !DirectX.hWnd || !DirectX.Windowed)
		return;
	
	DirectX.NeedClipper = FALSE;
	if((DirectX.ClientRect.right - DirectX.ClientRect.left) < dWidth ||
	   (DirectX.ClientRect.bottom - DirectX.ClientRect.top) < dHeight)
		DirectX.NeedClipper = TRUE;
	if(!DirectX.NeedClipper) {
		POINT pt;
		RECT wRect, dRect;
		int dwidth = (int)dWidth;
		int dheight = (int)dHeight;
		pt.x = ((DirectX.ClientRect.right - DirectX.ClientRect.left) - dwidth) / 2;
		pt.y = ((DirectX.ClientRect.bottom - DirectX.ClientRect.top) - dheight) / 2;
		ClientToScreen (DirectX.hWnd, &pt);
		dRect.top = pt.y;
		dRect.left = pt.x;
		dRect.bottom = dRect.top + dheight;
		dRect.right  = dRect.left + dwidth;

		if(topmost) {
			wRect.left = 0;
			wRect.top = 0;
			wRect.right = GetSystemMetrics(SM_CXSCREEN);
			wRect.bottom = GetSystemMetrics(SM_CYSCREEN);
		}
		else {
			SystemParametersInfo(SPI_GETWORKAREA, 0, &wRect, 0);
		}
		if(wRect.top > dRect.top || wRect.left > dRect.left || wRect.right < dRect.right || wRect.bottom < dRect.bottom)
			DirectX.NeedClipper = TRUE;
	}

	if(clipflag || DirectX.NeedClipper || DirectX.ForceWindowedDirectDrawClipper || DirectX.ForceClipper) {
		if(DirectX.lpDD && DirectX.lpDDClipper == NULL) {
			DirectX.dErr = DirectX.lpDD -> CreateClipper(0, &DirectX.lpDDClipper, NULL);
			if(DirectX.dErr == DD_OK) {
				DirectX.dErr = DirectX.lpDDClipper -> SetHWnd(0, DirectX.hWnd);
				if(DirectX.dErr != DD_OK)
					return;
			}
			else {
				DirectX.lpDDClipper = NULL;
				return;
			}
		}
		if(DirectX.lpDDSPrimary2) {
			DirectX.lpDDSPrimary2 -> SetClipper(DirectX.lpDDClipper);
		}
	}
	else {
		if(DirectX.lpDDSPrimary2) {
			DirectX.lpDDSPrimary2 -> SetClipper(NULL);
		}
		if(DirectX.lpDDClipper != NULL)
		{
			DirectX.lpDDClipper -> SetHWnd(0, NULL);
			DirectX.lpDDClipper -> Release();
			DirectX.lpDDClipper = NULL;
		}
	}
}

