#include "snes9x.h"
#include "memmap.h"
#include "debug.h"
#include "snapshot.h"
#include "apu.h"
#include "display.h"
#include "uosnesw.h"
#include "windraw.h"
#include "uowdraw.h"
#include "wintimer.h"
#include "uowinput.h"
#include "uowsound.h"
#include "AVIOutput.h"

#include <direct.h>
#include <io.h>

void S9xParseArg (char **argv, int &i, int argc)
{
#if 0
    if (strcasecmp (argv [i], "-restore") == 0)
    {
        WinDeleteRegistryEntries ();
        WinSetDefaultValues ();
	}
	if (strcasecmp (argv[i], "-hidemenu") == 0)
	{
		GUI.HideMenu = true;
	}
#endif
}

void S9xExtraUsage ()
{
}

void S9xTextMode( void)
{
}

void S9xGraphicsMode ()
{
}

void S9xExit( void)
{
	MessageBox(NULL, Languages[ GUI.Language].S9xExitMessage, "uosnesw", MB_OK | MB_ICONSTOP);
	SendMessage(GUI.hWnd, WM_COMMAND, ID_FILE_EXIT, 0);
}

const char *GetHomeDirectory ()
{
    static char filename [_MAX_PATH + 1];
    char drive [_MAX_DRIVE + 1];
    char dir [_MAX_DIR + 1];
    char fname [_MAX_FNAME + 1];
    char ext [_MAX_EXT + 1];

	_splitpath (__argv[0], drive, dir, fname, ext);
	_makepath(filename, drive, dir, NULL, NULL);
	int len = strlen (filename);
	if(len > 0 && filename[--len] == SLASH_CHAR)
		filename[len] = 0;
    return (const char *)filename;
}

extern "C" const char *S9xGetFilename (const char *e)
{
    static char filename [_MAX_PATH + 1];
    char drive [_MAX_DRIVE + 1];
    char dir [_MAX_DIR + 1];
    char fname [_MAX_FNAME + 1];
    char ext [_MAX_EXT + 1];

    if (strlen (GUI.FreezeFileDir))
    {
        _splitpath (Memory.ROMFilename, drive, dir, fname, ext);
        strcpy (filename, GUI.FreezeFileDir);
        strcat (filename, "\\");
        strcat (filename, fname);
        strcat (filename, e);
    }
    else
    {
        _splitpath (Memory.ROMFilename, drive, dir, fname, ext);
        _makepath( filename, drive, dir, fname, e);
    }
    return (filename);
}

const char *S9xGetFilenameInc (const char *e)
{
    static char filename [_MAX_PATH + 1];
    char drive [_MAX_DRIVE + 1];
    char dir [_MAX_DIR + 1];
    char fname [_MAX_FNAME + 1];
    char ext [_MAX_EXT + 1];
    char *ptr;

    if (strlen (GUI.FreezeFileDir))
    {
        _splitpath (Memory.ROMFilename, drive, dir, fname, ext);
        strcpy (filename, GUI.FreezeFileDir);
        strcat (filename, TEXT("\\"));
        strcat (filename, fname);
        ptr = filename + strlen (filename);
        strcat (filename, TEXT("00/"));
        strcat (filename, e);
    }
    else
    {
        _splitpath (Memory.ROMFilename, drive, dir, fname, ext);
        strcat (fname, TEXT("00/"));
        _makepath (filename, drive, dir, fname, e);
        ptr = strstr (filename, TEXT("00/"));
    }

    do
    {
        if (++*(ptr + 2) > '9')
        {
            *(ptr + 2) = '0';
            if (++*(ptr + 1) > '9')
            {
                *(ptr + 1) = '0';
                if (++*ptr > '9')
                    break;
            }
        }
    } while (_access (filename, 0) == 0);

    return (filename);
}

static int spcnum = 0;

const char *S9xGetSPCFilename ()
{
    static char filename [_MAX_PATH + 1];
    char drive [_MAX_DRIVE + 1];
    char dir [_MAX_DIR + 1];
    char fname [_MAX_FNAME + 1];
    char ext [_MAX_EXT + 1];


    if (strlen (Memory.SPCDumpDirectory))
    {
        _splitpath (Memory.ROMFilename, drive, dir, fname, ext);
        strcpy (filename, Memory.SPCDumpDirectory);
        strcat (filename, "\\");
        strcat (filename, fname);
		strcat (filename, "_000");
        strcat (filename, ".spc");
		_splitpath (filename, drive, dir, fname, ext);
    }
    else
    {
        _splitpath (Memory.ROMFilename, drive, dir, fname, ext);
		strcat (fname, "_000");
        _makepath( filename, drive, dir, fname, ".spc");
		_splitpath (filename, drive, dir, fname, ext);
    }
	spcnum = 0;
	while((int)GetFileAttributes(filename) != -1 && spcnum != 999)
	{
		++spcnum;
		wsprintf(&fname[lstrlen(fname) - 3], "%03d", spcnum);
		_makepath( filename, drive, dir, fname, ext);
	}
    return (const char *)filename;
}

static char SavedSPCNumberAndExtStr[10];

char *S9xwGetSavedSPCNumberAndExtStr()
{
	SavedSPCNumberAndExtStr[0] = '_';
	wsprintf(&SavedSPCNumberAndExtStr[1], "%03d", spcnum);
	lstrcat(SavedSPCNumberAndExtStr, ".spc");
	return SavedSPCNumberAndExtStr;
}

static char imgext [_MAX_EXT] = ".bmp";
static int imgnum = 0;

char *S9xwGetScreenImageFilename (char *ImageTypeExt)
{
	static char filename [_MAX_PATH + 1];
	char drive [_MAX_DRIVE + 1];
	char dir [_MAX_DIR + 1];
	char fname [_MAX_FNAME + 1];

	_splitpath (Memory.ROMFilename, drive, dir, fname, imgext);
	lstrcpy(imgext, ImageTypeExt);
	CharLower(imgext);

	if (strlen (Memory.ScreenShotDirectory))
	{
		strcpy (filename, Memory.ScreenShotDirectory);
		strcat (filename, "\\");
		strcat (filename, fname);
		strcat (filename, "_000");
		strcat (filename, imgext);
		_splitpath (filename, drive, dir, fname, imgext);
	}
	else
	{
		strcat (fname, "_000");
		_makepath( filename, drive, dir, fname, imgext);
		_splitpath (filename, drive, dir, fname, imgext);
	}
	
	imgnum = 0;
	while((int)GetFileAttributes(filename) != -1 && imgnum != 999)
	{
		++imgnum;
		wsprintf(&fname[lstrlen(fname) - 3], "%03d", imgnum);
		_makepath( filename, drive, dir, fname, imgext);
	}

	return (filename);
}

extern "C" const char *S9xGetNumFilename (const char *dirstr, const char *fext, int *numsaved)
{
	static char filename [_MAX_PATH + 1];
	char drive [_MAX_DRIVE + 1];
	char dir [_MAX_DIR + 1];
	char fname [_MAX_FNAME + 1];
	char ext [_MAX_EXT + 1];
	int num = 0;

	_splitpath (Memory.ROMFilename, drive, dir, fname, ext);
	lstrcpy(ext, fext);
	CharLower(ext);

	if (lstrlen (dirstr))
	{
		if((lstrlen(dirstr) + 1 + lstrlen(fname) + 4 + lstrlen(ext)) > _MAX_PATH) {
			if(numsaved)
				*numsaved = num;
			return NULL;
		}

		lstrcpy (filename, dirstr);
		lstrcat (filename, "\\");
		lstrcat (filename, fname);
		lstrcat (filename, "_000");
		lstrcat (filename, ext);
		_splitpath (filename, drive, dir, fname, ext);
	}
	else
	{
		if((lstrlen(drive) + lstrlen(dir) + lstrlen(fname) + 4 + lstrlen(ext)) > _MAX_PATH) {
			if(numsaved)
				*numsaved = num;
			return NULL;
		}

		lstrcat (fname, "_000");
		_makepath( filename, drive, dir, fname, ext);
		_splitpath (filename, drive, dir, fname, ext);
	}
	
	while(GetFileAttributes(filename) != 0xffffffff && num != 999)
	{
		++num;
		wsprintf(&fname[lstrlen(fname) - 3], "%03d", num);
		_makepath( filename, drive, dir, fname, ext);
	}

	if(numsaved)
		*numsaved = num;

	return (const char *)filename;
}

static char SavedScreenImageNumberAndTypeStr[10];

char *S9xwGetSavedScreenImageNumberAndTypeStr()
{
	SavedScreenImageNumberAndTypeStr[0] = '_';
	wsprintf(&SavedScreenImageNumberAndTypeStr[1], "%03d", imgnum);
	lstrcat(SavedScreenImageNumberAndTypeStr, imgext);
	return SavedScreenImageNumberAndTypeStr;
}

bool8 S9xOpenSnapshotFile(const char *fname, bool8 read_only, STREAM *file)
{
    char filename [_MAX_PATH + 1];
    char drive [_MAX_DRIVE + 1];
    char dir [_MAX_DIR + 1];
    char fn [_MAX_FNAME + 1];
    char ext [_MAX_EXT + 1];

    _splitpath( fname, drive, dir, fn, ext);
    _makepath( filename, drive, dir, fn, ext[0] == '\0' ? ".000" : ext);

    if (read_only)
    {
	if ((*file = OPEN_STREAM (filename, "rb")))
	    return (TRUE);
    }
    else
    {
	if ((*file = OPEN_STREAM (filename, "wb")))
	    return (TRUE);
        FILE *fs = fopen (filename, "rb");
        if (fs)
        {
            sprintf (String, "Freeze file \"%s\" exists but is read only",
                     filename);
            fclose (fs);
            S9xMessage (S9X_ERROR, S9X_FREEZE_FILE_NOT_FOUND, String);
        }
        else
        {
            sprintf (String, "Cannot create freeze file \"%s\". Directory is read-only or does not exist.", filename);
            
            S9xMessage (S9X_ERROR, S9X_FREEZE_FILE_NOT_FOUND, String);
        }
    }
    return (FALSE);
}

void S9xCloseSnapshotFile( STREAM file)
{
    CLOSE_STREAM (file);
}

void S9xMessage (int, int, const char *str)
{
#ifdef DEBUGGER
  //static FILE *out = NULL;

  //if (out == NULL)
  //        out = fopen ("out.txt", "w");

  //    fprintf (out, "%s\n", str);
#endif

    S9xSetInfoString (str);
}

bool8 S9xOpenSoundDevice (int mode, bool8 pStereo, int BufferSize)
{
    return (TRUE);
}

int superscope_pause = 0;
int superscope_turbo = 0;

bool8 S9xReadSuperScopePosition (int &x, int &y, uint32 &buttons)
{
	RECT dstRect;
	GetRenderedRect(GUI.hWnd, &dstRect);

    x = (int) ((GUI.MouseX - dstRect.left) * (256.0 / (dstRect.right - dstRect.left)));
    //not all games are 224
	y = (int) ((GUI.MouseY - dstRect.top) * ((double)PPU.ScreenHeight / (dstRect.bottom - dstRect.top)));
    buttons = GUI.MouseButtons | (superscope_turbo << 2) | 
              (superscope_pause << 3);

	superscope_pause=FALSE;

    return (TRUE);
}

void S9xSyncSpeed(void)
{
	if(!Settings.SPCPlaying && IPPU.RenderThisFrame)
		S9xDeinitUpdate (IPPU.RenderedScreenWidth,
						 IPPU.RenderedScreenHeight,
						 Settings.SixteenBit);

	if ((!Settings.TurboMode && Settings.SkipFrames == AUTO_FRAMERATE) ||
		(XxxMovie.Replay_rec == TRUE || XxxMovie.Replay_play == TRUE)) {
		LONG prev;
		static unsigned long XXX_FrameTime;

		EnterMeteredSection(GUI.FrameTimerMeteredSection, 100);
		LeaveMeteredSection(GUI.FrameTimerMeteredSection, 0, &prev);

		if (prev == 0) {
			IPPU.RenderThisFrame = TRUE;
			IPPU.SkippedFrames = 0;
			XXX_FrameTime = 0;
		}
        else {
			if (IPPU.SkippedFrames < Settings.AutoMaxSkipFrames && prev > 1) {
				IPPU.SkippedFrames++;
				IPPU.RenderThisFrame = FALSE;
				XXX_FrameTime = 0;
			}
			else {
				if (IPPU.SkippedFrames == 0 && XXX_FrameTime > 3) {
					IPPU.SkippedFrames++;
					IPPU.RenderThisFrame = FALSE;
		            XXX_FrameTime = 0;
				}
				else {
					IPPU.RenderThisFrame = TRUE;
					IPPU.SkippedFrames = 0;
					XXX_FrameTime++;
				}
			}
		}
	}
	else {
		if (++IPPU.FrameSkip >= (Settings.TurboMode ?
								 Settings.TurboSkipFrames : Settings.SkipFrames)) {
			IPPU.FrameSkip = 0;
			IPPU.SkippedFrames = 0;
			IPPU.RenderThisFrame = TRUE;
		}
		else {
			IPPU.SkippedFrames++;
			IPPU.RenderThisFrame = FALSE;
		}
	}
}

const char *S9xBasename (const char *f)
{
	const char *p;
	const char *pp = f;
	size_t slen = lstrlen(f);
	//SJIS string
	for (p = f; p < (f + slen); p++) {
		if(*(p + 1) && ((*(unsigned char *)p >= 0x81 && *(unsigned char *)p <= 0x9f) ||
						(*(unsigned char *)p >= 0xe0 && *(unsigned char *)p <= 0xfc)) &&
		   ((*(unsigned char *)(p + 1) >= 0x40 && *(unsigned char *)(p + 1) <= 0x7e) ||
			(*(unsigned char *)(p + 1) >= 0x80 && *(unsigned char *)(p + 1) <= 0xfc)))
			++p;
		else if (*p == (const char)'\\')
			pp = (p + 1);
	}
	return pp;
}

bool8 S9xReadMousePosition (int which, int &x, int &y, uint32 &buttons)
{
    if (which == 0)
    {
        x = GUI.MouseX;
        y = GUI.MouseY;
        buttons = GUI.MouseButtons;
        return (TRUE);
    }

    return (FALSE);
}

void S9xAutoSaveSRAM ()
{
    Memory.SaveSRAM (S9xGetFilename (".srm"));
}

void S9xSetPause (uint32 mask)
{
    Settings.ForcedPause |= mask;
}

void S9xClearPause (uint32 mask)
{
    Settings.ForcedPause &= ~mask;
    if (!Settings.ForcedPause)
    {
        // Wake up the main loop thread just if its blocked in a GetMessage
        // call.
        PostMessage (GUI.hWnd, WM_NULL, 0, 0);
    }
}

bool InitUosnesw()
{
    if(!Memory.Init())
		return FALSE;

	if(!DirectX_Initialize(GUI.hWnd, GUI.dwStyleWindowed, GUI.dwStyleFullScreen)) {
		MessageBox(GUI.hWnd,
				   Languages[GUI.Language].errInitDD,
				   "uosnes - DirectX",
				   MB_OK | MB_ICONSTOP);
		return FALSE;
	}
	
	CurFullscreenDisplayModeIndexChange();
	if(!DirectX_SetDisplayMode(DisplayMode[GUI.CurFullscreenDisplayModeIndex].Width,
							   DisplayMode[GUI.CurFullscreenDisplayModeIndex].Height,
							   DisplayMode[GUI.CurFullscreenDisplayModeIndex].Depth,
							   TRUE, GUI.DoubleBuffered)) {
		MessageBox(GUI.hWnd,
				   Languages[GUI.Language].errModeDD,
				   "uosnes - DirectDraw",
				   MB_OK | MB_ICONSTOP);
		DirectX_DeInitialize();
		return FALSE;
	}
	GUI.ScreenDepth = (DWORD)DirectX.Depth;

    S9xSetWinPixelFormat ();

    if(!S9xGraphicsInit())
    	return FALSE;

	S9xInitUpdate();

    if(!S9xInitAPU())
    	return FALSE;

	//init SNES sound
	int _1msc = 0;
	for (; (_1msc * 1000) < Settings.SoundPlaybackRate; _1msc++);
	int buffer_bytes = _1msc * Settings.SoundMixInterval *
		(Settings.Stereo ? 2 : 1) * (Settings.SixteenBitSound ? 2 : 1);
    S9xInitSound(7, Settings.Stereo, buffer_bytes);

	if(!UosneswSetupSound(SoundRates[Options.SoundRate],
						  Options.SoundBit == 16,
						  Options.SoundChn == 2)) {
		MessageBox(GUI.hWnd,
				   Languages[GUI.Language].errInitSound,
				   "uosnes - Sound",
				   MB_OK | MB_ICONINFORMATION);
	}

	return TRUE;
}

void DeinitUosnesw()
{
#ifdef DEBUGGER
    extern FILE *trace;
	extern FILE *trace2;
	if(trace)
		fclose(trace);
	if(trace2)
		fclose(trace2);
#endif
	//Release input resources
	UosneswReleaseInput();
	//Release sound resources
	UosneswReleaseSound();
	//Release DirectX resources
	DirectX_DeInitialize();

	Memory.Deinit();
	S9xGraphicsDeinit();
	S9xDeinitAPU();
}

extern "C"
{
	char*osd_GetPackDir()
	{
		static char filename[MAX_PATH];
		memset(filename, 0, MAX_PATH);
		
		if(strlen(GUI.FreezeFileDir)!=0)
			strcpy (filename, GUI.FreezeFileDir);
		else
		{
			char dir [_MAX_DIR + 1];
			char drive [_MAX_DRIVE + 1];
			char name [_MAX_FNAME + 1];
			char ext [_MAX_EXT + 1];
			_splitpath(Memory.ROMFilename,drive, dir, name, ext);
			_makepath(filename,drive, dir, NULL, NULL);
		}
		
		if(!strncmp((char*)&Memory.ROM [0xffc0], "SUPER POWER LEAG 4   ", 21))
		{
			strcat(filename, "\\SPL4-SP7");
		}
		else if(!strncmp((char*)&Memory.ROM [0xffc0], "MOMOTETSU HAPPY      ",21))
		{
			strcat(filename, "\\SMHT-SP7");
		}
		else if(!strncmp((char*)&Memory.ROM [0xffc0], "HU TENGAI MAKYO ZERO ", 21))
		{
			strcat(filename, "\\FEOEZSP7");
		}
		else if(!strncmp((char*)&Memory.ROM [0xffc0], "JUMP TENGAIMAKYO ZERO",21))
		{
			strcat(filename, "\\SJUMPSP7");
		}
		else strcat(filename, "\\MISC-SP7");
		return filename;
	}
}

bool JustifierOffscreen()
{
	return (bool)((GUI.MouseButtons&2)!=0);
}

void JustifierButtons(uint32& justifiers)
{
	{
		if((GUI.MouseButtons&1)||(GUI.MouseButtons&2))
		{
			justifiers|=0x00100;
		}
		if(GUI.MouseButtons&4)
		{
			justifiers|=0x00400;
		}
	}
}

static void FrameTimerProc(void *tParams)
{
	if(GUI.PauseEmulation || GUI.StopEmulation || GUI.ForcedPauseEmulation)
		EnterMeteredSection(GUI.FrameTimerMeteredSection, 0);
	else
		LeaveMeteredSection(GUI.FrameTimerMeteredSection, 1, NULL);
	return;
}

BOOL UosneswSetupFrameTimer(DWORD ms)
{
	return SetupFrameTimer(ms,
						   FrameTimerProc,
						   NULL, GUI.hWnd);
}

void DoAVIOpen(const char* filename)
{
}

void DoAVIClose(int reason)
{
}

