
/*********************************************************************************************/
/*                                                                                           */
/*********************************************************************************************/

#include "snes9x.h"
#include "memmap.h"
#include "ppu.h"
#include "display.h"
#include "apu.h"
#include "soundux.h"

int Voicer_CdPlayWaitSet;
int Voicer_CdPlayWaitTime;
int Voicer_CdPlayWaitFlag;

void Emit1_Story ();
void Emit1_Mondai ();
void Emit2_Story ();
void Emit2_Mondai ();
void Emit3_Story ();
void Emit3_Mondai ();
void Voicerkun_CDDA_Sync ();
void Voicerkun_CDDA_Change ();

#define VOICER_CD_WAITTIME 110
#define VOICER_CD_WAITTIME_ZERO 1

void VOICERKUN_MEMORYFIX ()
{

if(Xxxcdda.Enable)
{

    if(Xxxcdda.VoicerCDChange) Voicerkun_CDDA_Change ();

    if (Memory.HiROM && strncmp ((char *) &Memory.ROM [0xffc0], "EMIT Vol.1", 10) == 0)
    {

      //0x214e Đԍ 
      //0x214f  K肩fꏊ 0x3ƗK
      //0x2150 0 p 1{ 
      //0x2154 0̑ 1bp[g
      //0x2156 0fBXNP 1fBXN2
      //0x2157 K
      //0x2159 1Đ 2|[Y 

      int vo_214e,vo_214f,vo_2150,vo_2154,vo_2156,vo_2157,vo_2159;

          vo_214e = Memory.RAM [0x214e];
          vo_214f = Memory.RAM [0x214f];
          vo_2150 = Memory.RAM [0x2150];
          vo_2154 = Memory.RAM [0x2154];
          vo_2156 = Memory.RAM [0x2156];
          vo_2157 = Memory.RAM [0x2157];
          vo_2159 = Memory.RAM [0x2159];

	  //Settings.H_Max = (100 * SNES_CYCLES_PER_SCANLINE) / 100;
      Voicerkun_CDDA_Sync ();

      if (vo_2159 == 2)
      {
	  cdda_stop();
         Xxxcdda.Soundlink_cd_track = 0;
         Voicer_CdPlayWaitFlag = 1;
      }

      if (vo_2159 == 0)
      {
	  cdda_stop();
         Xxxcdda.Soundlink_cd_track = 0;
         Voicer_CdPlayWaitFlag = 1;
      }

      if (vo_2159 == 1)
      {
        if ((vo_214f & 3)==0)
         Emit1_Story ();
         else
         Emit1_Mondai ();   
      }

      if(Voicer_CdPlayWaitSet)
      {
         if(Voicer_CdPlayWaitTime==0 || Voicer_CdPlayWaitFlag==1)
         {
                 cdda_play();
                 Voicer_CdPlayWaitSet = 0;
                 Voicer_CdPlayWaitFlag = 0;
         }
         else
                 Voicer_CdPlayWaitTime--;
      }


    }

    if (Memory.HiROM && strncmp ((char *) &Memory.ROM [0xffc0], "EMIT Vol.2", 10) == 0)
    {

      //0x214e Đԍ 
      //0x214f  K肩fꏊ 0x3ƗK
      //0x2150 0 p 1{ 
      //0x2154 0̑ 1bp[g
      //0x2156 0fBXNP 1fBXN2
      //0x2157 K
      //0x2159 1Đ 2|[Y 

      int vo_214e,vo_214f,vo_2150,vo_2154,vo_2156,vo_2157,vo_2159;

          vo_214e = Memory.RAM [0x214e];
          vo_214f = Memory.RAM [0x214f];
          vo_2150 = Memory.RAM [0x2150];
          vo_2154 = Memory.RAM [0x2154];
          vo_2156 = Memory.RAM [0x2156];
          vo_2157 = Memory.RAM [0x2157];
          vo_2159 = Memory.RAM [0x2159];

	  //Settings.H_Max = (100 * SNES_CYCLES_PER_SCANLINE) / 100;
      Voicerkun_CDDA_Sync ();

      if (vo_2159 == 2)
      {
	  cdda_stop();
         Xxxcdda.Soundlink_cd_track = 0;
         Voicer_CdPlayWaitFlag = 1;
      }

      if (vo_2159 == 0)
      {
	  cdda_stop();
         Xxxcdda.Soundlink_cd_track = 0;
         Voicer_CdPlayWaitFlag = 1;
      }

      if (vo_2159 == 1)
      {
        if ((vo_214f & 3)==0)
         Emit2_Story ();
         else
         Emit2_Mondai ();   
      }

      if(Voicer_CdPlayWaitSet)
      {
         if(Voicer_CdPlayWaitTime==0 || Voicer_CdPlayWaitFlag==1)
         {
                 cdda_play();
                 Voicer_CdPlayWaitSet = 0;
                 Voicer_CdPlayWaitFlag = 0;
         }
         else
                 Voicer_CdPlayWaitTime--;
      }

    }

    if (Memory.HiROM && strncmp ((char *) &Memory.ROM [0xffc0], "EMIT Vol.3", 10) == 0)
    {

      //0x214e Đԍ 
      //0x214f  K肩fꏊ 0x3ƗK
      //0x2150 0 p 1{ 
      //0x2154 0̑ 1bp[g
      //0x2156 0fBXNP 1fBXN2
      //0x2157 K
      //0x2159 1Đ 2|[Y 

      int vo_214e,vo_214f,vo_2150,vo_2154,vo_2156,vo_2157,vo_2159;

          vo_214e = Memory.RAM [0x214e];
          vo_214f = Memory.RAM [0x214f];
          vo_2150 = Memory.RAM [0x2150];
          vo_2154 = Memory.RAM [0x2154];
          vo_2156 = Memory.RAM [0x2156];
          vo_2157 = Memory.RAM [0x2157];
          vo_2159 = Memory.RAM [0x2159];

	  //Settings.H_Max = (100 * SNES_CYCLES_PER_SCANLINE) / 100;
      Voicerkun_CDDA_Sync ();

      if (vo_2159 == 2)
      {
	  cdda_stop();
         Xxxcdda.Soundlink_cd_track = 0;
         Voicer_CdPlayWaitFlag = 1;
      }

      if (vo_2159 == 0)
      {
	  cdda_stop();
         Xxxcdda.Soundlink_cd_track = 0;
         Voicer_CdPlayWaitFlag = 1;
      }

      if (vo_2159 == 1)
      {
         if ((vo_214f & 3)==0)
         Emit3_Story ();
         else
         Emit3_Mondai ();   
      }

      if(Voicer_CdPlayWaitSet)
      {
         if(Voicer_CdPlayWaitTime==0 || Voicer_CdPlayWaitFlag==1)
         {
                 cdda_play();
                 Voicer_CdPlayWaitSet = 0;
                 Voicer_CdPlayWaitFlag = 0;
         }
         else
                 Voicer_CdPlayWaitTime--;
      }

    } 

    if (Memory.HiROM && strncmp ((char *) &Memory.ROM [0xffc0], "ݼުذ ޫ̧ް", 21) == 0)
    {

      //0x7c66 Đԍ 
      //0x7c67 0|[YȂ@1 |[Y
      //0x7c68 0? 1Đ 2Xgbv

      int vo_7c66,vo_7c67,vo_7c68;
          vo_7c66 = Memory.RAM [0x7c66];
          vo_7c67 = Memory.RAM [0x7c67];
          vo_7c68 = Memory.RAM [0x7c68];
	  //Settings.H_Max = (100 * SNES_CYCLES_PER_SCANLINE) / 100;
      Voicerkun_CDDA_Sync ();

      if (vo_7c68 == 2)
      {
	  cdda_stop();
         Xxxcdda.Soundlink_cd_track = 0;
      }

      if (vo_7c68 == 0)
      {
	  cdda_stop();
         Xxxcdda.Soundlink_cd_track = 0;
      }

      if (vo_7c68 == 1 && vo_7c67 == 0 && Xxxcdda.Soundlink_cd_track!=vo_7c66)
      {
         Xxxcdda.Soundlink_cd_track=vo_7c66;
	  cdda_stop();
         cdda_play();
      }
    }
}

}

void Voicerkun_CDDA_Sync ()
{
}

void Voicerkun_CDDA_Change ()
{
	  cdda_exit();
	  cdda_open();
         Xxxcdda.VoicerCDChange=0;
}


void Emit1_Story ()
{
      //0x214e Đԍ 
      //0x214f  K肩fꏊ 0x3ƗK
      //0x2150 0 p 1{ 
      //0x2154 0̑ 1bp[g
      //0x2156 0fBXNP 1fBXN2
      //0x2157 K
      //0x2159 1Đ 2|[Y 

      int vo_214e,vo_214f,vo_2150,vo_2154,vo_2156,vo_2157,vo_2159;
          vo_214e = Memory.RAM [0x214e];
          vo_214f = Memory.RAM [0x214f];
          vo_2150 = Memory.RAM [0x2150];
          vo_2154 = Memory.RAM [0x2154];
          vo_2156 = Memory.RAM [0x2156];
          vo_2157 = Memory.RAM [0x2157];
          vo_2159 = Memory.RAM [0x2159];

// I[vjO
      if (vo_214e == 0 && vo_2154 == 0 && vo_2159 == 1 && Xxxcdda.Soundlink_cd_track!= 1)
      {
         Xxxcdda.Soundlink_cd_track=1;
         Voicer_CdPlayWaitFlag = 0;
	  cdda_stop();
         cdda_play();
         //Settings.H_Max = (85 * SNES_CYCLES_PER_SCANLINE) / 100;
      }

// GfBO
      if (vo_214e == 74 && vo_2159 == 1 && Xxxcdda.Soundlink_cd_track!= 2)
      {
         Xxxcdda.Soundlink_cd_track=2;
         Voicer_CdPlayWaitFlag = 0;
	  cdda_stop();
         cdda_play();
         //Settings.H_Max = (85 * SNES_CYCLES_PER_SCANLINE) / 100;
       }

// 1͉p
      if (vo_214e == 0 && vo_2150 == 0 && vo_2154 == 1 && vo_2156 == 0 && vo_2159 == 1 && Xxxcdda.Soundlink_cd_track!= 4)
      {
         Xxxcdda.Soundlink_cd_track=4;
         Voicer_CdPlayWaitFlag = 0;
	  cdda_stop();
         cdda_play();
      }
      if (vo_214e == 1 && vo_2150 == 0 && vo_2154 == 1 && vo_2156 == 0 && vo_2159 == 1 && Xxxcdda.Soundlink_cd_track!= 5)
      {
         Xxxcdda.Soundlink_cd_track=5;
	  cdda_stop();
         Voicer_CdPlayWaitSet=1;
         Voicer_CdPlayWaitTime=VOICER_CD_WAITTIME;
      }
      if (vo_214e == 2 && vo_2150 == 0 && vo_2154 == 1 && vo_2156 == 0 && vo_2159 == 1 && Xxxcdda.Soundlink_cd_track!= 6)
      {
         Xxxcdda.Soundlink_cd_track=6;
	  cdda_stop();
         Voicer_CdPlayWaitSet=1;
         Voicer_CdPlayWaitTime=VOICER_CD_WAITTIME;
      }
      if (vo_214e == 3 && vo_2150 == 0 && vo_2154 == 1 && vo_2156 == 0 && vo_2159 == 1 && Xxxcdda.Soundlink_cd_track!= 7)
      {
         Xxxcdda.Soundlink_cd_track=7;
	  cdda_stop();
         Voicer_CdPlayWaitSet=1;
         Voicer_CdPlayWaitTime=VOICER_CD_WAITTIME;
      }
      if (vo_214e == 4 && vo_2150 == 0 && vo_2154 == 1 && vo_2156 == 0 && vo_2159 == 1 && Xxxcdda.Soundlink_cd_track!= 8)
      {
         Xxxcdda.Soundlink_cd_track=8;
	  cdda_stop();
         Voicer_CdPlayWaitSet=1;
         Voicer_CdPlayWaitTime=VOICER_CD_WAITTIME;
      }
      if (vo_214e == 5 && vo_2150 == 0 && vo_2154 == 1 && vo_2156 == 0 && vo_2159 == 1 && Xxxcdda.Soundlink_cd_track!= 9)
      {
         Xxxcdda.Soundlink_cd_track=9;
	  cdda_stop();
         Voicer_CdPlayWaitSet=1;
         Voicer_CdPlayWaitTime=VOICER_CD_WAITTIME;
      }
      if (vo_214e == 6 && vo_2150 == 0 && vo_2154 == 1 && vo_2156 == 0 && vo_2159 == 1 && Xxxcdda.Soundlink_cd_track!= 10)
      {
         Xxxcdda.Soundlink_cd_track=10;
	  cdda_stop();
         Voicer_CdPlayWaitSet=1;
         Voicer_CdPlayWaitTime=VOICER_CD_WAITTIME;
      }
      if (vo_214e == 7 && vo_2150 == 0 && vo_2154 == 1 && vo_2156 == 0 && vo_2159 == 1 && Xxxcdda.Soundlink_cd_track!= 11)
      {
         Xxxcdda.Soundlink_cd_track=11;
	  cdda_stop();
         Voicer_CdPlayWaitSet=1;
         Voicer_CdPlayWaitTime=VOICER_CD_WAITTIME;
      }
      if (vo_214e == 8 && vo_2150 == 0 && vo_2154 == 1 && vo_2156 == 0 && vo_2159 == 1 && Xxxcdda.Soundlink_cd_track!= 12)
      {
         Xxxcdda.Soundlink_cd_track=12;
	  cdda_stop();
         Voicer_CdPlayWaitSet=1;
         Voicer_CdPlayWaitTime=VOICER_CD_WAITTIME;
      }
      if (vo_214e == 9 && vo_2150 == 0 && vo_2154 == 1 && vo_2156 == 0 && vo_2159 == 1 && Xxxcdda.Soundlink_cd_track!= 13)
      {
         Xxxcdda.Soundlink_cd_track=13;
	  cdda_stop();
         Voicer_CdPlayWaitSet=1;
         Voicer_CdPlayWaitTime=VOICER_CD_WAITTIME;
      }
      if (vo_214e == 10 && vo_2150 == 0 && vo_2154 == 1 && vo_2156 == 0 && vo_2159 == 1 && Xxxcdda.Soundlink_cd_track!= 14)
      {
         Xxxcdda.Soundlink_cd_track=14;
	  cdda_stop();
         Voicer_CdPlayWaitSet=1;
         Voicer_CdPlayWaitTime=VOICER_CD_WAITTIME;
      }

// 1͓{
      if (vo_214e == 0 && vo_2150 == 1 && vo_2154 == 1 && vo_2156 == 0 && vo_2159 == 1 && Xxxcdda.Soundlink_cd_track!= 15)
      {
         Xxxcdda.Soundlink_cd_track=15;
         Voicer_CdPlayWaitFlag = 0;
	  cdda_stop();
         cdda_play();
      }
      if (vo_214e == 1 && vo_2150 == 1 && vo_2154 == 1 && vo_2156 == 0 && vo_2159 == 1 && Xxxcdda.Soundlink_cd_track!= 16)
      {
         Xxxcdda.Soundlink_cd_track=16;
	  cdda_stop();
         Voicer_CdPlayWaitSet=1;
         Voicer_CdPlayWaitTime=VOICER_CD_WAITTIME;
      }
      if (vo_214e == 2 && vo_2150 == 1 && vo_2154 == 1 && vo_2156 == 0 && vo_2159 == 1 && Xxxcdda.Soundlink_cd_track!= 17)
      {
         Xxxcdda.Soundlink_cd_track=17;
	  cdda_stop();
         Voicer_CdPlayWaitSet=1;
         Voicer_CdPlayWaitTime=VOICER_CD_WAITTIME;
      }
      if (vo_214e == 3 && vo_2150 == 1 && vo_2154 == 1 && vo_2156 == 0 && vo_2159 == 1 && Xxxcdda.Soundlink_cd_track!= 18)
      {
         Xxxcdda.Soundlink_cd_track=18;
	  cdda_stop();
         Voicer_CdPlayWaitSet=1;
         Voicer_CdPlayWaitTime=VOICER_CD_WAITTIME;
      }
      if (vo_214e == 4 && vo_2150 == 1 && vo_2154 == 1 && vo_2156 == 0 && vo_2159 == 1 && Xxxcdda.Soundlink_cd_track!= 19)
      {
         Xxxcdda.Soundlink_cd_track=19;
	  cdda_stop();
         Voicer_CdPlayWaitSet=1;
         Voicer_CdPlayWaitTime=VOICER_CD_WAITTIME;
      }
      if (vo_214e == 5 && vo_2150 == 1 && vo_2154 == 1 && vo_2156 == 0 && vo_2159 == 1 && Xxxcdda.Soundlink_cd_track!= 20)
      {
         Xxxcdda.Soundlink_cd_track=20;
	  cdda_stop();
         Voicer_CdPlayWaitSet=1;
         Voicer_CdPlayWaitTime=VOICER_CD_WAITTIME;
      }
      if (vo_214e == 6 && vo_2150 == 1 && vo_2154 == 1 && vo_2156 == 0 && vo_2159 == 1 && Xxxcdda.Soundlink_cd_track!= 21)
      {
         Xxxcdda.Soundlink_cd_track=21;
	  cdda_stop();
         Voicer_CdPlayWaitSet=1;
         Voicer_CdPlayWaitTime=VOICER_CD_WAITTIME;
      }
      if (vo_214e == 7 && vo_2150 == 1 && vo_2154 == 1 && vo_2156 == 0 && vo_2159 == 1 && Xxxcdda.Soundlink_cd_track!= 22)
      {
         Xxxcdda.Soundlink_cd_track=22;
	  cdda_stop();
         Voicer_CdPlayWaitSet=1;
         Voicer_CdPlayWaitTime=VOICER_CD_WAITTIME;
      }
      if (vo_214e == 8 && vo_2150 == 1 && vo_2154 == 1 && vo_2156 == 0 && vo_2159 == 1 && Xxxcdda.Soundlink_cd_track!= 23)
      {
         Xxxcdda.Soundlink_cd_track=23;
	  cdda_stop();
         Voicer_CdPlayWaitSet=1;
         Voicer_CdPlayWaitTime=VOICER_CD_WAITTIME;
      }
      if (vo_214e == 9 && vo_2150 == 1 && vo_2154 == 1 && vo_2156 == 0 && vo_2159 == 1 && Xxxcdda.Soundlink_cd_track!= 24)
      {
         Xxxcdda.Soundlink_cd_track=24;
	  cdda_stop();
         Voicer_CdPlayWaitSet=1;
         Voicer_CdPlayWaitTime=VOICER_CD_WAITTIME;
      }
      if (vo_214e == 10 && vo_2150 == 1 && vo_2154 == 1 && vo_2156 == 0 && vo_2159 == 1 && Xxxcdda.Soundlink_cd_track!= 25)
      {
         Xxxcdda.Soundlink_cd_track=25;
	  cdda_stop();
         Voicer_CdPlayWaitSet=1;
         Voicer_CdPlayWaitTime=VOICER_CD_WAITTIME;
      }

// 2͉p
      if (vo_214e == 11 && vo_2150 == 0 && vo_2154 == 1 && vo_2156 == 0 && vo_2159 == 1 && Xxxcdda.Soundlink_cd_track!= 34)
      {
         Xxxcdda.Soundlink_cd_track=34;
         Voicer_CdPlayWaitFlag = 0;
	  cdda_stop();
         cdda_play();
      }
      if (vo_214e == 12 && vo_2150 == 0 && vo_2154 == 1 && vo_2156 == 0 && vo_2159 == 1 && Xxxcdda.Soundlink_cd_track!= 35)
      {
         Xxxcdda.Soundlink_cd_track=35;
	  cdda_stop();
         Voicer_CdPlayWaitSet=1;
         Voicer_CdPlayWaitTime=VOICER_CD_WAITTIME;
      }
      if (vo_214e == 13 && vo_2150 == 0 && vo_2154 == 1 && vo_2156 == 0 && vo_2159 == 1 && Xxxcdda.Soundlink_cd_track!= 36)
      {
         Xxxcdda.Soundlink_cd_track=36;
	  cdda_stop();
         Voicer_CdPlayWaitSet=1;
         Voicer_CdPlayWaitTime=VOICER_CD_WAITTIME;
      }
      if (vo_214e == 14 && vo_2150 == 0 && vo_2154 == 1 && vo_2156 == 0 && vo_2159 == 1 && Xxxcdda.Soundlink_cd_track!= 37)
      {
         Xxxcdda.Soundlink_cd_track=37;
	  cdda_stop();
         Voicer_CdPlayWaitSet=1;
         Voicer_CdPlayWaitTime=VOICER_CD_WAITTIME;
      }
      if (vo_214e == 15 && vo_2150 == 0 && vo_2154 == 1 && vo_2156 == 0 && vo_2159 == 1 && Xxxcdda.Soundlink_cd_track!= 38)
      {
         Xxxcdda.Soundlink_cd_track=38;
	  cdda_stop();
         Voicer_CdPlayWaitSet=1;
         Voicer_CdPlayWaitTime=VOICER_CD_WAITTIME;
      }
      if (vo_214e == 16 && vo_2150 == 0 && vo_2154 == 1 && vo_2156 == 0 && vo_2159 == 1 && Xxxcdda.Soundlink_cd_track!= 39)
      {
         Xxxcdda.Soundlink_cd_track=39;
	  cdda_stop();
         Voicer_CdPlayWaitSet=1;
         Voicer_CdPlayWaitTime=VOICER_CD_WAITTIME;
      }
      if (vo_214e == 17 && vo_2150 == 0 && vo_2154 == 1 && vo_2156 == 0 && vo_2159 == 1 && Xxxcdda.Soundlink_cd_track!= 40)
      {
         Xxxcdda.Soundlink_cd_track=40;
	  cdda_stop();
         Voicer_CdPlayWaitSet=1;
         Voicer_CdPlayWaitTime=VOICER_CD_WAITTIME;
      }

// 2͓{
      if (vo_214e == 11 && vo_2150 == 1 && vo_2154 == 1 && vo_2156 == 0 && vo_2159 == 1 && Xxxcdda.Soundlink_cd_track!= 41)
      {
         Xxxcdda.Soundlink_cd_track=41;
         Voicer_CdPlayWaitFlag = 0;
	  cdda_stop();
         cdda_play();
      }
      if (vo_214e == 12 && vo_2150 == 1 && vo_2154 == 1 && vo_2156 == 0 && vo_2159 == 1 && Xxxcdda.Soundlink_cd_track!= 42)
      {
         Xxxcdda.Soundlink_cd_track=42;
	  cdda_stop();
         Voicer_CdPlayWaitSet=1;
         Voicer_CdPlayWaitTime=VOICER_CD_WAITTIME;
      }
      if (vo_214e == 13 && vo_2150 == 1 && vo_2154 == 1 && vo_2156 == 0 && vo_2159 == 1 && Xxxcdda.Soundlink_cd_track!= 43)
      {
         Xxxcdda.Soundlink_cd_track=43;
	  cdda_stop();
         Voicer_CdPlayWaitSet=1;
         Voicer_CdPlayWaitTime=VOICER_CD_WAITTIME;
      }
      if (vo_214e == 14 && vo_2150 == 1 && vo_2154 == 1 && vo_2156 == 0 && vo_2159 == 1 && Xxxcdda.Soundlink_cd_track!= 44)
      {
         Xxxcdda.Soundlink_cd_track=44;
	  cdda_stop();
         Voicer_CdPlayWaitSet=1;
         Voicer_CdPlayWaitTime=VOICER_CD_WAITTIME;
      }
      if (vo_214e == 15 && vo_2150 == 1 && vo_2154 == 1 && vo_2156 == 0 && vo_2159 == 1 && Xxxcdda.Soundlink_cd_track!= 45)
      {
         Xxxcdda.Soundlink_cd_track=45;
	  cdda_stop();
         Voicer_CdPlayWaitSet=1;
         Voicer_CdPlayWaitTime=VOICER_CD_WAITTIME;
      }
      if (vo_214e == 16 && vo_2150 == 1 && vo_2154 == 1 && vo_2156 == 0 && vo_2159 == 1 && Xxxcdda.Soundlink_cd_track!= 46)
      {
         Xxxcdda.Soundlink_cd_track=46;
	  cdda_stop();
         Voicer_CdPlayWaitSet=1;
         Voicer_CdPlayWaitTime=VOICER_CD_WAITTIME;
      }
      if (vo_214e == 17 && vo_2150 == 1 && vo_2154 == 1 && vo_2156 == 0 && vo_2159 == 1 && Xxxcdda.Soundlink_cd_track!= 47)
      {
         Xxxcdda.Soundlink_cd_track=47;
	  cdda_stop();
         Voicer_CdPlayWaitSet=1;
         Voicer_CdPlayWaitTime=VOICER_CD_WAITTIME;
      }

// 3͉p
      if (vo_214e == 18 && vo_2150 == 0 && vo_2154 == 1 && vo_2156 == 0 && vo_2159 == 1 && Xxxcdda.Soundlink_cd_track!= 53)
      {
         Xxxcdda.Soundlink_cd_track=53;
         Voicer_CdPlayWaitFlag = 0;
	  cdda_stop();
         cdda_play();
      }
      if (vo_214e == 19 && vo_2150 == 0 && vo_2154 == 1 && vo_2156 == 0 && vo_2159 == 1 && Xxxcdda.Soundlink_cd_track!= 54)
      {
         Xxxcdda.Soundlink_cd_track=54;
	  cdda_stop();
         Voicer_CdPlayWaitSet=1;
         Voicer_CdPlayWaitTime=VOICER_CD_WAITTIME;
      }
      if (vo_214e == 20 && vo_2150 == 0 && vo_2154 == 1 && vo_2156 == 0 && vo_2159 == 1 && Xxxcdda.Soundlink_cd_track!= 55)
      {
         Xxxcdda.Soundlink_cd_track=55;
	  cdda_stop();
         Voicer_CdPlayWaitSet=1;
         Voicer_CdPlayWaitTime=VOICER_CD_WAITTIME;
      }
      if (vo_214e == 21 && vo_2150 == 0 && vo_2154 == 1 && vo_2156 == 0 && vo_2159 == 1 && Xxxcdda.Soundlink_cd_track!= 56)
      {
         Xxxcdda.Soundlink_cd_track=56;
	  cdda_stop();
         Voicer_CdPlayWaitSet=1;
         Voicer_CdPlayWaitTime=VOICER_CD_WAITTIME;
      }
      if (vo_214e == 22 && vo_2150 == 0 && vo_2154 == 1 && vo_2156 == 0 && vo_2159 == 1 && Xxxcdda.Soundlink_cd_track!= 57)
      {
         Xxxcdda.Soundlink_cd_track=57;
	  cdda_stop();
         Voicer_CdPlayWaitSet=1;
         Voicer_CdPlayWaitTime=VOICER_CD_WAITTIME;
      }
      if (vo_214e == 23 && vo_2150 == 0 && vo_2154 == 1 && vo_2156 == 0 && vo_2159 == 1 && Xxxcdda.Soundlink_cd_track!= 58)
      {
         Xxxcdda.Soundlink_cd_track=58;
	  cdda_stop();
         Voicer_CdPlayWaitSet=1;
         Voicer_CdPlayWaitTime=VOICER_CD_WAITTIME;
      }
      if (vo_214e == 24 && vo_2150 == 0 && vo_2154 == 1 && vo_2156 == 0 && vo_2159 == 1 && Xxxcdda.Soundlink_cd_track!= 59)
      {
         Xxxcdda.Soundlink_cd_track=59;
	  cdda_stop();
         Voicer_CdPlayWaitSet=1;
         Voicer_CdPlayWaitTime=VOICER_CD_WAITTIME;
      }
      if (vo_214e == 25 && vo_2150 == 0 && vo_2154 == 1 && vo_2156 == 0 && vo_2159 == 1 && Xxxcdda.Soundlink_cd_track!= 60)
      {
         Xxxcdda.Soundlink_cd_track=60;
	  cdda_stop();
         Voicer_CdPlayWaitSet=1;
         Voicer_CdPlayWaitTime=VOICER_CD_WAITTIME;
      }
      if (vo_214e == 26 && vo_2150 == 0 && vo_2154 == 1 && vo_2156 == 0 && vo_2159 == 1 && Xxxcdda.Soundlink_cd_track!= 61)
      {
         Xxxcdda.Soundlink_cd_track=61;
	  cdda_stop();
         Voicer_CdPlayWaitSet=1;
         Voicer_CdPlayWaitTime=VOICER_CD_WAITTIME;
      }
      if (vo_214e == 27 && vo_2150 == 0 && vo_2154 == 1 && vo_2156 == 0 && vo_2159 == 1 && Xxxcdda.Soundlink_cd_track!= 62)
      {
         Xxxcdda.Soundlink_cd_track=62;
	  cdda_stop();
         Voicer_CdPlayWaitSet=1;
         Voicer_CdPlayWaitTime=VOICER_CD_WAITTIME;
      }
      if (vo_214e == 28 && vo_2150 == 0 && vo_2154 == 1 && vo_2156 == 0 && vo_2159 == 1 && Xxxcdda.Soundlink_cd_track!= 63)
      {
         Xxxcdda.Soundlink_cd_track=63;
	  cdda_stop();
         Voicer_CdPlayWaitSet=1;
         Voicer_CdPlayWaitTime=VOICER_CD_WAITTIME;
      }
      if (vo_214e == 29 && vo_2150 == 0 && vo_2154 == 1 && vo_2156 == 0 && vo_2159 == 1 && Xxxcdda.Soundlink_cd_track!= 64)
      {
         Xxxcdda.Soundlink_cd_track=64;
	  cdda_stop();
         Voicer_CdPlayWaitSet=1;
         Voicer_CdPlayWaitTime=VOICER_CD_WAITTIME;
      }
      if (vo_214e == 30 && vo_2150 == 0 && vo_2154 == 1 && vo_2156 == 0 && vo_2159 == 1 && Xxxcdda.Soundlink_cd_track!= 65)
      {
         Xxxcdda.Soundlink_cd_track=65;
	  cdda_stop();
         Voicer_CdPlayWaitSet=1;
         Voicer_CdPlayWaitTime=VOICER_CD_WAITTIME;
      }
      if (vo_214e == 31 && vo_2150 == 0 && vo_2154 == 1 && vo_2156 == 0 && vo_2159 == 1 && Xxxcdda.Soundlink_cd_track!= 66)
      {
         Xxxcdda.Soundlink_cd_track=66;
	  cdda_stop();
         Voicer_CdPlayWaitSet=1;
         Voicer_CdPlayWaitTime=VOICER_CD_WAITTIME;
      }

// 3͓{
      if (vo_214e == 18 && vo_2150 == 1 && vo_2154 == 1 && vo_2156 == 0 && vo_2159 == 1 && Xxxcdda.Soundlink_cd_track!= 67)
      {
         Xxxcdda.Soundlink_cd_track=67;
         Voicer_CdPlayWaitFlag = 0;
	  cdda_stop();
         cdda_play();
      }
      if (vo_214e == 19 && vo_2150 == 1 && vo_2154 == 1 && vo_2156 == 0 && vo_2159 == 1 && Xxxcdda.Soundlink_cd_track!= 68)
      {
         Xxxcdda.Soundlink_cd_track=68;
	  cdda_stop();
         Voicer_CdPlayWaitSet=1;
         Voicer_CdPlayWaitTime=VOICER_CD_WAITTIME;
      }
      if (vo_214e == 20 && vo_2150 == 1 && vo_2154 == 1 && vo_2156 == 0 && vo_2159 == 1 && Xxxcdda.Soundlink_cd_track!= 69)
      {
         Xxxcdda.Soundlink_cd_track=69;
	  cdda_stop();
         Voicer_CdPlayWaitSet=1;
         Voicer_CdPlayWaitTime=VOICER_CD_WAITTIME;
      }
      if (vo_214e == 21 && vo_2150 == 1 && vo_2154 == 1 && vo_2156 == 0 && vo_2159 == 1 && Xxxcdda.Soundlink_cd_track!= 70)
      {
         Xxxcdda.Soundlink_cd_track=70;
	  cdda_stop();
         Voicer_CdPlayWaitSet=1;
         Voicer_CdPlayWaitTime=VOICER_CD_WAITTIME;
      }
      if (vo_214e == 22 && vo_2150 == 1 && vo_2154 == 1 && vo_2156 == 0 && vo_2159 == 1 && Xxxcdda.Soundlink_cd_track!= 71)
      {
         Xxxcdda.Soundlink_cd_track=71;
	  cdda_stop();
         Voicer_CdPlayWaitSet=1;
         Voicer_CdPlayWaitTime=VOICER_CD_WAITTIME;
      }
      if (vo_214e == 23 && vo_2150 == 1 && vo_2154 == 1 && vo_2156 == 0 && vo_2159 == 1 && Xxxcdda.Soundlink_cd_track!= 72)
      {
         Xxxcdda.Soundlink_cd_track=72;
	  cdda_stop();
         Voicer_CdPlayWaitSet=1;
         Voicer_CdPlayWaitTime=VOICER_CD_WAITTIME;
      }
      if (vo_214e == 24 && vo_2150 == 1 && vo_2154 == 1 && vo_2156 == 0 && vo_2159 == 1 && Xxxcdda.Soundlink_cd_track!= 73)
      {
         Xxxcdda.Soundlink_cd_track=73;
	  cdda_stop();
         Voicer_CdPlayWaitSet=1;
         Voicer_CdPlayWaitTime=VOICER_CD_WAITTIME;
      }
      if (vo_214e == 25 && vo_2150 == 1 && vo_2154 == 1 && vo_2156 == 0 && vo_2159 == 1 && Xxxcdda.Soundlink_cd_track!= 74)
      {
         Xxxcdda.Soundlink_cd_track=74;
	  cdda_stop();
         Voicer_CdPlayWaitSet=1;
         Voicer_CdPlayWaitTime=VOICER_CD_WAITTIME;
      }
      if (vo_214e == 26 && vo_2150 == 1 && vo_2154 == 1 && vo_2156 == 0 && vo_2159 == 1 && Xxxcdda.Soundlink_cd_track!= 75)
      {
         Xxxcdda.Soundlink_cd_track=75;
	  cdda_stop();
         Voicer_CdPlayWaitSet=1;
         Voicer_CdPlayWaitTime=VOICER_CD_WAITTIME;
      }
      if (vo_214e == 27 && vo_2150 == 1 && vo_2154 == 1 && vo_2156 == 0 && vo_2159 == 1 && Xxxcdda.Soundlink_cd_track!= 76)
      {
         Xxxcdda.Soundlink_cd_track=76;
	  cdda_stop();
         Voicer_CdPlayWaitSet=1;
         Voicer_CdPlayWaitTime=VOICER_CD_WAITTIME;
      }
      if (vo_214e == 28 && vo_2150 == 1 && vo_2154 == 1 && vo_2156 == 0 && vo_2159 == 1 && Xxxcdda.Soundlink_cd_track!= 77)
      {
         Xxxcdda.Soundlink_cd_track=77;
	  cdda_stop();
         Voicer_CdPlayWaitSet=1;
         Voicer_CdPlayWaitTime=VOICER_CD_WAITTIME;
      }
      if (vo_214e == 29 && vo_2150 == 1 && vo_2154 == 1 && vo_2156 == 0 && vo_2159 == 1 && Xxxcdda.Soundlink_cd_track!= 78)
      {
         Xxxcdda.Soundlink_cd_track=78;
	  cdda_stop();
         Voicer_CdPlayWaitSet=1;
         Voicer_CdPlayWaitTime=VOICER_CD_WAITTIME;
      }
      if (vo_214e == 30 && vo_2150 == 1 && vo_2154 == 1 && vo_2156 == 0 && vo_2159 == 1 && Xxxcdda.Soundlink_cd_track!= 79)
      {
         Xxxcdda.Soundlink_cd_track=79;
	  cdda_stop();
         Voicer_CdPlayWaitSet=1;
         Voicer_CdPlayWaitTime=VOICER_CD_WAITTIME;
      }
      if (vo_214e == 31 && vo_2150 == 1 && vo_2154 == 1 && vo_2156 == 0 && vo_2159 == 1 && Xxxcdda.Soundlink_cd_track!= 80)
      {
         Xxxcdda.Soundlink_cd_track=80;
	  cdda_stop();
         Voicer_CdPlayWaitSet=1;
         Voicer_CdPlayWaitTime=VOICER_CD_WAITTIME;
      }

// 4͉p
      if (vo_214e == 32 && vo_2150 == 0 && vo_2154 == 1 && vo_2156 == 0 && vo_2159 == 1 && Xxxcdda.Soundlink_cd_track!= 90)
      {
         Xxxcdda.Soundlink_cd_track=90;
	  cdda_stop();
         Voicer_CdPlayWaitSet=1;
         Voicer_CdPlayWaitTime=VOICER_CD_WAITTIME_ZERO;
      }
      if (vo_214e == 33 && vo_2150 == 0 && vo_2154 == 1 && vo_2156 == 0 && vo_2159 == 1 && Xxxcdda.Soundlink_cd_track!= 91)
      {
         Xxxcdda.Soundlink_cd_track=91;
	  cdda_stop();
         Voicer_CdPlayWaitSet=1;
         Voicer_CdPlayWaitTime=VOICER_CD_WAITTIME;
      }
      if (vo_214e == 34 && vo_2150 == 0 && vo_2154 == 1 && vo_2156 == 0 && vo_2159 == 1 && Xxxcdda.Soundlink_cd_track!= 92)
      {
         Xxxcdda.Soundlink_cd_track=92;
	  cdda_stop();
         Voicer_CdPlayWaitSet=1;
         Voicer_CdPlayWaitTime=VOICER_CD_WAITTIME;
      }
      if (vo_214e == 35 && vo_2150 == 0 && vo_2154 == 1 && vo_2156 == 0 && vo_2159 == 1 && Xxxcdda.Soundlink_cd_track!= 93)
      {
         Xxxcdda.Soundlink_cd_track=93;
	  cdda_stop();
         Voicer_CdPlayWaitSet=1;
         Voicer_CdPlayWaitTime=VOICER_CD_WAITTIME;
      }

// 4͓{
      if (vo_214e == 32 && vo_2150 == 1 && vo_2154 == 1 && vo_2156 == 0 && vo_2159 == 1 && Xxxcdda.Soundlink_cd_track!= 94)
      {
         Xxxcdda.Soundlink_cd_track=94;
	  cdda_stop();
         Voicer_CdPlayWaitSet=1;
         Voicer_CdPlayWaitTime=VOICER_CD_WAITTIME_ZERO;
      }
      if (vo_214e == 33 && vo_2150 == 1 && vo_2154 == 1 && vo_2156 == 0 && vo_2159 == 1 && Xxxcdda.Soundlink_cd_track!= 95)
      {
         Xxxcdda.Soundlink_cd_track=95;
	  cdda_stop();
         Voicer_CdPlayWaitSet=1;
         Voicer_CdPlayWaitTime=VOICER_CD_WAITTIME;
      }
      if (vo_214e == 34 && vo_2150 == 1 && vo_2154 == 1 && vo_2156 == 0 && vo_2159 == 1 && Xxxcdda.Soundlink_cd_track!= 96)
      {
         Xxxcdda.Soundlink_cd_track=96;
	  cdda_stop();
         cdda_play();
//         Voicer_CdPlayWaitSet=1;
//         Voicer_CdPlayWaitTime=VOICER_CD_WAITTIME;
      }
      if (vo_214e == 35 && vo_2150 == 1 && vo_2154 == 1 && vo_2156 == 0 && vo_2159 == 1 && Xxxcdda.Soundlink_cd_track!= 97)
      {
         Xxxcdda.Soundlink_cd_track=97;
	  cdda_stop();
         Voicer_CdPlayWaitSet=1;
         Voicer_CdPlayWaitTime=VOICER_CD_WAITTIME;
      }

// 5͉p
      if (vo_214e == 36 && vo_2150 == 0 && vo_2154 == 1 && vo_2156 == 1 && vo_2159 == 1 && Xxxcdda.Soundlink_cd_track!= 4)
      {
         Xxxcdda.Soundlink_cd_track=4;
         Voicer_CdPlayWaitFlag = 0;
	  cdda_stop();
         cdda_play();
      }
      if (vo_214e == 37 && vo_2150 == 0 && vo_2154 == 1 && vo_2156 == 1 && vo_2159 == 1 && Xxxcdda.Soundlink_cd_track!= 5)
      {
         Xxxcdda.Soundlink_cd_track=5;
	  cdda_stop();
         Voicer_CdPlayWaitSet=1;
         Voicer_CdPlayWaitTime=VOICER_CD_WAITTIME;
      }
      if (vo_214e == 38 && vo_2150 == 0 && vo_2154 == 1 && vo_2156 == 1 && vo_2159 == 1 && Xxxcdda.Soundlink_cd_track!= 6)
      {
         Xxxcdda.Soundlink_cd_track=6;
	  cdda_stop();
         Voicer_CdPlayWaitSet=1;
         Voicer_CdPlayWaitTime=VOICER_CD_WAITTIME;
      }
      if (vo_214e == 39 && vo_2150 == 0 && vo_2154 == 1 && vo_2156 == 1 && vo_2159 == 1 && Xxxcdda.Soundlink_cd_track!= 7)
      {
         Xxxcdda.Soundlink_cd_track=7;
	  cdda_stop();
         Voicer_CdPlayWaitSet=1;
         Voicer_CdPlayWaitTime=VOICER_CD_WAITTIME;
      }
      if (vo_214e == 40 && vo_2150 == 0 && vo_2154 == 1 && vo_2156 == 1 && vo_2159 == 1 && Xxxcdda.Soundlink_cd_track!= 8)
      {
         Xxxcdda.Soundlink_cd_track=8;
	  cdda_stop();
         Voicer_CdPlayWaitSet=1;
         Voicer_CdPlayWaitTime=VOICER_CD_WAITTIME;
      }
      if (vo_214e == 41 && vo_2150 == 0 && vo_2154 == 1 && vo_2156 == 1 && vo_2159 == 1 && Xxxcdda.Soundlink_cd_track!= 9)
      {
         Xxxcdda.Soundlink_cd_track=9;
	  cdda_stop();
         Voicer_CdPlayWaitSet=1;
         Voicer_CdPlayWaitTime=VOICER_CD_WAITTIME;
      }
      if (vo_214e == 42 && vo_2150 == 0 && vo_2154 == 1 && vo_2156 == 1 && vo_2159 == 1 && Xxxcdda.Soundlink_cd_track!= 10)
      {
         Xxxcdda.Soundlink_cd_track=10;
	  cdda_stop();
         Voicer_CdPlayWaitSet=1;
         Voicer_CdPlayWaitTime=VOICER_CD_WAITTIME;
      }
      if (vo_214e == 43 && vo_2150 == 0 && vo_2154 == 1 && vo_2156 == 1 && vo_2159 == 1 && Xxxcdda.Soundlink_cd_track!= 11)
      {
         Xxxcdda.Soundlink_cd_track=11;
	  cdda_stop();
         Voicer_CdPlayWaitSet=1;
         Voicer_CdPlayWaitTime=VOICER_CD_WAITTIME;
      }
      if (vo_214e == 44 && vo_2150 == 0 && vo_2154 == 1 && vo_2156 == 1 && vo_2159 == 1 && Xxxcdda.Soundlink_cd_track!= 12)
      {
         Xxxcdda.Soundlink_cd_track=12;
	  cdda_stop();
         Voicer_CdPlayWaitSet=1;
         Voicer_CdPlayWaitTime=VOICER_CD_WAITTIME;
      }
      if (vo_214e == 45 && vo_2150 == 0 && vo_2154 == 1 && vo_2156 == 1 && vo_2159 == 1 && Xxxcdda.Soundlink_cd_track!= 13)
      {
         Xxxcdda.Soundlink_cd_track=13;
	  cdda_stop();
         Voicer_CdPlayWaitSet=1;
         Voicer_CdPlayWaitTime=VOICER_CD_WAITTIME;
      }
      if (vo_214e == 46 && vo_2150 == 0 && vo_2154 == 1 && vo_2156 == 1 && vo_2159 == 1 && Xxxcdda.Soundlink_cd_track!= 14)
      {
         Xxxcdda.Soundlink_cd_track=14;
	  cdda_stop();
         Voicer_CdPlayWaitSet=1;
         Voicer_CdPlayWaitTime=VOICER_CD_WAITTIME;
      }

// 5͓{
      if (vo_214e == 36 && vo_2150 == 1 && vo_2154 == 1 && vo_2156 == 1 && vo_2159 == 1 && Xxxcdda.Soundlink_cd_track!= 15)
      {
         Xxxcdda.Soundlink_cd_track=15;
         Voicer_CdPlayWaitFlag = 0;
	  cdda_stop();
         cdda_play();
      }
      if (vo_214e == 37 && vo_2150 == 1 && vo_2154 == 1 && vo_2156 == 1 && vo_2159 == 1 && Xxxcdda.Soundlink_cd_track!= 16)
      {
         Xxxcdda.Soundlink_cd_track=16;
	  cdda_stop();
         Voicer_CdPlayWaitSet=1;
         Voicer_CdPlayWaitTime=VOICER_CD_WAITTIME;
      }
      if (vo_214e == 38 && vo_2150 == 1 && vo_2154 == 1 && vo_2156 == 1 && vo_2159 == 1 && Xxxcdda.Soundlink_cd_track!= 17)
      {
         Xxxcdda.Soundlink_cd_track=17;
	  cdda_stop();
         Voicer_CdPlayWaitSet=1;
         Voicer_CdPlayWaitTime=VOICER_CD_WAITTIME;
      }
      if (vo_214e == 39 && vo_2150 == 1 && vo_2154 == 1 && vo_2156 == 1 && vo_2159 == 1 && Xxxcdda.Soundlink_cd_track!= 18)
      {
         Xxxcdda.Soundlink_cd_track=18;
	  cdda_stop();
         Voicer_CdPlayWaitSet=1;
         Voicer_CdPlayWaitTime=VOICER_CD_WAITTIME;
      }
      if (vo_214e == 40 && vo_2150 == 1 && vo_2154 == 1 && vo_2156 == 1 && vo_2159 == 1 && Xxxcdda.Soundlink_cd_track!= 19)
      {
         Xxxcdda.Soundlink_cd_track=19;
	  cdda_stop();
         Voicer_CdPlayWaitSet=1;
         Voicer_CdPlayWaitTime=VOICER_CD_WAITTIME;
      }
      if (vo_214e == 41 && vo_2150 == 1 && vo_2154 == 1 && vo_2156 == 1 && vo_2159 == 1 && Xxxcdda.Soundlink_cd_track!= 20)
      {
         Xxxcdda.Soundlink_cd_track=20;
	  cdda_stop();
         Voicer_CdPlayWaitSet=1;
         Voicer_CdPlayWaitTime=VOICER_CD_WAITTIME;
      }
      if (vo_214e == 42 && vo_2150 == 1 && vo_2154 == 1 && vo_2156 == 1 && vo_2159 == 1 && Xxxcdda.Soundlink_cd_track!= 21)
      {
         Xxxcdda.Soundlink_cd_track=21;
	  cdda_stop();
         Voicer_CdPlayWaitSet=1;
         Voicer_CdPlayWaitTime=VOICER_CD_WAITTIME;
      }
      if (vo_214e == 43 && vo_2150 == 1 && vo_2154 == 1 && vo_2156 == 1 && vo_2159 == 1 && Xxxcdda.Soundlink_cd_track!= 22)
      {
         Xxxcdda.Soundlink_cd_track=22;
	  cdda_stop();
         Voicer_CdPlayWaitSet=1;
         Voicer_CdPlayWaitTime=VOICER_CD_WAITTIME;
      }
      if (vo_214e == 44 && vo_2150 == 1 && vo_2154 == 1 && vo_2156 == 1 && vo_2159 == 1 && Xxxcdda.Soundlink_cd_track!= 23)
      {
         Xxxcdda.Soundlink_cd_track=23;
	  cdda_stop();
         Voicer_CdPlayWaitSet=1;
         Voicer_CdPlayWaitTime=VOICER_CD_WAITTIME;
      }
      if (vo_214e == 45 && vo_2150 == 1 && vo_2154 == 1 && vo_2156 == 1 && vo_2159 == 1 && Xxxcdda.Soundlink_cd_track!= 24)
      {
         Xxxcdda.Soundlink_cd_track=24;
	  cdda_stop();
         Voicer_CdPlayWaitSet=1;
         Voicer_CdPlayWaitTime=VOICER_CD_WAITTIME;
      }
      if (vo_214e == 46 && vo_2150 == 1 && vo_2154 == 1 && vo_2156 == 1 && vo_2159 == 1 && Xxxcdda.Soundlink_cd_track!= 25)
      {
         Xxxcdda.Soundlink_cd_track=25;
	  cdda_stop();
         Voicer_CdPlayWaitSet=1;
         Voicer_CdPlayWaitTime=VOICER_CD_WAITTIME;
      }

// 6͉p
      if (vo_214e == 47 && vo_2150 == 0 && vo_2154 == 1 && vo_2156 == 1 && vo_2159 == 1 && Xxxcdda.Soundlink_cd_track!= 31)
      {
         Xxxcdda.Soundlink_cd_track=31;
         Voicer_CdPlayWaitFlag = 0;
	  cdda_stop();
         cdda_play();
      }
      if (vo_214e == 48 && vo_2150 == 0 && vo_2154 == 1 && vo_2156 == 1 && vo_2159 == 1 && Xxxcdda.Soundlink_cd_track!= 32)
      {
         Xxxcdda.Soundlink_cd_track=32;
	  cdda_stop();
         Voicer_CdPlayWaitSet=1;
         Voicer_CdPlayWaitTime=VOICER_CD_WAITTIME;
      }
      if (vo_214e == 49 && vo_2150 == 0 && vo_2154 == 1 && vo_2156 == 1 && vo_2159 == 1 && Xxxcdda.Soundlink_cd_track!= 33)
      {
         Xxxcdda.Soundlink_cd_track=33;
	  cdda_stop();
         Voicer_CdPlayWaitSet=1;
         Voicer_CdPlayWaitTime=VOICER_CD_WAITTIME;
      }
      if (vo_214e == 50 && vo_2150 == 0 && vo_2154 == 1 && vo_2156 == 1 && vo_2159 == 1 && Xxxcdda.Soundlink_cd_track!= 34)
      {
         Xxxcdda.Soundlink_cd_track=34;
	  cdda_stop();
         Voicer_CdPlayWaitSet=1;
         Voicer_CdPlayWaitTime=VOICER_CD_WAITTIME;
      }
      if (vo_214e == 51 && vo_2150 == 0 && vo_2154 == 1 && vo_2156 == 1 && vo_2159 == 1 && Xxxcdda.Soundlink_cd_track!= 35)
      {
         Xxxcdda.Soundlink_cd_track=35;
	  cdda_stop();
         Voicer_CdPlayWaitSet=1;
         Voicer_CdPlayWaitTime=VOICER_CD_WAITTIME;
      }
      if (vo_214e == 52 && vo_2150 == 0 && vo_2154 == 1 && vo_2156 == 1 && vo_2159 == 1 && Xxxcdda.Soundlink_cd_track!= 36)
      {
         Xxxcdda.Soundlink_cd_track=36;
	  cdda_stop();
         Voicer_CdPlayWaitSet=1;
         Voicer_CdPlayWaitTime=VOICER_CD_WAITTIME;
      }
      if (vo_214e == 53 && vo_2150 == 0 && vo_2154 == 1 && vo_2156 == 1 && vo_2159 == 1 && Xxxcdda.Soundlink_cd_track!= 37)
      {
         Xxxcdda.Soundlink_cd_track=37;
	  cdda_stop();
         Voicer_CdPlayWaitSet=1;
         Voicer_CdPlayWaitTime=VOICER_CD_WAITTIME;
      }
      if (vo_214e == 54 && vo_2150 == 0 && vo_2154 == 1 && vo_2156 == 1 && vo_2159 == 1 && Xxxcdda.Soundlink_cd_track!= 38)
      {
         Xxxcdda.Soundlink_cd_track=38;
	  cdda_stop();
         Voicer_CdPlayWaitSet=1;
         Voicer_CdPlayWaitTime=VOICER_CD_WAITTIME;
      }

// 6͓{
      if (vo_214e == 47 && vo_2150 == 1 && vo_2154 == 1 && vo_2156 == 1 && vo_2159 == 1 && Xxxcdda.Soundlink_cd_track!= 39)
      {
         Xxxcdda.Soundlink_cd_track=39;
         Voicer_CdPlayWaitFlag = 0;
	  cdda_stop();
         cdda_play();
      }
      if (vo_214e == 48 && vo_2150 == 1 && vo_2154 == 1 && vo_2156 == 1 && vo_2159 == 1 && Xxxcdda.Soundlink_cd_track!= 40)
      {
         Xxxcdda.Soundlink_cd_track=40;
	  cdda_stop();
         Voicer_CdPlayWaitSet=1;
         Voicer_CdPlayWaitTime=VOICER_CD_WAITTIME;
      }
      if (vo_214e == 49 && vo_2150 == 1 && vo_2154 == 1 && vo_2156 == 1 && vo_2159 == 1 && Xxxcdda.Soundlink_cd_track!= 41)
      {
         Xxxcdda.Soundlink_cd_track=41;
	  cdda_stop();
         Voicer_CdPlayWaitSet=1;
         Voicer_CdPlayWaitTime=VOICER_CD_WAITTIME;
      }
      if (vo_214e == 50 && vo_2150 == 1 && vo_2154 == 1 && vo_2156 == 1 && vo_2159 == 1 && Xxxcdda.Soundlink_cd_track!= 42)
      {
         Xxxcdda.Soundlink_cd_track=42;
	  cdda_stop();
         Voicer_CdPlayWaitSet=1;
         Voicer_CdPlayWaitTime=VOICER_CD_WAITTIME;
      }
      if (vo_214e == 51 && vo_2150 == 1 && vo_2154 == 1 && vo_2156 == 1 && vo_2159 == 1 && Xxxcdda.Soundlink_cd_track!= 43)
      {
         Xxxcdda.Soundlink_cd_track=43;
	  cdda_stop();
         Voicer_CdPlayWaitSet=1;
         Voicer_CdPlayWaitTime=VOICER_CD_WAITTIME;
      }
      if (vo_214e == 52 && vo_2150 == 1 && vo_2154 == 1 && vo_2156 == 1 && vo_2159 == 1 && Xxxcdda.Soundlink_cd_track!= 44)
      {
         Xxxcdda.Soundlink_cd_track=44;
	  cdda_stop();
         Voicer_CdPlayWaitSet=1;
         Voicer_CdPlayWaitTime=VOICER_CD_WAITTIME;
      }
      if (vo_214e == 53 && vo_2150 == 1 && vo_2154 == 1 && vo_2156 == 1 && vo_2159 == 1 && Xxxcdda.Soundlink_cd_track!= 45)
      {
         Xxxcdda.Soundlink_cd_track=45;
	  cdda_stop();
         Voicer_CdPlayWaitSet=1;
         Voicer_CdPlayWaitTime=VOICER_CD_WAITTIME;
      }
      if (vo_214e == 54 && vo_2150 == 1 && vo_2154 == 1 && vo_2156 == 1 && vo_2159 == 1 && Xxxcdda.Soundlink_cd_track!= 46)
      {
         Xxxcdda.Soundlink_cd_track=46;
	  cdda_stop();
         Voicer_CdPlayWaitSet=1;
         Voicer_CdPlayWaitTime=VOICER_CD_WAITTIME;
      }

// 7͉p
      if (vo_214e == 55 && vo_2150 == 0 && vo_2154 == 1 && vo_2156 == 1 && vo_2159 == 1 && Xxxcdda.Soundlink_cd_track!= 50)
      {
         Xxxcdda.Soundlink_cd_track=50;
         Voicer_CdPlayWaitFlag = 0;
	  cdda_stop();
         cdda_play();
      }
      if (vo_214e == 56 && vo_2150 == 0 && vo_2154 == 1 && vo_2156 == 1 && vo_2159 == 1 && Xxxcdda.Soundlink_cd_track!= 51)
      {
         Xxxcdda.Soundlink_cd_track=51;
	  cdda_stop();
         Voicer_CdPlayWaitSet=1;
         Voicer_CdPlayWaitTime=VOICER_CD_WAITTIME;
      }
      if (vo_214e == 57 && vo_2150 == 0 && vo_2154 == 1 && vo_2156 == 1 && vo_2159 == 1 && Xxxcdda.Soundlink_cd_track!= 52)
      {
         Xxxcdda.Soundlink_cd_track=52;
	  cdda_stop();
         Voicer_CdPlayWaitSet=1;
         Voicer_CdPlayWaitTime=VOICER_CD_WAITTIME;
      }

// 7͓{
      if (vo_214e == 55 && vo_2150 == 1 && vo_2154 == 1 && vo_2156 == 1 && vo_2159 == 1 && Xxxcdda.Soundlink_cd_track!= 53)
      {
         Xxxcdda.Soundlink_cd_track=53;
         Voicer_CdPlayWaitFlag = 0;
	  cdda_stop();
         cdda_play();
      }
      if (vo_214e == 56 && vo_2150 == 1 && vo_2154 == 1 && vo_2156 == 1 && vo_2159 == 1 && Xxxcdda.Soundlink_cd_track!= 54)
      {
         Xxxcdda.Soundlink_cd_track=54;
	  cdda_stop();
         Voicer_CdPlayWaitSet=1;
         Voicer_CdPlayWaitTime=VOICER_CD_WAITTIME;
      }
      if (vo_214e == 57 && vo_2150 == 1 && vo_2154 == 1 && vo_2156 == 1 && vo_2159 == 1 && Xxxcdda.Soundlink_cd_track!= 55)
      {
         Xxxcdda.Soundlink_cd_track=55;
	  cdda_stop();
         Voicer_CdPlayWaitSet=1;
         Voicer_CdPlayWaitTime=VOICER_CD_WAITTIME;
      }

// 8͉p
      if (vo_214e == 58 && vo_2150 == 0 && vo_2154 == 1 && vo_2156 == 1 && vo_2159 == 1 && Xxxcdda.Soundlink_cd_track!= 58)
      {
         Xxxcdda.Soundlink_cd_track=58;
         Voicer_CdPlayWaitFlag = 0;
	  cdda_stop();
         cdda_play();
      }
      if (vo_214e == 59 && vo_2150 == 0 && vo_2154 == 1 && vo_2156 == 1 && vo_2159 == 1 && Xxxcdda.Soundlink_cd_track!= 59)
      {
         Xxxcdda.Soundlink_cd_track=59;
	  cdda_stop();
         Voicer_CdPlayWaitSet=1;
         Voicer_CdPlayWaitTime=VOICER_CD_WAITTIME;
      }
      if (vo_214e == 60 && vo_2150 == 0 && vo_2154 == 1 && vo_2156 == 1 && vo_2159 == 1 && Xxxcdda.Soundlink_cd_track!= 60)
      {
         Xxxcdda.Soundlink_cd_track=60;
	  cdda_stop();
         Voicer_CdPlayWaitSet=1;
         Voicer_CdPlayWaitTime=VOICER_CD_WAITTIME;
      }
      if (vo_214e == 61 && vo_2150 == 0 && vo_2154 == 1 && vo_2156 == 1 && vo_2159 == 1 && Xxxcdda.Soundlink_cd_track!= 61)
      {
         Xxxcdda.Soundlink_cd_track=61;
	  cdda_stop();
         Voicer_CdPlayWaitSet=1;
         Voicer_CdPlayWaitTime=VOICER_CD_WAITTIME;
      }

// 8͓{
      if (vo_214e == 58 && vo_2150 == 1 && vo_2154 == 1 && vo_2156 == 1 && vo_2159 == 1 && Xxxcdda.Soundlink_cd_track!= 62)
      {
         Xxxcdda.Soundlink_cd_track=62;
         Voicer_CdPlayWaitFlag = 0;
	  cdda_stop();
         cdda_play();
      }
      if (vo_214e == 59 && vo_2150 == 1 && vo_2154 == 1 && vo_2156 == 1 && vo_2159 == 1 && Xxxcdda.Soundlink_cd_track!= 63)
      {
         Xxxcdda.Soundlink_cd_track=63;
	  cdda_stop();
         Voicer_CdPlayWaitSet=1;
         Voicer_CdPlayWaitTime=VOICER_CD_WAITTIME;
      }
      if (vo_214e == 60 && vo_2150 == 1 && vo_2154 == 1 && vo_2156 == 1 && vo_2159 == 1 && Xxxcdda.Soundlink_cd_track!= 64)
      {
         Xxxcdda.Soundlink_cd_track=64;
	  cdda_stop();
         Voicer_CdPlayWaitSet=1;
         Voicer_CdPlayWaitTime=VOICER_CD_WAITTIME;
      }
      if (vo_214e == 61 && vo_2150 == 1 && vo_2154 == 1 && vo_2156 == 1 && vo_2159 == 1 && Xxxcdda.Soundlink_cd_track!= 65)
      {
         Xxxcdda.Soundlink_cd_track=65;
	  cdda_stop();
         Voicer_CdPlayWaitSet=1;
         Voicer_CdPlayWaitTime=VOICER_CD_WAITTIME;
      }

// 9͉p
      if (vo_214e == 62 && vo_2150 == 0 && vo_2154 == 1 && vo_2156 == 1 && vo_2159 == 1 && Xxxcdda.Soundlink_cd_track!= 69)
      {
         Xxxcdda.Soundlink_cd_track=69;
         Voicer_CdPlayWaitFlag = 0;
	  cdda_stop();
         cdda_play();
      }
      if (vo_214e == 63 && vo_2150 == 0 && vo_2154 == 1 && vo_2156 == 1 && vo_2159 == 1 && Xxxcdda.Soundlink_cd_track!= 70)
      {
         Xxxcdda.Soundlink_cd_track=70;
	  cdda_stop();
         Voicer_CdPlayWaitSet=1;
         Voicer_CdPlayWaitTime=VOICER_CD_WAITTIME;
      }
      if (vo_214e == 64 && vo_2150 == 0 && vo_2154 == 1 && vo_2156 == 1 && vo_2159 == 1 && Xxxcdda.Soundlink_cd_track!= 71)
      {
         Xxxcdda.Soundlink_cd_track=71;
	  cdda_stop();
         Voicer_CdPlayWaitSet=1;
         Voicer_CdPlayWaitTime=VOICER_CD_WAITTIME;
      }
      if (vo_214e == 65 && vo_2150 == 0 && vo_2154 == 1 && vo_2156 == 1 && vo_2159 == 1 && Xxxcdda.Soundlink_cd_track!= 72)
      {
         Xxxcdda.Soundlink_cd_track=72;
	  cdda_stop();
         Voicer_CdPlayWaitSet=1;
         Voicer_CdPlayWaitTime=VOICER_CD_WAITTIME;
      }
      if (vo_214e == 66 && vo_2150 == 0 && vo_2154 == 1 && vo_2156 == 1 && vo_2159 == 1 && Xxxcdda.Soundlink_cd_track!= 73)
      {
         Xxxcdda.Soundlink_cd_track=73;
	  cdda_stop();
         Voicer_CdPlayWaitSet=1;
         Voicer_CdPlayWaitTime=VOICER_CD_WAITTIME;
      }
      if (vo_214e == 67 && vo_2150 == 0 && vo_2154 == 1 && vo_2156 == 1 && vo_2159 == 1 && Xxxcdda.Soundlink_cd_track!= 74)
      {
         Xxxcdda.Soundlink_cd_track=74;
	  cdda_stop();
         Voicer_CdPlayWaitSet=1;
         Voicer_CdPlayWaitTime=VOICER_CD_WAITTIME;
      }

// 9͓{
      if (vo_214e == 62 && vo_2150 == 1 && vo_2154 == 1 && vo_2156 == 1 && vo_2159 == 1 && Xxxcdda.Soundlink_cd_track!= 75)
      {
         Xxxcdda.Soundlink_cd_track=75;
         Voicer_CdPlayWaitFlag = 0;
	  cdda_stop();
         cdda_play();
      }
      if (vo_214e == 63 && vo_2150 == 1 && vo_2154 == 1 && vo_2156 == 1 && vo_2159 == 1 && Xxxcdda.Soundlink_cd_track!= 76)
      {
         Xxxcdda.Soundlink_cd_track=76;
	  cdda_stop();
         Voicer_CdPlayWaitSet=1;
         Voicer_CdPlayWaitTime=VOICER_CD_WAITTIME;
      }
      if (vo_214e == 64 && vo_2150 == 1 && vo_2154 == 1 && vo_2156 == 1 && vo_2159 == 1 && Xxxcdda.Soundlink_cd_track!= 77)
      {
         Xxxcdda.Soundlink_cd_track=77;
	  cdda_stop();
         Voicer_CdPlayWaitSet=1;
         Voicer_CdPlayWaitTime=VOICER_CD_WAITTIME;
      }
      if (vo_214e == 65 && vo_2150 == 1 && vo_2154 == 1 && vo_2156 == 1 && vo_2159 == 1 && Xxxcdda.Soundlink_cd_track!= 78)
      {
         Xxxcdda.Soundlink_cd_track=78;
	  cdda_stop();
         Voicer_CdPlayWaitSet=1;
         Voicer_CdPlayWaitTime=VOICER_CD_WAITTIME;
      }
      if (vo_214e == 66 && vo_2150 == 1 && vo_2154 == 1 && vo_2156 == 1 && vo_2159 == 1 && Xxxcdda.Soundlink_cd_track!= 79)
      {
         Xxxcdda.Soundlink_cd_track=79;
	  cdda_stop();
         Voicer_CdPlayWaitSet=1;
         Voicer_CdPlayWaitTime=VOICER_CD_WAITTIME;
      }
      if (vo_214e == 67 && vo_2150 == 1 && vo_2154 == 1 && vo_2156 == 1 && vo_2159 == 1 && Xxxcdda.Soundlink_cd_track!= 80)
      {
         Xxxcdda.Soundlink_cd_track=80;
	  cdda_stop();
         Voicer_CdPlayWaitSet=1;
         Voicer_CdPlayWaitTime=VOICER_CD_WAITTIME;
      }

// 10͉p
      if (vo_214e == 68 && vo_2150 == 0 && vo_2154 == 1 && vo_2156 == 1 && vo_2159 == 1 && Xxxcdda.Soundlink_cd_track!= 84)
      {
         Xxxcdda.Soundlink_cd_track=84;
         Voicer_CdPlayWaitFlag = 0;
	  cdda_stop();
         cdda_play();
      }
      if (vo_214e == 69 && vo_2150 == 0 && vo_2154 == 1 && vo_2156 == 1 && vo_2159 == 1 && Xxxcdda.Soundlink_cd_track!= 85)
      {
         Xxxcdda.Soundlink_cd_track=85;
	  cdda_stop();
         Voicer_CdPlayWaitSet=1;
         Voicer_CdPlayWaitTime=VOICER_CD_WAITTIME;
      }
      if (vo_214e == 70 && vo_2150 == 0 && vo_2154 == 1 && vo_2156 == 1 && vo_2159 == 1 && Xxxcdda.Soundlink_cd_track!= 86)
      {
         Xxxcdda.Soundlink_cd_track=86;
	  cdda_stop();
         Voicer_CdPlayWaitSet=1;
         Voicer_CdPlayWaitTime=VOICER_CD_WAITTIME;
      }
      if (vo_214e == 71 && vo_2150 == 0 && vo_2154 == 1 && vo_2156 == 1 && vo_2159 == 1 && Xxxcdda.Soundlink_cd_track!= 87)
      {
         Xxxcdda.Soundlink_cd_track=87;
	  cdda_stop();
         Voicer_CdPlayWaitSet=1;
         Voicer_CdPlayWaitTime=VOICER_CD_WAITTIME;
      }
      if (vo_214e == 72 && vo_2150 == 0 && vo_2154 == 1 && vo_2156 == 1 && vo_2159 == 1 && Xxxcdda.Soundlink_cd_track!= 88)
      {
         Xxxcdda.Soundlink_cd_track=88;
	  cdda_stop();
         Voicer_CdPlayWaitSet=1;
         Voicer_CdPlayWaitTime=VOICER_CD_WAITTIME;
      }
      if (vo_214e == 73 && vo_2150 == 0 && vo_2154 == 1 && vo_2156 == 1 && vo_2159 == 1 && Xxxcdda.Soundlink_cd_track!= 89)
      {
         Xxxcdda.Soundlink_cd_track=89;
	  cdda_stop();
         Voicer_CdPlayWaitSet=1;
         Voicer_CdPlayWaitTime=VOICER_CD_WAITTIME;
      }

// 10͓{
      if (vo_214e == 68 && vo_2150 == 1 && vo_2154 == 1 && vo_2156 == 1 && vo_2159 == 1 && Xxxcdda.Soundlink_cd_track!= 90)
      {
         Xxxcdda.Soundlink_cd_track=90;
         Voicer_CdPlayWaitFlag = 0;
	  cdda_stop();
         cdda_play();
      }
      if (vo_214e == 69 && vo_2150 == 1 && vo_2154 == 1 && vo_2156 == 1 && vo_2159 == 1 && Xxxcdda.Soundlink_cd_track!= 91)
      {
         Xxxcdda.Soundlink_cd_track=91;
	  cdda_stop();
         Voicer_CdPlayWaitSet=1;
         Voicer_CdPlayWaitTime=VOICER_CD_WAITTIME;
      }
      if (vo_214e == 70 && vo_2150 == 1 && vo_2154 == 1 && vo_2156 == 1 && vo_2159 == 1 && Xxxcdda.Soundlink_cd_track!= 92)
      {
         Xxxcdda.Soundlink_cd_track=92;
	  cdda_stop();
         Voicer_CdPlayWaitSet=1;
         Voicer_CdPlayWaitTime=VOICER_CD_WAITTIME;
      }
      if (vo_214e == 71 && vo_2150 == 1 && vo_2154 == 1 && vo_2156 == 1 && vo_2159 == 1 && Xxxcdda.Soundlink_cd_track!= 93)
      {
         Xxxcdda.Soundlink_cd_track=93;
	  cdda_stop();
         Voicer_CdPlayWaitSet=1;
         Voicer_CdPlayWaitTime=VOICER_CD_WAITTIME;
      }
      if (vo_214e == 72 && vo_2150 == 1 && vo_2154 == 1 && vo_2156 == 1 && vo_2159 == 1 && Xxxcdda.Soundlink_cd_track!= 94)
      {
         Xxxcdda.Soundlink_cd_track=94;
	  cdda_stop();
         Voicer_CdPlayWaitSet=1;
         Voicer_CdPlayWaitTime=VOICER_CD_WAITTIME;
      }
      if (vo_214e == 73 && vo_2150 == 1 && vo_2154 == 1 && vo_2156 == 1 && vo_2159 == 1 && Xxxcdda.Soundlink_cd_track!= 95)
      {
         Xxxcdda.Soundlink_cd_track=95;
	  cdda_stop();
         Voicer_CdPlayWaitSet=1;
         Voicer_CdPlayWaitTime=VOICER_CD_WAITTIME;
      }
}

/*********************************************************************************************/
/* Emit1_Mondai                                                                               */
/*********************************************************************************************/

void Emit1_Mondai ()
{
      //0x214e Đԍ 
      //0x214f  K肩fꏊ 0x3ƗK
      //0x2150 0 p 1{ 
      //0x2154 0̑ 1bp[g
      //0x2156 0fBXNP 1fBXN2
      //0x2157 K
      //0x2159 1Đ 2|[Y 

      int vo_214e,vo_214f,vo_2150,vo_2154,vo_2156,vo_2157,vo_2159;
          vo_214e = Memory.RAM [0x214e];
          vo_214f = Memory.RAM [0x214f];
          vo_2150 = Memory.RAM [0x2150];
          vo_2154 = Memory.RAM [0x2154];
          vo_2156 = Memory.RAM [0x2156];
          vo_2157 = Memory.RAM [0x2157];
          vo_2159 = Memory.RAM [0x2159];

// 1 K
      if (vo_2157 == 0x19 && vo_2156 == 0 && vo_2159 == 1 && Xxxcdda.Soundlink_cd_track!= 26)
      {
         Xxxcdda.Soundlink_cd_track=26;
	  cdda_stop();
         cdda_play();
      }
      if (vo_2157 == 0x1a && vo_2156 == 0 && vo_2159 == 1 && Xxxcdda.Soundlink_cd_track!= 27)
      {
         Xxxcdda.Soundlink_cd_track=27;
	  cdda_stop();
         cdda_play();
      }
      if (vo_2157 == 0x1b && vo_2156 == 0 && vo_2159 == 1 && Xxxcdda.Soundlink_cd_track!= 28)
      {
         Xxxcdda.Soundlink_cd_track=28;
	  cdda_stop();
         cdda_play();
      }
      if (vo_2157 == 0x1c && vo_2156 == 0 && vo_2159 == 1 && Xxxcdda.Soundlink_cd_track!= 29)
      {
         Xxxcdda.Soundlink_cd_track=29;
	  cdda_stop();
         cdda_play();
      }
      if (vo_2157 == 0x1d && vo_2156 == 0 && vo_2159 == 1 && Xxxcdda.Soundlink_cd_track!= 30)
      {
         Xxxcdda.Soundlink_cd_track=30;
	  cdda_stop();
         cdda_play();
      }
      if (vo_2157 == 0x1e && vo_2156 == 0 && vo_2159 == 1 && Xxxcdda.Soundlink_cd_track!= 31)
      {
         Xxxcdda.Soundlink_cd_track=31;
	  cdda_stop();
         cdda_play();
      }
      if (vo_2157 == 0x1f && vo_2156 == 0 && vo_2159 == 1 && Xxxcdda.Soundlink_cd_track!= 32)
      {
         Xxxcdda.Soundlink_cd_track=32;
	  cdda_stop();
         cdda_play();
      }
      if (vo_2157 == 0x20 && vo_2156 == 0 && vo_2159 == 1 && Xxxcdda.Soundlink_cd_track!= 33)
      {
         Xxxcdda.Soundlink_cd_track=33;
	  cdda_stop();
         cdda_play();
      }

// 2 K
      if (vo_2157 == 0x2f && vo_2156 == 0 && vo_2159 == 1 && Xxxcdda.Soundlink_cd_track!= 48)
      {
         Xxxcdda.Soundlink_cd_track=48;
	  cdda_stop();
         cdda_play();
      }
      if (vo_2157 == 0x30 && vo_2156 == 0 && vo_2159 == 1 && Xxxcdda.Soundlink_cd_track!= 49)
      {
         Xxxcdda.Soundlink_cd_track=49;
	  cdda_stop();
         cdda_play();
      }
      if (vo_2157 == 0x31 && vo_2156 == 0 && vo_2159 == 1 && Xxxcdda.Soundlink_cd_track!= 50)
      {
         Xxxcdda.Soundlink_cd_track=50;
	  cdda_stop();
         cdda_play();
      }
      if (vo_2157 == 0x32 && vo_2156 == 0 && vo_2159 == 1 && Xxxcdda.Soundlink_cd_track!= 51)
      {
         Xxxcdda.Soundlink_cd_track=51;
	  cdda_stop();
         cdda_play();
      }
      if (vo_2157 == 0x33 && vo_2156 == 0 && vo_2159 == 1 && Xxxcdda.Soundlink_cd_track!= 52)
      {
         Xxxcdda.Soundlink_cd_track=52;
	  cdda_stop();
         cdda_play();
      }


// 3 K
      if (vo_2157 == 0x50 && vo_2156 == 0 && vo_2159 == 1 && Xxxcdda.Soundlink_cd_track!= 81)
      {
         Xxxcdda.Soundlink_cd_track=81;
	  cdda_stop();
         cdda_play();
      }
      if (vo_2157 == 0x51 && vo_2156 == 0 && vo_2159 == 1 && Xxxcdda.Soundlink_cd_track!= 82)
      {
         Xxxcdda.Soundlink_cd_track=82;
	  cdda_stop();
         cdda_play();
      }
      if (vo_2157 == 0x52 && vo_2156 == 0 && vo_2159 == 1 && Xxxcdda.Soundlink_cd_track!= 83)
      {
         Xxxcdda.Soundlink_cd_track=83;
	  cdda_stop();
         cdda_play();
      }

      if (vo_2157 == 0x53 && vo_2156 == 0 && vo_2159 == 1 && Xxxcdda.Soundlink_cd_track!= 84)
      {
         Xxxcdda.Soundlink_cd_track=84;
	  cdda_stop();
         cdda_play();
      }
      if (vo_2157 == 0x54 && vo_2156 == 0 && vo_2159 == 1 && Xxxcdda.Soundlink_cd_track!= 85)
      {
         Xxxcdda.Soundlink_cd_track=85;
	  cdda_stop();
         cdda_play();
      }
      if (vo_2157 == 0x55 && vo_2156 == 0 && vo_2159 == 1 && Xxxcdda.Soundlink_cd_track!= 86)
      {
         Xxxcdda.Soundlink_cd_track=86;
	  cdda_stop();
         cdda_play();
      }
      if (vo_2157 == 0x56 && vo_2156 == 0 && vo_2159 == 1 && Xxxcdda.Soundlink_cd_track!= 87)
      {
         Xxxcdda.Soundlink_cd_track=87;
	  cdda_stop();
         cdda_play();
      }
      if (vo_2157 == 0x57 && vo_2156 == 0 && vo_2159 == 1 && Xxxcdda.Soundlink_cd_track!= 88)
      {
         Xxxcdda.Soundlink_cd_track=88;
	  cdda_stop();
         cdda_play();
      }
      if (vo_2157 == 0x58 && vo_2156 == 0 && vo_2159 == 1 && Xxxcdda.Soundlink_cd_track!= 89)
      {
         Xxxcdda.Soundlink_cd_track=89;
	  cdda_stop();
         cdda_play();
      }


// 4 K
      if (vo_2157 == 0x61 && vo_2156 == 0 && vo_2159 == 1 && Xxxcdda.Soundlink_cd_track!= 98)
      {
         Xxxcdda.Soundlink_cd_track=98;
	  cdda_stop();
         cdda_play();
      }

// 5 K
      if (vo_2157 == 0x19 && vo_2156 == 1 && vo_2159 == 1 && Xxxcdda.Soundlink_cd_track!= 26)
      {
         Xxxcdda.Soundlink_cd_track=26;
	  cdda_stop();
         cdda_play();
      }
      if (vo_2157 == 0x1a && vo_2156 == 1 && vo_2159 == 1 && Xxxcdda.Soundlink_cd_track!= 27)
      {
         Xxxcdda.Soundlink_cd_track=27;
	  cdda_stop();
         cdda_play();
      }
      if (vo_2157 == 0x1b && vo_2156 == 1 && vo_2159 == 1 && Xxxcdda.Soundlink_cd_track!= 28)
      {
         Xxxcdda.Soundlink_cd_track=28;
	  cdda_stop();
         cdda_play();
      }
      if (vo_2157 == 0x1c && vo_2156 == 1 && vo_2159 == 1 && Xxxcdda.Soundlink_cd_track!= 29)
      {
         Xxxcdda.Soundlink_cd_track=29;
	  cdda_stop();
         cdda_play();
      }
      if (vo_2157 == 0x1d && vo_2156 == 1 && vo_2159 == 1 && Xxxcdda.Soundlink_cd_track!= 30)
      {
         Xxxcdda.Soundlink_cd_track=30;
	  cdda_stop();
         cdda_play();
      }

// 6 K
      if (vo_2157 == 0x2e && vo_2156 == 1 && vo_2159 == 1 && Xxxcdda.Soundlink_cd_track!= 47)
      {
         Xxxcdda.Soundlink_cd_track=47;
	  cdda_stop();
         cdda_play();
      }
      if (vo_2157 == 0x2f && vo_2156 == 1 && vo_2159 == 1 && Xxxcdda.Soundlink_cd_track!= 48)
      {
         Xxxcdda.Soundlink_cd_track=48;
	  cdda_stop();
         cdda_play();
      }
      if (vo_2157 == 0x30 && vo_2156 == 1 && vo_2159 == 1 && Xxxcdda.Soundlink_cd_track!= 49)
      {
         Xxxcdda.Soundlink_cd_track=49;
	  cdda_stop();
         cdda_play();
      }

// 7 K
      if (vo_2157 == 0x37 && vo_2156 == 1 && vo_2159 == 1 && Xxxcdda.Soundlink_cd_track!= 56)
      {
         Xxxcdda.Soundlink_cd_track=56;
	  cdda_stop();
         cdda_play();
      }
      if (vo_2157 == 0x38 && vo_2156 == 1 && vo_2159 == 1 && Xxxcdda.Soundlink_cd_track!= 57)
      {
         Xxxcdda.Soundlink_cd_track=57;
	  cdda_stop();
         cdda_play();
      }

// 8 K
      if (vo_2157 == 0x41 && vo_2156 == 1 && vo_2159 == 1 && Xxxcdda.Soundlink_cd_track!= 66)
      {
         Xxxcdda.Soundlink_cd_track=66;
	  cdda_stop();
         cdda_play();
      }
      if (vo_2157 == 0x42 && vo_2156 == 1 && vo_2159 == 1 && Xxxcdda.Soundlink_cd_track!= 67)
      {
         Xxxcdda.Soundlink_cd_track=67;
	  cdda_stop();
         cdda_play();
      }
      if (vo_2157 == 0x43 && vo_2156 == 1 && vo_2159 == 1 && Xxxcdda.Soundlink_cd_track!= 68)
      {
         Xxxcdda.Soundlink_cd_track=68;
	  cdda_stop();
         cdda_play();
      }

// 9 K
      if (vo_2157 == 0x50 && vo_2156 == 1 && vo_2159 == 1 && Xxxcdda.Soundlink_cd_track!= 81)
      {
         Xxxcdda.Soundlink_cd_track=81;
	  cdda_stop();
         cdda_play();
      }
      if (vo_2157 == 0x51 && vo_2156 == 1 && vo_2159 == 1 && Xxxcdda.Soundlink_cd_track!= 82)
      {
         Xxxcdda.Soundlink_cd_track=82;
	  cdda_stop();
         cdda_play();
      }
      if (vo_2157 == 0x52 && vo_2156 == 1 && vo_2159 == 1 && Xxxcdda.Soundlink_cd_track!= 83)
      {
         Xxxcdda.Soundlink_cd_track=83;
	  cdda_stop();
         cdda_play();
      }

// 10 K
      if (vo_2157 == 0x5f && vo_2156 == 1 && vo_2159 == 1 && Xxxcdda.Soundlink_cd_track!= 96)
      {
         Xxxcdda.Soundlink_cd_track=96;
	  cdda_stop();
         cdda_play();
      }
      if (vo_2157 == 0x60 && vo_2156 == 1 && vo_2159 == 1 && Xxxcdda.Soundlink_cd_track!= 97)
      {
         Xxxcdda.Soundlink_cd_track=97;
	  cdda_stop();
         cdda_play();
      }
      if (vo_2157 == 0x61 && vo_2156 == 1 && vo_2159 == 1 && Xxxcdda.Soundlink_cd_track!= 98)
      {
         Xxxcdda.Soundlink_cd_track=98;
	  cdda_stop();
         cdda_play();
      }




}

/*********************************************************************************************/
/* Emit2_Story                                                                               */
/*********************************************************************************************/

void Emit2_Story ()
{
      //0x214e Đԍ 
      //0x214f  K肩fꏊ 0x3ƗK
      //0x2150 0 p 1{ 
      //0x2154 0̑ 1bp[g
      //0x2156 0fBXNP 1fBXN2
      //0x2157 K
      //0x2159 1Đ 2|[Y 

      int vo_214e,vo_214f,vo_2150,vo_2154,vo_2156,vo_2157,vo_2159;
          vo_214e = Memory.RAM [0x214e];
          vo_214f = Memory.RAM [0x214f];
          vo_2150 = Memory.RAM [0x2150];
          vo_2154 = Memory.RAM [0x2154];
          vo_2156 = Memory.RAM [0x2156];
          vo_2157 = Memory.RAM [0x2157];
          vo_2159 = Memory.RAM [0x2159];

// I[vjO
      if (vo_214e == 0 && vo_2154 == 0 && vo_2159 == 1 && Xxxcdda.Soundlink_cd_track!= 1)
      {
         Xxxcdda.Soundlink_cd_track=1;
         Voicer_CdPlayWaitFlag = 0;
	  cdda_stop();
         cdda_play();
         //Settings.H_Max = (85 * SNES_CYCLES_PER_SCANLINE) / 100;
       }

// GfBO
      if (vo_214e == 77 && vo_2159 == 1 && Xxxcdda.Soundlink_cd_track!= 2)
      {
         Xxxcdda.Soundlink_cd_track=2;
         Voicer_CdPlayWaitFlag = 0;
	  cdda_stop();
         cdda_play();
         //Settings.H_Max = (85 * SNES_CYCLES_PER_SCANLINE) / 100;
       }

// 1͉p
      if (vo_214e == 0 && vo_2150 == 0 && vo_2154 == 1 && vo_2156 == 0 && vo_2159 == 1 && Xxxcdda.Soundlink_cd_track!= 4)
      {
         Xxxcdda.Soundlink_cd_track=4;
         Voicer_CdPlayWaitFlag = 0;
	  cdda_stop();
         cdda_play();
      }

      if (vo_214e == 1 && vo_2150 == 0 && vo_2154 == 1 && vo_2156 == 0 && vo_2159 == 1 && Xxxcdda.Soundlink_cd_track!= 5)
      {
         Xxxcdda.Soundlink_cd_track=5;
	  cdda_stop();
         Voicer_CdPlayWaitSet=1;
         Voicer_CdPlayWaitTime=VOICER_CD_WAITTIME;
      }

      if (vo_214e == 2 && vo_2150 == 0 && vo_2154 == 1 && vo_2156 == 0 && vo_2159 == 1 && Xxxcdda.Soundlink_cd_track!= 6)
      {
         Xxxcdda.Soundlink_cd_track=6;
	  cdda_stop();
         Voicer_CdPlayWaitSet=1;
         Voicer_CdPlayWaitTime=VOICER_CD_WAITTIME;
      }

      if (vo_214e == 3 && vo_2150 == 0 && vo_2154 == 1 && vo_2156 == 0 && vo_2159 == 1 && Xxxcdda.Soundlink_cd_track!= 7)
      {
         Xxxcdda.Soundlink_cd_track=7;
	  cdda_stop();
         Voicer_CdPlayWaitSet=1;
         Voicer_CdPlayWaitTime=VOICER_CD_WAITTIME;
      }

      if (vo_214e == 4 && vo_2150 == 0 && vo_2154 == 1 && vo_2156 == 0 && vo_2159 == 1 && Xxxcdda.Soundlink_cd_track!= 8)
      {
         Xxxcdda.Soundlink_cd_track=8;
	  cdda_stop();
         Voicer_CdPlayWaitSet=1;
         Voicer_CdPlayWaitTime=VOICER_CD_WAITTIME;
      }

      if (vo_214e == 5 && vo_2150 == 0 && vo_2154 == 1 && vo_2156 == 0 && vo_2159 == 1 && Xxxcdda.Soundlink_cd_track!= 9)
      {
         Xxxcdda.Soundlink_cd_track=9;
	  cdda_stop();
         Voicer_CdPlayWaitSet=1;
         Voicer_CdPlayWaitTime=VOICER_CD_WAITTIME;
      }

      if (vo_214e == 6 && vo_2150 == 0 && vo_2154 == 1 && vo_2156 == 0 && vo_2159 == 1 && Xxxcdda.Soundlink_cd_track!= 10)
      {
         Xxxcdda.Soundlink_cd_track=10;
	  cdda_stop();
         Voicer_CdPlayWaitSet=1;
         Voicer_CdPlayWaitTime=VOICER_CD_WAITTIME;
      }

      if (vo_214e == 7 && vo_2150 == 0 && vo_2154 == 1 && vo_2156 == 0 && vo_2159 == 1 && Xxxcdda.Soundlink_cd_track!= 11)
      {
         Xxxcdda.Soundlink_cd_track=11;
	  cdda_stop();
         Voicer_CdPlayWaitSet=1;
         Voicer_CdPlayWaitTime=VOICER_CD_WAITTIME;
      }

      if (vo_214e == 8 && vo_2150 == 0 && vo_2154 == 1 && vo_2156 == 0 && vo_2159 == 1 && Xxxcdda.Soundlink_cd_track!= 12)
      {
         Xxxcdda.Soundlink_cd_track=12;
	  cdda_stop();
         Voicer_CdPlayWaitSet=1;
         Voicer_CdPlayWaitTime=VOICER_CD_WAITTIME;
      }
// 1͓{
      if (vo_214e == 0 && vo_2150 == 1 && vo_2154 == 1 && vo_2156 == 0 && vo_2159 == 1 && Xxxcdda.Soundlink_cd_track!= 13)
      {
         Xxxcdda.Soundlink_cd_track=13;
         Voicer_CdPlayWaitFlag = 0;
	  cdda_stop();
         cdda_play();
      }

      if (vo_214e == 1 && vo_2150 == 1 && vo_2154 == 1 && vo_2156 == 0 && vo_2159 == 1 && Xxxcdda.Soundlink_cd_track!= 14)
      {
         Xxxcdda.Soundlink_cd_track=14;
	  cdda_stop();
         Voicer_CdPlayWaitSet=1;
         Voicer_CdPlayWaitTime=VOICER_CD_WAITTIME;
      }

      if (vo_214e == 2 && vo_2150 == 1 && vo_2154 == 1 && vo_2156 == 0 && vo_2159 == 1 && Xxxcdda.Soundlink_cd_track!= 15)
      {
         Xxxcdda.Soundlink_cd_track=15;
	  cdda_stop();
         Voicer_CdPlayWaitSet=1;
         Voicer_CdPlayWaitTime=VOICER_CD_WAITTIME;
      }

      if (vo_214e == 3 && vo_2150 == 1 && vo_2154 == 1 && vo_2156 == 0 && vo_2159 == 1 && Xxxcdda.Soundlink_cd_track!= 16)
      {
         Xxxcdda.Soundlink_cd_track=16;
	  cdda_stop();
         Voicer_CdPlayWaitSet=1;
         Voicer_CdPlayWaitTime=VOICER_CD_WAITTIME;
      }

      if (vo_214e == 4 && vo_2150 == 1 && vo_2154 == 1 && vo_2156 == 0 && vo_2159 == 1 && Xxxcdda.Soundlink_cd_track!= 17)
      {
         Xxxcdda.Soundlink_cd_track=17;
	  cdda_stop();
         Voicer_CdPlayWaitSet=1;
         Voicer_CdPlayWaitTime=VOICER_CD_WAITTIME;
      }

      if (vo_214e == 5 && vo_2150 == 1 && vo_2154 == 1 && vo_2156 == 0 && vo_2159 == 1 && Xxxcdda.Soundlink_cd_track!= 18)
      {
         Xxxcdda.Soundlink_cd_track=18;
	  cdda_stop();
         Voicer_CdPlayWaitSet=1;
         Voicer_CdPlayWaitTime=VOICER_CD_WAITTIME;
      }

      if (vo_214e == 6 && vo_2150 == 1 && vo_2154 == 1 && vo_2156 == 0 && vo_2159 == 1 && Xxxcdda.Soundlink_cd_track!= 19)
      {
         Xxxcdda.Soundlink_cd_track=19;
	  cdda_stop();
         Voicer_CdPlayWaitSet=1;
         Voicer_CdPlayWaitTime=VOICER_CD_WAITTIME;
      }

      if (vo_214e == 7 && vo_2150 == 1 && vo_2154 == 1 && vo_2156 == 0 && vo_2159 == 1 && Xxxcdda.Soundlink_cd_track!= 20)
      {
         Xxxcdda.Soundlink_cd_track=20;
	  cdda_stop();
         Voicer_CdPlayWaitSet=1;
         Voicer_CdPlayWaitTime=VOICER_CD_WAITTIME;
      }

      if (vo_214e == 8 && vo_2150 == 1 && vo_2154 == 1 && vo_2156 == 0 && vo_2159 == 1 && Xxxcdda.Soundlink_cd_track!= 21)
      {
         Xxxcdda.Soundlink_cd_track=21;
	  cdda_stop();
         Voicer_CdPlayWaitSet=1;
         Voicer_CdPlayWaitTime=VOICER_CD_WAITTIME;
      }
// 2͉p
      if (vo_214e == 9 && vo_2150 == 0 && vo_2154 == 1 && vo_2156 == 0 && vo_2159 == 1 && Xxxcdda.Soundlink_cd_track!= 25)
      {
         Xxxcdda.Soundlink_cd_track=25;
         Voicer_CdPlayWaitFlag = 0;
	  cdda_stop();
         cdda_play();
      }
      if (vo_214e == 10 && vo_2150 == 0 && vo_2154 == 1 && vo_2156 == 0 && vo_2159 == 1 && Xxxcdda.Soundlink_cd_track!= 26)
      {
         Xxxcdda.Soundlink_cd_track=26;
	  cdda_stop();
         Voicer_CdPlayWaitSet=1;
         Voicer_CdPlayWaitTime=VOICER_CD_WAITTIME;
      }
      if (vo_214e == 11 && vo_2150 == 0 && vo_2154 == 1 && vo_2156 == 0 && vo_2159 == 1 && Xxxcdda.Soundlink_cd_track!= 27)
      {
         Xxxcdda.Soundlink_cd_track=27;
	  cdda_stop();
         Voicer_CdPlayWaitSet=1;
         Voicer_CdPlayWaitTime=VOICER_CD_WAITTIME;
      }
      if (vo_214e == 12 && vo_2150 == 0 && vo_2154 == 1 && vo_2156 == 0 && vo_2159 == 1 && Xxxcdda.Soundlink_cd_track!= 28)
      {
         Xxxcdda.Soundlink_cd_track=28;
	  cdda_stop();
         Voicer_CdPlayWaitSet=1;
         Voicer_CdPlayWaitTime=VOICER_CD_WAITTIME;
      }
      if (vo_214e == 13 && vo_2150 == 0 && vo_2154 == 1 && vo_2156 == 0 && vo_2159 == 1 && Xxxcdda.Soundlink_cd_track!= 29)
      {
         Xxxcdda.Soundlink_cd_track=29;
	  cdda_stop();
         Voicer_CdPlayWaitSet=1;
         Voicer_CdPlayWaitTime=VOICER_CD_WAITTIME;
      }
      if (vo_214e == 14 && vo_2150 == 0 && vo_2154 == 1 && vo_2156 == 0 && vo_2159 == 1 && Xxxcdda.Soundlink_cd_track!= 30)
      {
         Xxxcdda.Soundlink_cd_track=30;
	  cdda_stop();
         Voicer_CdPlayWaitSet=1;
         Voicer_CdPlayWaitTime=VOICER_CD_WAITTIME;
      }
      if (vo_214e == 15 && vo_2150 == 0 && vo_2154 == 1 && vo_2156 == 0 && vo_2159 == 1 && Xxxcdda.Soundlink_cd_track!= 31)
      {
         Xxxcdda.Soundlink_cd_track=31;
	  cdda_stop();
         Voicer_CdPlayWaitSet=1;
         Voicer_CdPlayWaitTime=VOICER_CD_WAITTIME;
      }
      if (vo_214e == 16 && vo_2150 == 0 && vo_2154 == 1 && vo_2156 == 0 && vo_2159 == 1 && Xxxcdda.Soundlink_cd_track!= 32)
      {
         Xxxcdda.Soundlink_cd_track=32;
	  cdda_stop();
         Voicer_CdPlayWaitSet=1;
         Voicer_CdPlayWaitTime=VOICER_CD_WAITTIME;
      }
      if (vo_214e == 17 && vo_2150 == 0 && vo_2154 == 1 && vo_2156 == 0 && vo_2159 == 1 && Xxxcdda.Soundlink_cd_track!= 33)
      {
         Xxxcdda.Soundlink_cd_track=33;
	  cdda_stop();
         Voicer_CdPlayWaitSet=1;
         Voicer_CdPlayWaitTime=VOICER_CD_WAITTIME;
      }
// 2͓{
      if (vo_214e == 9 && vo_2150 == 1 && vo_2154 == 1 && vo_2156 == 0 && vo_2159 == 1 && Xxxcdda.Soundlink_cd_track!= 34)
      {
         Xxxcdda.Soundlink_cd_track=34;
         Voicer_CdPlayWaitFlag = 0;
	  cdda_stop();
         cdda_play();
      }
      if (vo_214e == 10 && vo_2150 == 1 && vo_2154 == 1 && vo_2156 == 0 && vo_2159 == 1 && Xxxcdda.Soundlink_cd_track!= 35)
      {
         Xxxcdda.Soundlink_cd_track=35;
	  cdda_stop();
         Voicer_CdPlayWaitSet=1;
         Voicer_CdPlayWaitTime=VOICER_CD_WAITTIME;
      }
      if (vo_214e == 11 && vo_2150 == 1 && vo_2154 == 1 && vo_2156 == 0 && vo_2159 == 1 && Xxxcdda.Soundlink_cd_track!= 36)
      {
         Xxxcdda.Soundlink_cd_track=36;
	  cdda_stop();
         Voicer_CdPlayWaitSet=1;
         Voicer_CdPlayWaitTime=VOICER_CD_WAITTIME;
      }
      if (vo_214e == 12 && vo_2150 == 1 && vo_2154 == 1 && vo_2156 == 0 && vo_2159 == 1 && Xxxcdda.Soundlink_cd_track!= 37)
      {
         Xxxcdda.Soundlink_cd_track=37;
	  cdda_stop();
         Voicer_CdPlayWaitSet=1;
         Voicer_CdPlayWaitTime=VOICER_CD_WAITTIME;
      }
      if (vo_214e == 13 && vo_2150 == 1 && vo_2154 == 1 && vo_2156 == 0 && vo_2159 == 1 && Xxxcdda.Soundlink_cd_track!= 38)
      {
         Xxxcdda.Soundlink_cd_track=38;
	  cdda_stop();
         Voicer_CdPlayWaitSet=1;
         Voicer_CdPlayWaitTime=VOICER_CD_WAITTIME;
      }
      if (vo_214e == 14 && vo_2150 == 1 && vo_2154 == 1 && vo_2156 == 0 && vo_2159 == 1 && Xxxcdda.Soundlink_cd_track!= 39)
      {
         Xxxcdda.Soundlink_cd_track=39;
	  cdda_stop();
         Voicer_CdPlayWaitSet=1;
         Voicer_CdPlayWaitTime=VOICER_CD_WAITTIME;
      }
      if (vo_214e == 15 && vo_2150 == 1 && vo_2154 == 1 && vo_2156 == 0 && vo_2159 == 1 && Xxxcdda.Soundlink_cd_track!= 40)
      {
         Xxxcdda.Soundlink_cd_track=40;
	  cdda_stop();
         Voicer_CdPlayWaitSet=1;
         Voicer_CdPlayWaitTime=VOICER_CD_WAITTIME;
      }
      if (vo_214e == 16 && vo_2150 == 1 && vo_2154 == 1 && vo_2156 == 0 && vo_2159 == 1 && Xxxcdda.Soundlink_cd_track!= 41)
      {
         Xxxcdda.Soundlink_cd_track=41;
	  cdda_stop();
         Voicer_CdPlayWaitSet=1;
         Voicer_CdPlayWaitTime=VOICER_CD_WAITTIME;
      }
      if (vo_214e == 17 && vo_2150 == 1 && vo_2154 == 1 && vo_2156 == 0 && vo_2159 == 1 && Xxxcdda.Soundlink_cd_track!= 42)
      {
         Xxxcdda.Soundlink_cd_track=42;
	  cdda_stop();
         Voicer_CdPlayWaitSet=1;
         Voicer_CdPlayWaitTime=VOICER_CD_WAITTIME;
      }
// 3͉p
      if (vo_214e == 18 && vo_2150 == 0 && vo_2154 == 1 && vo_2156 == 0 && vo_2159 == 1 && Xxxcdda.Soundlink_cd_track!= 49)
      {
         Xxxcdda.Soundlink_cd_track=49;
         Voicer_CdPlayWaitFlag = 0;
	  cdda_stop();
         cdda_play();
      }
      if (vo_214e == 19 && vo_2150 == 0 && vo_2154 == 1 && vo_2156 == 0 && vo_2159 == 1 && Xxxcdda.Soundlink_cd_track!= 50)
      {
         Xxxcdda.Soundlink_cd_track=50;
	  cdda_stop();
         Voicer_CdPlayWaitSet=1;
         Voicer_CdPlayWaitTime=VOICER_CD_WAITTIME;
      }
      if (vo_214e == 20 && vo_2150 == 0 && vo_2154 == 1 && vo_2156 == 0 && vo_2159 == 1 && Xxxcdda.Soundlink_cd_track!= 51)
      {
         Xxxcdda.Soundlink_cd_track=51;
	  cdda_stop();
         Voicer_CdPlayWaitSet=1;
         Voicer_CdPlayWaitTime=VOICER_CD_WAITTIME;
      }
      if (vo_214e == 21 && vo_2150 == 0 && vo_2154 == 1 && vo_2156 == 0 && vo_2159 == 1 && Xxxcdda.Soundlink_cd_track!= 52)
      {
         Xxxcdda.Soundlink_cd_track=52;
	  cdda_stop();
         Voicer_CdPlayWaitSet=1;
         Voicer_CdPlayWaitTime=VOICER_CD_WAITTIME;
      }
      if (vo_214e == 22 && vo_2150 == 0 && vo_2154 == 1 && vo_2156 == 0 && vo_2159 == 1 && Xxxcdda.Soundlink_cd_track!= 53)
      {
         Xxxcdda.Soundlink_cd_track=53;
	  cdda_stop();
         Voicer_CdPlayWaitSet=1;
         Voicer_CdPlayWaitTime=VOICER_CD_WAITTIME;
      }
      if (vo_214e == 23 && vo_2150 == 0 && vo_2154 == 1 && vo_2156 == 0 && vo_2159 == 1 && Xxxcdda.Soundlink_cd_track!= 54)
      {
         Xxxcdda.Soundlink_cd_track=54;
	  cdda_stop();
         Voicer_CdPlayWaitSet=1;
         Voicer_CdPlayWaitTime=VOICER_CD_WAITTIME;
      }
      if (vo_214e == 24 && vo_2150 == 0 && vo_2154 == 1 && vo_2156 == 0 && vo_2159 == 1 && Xxxcdda.Soundlink_cd_track!= 55)
      {
         Xxxcdda.Soundlink_cd_track=55;
	  cdda_stop();
         Voicer_CdPlayWaitSet=1;
         Voicer_CdPlayWaitTime=VOICER_CD_WAITTIME;
      }
      if (vo_214e == 25 && vo_2150 == 0 && vo_2154 == 1 && vo_2156 == 0 && vo_2159 == 1 && Xxxcdda.Soundlink_cd_track!= 56)
      {
         Xxxcdda.Soundlink_cd_track=56;
	  cdda_stop();
         Voicer_CdPlayWaitSet=1;
         Voicer_CdPlayWaitTime=VOICER_CD_WAITTIME;
      }
// 3͓{
      if (vo_214e == 18 && vo_2150 == 1 && vo_2154 == 1 && vo_2156 == 0 && vo_2159 == 1 && Xxxcdda.Soundlink_cd_track!= 57)
      {
         Xxxcdda.Soundlink_cd_track=57;
         Voicer_CdPlayWaitFlag = 0;
	  cdda_stop();
         cdda_play();
      }
      if (vo_214e == 19 && vo_2150 == 1 && vo_2154 == 1 && vo_2156 == 0 && vo_2159 == 1 && Xxxcdda.Soundlink_cd_track!= 58)
      {
         Xxxcdda.Soundlink_cd_track=58;
	  cdda_stop();
         Voicer_CdPlayWaitSet=1;
         Voicer_CdPlayWaitTime=VOICER_CD_WAITTIME;
      }
      if (vo_214e == 20 && vo_2150 == 1 && vo_2154 == 1 && vo_2156 == 0 && vo_2159 == 1 && Xxxcdda.Soundlink_cd_track!= 59)
      {
         Xxxcdda.Soundlink_cd_track=59;
	  cdda_stop();
         Voicer_CdPlayWaitSet=1;
         Voicer_CdPlayWaitTime=VOICER_CD_WAITTIME;
      }
      if (vo_214e == 21 && vo_2150 == 1 && vo_2154 == 1 && vo_2156 == 0 && vo_2159 == 1 && Xxxcdda.Soundlink_cd_track!= 60)
      {
         Xxxcdda.Soundlink_cd_track=60;
	  cdda_stop();
         Voicer_CdPlayWaitSet=1;
         Voicer_CdPlayWaitTime=VOICER_CD_WAITTIME;
      }
      if (vo_214e == 22 && vo_2150 == 1 && vo_2154 == 1 && vo_2156 == 0 && vo_2159 == 1 && Xxxcdda.Soundlink_cd_track!= 61)
      {
         Xxxcdda.Soundlink_cd_track=61;
	  cdda_stop();
         Voicer_CdPlayWaitSet=1;
         Voicer_CdPlayWaitTime=VOICER_CD_WAITTIME;
      }
      if (vo_214e == 23 && vo_2150 == 1 && vo_2154 == 1 && vo_2156 == 0 && vo_2159 == 1 && Xxxcdda.Soundlink_cd_track!= 62)
      {
         Xxxcdda.Soundlink_cd_track=62;
	  cdda_stop();
         Voicer_CdPlayWaitSet=1;
         Voicer_CdPlayWaitTime=VOICER_CD_WAITTIME;
      }
      if (vo_214e == 24 && vo_2150 == 1 && vo_2154 == 1 && vo_2156 == 0 && vo_2159 == 1 && Xxxcdda.Soundlink_cd_track!= 63)
      {
         Xxxcdda.Soundlink_cd_track=63;
	  cdda_stop();
         Voicer_CdPlayWaitSet=1;
         Voicer_CdPlayWaitTime=VOICER_CD_WAITTIME;
      }
      if (vo_214e == 25 && vo_2150 == 1 && vo_2154 == 1 && vo_2156 == 0 && vo_2159 == 1 && Xxxcdda.Soundlink_cd_track!= 64)
      {
         Xxxcdda.Soundlink_cd_track=64;
	  cdda_stop();
         Voicer_CdPlayWaitSet=1;
         Voicer_CdPlayWaitTime=VOICER_CD_WAITTIME;
      }

// 4͉p
      if (vo_214e == 26 && vo_2150 == 0 && vo_2154 == 1 && vo_2156 == 0 && vo_2159 == 1 && Xxxcdda.Soundlink_cd_track!= 65)
      {
         Xxxcdda.Soundlink_cd_track=65;
         Voicer_CdPlayWaitFlag = 0;
	  cdda_stop();
         cdda_play();
      }
      if (vo_214e == 27 && vo_2150 == 0 && vo_2154 == 1 && vo_2156 == 0 && vo_2159 == 1 && Xxxcdda.Soundlink_cd_track!= 66)
      {
         Xxxcdda.Soundlink_cd_track=66;
	  cdda_stop();
         Voicer_CdPlayWaitSet=1;
         Voicer_CdPlayWaitTime=VOICER_CD_WAITTIME;
      }
      if (vo_214e == 28 && vo_2150 == 0 && vo_2154 == 1 && vo_2156 == 0 && vo_2159 == 1 && Xxxcdda.Soundlink_cd_track!= 67)
      {
         Xxxcdda.Soundlink_cd_track=67;
	  cdda_stop();
         Voicer_CdPlayWaitSet=1;
         Voicer_CdPlayWaitTime=VOICER_CD_WAITTIME;
      }
      if (vo_214e == 29 && vo_2150 == 0 && vo_2154 == 1 && vo_2156 == 0 && vo_2159 == 1 && Xxxcdda.Soundlink_cd_track!= 68)
      {
         Xxxcdda.Soundlink_cd_track=68;
	  cdda_stop();
         Voicer_CdPlayWaitSet=1;
         Voicer_CdPlayWaitTime=VOICER_CD_WAITTIME;
      }
      if (vo_214e == 30 && vo_2150 == 0 && vo_2154 == 1 && vo_2156 == 0 && vo_2159 == 1 && Xxxcdda.Soundlink_cd_track!= 69)
      {
         Xxxcdda.Soundlink_cd_track=69;
	  cdda_stop();
         Voicer_CdPlayWaitSet=1;
         Voicer_CdPlayWaitTime=VOICER_CD_WAITTIME;
      }
      if (vo_214e == 31 && vo_2150 == 0 && vo_2154 == 1 && vo_2156 == 0 && vo_2159 == 1 && Xxxcdda.Soundlink_cd_track!= 70)
      {
         Xxxcdda.Soundlink_cd_track=70;
	  cdda_stop();
         Voicer_CdPlayWaitSet=1;
         Voicer_CdPlayWaitTime=VOICER_CD_WAITTIME;
      }
      if (vo_214e == 32 && vo_2150 == 0 && vo_2154 == 1 && vo_2156 == 0 && vo_2159 == 1 && Xxxcdda.Soundlink_cd_track!= 71)
      {
         Xxxcdda.Soundlink_cd_track=71;
	  cdda_stop();
         Voicer_CdPlayWaitSet=1;
         Voicer_CdPlayWaitTime=VOICER_CD_WAITTIME;
      }

// 4͓{
      if (vo_214e == 26 && vo_2150 == 1 && vo_2154 == 1 && vo_2156 == 0 && vo_2159 == 1 && Xxxcdda.Soundlink_cd_track!= 72)
      {
         Xxxcdda.Soundlink_cd_track=72;
         Voicer_CdPlayWaitFlag = 0;
	  cdda_stop();
         cdda_play();
      }
      if (vo_214e == 27 && vo_2150 == 1 && vo_2154 == 1 && vo_2156 == 0 && vo_2159 == 1 && Xxxcdda.Soundlink_cd_track!= 73)
      {
         Xxxcdda.Soundlink_cd_track=73;
	  cdda_stop();
         Voicer_CdPlayWaitSet=1;
         Voicer_CdPlayWaitTime=VOICER_CD_WAITTIME;
      }
      if (vo_214e == 28 && vo_2150 == 1 && vo_2154 == 1 && vo_2156 == 0 && vo_2159 == 1 && Xxxcdda.Soundlink_cd_track!= 74)
      {
         Xxxcdda.Soundlink_cd_track=74;
	  cdda_stop();
         Voicer_CdPlayWaitSet=1;
         Voicer_CdPlayWaitTime=VOICER_CD_WAITTIME;
      }
      if (vo_214e == 29 && vo_2150 == 1 && vo_2154 == 1 && vo_2156 == 0 && vo_2159 == 1 && Xxxcdda.Soundlink_cd_track!= 75)
      {
         Xxxcdda.Soundlink_cd_track=75;
	  cdda_stop();
         Voicer_CdPlayWaitSet=1;
         Voicer_CdPlayWaitTime=VOICER_CD_WAITTIME;
      }
      if (vo_214e == 30 && vo_2150 == 1 && vo_2154 == 1 && vo_2156 == 0 && vo_2159 == 1 && Xxxcdda.Soundlink_cd_track!= 76)
      {
         Xxxcdda.Soundlink_cd_track=76;
	  cdda_stop();
         Voicer_CdPlayWaitSet=1;
         Voicer_CdPlayWaitTime=VOICER_CD_WAITTIME;
      }
      if (vo_214e == 31 && vo_2150 == 1 && vo_2154 == 1 && vo_2156 == 0 && vo_2159 == 1 && Xxxcdda.Soundlink_cd_track!= 77)
      {
         Xxxcdda.Soundlink_cd_track=77;
	  cdda_stop();
         Voicer_CdPlayWaitSet=1;
         Voicer_CdPlayWaitTime=VOICER_CD_WAITTIME;
      }
      if (vo_214e == 32 && vo_2150 == 1 && vo_2154 == 1 && vo_2156 == 0 && vo_2159 == 1 && Xxxcdda.Soundlink_cd_track!= 78)
      {
         Xxxcdda.Soundlink_cd_track=78;
	  cdda_stop();
         cdda_play();
      }

// 5͉p
      if (vo_214e == 33 && vo_2150 == 0 && vo_2154 == 1 && vo_2156 == 0 && vo_2159 == 1 && Xxxcdda.Soundlink_cd_track!= 84)
      {
         Xxxcdda.Soundlink_cd_track=84;
         Voicer_CdPlayWaitFlag = 0;
	  cdda_stop();
         cdda_play();
      }
      if (vo_214e == 34 && vo_2150 == 0 && vo_2154 == 1 && vo_2156 == 0 && vo_2159 == 1 && Xxxcdda.Soundlink_cd_track!= 85)
      {
         Xxxcdda.Soundlink_cd_track=85;
	  cdda_stop();
         Voicer_CdPlayWaitSet=1;
         Voicer_CdPlayWaitTime=VOICER_CD_WAITTIME;
      }
      if (vo_214e == 35 && vo_2150 == 0 && vo_2154 == 1 && vo_2156 == 0 && vo_2159 == 1 && Xxxcdda.Soundlink_cd_track!= 86)
      {
         Xxxcdda.Soundlink_cd_track=86;
	  cdda_stop();
         Voicer_CdPlayWaitSet=1;
         Voicer_CdPlayWaitTime=VOICER_CD_WAITTIME;
      }
      if (vo_214e == 36 && vo_2150 == 0 && vo_2154 == 1 && vo_2156 == 0 && vo_2159 == 1 && Xxxcdda.Soundlink_cd_track!= 87)
      {
         Xxxcdda.Soundlink_cd_track=87;
	  cdda_stop();
         Voicer_CdPlayWaitSet=1;
         Voicer_CdPlayWaitTime=VOICER_CD_WAITTIME;
      }
      if (vo_214e == 37 && vo_2150 == 0 && vo_2154 == 1 && vo_2156 == 0 && vo_2159 == 1 && Xxxcdda.Soundlink_cd_track!= 88)
      {
         Xxxcdda.Soundlink_cd_track=88;
	  cdda_stop();
         Voicer_CdPlayWaitSet=1;
         Voicer_CdPlayWaitTime=VOICER_CD_WAITTIME;
      }

// 5͓{
      if (vo_214e == 33 && vo_2150 == 1 && vo_2154 == 1 && vo_2156 == 0 && vo_2159 == 1 && Xxxcdda.Soundlink_cd_track!= 89)
      {
         Xxxcdda.Soundlink_cd_track=89;
         Voicer_CdPlayWaitFlag = 0;
	  cdda_stop();
         cdda_play();
      }
      if (vo_214e == 34 && vo_2150 == 1 && vo_2154 == 1 && vo_2156 == 0 && vo_2159 == 1 && Xxxcdda.Soundlink_cd_track!= 90)
      {
         Xxxcdda.Soundlink_cd_track=90;
	  cdda_stop();
         Voicer_CdPlayWaitSet=1;
         Voicer_CdPlayWaitTime=VOICER_CD_WAITTIME;
      }
      if (vo_214e == 35 && vo_2150 == 1 && vo_2154 == 1 && vo_2156 == 0 && vo_2159 == 1 && Xxxcdda.Soundlink_cd_track!= 91)
      {
         Xxxcdda.Soundlink_cd_track=91;
	  cdda_stop();
         Voicer_CdPlayWaitSet=1;
         Voicer_CdPlayWaitTime=VOICER_CD_WAITTIME;
      }
      if (vo_214e == 36 && vo_2150 == 1 && vo_2154 == 1 && vo_2156 == 0 && vo_2159 == 1 && Xxxcdda.Soundlink_cd_track!= 92)
      {
         Xxxcdda.Soundlink_cd_track=92;
	  cdda_stop();
         Voicer_CdPlayWaitSet=1;
         Voicer_CdPlayWaitTime=VOICER_CD_WAITTIME;
      }
      if (vo_214e == 37 && vo_2150 == 1 && vo_2154 == 1 && vo_2156 == 0 && vo_2159 == 1 && Xxxcdda.Soundlink_cd_track!= 93)
      {
         Xxxcdda.Soundlink_cd_track=93;
	  cdda_stop();
         Voicer_CdPlayWaitSet=1;
         Voicer_CdPlayWaitTime=VOICER_CD_WAITTIME;
      }

// 6͉p
      if (vo_214e == 38 && vo_2150 == 0 && vo_2154 == 1 && vo_2156 == 1 && vo_2159 == 1 && Xxxcdda.Soundlink_cd_track!= 4)
      {
         Xxxcdda.Soundlink_cd_track=4;
         Voicer_CdPlayWaitFlag = 0;
	  cdda_stop();
         cdda_play();
      }
      if (vo_214e == 39 && vo_2150 == 0 && vo_2154 == 1 && vo_2156 == 1 && vo_2159 == 1 && Xxxcdda.Soundlink_cd_track!= 5)
      {
         Xxxcdda.Soundlink_cd_track=5;
	  cdda_stop();
         Voicer_CdPlayWaitSet=1;
         Voicer_CdPlayWaitTime=VOICER_CD_WAITTIME;
      }
      if (vo_214e == 40 && vo_2150 == 0 && vo_2154 == 1 && vo_2156 == 1 && vo_2159 == 1 && Xxxcdda.Soundlink_cd_track!= 6)
      {
         Xxxcdda.Soundlink_cd_track=6;
	  cdda_stop();
         Voicer_CdPlayWaitSet=1;
         Voicer_CdPlayWaitTime=VOICER_CD_WAITTIME;
      }
      if (vo_214e == 41 && vo_2150 == 0 && vo_2154 == 1 && vo_2156 == 1 && vo_2159 == 1 && Xxxcdda.Soundlink_cd_track!= 7)
      {
         Xxxcdda.Soundlink_cd_track=7;
	  cdda_stop();
         Voicer_CdPlayWaitSet=1;
         Voicer_CdPlayWaitTime=VOICER_CD_WAITTIME;
      }
      if (vo_214e == 42 && vo_2150 == 0 && vo_2154 == 1 && vo_2156 == 1 && vo_2159 == 1 && Xxxcdda.Soundlink_cd_track!= 8)
      {
         Xxxcdda.Soundlink_cd_track=8;
	  cdda_stop();
         Voicer_CdPlayWaitSet=1;
         Voicer_CdPlayWaitTime=VOICER_CD_WAITTIME;
      }
      if (vo_214e == 43 && vo_2150 == 0 && vo_2154 == 1 && vo_2156 == 1 && vo_2159 == 1 && Xxxcdda.Soundlink_cd_track!= 9)
      {
         Xxxcdda.Soundlink_cd_track=9;
	  cdda_stop();
         Voicer_CdPlayWaitSet=1;
         Voicer_CdPlayWaitTime=VOICER_CD_WAITTIME;
      }
      if (vo_214e == 44 && vo_2150 == 0 && vo_2154 == 1 && vo_2156 == 1 && vo_2159 == 1 && Xxxcdda.Soundlink_cd_track!= 10)
      {
         Xxxcdda.Soundlink_cd_track=10;
	  cdda_stop();
         Voicer_CdPlayWaitSet=1;
         Voicer_CdPlayWaitTime=VOICER_CD_WAITTIME;
      }
      if (vo_214e == 45 && vo_2150 == 0 && vo_2154 == 1 && vo_2156 == 1 && vo_2159 == 1 && Xxxcdda.Soundlink_cd_track!= 11)
      {
         Xxxcdda.Soundlink_cd_track=11;
	  cdda_stop();
         Voicer_CdPlayWaitSet=1;
         Voicer_CdPlayWaitTime=VOICER_CD_WAITTIME;
      }
      if (vo_214e == 46 && vo_2150 == 0 && vo_2154 == 1 && vo_2156 == 1 && vo_2159 == 1 && Xxxcdda.Soundlink_cd_track!= 12)
      {
         Xxxcdda.Soundlink_cd_track=12;
	  cdda_stop();
         Voicer_CdPlayWaitSet=1;
         Voicer_CdPlayWaitTime=VOICER_CD_WAITTIME;
      }
      if (vo_214e == 47 && vo_2150 == 0 && vo_2154 == 1 && vo_2156 == 1 && vo_2159 == 1 && Xxxcdda.Soundlink_cd_track!= 13)
      {
         Xxxcdda.Soundlink_cd_track=13;
	  cdda_stop();
         Voicer_CdPlayWaitSet=1;
         Voicer_CdPlayWaitTime=VOICER_CD_WAITTIME;
      }
      if (vo_214e == 48 && vo_2150 == 0 && vo_2154 == 1 && vo_2156 == 1 && vo_2159 == 1 && Xxxcdda.Soundlink_cd_track!= 14)
      {
         Xxxcdda.Soundlink_cd_track=14;
	  cdda_stop();
         Voicer_CdPlayWaitSet=1;
         Voicer_CdPlayWaitTime=VOICER_CD_WAITTIME;
      }
      if (vo_214e == 49 && vo_2150 == 0 && vo_2154 == 1 && vo_2156 == 1 && vo_2159 == 1 && Xxxcdda.Soundlink_cd_track!= 15)
      {
         Xxxcdda.Soundlink_cd_track=15;
	  cdda_stop();
         Voicer_CdPlayWaitSet=1;
         Voicer_CdPlayWaitTime=VOICER_CD_WAITTIME;
      }
      if (vo_214e == 50 && vo_2150 == 0 && vo_2154 == 1 && vo_2156 == 1 && vo_2159 == 1 && Xxxcdda.Soundlink_cd_track!= 16)
      {
         Xxxcdda.Soundlink_cd_track=16;
	  cdda_stop();
         Voicer_CdPlayWaitSet=1;
         Voicer_CdPlayWaitTime=VOICER_CD_WAITTIME;
      }

// 6͓{
      if (vo_214e == 38 && vo_2150 == 1 && vo_2154 == 1 && vo_2156 == 1 && vo_2159 == 1 && Xxxcdda.Soundlink_cd_track!= 17)
      {
         Xxxcdda.Soundlink_cd_track=17;
         Voicer_CdPlayWaitFlag = 0;
	  cdda_stop();
         cdda_play();
      }
      if (vo_214e == 39 && vo_2150 == 1 && vo_2154 == 1 && vo_2156 == 1 && vo_2159 == 1 && Xxxcdda.Soundlink_cd_track!= 18)
      {
         Xxxcdda.Soundlink_cd_track=18;
	  cdda_stop();
         Voicer_CdPlayWaitSet=1;
         Voicer_CdPlayWaitTime=VOICER_CD_WAITTIME;
      }
      if (vo_214e == 40 && vo_2150 == 1 && vo_2154 == 1 && vo_2156 == 1 && vo_2159 == 1 && Xxxcdda.Soundlink_cd_track!= 19)
      {
         Xxxcdda.Soundlink_cd_track=19;
	  cdda_stop();
         Voicer_CdPlayWaitSet=1;
         Voicer_CdPlayWaitTime=VOICER_CD_WAITTIME;
      }
      if (vo_214e == 41 && vo_2150 == 1 && vo_2154 == 1 && vo_2156 == 1 && vo_2159 == 1 && Xxxcdda.Soundlink_cd_track!= 20)
      {
         Xxxcdda.Soundlink_cd_track=20;
	  cdda_stop();
         Voicer_CdPlayWaitSet=1;
         Voicer_CdPlayWaitTime=VOICER_CD_WAITTIME;
      }
      if (vo_214e == 42 && vo_2150 == 1 && vo_2154 == 1 && vo_2156 == 1 && vo_2159 == 1 && Xxxcdda.Soundlink_cd_track!= 21)
      {
         Xxxcdda.Soundlink_cd_track=21;
	  cdda_stop();
         Voicer_CdPlayWaitSet=1;
         Voicer_CdPlayWaitTime=VOICER_CD_WAITTIME;
      }
      if (vo_214e == 43 && vo_2150 == 1 && vo_2154 == 1 && vo_2156 == 1 && vo_2159 == 1 && Xxxcdda.Soundlink_cd_track!= 22)
      {
         Xxxcdda.Soundlink_cd_track=22;
	  cdda_stop();
         Voicer_CdPlayWaitSet=1;
         Voicer_CdPlayWaitTime=VOICER_CD_WAITTIME;
      }
      if (vo_214e == 44 && vo_2150 == 1 && vo_2154 == 1 && vo_2156 == 1 && vo_2159 == 1 && Xxxcdda.Soundlink_cd_track!= 23)
      {
         Xxxcdda.Soundlink_cd_track=23;
	  cdda_stop();
         Voicer_CdPlayWaitSet=1;
         Voicer_CdPlayWaitTime=VOICER_CD_WAITTIME;
      }
      if (vo_214e == 45 && vo_2150 == 1 && vo_2154 == 1 && vo_2156 == 1 && vo_2159 == 1 && Xxxcdda.Soundlink_cd_track!= 24)
      {
         Xxxcdda.Soundlink_cd_track=24;
	  cdda_stop();
         Voicer_CdPlayWaitSet=1;
         Voicer_CdPlayWaitTime=VOICER_CD_WAITTIME;
      }
      if (vo_214e == 46 && vo_2150 == 1 && vo_2154 == 1 && vo_2156 == 1 && vo_2159 == 1 && Xxxcdda.Soundlink_cd_track!= 25)
      {
         Xxxcdda.Soundlink_cd_track=25;
	  cdda_stop();
         Voicer_CdPlayWaitSet=1;
         Voicer_CdPlayWaitTime=VOICER_CD_WAITTIME;
      }
      if (vo_214e == 47 && vo_2150 == 1 && vo_2154 == 1 && vo_2156 == 1 && vo_2159 == 1 && Xxxcdda.Soundlink_cd_track!= 26)
      {
         Xxxcdda.Soundlink_cd_track=26;
	  cdda_stop();
         Voicer_CdPlayWaitSet=1;
         Voicer_CdPlayWaitTime=VOICER_CD_WAITTIME;
      }
      if (vo_214e == 48 && vo_2150 == 1 && vo_2154 == 1 && vo_2156 == 1 && vo_2159 == 1 && Xxxcdda.Soundlink_cd_track!= 27)
      {
         Xxxcdda.Soundlink_cd_track=27;
	  cdda_stop();
         Voicer_CdPlayWaitSet=1;
         Voicer_CdPlayWaitTime=VOICER_CD_WAITTIME;
      }
      if (vo_214e == 49 && vo_2150 == 1 && vo_2154 == 1 && vo_2156 == 1 && vo_2159 == 1 && Xxxcdda.Soundlink_cd_track!= 28)
      {
         Xxxcdda.Soundlink_cd_track=28;
	  cdda_stop();
         Voicer_CdPlayWaitSet=1;
         Voicer_CdPlayWaitTime=VOICER_CD_WAITTIME;
      }
      if (vo_214e == 50 && vo_2150 == 1 && vo_2154 == 1 && vo_2156 == 1 && vo_2159 == 1 && Xxxcdda.Soundlink_cd_track!= 29)
      {
         Xxxcdda.Soundlink_cd_track=29;
	  cdda_stop();
         Voicer_CdPlayWaitSet=1;
         Voicer_CdPlayWaitTime=VOICER_CD_WAITTIME;
      }

// 7͉p
      if (vo_214e == 51 && vo_2150 == 0 && vo_2154 == 1 && vo_2156 == 1 && vo_2159 == 1 && Xxxcdda.Soundlink_cd_track!= 36)
      {
         Xxxcdda.Soundlink_cd_track=36;
         Voicer_CdPlayWaitFlag = 0;
	  cdda_stop();
         cdda_play();
      }
      if (vo_214e == 52 && vo_2150 == 0 && vo_2154 == 1 && vo_2156 == 1 && vo_2159 == 1 && Xxxcdda.Soundlink_cd_track!= 37)
      {
         Xxxcdda.Soundlink_cd_track=37;
	  cdda_stop();
         Voicer_CdPlayWaitSet=1;
         Voicer_CdPlayWaitTime=VOICER_CD_WAITTIME;
      }
      if (vo_214e == 53 && vo_2150 == 0 && vo_2154 == 1 && vo_2156 == 1 && vo_2159 == 1 && Xxxcdda.Soundlink_cd_track!= 38)
      {
         Xxxcdda.Soundlink_cd_track=38;
	  cdda_stop();
         Voicer_CdPlayWaitSet=1;
         Voicer_CdPlayWaitTime=VOICER_CD_WAITTIME;
      }
      if (vo_214e == 54 && vo_2150 == 0 && vo_2154 == 1 && vo_2156 == 1 && vo_2159 == 1 && Xxxcdda.Soundlink_cd_track!= 39)
      {
         Xxxcdda.Soundlink_cd_track=39;
	  cdda_stop();
         Voicer_CdPlayWaitSet=1;
         Voicer_CdPlayWaitTime=VOICER_CD_WAITTIME;
      }
      if (vo_214e == 55 && vo_2150 == 0 && vo_2154 == 1 && vo_2156 == 1 && vo_2159 == 1 && Xxxcdda.Soundlink_cd_track!= 40)
      {
         Xxxcdda.Soundlink_cd_track=40;
	  cdda_stop();
         Voicer_CdPlayWaitSet=1;
         Voicer_CdPlayWaitTime=VOICER_CD_WAITTIME;
      }
      if (vo_214e == 56 && vo_2150 == 0 && vo_2154 == 1 && vo_2156 == 1 && vo_2159 == 1 && Xxxcdda.Soundlink_cd_track!= 41)
      {
         Xxxcdda.Soundlink_cd_track=41;
	  cdda_stop();
         Voicer_CdPlayWaitSet=1;
         Voicer_CdPlayWaitTime=VOICER_CD_WAITTIME;
      }

// 7͓{
      if (vo_214e == 51 && vo_2150 == 1 && vo_2154 == 1 && vo_2156 == 1 && vo_2159 == 1 && Xxxcdda.Soundlink_cd_track!= 42)
      {
         Xxxcdda.Soundlink_cd_track=42;
         Voicer_CdPlayWaitFlag = 0;
	  cdda_stop();
         cdda_play();
      }
      if (vo_214e == 52 && vo_2150 == 1 && vo_2154 == 1 && vo_2156 == 1 && vo_2159 == 1 && Xxxcdda.Soundlink_cd_track!= 43)
      {
         Xxxcdda.Soundlink_cd_track=43;
	  cdda_stop();
         Voicer_CdPlayWaitSet=1;
         Voicer_CdPlayWaitTime=VOICER_CD_WAITTIME;
      }
      if (vo_214e == 53 && vo_2150 == 1 && vo_2154 == 1 && vo_2156 == 1 && vo_2159 == 1 && Xxxcdda.Soundlink_cd_track!= 44)
      {
         Xxxcdda.Soundlink_cd_track=44;
	  cdda_stop();
         Voicer_CdPlayWaitSet=1;
         Voicer_CdPlayWaitTime=VOICER_CD_WAITTIME;
      }
      if (vo_214e == 54 && vo_2150 == 1 && vo_2154 == 1 && vo_2156 == 1 && vo_2159 == 1 && Xxxcdda.Soundlink_cd_track!= 45)
      {
         Xxxcdda.Soundlink_cd_track=45;
	  cdda_stop();
         Voicer_CdPlayWaitSet=1;
         Voicer_CdPlayWaitTime=VOICER_CD_WAITTIME;
      }
      if (vo_214e == 55 && vo_2150 == 1 && vo_2154 == 1 && vo_2156 == 1 && vo_2159 == 1 && Xxxcdda.Soundlink_cd_track!= 46)
      {
         Xxxcdda.Soundlink_cd_track=46;
	  cdda_stop();
         Voicer_CdPlayWaitSet=1;
         Voicer_CdPlayWaitTime=VOICER_CD_WAITTIME;
      }
      if (vo_214e == 56 && vo_2150 == 1 && vo_2154 == 1 && vo_2156 == 1 && vo_2159 == 1 && Xxxcdda.Soundlink_cd_track!= 47)
      {
         Xxxcdda.Soundlink_cd_track=47;
	  cdda_stop();
         Voicer_CdPlayWaitSet=1;
         Voicer_CdPlayWaitTime=VOICER_CD_WAITTIME;
      }

// 8͉p
      if (vo_214e == 57 && vo_2150 == 0 && vo_2154 == 1 && vo_2156 == 1 && vo_2159 == 1 && Xxxcdda.Soundlink_cd_track!= 51)
      {
         Xxxcdda.Soundlink_cd_track=51;
         Voicer_CdPlayWaitFlag = 0;
	  cdda_stop();
         cdda_play();
      }
      if (vo_214e == 58 && vo_2150 == 0 && vo_2154 == 1 && vo_2156 == 1 && vo_2159 == 1 && Xxxcdda.Soundlink_cd_track!= 52)
      {
         Xxxcdda.Soundlink_cd_track=52;
	  cdda_stop();
         Voicer_CdPlayWaitSet=1;
         Voicer_CdPlayWaitTime=VOICER_CD_WAITTIME;
      }
      if (vo_214e == 59 && vo_2150 == 0 && vo_2154 == 1 && vo_2156 == 1 && vo_2159 == 1 && Xxxcdda.Soundlink_cd_track!= 53)
      {
         Xxxcdda.Soundlink_cd_track=53;
	  cdda_stop();
         Voicer_CdPlayWaitSet=1;
         Voicer_CdPlayWaitTime=VOICER_CD_WAITTIME;
      }
      if (vo_214e == 60 && vo_2150 == 0 && vo_2154 == 1 && vo_2156 == 1 && vo_2159 == 1 && Xxxcdda.Soundlink_cd_track!= 54)
      {
         Xxxcdda.Soundlink_cd_track=54;
	  cdda_stop();
         Voicer_CdPlayWaitSet=1;
         Voicer_CdPlayWaitTime=VOICER_CD_WAITTIME;
      }
      if (vo_214e == 61 && vo_2150 == 0 && vo_2154 == 1 && vo_2156 == 1 && vo_2159 == 1 && Xxxcdda.Soundlink_cd_track!= 55)
      {
         Xxxcdda.Soundlink_cd_track=55;
	  cdda_stop();
         Voicer_CdPlayWaitSet=1;
         Voicer_CdPlayWaitTime=VOICER_CD_WAITTIME;
      }
      if (vo_214e == 62 && vo_2150 == 0 && vo_2154 == 1 && vo_2156 == 1 && vo_2159 == 1 && Xxxcdda.Soundlink_cd_track!= 56)
      {
         Xxxcdda.Soundlink_cd_track=56;
	  cdda_stop();
         Voicer_CdPlayWaitSet=1;
         Voicer_CdPlayWaitTime=VOICER_CD_WAITTIME;
      }
      if (vo_214e == 63 && vo_2150 == 0 && vo_2154 == 1 && vo_2156 == 1 && vo_2159 == 1 && Xxxcdda.Soundlink_cd_track!= 57)
      {
         Xxxcdda.Soundlink_cd_track=57;
	  cdda_stop();
         Voicer_CdPlayWaitSet=1;
         Voicer_CdPlayWaitTime=VOICER_CD_WAITTIME;
      }

// 8͓{
      if (vo_214e == 57 && vo_2150 == 1 && vo_2154 == 1 && vo_2156 == 1 && vo_2159 == 1 && Xxxcdda.Soundlink_cd_track!= 58)
      {
         Xxxcdda.Soundlink_cd_track=58;
         Voicer_CdPlayWaitFlag = 0;
	  cdda_stop();
         cdda_play();
      }
      if (vo_214e == 58 && vo_2150 == 1 && vo_2154 == 1 && vo_2156 == 1 && vo_2159 == 1 && Xxxcdda.Soundlink_cd_track!= 59)
      {
         Xxxcdda.Soundlink_cd_track=59;
	  cdda_stop();
         Voicer_CdPlayWaitSet=1;
         Voicer_CdPlayWaitTime=VOICER_CD_WAITTIME;
      }
      if (vo_214e == 59 && vo_2150 == 1 && vo_2154 == 1 && vo_2156 == 1 && vo_2159 == 1 && Xxxcdda.Soundlink_cd_track!= 60)
      {
         Xxxcdda.Soundlink_cd_track=60;
	  cdda_stop();
         Voicer_CdPlayWaitSet=1;
         Voicer_CdPlayWaitTime=VOICER_CD_WAITTIME;
      }
      if (vo_214e == 60 && vo_2150 == 1 && vo_2154 == 1 && vo_2156 == 1 && vo_2159 == 1 && Xxxcdda.Soundlink_cd_track!= 61)
      {
         Xxxcdda.Soundlink_cd_track=61;
	  cdda_stop();
         Voicer_CdPlayWaitSet=1;
         Voicer_CdPlayWaitTime=VOICER_CD_WAITTIME;
      }
      if (vo_214e == 61 && vo_2150 == 1 && vo_2154 == 1 && vo_2156 == 1 && vo_2159 == 1 && Xxxcdda.Soundlink_cd_track!= 62)
      {
         Xxxcdda.Soundlink_cd_track=62;
	  cdda_stop();
         Voicer_CdPlayWaitSet=1;
         Voicer_CdPlayWaitTime=VOICER_CD_WAITTIME;
      }
      if (vo_214e == 62 && vo_2150 == 1 && vo_2154 == 1 && vo_2156 == 1 && vo_2159 == 1 && Xxxcdda.Soundlink_cd_track!= 63)
      {
         Xxxcdda.Soundlink_cd_track=63;
	  cdda_stop();
         Voicer_CdPlayWaitSet=1;
         Voicer_CdPlayWaitTime=VOICER_CD_WAITTIME;
      }
      if (vo_214e == 63 && vo_2150 == 1 && vo_2154 == 1 && vo_2156 == 1 && vo_2159 == 1 && Xxxcdda.Soundlink_cd_track!= 64)
      {
         Xxxcdda.Soundlink_cd_track=64;
	  cdda_stop();
         Voicer_CdPlayWaitSet=1;
         Voicer_CdPlayWaitTime=VOICER_CD_WAITTIME;
      }

// 9͉p
      if (vo_214e == 64 && vo_2150 == 0 && vo_2154 == 1 && vo_2156 == 1 && vo_2159 == 1 && Xxxcdda.Soundlink_cd_track!= 68)
      {
         Xxxcdda.Soundlink_cd_track=68;
         Voicer_CdPlayWaitFlag = 0;
	  cdda_stop();
         cdda_play();
      }
      if (vo_214e == 65 && vo_2150 == 0 && vo_2154 == 1 && vo_2156 == 1 && vo_2159 == 1 && Xxxcdda.Soundlink_cd_track!= 69)
      {
         Xxxcdda.Soundlink_cd_track=69;
	  cdda_stop();
         Voicer_CdPlayWaitSet=1;
         Voicer_CdPlayWaitTime=VOICER_CD_WAITTIME;
      }
      if (vo_214e == 66 && vo_2150 == 0 && vo_2154 == 1 && vo_2156 == 1 && vo_2159 == 1 && Xxxcdda.Soundlink_cd_track!= 70)
      {
         Xxxcdda.Soundlink_cd_track=70;
	  cdda_stop();
         Voicer_CdPlayWaitSet=1;
         Voicer_CdPlayWaitTime=VOICER_CD_WAITTIME;
      }

// 9͓{
      if (vo_214e == 64 && vo_2150 == 1 && vo_2154 == 1 && vo_2156 == 1 && vo_2159 == 1 && Xxxcdda.Soundlink_cd_track!= 71)
      {
         Xxxcdda.Soundlink_cd_track=71;
         Voicer_CdPlayWaitFlag = 0;
	  cdda_stop();
         cdda_play();
      }
      if (vo_214e == 65 && vo_2150 == 1 && vo_2154 == 1 && vo_2156 == 1 && vo_2159 == 1 && Xxxcdda.Soundlink_cd_track!= 72)
      {
         Xxxcdda.Soundlink_cd_track=72;
	  cdda_stop();
         Voicer_CdPlayWaitSet=1;
         Voicer_CdPlayWaitTime=VOICER_CD_WAITTIME;
      }
      if (vo_214e == 66 && vo_2150 == 1 && vo_2154 == 1 && vo_2156 == 1 && vo_2159 == 1 && Xxxcdda.Soundlink_cd_track!= 73)
      {
         Xxxcdda.Soundlink_cd_track=73;
	  cdda_stop();
         Voicer_CdPlayWaitSet=1;
         Voicer_CdPlayWaitTime=VOICER_CD_WAITTIME;
      }

// 10͉p
      if (vo_214e == 67 && vo_2150 == 0 && vo_2154 == 1 && vo_2156 == 1 && vo_2159 == 1 && Xxxcdda.Soundlink_cd_track!= 75)
      {
         Xxxcdda.Soundlink_cd_track=75;
         Voicer_CdPlayWaitFlag = 0;
	  cdda_stop();
         cdda_play();
      }
      if (vo_214e == 68 && vo_2150 == 0 && vo_2154 == 1 && vo_2156 == 1 && vo_2159 == 1 && Xxxcdda.Soundlink_cd_track!= 76)
      {
         Xxxcdda.Soundlink_cd_track=76;
	  cdda_stop();
         Voicer_CdPlayWaitSet=1;
         Voicer_CdPlayWaitTime=VOICER_CD_WAITTIME;
      }
      if (vo_214e == 69 && vo_2150 == 0 && vo_2154 == 1 && vo_2156 == 1 && vo_2159 == 1 && Xxxcdda.Soundlink_cd_track!= 77)
      {
         Xxxcdda.Soundlink_cd_track=77;
	  cdda_stop();
         Voicer_CdPlayWaitSet=1;
         Voicer_CdPlayWaitTime=VOICER_CD_WAITTIME;
      }

// 10͓{
      if (vo_214e == 67 && vo_2150 == 1 && vo_2154 == 1 && vo_2156 == 1 && vo_2159 == 1 && Xxxcdda.Soundlink_cd_track!= 78)
      {
         Xxxcdda.Soundlink_cd_track=78;
         Voicer_CdPlayWaitFlag = 0;
	  cdda_stop();
         cdda_play();
      }
      if (vo_214e == 68 && vo_2150 == 1 && vo_2154 == 1 && vo_2156 == 1 && vo_2159 == 1 && Xxxcdda.Soundlink_cd_track!= 79)
      {
         Xxxcdda.Soundlink_cd_track=79;
	  cdda_stop();
         Voicer_CdPlayWaitSet=1;
         Voicer_CdPlayWaitTime=VOICER_CD_WAITTIME;
      }
      if (vo_214e == 69 && vo_2150 == 1 && vo_2154 == 1 && vo_2156 == 1 && vo_2159 == 1 && Xxxcdda.Soundlink_cd_track!= 80)
      {
         Xxxcdda.Soundlink_cd_track=80;
	  cdda_stop();
         Voicer_CdPlayWaitSet=1;
         Voicer_CdPlayWaitTime=VOICER_CD_WAITTIME;
      }

// 11͉p
      if (vo_214e == 70 && vo_2150 == 0 && vo_2154 == 1 && vo_2156 == 1 && vo_2159 == 1 && Xxxcdda.Soundlink_cd_track!= 84)
      {
         Xxxcdda.Soundlink_cd_track=84;
         Voicer_CdPlayWaitFlag = 0;
	  cdda_stop();
         cdda_play();
      }
      if (vo_214e == 71 && vo_2150 == 0 && vo_2154 == 1 && vo_2156 == 1 && vo_2159 == 1 && Xxxcdda.Soundlink_cd_track!= 85)
      {
         Xxxcdda.Soundlink_cd_track=85;
	  cdda_stop();
         Voicer_CdPlayWaitSet=1;
         Voicer_CdPlayWaitTime=VOICER_CD_WAITTIME;
      }
      if (vo_214e == 72 && vo_2150 == 0 && vo_2154 == 1 && vo_2156 == 1 && vo_2159 == 1 && Xxxcdda.Soundlink_cd_track!= 86)
      {
         Xxxcdda.Soundlink_cd_track=86;
	  cdda_stop();
         Voicer_CdPlayWaitSet=1;
         Voicer_CdPlayWaitTime=VOICER_CD_WAITTIME;
      }

// 11͓{
      if (vo_214e == 70 && vo_2150 == 1 && vo_2154 == 1 && vo_2156 == 1 && vo_2159 == 1 && Xxxcdda.Soundlink_cd_track!= 87)
      {
         Xxxcdda.Soundlink_cd_track=87;
         Voicer_CdPlayWaitFlag = 0;
	  cdda_stop();
         cdda_play();
      }
      if (vo_214e == 71 && vo_2150 == 1 && vo_2154 == 1 && vo_2156 == 1 && vo_2159 == 1 && Xxxcdda.Soundlink_cd_track!= 88)
      {
         Xxxcdda.Soundlink_cd_track=88;
	  cdda_stop();
         Voicer_CdPlayWaitSet=1;
         Voicer_CdPlayWaitTime=VOICER_CD_WAITTIME;
      }
      if (vo_214e == 72 && vo_2150 == 1 && vo_2154 == 1 && vo_2156 == 1 && vo_2159 == 1 && Xxxcdda.Soundlink_cd_track!= 89)
      {
         Xxxcdda.Soundlink_cd_track=89;
	  cdda_stop();
         Voicer_CdPlayWaitSet=1;
         Voicer_CdPlayWaitTime=VOICER_CD_WAITTIME;
      }

// 12͉p
      if (vo_214e == 73 && vo_2150 == 0 && vo_2154 == 1 && vo_2156 == 1 && vo_2159 == 1 && Xxxcdda.Soundlink_cd_track!= 90)
      {
         Xxxcdda.Soundlink_cd_track=90;
         Voicer_CdPlayWaitFlag = 0;
	  cdda_stop();
         cdda_play();
      }
      if (vo_214e == 74 && vo_2150 == 0 && vo_2154 == 1 && vo_2156 == 1 && vo_2159 == 1 && Xxxcdda.Soundlink_cd_track!= 91)
      {
         Xxxcdda.Soundlink_cd_track=91;
	  cdda_stop();
         Voicer_CdPlayWaitSet=1;
         Voicer_CdPlayWaitTime=VOICER_CD_WAITTIME;
      }
      if (vo_214e == 75 && vo_2150 == 0 && vo_2154 == 1 && vo_2156 == 1 && vo_2159 == 1 && Xxxcdda.Soundlink_cd_track!= 92)
      {
         Xxxcdda.Soundlink_cd_track=92;
	  cdda_stop();
         Voicer_CdPlayWaitSet=1;
         Voicer_CdPlayWaitTime=VOICER_CD_WAITTIME;
      }
      if (vo_214e == 76 && vo_2150 == 0 && vo_2154 == 1 && vo_2156 == 1 && vo_2159 == 1 && Xxxcdda.Soundlink_cd_track!= 93)
      {
         Xxxcdda.Soundlink_cd_track=93;
	  cdda_stop();
         Voicer_CdPlayWaitSet=1;
         Voicer_CdPlayWaitTime=VOICER_CD_WAITTIME;
      }
// 12͓{
      if (vo_214e == 73 && vo_2150 == 1 && vo_2154 == 1 && vo_2156 == 1 && vo_2159 == 1 && Xxxcdda.Soundlink_cd_track!= 94)
      {
         Xxxcdda.Soundlink_cd_track=94;
         Voicer_CdPlayWaitFlag = 0;
	  cdda_stop();
         cdda_play();
      }
      if (vo_214e == 74 && vo_2150 == 1 && vo_2154 == 1 && vo_2156 == 1 && vo_2159 == 1 && Xxxcdda.Soundlink_cd_track!= 95)
      {
         Xxxcdda.Soundlink_cd_track=95;
	  cdda_stop();
         Voicer_CdPlayWaitSet=1;
         Voicer_CdPlayWaitTime=VOICER_CD_WAITTIME;
      }
      if (vo_214e == 75 && vo_2150 == 1 && vo_2154 == 1 && vo_2156 == 1 && vo_2159 == 1 && Xxxcdda.Soundlink_cd_track!= 96)
      {
         Xxxcdda.Soundlink_cd_track=96;
	  cdda_stop();
         Voicer_CdPlayWaitSet=1;
         Voicer_CdPlayWaitTime=VOICER_CD_WAITTIME;
      }
      if (vo_214e == 76 && vo_2150 == 1 && vo_2154 == 1 && vo_2156 == 1 && vo_2159 == 1 && Xxxcdda.Soundlink_cd_track!= 97)
      {
         Xxxcdda.Soundlink_cd_track=97;
	  cdda_stop();
         Voicer_CdPlayWaitSet=1;
         Voicer_CdPlayWaitTime=VOICER_CD_WAITTIME;
      }
}

/*********************************************************************************************/
/* Emit2_Mondai                                                                               */
/*********************************************************************************************/

void Emit2_Mondai ()
{

      //0x214e Đԍ 
      //0x214f  K肩fꏊ 0x3ƗK
      //0x2150 0 p 1{ 
      //0x2154 0̑ 1bp[g
      //0x2156 0fBXNP 1fBXN2
      //0x2157 K
      //0x2159 1Đ 2|[Y 

      int vo_214e,vo_214f,vo_2150,vo_2154,vo_2156,vo_2157,vo_2159;
          vo_214e = Memory.RAM [0x214e];
          vo_214f = Memory.RAM [0x214f];
          vo_2150 = Memory.RAM [0x2150];
          vo_2154 = Memory.RAM [0x2154];
          vo_2156 = Memory.RAM [0x2156];
          vo_2157 = Memory.RAM [0x2157];
          vo_2159 = Memory.RAM [0x2159];

// 1 K
      if (vo_2157 == 0x15 && vo_2156 == 0 && vo_2159 == 1 && Xxxcdda.Soundlink_cd_track!= 22)
      {
         Xxxcdda.Soundlink_cd_track=22;
	  cdda_stop();
         cdda_play();
      }
      if (vo_2157 == 0x16 && vo_2156 == 0 && vo_2159 == 1 && Xxxcdda.Soundlink_cd_track!= 23)
      {
         Xxxcdda.Soundlink_cd_track=23;
	  cdda_stop();
         cdda_play();
      }
      if (vo_2157 == 0x17 && vo_2156 == 0 && vo_2159 == 1 && Xxxcdda.Soundlink_cd_track!= 24)
      {
         Xxxcdda.Soundlink_cd_track=24;
	  cdda_stop();
         cdda_play();
      }

// 2 K
      if (vo_2157 == 0x2a && vo_2156 == 0 && vo_2159 == 1 && Xxxcdda.Soundlink_cd_track!= 43)
      {
         Xxxcdda.Soundlink_cd_track=43;
	  cdda_stop();
         cdda_play();
      }
      if (vo_2157 == 0x2b && vo_2156 == 0 && vo_2159 == 1 && Xxxcdda.Soundlink_cd_track!= 44)
      {
         Xxxcdda.Soundlink_cd_track=44;
	  cdda_stop();
         cdda_play();
      }
      if (vo_2157 == 0x2c && vo_2156 == 0 && vo_2159 == 1 && Xxxcdda.Soundlink_cd_track!= 45)
      {
         Xxxcdda.Soundlink_cd_track=45;
	  cdda_stop();
         cdda_play();
      }
      if (vo_2157 == 0x2d && vo_2156 == 0 && vo_2159 == 1 && Xxxcdda.Soundlink_cd_track!= 46)
      {
         Xxxcdda.Soundlink_cd_track=46;
	  cdda_stop();
         cdda_play();
      }
      if (vo_2157 == 0x2e && vo_2156 == 0 && vo_2159 == 1 && Xxxcdda.Soundlink_cd_track!= 47)
      {
         Xxxcdda.Soundlink_cd_track=47;
	  cdda_stop();
         cdda_play();
      }
      if (vo_2157 == 0x2f && vo_2156 == 0 && vo_2159 == 1 && Xxxcdda.Soundlink_cd_track!= 48)
      {
         Xxxcdda.Soundlink_cd_track=48;
	  cdda_stop();
         cdda_play();
      }

// 4 K
      if (vo_2157 == 0x4e && vo_2156 == 0 && vo_2159 == 1 && Xxxcdda.Soundlink_cd_track!= 79)
      {
         Xxxcdda.Soundlink_cd_track=79;
	  cdda_stop();
         cdda_play();
      }
      if (vo_2157 == 0x4f && vo_2156 == 0 && vo_2159 == 1 && Xxxcdda.Soundlink_cd_track!= 80)
      {
         Xxxcdda.Soundlink_cd_track=80;
	  cdda_stop();
         cdda_play();
      }
      if (vo_2157 == 0x50 && vo_2156 == 0 && vo_2159 == 1 && Xxxcdda.Soundlink_cd_track!= 81)
      {
         Xxxcdda.Soundlink_cd_track=81;
	  cdda_stop();
         cdda_play();
      }
      if (vo_2157 == 0x51 && vo_2156 == 0 && vo_2159 == 1 && Xxxcdda.Soundlink_cd_track!= 82)
      {
         Xxxcdda.Soundlink_cd_track=82;
	  cdda_stop();
         cdda_play();
      }
      if (vo_2157 == 0x52 && vo_2156 == 0 && vo_2159 == 1 && Xxxcdda.Soundlink_cd_track!= 83)
      {
         Xxxcdda.Soundlink_cd_track=83;
	  cdda_stop();
         cdda_play();
      }

// 5 K
      if (vo_2157 == 0x5d && vo_2156 == 0 && vo_2159 == 1 && Xxxcdda.Soundlink_cd_track!= 94)
      {
         Xxxcdda.Soundlink_cd_track=94;
	  cdda_stop();
         cdda_play();
      }
      if (vo_2157 == 0x5e && vo_2156 == 0 && vo_2159 == 1 && Xxxcdda.Soundlink_cd_track!= 95)
      {
         Xxxcdda.Soundlink_cd_track=95;
	  cdda_stop();
         cdda_play();
      }
      if (vo_2157 == 0x5f && vo_2156 == 0 && vo_2159 == 1 && Xxxcdda.Soundlink_cd_track!= 96)
      {
         Xxxcdda.Soundlink_cd_track=96;
	  cdda_stop();
         cdda_play();
      }
      if (vo_2157 == 0x60 && vo_2156 == 0 && vo_2159 == 1 && Xxxcdda.Soundlink_cd_track!= 97)
      {
         Xxxcdda.Soundlink_cd_track=97;
	  cdda_stop();
         cdda_play();
      }

// 6 K
      if (vo_2157 == 0x1d && vo_2156 == 1 && vo_2159 == 1 && Xxxcdda.Soundlink_cd_track!= 30)
      {
         Xxxcdda.Soundlink_cd_track=30;
	  cdda_stop();
         cdda_play();
      }
      if (vo_2157 == 0x1e && vo_2156 == 1 && vo_2159 == 1 && Xxxcdda.Soundlink_cd_track!= 31)
      {
         Xxxcdda.Soundlink_cd_track=31;
	  cdda_stop();
         cdda_play();
      }
      if (vo_2157 == 0x1f && vo_2156 == 1 && vo_2159 == 1 && Xxxcdda.Soundlink_cd_track!= 32)
      {
         Xxxcdda.Soundlink_cd_track=32;
	  cdda_stop();
         cdda_play();
      }
      if (vo_2157 == 0x20 && vo_2156 == 1 && vo_2159 == 1 && Xxxcdda.Soundlink_cd_track!= 33)
      {
         Xxxcdda.Soundlink_cd_track=33;
	  cdda_stop();
         cdda_play();
      }
      if (vo_2157 == 0x21 && vo_2156 == 1 && vo_2159 == 1 && Xxxcdda.Soundlink_cd_track!= 34)
      {
         Xxxcdda.Soundlink_cd_track=34;
	  cdda_stop();
         cdda_play();
      }
      if (vo_2157 == 0x22 && vo_2156 == 1 && vo_2159 == 1 && Xxxcdda.Soundlink_cd_track!= 35)
      {
         Xxxcdda.Soundlink_cd_track=35;
	  cdda_stop();
         cdda_play();
      }

// 7 K
      if (vo_2157 == 0x2f && vo_2156 == 1 && vo_2159 == 1 && Xxxcdda.Soundlink_cd_track!= 48)
      {
         Xxxcdda.Soundlink_cd_track=48;
	  cdda_stop();
         cdda_play();
      }
      if (vo_2157 == 0x30 && vo_2156 == 1 && vo_2159 == 1 && Xxxcdda.Soundlink_cd_track!= 49)
      {
         Xxxcdda.Soundlink_cd_track=49;
	  cdda_stop();
         cdda_play();
      }
      if (vo_2157 == 0x31 && vo_2156 == 1 && vo_2159 == 1 && Xxxcdda.Soundlink_cd_track!= 50)
      {
         Xxxcdda.Soundlink_cd_track=50;
	  cdda_stop();
         cdda_play();
      }

// 8 K
      if (vo_2157 == 0x40 && vo_2156 == 1 && vo_2159 == 1 && Xxxcdda.Soundlink_cd_track!= 65)
      {
         Xxxcdda.Soundlink_cd_track=65;
	  cdda_stop();
         cdda_play();
      }
      if (vo_2157 == 0x41 && vo_2156 == 1 && vo_2159 == 1 && Xxxcdda.Soundlink_cd_track!= 66)
      {
         Xxxcdda.Soundlink_cd_track=66;
	  cdda_stop();
         cdda_play();
      }
      if (vo_2157 == 0x42 && vo_2156 == 1 && vo_2159 == 1 && Xxxcdda.Soundlink_cd_track!= 67)
      {
         Xxxcdda.Soundlink_cd_track=67;
	  cdda_stop();
         cdda_play();
      }

// 9 K
      if (vo_2157 == 0x49 && vo_2156 == 1 && vo_2159 == 1 && Xxxcdda.Soundlink_cd_track!= 74)
      {
         Xxxcdda.Soundlink_cd_track=74;
	  cdda_stop();
         cdda_play();
      }

// 10 K
      if (vo_2157 == 0x50 && vo_2156 == 1 && vo_2159 == 1 && Xxxcdda.Soundlink_cd_track!= 81)
      {
         Xxxcdda.Soundlink_cd_track=81;
	  cdda_stop();
         cdda_play();
      }
      if (vo_2157 == 0x51 && vo_2156 == 1 && vo_2159 == 1 && Xxxcdda.Soundlink_cd_track!= 82)
      {
         Xxxcdda.Soundlink_cd_track=82;
	  cdda_stop();
         cdda_play();
      }
      if (vo_2157 == 0x52 && vo_2156 == 1 && vo_2159 == 1 && Xxxcdda.Soundlink_cd_track!= 83)
      {
         Xxxcdda.Soundlink_cd_track=83;
	  cdda_stop();
         cdda_play();
      }

// 12 K
      if (vo_2157 == 0x61 && vo_2156 == 1 && vo_2159 == 1 && Xxxcdda.Soundlink_cd_track!= 98)
      {
         Xxxcdda.Soundlink_cd_track=98;
	  cdda_stop();
         cdda_play();
      }

}

/*********************************************************************************************/
/* Emit3_Story                                                                               */
/*********************************************************************************************/

void Emit3_Story ()
{

      //0x214e Đԍ 
      //0x214f  K肩fꏊ 0x3ƗK
      //0x2150 0 p 1{ 
      //0x2154 0̑ 1bp[g
      //0x2156 0fBXNP 1fBXN2
      //0x2157 K
      //0x2159 1Đ 2|[Y 

      int vo_214e,vo_214f,vo_2150,vo_2154,vo_2156,vo_2157,vo_2159;
          vo_214e = Memory.RAM [0x214e];
          vo_214f = Memory.RAM [0x214f];
          vo_2150 = Memory.RAM [0x2150];
          vo_2154 = Memory.RAM [0x2154];
          vo_2156 = Memory.RAM [0x2156];
          vo_2157 = Memory.RAM [0x2157];
          vo_2159 = Memory.RAM [0x2159];

// I[vjO
      if (vo_214e == 0 && vo_2154 == 0 && vo_2159 == 1 && Xxxcdda.Soundlink_cd_track!= 1)
      {
         Xxxcdda.Soundlink_cd_track=1;
         Voicer_CdPlayWaitFlag = 0;
	  cdda_stop();
         cdda_play();
         //Settings.H_Max = (85 * SNES_CYCLES_PER_SCANLINE) / 100;
       }

// GfBO
      if (vo_214e == 69 && vo_2159 == 1 && Xxxcdda.Soundlink_cd_track!= 2)
      {
         Xxxcdda.Soundlink_cd_track=2;
         Voicer_CdPlayWaitFlag = 0;
	  cdda_stop();
         cdda_play();
         //Settings.H_Max = (85 * SNES_CYCLES_PER_SCANLINE) / 100;
       }

// 1͉p
      if (vo_214e == 0 && vo_2150 == 0 && vo_2154 == 1 && vo_2156 == 0 && vo_2159 == 1 && Xxxcdda.Soundlink_cd_track!= 4)
      {
         Xxxcdda.Soundlink_cd_track=4;
         Voicer_CdPlayWaitFlag = 0;
	  cdda_stop();
         cdda_play();
      }

      if (vo_214e == 1 && vo_2150 == 0 && vo_2154 == 1 && vo_2156 == 0 && vo_2159 == 1 && Xxxcdda.Soundlink_cd_track!= 5)
      {
         Xxxcdda.Soundlink_cd_track=5;
	  cdda_stop();
         Voicer_CdPlayWaitSet=1;
         Voicer_CdPlayWaitTime=VOICER_CD_WAITTIME;
      }

      if (vo_214e == 2 && vo_2150 == 0 && vo_2154 == 1 && vo_2156 == 0 && vo_2159 == 1 && Xxxcdda.Soundlink_cd_track!= 6)
      {
         Xxxcdda.Soundlink_cd_track=6;
	  cdda_stop();
         Voicer_CdPlayWaitSet=1;
         Voicer_CdPlayWaitTime=VOICER_CD_WAITTIME;
      }

      if (vo_214e == 3 && vo_2150 == 0 && vo_2154 == 1 && vo_2156 == 0 && vo_2159 == 1 && Xxxcdda.Soundlink_cd_track!= 7)
      {
         Xxxcdda.Soundlink_cd_track=7;
	  cdda_stop();
         Voicer_CdPlayWaitSet=1;
         Voicer_CdPlayWaitTime=VOICER_CD_WAITTIME;
      }

      if (vo_214e == 4 && vo_2150 == 0 && vo_2154 == 1 && vo_2156 == 0 && vo_2159 == 1 && Xxxcdda.Soundlink_cd_track!= 8)
      {
         Xxxcdda.Soundlink_cd_track=8;
	  cdda_stop();
         Voicer_CdPlayWaitSet=1;
         Voicer_CdPlayWaitTime=VOICER_CD_WAITTIME;
      }

      if (vo_214e == 5 && vo_2150 == 0 && vo_2154 == 1 && vo_2156 == 0 && vo_2159 == 1 && Xxxcdda.Soundlink_cd_track!= 9)
      {
         Xxxcdda.Soundlink_cd_track=9;
	  cdda_stop();
         Voicer_CdPlayWaitSet=1;
         Voicer_CdPlayWaitTime=VOICER_CD_WAITTIME;
      }

      if (vo_214e == 6 && vo_2150 == 0 && vo_2154 == 1 && vo_2156 == 0 && vo_2159 == 1 && Xxxcdda.Soundlink_cd_track!= 10)
      {
         Xxxcdda.Soundlink_cd_track=10;
	  cdda_stop();
         Voicer_CdPlayWaitSet=1;
         Voicer_CdPlayWaitTime=VOICER_CD_WAITTIME;
      }

      if (vo_214e == 7 && vo_2150 == 0 && vo_2154 == 1 && vo_2156 == 0 && vo_2159 == 1 && Xxxcdda.Soundlink_cd_track!= 11)
      {
         Xxxcdda.Soundlink_cd_track=11;
	  cdda_stop();
         Voicer_CdPlayWaitSet=1;
         Voicer_CdPlayWaitTime=VOICER_CD_WAITTIME;
      }

      if (vo_214e == 8 && vo_2150 == 0 && vo_2154 == 1 && vo_2156 == 0 && vo_2159 == 1 && Xxxcdda.Soundlink_cd_track!= 12)
      {
         Xxxcdda.Soundlink_cd_track=12;
	  cdda_stop();
         Voicer_CdPlayWaitSet=1;
         Voicer_CdPlayWaitTime=VOICER_CD_WAITTIME;
      }

// 1͓{
      if (vo_214e == 0 && vo_2150 == 1 && vo_2154 == 1 && vo_2156 == 0 && vo_2159 == 1 && Xxxcdda.Soundlink_cd_track!= 13)
      {
         Xxxcdda.Soundlink_cd_track=13;
         Voicer_CdPlayWaitFlag = 0;
	  cdda_stop();
         cdda_play();
      }

      if (vo_214e == 1 && vo_2150 == 1 && vo_2154 == 1 && vo_2156 == 0 && vo_2159 == 1 && Xxxcdda.Soundlink_cd_track!= 14)
      {
         Xxxcdda.Soundlink_cd_track=14;
	  cdda_stop();
         Voicer_CdPlayWaitSet=1;
         Voicer_CdPlayWaitTime=VOICER_CD_WAITTIME;
      }

      if (vo_214e == 2 && vo_2150 == 1 && vo_2154 == 1 && vo_2156 == 0 && vo_2159 == 1 && Xxxcdda.Soundlink_cd_track!= 15)
      {
         Xxxcdda.Soundlink_cd_track=15;
	  cdda_stop();
         Voicer_CdPlayWaitSet=1;
         Voicer_CdPlayWaitTime=VOICER_CD_WAITTIME;
      }

      if (vo_214e == 3 && vo_2150 == 1 && vo_2154 == 1 && vo_2156 == 0 && vo_2159 == 1 && Xxxcdda.Soundlink_cd_track!= 16)
      {
         Xxxcdda.Soundlink_cd_track=16;
	  cdda_stop();
         Voicer_CdPlayWaitSet=1;
         Voicer_CdPlayWaitTime=VOICER_CD_WAITTIME;
      }

      if (vo_214e == 4 && vo_2150 == 1 && vo_2154 == 1 && vo_2156 == 0 && vo_2159 == 1 && Xxxcdda.Soundlink_cd_track!= 17)
      {
         Xxxcdda.Soundlink_cd_track=17;
	  cdda_stop();
         Voicer_CdPlayWaitSet=1;
         Voicer_CdPlayWaitTime=VOICER_CD_WAITTIME;
      }

      if (vo_214e == 5 && vo_2150 == 1 && vo_2154 == 1 && vo_2156 == 0 && vo_2159 == 1 && Xxxcdda.Soundlink_cd_track!= 18)
      {
         Xxxcdda.Soundlink_cd_track=18;
	  cdda_stop();
         Voicer_CdPlayWaitSet=1;
         Voicer_CdPlayWaitTime=VOICER_CD_WAITTIME;
      }

      if (vo_214e == 6 && vo_2150 == 1 && vo_2154 == 1 && vo_2156 == 0 && vo_2159 == 1 && Xxxcdda.Soundlink_cd_track!= 19)
      {
         Xxxcdda.Soundlink_cd_track=19;
	  cdda_stop();
         Voicer_CdPlayWaitSet=1;
         Voicer_CdPlayWaitTime=VOICER_CD_WAITTIME;
      }

      if (vo_214e == 7 && vo_2150 == 1 && vo_2154 == 1 && vo_2156 == 0 && vo_2159 == 1 && Xxxcdda.Soundlink_cd_track!= 20)
      {
         Xxxcdda.Soundlink_cd_track=20;
	  cdda_stop();
         Voicer_CdPlayWaitSet=1;
         Voicer_CdPlayWaitTime=VOICER_CD_WAITTIME;
      }

      if (vo_214e == 8 && vo_2150 == 1 && vo_2154 == 1 && vo_2156 == 0 && vo_2159 == 1 && Xxxcdda.Soundlink_cd_track!= 21)
      {
         Xxxcdda.Soundlink_cd_track=21;
	  cdda_stop();
         Voicer_CdPlayWaitSet=1;
         Voicer_CdPlayWaitTime=VOICER_CD_WAITTIME;
      }

// 2͉p
      if (vo_214e == 9 && vo_2150 == 0 && vo_2154 == 1 && vo_2156 == 0 && vo_2159 == 1 && Xxxcdda.Soundlink_cd_track!= 25)
      {
         Xxxcdda.Soundlink_cd_track=25;
         Voicer_CdPlayWaitFlag = 0;
	  cdda_stop();
         cdda_play();
      }
      if (vo_214e == 10 && vo_2150 == 0 && vo_2154 == 1 && vo_2156 == 0 && vo_2159 == 1 && Xxxcdda.Soundlink_cd_track!= 26)
      {
         Xxxcdda.Soundlink_cd_track=26;
	  cdda_stop();
         Voicer_CdPlayWaitSet=1;
         Voicer_CdPlayWaitTime=VOICER_CD_WAITTIME;
      }
      if (vo_214e == 11 && vo_2150 == 0 && vo_2154 == 1 && vo_2156 == 0 && vo_2159 == 1 && Xxxcdda.Soundlink_cd_track!= 27)
      {
         Xxxcdda.Soundlink_cd_track=27;
	  cdda_stop();
         Voicer_CdPlayWaitSet=1;
         Voicer_CdPlayWaitTime=VOICER_CD_WAITTIME;
      }
      if (vo_214e == 12 && vo_2150 == 0 && vo_2154 == 1 && vo_2156 == 0 && vo_2159 == 1 && Xxxcdda.Soundlink_cd_track!= 28)
      {
         Xxxcdda.Soundlink_cd_track=28;
	  cdda_stop();
         Voicer_CdPlayWaitSet=1;
         Voicer_CdPlayWaitTime=VOICER_CD_WAITTIME;
      }
      if (vo_214e == 13 && vo_2150 == 0 && vo_2154 == 1 && vo_2156 == 0 && vo_2159 == 1 && Xxxcdda.Soundlink_cd_track!= 29)
      {
         Xxxcdda.Soundlink_cd_track=29;
	  cdda_stop();
         Voicer_CdPlayWaitSet=1;
         Voicer_CdPlayWaitTime=VOICER_CD_WAITTIME;
      }
      if (vo_214e == 14 && vo_2150 == 0 && vo_2154 == 1 && vo_2156 == 0 && vo_2159 == 1 && Xxxcdda.Soundlink_cd_track!= 30)
      {
         Xxxcdda.Soundlink_cd_track=30;
	  cdda_stop();
         Voicer_CdPlayWaitSet=1;
         Voicer_CdPlayWaitTime=VOICER_CD_WAITTIME;
      }
      if (vo_214e == 15 && vo_2150 == 0 && vo_2154 == 1 && vo_2156 == 0 && vo_2159 == 1 && Xxxcdda.Soundlink_cd_track!= 31)
      {
         Xxxcdda.Soundlink_cd_track=31;
	  cdda_stop();
         Voicer_CdPlayWaitSet=1;
         Voicer_CdPlayWaitTime=VOICER_CD_WAITTIME;
      }
      if (vo_214e == 16 && vo_2150 == 0 && vo_2154 == 1 && vo_2156 == 0 && vo_2159 == 1 && Xxxcdda.Soundlink_cd_track!= 32)
      {
         Xxxcdda.Soundlink_cd_track=32;
	  cdda_stop();
         Voicer_CdPlayWaitSet=1;
         Voicer_CdPlayWaitTime=VOICER_CD_WAITTIME;
      }

// 2͓{
      if (vo_214e == 9 && vo_2150 == 1 && vo_2154 == 1 && vo_2156 == 0 && vo_2159 == 1 && Xxxcdda.Soundlink_cd_track!= 33)
      {
         Xxxcdda.Soundlink_cd_track=33;
         Voicer_CdPlayWaitFlag = 0;
	  cdda_stop();
         cdda_play();
      }
      if (vo_214e == 10 && vo_2150 == 1 && vo_2154 == 1 && vo_2156 == 0 && vo_2159 == 1 && Xxxcdda.Soundlink_cd_track!= 34)
      {
         Xxxcdda.Soundlink_cd_track=34;
	  cdda_stop();
         Voicer_CdPlayWaitSet=1;
         Voicer_CdPlayWaitTime=VOICER_CD_WAITTIME;
      }
      if (vo_214e == 11 && vo_2150 == 1 && vo_2154 == 1 && vo_2156 == 0 && vo_2159 == 1 && Xxxcdda.Soundlink_cd_track!= 35)
      {
         Xxxcdda.Soundlink_cd_track=35;
	  cdda_stop();
         Voicer_CdPlayWaitSet=1;
         Voicer_CdPlayWaitTime=VOICER_CD_WAITTIME;
      }
      if (vo_214e == 12 && vo_2150 == 1 && vo_2154 == 1 && vo_2156 == 0 && vo_2159 == 1 && Xxxcdda.Soundlink_cd_track!= 36)
      {
         Xxxcdda.Soundlink_cd_track=36;
	  cdda_stop();
         Voicer_CdPlayWaitSet=1;
         Voicer_CdPlayWaitTime=VOICER_CD_WAITTIME;
      }
      if (vo_214e == 13 && vo_2150 == 1 && vo_2154 == 1 && vo_2156 == 0 && vo_2159 == 1 && Xxxcdda.Soundlink_cd_track!= 37)
      {
         Xxxcdda.Soundlink_cd_track=37;
	  cdda_stop();
         Voicer_CdPlayWaitSet=1;
         Voicer_CdPlayWaitTime=VOICER_CD_WAITTIME;
      }
      if (vo_214e == 14 && vo_2150 == 1 && vo_2154 == 1 && vo_2156 == 0 && vo_2159 == 1 && Xxxcdda.Soundlink_cd_track!= 38)
      {
         Xxxcdda.Soundlink_cd_track=38;
	  cdda_stop();
         Voicer_CdPlayWaitSet=1;
         Voicer_CdPlayWaitTime=VOICER_CD_WAITTIME;
      }
      if (vo_214e == 15 && vo_2150 == 1 && vo_2154 == 1 && vo_2156 == 0 && vo_2159 == 1 && Xxxcdda.Soundlink_cd_track!= 39)
      {
         Xxxcdda.Soundlink_cd_track=39;
	  cdda_stop();
         Voicer_CdPlayWaitSet=1;
         Voicer_CdPlayWaitTime=VOICER_CD_WAITTIME;
      }
      if (vo_214e == 16 && vo_2150 == 1 && vo_2154 == 1 && vo_2156 == 0 && vo_2159 == 1 && Xxxcdda.Soundlink_cd_track!= 40)
      {
         Xxxcdda.Soundlink_cd_track=40;
	  cdda_stop();
         Voicer_CdPlayWaitSet=1;
         Voicer_CdPlayWaitTime=VOICER_CD_WAITTIME;
      }

// 3͉p
      if (vo_214e == 17 && vo_2150 == 0 && vo_2154 == 1 && vo_2156 == 0 && vo_2159 == 1 && Xxxcdda.Soundlink_cd_track!= 51)
      {
         Xxxcdda.Soundlink_cd_track=51;
         Voicer_CdPlayWaitFlag = 0;
	  cdda_stop();
         cdda_play();
      }
      if (vo_214e == 18 && vo_2150 == 0 && vo_2154 == 1 && vo_2156 == 0 && vo_2159 == 1 && Xxxcdda.Soundlink_cd_track!= 52)
      {
         Xxxcdda.Soundlink_cd_track=52;
	  cdda_stop();
         Voicer_CdPlayWaitSet=1;
         Voicer_CdPlayWaitTime=VOICER_CD_WAITTIME;
      }
      if (vo_214e == 19 && vo_2150 == 0 && vo_2154 == 1 && vo_2156 == 0 && vo_2159 == 1 && Xxxcdda.Soundlink_cd_track!= 53)
      {
         Xxxcdda.Soundlink_cd_track=53;
	  cdda_stop();
         Voicer_CdPlayWaitSet=1;
         Voicer_CdPlayWaitTime=VOICER_CD_WAITTIME;
      }
      if (vo_214e == 20 && vo_2150 == 0 && vo_2154 == 1 && vo_2156 == 0 && vo_2159 == 1 && Xxxcdda.Soundlink_cd_track!= 54)
      {
         Xxxcdda.Soundlink_cd_track=54;
	  cdda_stop();
         Voicer_CdPlayWaitSet=1;
         Voicer_CdPlayWaitTime=VOICER_CD_WAITTIME;
      }
      if (vo_214e == 21 && vo_2150 == 0 && vo_2154 == 1 && vo_2156 == 0 && vo_2159 == 1 && Xxxcdda.Soundlink_cd_track!= 55)
      {
         Xxxcdda.Soundlink_cd_track=55;
	  cdda_stop();
         Voicer_CdPlayWaitSet=1;
         Voicer_CdPlayWaitTime=VOICER_CD_WAITTIME;
      }
      if (vo_214e == 22 && vo_2150 == 0 && vo_2154 == 1 && vo_2156 == 0 && vo_2159 == 1 && Xxxcdda.Soundlink_cd_track!= 56)
      {
         Xxxcdda.Soundlink_cd_track=56;
	  cdda_stop();
         Voicer_CdPlayWaitSet=1;
         Voicer_CdPlayWaitTime=VOICER_CD_WAITTIME;
      }
      if (vo_214e == 23 && vo_2150 == 0 && vo_2154 == 1 && vo_2156 == 0 && vo_2159 == 1 && Xxxcdda.Soundlink_cd_track!= 57)
      {
         Xxxcdda.Soundlink_cd_track=57;
	  cdda_stop();
         Voicer_CdPlayWaitSet=1;
         Voicer_CdPlayWaitTime=VOICER_CD_WAITTIME;
      }
      if (vo_214e == 24 && vo_2150 == 0 && vo_2154 == 1 && vo_2156 == 0 && vo_2159 == 1 && Xxxcdda.Soundlink_cd_track!= 58)
      {
         Xxxcdda.Soundlink_cd_track=58;
	  cdda_stop();
         Voicer_CdPlayWaitSet=1;
         Voicer_CdPlayWaitTime=VOICER_CD_WAITTIME;
      }
      if (vo_214e == 25 && vo_2150 == 0 && vo_2154 == 1 && vo_2156 == 0 && vo_2159 == 1 && Xxxcdda.Soundlink_cd_track!= 59)
      {
         Xxxcdda.Soundlink_cd_track=59;
	  cdda_stop();
         Voicer_CdPlayWaitSet=1;
         Voicer_CdPlayWaitTime=VOICER_CD_WAITTIME;
      }

// 3͓{
      if (vo_214e == 17 && vo_2150 == 1 && vo_2154 == 1 && vo_2156 == 0 && vo_2159 == 1 && Xxxcdda.Soundlink_cd_track!= 60)
      {
         Xxxcdda.Soundlink_cd_track=60;
         Voicer_CdPlayWaitFlag = 0;
	  cdda_stop();
         cdda_play();
      }
      if (vo_214e == 18 && vo_2150 == 1 && vo_2154 == 1 && vo_2156 == 0 && vo_2159 == 1 && Xxxcdda.Soundlink_cd_track!= 61)
      {
         Xxxcdda.Soundlink_cd_track=61;
	  cdda_stop();
         Voicer_CdPlayWaitSet=1;
         Voicer_CdPlayWaitTime=VOICER_CD_WAITTIME;
      }
      if (vo_214e == 19 && vo_2150 == 1 && vo_2154 == 1 && vo_2156 == 0 && vo_2159 == 1 && Xxxcdda.Soundlink_cd_track!= 62)
      {
         Xxxcdda.Soundlink_cd_track=62;
	  cdda_stop();
         Voicer_CdPlayWaitSet=1;
         Voicer_CdPlayWaitTime=VOICER_CD_WAITTIME;
      }
      if (vo_214e == 20 && vo_2150 == 1 && vo_2154 == 1 && vo_2156 == 0 && vo_2159 == 1 && Xxxcdda.Soundlink_cd_track!= 63)
      {
         Xxxcdda.Soundlink_cd_track=63;
	  cdda_stop();
         Voicer_CdPlayWaitSet=1;
         Voicer_CdPlayWaitTime=VOICER_CD_WAITTIME;
      }
      if (vo_214e == 21 && vo_2150 == 1 && vo_2154 == 1 && vo_2156 == 0 && vo_2159 == 1 && Xxxcdda.Soundlink_cd_track!= 64)
      {
         Xxxcdda.Soundlink_cd_track=64;
	  cdda_stop();
         Voicer_CdPlayWaitSet=1;
         Voicer_CdPlayWaitTime=VOICER_CD_WAITTIME;
      }
      if (vo_214e == 22 && vo_2150 == 1 && vo_2154 == 1 && vo_2156 == 0 && vo_2159 == 1 && Xxxcdda.Soundlink_cd_track!= 65)
      {
         Xxxcdda.Soundlink_cd_track=65;
	  cdda_stop();
         Voicer_CdPlayWaitSet=1;
         Voicer_CdPlayWaitTime=VOICER_CD_WAITTIME;
      }
      if (vo_214e == 23 && vo_2150 == 1 && vo_2154 == 1 && vo_2156 == 0 && vo_2159 == 1 && Xxxcdda.Soundlink_cd_track!= 66)
      {
         Xxxcdda.Soundlink_cd_track=66;
	  cdda_stop();
         Voicer_CdPlayWaitSet=1;
         Voicer_CdPlayWaitTime=VOICER_CD_WAITTIME;
      }
      if (vo_214e == 24 && vo_2150 == 1 && vo_2154 == 1 && vo_2156 == 0 && vo_2159 == 1 && Xxxcdda.Soundlink_cd_track!= 67)
      {
         Xxxcdda.Soundlink_cd_track=67;
	  cdda_stop();
         Voicer_CdPlayWaitSet=1;
         Voicer_CdPlayWaitTime=VOICER_CD_WAITTIME;
      }
      if (vo_214e == 25 && vo_2150 == 1 && vo_2154 == 1 && vo_2156 == 0 && vo_2159 == 1 && Xxxcdda.Soundlink_cd_track!= 68)
      {
         Xxxcdda.Soundlink_cd_track=68;
	  cdda_stop();
         Voicer_CdPlayWaitSet=1;
         Voicer_CdPlayWaitTime=VOICER_CD_WAITTIME;
      }

// 4͉p
      if (vo_214e == 26 && vo_2150 == 0 && vo_2154 == 1 && vo_2156 == 0 && vo_2159 == 1 && Xxxcdda.Soundlink_cd_track!= 71)
      {
         Xxxcdda.Soundlink_cd_track=71;
         Voicer_CdPlayWaitFlag = 0;
	  cdda_stop();
         cdda_play();
      }
      if (vo_214e == 27 && vo_2150 == 0 && vo_2154 == 1 && vo_2156 == 0 && vo_2159 == 1 && Xxxcdda.Soundlink_cd_track!= 72)
      {
         Xxxcdda.Soundlink_cd_track=72;
	  cdda_stop();
         Voicer_CdPlayWaitSet=1;
         Voicer_CdPlayWaitTime=VOICER_CD_WAITTIME;
      }
      if (vo_214e == 28 && vo_2150 == 0 && vo_2154 == 1 && vo_2156 == 0 && vo_2159 == 1 && Xxxcdda.Soundlink_cd_track!= 73)
      {
         Xxxcdda.Soundlink_cd_track=73;
	  cdda_stop();
         Voicer_CdPlayWaitSet=1;
         Voicer_CdPlayWaitTime=VOICER_CD_WAITTIME;
      }

// 4͓{
      if (vo_214e == 26 && vo_2150 == 1 && vo_2154 == 1 && vo_2156 == 0 && vo_2159 == 1 && Xxxcdda.Soundlink_cd_track!= 74)
      {
         Xxxcdda.Soundlink_cd_track=74;
         Voicer_CdPlayWaitFlag = 0;
	  cdda_stop();
         cdda_play();
      }
      if (vo_214e == 27 && vo_2150 == 1 && vo_2154 == 1 && vo_2156 == 0 && vo_2159 == 1 && Xxxcdda.Soundlink_cd_track!= 75)
      {
         Xxxcdda.Soundlink_cd_track=75;
	  cdda_stop();
         Voicer_CdPlayWaitSet=1;
         Voicer_CdPlayWaitTime=VOICER_CD_WAITTIME;
      }
      if (vo_214e == 28 && vo_2150 == 1 && vo_2154 == 1 && vo_2156 == 0 && vo_2159 == 1 && Xxxcdda.Soundlink_cd_track!= 76)
      {
         Xxxcdda.Soundlink_cd_track=76;
	  cdda_stop();
         Voicer_CdPlayWaitSet=1;
         Voicer_CdPlayWaitTime=VOICER_CD_WAITTIME;
      }

// 5͉p
      if (vo_214e == 29 && vo_2150 == 0 && vo_2154 == 1 && vo_2156 == 0 && vo_2159 == 1 && Xxxcdda.Soundlink_cd_track!= 78)
      {
         Xxxcdda.Soundlink_cd_track=78;
         Voicer_CdPlayWaitFlag = 0;
	  cdda_stop();
         cdda_play();
      }
      if (vo_214e == 30 && vo_2150 == 0 && vo_2154 == 1 && vo_2156 == 0 && vo_2159 == 1 && Xxxcdda.Soundlink_cd_track!= 79)
      {
         Xxxcdda.Soundlink_cd_track=79;
	  cdda_stop();
         Voicer_CdPlayWaitSet=1;
         Voicer_CdPlayWaitTime=VOICER_CD_WAITTIME;
      }
      if (vo_214e == 31 && vo_2150 == 0 && vo_2154 == 1 && vo_2156 == 0 && vo_2159 == 1 && Xxxcdda.Soundlink_cd_track!= 80)
      {
         Xxxcdda.Soundlink_cd_track=80;
	  cdda_stop();
         Voicer_CdPlayWaitSet=1;
         Voicer_CdPlayWaitTime=VOICER_CD_WAITTIME;
      }

// 5͓{
      if (vo_214e == 29 && vo_2150 == 1 && vo_2154 == 1 && vo_2156 == 0 && vo_2159 == 1 && Xxxcdda.Soundlink_cd_track!= 81)
      {
         Xxxcdda.Soundlink_cd_track=81;
         Voicer_CdPlayWaitFlag = 0;
	  cdda_stop();
         cdda_play();
      }
      if (vo_214e == 30 && vo_2150 == 1 && vo_2154 == 1 && vo_2156 == 0 && vo_2159 == 1 && Xxxcdda.Soundlink_cd_track!= 82)
      {
         Xxxcdda.Soundlink_cd_track=82;
	  cdda_stop();
         Voicer_CdPlayWaitSet=1;
         Voicer_CdPlayWaitTime=VOICER_CD_WAITTIME;
      }
      if (vo_214e == 31 && vo_2150 == 1 && vo_2154 == 1 && vo_2156 == 0 && vo_2159 == 1 && Xxxcdda.Soundlink_cd_track!= 83)
      {
         Xxxcdda.Soundlink_cd_track=83;
	  cdda_stop();
         Voicer_CdPlayWaitSet=1;
         Voicer_CdPlayWaitTime=VOICER_CD_WAITTIME;
      }

// 6͉p
      if (vo_214e == 32 && vo_2150 == 0 && vo_2154 == 1 && vo_2156 == 1 && vo_2159 == 1 && Xxxcdda.Soundlink_cd_track!= 4)
      {
         Xxxcdda.Soundlink_cd_track=4;
         Voicer_CdPlayWaitFlag = 0;
	  cdda_stop();
         cdda_play();
      }
      if (vo_214e == 33 && vo_2150 == 0 && vo_2154 == 1 && vo_2156 == 1 && vo_2159 == 1 && Xxxcdda.Soundlink_cd_track!= 5)
      {
         Xxxcdda.Soundlink_cd_track=5;
	  cdda_stop();
         Voicer_CdPlayWaitSet=1;
         Voicer_CdPlayWaitTime=VOICER_CD_WAITTIME;
      }
      if (vo_214e == 34 && vo_2150 == 0 && vo_2154 == 1 && vo_2156 == 1 && vo_2159 == 1 && Xxxcdda.Soundlink_cd_track!= 6)
      {
         Xxxcdda.Soundlink_cd_track=6;
	  cdda_stop();
         Voicer_CdPlayWaitSet=1;
         Voicer_CdPlayWaitTime=VOICER_CD_WAITTIME;
      }
      if (vo_214e == 35 && vo_2150 == 0 && vo_2154 == 1 && vo_2156 == 1 && vo_2159 == 1 && Xxxcdda.Soundlink_cd_track!= 7)
      {
         Xxxcdda.Soundlink_cd_track=7;
	  cdda_stop();
         Voicer_CdPlayWaitSet=1;
         Voicer_CdPlayWaitTime=VOICER_CD_WAITTIME;
      }
      if (vo_214e == 36 && vo_2150 == 0 && vo_2154 == 1 && vo_2156 == 1 && vo_2159 == 1 && Xxxcdda.Soundlink_cd_track!= 8)
      {
         Xxxcdda.Soundlink_cd_track=8;
	  cdda_stop();
         Voicer_CdPlayWaitSet=1;
         Voicer_CdPlayWaitTime=VOICER_CD_WAITTIME;
      }
      if (vo_214e == 37 && vo_2150 == 0 && vo_2154 == 1 && vo_2156 == 1 && vo_2159 == 1 && Xxxcdda.Soundlink_cd_track!= 9)
      {
         Xxxcdda.Soundlink_cd_track=9;
	  cdda_stop();
         Voicer_CdPlayWaitSet=1;
         Voicer_CdPlayWaitTime=VOICER_CD_WAITTIME;
      }

// 6͓{
      if (vo_214e == 32 && vo_2150 == 1 && vo_2154 == 1 && vo_2156 == 1 && vo_2159 == 1 && Xxxcdda.Soundlink_cd_track!= 10)
      {
         Xxxcdda.Soundlink_cd_track=10;
         Voicer_CdPlayWaitFlag = 0;
	  cdda_stop();
         cdda_play();
      }
      if (vo_214e == 33 && vo_2150 == 1 && vo_2154 == 1 && vo_2156 == 1 && vo_2159 == 1 && Xxxcdda.Soundlink_cd_track!= 11)
      {
         Xxxcdda.Soundlink_cd_track=11;
	  cdda_stop();
         Voicer_CdPlayWaitSet=1;
         Voicer_CdPlayWaitTime=VOICER_CD_WAITTIME;
      }
      if (vo_214e == 34 && vo_2150 == 1 && vo_2154 == 1 && vo_2156 == 1 && vo_2159 == 1 && Xxxcdda.Soundlink_cd_track!= 12)
      {
         Xxxcdda.Soundlink_cd_track=12;
	  cdda_stop();
         Voicer_CdPlayWaitSet=1;
         Voicer_CdPlayWaitTime=VOICER_CD_WAITTIME;
      }
      if (vo_214e == 35 && vo_2150 == 1 && vo_2154 == 1 && vo_2156 == 1 && vo_2159 == 1 && Xxxcdda.Soundlink_cd_track!= 13)
      {
         Xxxcdda.Soundlink_cd_track=13;
	  cdda_stop();
         Voicer_CdPlayWaitSet=1;
         Voicer_CdPlayWaitTime=VOICER_CD_WAITTIME;
      }
      if (vo_214e == 36 && vo_2150 == 1 && vo_2154 == 1 && vo_2156 == 1 && vo_2159 == 1 && Xxxcdda.Soundlink_cd_track!= 14)
      {
         Xxxcdda.Soundlink_cd_track=14;
	  cdda_stop();
         Voicer_CdPlayWaitSet=1;
         Voicer_CdPlayWaitTime=VOICER_CD_WAITTIME;
      }
      if (vo_214e == 37 && vo_2150 == 1 && vo_2154 == 1 && vo_2156 == 1 && vo_2159 == 1 && Xxxcdda.Soundlink_cd_track!= 15)
      {
         Xxxcdda.Soundlink_cd_track=15;
	  cdda_stop();
         Voicer_CdPlayWaitSet=1;
         Voicer_CdPlayWaitTime=VOICER_CD_WAITTIME;
      }

// 7͉p
      if (vo_214e == 38 && vo_2150 == 0 && vo_2154 == 1 && vo_2156 == 1 && vo_2159 == 1 && Xxxcdda.Soundlink_cd_track!= 20)
      {
         Xxxcdda.Soundlink_cd_track=20;
         Voicer_CdPlayWaitFlag = 0;
	  cdda_stop();
         cdda_play();
      }
      if (vo_214e == 39 && vo_2150 == 0 && vo_2154 == 1 && vo_2156 == 1 && vo_2159 == 1 && Xxxcdda.Soundlink_cd_track!= 21)
      {
         Xxxcdda.Soundlink_cd_track=21;
	  cdda_stop();
         Voicer_CdPlayWaitSet=1;
         Voicer_CdPlayWaitTime=VOICER_CD_WAITTIME;
      }
      if (vo_214e == 40 && vo_2150 == 0 && vo_2154 == 1 && vo_2156 == 1 && vo_2159 == 1 && Xxxcdda.Soundlink_cd_track!= 22)
      {
         Xxxcdda.Soundlink_cd_track=22;
	  cdda_stop();
         Voicer_CdPlayWaitSet=1;
         Voicer_CdPlayWaitTime=VOICER_CD_WAITTIME;
      }
      if (vo_214e == 41 && vo_2150 == 0 && vo_2154 == 1 && vo_2156 == 1 && vo_2159 == 1 && Xxxcdda.Soundlink_cd_track!= 23)
      {
         Xxxcdda.Soundlink_cd_track=23;
	  cdda_stop();
         Voicer_CdPlayWaitSet=1;
         Voicer_CdPlayWaitTime=VOICER_CD_WAITTIME;
      }
      if (vo_214e == 42 && vo_2150 == 0 && vo_2154 == 1 && vo_2156 == 1 && vo_2159 == 1 && Xxxcdda.Soundlink_cd_track!= 24)
      {
         Xxxcdda.Soundlink_cd_track=24;
	  cdda_stop();
         Voicer_CdPlayWaitSet=1;
         Voicer_CdPlayWaitTime=VOICER_CD_WAITTIME;
      }
      if (vo_214e == 43 && vo_2150 == 0 && vo_2154 == 1 && vo_2156 == 1 && vo_2159 == 1 && Xxxcdda.Soundlink_cd_track!= 25)
      {
         Xxxcdda.Soundlink_cd_track=25;
	  cdda_stop();
         Voicer_CdPlayWaitSet=1;
         Voicer_CdPlayWaitTime=VOICER_CD_WAITTIME;
      }
      if (vo_214e == 44 && vo_2150 == 0 && vo_2154 == 1 && vo_2156 == 1 && vo_2159 == 1 && Xxxcdda.Soundlink_cd_track!= 26)
      {
         Xxxcdda.Soundlink_cd_track=26;
	  cdda_stop();
         Voicer_CdPlayWaitSet=1;
         Voicer_CdPlayWaitTime=VOICER_CD_WAITTIME;
      }

// 7͓{
      if (vo_214e == 38 && vo_2150 == 1 && vo_2154 == 1 && vo_2156 == 1 && vo_2159 == 1 && Xxxcdda.Soundlink_cd_track!= 27)
      {
         Xxxcdda.Soundlink_cd_track=27;
         Voicer_CdPlayWaitFlag = 0;
	  cdda_stop();
         cdda_play();
      }
      if (vo_214e == 39 && vo_2150 == 1 && vo_2154 == 1 && vo_2156 == 1 && vo_2159 == 1 && Xxxcdda.Soundlink_cd_track!= 28)
      {
         Xxxcdda.Soundlink_cd_track=28;
	  cdda_stop();
         Voicer_CdPlayWaitSet=1;
         Voicer_CdPlayWaitTime=VOICER_CD_WAITTIME;
      }
      if (vo_214e == 40 && vo_2150 == 1 && vo_2154 == 1 && vo_2156 == 1 && vo_2159 == 1 && Xxxcdda.Soundlink_cd_track!= 29)
      {
         Xxxcdda.Soundlink_cd_track=29;
	  cdda_stop();
         Voicer_CdPlayWaitSet=1;
         Voicer_CdPlayWaitTime=VOICER_CD_WAITTIME;
      }
      if (vo_214e == 41 && vo_2150 == 1 && vo_2154 == 1 && vo_2156 == 1 && vo_2159 == 1 && Xxxcdda.Soundlink_cd_track!= 30)
      {
         Xxxcdda.Soundlink_cd_track=30;
	  cdda_stop();
         Voicer_CdPlayWaitSet=1;
         Voicer_CdPlayWaitTime=VOICER_CD_WAITTIME;
      }
      if (vo_214e == 42 && vo_2150 == 1 && vo_2154 == 1 && vo_2156 == 1 && vo_2159 == 1 && Xxxcdda.Soundlink_cd_track!= 31)
      {
         Xxxcdda.Soundlink_cd_track=31;
	  cdda_stop();
         Voicer_CdPlayWaitSet=1;
         Voicer_CdPlayWaitTime=VOICER_CD_WAITTIME;
      }
      if (vo_214e == 43 && vo_2150 == 1 && vo_2154 == 1 && vo_2156 == 1 && vo_2159 == 1 && Xxxcdda.Soundlink_cd_track!= 32)
      {
         Xxxcdda.Soundlink_cd_track=32;
	  cdda_stop();
         Voicer_CdPlayWaitSet=1;
         Voicer_CdPlayWaitTime=VOICER_CD_WAITTIME;
      }
      if (vo_214e == 44 && vo_2150 == 1 && vo_2154 == 1 && vo_2156 == 1 && vo_2159 == 1 && Xxxcdda.Soundlink_cd_track!= 33)
      {
         Xxxcdda.Soundlink_cd_track=33;
	  cdda_stop();
         Voicer_CdPlayWaitSet=1;
         Voicer_CdPlayWaitTime=VOICER_CD_WAITTIME;
      }

// 8͉p
      if (vo_214e == 45 && vo_2150 == 0 && vo_2154 == 1 && vo_2156 == 1 && vo_2159 == 1 && Xxxcdda.Soundlink_cd_track!= 37)
      {
         Xxxcdda.Soundlink_cd_track=37;
         Voicer_CdPlayWaitFlag = 0;
	  cdda_stop();
         cdda_play();
      }
      if (vo_214e == 46 && vo_2150 == 0 && vo_2154 == 1 && vo_2156 == 1 && vo_2159 == 1 && Xxxcdda.Soundlink_cd_track!= 38)
      {
         Xxxcdda.Soundlink_cd_track=38;
	  cdda_stop();
         Voicer_CdPlayWaitSet=1;
         Voicer_CdPlayWaitTime=VOICER_CD_WAITTIME;
      }
      if (vo_214e == 47 && vo_2150 == 0 && vo_2154 == 1 && vo_2156 == 1 && vo_2159 == 1 && Xxxcdda.Soundlink_cd_track!= 39)
      {
         Xxxcdda.Soundlink_cd_track=39;
	  cdda_stop();
         Voicer_CdPlayWaitSet=1;
         Voicer_CdPlayWaitTime=VOICER_CD_WAITTIME;
      }
      if (vo_214e == 48 && vo_2150 == 0 && vo_2154 == 1 && vo_2156 == 1 && vo_2159 == 1 && Xxxcdda.Soundlink_cd_track!= 40)
      {
         Xxxcdda.Soundlink_cd_track=40;
	  cdda_stop();
         Voicer_CdPlayWaitSet=1;
         Voicer_CdPlayWaitTime=VOICER_CD_WAITTIME;
      }
      if (vo_214e == 49 && vo_2150 == 0 && vo_2154 == 1 && vo_2156 == 1 && vo_2159 == 1 && Xxxcdda.Soundlink_cd_track!= 41)
      {
         Xxxcdda.Soundlink_cd_track=41;
	  cdda_stop();
         Voicer_CdPlayWaitSet=1;
         Voicer_CdPlayWaitTime=VOICER_CD_WAITTIME;
      }

// 8͓{
      if (vo_214e == 45 && vo_2150 == 1 && vo_2154 == 1 && vo_2156 == 1 && vo_2159 == 1 && Xxxcdda.Soundlink_cd_track!= 42)
      {
         Xxxcdda.Soundlink_cd_track=42;
         Voicer_CdPlayWaitFlag = 0;
	  cdda_stop();
         cdda_play();
      }
      if (vo_214e == 46 && vo_2150 == 1 && vo_2154 == 1 && vo_2156 == 1 && vo_2159 == 1 && Xxxcdda.Soundlink_cd_track!= 43)
      {
         Xxxcdda.Soundlink_cd_track=43;
	  cdda_stop();
         Voicer_CdPlayWaitSet=1;
         Voicer_CdPlayWaitTime=VOICER_CD_WAITTIME;
      }
      if (vo_214e == 47 && vo_2150 == 1 && vo_2154 == 1 && vo_2156 == 1 && vo_2159 == 1 && Xxxcdda.Soundlink_cd_track!= 44)
      {
         Xxxcdda.Soundlink_cd_track=44;
	  cdda_stop();
         Voicer_CdPlayWaitSet=1;
         Voicer_CdPlayWaitTime=VOICER_CD_WAITTIME;
      }
      if (vo_214e == 48 && vo_2150 == 1 && vo_2154 == 1 && vo_2156 == 1 && vo_2159 == 1 && Xxxcdda.Soundlink_cd_track!= 45)
      {
         Xxxcdda.Soundlink_cd_track=45;
	  cdda_stop();
         Voicer_CdPlayWaitSet=1;
         Voicer_CdPlayWaitTime=VOICER_CD_WAITTIME;
      }
      if (vo_214e == 49 && vo_2150 == 1 && vo_2154 == 1 && vo_2156 == 1 && vo_2159 == 1 && Xxxcdda.Soundlink_cd_track!= 46)
      {
         Xxxcdda.Soundlink_cd_track=46;
	  cdda_stop();
         Voicer_CdPlayWaitSet=1;
         Voicer_CdPlayWaitTime=VOICER_CD_WAITTIME;
      }

// 9͉p
      if (vo_214e == 50 && vo_2150 == 0 && vo_2154 == 1 && vo_2156 == 1 && vo_2159 == 1 && Xxxcdda.Soundlink_cd_track!= 50)
      {
         Xxxcdda.Soundlink_cd_track=50;
         Voicer_CdPlayWaitFlag = 0;
	  cdda_stop();
         cdda_play();
      }
      if (vo_214e == 51 && vo_2150 == 0 && vo_2154 == 1 && vo_2156 == 1 && vo_2159 == 1 && Xxxcdda.Soundlink_cd_track!= 51)
      {
         Xxxcdda.Soundlink_cd_track=51;
	  cdda_stop();
         Voicer_CdPlayWaitSet=1;
         Voicer_CdPlayWaitTime=VOICER_CD_WAITTIME;
      }

// 9͓{
      if (vo_214e == 50 && vo_2150 == 1 && vo_2154 == 1 && vo_2156 == 1 && vo_2159 == 1 && Xxxcdda.Soundlink_cd_track!= 52)
      {
         Xxxcdda.Soundlink_cd_track=52;
         Voicer_CdPlayWaitFlag = 0;
	  cdda_stop();
         cdda_play();
      }
      if (vo_214e == 51 && vo_2150 == 1 && vo_2154 == 1 && vo_2156 == 1 && vo_2159 == 1 && Xxxcdda.Soundlink_cd_track!= 53)
      {
         Xxxcdda.Soundlink_cd_track=53;
	  cdda_stop();
         Voicer_CdPlayWaitSet=1;
         Voicer_CdPlayWaitTime=VOICER_CD_WAITTIME;
      }

// 10͉p
      if (vo_214e == 52 && vo_2150 == 0 && vo_2154 == 1 && vo_2156 == 1 && vo_2159 == 1 && Xxxcdda.Soundlink_cd_track!= 54)
      {
         Xxxcdda.Soundlink_cd_track=54;
         Voicer_CdPlayWaitFlag = 0;
	  cdda_stop();
         cdda_play();
      }
      if (vo_214e == 53 && vo_2150 == 0 && vo_2154 == 1 && vo_2156 == 1 && vo_2159 == 1 && Xxxcdda.Soundlink_cd_track!= 55)
      {
         Xxxcdda.Soundlink_cd_track=55;
	  cdda_stop();
         Voicer_CdPlayWaitSet=1;
         Voicer_CdPlayWaitTime=VOICER_CD_WAITTIME;
      }
      if (vo_214e == 54 && vo_2150 == 0 && vo_2154 == 1 && vo_2156 == 1 && vo_2159 == 1 && Xxxcdda.Soundlink_cd_track!= 56)
      {
         Xxxcdda.Soundlink_cd_track=56;
	  cdda_stop();
         Voicer_CdPlayWaitSet=1;
         Voicer_CdPlayWaitTime=VOICER_CD_WAITTIME;
      }
      if (vo_214e == 55 && vo_2150 == 0 && vo_2154 == 1 && vo_2156 == 1 && vo_2159 == 1 && Xxxcdda.Soundlink_cd_track!= 57)
      {
         Xxxcdda.Soundlink_cd_track=57;
	  cdda_stop();
         Voicer_CdPlayWaitSet=1;
         Voicer_CdPlayWaitTime=VOICER_CD_WAITTIME;
      }
      if (vo_214e == 56 && vo_2150 == 0 && vo_2154 == 1 && vo_2156 == 1 && vo_2159 == 1 && Xxxcdda.Soundlink_cd_track!= 58)
      {
         Xxxcdda.Soundlink_cd_track=58;
	  cdda_stop();
         Voicer_CdPlayWaitSet=1;
         Voicer_CdPlayWaitTime=VOICER_CD_WAITTIME;
      }

// 10͓{
      if (vo_214e == 52 && vo_2150 == 1 && vo_2154 == 1 && vo_2156 == 1 && vo_2159 == 1 && Xxxcdda.Soundlink_cd_track!= 59)
      {
         Xxxcdda.Soundlink_cd_track=59;
         Voicer_CdPlayWaitFlag = 0;
	  cdda_stop();
         cdda_play();
      }
      if (vo_214e == 53 && vo_2150 == 1 && vo_2154 == 1 && vo_2156 == 1 && vo_2159 == 1 && Xxxcdda.Soundlink_cd_track!= 60)
      {
         Xxxcdda.Soundlink_cd_track=60;
	  cdda_stop();
         Voicer_CdPlayWaitSet=1;
         Voicer_CdPlayWaitTime=VOICER_CD_WAITTIME;
      }
      if (vo_214e == 54 && vo_2150 == 1 && vo_2154 == 1 && vo_2156 == 1 && vo_2159 == 1 && Xxxcdda.Soundlink_cd_track!= 61)
      {
         Xxxcdda.Soundlink_cd_track=61;
	  cdda_stop();
         Voicer_CdPlayWaitSet=1;
         Voicer_CdPlayWaitTime=VOICER_CD_WAITTIME;
      }
      if (vo_214e == 55 && vo_2150 == 1 && vo_2154 == 1 && vo_2156 == 1 && vo_2159 == 1 && Xxxcdda.Soundlink_cd_track!= 62)
      {
         Xxxcdda.Soundlink_cd_track=62;
	  cdda_stop();
         Voicer_CdPlayWaitSet=1;
         Voicer_CdPlayWaitTime=VOICER_CD_WAITTIME;
      }
      if (vo_214e == 56 && vo_2150 == 1 && vo_2154 == 1 && vo_2156 == 1 && vo_2159 == 1 && Xxxcdda.Soundlink_cd_track!= 63)
      {
         Xxxcdda.Soundlink_cd_track=63;
	  cdda_stop();
         Voicer_CdPlayWaitSet=1;
         Voicer_CdPlayWaitTime=VOICER_CD_WAITTIME;
      }

// 11͉p
      if (vo_214e == 57 && vo_2150 == 0 && vo_2154 == 1 && vo_2156 == 1 && vo_2159 == 1 && Xxxcdda.Soundlink_cd_track!= 67)
      {
         Xxxcdda.Soundlink_cd_track=67;
         Voicer_CdPlayWaitFlag = 0;
	  cdda_stop();
         cdda_play();
      }
      if (vo_214e == 58 && vo_2150 == 0 && vo_2154 == 1 && vo_2156 == 1 && vo_2159 == 1 && Xxxcdda.Soundlink_cd_track!= 68)
      {
         Xxxcdda.Soundlink_cd_track=68;
	  cdda_stop();
         Voicer_CdPlayWaitSet=1;
         Voicer_CdPlayWaitTime=VOICER_CD_WAITTIME;
      }
      if (vo_214e == 59 && vo_2150 == 0 && vo_2154 == 1 && vo_2156 == 1 && vo_2159 == 1 && Xxxcdda.Soundlink_cd_track!= 69)
      {
         Xxxcdda.Soundlink_cd_track=69;
	  cdda_stop();
         Voicer_CdPlayWaitSet=1;
         Voicer_CdPlayWaitTime=VOICER_CD_WAITTIME;
      }

// 11͓{
      if (vo_214e == 57 && vo_2150 == 1 && vo_2154 == 1 && vo_2156 == 1 && vo_2159 == 1 && Xxxcdda.Soundlink_cd_track!= 70)
      {
         Xxxcdda.Soundlink_cd_track=70;
         Voicer_CdPlayWaitFlag = 0;
	  cdda_stop();
         cdda_play();
      }
      if (vo_214e == 58 && vo_2150 == 1 && vo_2154 == 1 && vo_2156 == 1 && vo_2159 == 1 && Xxxcdda.Soundlink_cd_track!= 71)
      {
         Xxxcdda.Soundlink_cd_track=71;
	  cdda_stop();
         Voicer_CdPlayWaitSet=1;
         Voicer_CdPlayWaitTime=VOICER_CD_WAITTIME;
      }
      if (vo_214e == 59 && vo_2150 == 1 && vo_2154 == 1 && vo_2156 == 1 && vo_2159 == 1 && Xxxcdda.Soundlink_cd_track!= 72)
      {
         Xxxcdda.Soundlink_cd_track=72;
	  cdda_stop();
         Voicer_CdPlayWaitSet=1;
         Voicer_CdPlayWaitTime=VOICER_CD_WAITTIME;
      }

// 12͉p
      if (vo_214e == 60 && vo_2150 == 0 && vo_2154 == 1 && vo_2156 == 1 && vo_2159 == 1 && Xxxcdda.Soundlink_cd_track!= 73)
      {
         Xxxcdda.Soundlink_cd_track=73;
         Voicer_CdPlayWaitFlag = 0;
	  cdda_stop();
         cdda_play();
      }
      if (vo_214e == 61 && vo_2150 == 0 && vo_2154 == 1 && vo_2156 == 1 && vo_2159 == 1 && Xxxcdda.Soundlink_cd_track!= 74)
      {
         Xxxcdda.Soundlink_cd_track=74;
	  cdda_stop();
         Voicer_CdPlayWaitSet=1;
         Voicer_CdPlayWaitTime=VOICER_CD_WAITTIME;
      }
      if (vo_214e == 62 && vo_2150 == 0 && vo_2154 == 1 && vo_2156 == 1 && vo_2159 == 1 && Xxxcdda.Soundlink_cd_track!= 75)
      {
         Xxxcdda.Soundlink_cd_track=75;
	  cdda_stop();
         Voicer_CdPlayWaitSet=1;
         Voicer_CdPlayWaitTime=VOICER_CD_WAITTIME;
      }
      if (vo_214e == 63 && vo_2150 == 0 && vo_2154 == 1 && vo_2156 == 1 && vo_2159 == 1 && Xxxcdda.Soundlink_cd_track!= 76)
      {
         Xxxcdda.Soundlink_cd_track=76;
	  cdda_stop();
         Voicer_CdPlayWaitSet=1;
         Voicer_CdPlayWaitTime=VOICER_CD_WAITTIME;
      }

// 12͓{
      if (vo_214e == 60 && vo_2150 == 1 && vo_2154 == 1 && vo_2156 == 1 && vo_2159 == 1 && Xxxcdda.Soundlink_cd_track!= 77)
      {
         Xxxcdda.Soundlink_cd_track=77;
         Voicer_CdPlayWaitFlag = 0;
	  cdda_stop();
         cdda_play();
      }
      if (vo_214e == 61 && vo_2150 == 1 && vo_2154 == 1 && vo_2156 == 1 && vo_2159 == 1 && Xxxcdda.Soundlink_cd_track!= 78)
      {
         Xxxcdda.Soundlink_cd_track=78;
	  cdda_stop();
         Voicer_CdPlayWaitSet=1;
         Voicer_CdPlayWaitTime=VOICER_CD_WAITTIME;
      }
      if (vo_214e == 62 && vo_2150 == 1 && vo_2154 == 1 && vo_2156 == 1 && vo_2159 == 1 && Xxxcdda.Soundlink_cd_track!= 79)
      {
         Xxxcdda.Soundlink_cd_track=79;
	  cdda_stop();
         Voicer_CdPlayWaitSet=1;
         Voicer_CdPlayWaitTime=VOICER_CD_WAITTIME;
      }
      if (vo_214e == 63 && vo_2150 == 1 && vo_2154 == 1 && vo_2156 == 1 && vo_2159 == 1 && Xxxcdda.Soundlink_cd_track!= 80)
      {
         Xxxcdda.Soundlink_cd_track=80;
	  cdda_stop();
         Voicer_CdPlayWaitSet=1;
         Voicer_CdPlayWaitTime=VOICER_CD_WAITTIME;
      }

// 13͉p
      if (vo_214e == 64 && vo_2150 == 0 && vo_2154 == 1 && vo_2156 == 1 && vo_2159 == 1 && Xxxcdda.Soundlink_cd_track!= 84)
      {
         Xxxcdda.Soundlink_cd_track=84;
         Voicer_CdPlayWaitFlag = 0;
	  cdda_stop();
         cdda_play();
      }
      if (vo_214e == 65 && vo_2150 == 0 && vo_2154 == 1 && vo_2156 == 1 && vo_2159 == 1 && Xxxcdda.Soundlink_cd_track!= 85)
      {
         Xxxcdda.Soundlink_cd_track=85;
	  cdda_stop();
         Voicer_CdPlayWaitSet=1;
         Voicer_CdPlayWaitTime=VOICER_CD_WAITTIME;
      }
      if (vo_214e == 66 && vo_2150 == 0 && vo_2154 == 1 && vo_2156 == 1 && vo_2159 == 1 && Xxxcdda.Soundlink_cd_track!= 86)
      {
         Xxxcdda.Soundlink_cd_track=86;
	  cdda_stop();
         Voicer_CdPlayWaitSet=1;
         Voicer_CdPlayWaitTime=VOICER_CD_WAITTIME;
      }
      if (vo_214e == 67 && vo_2150 == 0 && vo_2154 == 1 && vo_2156 == 1 && vo_2159 == 1 && Xxxcdda.Soundlink_cd_track!= 87)
      {
         Xxxcdda.Soundlink_cd_track=87;
	  cdda_stop();
         Voicer_CdPlayWaitSet=1;
         Voicer_CdPlayWaitTime=VOICER_CD_WAITTIME;
      }
      if (vo_214e == 68 && vo_2150 == 0 && vo_2154 == 1 && vo_2156 == 1 && vo_2159 == 1 && Xxxcdda.Soundlink_cd_track!= 88)
      {
         Xxxcdda.Soundlink_cd_track=88;
	  cdda_stop();
         Voicer_CdPlayWaitSet=1;
         Voicer_CdPlayWaitTime=VOICER_CD_WAITTIME;
      }

// 13͓{
      if (vo_214e == 64 && vo_2150 == 1 && vo_2154 == 1 && vo_2156 == 1 && vo_2159 == 1 && Xxxcdda.Soundlink_cd_track!= 89)
      {
         Xxxcdda.Soundlink_cd_track=89;
         Voicer_CdPlayWaitFlag = 0;
	  cdda_stop();
         cdda_play();
      }
      if (vo_214e == 65 && vo_2150 == 1 && vo_2154 == 1 && vo_2156 == 1 && vo_2159 == 1 && Xxxcdda.Soundlink_cd_track!= 90)
      {
         Xxxcdda.Soundlink_cd_track=90;
	  cdda_stop();
         Voicer_CdPlayWaitSet=1;
         Voicer_CdPlayWaitTime=VOICER_CD_WAITTIME;
      }
      if (vo_214e == 66 && vo_2150 == 1 && vo_2154 == 1 && vo_2156 == 1 && vo_2159 == 1 && Xxxcdda.Soundlink_cd_track!= 91)
      {
         Xxxcdda.Soundlink_cd_track=91;
	  cdda_stop();
         Voicer_CdPlayWaitSet=1;
         Voicer_CdPlayWaitTime=VOICER_CD_WAITTIME;
      }
      if (vo_214e == 67 && vo_2150 == 1 && vo_2154 == 1 && vo_2156 == 1 && vo_2159 == 1 && Xxxcdda.Soundlink_cd_track!= 92)
      {
         Xxxcdda.Soundlink_cd_track=92;
	  cdda_stop();
         Voicer_CdPlayWaitSet=1;
         Voicer_CdPlayWaitTime=VOICER_CD_WAITTIME;
      }
      if (vo_214e == 68 && vo_2150 == 1 && vo_2154 == 1 && vo_2156 == 1 && vo_2159 == 1 && Xxxcdda.Soundlink_cd_track!= 93)
      {
         Xxxcdda.Soundlink_cd_track=93;
	  cdda_stop();
         Voicer_CdPlayWaitSet=1;
         Voicer_CdPlayWaitTime=VOICER_CD_WAITTIME;
      }

}

/*********************************************************************************************/
/* Emit3_Mondai                                                                               */
/*********************************************************************************************/

void Emit3_Mondai ()
{
      //0x214e Đԍ 
      //0x214f  K肩fꏊ 0x3ƗK
      //0x2150 0 p 1{ 
      //0x2154 0̑ 1bp[g
      //0x2156 0fBXNP 1fBXN2
      //0x2157 K
      //0x2159 1Đ 2|[Y 

      int vo_214e,vo_214f,vo_2150,vo_2154,vo_2156,vo_2157,vo_2159;
          vo_214e = Memory.RAM [0x214e];
          vo_214f = Memory.RAM [0x214f];
          vo_2150 = Memory.RAM [0x2150];
          vo_2154 = Memory.RAM [0x2154];
          vo_2156 = Memory.RAM [0x2156];
          vo_2157 = Memory.RAM [0x2157];
          vo_2159 = Memory.RAM [0x2159];

// 1 K
      if (vo_2157 == 0x15 && vo_2156 == 0 && vo_2159 == 1 && Xxxcdda.Soundlink_cd_track!= 22)
      {
         Xxxcdda.Soundlink_cd_track=22;
	  cdda_stop();
         cdda_play();
      }
      if (vo_2157 == 0x16 && vo_2156 == 0 && vo_2159 == 1 && Xxxcdda.Soundlink_cd_track!= 23)
      {
         Xxxcdda.Soundlink_cd_track=23;
	  cdda_stop();
         cdda_play();
      }
      if (vo_2157 == 0x17 && vo_2156 == 0 && vo_2159 == 1 && Xxxcdda.Soundlink_cd_track!= 24)
      {
         Xxxcdda.Soundlink_cd_track=24;
	  cdda_stop();
         cdda_play();
      }

// 2 K
      if (vo_2157 == 0x28 && vo_2156 == 0 && vo_2159 == 1 && Xxxcdda.Soundlink_cd_track!= 41)
      {
         Xxxcdda.Soundlink_cd_track=41;
	  cdda_stop();
         cdda_play();
      }
      if (vo_2157 == 0x29 && vo_2156 == 0 && vo_2159 == 1 && Xxxcdda.Soundlink_cd_track!= 42)
      {
         Xxxcdda.Soundlink_cd_track=42;
	  cdda_stop();
         cdda_play();
      }
      if (vo_2157 == 0x2a && vo_2156 == 0 && vo_2159 == 1 && Xxxcdda.Soundlink_cd_track!= 43)
      {
         Xxxcdda.Soundlink_cd_track=43;
	  cdda_stop();
         cdda_play();
      }
      if (vo_2157 == 0x2b && vo_2156 == 0 && vo_2159 == 1 && Xxxcdda.Soundlink_cd_track!= 44)
      {
         Xxxcdda.Soundlink_cd_track=44;
	  cdda_stop();
         cdda_play();
      }
      if (vo_2157 == 0x2c && vo_2156 == 0 && vo_2159 == 1 && Xxxcdda.Soundlink_cd_track!= 45)
      {
         Xxxcdda.Soundlink_cd_track=45;
	  cdda_stop();
         cdda_play();
      }
      if (vo_2157 == 0x2d && vo_2156 == 0 && vo_2159 == 1 && Xxxcdda.Soundlink_cd_track!= 46)
      {
         Xxxcdda.Soundlink_cd_track=46;
	  cdda_stop();
         cdda_play();
      }
      if (vo_2157 == 0x2e && vo_2156 == 0 && vo_2159 == 1 && Xxxcdda.Soundlink_cd_track!= 47)
      {
         Xxxcdda.Soundlink_cd_track=47;
	  cdda_stop();
         cdda_play();
      }
      if (vo_2157 == 0x2f && vo_2156 == 0 && vo_2159 == 1 && Xxxcdda.Soundlink_cd_track!= 48)
      {
         Xxxcdda.Soundlink_cd_track=48;
	  cdda_stop();
         cdda_play();
      }
      if (vo_2157 == 0x30 && vo_2156 == 0 && vo_2159 == 1 && Xxxcdda.Soundlink_cd_track!= 49)
      {
         Xxxcdda.Soundlink_cd_track=49;
	  cdda_stop();
         cdda_play();
      }
      if (vo_2157 == 0x31 && vo_2156 == 0 && vo_2159 == 1 && Xxxcdda.Soundlink_cd_track!= 50)
      {
         Xxxcdda.Soundlink_cd_track=50;
	  cdda_stop();
         cdda_play();
      }

// 3 K
      if (vo_2157 == 0x44 && vo_2156 == 0 && vo_2159 == 1 && Xxxcdda.Soundlink_cd_track!= 69)
      {
         Xxxcdda.Soundlink_cd_track=69;
	  cdda_stop();
         cdda_play();
      }
      if (vo_2157 == 0x45 && vo_2156 == 0 && vo_2159 == 1 && Xxxcdda.Soundlink_cd_track!= 70)
      {
         Xxxcdda.Soundlink_cd_track=70;
	  cdda_stop();
         cdda_play();
      }

// 4 K
      if (vo_2157 == 0x4c && vo_2156 == 0 && vo_2159 == 1 && Xxxcdda.Soundlink_cd_track!= 77)
      {
         Xxxcdda.Soundlink_cd_track=77;
	  cdda_stop();
         cdda_play();
      }

// 5 K
      if (vo_2157 == 0x53 && vo_2156 == 0 && vo_2159 == 1 && Xxxcdda.Soundlink_cd_track!= 84)
      {
         Xxxcdda.Soundlink_cd_track=84;
	  cdda_stop();
         cdda_play();
      }
      if (vo_2157 == 0x54 && vo_2156 == 0 && vo_2159 == 1 && Xxxcdda.Soundlink_cd_track!= 85)
      {
         Xxxcdda.Soundlink_cd_track=85;
	  cdda_stop();
         cdda_play();
      }

// 6 K
      if (vo_2157 == 0xf && vo_2156 == 1 && vo_2159 == 1 && Xxxcdda.Soundlink_cd_track!= 16)
      {
         Xxxcdda.Soundlink_cd_track=16;
	  cdda_stop();
         cdda_play();
      }
      if (vo_2157 == 0x10 && vo_2156 == 1 && vo_2159 == 1 && Xxxcdda.Soundlink_cd_track!= 17)
      {
         Xxxcdda.Soundlink_cd_track=17;
	  cdda_stop();
         cdda_play();
      }
      if (vo_2157 == 0x11 && vo_2156 == 1 && vo_2159 == 1 && Xxxcdda.Soundlink_cd_track!= 18)
      {
         Xxxcdda.Soundlink_cd_track=18;
	  cdda_stop();
         cdda_play();
      }
      if (vo_2157 == 0x12 && vo_2156 == 1 && vo_2159 == 1 && Xxxcdda.Soundlink_cd_track!= 19)
      {
         Xxxcdda.Soundlink_cd_track=19;
	  cdda_stop();
         cdda_play();
      }

// 7 K
      if (vo_2157 == 0x21 && vo_2156 == 1 && vo_2159 == 1 && Xxxcdda.Soundlink_cd_track!= 34)
      {
         Xxxcdda.Soundlink_cd_track=34;
	  cdda_stop();
         cdda_play();
      }
      if (vo_2157 == 0x22 && vo_2156 == 1 && vo_2159 == 1 && Xxxcdda.Soundlink_cd_track!= 35)
      {
         Xxxcdda.Soundlink_cd_track=35;
	  cdda_stop();
         cdda_play();
      }
      if (vo_2157 == 0x23 && vo_2156 == 1 && vo_2159 == 1 && Xxxcdda.Soundlink_cd_track!= 36)
      {
         Xxxcdda.Soundlink_cd_track=36;
	  cdda_stop();
         cdda_play();
      }

// 8 K
      if (vo_2157 == 0x2e && vo_2156 == 1 && vo_2159 == 1 && Xxxcdda.Soundlink_cd_track!= 47)
      {
         Xxxcdda.Soundlink_cd_track=47;
	  cdda_stop();
         cdda_play();
      }
      if (vo_2157 == 0x2f && vo_2156 == 1 && vo_2159 == 1 && Xxxcdda.Soundlink_cd_track!= 48)
      {
         Xxxcdda.Soundlink_cd_track=48;
	  cdda_stop();
         cdda_play();
      }
      if (vo_2157 == 0x30 && vo_2156 == 1 && vo_2159 == 1 && Xxxcdda.Soundlink_cd_track!= 49)
      {
         Xxxcdda.Soundlink_cd_track=49;
	  cdda_stop();
         cdda_play();
      }

// 10 K
      if (vo_2157 == 0x3f && vo_2156 == 1 && vo_2159 == 1 && Xxxcdda.Soundlink_cd_track!= 64)
      {
         Xxxcdda.Soundlink_cd_track=64;
	  cdda_stop();
         cdda_play();
      }
      if (vo_2157 == 0x40 && vo_2156 == 1 && vo_2159 == 1 && Xxxcdda.Soundlink_cd_track!= 65)
      {
         Xxxcdda.Soundlink_cd_track=65;
	  cdda_stop();
         cdda_play();
      }
      if (vo_2157 == 0x41 && vo_2156 == 1 && vo_2159 == 1 && Xxxcdda.Soundlink_cd_track!= 66)
      {
         Xxxcdda.Soundlink_cd_track=66;
	  cdda_stop();
         cdda_play();
      }

// 12 K
      if (vo_2157 == 0x50 && vo_2156 == 1 && vo_2159 == 1 && Xxxcdda.Soundlink_cd_track!= 81)
      {
         Xxxcdda.Soundlink_cd_track=81;
	  cdda_stop();
         cdda_play();
      }
      if (vo_2157 == 0x51 && vo_2156 == 1 && vo_2159 == 1 && Xxxcdda.Soundlink_cd_track!= 82)
      {
         Xxxcdda.Soundlink_cd_track=82;
	  cdda_stop();
         cdda_play();
      }
      if (vo_2157 == 0x52 && vo_2156 == 1 && vo_2159 == 1 && Xxxcdda.Soundlink_cd_track!= 83)
      {
         Xxxcdda.Soundlink_cd_track=83;
	  cdda_stop();
         cdda_play();
      }

// 13 K
      if (vo_2157 == 0x5d && vo_2156 == 1 && vo_2159 == 1 && Xxxcdda.Soundlink_cd_track!= 94)
      {
         Xxxcdda.Soundlink_cd_track=94;
	  cdda_stop();
         cdda_play();
      }

}
