#include "snes9x.h"
#include "apu.h"
#include "soundux.h"
#include "snesapu.h"
#include "uosnesw.h"
#include "winsound.h"
#include "uowsound.h"

static BOOL sound_exit = TRUE;
static BOOL sound_exit_success = TRUE;
static uint8 *SoundSyncBuffer0 = NULL;
static uint8 *SoundSyncBuffer = NULL;
static HANDLE hSoundEvent0 = FALSE;
static volatile HANDLE hSoundEvent1 = FALSE;
static volatile HANDLE hSoundEvent2 = FALSE;

static bool8 hCriticalSection = FALSE;
static CRITICAL_SECTION ssycs;

static volatile bool8 block_signal = FALSE;
static volatile bool8 pending_signal = FALSE;

static inline void ReadSoundSyncBuffer(uint8 *buffer,
									   int *sample_count,
									   int *byte_offset)
{
	if(SoundSyncBuffer0 == NULL || so.samples_mixed_so_far <= 0) {
		so.err_counter = 0;
		so.t64Cnt = EXT.t64Cnt;
		return;
	}

	int _max_count = so.buffer_size >> (so.sixteen_bit ? 1 : 0);

	//SoundSyncBuffer - SoundSyncBuffer0
	int _byte_offset = (int)(SoundSyncBuffer - SoundSyncBuffer0);
	int _sample_count = *sample_count <= so.samples_mixed_so_far ? *sample_count : so.samples_mixed_so_far;
	int _sample_count0 = (_max_count - (_byte_offset >> (so.sixteen_bit ? 1 : 0)));
	int _sample_byte_count = _sample_count << (so.sixteen_bit ? 1 : 0);

	if(_sample_count <= _sample_count0) {
		memcpy(buffer + *byte_offset,
			   SoundSyncBuffer,
			   (size_t) _sample_byte_count);
	}
	else {
		int _sample_byte_count0 = so.buffer_size - _byte_offset;
		memcpy(buffer + *byte_offset,
			   SoundSyncBuffer,
			   (size_t) _sample_byte_count0);
		memcpy(buffer + *byte_offset + _sample_byte_count0,
			   SoundSyncBuffer0,
			   (size_t) (_sample_byte_count - _sample_byte_count0));
	}

	SoundSyncBuffer = SoundSyncBuffer0 +
		((_byte_offset + _sample_byte_count) % so.buffer_size);

	so.samples_mixed_so_far -= _sample_count;

	*sample_count -= _sample_count;
	*byte_offset += _sample_byte_count;

	so.err_counter = 0;
	so.t64Cnt = EXT.t64Cnt;
	return;
}

static void SNESSoundCallback(void *buff, int len)
{
	if(sound_exit) {
		if(sound_exit_success == FALSE) {
			sound_exit_success = TRUE;
			SetEvent(hSoundEvent2);
		}
		return;
	}
	else {
		if(sound_exit_success == TRUE) {
			sound_exit_success = FALSE;
			SetEvent(hSoundEvent2);
		}
	}

	if(Settings.SoundSync) {
		EnterCriticalSection(&ssycs);
		int sample_count = len >> (so.sixteen_bit ? 1 : 0);
		int byte_offset = 0;

		ReadSoundSyncBuffer((uint8 *)buff, &sample_count, &byte_offset);
		if(sample_count == 0) {
			LeaveCriticalSection(&ssycs);
			return;
		}
		S9xMixSamplesO((uint8 *)buff, sample_count, byte_offset);
		LeaveCriticalSection(&ssycs);
	}
	else
		S9xMixSamplesO((uint8 *)buff, len >> (so.sixteen_bit ? 1 : 0), 0);
}

static BOOL OpenSoundEvent()
{
	if(hSoundEvent0 == FALSE)
		hSoundEvent0 = CreateEvent(NULL, FALSE, FALSE, "uosnes-SoundEvent");

	if(hSoundEvent0 == FALSE)
		return FALSE;

	if(hSoundEvent1 == FALSE)
		hSoundEvent1 = OpenEvent(SYNCHRONIZE, FALSE, "uosnes-SoundEvent");
	if(hSoundEvent2 == FALSE)
		hSoundEvent2 = OpenEvent(EVENT_MODIFY_STATE, FALSE, "uosnes-SoundEvent");

	if(hSoundEvent1 == FALSE || hSoundEvent2 == FALSE)
		return FALSE;

	if(hCriticalSection == FALSE) {
		InitializeCriticalSection(&ssycs);
		hCriticalSection = TRUE;
	}

	return TRUE;
}

static void CloseSoundEvent()
{
	if(hSoundEvent2) {
		CloseHandle(hSoundEvent2);
		hSoundEvent2 = FALSE;
	}
	if(hSoundEvent1) {
		CloseHandle(hSoundEvent1);
		hSoundEvent1 = FALSE;
	}
	if(hSoundEvent0) {
		CloseHandle(hSoundEvent0);
		hSoundEvent0 = FALSE;
	}
	if(hCriticalSection) {
		DeleteCriticalSection(&ssycs);
		hCriticalSection = FALSE;
	}
}

bool8 UosneswSetupSound (long rate, bool8 sixteen_bit, bool8 stereo)
{
	if(sound_exit == FALSE) {
		sound_exit = TRUE;
		WaitForSingleObject(hSoundEvent1, INFINITE);
		if(sound_exit_success == FALSE)
			return FALSE;
	}
	CloseSoundEvent();
	if(!OpenSoundEvent()) {
		CloseSoundEvent();
		return FALSE;
	}

	WAVEFORMATEX wfx;
	DWORD buffersize;

	bool8 r = (bool8)WinSetupSound(rate, (BOOL)sixteen_bit, (BOOL)stereo,
								   Settings.SoundBufferSize, Settings.SoundMixInterval,
								   SNESSoundCallback,
								   &wfx, &buffersize,
								   GUI.hWnd, GUI.DSuse,
								   GUI.SoundGlobalFocus, GUI.DirectSoundNotify);

	if(!r && GUI.DSuse && GUI.DirectSoundNotify) {
		BOOL ds_notify = GUI.DirectSoundNotify;
		ds_notify = !ds_notify;
		r = (bool8)WinSetupSound(rate, (BOOL)sixteen_bit, (BOOL)stereo,
								 Settings.SoundBufferSize, Settings.SoundMixInterval,
								 SNESSoundCallback,
								 &wfx, &buffersize,
								 GUI.hWnd, GUI.DSuse,
								 GUI.SoundGlobalFocus, ds_notify);

		if(r)
			GUI.DirectSoundNotify = ds_notify;
	}

	if(!r) {
		BOOL dsuse = GUI.DSuse;
		dsuse = !dsuse;
		r = (bool8)WinSetupSound(rate, (BOOL)sixteen_bit, (BOOL)stereo,
								 Settings.SoundBufferSize, Settings.SoundMixInterval,
								 SNESSoundCallback,
								 &wfx, &buffersize,
								 GUI.hWnd, dsuse,
								 GUI.SoundGlobalFocus, GUI.DirectSoundNotify);

		if(!r)
			return FALSE;

		GUI.DSuse = dsuse;
	}

	Settings.Stereo = wfx.nChannels == 2 ? TRUE : FALSE;
	Settings.SoundPlaybackRate = (uint32)wfx.nSamplesPerSec;
	Settings.SixteenBitSound = wfx.wBitsPerSample == 16 ? TRUE : FALSE;

    so.playback_rate = Settings.SoundPlaybackRate;
    so.stereo = Settings.Stereo;
    so.sixteen_bit = Settings.SixteenBitSound;
    so.buffer_size = (int)(buffersize / Settings.SoundBufferSize);
    so.encoded = FALSE;

	//Reserve SoundSyncBuffer
	if(SoundSyncBuffer0) {
		GlobalFree((HGLOBAL)SoundSyncBuffer0);
		SoundSyncBuffer = SoundSyncBuffer0 = NULL;
	}
	if(so.buffer_size) {
		SoundSyncBuffer0 = (uint8 *)GlobalAlloc(GPTR, (DWORD)so.buffer_size);
		SoundSyncBuffer = SoundSyncBuffer0;
		if(SoundSyncBuffer0 == NULL)
			return FALSE;
	}

	//Reset SoundSyncBuffer
	so.samples_mixed_so_far = 0;
	so.err_counter = 0;
	so.t64Cnt = EXT.t64Cnt;
	SoundSyncBuffer = SoundSyncBuffer0;

	S9xSetPlaybackRate(so.playback_rate);

	if(sound_exit == TRUE) {
		sound_exit = FALSE;
		WaitForSingleObject(hSoundEvent1, INFINITE);
		if(sound_exit_success == TRUE) {
			//sound_exit = TRUE;
			return FALSE;
		}
	}

	return TRUE;
}

void UosneswReleaseSound()
{
	if(sound_exit == FALSE) {
		sound_exit = TRUE;
		WaitForSingleObject(hSoundEvent1, INFINITE);
	}
	CloseSoundEvent();
	WinSoundDeinitialize();
	if(SoundSyncBuffer0) {
		GlobalFree((HGLOBAL)SoundSyncBuffer0);
		SoundSyncBuffer = SoundSyncBuffer0 = NULL;
	}
}

extern "C" void S9xGenerateSound(void)
{
	int _max_count = so.sixteen_bit ? so.buffer_size >> 1 : so.buffer_size;

	if(sound_exit ||
	   /*SoundSyncBuffer0 == NULL ||*/
	   so.samples_mixed_so_far >= _max_count)
		return;

	EnterCriticalSection(&ssycs);

	int _sample_count;
    if((_sample_count = (int)((so.err_counter += so.err_rate * (EXT.t64Cnt - so.t64Cnt)) >> FIXED_POINT_SHIFT)) > 0) {
        so.err_counter &= FIXED_POINT_REMAINDER;

		if (so.stereo)
			_sample_count <<= 1;

		//SoundSyncBuffer - SoundSyncBuffer0
		int _byte_offset = (int)(SoundSyncBuffer - SoundSyncBuffer0);
		_byte_offset =
			(_byte_offset + (so.samples_mixed_so_far << (so.sixteen_bit ? 1 : 0))) % so.buffer_size;

        if (so.samples_mixed_so_far + _sample_count > _max_count)
            _sample_count = _max_count - so.samples_mixed_so_far;

		int _sample_count0 = (_max_count - (_byte_offset >> (so.sixteen_bit ? 1 : 0)));

		if(_sample_count0 >= _sample_count) {
			S9xMixSamplesO(SoundSyncBuffer0,
						   _sample_count,
						   _byte_offset);
		}
		else {
			S9xMixSamplesO(SoundSyncBuffer0,
						   _sample_count0,
						   _byte_offset);
			S9xMixSamplesO(SoundSyncBuffer0,
						   _sample_count - _sample_count0,
						   0);

		}
		so.samples_mixed_so_far += _sample_count;
	}
	so.t64Cnt = EXT.t64Cnt;
	LeaveCriticalSection(&ssycs);
}

