#include "snes9x.h"
#include "ppu.h"
#include "soundux.h"
#include "uosnesw.h"
#include "windraw.h"
#include "winutil.h"

extern char ROMFileName[];
extern char RecentROMFileName[];

extern "C" const char *S9xBasename (const char *f);
extern "C" const char *S9xGetFilename (const char *e);
static void SetStateSaveLoadMenu();

//Set menu status proc
void SetMenuStatus(HMENU hAppMenu, HMENU hSysMenu)
{
	/* File */
	//Open ROM
	EnableMenuItem(hAppMenu, ID_FILE_OPEN, GUI.PauseEmulation ? MFS_GRAYED : MFS_ENABLED);
	//Recent Games
	SetRecentFileMenu();

	/* Option */
	//Double Rendering(x2)
	CheckMenuItem(hAppMenu, ID_OPTION_DOUBLE, (GUI.DoubleRendering ? MFS_CHECKED : MFS_UNCHECKED));
	EnableMenuItem(hAppMenu, ID_OPTION_DOUBLE, GUI.PauseEmulation ? MFS_GRAYED : MFS_ENABLED);
	//Fullscreen
	CheckMenuItem(hAppMenu, ID_OPTION_FULLSCREEN,
				  (GUI.FullScreen || (DirectX.Windowed && DirectX.Depth == 8)) ? MFS_CHECKED : MFS_UNCHECKED);
	EnableMenuItem(hAppMenu, ID_OPTION_FULLSCREEN,
				   (Settings.SPCPlaying || (DirectX.Windowed && DirectX.Depth == 8)) ? MFS_GRAYED : MFS_ENABLED);
	//Adjust Window Size
	EnableMenuItem(hAppMenu, ID_OPTION_ADJUSTWINDOW, GUI.PauseEmulation ? MFS_GRAYED : MFS_ENABLED);
	//Stretch Image
	CheckMenuItem(hAppMenu, ID_OPTION_STRETCH, GUI.Stretch == 1 ? MFS_CHECKED : MFS_UNCHECKED);
	//Stretch Image Clip Scale
	CheckMenuItem(hAppMenu, ID_OPTION_SCALESTRETCH, GUI.Stretch == 2 ? MFS_CHECKED : MFS_UNCHECKED);
	//Configuration Settings
	EnableMenuItem(hAppMenu, ID_OPTION_CONFIG, GUI.PauseEmulation ? MFS_GRAYED : MFS_ENABLED);
	//Cheat Code
	EnableMenuItem(hAppMenu, ID_OPTION_CHEATCODE,
				   (GUI.StopEmulation || Settings.SPCPlaying) ? MFS_GRAYED : MFS_ENABLED);
	//uosnes Keys of change settings
	CheckMenuItem(hAppMenu, ID_OPTION_SETTINGS_KEY_0, Settings.DisableHDMA ? MFS_UNCHECKED : MFS_CHECKED);
	CheckMenuItem(hAppMenu, ID_OPTION_SETTINGS_KEY_6, Settings.SwapJoypads ? MFS_CHECKED : MFS_UNCHECKED);
	CheckMenuItem(hAppMenu, ID_OPTION_SETTINGS_KEY_8, Settings.BGLayering ? MFS_CHECKED : MFS_UNCHECKED);
	CheckMenuItem(hAppMenu, ID_OPTION_SETTINGS_KEY_9, Settings.Transparency ? MFS_CHECKED : MFS_UNCHECKED);
	EnableMenuItem(hAppMenu, ID_OPTION_SETTINGS_KEY_9, Settings.SixteenBit ? MFS_ENABLED : MFS_GRAYED);
	CheckMenuItem(hAppMenu, ID_OPTION_SETTINGS_KEY_BACK,
				  Settings.DisableGraphicWindows ? MFS_UNCHECKED : MFS_CHECKED);
	CheckMenuItem(hAppMenu, ID_OPTION_SETTINGS_KEY_PAUSE, GUI.PauseEmulation ? MFS_CHECKED : MFS_UNCHECKED);
	CheckMenuItem(hAppMenu, ID_OPTION_SETTINGS_KEY_APPLYCHEATS,
				  (Settings.ApplyCheats ? MFS_CHECKED : MFS_UNCHECKED));
	CheckMenuItem(hAppMenu, ID_OPTION_SETTINGS_KEY_TURBO, Settings.TurboMode ? MFS_CHECKED : MFS_UNCHECKED);

	//Volume Level
	switch(Options.VolumeLevel) {
	case 1:
		CheckMenuRadioItem(hAppMenu, ID_OPTION_VL1, ID_OPTION_VL5, ID_OPTION_VL1, MF_BYCOMMAND);
		break;

	case 2:
		CheckMenuRadioItem(hAppMenu, ID_OPTION_VL1, ID_OPTION_VL5, ID_OPTION_VL2, MF_BYCOMMAND);
		break;

	case 3:
		CheckMenuRadioItem(hAppMenu, ID_OPTION_VL1, ID_OPTION_VL5, ID_OPTION_VL3, MF_BYCOMMAND);
		break;

	case 4:
		CheckMenuRadioItem(hAppMenu, ID_OPTION_VL1, ID_OPTION_VL5, ID_OPTION_VL4, MF_BYCOMMAND);
		break;

	case 5:
		CheckMenuRadioItem(hAppMenu, ID_OPTION_VL1, ID_OPTION_VL5, ID_OPTION_VL5, MF_BYCOMMAND);
		break;

	default:
		CheckMenuRadioItem(hAppMenu, ID_OPTION_VL1, ID_OPTION_VL5, ID_OPTION_VL1, MF_BYCOMMAND);
		break;
	}
	//Mute Sound
	CheckMenuItem(hAppMenu, ID_OPTION_MUTE, (Settings.Mute ? MFS_CHECKED : MFS_UNCHECKED));
	//Show FPS
	CheckMenuItem(hAppMenu, ID_OPTION_FPS, (Settings.DisplayFrameRate ? MFS_CHECKED : MFS_UNCHECKED));

	//Language
	if(Options.JPenvFlag)
		CheckMenuItem(hAppMenu, ID_OPTION_JP, MFS_CHECKED);

	//Volume Level(System Menu)
	switch(Options.VolumeLevel) {
	case 1:
		CheckMenuRadioItem(hSysMenu,
						   ID_OPTION_VL1, ID_OPTION_VL5,
						   ID_OPTION_VL1, MF_BYCOMMAND);
		break;

	case 2:
		CheckMenuRadioItem(hSysMenu,
						   ID_OPTION_VL1, ID_OPTION_VL5,
						   ID_OPTION_VL2, MF_BYCOMMAND);
		break;

	case 3:
		CheckMenuRadioItem(hSysMenu, ID_OPTION_VL1, ID_OPTION_VL5, ID_OPTION_VL3, MF_BYCOMMAND);
		break;

	case 4:
		CheckMenuRadioItem(hSysMenu, ID_OPTION_VL1, ID_OPTION_VL5, ID_OPTION_VL4, MF_BYCOMMAND);
		break;

	case 5:
		CheckMenuRadioItem(hSysMenu, ID_OPTION_VL1, ID_OPTION_VL5, ID_OPTION_VL5, MF_BYCOMMAND);
		break;

	default:
		CheckMenuRadioItem(hSysMenu, ID_OPTION_VL1, ID_OPTION_VL5, ID_OPTION_VL1, MF_BYCOMMAND);
		break;
	}

	SetStateSaveLoadMenu();

	char movie_recording_menu_string[256];

	//AVI Movie Recording Start or Stop
	lstrcpy(movie_recording_menu_string,
			GUI.Language ? "AVI " : "A&VI Movie Recording ");
	if(Options.AVI_Recording) {
		lstrcat(movie_recording_menu_string,
				GUI.Language ? "^~(&V)\tShift+F12" : "Stop\tShift+F12");
	}
	else {
		lstrcat(movie_recording_menu_string,
				GUI.Language ? "^Jn(&V)\tShift+F12" : "Start\tShift+F12");
	}
	ModifyMenu(GUI.hMenu,
			   ID_FILE_WRITE_AVI,
			   MF_BYCOMMAND,
			   ID_FILE_WRITE_AVI,
			   movie_recording_menu_string);

	//Movie Recording Start or Stop
	lstrcpy(movie_recording_menu_string,
			GUI.Language ? "[r[ " : "&Movie Recording ");
	if(Options.MovieRecording) {
		lstrcat(movie_recording_menu_string,
				GUI.Language ? "L^~(&M)\tShift+M" : "Stop\tShift+M");
	}
	else {
		lstrcat(movie_recording_menu_string,
				GUI.Language ? "L^Jn(&M)\tShift+M" : "Start\tShift+M");
	}
	ModifyMenu(GUI.hMenu,
			   ID_FILE_WRITE_MOVIE,
			   MF_BYCOMMAND,
			   ID_FILE_WRITE_MOVIE,
			   movie_recording_menu_string);

	if(GUI.StopEmulation || Settings.SPCPlaying || (GUI.PauseEmulation && GUI.FullScreen)) {
		/* File */
		//Save Game Position
		EnableMenuItem(hAppMenu, ID_FILE_SAVESLOT_1, MFS_GRAYED);
		EnableMenuItem(hAppMenu, ID_FILE_SAVESLOT_2, MFS_GRAYED);
		EnableMenuItem(hAppMenu, ID_FILE_SAVESLOT_3, MFS_GRAYED);
		EnableMenuItem(hAppMenu, ID_FILE_SAVESLOT_4, MFS_GRAYED);
		EnableMenuItem(hAppMenu, ID_FILE_SAVESLOT_5, MFS_GRAYED);
		EnableMenuItem(hAppMenu, ID_FILE_SAVESLOT_6, MFS_GRAYED);
		EnableMenuItem(hAppMenu, ID_FILE_SAVESLOT_7, MFS_GRAYED);
		EnableMenuItem(hAppMenu, ID_FILE_SAVESLOT_8, MFS_GRAYED);
		EnableMenuItem(hAppMenu, ID_FILE_SAVESLOT_9, MFS_GRAYED);
		//Load Game Position
		EnableMenuItem(hAppMenu, ID_FILE_LOADSLOT_1, MFS_GRAYED);
		EnableMenuItem(hAppMenu, ID_FILE_LOADSLOT_2, MFS_GRAYED);
		EnableMenuItem(hAppMenu, ID_FILE_LOADSLOT_3, MFS_GRAYED);
		EnableMenuItem(hAppMenu, ID_FILE_LOADSLOT_4, MFS_GRAYED);
		EnableMenuItem(hAppMenu, ID_FILE_LOADSLOT_5, MFS_GRAYED);
		EnableMenuItem(hAppMenu, ID_FILE_LOADSLOT_6, MFS_GRAYED);
		EnableMenuItem(hAppMenu, ID_FILE_LOADSLOT_7, MFS_GRAYED);
		EnableMenuItem(hAppMenu, ID_FILE_LOADSLOT_8, MFS_GRAYED);
		EnableMenuItem(hAppMenu, ID_FILE_LOADSLOT_9, MFS_GRAYED);
		//Save Screen Shot
		EnableMenuItem(hAppMenu, ID_FILE_SCREENSHOT, MFS_GRAYED);

		//AVI Movie Recording Start or Stop
		//if(!Options.AVI_Recording)
			EnableMenuItem(hAppMenu, ID_FILE_WRITE_AVI, MFS_GRAYED);

		//Movie Recording Start or Stop
		//if(!Options.MovieRecording)
			EnableMenuItem(hAppMenu, ID_FILE_WRITE_MOVIE, MFS_GRAYED);

		//SPC Dump
		EnableMenuItem(hAppMenu, ID_FILE_SPCDUMP, MFS_GRAYED);
	}
	else {
		/* File */
		//Save Game Position
		EnableMenuItem(hAppMenu, ID_FILE_SAVESLOT_1, MFS_ENABLED);
		EnableMenuItem(hAppMenu, ID_FILE_SAVESLOT_2, MFS_ENABLED);
		EnableMenuItem(hAppMenu, ID_FILE_SAVESLOT_3, MFS_ENABLED);
		EnableMenuItem(hAppMenu, ID_FILE_SAVESLOT_4, MFS_ENABLED);
		EnableMenuItem(hAppMenu, ID_FILE_SAVESLOT_5, MFS_ENABLED);
		EnableMenuItem(hAppMenu, ID_FILE_SAVESLOT_6, MFS_ENABLED);
		EnableMenuItem(hAppMenu, ID_FILE_SAVESLOT_7, MFS_ENABLED);
		EnableMenuItem(hAppMenu, ID_FILE_SAVESLOT_8, MFS_ENABLED);
		EnableMenuItem(hAppMenu, ID_FILE_SAVESLOT_9, MFS_ENABLED);
		//Save Screen Shot
		EnableMenuItem(hAppMenu, ID_FILE_SCREENSHOT, MFS_ENABLED);

		//AVI Movie Recording Start or Stop
		//EnableMenuItem(hAppMenu, ID_FILE_WRITE_AVI, MFS_ENABLED);
		EnableMenuItem(hAppMenu, ID_FILE_WRITE_AVI, MFS_GRAYED);

		//Movie Recording Start or Stop
		//EnableMenuItem(hAppMenu, ID_FILE_WRITE_MOVIE, MFS_ENABLED);
		EnableMenuItem(hAppMenu, ID_FILE_WRITE_MOVIE, MFS_GRAYED);

		//SPC Dump
		EnableMenuItem(hAppMenu, ID_FILE_SPCDUMP, MFS_ENABLED);
	}

	//It's condition that emulator not execute.
	if(GUI.StopEmulation || Settings.SPCPlaying || GUI.PauseEmulation) {
		/* File */
		//Reset Game
		EnableMenuItem(hAppMenu, ID_FILE_SOFTRESET, MFS_GRAYED);
		//Power OFF ON!
		EnableMenuItem(hAppMenu, ID_FILE_RESET, MFS_GRAYED);

		/* Option */
		//uosnes Keys of change settings
		CheckMenuItem(hAppMenu, ID_OPTION_SETTINGS_KEY_1, MFS_CHECKED);
		EnableMenuItem(hAppMenu, ID_OPTION_SETTINGS_KEY_1, MFS_GRAYED);
		CheckMenuItem(hAppMenu, ID_OPTION_SETTINGS_KEY_2, MFS_CHECKED);
		EnableMenuItem(hAppMenu, ID_OPTION_SETTINGS_KEY_2, MFS_GRAYED);
		CheckMenuItem(hAppMenu, ID_OPTION_SETTINGS_KEY_3, MFS_CHECKED);
		EnableMenuItem(hAppMenu, ID_OPTION_SETTINGS_KEY_3, MFS_GRAYED);
		CheckMenuItem(hAppMenu, ID_OPTION_SETTINGS_KEY_4, MFS_CHECKED);
		EnableMenuItem(hAppMenu, ID_OPTION_SETTINGS_KEY_4, MFS_GRAYED);
		CheckMenuItem(hAppMenu, ID_OPTION_SETTINGS_KEY_5, MFS_CHECKED);
		EnableMenuItem(hAppMenu, ID_OPTION_SETTINGS_KEY_5, MFS_GRAYED);

		//uosnes Keys of change settings -> Snes Input Device Changing
		switch(Settings.ControllerOption) {
		case SNES_JOYPAD:
			CheckMenuRadioItem(hAppMenu,
							   ID_OPTION_SNESJOYPAD, ID_OPTION_SNESMULTIPLAYER5,
							   ID_OPTION_SNESJOYPAD,
							   MF_BYCOMMAND);
			break;

		case SNES_MOUSE_SWAPPED:
			if(!Settings.Mouse)
				break;
			CheckMenuRadioItem(hAppMenu,
							   ID_OPTION_SNESJOYPAD, ID_OPTION_SNESMULTIPLAYER5,
							   ID_OPTION_SNESMOUSE1,
							   MF_BYCOMMAND);
			break;

		case SNES_MOUSE:
			if(!Settings.Mouse)
				break;
			CheckMenuRadioItem(hAppMenu,
							   ID_OPTION_SNESJOYPAD, ID_OPTION_SNESMULTIPLAYER5,
							   ID_OPTION_SNESMOUSE0,
							   MF_BYCOMMAND);
			break;

		case SNES_SUPERSCOPE:
			if(!Settings.SuperScope)
				break;
			CheckMenuRadioItem(hAppMenu,
							   ID_OPTION_SNESJOYPAD, ID_OPTION_SNESMULTIPLAYER5,
							   ID_OPTION_SNESSUPERSCOPE,
							   MF_BYCOMMAND);
			break;

		case SNES_JUSTIFIER:
			if(!Settings.Justifier)
				break;
			CheckMenuRadioItem(hAppMenu,
							   ID_OPTION_SNESJOYPAD, ID_OPTION_SNESMULTIPLAYER5,
							   ID_OPTION_SNESJUSTIFIER,
							   MF_BYCOMMAND);
			break;

		case SNES_JUSTIFIER_2:
			if(!Settings.SecondJustifier)
				break;
			CheckMenuRadioItem(hAppMenu,
							   ID_OPTION_SNESJOYPAD, ID_OPTION_SNESMULTIPLAYER5,
							   ID_OPTION_SNESJUSTIFIER_2,
							   MF_BYCOMMAND);
			break;

		case SNES_MULTIPLAYER5:
			if(!Settings.MultiPlayer5)
				break;
			CheckMenuRadioItem(hAppMenu,
							   ID_OPTION_SNESJOYPAD, ID_OPTION_SNESMULTIPLAYER5,
							   ID_OPTION_SNESMULTIPLAYER5,
							   MF_BYCOMMAND);
			break;

		default:
			CheckMenuRadioItem(hAppMenu,
							   ID_OPTION_SNESJOYPAD, ID_OPTION_SNESMULTIPLAYER5,
							   ID_OPTION_SNESJOYPAD,
							   MF_BYCOMMAND);
			break;
		}

		EnableMenuItem(hAppMenu, ID_OPTION_SNESJOYPAD, MFS_GRAYED);
		EnableMenuItem(hAppMenu, ID_OPTION_SNESMOUSE1, MFS_GRAYED);
		EnableMenuItem(hAppMenu, ID_OPTION_SNESMOUSE0, MFS_GRAYED);
		EnableMenuItem(hAppMenu, ID_OPTION_SNESSUPERSCOPE, MFS_GRAYED);
		EnableMenuItem(hAppMenu, ID_OPTION_SNESJUSTIFIER, MFS_GRAYED);
		EnableMenuItem(hAppMenu, ID_OPTION_SNESJUSTIFIER_2, MFS_GRAYED);
		EnableMenuItem(hAppMenu, ID_OPTION_SNESMULTIPLAYER5, MFS_GRAYED);

		//SPC Sound Channnel ON OFF
		if(!Settings.SPCPlaying || GUI.PauseEmulation) {
			CheckMenuItem(hAppMenu, ID_OPTION_SETTINGS_KEY_SPCCHANNEL0, MFS_CHECKED);
			EnableMenuItem(hAppMenu, ID_OPTION_SETTINGS_KEY_SPCCHANNEL0, MFS_GRAYED);
			CheckMenuItem(hAppMenu, ID_OPTION_SETTINGS_KEY_SPCCHANNEL1, MFS_CHECKED);
			EnableMenuItem(hAppMenu, ID_OPTION_SETTINGS_KEY_SPCCHANNEL1, MFS_GRAYED);
			CheckMenuItem(hAppMenu, ID_OPTION_SETTINGS_KEY_SPCCHANNEL2, MFS_CHECKED);
			EnableMenuItem(hAppMenu, ID_OPTION_SETTINGS_KEY_SPCCHANNEL2, MFS_GRAYED);
			CheckMenuItem(hAppMenu, ID_OPTION_SETTINGS_KEY_SPCCHANNEL3, MFS_CHECKED);
			EnableMenuItem(hAppMenu, ID_OPTION_SETTINGS_KEY_SPCCHANNEL3, MFS_GRAYED);
			CheckMenuItem(hAppMenu, ID_OPTION_SETTINGS_KEY_SPCCHANNEL4, MFS_CHECKED);
			EnableMenuItem(hAppMenu, ID_OPTION_SETTINGS_KEY_SPCCHANNEL4, MFS_GRAYED);
			CheckMenuItem(hAppMenu, ID_OPTION_SETTINGS_KEY_SPCCHANNEL5, MFS_CHECKED);
			EnableMenuItem(hAppMenu, ID_OPTION_SETTINGS_KEY_SPCCHANNEL5, MFS_GRAYED);
			CheckMenuItem(hAppMenu, ID_OPTION_SETTINGS_KEY_SPCCHANNEL6, MFS_CHECKED);
			EnableMenuItem(hAppMenu, ID_OPTION_SETTINGS_KEY_SPCCHANNEL6, MFS_GRAYED);
			CheckMenuItem(hAppMenu, ID_OPTION_SETTINGS_KEY_SPCCHANNEL7, MFS_CHECKED);
			EnableMenuItem(hAppMenu, ID_OPTION_SETTINGS_KEY_SPCCHANNEL7, MFS_GRAYED);
		}
		else {
			CheckMenuItem(hAppMenu, ID_OPTION_SETTINGS_KEY_SPCCHANNEL0,
						  (so.sound_switch & (int)(1 << 0)) ? MFS_CHECKED : MFS_UNCHECKED);
			EnableMenuItem(hAppMenu, ID_OPTION_SETTINGS_KEY_SPCCHANNEL0, MFS_ENABLED);
			CheckMenuItem(hAppMenu, ID_OPTION_SETTINGS_KEY_SPCCHANNEL1,
						  (so.sound_switch & (int)(1 << 1)) ? MFS_CHECKED : MFS_UNCHECKED);
			EnableMenuItem(hAppMenu, ID_OPTION_SETTINGS_KEY_SPCCHANNEL1, MFS_ENABLED);
			CheckMenuItem(hAppMenu, ID_OPTION_SETTINGS_KEY_SPCCHANNEL2,
						  (so.sound_switch & (int)(1 << 2)) ? MFS_CHECKED : MFS_UNCHECKED);
			EnableMenuItem(hAppMenu, ID_OPTION_SETTINGS_KEY_SPCCHANNEL2, MFS_ENABLED);
			CheckMenuItem(hAppMenu, ID_OPTION_SETTINGS_KEY_SPCCHANNEL3,
						  (so.sound_switch & (int)(1 << 3)) ? MFS_CHECKED : MFS_UNCHECKED);
			EnableMenuItem(hAppMenu, ID_OPTION_SETTINGS_KEY_SPCCHANNEL3, MFS_ENABLED);
			CheckMenuItem(hAppMenu, ID_OPTION_SETTINGS_KEY_SPCCHANNEL4,
						  (so.sound_switch & (int)(1 << 4)) ? MFS_CHECKED : MFS_UNCHECKED);
			EnableMenuItem(hAppMenu, ID_OPTION_SETTINGS_KEY_SPCCHANNEL4, MFS_ENABLED);
			CheckMenuItem(hAppMenu, ID_OPTION_SETTINGS_KEY_SPCCHANNEL5,
						  (so.sound_switch & (int)(1 << 5)) ? MFS_CHECKED : MFS_UNCHECKED);
			EnableMenuItem(hAppMenu, ID_OPTION_SETTINGS_KEY_SPCCHANNEL5, MFS_ENABLED);
			CheckMenuItem(hAppMenu, ID_OPTION_SETTINGS_KEY_SPCCHANNEL6,
						  (so.sound_switch & (int)(1 << 6)) ? MFS_CHECKED : MFS_UNCHECKED);
			EnableMenuItem(hAppMenu, ID_OPTION_SETTINGS_KEY_SPCCHANNEL6, MFS_ENABLED);
			CheckMenuItem(hAppMenu, ID_OPTION_SETTINGS_KEY_SPCCHANNEL7,
						  (so.sound_switch & (int)(1 << 7)) ? MFS_CHECKED : MFS_UNCHECKED);
			EnableMenuItem(hAppMenu, ID_OPTION_SETTINGS_KEY_SPCCHANNEL7, MFS_ENABLED);
		}
	}
	else {
		/* File */
		//Reset Game
		EnableMenuItem(hAppMenu, ID_FILE_SOFTRESET, MFS_ENABLED);
		//Power OFF ON!
		EnableMenuItem(hAppMenu, ID_FILE_RESET, MFS_ENABLED);

		/* Option */
		//uosnes Keys of change settings
		CheckMenuItem(hAppMenu, ID_OPTION_SETTINGS_KEY_1,
					  (PPU.BG_Forced & 1) ? MFS_UNCHECKED : MFS_CHECKED);
		EnableMenuItem(hAppMenu, ID_OPTION_SETTINGS_KEY_1, MFS_ENABLED);
		CheckMenuItem(hAppMenu, ID_OPTION_SETTINGS_KEY_2,
					  (PPU.BG_Forced & 2) ? MFS_UNCHECKED : MFS_CHECKED);
		EnableMenuItem(hAppMenu, ID_OPTION_SETTINGS_KEY_2, MFS_ENABLED);
		CheckMenuItem(hAppMenu, ID_OPTION_SETTINGS_KEY_3,
					  (PPU.BG_Forced & 4) ? MFS_UNCHECKED : MFS_CHECKED);
		EnableMenuItem(hAppMenu, ID_OPTION_SETTINGS_KEY_3, MFS_ENABLED);
		CheckMenuItem(hAppMenu, ID_OPTION_SETTINGS_KEY_4,
					  (PPU.BG_Forced & 8) ? MFS_UNCHECKED : MFS_CHECKED);
		EnableMenuItem(hAppMenu, ID_OPTION_SETTINGS_KEY_4, MFS_ENABLED);
		CheckMenuItem(hAppMenu, ID_OPTION_SETTINGS_KEY_5,
					  (PPU.BG_Forced & 16) ? MFS_UNCHECKED : MFS_CHECKED);
		EnableMenuItem(hAppMenu, ID_OPTION_SETTINGS_KEY_5, MFS_ENABLED);

		//uosnes Keys of change settings -> Snes Input Device Changing
		switch(Settings.ControllerOption) {
		case SNES_JOYPAD:
			CheckMenuRadioItem(hAppMenu,
							   ID_OPTION_SNESJOYPAD,ID_OPTION_SNESMULTIPLAYER5,
							   ID_OPTION_SNESJOYPAD,
							   MF_BYCOMMAND);
			break;

		case SNES_MOUSE_SWAPPED:
			CheckMenuRadioItem(hAppMenu,
							   ID_OPTION_SNESJOYPAD, ID_OPTION_SNESMULTIPLAYER5,
							   ID_OPTION_SNESMOUSE1,
							   MF_BYCOMMAND);
			break;

		case SNES_MOUSE:
			CheckMenuRadioItem(hAppMenu, ID_OPTION_SNESJOYPAD,
							   ID_OPTION_SNESMULTIPLAYER5,
							   ID_OPTION_SNESMOUSE0, MF_BYCOMMAND);
			break;

		case SNES_SUPERSCOPE:
			CheckMenuRadioItem(hAppMenu, ID_OPTION_SNESJOYPAD,
							   ID_OPTION_SNESMULTIPLAYER5,
							   ID_OPTION_SNESSUPERSCOPE, MF_BYCOMMAND);
			break;

		case SNES_JUSTIFIER:
			CheckMenuRadioItem(hAppMenu, ID_OPTION_SNESJOYPAD,
							   ID_OPTION_SNESMULTIPLAYER5,
							   ID_OPTION_SNESJUSTIFIER, MF_BYCOMMAND);
			break;

		case SNES_JUSTIFIER_2:
			CheckMenuRadioItem(hAppMenu, ID_OPTION_SNESJOYPAD,
							   ID_OPTION_SNESMULTIPLAYER5,
							   ID_OPTION_SNESJUSTIFIER_2, MF_BYCOMMAND);
			break;

		case SNES_MULTIPLAYER5:
			CheckMenuRadioItem(hAppMenu, ID_OPTION_SNESJOYPAD,
							   ID_OPTION_SNESMULTIPLAYER5,
							   ID_OPTION_SNESMULTIPLAYER5, MF_BYCOMMAND);
			break;

		default:
			CheckMenuRadioItem(hAppMenu,
							   ID_OPTION_SNESJOYPAD,ID_OPTION_SNESMULTIPLAYER5,
							   ID_OPTION_SNESJOYPAD,
							   MF_BYCOMMAND);
			break;
		}

		EnableMenuItem(hAppMenu, ID_OPTION_SNESJOYPAD, MFS_ENABLED);
		EnableMenuItem(hAppMenu, ID_OPTION_SNESMOUSE1, Settings.Mouse ? MFS_ENABLED : MFS_GRAYED);
		EnableMenuItem(hAppMenu, ID_OPTION_SNESMOUSE0, Settings.Mouse ? MFS_ENABLED : MFS_GRAYED);
		EnableMenuItem(hAppMenu, ID_OPTION_SNESSUPERSCOPE, Settings.SuperScope ? MFS_ENABLED : MFS_GRAYED);
		EnableMenuItem(hAppMenu, ID_OPTION_SNESJUSTIFIER, Settings.Justifier ? MFS_ENABLED : MFS_GRAYED);
		EnableMenuItem(hAppMenu, ID_OPTION_SNESJUSTIFIER_2, Settings.SecondJustifier ? MFS_ENABLED : MFS_GRAYED);
		EnableMenuItem(hAppMenu, ID_OPTION_SNESMULTIPLAYER5, Settings.MultiPlayer5 ? MFS_ENABLED : MFS_GRAYED);

		//SPC Sound Channnel ON OFF
		CheckMenuItem(hAppMenu, ID_OPTION_SETTINGS_KEY_SPCCHANNEL0,
					  (so.sound_switch & (int)(1 << 0)) ? MFS_CHECKED : MFS_UNCHECKED);
		EnableMenuItem(hAppMenu, ID_OPTION_SETTINGS_KEY_SPCCHANNEL0, MFS_ENABLED);
		CheckMenuItem(hAppMenu, ID_OPTION_SETTINGS_KEY_SPCCHANNEL1,
					  (so.sound_switch & (int)(1 << 1)) ? MFS_CHECKED : MFS_UNCHECKED);
		EnableMenuItem(hAppMenu, ID_OPTION_SETTINGS_KEY_SPCCHANNEL1, MFS_ENABLED);
		CheckMenuItem(hAppMenu, ID_OPTION_SETTINGS_KEY_SPCCHANNEL2,
					  (so.sound_switch & (int)(1 << 2)) ? MFS_CHECKED : MFS_UNCHECKED);
		EnableMenuItem(hAppMenu, ID_OPTION_SETTINGS_KEY_SPCCHANNEL2, MFS_ENABLED);
		CheckMenuItem(hAppMenu, ID_OPTION_SETTINGS_KEY_SPCCHANNEL3,
					  (so.sound_switch & (int)(1 << 3)) ? MFS_CHECKED : MFS_UNCHECKED);
		EnableMenuItem(hAppMenu, ID_OPTION_SETTINGS_KEY_SPCCHANNEL3, MFS_ENABLED);
		CheckMenuItem(hAppMenu, ID_OPTION_SETTINGS_KEY_SPCCHANNEL4,
					  (so.sound_switch & (int)(1 << 4)) ? MFS_CHECKED : MFS_UNCHECKED);
		EnableMenuItem(hAppMenu, ID_OPTION_SETTINGS_KEY_SPCCHANNEL4, MFS_ENABLED);
		CheckMenuItem(hAppMenu, ID_OPTION_SETTINGS_KEY_SPCCHANNEL5,
					  (so.sound_switch & (int)(1 << 5)) ? MFS_CHECKED : MFS_UNCHECKED);
		EnableMenuItem(hAppMenu, ID_OPTION_SETTINGS_KEY_SPCCHANNEL5, MFS_ENABLED);
		CheckMenuItem(hAppMenu, ID_OPTION_SETTINGS_KEY_SPCCHANNEL6,
					  (so.sound_switch & (int)(1 << 6)) ? MFS_CHECKED : MFS_UNCHECKED);
		EnableMenuItem(hAppMenu, ID_OPTION_SETTINGS_KEY_SPCCHANNEL6, MFS_ENABLED);
		CheckMenuItem(hAppMenu, ID_OPTION_SETTINGS_KEY_SPCCHANNEL7,
					  (so.sound_switch & (int)(1 << 7)) ? MFS_CHECKED : MFS_UNCHECKED);
		EnableMenuItem(hAppMenu, ID_OPTION_SETTINGS_KEY_SPCCHANNEL7, MFS_ENABLED);
	}

	/* File */
	//Back to Idle
	EnableMenuItem(hAppMenu, ID_FILE_BACKTOIDLE, GUI.StopEmulation ? MFS_GRAYED : MFS_ENABLED);
}

static bool GetFileTimeStringError = FALSE;
static FILETIME fLocTimes[9];
static FILETIME *fLocTimesp[9];

static char *GetFileTimeString(char *Fname, int memuindex)
{
	FILETIME fLocTime;
	SYSTEMTIME sysTime;
	HANDLE hFind;
	WIN32_FIND_DATA w32fd;
	hFind = FindFirstFile(Fname, &w32fd);
	if(hFind == INVALID_HANDLE_VALUE) {
		GetFileTimeStringError = TRUE;
		return (char *)(GUI.Language ? "" : "Empty");
	}
	FindClose(hFind);
	static char FileTimeStr[256];
	FileTimeToLocalFileTime(&w32fd.ftLastWriteTime, &fLocTime);
	FileTimeToSystemTime(&fLocTime, &sysTime);
	wsprintf(FileTimeStr,
			 "%04d/%02d/%02d %02d:%02d:%02d",
			 sysTime.wYear,
			 sysTime.wMonth,
			 sysTime.wDay,
			 sysTime.wHour,
			 sysTime.wMinute,
			 sysTime.wSecond);
	fLocTimes[memuindex] = fLocTime;
	fLocTimesp[memuindex] = &fLocTimes[memuindex];
	GetFileTimeStringError = FALSE;
	return FileTimeStr;
}

static void SetStateSaveLoadMenuDefault()
{
	FILETIME fLocTime;
	int i, menudefaultindex;
	
	for(i = 0; i < 9; i++) {
		if(fLocTimesp[i]) {
			fLocTime = fLocTimes[i];
			menudefaultindex = i;
			break;
		}
	}
	
	if(i >= 9)
		return;
	
	for(; i < 9; i++) {
		if(fLocTimesp[i] &&
			(fLocTimes[i].dwHighDateTime > fLocTime.dwHighDateTime ||
			(fLocTimes[i].dwHighDateTime >= fLocTime.dwHighDateTime &&
			 fLocTimes[i].dwLowDateTime > fLocTime.dwLowDateTime))) {
			fLocTime = fLocTimes[i];
			menudefaultindex = i;
		}
	}
	
	SetMenuDefaultItem(GetSubMenu(GetSubMenu(GUI.hMenu, 0), GUI.hRecentGamesMenu ? 3 : 2),
					   (UINT)(ID_FILE_SAVESLOT_1 + menudefaultindex), FALSE);
	SetMenuDefaultItem(GetSubMenu(GetSubMenu(GUI.hMenu, 0), GUI.hRecentGamesMenu ? 4 : 3),
					   (UINT)(ID_FILE_LOADSLOT_1 + menudefaultindex), FALSE);
}

static void SetStateSaveLoadMenu()
{
	char StateSaveLoadMenuString[100];
	char KeyNumberStr[2];
	char saveloadext[_MAX_EXT];
	int i;

	FillMemory((PVOID)fLocTimes, sizeof(FILETIME) * 9, 0);
	FillMemory((PVOID)fLocTimesp, sizeof(FILETIME *) * 9, 0);

	lstrcpy(StateSaveLoadMenuString, GUI.Language ? "Slot #&" : "Slot #&");
	if(GUI.StopEmulation || Settings.SPCPlaying) {
		for(i = 0; i < 9; i++) {
			wsprintf(&StateSaveLoadMenuString[7], "%d", i + 1);
			lstrcat(StateSaveLoadMenuString, "\tShift+F");
			wsprintf(KeyNumberStr, "%d", i + 1);
			lstrcat(StateSaveLoadMenuString, KeyNumberStr);
			ModifyMenu(GUI.hMenu,
					   ID_FILE_SAVESLOT_1 + i,
					   MF_BYCOMMAND,
					   ID_FILE_SAVESLOT_1 + i,
					   StateSaveLoadMenuString);
			wsprintf(&StateSaveLoadMenuString[7], "%d", i + 1);
			lstrcat(StateSaveLoadMenuString, "\tF");
			lstrcat(StateSaveLoadMenuString, KeyNumberStr);
			ModifyMenu(GUI.hMenu,
					   ID_FILE_LOADSLOT_1 + i,
					   MF_BYCOMMAND,
					   ID_FILE_LOADSLOT_1 + i,
					   StateSaveLoadMenuString);
		}
	}
	else {
		for(i = 0; i < 9; i++) {
			wsprintf(&StateSaveLoadMenuString[7], "%d", i + 1);
			wsprintf(saveloadext, ".%03d", i);

			//In case freeze file of slot num not exist.
			if(GetFileAttributes(S9xGetFilename(saveloadext)) == 0xffffffff) {
				lstrcat(StateSaveLoadMenuString, GUI.Language ? "  " : "  Empty");
				lstrcat(StateSaveLoadMenuString, "\tShift+F");
				wsprintf(KeyNumberStr, "%d", i + 1);
				lstrcat(StateSaveLoadMenuString, KeyNumberStr);
				ModifyMenu(GUI.hMenu, ID_FILE_SAVESLOT_1 + i, MF_BYCOMMAND,
						   ID_FILE_SAVESLOT_1 + i, StateSaveLoadMenuString);
				wsprintf(&StateSaveLoadMenuString[7], "%d", i + 1);
				lstrcat(StateSaveLoadMenuString, GUI.Language ? "  " : "  Empty");
				lstrcat(StateSaveLoadMenuString, "\tF");
				lstrcat(StateSaveLoadMenuString, KeyNumberStr);
				ModifyMenu(GUI.hMenu, ID_FILE_LOADSLOT_1 + i, MF_BYCOMMAND,
						   ID_FILE_LOADSLOT_1 + i, StateSaveLoadMenuString);
				EnableMenuItem(GUI.hMenu, ID_FILE_LOADSLOT_1 + i, MFS_GRAYED);
			}
			//In case freeze file of slot num exists.
			else {
				lstrcat(StateSaveLoadMenuString, "  ");
				lstrcat(StateSaveLoadMenuString,
						GetFileTimeString((char *)S9xGetFilename(saveloadext), i));
				lstrcat(StateSaveLoadMenuString, "\tShift+F");
				wsprintf(KeyNumberStr, "%d", i + 1);
				lstrcat(StateSaveLoadMenuString, KeyNumberStr);
				ModifyMenu(GUI.hMenu,
						   ID_FILE_SAVESLOT_1 + i,
						   MF_BYCOMMAND,
						   ID_FILE_SAVESLOT_1 + i,
						   StateSaveLoadMenuString);
				wsprintf(&StateSaveLoadMenuString[7], "%d", i + 1);
				lstrcat(StateSaveLoadMenuString, "  ");
				lstrcat(StateSaveLoadMenuString,
						GetFileTimeString((char *)S9xGetFilename(saveloadext), i));
				lstrcat(StateSaveLoadMenuString, "\tF");
				lstrcat(StateSaveLoadMenuString, KeyNumberStr);
				ModifyMenu(GUI.hMenu,
						   ID_FILE_LOADSLOT_1 + i,
						   MF_BYCOMMAND,
						   ID_FILE_LOADSLOT_1 + i,
						   StateSaveLoadMenuString);
				if(!GetFileTimeStringError)
					EnableMenuItem(GUI.hMenu, ID_FILE_LOADSLOT_1 + i, MFS_ENABLED);
				else
					EnableMenuItem(GUI.hMenu, ID_FILE_LOADSLOT_1 + i, MFS_GRAYED);
			}
		}
	}
	SetStateSaveLoadMenuDefault();
}

static int RecentROMFileNameDuplicateCheck(int listindex)
{
	int dupret = TRUE;
	if(!RecentROMFileName[_MAX_PATH * listindex])
		return !dupret;
	for(int listindex2 = listindex + 1; listindex2 < 10 && dupret; listindex2++)
		dupret = lstrcmp(&RecentROMFileName[_MAX_PATH * listindex2], &RecentROMFileName[_MAX_PATH * listindex]);
	return !dupret;
}

void SetRecentFileMenu()
{
	int i, i2;

	//Refresh RecentROMFileName
	if(ROMFileName[0]
	&& lstrcmp(&RecentROMFileName[_MAX_PATH * 0], ROMFileName)
	&& lstrcmp(&RecentROMFileName[_MAX_PATH * 1], ROMFileName)
	&& lstrcmp(&RecentROMFileName[_MAX_PATH * 2], ROMFileName)
	&& lstrcmp(&RecentROMFileName[_MAX_PATH * 3], ROMFileName)
	&& lstrcmp(&RecentROMFileName[_MAX_PATH * 4], ROMFileName)
	&& lstrcmp(&RecentROMFileName[_MAX_PATH * 5], ROMFileName)
	&& lstrcmp(&RecentROMFileName[_MAX_PATH * 6], ROMFileName)
	&& lstrcmp(&RecentROMFileName[_MAX_PATH * 7], ROMFileName)
	&& lstrcmp(&RecentROMFileName[_MAX_PATH * 8], ROMFileName)
	&& lstrcmp(&RecentROMFileName[_MAX_PATH * 9], ROMFileName))
	{
		memmove((void *)&RecentROMFileName[_MAX_PATH * 1],
				(void *)&RecentROMFileName[_MAX_PATH * 0], _MAX_PATH * 9);
		lstrcpy(&RecentROMFileName[_MAX_PATH * 0], ROMFileName);
	}

	//ROMFileName == RecentROMFileName[_MAX_PATH * y]
	else if(ROMFileName[0]) {
		for(i = 1; i < 10; i++) {
			if(!lstrcmp(ROMFileName, &RecentROMFileName[_MAX_PATH * i])) {
				memmove((void *)&RecentROMFileName[_MAX_PATH * 1],
						(void *)RecentROMFileName, _MAX_PATH * i);
				lstrcpy(RecentROMFileName, ROMFileName);
				break;
			}
		}
	}

	//empty, duplicate, file not exist
	for(i = 0; i < 10; i++) {
		for(i2 = i; i2 < 10; i2++) {
			if(!RecentROMFileName[_MAX_PATH * i] ||
			   RecentROMFileNameDuplicateCheck(i) ||
			   GetFileAttributes(&RecentROMFileName[_MAX_PATH * i]) == 0xffffffff)
				memmove((void *)&RecentROMFileName[_MAX_PATH * i],
						(void *)&RecentROMFileName[_MAX_PATH * (i + 1)],
						(_MAX_PATH * 11) - (_MAX_PATH * (i + 1)));
		}
	}
	
	//Recent Games
	if(RecentROMFileName[_MAX_PATH * 0] || RecentROMFileName[_MAX_PATH * 1] ||
	   RecentROMFileName[_MAX_PATH * 2] || RecentROMFileName[_MAX_PATH * 3] ||
	   RecentROMFileName[_MAX_PATH * 4]	|| RecentROMFileName[_MAX_PATH * 5] ||
	   RecentROMFileName[_MAX_PATH * 6] || RecentROMFileName[_MAX_PATH * 7] ||
	   RecentROMFileName[_MAX_PATH * 8] || RecentROMFileName[_MAX_PATH * 9]) {
		if(GUI.hRecentGamesMenu) {
			DeleteMenu(GetSubMenu(GUI.hMenu, 0), 1, MF_BYPOSITION | MF_POPUP);
			DestroyMenu(GUI.hRecentGamesMenu);
		}
		GUI.hRecentGamesMenu = CreatePopupMenu();
		char RecentGamesMenuStrings[_MAX_PATH + 5];
		lstrcpy(RecentGamesMenuStrings, "&1. ");
		for(i = 0; i < 10; i++) {
			if(RecentROMFileName[_MAX_PATH * i]) {
				wsprintf(&RecentGamesMenuStrings[1], "%X", i + 1);
				RecentGamesMenuStrings[2] = '.';
				lstrcpyn(&RecentGamesMenuStrings[4],
						 S9xBasename(&RecentROMFileName[_MAX_PATH * i]), _MAX_PATH);
				RecentGamesMenuStrings[_MAX_PATH + 4] = 0;
				StrexchDBCS(RecentGamesMenuStrings + 4, '&', (char *)"&&", _MAX_PATH + 1);
				AppendMenu(GUI.hRecentGamesMenu, MFT_STRING,
						   ID_FILE_RECENT1 + i, RecentGamesMenuStrings);
				EnableMenuItem(GUI.hRecentGamesMenu, ID_FILE_RECENT1 + i,
							   GUI.PauseEmulation ? MFS_GRAYED : MFS_ENABLED);
			}
		}
		InsertMenu(GetSubMenu(GUI.hMenu, 0),
				   1,
				   MF_BYPOSITION | MF_POPUP,
				   (UINT)GUI.hRecentGamesMenu,
				   GUI.Language ? "ŋߓǂݍ񂾃(&G)" : "Recent &Games");
	}
	else {
		if(GUI.hRecentGamesMenu) {
			DeleteMenu(GetSubMenu(GUI.hMenu, 0), 1, MF_BYPOSITION | MF_POPUP);
			DestroyMenu(GUI.hRecentGamesMenu);
			GUI.hRecentGamesMenu = 0;
		}
	}
}

