#include "snes9x.h"
#include "uosnesw.h"
#include <dinput.h>
#include "wininput.h"
#include "uowinput.h"

SJoypad JoypadA[5] = {
	{      								/* Joypad 1 default keys:*/
	VK_LEFT, 0, 0, VK_RIGHT, 0, 0, VK_UP, VK_DOWN,	/* Left, Left_Up, Left_Down, Right, Right_Up, Right_Down, Up, Down */
	VK_RETURN, VK_SPACE,				/* Start, Select */
	'D', 'C',							/* A B */
	'S', 'X',							/* X Y */
	'A', 'Z',							/* L R */
	0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0},
	{       							/* Joypad 2 default joystick 0 */
	0x8000, 0, 0, 0x8001, 0, 0, 0x8002, 0x8003,		/* Left, Left_Up, Left_Down, Right, Right_Up, Right_Down, Up, Down */
	0x8008, 0x8009,						/* Start, Select */
	0x800A, 0x800B,						/* A B */
	0x800C, 0x800D,						/* X Y */
	0x800E, 0x800F,						/* L R */
	0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0},
	{           						/* Joypad 3 default off */
	0, 0, 0, 0, 0, 0, 0, 0,							/* Left, Left_Up, Left_Down, Right, Right_Up, Right_Down, Up, Down */
	0, 0,								/* Start, Select */
	0, 0,								/* A B */
	0, 0,								/* X Y */
	0, 0,								/* L R */
	0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0},
	{           						/* Joypad 4 default off */
	0, 0, 0, 0, 0, 0, 0, 0,							/* Left, Left_Up, Left_Down, Right, Right_Up, Right_Down, Up, Down */
	0, 0,								/* Start, Select */
	0, 0,								/* A B */
	0, 0,								/* X Y */
	0, 0,								/* L R */
	0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0},
	{           						/* Joypad 5 default off */
	0, 0, 0, 0, 0, 0, 0, 0,							/* Left, Left_Up, Left_Down, Right, Right_Up, Right_Down, Up, Down */
	0, 0,								/* Start, Select */
	0, 0,								/* A B */
	0, 0,								/* X Y */
	0, 0,								/* L R */
	0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}
	};

SJoypad JoypadB[5] = {
	{   								/* Joypad 1 default keys:*/
	DIK_LEFT, 0, 0, DIK_RIGHT, 0, 0, DIK_UP, DIK_DOWN,	/* Left, Left_Up, Left_Down, Right, Right_Up, Right_Down, Up, Down */
	DIK_RETURN, DIK_SPACE,				/* Start, Select */
	DIK_D, DIK_C,						/* A B */
	DIK_S, DIK_X,						/* X Y */
	DIK_A, DIK_Z,						/* L R */
	0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0},
	{       							/* Joypad 2 default joystick 0 */
	0x8000, 0, 0, 0x8001, 0, 0, 0x8002, 0x8003,		/* Left, Left_Up, Left_Down, Right, Right_Up, Right_Down, Up, Down */
	0x8008, 0x8009,						/* Start, Select */
	0x800A, 0x800B,						/* A B */
	0x800C, 0x800D,						/* X Y */
	0x800E, 0x800F,						/* L R */
	0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0},
	{           						/* Joypad 3 default off */
	0, 0, 0, 0, 0, 0, 0, 0,							/* Left, Left_Up, Left_Down, Right, Right_Up, Right_Down, Up, Down */
	0, 0,								/* Start, Select */
	0, 0,								/* A B */
	0, 0,								/* X Y */
	0, 0,								/* L R */
	0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0},
	{           						/* Joypad 4 default off */
	0, 0, 0, 0, 0, 0, 0, 0,							/* Left, Left_Up, Left_Down, Right, Right_Up, Right_Down, Up, Down */
	0, 0,								/* Start, Select */
	0, 0,								/* A B */
	0, 0,								/* X Y */
	0, 0,								/* L R */
	0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0},
	{           						/* Joypad 5 default off */
	0, 0, 0, 0, 0, 0, 0, 0,							/* Left, Left_Up, Left_Down, Right, Right_Up, Right_Down, Up, Down */
	0, 0,								/* Start, Select */
	0, 0,								/* A B */
	0, 0,								/* X Y */
	0, 0,								/* L R */
	0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}
	};

static SJoypad *Joypad = JoypadA;

/* HIWORD == MF_xxxx Function number, LOWORD == button code */
DWORD FunctionCodeA[8] = {MF_TURBOPAUSEFWD << 16, MF_TURBO << 16, MF_XXX01 << 16, MF_XXX02 << 16,
						  MF_XXX03 << 16, MF_XXX04 << 16, MF_SSTURBO << 16, MF_SSPAUSE << 16};

DWORD FunctionCodeB[8] = {MF_TURBOPAUSEFWD << 16, MF_TURBO << 16, MF_XXX01 << 16, MF_XXX02 << 16,
						  MF_XXX03 << 16, MF_XXX04 << 16, MF_SSTURBO << 16, MF_SSPAUSE << 16};

static DWORD *FunctionCode = FunctionCodeA;

static bool8 FunctionCodePress;
static bool8 FunctionCodePressed;
static bool8 TurbofwdPressed[8];

static uint32 joypads [5];
static uint32 TurboStatus [5] = {~0, ~0, ~0, ~0, ~0};

void MakeTurboStatus()
{
	uint8 PadState[2];
	
	for (int J = 0; J < 5; J++) {
		if (Settings.JoystickConnected[J]) {
			TurboStatus[J] = ~0;
			PadState[0]  = 0;
			PadState[0] |= (Joypad[J].Turbo_R ? 16 : 0);
			PadState[0] |= (Joypad[J].Turbo_L ? 32 : 0);
			PadState[0] |= (Joypad[J].Turbo_X ? 64 : 0);
			PadState[0] |= (Joypad[J].Turbo_A ? 128 : 0);

			PadState[1]  = 0;
			PadState[1] |= (Joypad[J].Turbo_Right ? 1 : 0);
			PadState[1] |= (Joypad[J].Turbo_Left ? 2 : 0);
			PadState[1] |= (Joypad[J].Turbo_Down ? 4 : 0);
			PadState[1] |= (Joypad[J].Turbo_Up ? 8 : 0);
			PadState[1] |= (Joypad[J].Turbo_Start ? 16 : 0);
			PadState[1] |= (Joypad[J].Turbo_Select ? 32 : 0);
			PadState[1] |= (Joypad[J].Turbo_Y ? 64 : 0);
			PadState[1] |= (Joypad[J].Turbo_B ? 128 : 0);
			TurboStatus[J] ^= (PadState [0] | (PadState [1] << 8));
		}
		else
			TurboStatus[J] = ~0;
	}
}

void UosneswJoystickInit()
{
	GUI.DIuse = WinInputInitialize(GUI.hWnd, GUI.DIuse);
	Joypad = GUI.DIuse ? JoypadB : JoypadA;
	FunctionCode = GUI.DIuse ? FunctionCodeB : FunctionCodeA;
	MakeTurboStatus();
	return;
}

static BOOL S9xWinScanJoypads ()
{
	uint8 PadState[2];
	int i, J;
	
	GetKeybuttonStates();
	
	if(GUI.DIuse) {
		if(GetJoyKeybuttonState(DIK_LCONTROL) || GetJoyKeybuttonState(DIK_RCONTROL) ||
			GetJoyKeybuttonState(DIK_LSHIFT) || GetJoyKeybuttonState(DIK_RSHIFT) ||
			GetJoyKeybuttonState(DIK_LMENU) || GetJoyKeybuttonState(DIK_RMENU)) {

			for (J = 0; J < 5; J++) {
				if (Settings.JoystickConnected[J]) {
					joypads [J] = (uint32)0xFFFF0000;
				}
				else {
					joypads [J] = 0;
				}
			}
			return FALSE;
		}
	}
	else {
		if(GetJoyKeybuttonState(VK_CONTROL) || GetJoyKeybuttonState(VK_LCONTROL) || GetJoyKeybuttonState(VK_RCONTROL) ||
			GetJoyKeybuttonState(VK_SHIFT) || GetJoyKeybuttonState(VK_LSHIFT) || GetJoyKeybuttonState(VK_RSHIFT) ||
			GetJoyKeybuttonState(VK_MENU) || GetJoyKeybuttonState(VK_LMENU) || GetJoyKeybuttonState(VK_RMENU)) {

			for (J = 0; J < 5; J++) {
				if (Settings.JoystickConnected[J]) {
					joypads [J] = (uint32)0xFFFF0000;
				}
				else {
					joypads [J] = 0;
				}
			}
			return FALSE;
		}
	}
	
	GetJoybuttonStates();
	
	for (J = 0; J < 5; J++) {
		if (Settings.JoystickConnected[J]) {
			PadState[0]  = 0;
			PadState[0] |= GetJoyKeybuttonState (Joypad[J].R)      ?  16 : 0;
			PadState[0] |= GetJoyKeybuttonState (Joypad[J].L)      ?  32 : 0;
			PadState[0] |= GetJoyKeybuttonState (Joypad[J].X)      ?  64 : 0;
			PadState[0] |= GetJoyKeybuttonState (Joypad[J].A)      ? 128 : 0;

			PadState[1]  = 0;
			PadState[1] |= GetJoyKeybuttonState (Joypad[J].Right)  ?   1 : 0;
			PadState[1] |= GetJoyKeybuttonState (Joypad[J].Right_Up)  ? 1 + 8 : 0;
			PadState[1] |= GetJoyKeybuttonState (Joypad[J].Right_Down)? 1 + 4 : 0;
			PadState[1] |= GetJoyKeybuttonState (Joypad[J].Left)   ?   2 : 0;
			PadState[1] |= GetJoyKeybuttonState (Joypad[J].Left_Up)?   2 + 8 : 0;
			PadState[1] |= GetJoyKeybuttonState (Joypad[J].Left_Down)?  2 + 4 : 0;
			PadState[1] |= GetJoyKeybuttonState (Joypad[J].Down)   ?   4 : 0;
			PadState[1] |= GetJoyKeybuttonState (Joypad[J].Up)     ?   8 : 0;
			PadState[1] |= GetJoyKeybuttonState (Joypad[J].Start)  ?  16 : 0;
			PadState[1] |= GetJoyKeybuttonState (Joypad[J].Select) ?  32 : 0;
			PadState[1] |= GetJoyKeybuttonState (Joypad[J].Y)      ?  64 : 0;
			PadState[1] |= GetJoyKeybuttonState (Joypad[J].B)      ? 128 : 0;
			joypads [J] = (uint32)0xFFFF0000 | ((uint32)PadState [1] << 8) | PadState [0];
		}
		else
			joypads [J] = 0;
	}
	
	FunctionCodePress = FALSE;
	
	for(i = 0; i < 8; i++) {
		if(GetJoyKeybuttonState(LOWORD(FunctionCode[i]))) {
			if(!FunctionCodePress) {
				FunctionCodePress = TRUE;
				if(!FunctionCodePressed) {
					FunctionCodePressed = FunctionCodePress;
					TurbofwdPressed[i] = (HIWORD(FunctionCode[i]) == MF_TURBOPAUSEFWD);
					PostMessage (GUI.hWnd, WM_COMMAND, ID_FUNCTIONCODE, HIWORD(FunctionCode[i]));
					return TRUE;
				}
			}
		}
		else if(TurbofwdPressed[i] && HIWORD(FunctionCode[i]) == MF_TURBOPAUSEFWD) {
			TurbofwdPressed[i] = FALSE;
			FunctionCodePressed = FunctionCodePress;
			PostMessage (GUI.hWnd, WM_COMMAND, ID_FUNCTIONCODE, HIWORD(FunctionCode[i]));
			return TRUE;
		}
	}
	FunctionCodePressed = FunctionCodePress;
	return TRUE;
}

static uint32 JoyReadCount;

extern "C" uint32 S9xReadJoypad (int which1)
{
	if (which1 > 4)
		return 0;
	
	if(which1 == 0) {
		if((JoyReadCount & (uint32)Options.JoyReadRateMask) == Options.JoyReadRateMask)
			S9xWinScanJoypads();
		++JoyReadCount;
	}
	
	if(JoyReadCount & 1)
		return (joypads [which1]);
	else
		return (joypads [which1] & TurboStatus[which1]);
}

void UosneswReleaseInput()
{
	WinInputDeinitialize();
}

