#include "snes9x.h"
#include "ppu.h"
#include "uosnesw.h"
#include "windraw.h"
#include "uowdraw.h"
#include "render.h"

typedef struct {
	uint8 red;
	uint8 green;
	uint8 blue;
} Colour;

static Colour FixedColours [256];
static int color_diff [0x10000];
static PALETTEENTRY S9xPaletteEntry[256];
uint8 S9xwPalette [0x10000];

void S9xSetPalette( void)
{
    LPDIRECTDRAWPALETTE lpDDTemp;
    uint16 Brightness = IPPU_MaxBrightness * 140;

    // Only update the palette structures if needed
    if( GUI.ScreenDepth == 8)
    {
        if (Settings.SixteenBit)
        {
            for (int i = 0; i < 256; i++)
            {
                S9xPaletteEntry[i].peRed   = FixedColours [i].red;
                S9xPaletteEntry[i].peGreen = FixedColours [i].green;
                S9xPaletteEntry[i].peBlue  = FixedColours [i].blue;
            }
        }
        else
        {
            for (int i = 0; i < 256; i ++)
            {	
                S9xPaletteEntry[i].peRed   = (((PPU_CGDATA [i] >>  0) & 0x1F) * Brightness) >> 8;
                S9xPaletteEntry[i].peGreen = (((PPU_CGDATA [i] >>  5) & 0x1F) * Brightness) >> 8;
                S9xPaletteEntry[i].peBlue  = (((PPU_CGDATA [i] >> 10) & 0x1F) * Brightness) >> 8;
            }
        }
		DirectX.lpDDSPrimary2->GetPalette(&lpDDTemp);
		if(lpDDTemp != DirectX.lpDDPalette)
			DirectX.lpDDSPrimary2->SetPalette(DirectX.lpDDPalette);
        DirectX.lpDDPalette->SetEntries (0, 0, 256, S9xPaletteEntry);
    }
}

static BYTE ScreenBuffer[512*478*2];
static BYTE SubScreenBuffer[512*478*2];
static BYTE ZBuffer[512*478];
static BYTE SubZBuffer[512*478];

//static bool8 locked_surface = FALSE;
bool8 locked_surface = FALSE;
static SSurface Src, Dst;

static bool8 force_S9xDeinitUpdate = FALSE;

bool8 S9xInitUpdate( void)
{
    GFX.SubScreen = SubScreenBuffer;
    GFX.ZBuffer = ZBuffer;
    GFX.SubZBuffer = SubZBuffer;

    if (force_S9xDeinitUpdate == FALSE &&
		(GUI.Scale <= 1 ||
		 (DirectX.DisableHardwareScale == FALSE &&
		  ((GUI.Scale == 3 && IPPU.Interlace) ||
		   (GUI.Scale <= 7 && GUI.Scale >= 4 && (PPU.BGMode == 5 || PPU.BGMode == 6 || IPPU.Interlace)) ||
		   (GUI.Scale >= 8 && IPPU.Interlace)))) && 
		!GUI.NeedDepthConvert &&
        (DirectX.lpDDSOffScreen2 && LockSurface2 (DirectX.lpDDSOffScreen2, &Src))) {

        locked_surface = TRUE;

        GFX.RealPitch = GFX.Pitch2 = GFX.Pitch = Src.Pitch;
        GFX.Screen = Src.Surface;
	    DirectX.lpDDSOffScreen2->Unlock (Src.Surface);

		GFX.ZPitch = GFX.Pitch;
		if (Settings.SixteenBit)
			GFX.ZPitch >>= 1;
    }
    else
    {
        locked_surface = FALSE;
//        GFX.RealPitch = GFX.Pitch = 512 * 2;
//        GFX.Screen = ScreenBuffer;
		if (Settings.SixteenBit)
		{
			GFX.RealPitch = GFX.Pitch2 = GFX.Pitch = 512 * 2;
			GFX.ZPitch = GFX.Pitch;
			GFX.ZPitch >>= 1;
			GFX.Screen = ScreenBuffer;
		}
		else
		{
			GFX.RealPitch = GFX.Pitch2 = GFX.Pitch = 512;
			GFX.ZPitch = GFX.Pitch;
			GFX.Screen = ScreenBuffer;
			GFX.SubScreen = &ScreenBuffer[512*478];
		}
    }
    GFX.Delta = (GFX.SubScreen - GFX.Screen) >> 1;

    if (Settings.SixteenBit)
    {
        GFX.PPL = GFX.Pitch >> 1;
        GFX.PPLx2 = GFX.Pitch;
    }
    else
    {
        GFX.PPL = GFX.Pitch;
        GFX.PPLx2 = GFX.Pitch * 2;
    }
//    GFX.Pitchx2 = GFX.Pitch * 2;
    return (TRUE);
}

#define IS_DONT_RENDER()\
	(!DirectX.Windowed && ExtendHeight &&								\
	 (GUI.CurFullscreenDisplayModeIndex <= 1 ||							\
	  (GUI.Scale > 0 && (GUI.CurFullscreenDisplayModeIndex == 12 || GUI.CurFullscreenDisplayModeIndex == 13))))

#define RENDERED_EXIT(r)\
	GUI.SizeHistory [GUI.FlipCounter % DirectX.NumFlipFrames] = dstRect;\
	GUI.FlipCounter++;\
	return (r);

static inline void ClearRenderScreen(int w, int h)
{
	if(ExtendHeight_previos != ExtendHeight &&
	   !ExtendHeight && GUI.Stretch != 1 &&
	   (GUI.ClientRect.right - GUI.ClientRect.left) > 0 &&
	   (GUI.ClientRect.bottom - GUI.ClientRect.top) > h) {

		RECT clrRect;

		if(DirectX.Windowed) {
			HDC clrhdc;

			clrhdc = GetDC(GUI.hWnd);

			clrRect.top = 0;
			clrRect.bottom = ((GUI.ClientRect.bottom - GUI.ClientRect.top) - h) / 2;
			clrRect.left = GUI.ClientRect.left;
			clrRect.right = GUI.ClientRect.right;

			if((clrRect.bottom - clrRect.top) > 0)
				FillRect(clrhdc, &clrRect, (HBRUSH)GetStockObject(BLACK_BRUSH));

			clrRect.top = ((GUI.ClientRect.bottom - GUI.ClientRect.top) - h) / 2 + h;
			clrRect.bottom = GUI.ClientRect.bottom;
			clrRect.left = GUI.ClientRect.left;
			clrRect.right = GUI.ClientRect.right;

			if((clrRect.bottom - clrRect.top) > 0)
				FillRect(clrhdc, &clrRect, (HBRUSH)GetStockObject(BLACK_BRUSH));

			ReleaseDC(GUI.hWnd, clrhdc);
		}
		else {
			clrRect.top = 0;
			clrRect.bottom = ((GUI.ClientRect.bottom - GUI.ClientRect.top) - h) / 2;
			clrRect.left = GUI.ClientRect.left;
			clrRect.right = GUI.ClientRect.right;

			if((clrRect.bottom - clrRect.top) > 0) {
				DirectX_FillPrimarySurface(&clrRect);
				if(!DirectX.Windowed && DirectX.DoubleBuffered)
					DirectX_FillBackbufferSurface(&clrRect);
			}

			clrRect.top = ((GUI.ClientRect.bottom - GUI.ClientRect.top) - h) / 2 + h;
			clrRect.bottom = GUI.ClientRect.bottom;
			clrRect.left = GUI.ClientRect.left;
			clrRect.right = GUI.ClientRect.right;

			if((clrRect.bottom - clrRect.top) > 0) {
				DirectX_FillPrimarySurface(&clrRect);
				if(!DirectX.Windowed && DirectX.DoubleBuffered)
					DirectX_FillBackbufferSurface(&clrRect);
			}
		}
	}
}

static RECT srcRect = {0, 512, 0, 478};
static RECT dstRect = {0, 512, 0, 478};

BOOL GetRenderedRect(HWND hWnd, LPRECT lpRect)
{
	lpRect->top = dstRect.top;
	lpRect->left = dstRect.left;
	lpRect->bottom = dstRect.bottom;
	lpRect->right = dstRect.right;

	return 1;
}

bool8 S9xDeinitUpdate(int Width, int Height, bool8 sixteen_bit)
{
    LPDIRECTDRAWSURFACE2 lpDDSurface2 = NULL;
    bool PrimarySurfaceLockFailed = FALSE;
	static int update_method = 0;

	DisplayStatusInfo();

	if(IS_DONT_RENDER()) {
		RENDERED_EXIT(TRUE);
	}

	if(Options.DisplayScreenBufferAll && GUI.Scale > 0) {
		Width = 512;
		Height = 478;
	}
    Src.Width = Width;
    Src.Height = Height;
    Src.Pitch = GFX.RealPitch;
    Src.Surface = GFX.Screen;

	DoubleHeight = Src.Height > 240;
	DoubleWidth  = Src.Width == 512;
	ExtendHeight = Src.Height == 239 || Src.Height == 478;

	srcRect.top    = 0;
	srcRect.bottom = Height;
	srcRect.left   = 0;
	srcRect.right  = Width;

	bool8 clientrect_ok = (GUI.ClientRect.right - GUI.ClientRect.left) >= (GUI.Scale > 0 ? 512 : 256) &&
		(GUI.ClientRect.bottom - GUI.ClientRect.top) >= (GUI.Scale > 0 ? (ExtendHeight ? 478 : 448) : (ExtendHeight ? 239 : 224));

	// OffScreen has beed rendered image
	// It not needs render
	//
	// GUI.Scale <= 1 && !GUI.NeedDepthConvert
	//
    if (locked_surface &&
		(GUI.dRendering == FALSE || DirectX.lpDDClipper || GUI.Stretch > 0) &&
		(GUI.Scale <= 1 ||
		 (DirectX.DisableHardwareScale == FALSE &&
		  GUI.Scale >= 3))) {

		if(update_method != 0) {
			update_method = 0;
			ResetRenderMethod();
		}

		int dst_width, dst_height;
	    POINT p;

		// stretch
		if (GUI.Stretch == 1) {
			dst_width = (GUI.ClientRect.right - GUI.ClientRect.left);
			dst_height = (GUI.ClientRect.bottom - GUI.ClientRect.top);
			p.x = p.y = 0;
			ClientToScreen (GUI.hWnd, &p);
			dstRect.top = p.y;
			dstRect.left = p.x;
			dstRect.bottom = dstRect.top + dst_height;
			dstRect.right = dstRect.left + dst_width;
		}
		else if (GUI.Stretch == 2) {
			dst_width = srcRect.right - srcRect.left;
			dst_height = srcRect.bottom - srcRect.top;

			if (GUI.Scale > 0) {
			    // no Wx2 hires
			    if (dst_width < 257)
				    dst_width *= 2;
			    // no Hx2 hires
				if (dst_height < 240)
				    dst_height *= 2;
			}

			if((GUI.ClientRect.right - GUI.ClientRect.left) >= dst_width &&
				(GUI.ClientRect.bottom - GUI.ClientRect.top) >=
			   (dst_height * ((GUI.ClientRect.right - GUI.ClientRect.left) / dst_width))) {
				dst_width = 256;
				dst_height = ExtendHeight ? 239 : 224;
				long scalemulw = ((GUI.ClientRect.right - GUI.ClientRect.left) / dst_width);
				long scalemulh = ((GUI.ClientRect.bottom - GUI.ClientRect.top) / dst_height);
				long scalemul = scalemulw < scalemulh ? scalemulw : scalemulh;
				dst_width *= scalemul;
				p.x = ((GUI.ClientRect.right - GUI.ClientRect.left) - dst_width) / 2;
				dst_height *= scalemul;
				p.y = ((GUI.ClientRect.bottom - GUI.ClientRect.top) - dst_height) / 2;
			}
			else if((GUI.ClientRect.bottom - GUI.ClientRect.top) >= dst_height &&
				(GUI.ClientRect.right - GUI.ClientRect.left) >=
					(dst_width * ((GUI.ClientRect.bottom - GUI.ClientRect.top) / dst_height))) {
				dst_width = 256;
				dst_height = ExtendHeight ? 239 : 224;
				long scalemulw = ((GUI.ClientRect.right - GUI.ClientRect.left) / dst_width);
				long scalemulh = ((GUI.ClientRect.bottom - GUI.ClientRect.top) / dst_height);
				long scalemul = scalemulw < scalemulh ? scalemulw : scalemulh;
				dst_width *= scalemul;
				p.x = ((GUI.ClientRect.right - GUI.ClientRect.left) - dst_width) / 2;
				dst_height *= scalemul;
				p.y = ((GUI.ClientRect.bottom - GUI.ClientRect.top) - dst_height) / 2;
			}
			else {
				if((GUI.ClientRect.right - GUI.ClientRect.left) < dst_width) {
					p.x = 0;
					dst_width = GUI.ClientRect.right - GUI.ClientRect.left;
				}
				else {
					p.x = ((GUI.ClientRect.right - GUI.ClientRect.left) - dst_width) / 2;
				}
				if((GUI.ClientRect.bottom - GUI.ClientRect.top) < dst_height) {
					p.y = 0;
					dst_height = GUI.ClientRect.bottom - GUI.ClientRect.top;
				}
				else {
					p.y = ((GUI.ClientRect.bottom - GUI.ClientRect.top) - dst_height) / 2;
				}
			}

			ClientToScreen (GUI.hWnd, &p);
			dstRect.top = p.y;
			dstRect.left = p.x;
			dstRect.bottom = dstRect.top + dst_height;
			dstRect.right  = dstRect.left + dst_width;
		}
		else {
			dst_width = srcRect.right - srcRect.left;
			dst_height = srcRect.bottom - srcRect.top;

			if (GUI.Scale > 0) {
			    // no Wx2 hires
			    if (dst_width < 257)
				    dst_width *= 2;
			    // no Hx2 hires
				if (dst_height < 240)
				    dst_height *= 2;
			}
			p.x = ((GUI.ClientRect.right - GUI.ClientRect.left) - dst_width) / 2;
			p.y = ((GUI.ClientRect.bottom - GUI.ClientRect.top) - dst_height) / 2;
			ClientToScreen (GUI.hWnd, &p);

			dstRect.top = p.y;
			dstRect.left = p.x;
			dstRect.bottom = dstRect.top + dst_height;
			dstRect.right  = dstRect.left + dst_width;
		}

		ClearRenderScreen(dst_width, dst_height);
		ExtendHeight_previos = ExtendHeight;

		lpDDSurface2 = DirectX.lpDDSOffScreen2;
		lpDDSurface2->Unlock(Src.Surface);	

		bool8 _backbuffer;

		//fullscreen DoubleBuffered
		if(!DirectX.Windowed && DirectX.DoubleBuffered) {
		    _backbuffer = TRUE;
		    lpDDSurface2 = DirectX.lpDDSBack2;
		}
		else {
		    _backbuffer = FALSE;
		    lpDDSurface2 = DirectX.lpDDSPrimary2;
		}

		if(DirectX.wait_for_vsync && _backbuffer == FALSE)
			DirectX.lpDD->WaitForVerticalBlank(DDWAITVB_BLOCKBEGIN, 0);

		if (lpDDSurface2->Blt (&dstRect, DirectX.lpDDSOffScreen2, &srcRect, DDBLT_WAIT, NULL) != DD_OK) {
			RENDERED_EXIT(FALSE);
		}

		if(_backbuffer)
		    DirectX.lpDDSPrimary2->Flip(NULL, DDFLIP_WAIT);
    }
	//Directly Render to screen
	else if(force_S9xDeinitUpdate == FALSE &&
			clientrect_ok && !DirectX.lpDDClipper && GUI.dRendering && GUI.Stretch == 0) {

		if(update_method != 1) {
			update_method = 1;
			ResetRenderMethod();
		}

		int dst_width = srcRect.right - srcRect.left;
		int dst_height = srcRect.bottom - srcRect.top;

		if (GUI.Scale > 0) {
		    // no hires
			if (dst_width <= 256)
				dst_width *= 2;
			// no x2 height (??)
			if (dst_height < 240)
				dst_height *= 2;
		}

		POINT p;

		p.x = ((GUI.ClientRect.right - GUI.ClientRect.left) - dst_width) / 2;
		p.y = ((GUI.ClientRect.bottom - GUI.ClientRect.top) - dst_height) / 2;

		ClientToScreen (GUI.hWnd, &p);

		dstRect.top = p.y;
		dstRect.left = p.x;
		dstRect.bottom = dstRect.top + dst_height;
		dstRect.right  = dstRect.left + dst_width;

		bool8 _backbuffer;

		//fullscreen DoubleBuffered
		if(!DirectX.Windowed && DirectX.DoubleBuffered) {
		    _backbuffer = TRUE;
		    lpDDSurface2 = DirectX.lpDDSBack2;
			DirectX.NumFlipFrames = 2;
		}
		else {
		    _backbuffer = FALSE;
		    lpDDSurface2 = DirectX.lpDDSPrimary2;
			DirectX.NumFlipFrames = 1;
		}

		//before LockSurface2()
		SelectRenderMethod(TRUE);
		ClearRenderScreen(dst_width, dst_height);

		if (LockSurface2 (lpDDSurface2, &Dst) == FALSE) {
			ResetRenderMethod();
			RENDERED_EXIT(FALSE);
		}

		if(DirectX.wait_for_vsync && _backbuffer == FALSE)
			DirectX.lpDD->WaitForVerticalBlank(DDWAITVB_BLOCKBEGIN, 0);

		RenderMethod(&Src, &Dst, &srcRect, &dstRect);

		lpDDSurface2->Unlock(Dst.Surface);

		if(_backbuffer)
		    DirectX.lpDDSPrimary2->Flip(NULL, DDFLIP_WAIT);
	}
	// render offscreen & flip or blit
	else {

		if(update_method != 2) {
			update_method = 2;
			ResetRenderMethod();
		}

		int dst_width = srcRect.right - srcRect.left;
		int dst_height = srcRect.bottom - srcRect.top;

		bool8 _backbuffer;

		if(!DirectX.Windowed && DirectX.DoubleBuffered) {
		    _backbuffer = TRUE;
		}
		else {
		    _backbuffer = FALSE;
		}

		bool8 softwarescale;

		// hardware scale ?
		if(GUI.Stretch ||
		   GUI.Scale == 1 ||
		   (DirectX.DisableHardwareScale == FALSE &&
			(GUI.Scale == 3 ||
			 (GUI.Scale <= 7 && GUI.Scale >= 4 && (DoubleWidth ^ DoubleHeight)) ||
			 (GUI.Scale >= 8 && DoubleHeight == TRUE)))) {

			softwarescale = FALSE;

		    lpDDSurface2 = DirectX.lpDDSOffScreen2;
			DirectX.NumFlipFrames = 1;

			if (GUI.Scale == 2) {
			    // no hires
			    if (dst_width <= 256) {
				    dst_width *= 2;
				}
				// no x2 height (??)
				if (dst_height < 240) {
				    dst_height *= 2;
				}
			}
			else if (GUI.Scale == 3 && DoubleHeight == FALSE) {
			    dst_height *= 2;
			}
			else if (GUI.Scale <= 7 && GUI.Scale >= 4 &&
					 DoubleWidth == FALSE && DoubleHeight == FALSE) {
				dst_width *= 2;
				dst_height *= 2;
			}
			else if (GUI.Scale >= 8 && DoubleHeight == FALSE) {
			    // no hires
			    if (dst_width <= 256) {
				    dst_width *= 2;
				}
			    dst_height *= 2;
			}
		}
		// No hardware scale
		else {
			softwarescale = TRUE;

		    if(_backbuffer) {
			    lpDDSurface2 = DirectX.lpDDSBack2;
				DirectX.NumFlipFrames = 2;
			}
			else {
			    lpDDSurface2 = DirectX.lpDDSOffScreen2;
				DirectX.NumFlipFrames = 1;
			}
			if (GUI.Scale > 0) {
			    // no hires
			    if (dst_width <= 256) {
				    dst_width *= 2;
				}
				// no x2 height (??)
				if (dst_height < 240) {
				    dst_height *= 2;
				}
			}
		}

		// DoubleBuffer
		if(_backbuffer && lpDDSurface2 == DirectX.lpDDSBack2) {

			ClearRenderScreen(dst_width, dst_height);

			if (LockSurface2 (lpDDSurface2, &Dst) == FALSE) {
				ResetRenderMethod();
				RENDERED_EXIT(FALSE);
			}

			dstRect.top = (Dst.Height - dst_height) / 2;
			dstRect.left = (Dst.Width - dst_width) / 2;
			dstRect.bottom = dstRect.top + dst_height;
			dstRect.right = dstRect.left + dst_width;

			SelectRenderMethod(softwarescale);
			RenderMethod(&Src, &Dst, &srcRect, &dstRect);
			lpDDSurface2->Unlock(Dst.Surface);

		    DirectX.lpDDSPrimary2->Flip(NULL, DDFLIP_WAIT);
			RENDERED_EXIT(TRUE);
		}

		if (LockSurface2 (lpDDSurface2, &Dst) == FALSE) {
			ResetRenderMethod();
			RENDERED_EXIT(FALSE);
		}

		dstRect.top = (Dst.Height - dst_height) / 2;
		dstRect.left = (Dst.Width - dst_width) / 2;
		dstRect.bottom = dstRect.top + dst_height;
		dstRect.right = dstRect.left + dst_width;

		SelectRenderMethod(softwarescale);
		bool8 ep = ExtendHeight_previos;
		RenderMethod(&Src, &Dst, &srcRect, &dstRect);
		ExtendHeight_previos = ep;
		lpDDSurface2->Unlock(Dst.Surface);

		// OffScreen -> Primary
		Src = Dst;
		srcRect = dstRect;

	    POINT p;
		// stretch
		if (GUI.Stretch == 1) {
			dst_width = (GUI.ClientRect.right - GUI.ClientRect.left);
			dst_height = (GUI.ClientRect.bottom - GUI.ClientRect.top);
			p.x = p.y = 0;
			ClientToScreen (GUI.hWnd, &p);
			dstRect.top = p.y;
			dstRect.left = p.x;
			dstRect.bottom = dstRect.top + dst_height;
			dstRect.right = dstRect.left + dst_width;
		}
		else if (GUI.Stretch == 2) {
			dst_width = srcRect.right - srcRect.left;
			dst_height = srcRect.bottom - srcRect.top;

			if (GUI.Scale > 0) {
			    // no Wx2 hires
			    if (dst_width < 257)
				    dst_width *= 2;
			    // no Hx2 hires
				if (dst_height < 240)
				    dst_height *= 2;
			}

			if((GUI.ClientRect.right - GUI.ClientRect.left) >= dst_width &&
				(GUI.ClientRect.bottom - GUI.ClientRect.top) >=
			   (dst_height * ((GUI.ClientRect.right - GUI.ClientRect.left) / dst_width))) {
				dst_width = 256;
				dst_height = ExtendHeight ? 239 : 224;
				long scalemulw = ((GUI.ClientRect.right - GUI.ClientRect.left) / dst_width);
				long scalemulh = ((GUI.ClientRect.bottom - GUI.ClientRect.top) / dst_height);
				long scalemul = scalemulw < scalemulh ? scalemulw : scalemulh;
				dst_width *= scalemul;
				p.x = ((GUI.ClientRect.right - GUI.ClientRect.left) - dst_width) / 2;
				dst_height *= scalemul;
				p.y = ((GUI.ClientRect.bottom - GUI.ClientRect.top) - dst_height) / 2;
			}
			else if((GUI.ClientRect.bottom - GUI.ClientRect.top) >= dst_height &&
				(GUI.ClientRect.right - GUI.ClientRect.left) >=
					(dst_width * ((GUI.ClientRect.bottom - GUI.ClientRect.top) / dst_height))) {
				dst_width = 256;
				dst_height = ExtendHeight ? 239 : 224;
				long scalemulw = ((GUI.ClientRect.right - GUI.ClientRect.left) / dst_width);
				long scalemulh = ((GUI.ClientRect.bottom - GUI.ClientRect.top) / dst_height);
				long scalemul = scalemulw < scalemulh ? scalemulw : scalemulh;
				dst_width *= scalemul;
				p.x = ((GUI.ClientRect.right - GUI.ClientRect.left) - dst_width) / 2;
				dst_height *= scalemul;
				p.y = ((GUI.ClientRect.bottom - GUI.ClientRect.top) - dst_height) / 2;
			}
			else {
				if((GUI.ClientRect.right - GUI.ClientRect.left) < dst_width) {
					p.x = 0;
					dst_width = GUI.ClientRect.right - GUI.ClientRect.left;
				}
				else {
					p.x = ((GUI.ClientRect.right - GUI.ClientRect.left) - dst_width) / 2;
				}
				if((GUI.ClientRect.bottom - GUI.ClientRect.top) < dst_height) {
					p.y = 0;
					dst_height = GUI.ClientRect.bottom - GUI.ClientRect.top;
				}
				else {
					p.y = ((GUI.ClientRect.bottom - GUI.ClientRect.top) - dst_height) / 2;
				}
			}

			ClientToScreen (GUI.hWnd, &p);
			dstRect.top = p.y;
			dstRect.left = p.x;
			dstRect.bottom = dstRect.top + dst_height;
			dstRect.right  = dstRect.left + dst_width;
		}
		else {
			dst_width = srcRect.right - srcRect.left;
			dst_height = srcRect.bottom - srcRect.top;

			if (GUI.Scale > 0) {
			    // no Wx2 hires
			    if (dst_width < 257)
				    dst_width *= 2;
			    // no Hx2 hires
				if (dst_height < 240)
				    dst_height *= 2;
			}
			p.x = ((GUI.ClientRect.right - GUI.ClientRect.left) - dst_width) / 2;
			p.y = ((GUI.ClientRect.bottom - GUI.ClientRect.top) - dst_height) / 2;

			ClientToScreen (GUI.hWnd, &p);

			dstRect.top = p.y;
			dstRect.left = p.x;
			dstRect.bottom = dstRect.top + dst_height;
			dstRect.right  = dstRect.left + dst_width;
		}

		ClearRenderScreen(dst_width, dst_height);
		ExtendHeight_previos = ExtendHeight;

		//fullscreen DoubleBuffered
		if(_backbuffer) {
		    lpDDSurface2 = DirectX.lpDDSBack2;
		}
		else {
		    lpDDSurface2 = DirectX.lpDDSPrimary2;
		}

		if(DirectX.wait_for_vsync && _backbuffer == FALSE)
			DirectX.lpDD->WaitForVerticalBlank(DDWAITVB_BLOCKBEGIN, 0);

		if (lpDDSurface2->Blt (&dstRect, DirectX.lpDDSOffScreen2, &srcRect, DDBLT_WAIT, NULL) != DD_OK) {
			RENDERED_EXIT(FALSE);
		}

		if(_backbuffer)
		    DirectX.lpDDSPrimary2->Flip(NULL, DDFLIP_WAIT);
	}	
	RENDERED_EXIT(TRUE);
	// END
}

void UosneswScreenRedraw(HWND hWnd)
{
	if(!DirectX.DDAvailable || !DirectX.Windowed)
		return;

	RefreshRectParams();

	PAINTSTRUCT ps;
	HDC hdc = BeginPaint(hWnd, &ps);
	EndPaint(hWnd, &ps);

	unsigned char GUI_dRendering_bak = GUI.dRendering;
	GUI.dRendering = FALSE;
	force_S9xDeinitUpdate = TRUE;

	// screenbuffer == OffScreen
	if(locked_surface) {
		locked_surface = FALSE;
		uint8 *sb = ScreenBuffer;
		for(int y = 0; y < IPPU.RenderedScreenHeight; y++)
			memcpy(sb + y * (512 * (Settings.SixteenBit ? 2 : 1)), GFX.Screen + y * GFX.Pitch,
				   IPPU.RenderedScreenWidth * (Settings.SixteenBit ? 2 : 1));
	}
	S9xInitUpdate();

	int width = 256 * (DoubleWidth ? 2 : 1);
	int height = (ExtendHeight ? 239 : 224) * (DoubleHeight ? 2 : 1);

	S9xDeinitUpdate(width, height, Settings.SixteenBit);
	force_S9xDeinitUpdate = FALSE;
	GUI.dRendering = GUI_dRendering_bak;
	return;
}

static int ffs (uint32 mask)
{
    int m = 0;
    if (mask)
    {
        while (!(mask & (1 << m)))
            m++;

        return (m);
    }

    return (0);
}

void S9xSetWinPixelFormat ()
{
    extern int Init_2xSaI (uint32 BitFormat);
	extern void hq2x_init(unsigned);

    S9xSetRenderPixelFormat (RGB565);
    Init_2xSaI (565);
	hq2x_init(16);
    GUI.NeedDepthConvert = FALSE;

#if 0
    if (VOODOO_MODE)
    {
        GUI.ScreenDepth = 16;
        GUI.RedShift = 0;
        GUI.GreenShift = 5;
        GUI.BlueShift = 11;
        Settings.SixteenBit = TRUE;
    }
    else
    if (OPENGL_MODE)
    {
        GUI.ScreenDepth = 16;
        GUI.RedShift = 0;
        GUI.GreenShift = 5;
        GUI.BlueShift = 11;
        Settings.SixteenBit = TRUE;
    }
    else
    {
#endif
        GUI.ScreenDepth = DirectX.DDPixelFormat.dwRGBBitCount;
        if (GUI.ScreenDepth == 15)
            GUI.ScreenDepth = 16;

        GUI.RedShift = ffs (DirectX.DDPixelFormat.dwRBitMask);
        GUI.GreenShift = ffs (DirectX.DDPixelFormat.dwGBitMask);
        GUI.BlueShift = ffs (DirectX.DDPixelFormat.dwBBitMask);

        if((DirectX.DDPixelFormat.dwFlags&DDPF_RGB) != 0 &&
           GUI.ScreenDepth == 16 &&
           DirectX.DDPixelFormat.dwRBitMask == 0xF800 &&
           DirectX.DDPixelFormat.dwGBitMask == 0x07E0 &&
           DirectX.DDPixelFormat.dwBBitMask == 0x001F)
        {
			GUI.GreenShift += 1;
            S9xSetRenderPixelFormat (RGB565);
            Init_2xSaI (565);
			hq2x_init(16);
        }
        else
            if( (DirectX.DDPixelFormat.dwFlags&DDPF_RGB) != 0 &&
                GUI.ScreenDepth == 16 &&
                DirectX.DDPixelFormat.dwRBitMask == 0x7C00 &&
                DirectX.DDPixelFormat.dwGBitMask == 0x03E0 &&
                DirectX.DDPixelFormat.dwBBitMask == 0x001F)
            {
                S9xSetRenderPixelFormat (RGB555);
                Init_2xSaI (555);
				hq2x_init(15);
            }
            else
                if((DirectX.DDPixelFormat.dwFlags&DDPF_RGB) != 0 &&
                   GUI.ScreenDepth == 16 &&
                   DirectX.DDPixelFormat.dwRBitMask == 0x001F &&
                   DirectX.DDPixelFormat.dwGBitMask == 0x07E0 &&
                   DirectX.DDPixelFormat.dwBBitMask == 0xF800)
                {
					GUI.GreenShift += 1;
                    S9xSetRenderPixelFormat (BGR565);
                    Init_2xSaI (565);
					hq2x_init(16);
                }
                else
                    if( (DirectX.DDPixelFormat.dwFlags&DDPF_RGB) != 0 &&
                        GUI.ScreenDepth == 16 &&
                        DirectX.DDPixelFormat.dwRBitMask == 0x001F &&
                        DirectX.DDPixelFormat.dwGBitMask == 0x03E0 &&
                        DirectX.DDPixelFormat.dwBBitMask == 0x7C00)
                    {
                        S9xSetRenderPixelFormat (BGR555);
                        Init_2xSaI (555);
						hq2x_init(15);
                    }
                    else
                        if (DirectX.DDPixelFormat.dwRGBBitCount == 8 ||
                            DirectX.DDPixelFormat.dwRGBBitCount == 24 ||
                            DirectX.DDPixelFormat.dwRGBBitCount == 32)
                        {
                            S9xSetRenderPixelFormat (RGB565);
                            Init_2xSaI (565);
							hq2x_init(16);
                        }
        
        if (
#if 0
            !VOODOO_MODE &&
            !OPENGL_MODE &&
            (
#endif
             (GUI.ScreenDepth == 8 && Settings.SixteenBit) ||
             (GUI.ScreenDepth == 16 && !Settings.SixteenBit) ||
             (GUI.ScreenDepth == 24 || GUI.ScreenDepth == 32))
            GUI.NeedDepthConvert = TRUE;
        
        if (Settings.SixteenBit && 
            (GUI.ScreenDepth == 24 || GUI.ScreenDepth == 32))
        {
            GUI.RedShift += 3;
            GUI.GreenShift += 3;
            GUI.BlueShift += 3;
        }
#if 0
    }
#endif

    int l = 0;
    int i;

    for (i = 0; i < 6; i++)
    {
	int r = (i * 31) / (6 - 1);
	for (int j = 0; j < 6; j++)
	{
	    int g = (j * 31) / (6 - 1);
	    for (int k = 0; k < 6; k++)
	    { 
		int b = (k * 31) / (6 - 1);

		FixedColours [l].red = r << 3;
		FixedColours [l].green = g << 3;
		FixedColours [l++].blue = b << 3;
	    }
	}
    }

    //int *color_diff = new int [0x10000];
    int diffr, diffg, diffb, maxdiff = 0, won = 0, lost;
    int r, d = 8;
    for (r = 0; r <= (int) MAX_RED; r++)
    {
	int cr, g, q;
      
	int k = 6 - 1;
	cr = (r * k) / MAX_RED;
	q  = (r * k) % MAX_RED;
	if (q > d && cr < k) 
	    cr++;
	diffr = abs (cr * k - r);
	for (g = 0; g <= (int) MAX_GREEN; g++)
	{
	    int cg, b;
	  
	    k  = 6 - 1;
	    cg = (g * k) / MAX_GREEN;
	    q  = (g * k) % MAX_GREEN;
	    if(q > d && cg < k)
		cg++;
	    diffg = abs (cg * k - g);
	    for (b = 0; b <= (int) MAX_BLUE; b++) 
	    {
		int cb;
		int rgb = BUILD_PIXEL2(r, g, b);

		k  = 6 - 1;
		cb = (b * k) / MAX_BLUE;
		q  = (b * k) % MAX_BLUE;
		if (q > d && cb < k)
		    cb++;
		diffb = abs (cb * k - b);
		S9xwPalette[rgb] = (cr * 6 + cg) * 6 + cb;
		color_diff[rgb] = diffr + diffg + diffb;
		if (color_diff[rgb] > maxdiff)
		    maxdiff = color_diff[rgb];
	    }
	}
    }

    while (maxdiff > 0 && l < 256)
    {
	int newmaxdiff = 0;
	lost = 0; won++;
	for (r = MAX_RED; r >= 0; r--)
	{
	    int g;
      
	    for (g = MAX_GREEN; g >= 0; g--)
	    {
		int b;
	  
		for (b = MAX_BLUE; b >= 0; b--) 
		{
		    int rgb = BUILD_PIXEL2(r, g, b);

		    if (color_diff[rgb] == maxdiff)
		    {
			if (l >= 256)
			    lost++;
			else
			{
			    FixedColours [l].red = r << 3;
			    FixedColours [l].green = g << 3;
			    FixedColours [l].blue = b << 3;
			    S9xwPalette [rgb] = l++;
			}
			color_diff[rgb] = 0;
		    }
		    else
			if (color_diff[rgb] > newmaxdiff)
			    newmaxdiff = color_diff[rgb];
		    
		}
	    }
	}
	maxdiff = newmaxdiff;
    }
    free (color_diff);
	RenderInit();
}

void UosneswScreenInit()
{
	if(ScreenBuffer)
		FillMemory ((PVOID)ScreenBuffer, 512*478*2, 0);

	if(SubScreenBuffer)
		FillMemory ((PVOID)SubScreenBuffer, 512*478*2, 0);

	if(ZBuffer)
		FillMemory ((PVOID)ZBuffer, 512*478, 0);

	if(SubZBuffer)
		FillMemory ((PVOID)SubZBuffer, 512*478, 0);

	DirectX_ClearOffscreenSurface();

	//for clear filter log
	ResetRenderMethod();
	RenderInit();
}

