#ifdef HAVE_CONFIG_H
#  include <config.h>
#endif

#include "snes9x.h"
#include "memmap.h"
#include "soundux.h"
#include "uosnesw.h"
#include "windraw.h"
#include "uowinput.h"
#include "explorer.h"
#include <io.h>
#include <direct.h>
#include "cfgfile.h"
#include "commutil.h"

extern char ROMFileName[];
extern char InitialROMFileDirectory[];
extern char RecentROMFileName[];
extern OPENFILENAMEEXPLORERPOS uosxplorerposition;

static void ChangeWinHomeDirectory(char *fn, const char *hname, const char *last_hname, int bufsize)
{
	int len = (int)strlen(hname);
	int last_len = (int)strlen(last_hname);

    char drive [_MAX_DRIVE + 1];
    char dir [_MAX_DIR + 1];
    char fname [_MAX_FNAME + 1];
    char ext [_MAX_EXT + 1];

	int slash_len;

	_splitpath(hname, drive, dir, fname, ext);
	if(dir[0] && fname[0] == 0)
		slash_len = 1;
	else
		slash_len = 0;

	_splitpath(last_hname, drive, dir, fname, ext);
	if(dir[0] && fname[0] == 0) {
		if(slash_len == 1)
			slash_len = 0;
		else
			slash_len = -1;
	}

	if(last_len < bufsize && strncmp(fn, last_hname, (size_t)last_len) == 0 && ((int)strlen(fn) + len - slash_len - last_len) < bufsize) {
		memmove(&fn[len], &fn[last_len + slash_len], (size_t)(strlen(fn) - (last_len + slash_len) + 1));
		memcpy(&fn[0], hname, (size_t)len);
	}
}

void read_port_config()
{
    char drive [_MAX_DRIVE + 1];
    char dir [_MAX_DIR + 1];
    char fname [_MAX_FNAME + 1];
    char ext [_MAX_EXT + 1];
	char tmpCharBuf[_MAX_PATH + 1];
	char *tmpcharptr;
	int i;

	/* Read [windows] */
	i = get_config_int(1, cs.windows, "PriorityClass");
	switch(i) {
	case 0: GUI.PriorityClass = IDLE_PRIORITY_CLASS; break;
	case 1: GUI.PriorityClass = NORMAL_PRIORITY_CLASS; break;
	case 2: GUI.PriorityClass = HIGH_PRIORITY_CLASS; break;
	case 3: GUI.PriorityClass = REALTIME_PRIORITY_CLASS; break;
	default: GUI.PriorityClass = NORMAL_PRIORITY_CLASS; break;
	}
	
	i = get_config_int(2, cs.windows, "ThreadPriority");
	switch(i) {
	case 0: GUI.ThreadPriority = THREAD_PRIORITY_LOWEST; break;
	case 1: GUI.ThreadPriority = THREAD_PRIORITY_BELOW_NORMAL; break;
	case 2: GUI.ThreadPriority = THREAD_PRIORITY_NORMAL; break;
	case 3: GUI.ThreadPriority = THREAD_PRIORITY_ABOVE_NORMAL; break;
	case 4: GUI.ThreadPriority = THREAD_PRIORITY_HIGHEST; break;
	case 5: GUI.ThreadPriority = THREAD_PRIORITY_IDLE; break;
	case 6: GUI.ThreadPriority = THREAD_PRIORITY_TIME_CRITICAL; break;
	default: GUI.ThreadPriority = THREAD_PRIORITY_NORMAL; break;
	}

	GUI.WindowTopMost = (unsigned char)get_config_int((int)GUI.WindowTopMost, cs.windows, "WindowTopMost");
	Options.inactive_x = (u8)get_config_int((int)Options.inactive_x, cs.windows, "Inactive_X");

	/* Read [graphics] */
	i = get_config_int((int)GUI.FullScreen, cs.graphics, "Fullscreen");
	GUI.FullScreen = (i ? 1 : 0);
	GUI.DoubleRendering = (unsigned char)get_config_int((int)GUI.DoubleRendering, cs.graphics, "DoubleRendering");
	i = get_config_int(GUI.FullscreenDisplayModeIndexNormal16, cs.graphics, "FullscreenDisplayModeIndexNormal16");
	GUI.FullscreenDisplayModeIndexNormal16 = ((i >= 0 && i <= 27) ? i : GUI.FullscreenDisplayModeIndexNormal16);
	i = get_config_int(GUI.FullscreenDisplayModeIndexDouble16, cs.graphics, "FullscreenDisplayModeIndexDouble16");
	GUI.FullscreenDisplayModeIndexDouble16 = ((i >= 12 && i <= 27) ? i : GUI.FullscreenDisplayModeIndexDouble16);
	i = get_config_int(GUI.FullscreenDisplayModeIndexNormal8, cs.graphics, "FullscreenDisplayModeIndexNormal8");
	GUI.FullscreenDisplayModeIndexNormal8 = ((i >= 0 && i <= 27) ? i : GUI.FullscreenDisplayModeIndexNormal8);
	i = get_config_int(GUI.FullscreenDisplayModeIndexDouble8, cs.graphics, "FullscreenDisplayModeIndexDouble8");
	GUI.FullscreenDisplayModeIndexDouble8 = ((i >= 12 && i <= 27) ? i : GUI.FullscreenDisplayModeIndexDouble8);
	i = get_config_int(GUI.DoubleRenderingModes16, cs.graphics, "DoubleRenderingModes16");
	GUI.DoubleRenderingModes16 = ((i >= 1 && i <= 10) ? i : GUI.DoubleRenderingModes16);
	i = get_config_int(GUI.DoubleRenderingModes8, cs.graphics, "DoubleRenderingModes8");
	GUI.DoubleRenderingModes8 = ((i >= 1 && i <= 3) ? i : GUI.DoubleRenderingModes8);
	DirectX.DisableHardwareScale = (unsigned char)get_config_int((int)DirectX.DisableHardwareScale, cs.graphics, "DisableHardwareScale");
	GUI.dRendering = (unsigned char)get_config_int((int)GUI.dRendering, cs.graphics, "DirectScreenRendering");
	i = get_config_int((int)GUI.DoubleBuffered, cs.graphics, "DoubleBuffering");
	GUI.DoubleBuffered = i ? 1 : 0;
	GUI.ForceWindowedDirectDrawClipper = (unsigned char)get_config_int((int)GUI.ForceWindowedDirectDrawClipper,
																	   cs.graphics,
																	   "ForceWindowedDirectDrawClipper");
	i = get_config_int((int)DirectX.OffScreenVRAM, cs.graphics, "OffScreenVRAM");
	DirectX.OffScreenVRAM = i ? 1 : 0;
	i = get_config_int((int)DirectX.BackBufferVRAM, cs.graphics, "BackBufferVRAM");
	DirectX.BackBufferVRAM = i ? 1 : 0;
	Settings.GFXengine2 = (bool8)get_config_int((int)Settings.GFXengine2, cs.graphics, "GFXengine2");
	Settings.SixteenBit = (bool8)get_config_int((int)Settings.SixteenBit, cs.graphics, "RenderSixteenBit");

	i = get_config_int((int)Settings.ForceTransparency, cs.graphics, "Transparency");
	if (i == 0) {
		Settings.ForceTransparency = 0;
		Settings.ForceNoTransparency = 1;
	}
	else {
		Settings.ForceTransparency = 1;
		Settings.ForceNoTransparency = 0;
	}

	Settings.BGLayering = (bool8)get_config_int((int)Settings.BGLayering, cs.graphics, "BGLayering");
	Settings.DisableGraphicWindows = (bool8)get_config_int((int)Settings.DisableGraphicWindows, cs.graphics, "DisableGraphicWindows");
	Settings.DisableHDMA = (bool8)get_config_int((int)Settings.DisableHDMA, cs.graphics, "DisableHDMA");
	Settings.Mode7Interpolate = (bool8)get_config_int((int)Settings.Mode7Interpolate, cs.graphics, "Mode7Interpolate");
	GUI.SupportHiRes = (unsigned char)get_config_int((int)GUI.SupportHiRes, cs.graphics, "hires");

	i = get_config_int((int)DirectX.wait_for_vsync, cs.graphics, "wait_for_vsync");
	DirectX.wait_for_vsync = i ? 1 : 0;
	i = get_config_int((int)GUI.Stretch, cs.graphics, "stretch");
	GUI.Stretch = (i >= 0 && i <= 2) ? i : GUI.Stretch;

	/* Read [sound] */
	GUI.DSuse = (BOOL)get_config_int((int)GUI.DSuse, cs.sound, "DirectSound");
	GUI.DirectSoundNotify = (BOOL)get_config_int((int)GUI.DirectSoundNotify, cs.sound, "DirectSoundNotify");
	Settings.NextAPUEnabled = (bool8)get_config_int((int)Settings.NextAPUEnabled, cs.sound, "APUEnabled");

	i = get_config_int(Options.SoundRate, cs.sound, "SoundRate");
	Options.SoundRate = (char)((0 <= i && i <= 5) ? i : Options.SoundRate);

	i = get_config_int(1, cs.sound, "SoundBit");
	switch(i) {
	case 0: Options.SoundBit = 8; break;
	case 1: Options.SoundBit = 16; break;
	default: Options.SoundBit = DefaultOptions.SoundBit; break;
	}

	i = get_config_int(1, cs.sound, "Stereo");
	switch(i) {
	case 0: Options.SoundChn = 1; break;
	case 1: Options.SoundChn = 2; break;
	default: Options.SoundChn = DefaultOptions.SoundChn; break;
	}

	i = get_config_int(Settings.InterpolatedSound, cs.sound, "InterpolatedSound");
	Settings.InterpolatedSound = (0 <= i && i <= 3) ? i : Settings.InterpolatedSound;
	//Settings.LowPassFilter = (bool8)get_config_int((int)Settings.LowPassFilter, cs.sound, "LowPassFilter");
	//Settings.SimpleFilter = (bool8)get_config_int((int)Settings.SimpleFilter, cs.sound, "SimpleFilter");
	i = get_config_int((int)Settings.SoundBufferSize, cs.sound, "SoundBufferLength");
	Settings.SoundBufferSize = (i >= 2 && i <= 9) ? i : Settings.SoundBufferSize;
	i = get_config_int(Settings.SoundMixInterval, cs.sound, "SoundMixInterval");
	Settings.SoundMixInterval = (i >= 1 && i <= 999) ? i : Settings.SoundMixInterval;
	GUI.SoundGlobalFocus = (BOOL)get_config_int((int)GUI.SoundGlobalFocus, cs.sound, "SoundGlobalFocus");
	Settings.SoundEnvelopeHeightReading = (bool8)get_config_int((int)Settings.SoundEnvelopeHeightReading,
																cs.sound,
																"SoundEnvelopeHeightReading");
	Settings.DisableSoundEcho = (bool8)get_config_int((int)Settings.DisableSoundEcho, cs.sound, "DisableSoundEcho");
	Settings.DisableMasterVolume = (bool8)get_config_int((int)Settings.DisableMasterVolume, cs.sound, "DisableMasterVolume");
	i = get_config_int(Options.VolumeLevel, cs.sound, "VolumeLevel");
	Options.VolumeLevel = (i >= 1 && i <= 5) ? i : Options.VolumeLevel;
#if 0
	Settings.DisableSampleCaching = (bool8)get_config_int((int)Settings.DisableSampleCaching, cs.sound, "DisableSampleCaching");
	i = get_config_int((int)Settings.AltSampleDecode, cs.sound, "SampleDecodingMethod");
	Settings.AltSampleDecode = (uint8)((0 <= i && i <= 5) ? i : Settings.AltSampleDecode);
#endif
	Settings.ShutdownMaster = (bool8)!get_config_int((int)!Settings.ShutdownMaster, cs.sound, "Shutdown");
	i = get_config_int((int)Settings.SoundSkipMethod, cs.sound, "SoundSkipMethod");
	Settings.SoundSkipMethod = (uint8)((i >= 0 && i <= 3) ? i : Settings.SoundSkipMethod);
	Settings.SoundSync = (uint8)get_config_int((int)Settings.SoundSync, cs.sound, "SoundSync");
	Settings.ReverseStereo = (uint8)get_config_int((int)Settings.ReverseStereo, cs.sound, "ReverseStereo");
#if 0
	Settings.FixFrequency = (bool8)get_config_int((int)Settings.FixFrequency, cs.sound, "FixFrequency");
#endif

	/* Read [cpu] */
	i = get_config_int(Settings.CyclesPercentage, cs.cpu, "CyclesPercentage");
	Settings.CyclesPercentage = (i > 0 && i < 200) ? i : Settings.CyclesPercentage;

	/* Read [timer] */
	i = get_config_int((int)(Settings.SkipFrames == AUTO_FRAMERATE ?
							 AUTO_FRAMERATE : (Settings.SkipFrames - 1)), cs.timer, "SkipFrames");
	if(i != AUTO_FRAMERATE && i >= 0 && i <= 9)
		Settings.SkipFrames = (uint32)i + 1;
	else
		Settings.SkipFrames = AUTO_FRAMERATE;
	i = get_config_int((int)Settings.AutoMaxSkipFrames, cs.timer, "AutoMaxSkipFrames");
	Settings.AutoMaxSkipFrames = (uint32)((i >= 0 && i <= 10) ? i : Settings.AutoMaxSkipFrames);
	i = get_config_int((int)Settings.TurboSkipFrames, cs.timer, "TurboSkipFrames");
	Settings.TurboSkipFrames = (uint32)((i >= 0 && i <= 15) ? i : Settings.TurboSkipFrames);
	Settings.FrameTimeNTSC = (uint32)get_config_int((int)Settings.FrameTimeNTSC, cs.timer, "NTSCtiming");
	Settings.FrameTimePAL = (uint32)get_config_int((int)Settings.FrameTimePAL, cs.timer, "PALtiming");

	/* Read [FileDirectory] */
	tmpcharptr = get_config_string(cs.filedirectory, "HomeDirectory");

	if(tmpcharptr[0] && strlen((const char *)tmpcharptr) < 1024)
		strcpy(Options.LastHomeDirectory, (const char *)tmpcharptr);

	if(strcmp(Options.HomeDirectory, Options.LastHomeDirectory) == 0)
		Options.HomeDirectoryMoved = FALSE;
	else
		Options.HomeDirectoryMoved = TRUE;

	tmpcharptr = get_config_string(cs.filedirectory, "LastROMFileName");
	if(tmpcharptr[0]) {
		strcpy(ROMFileName, tmpcharptr);
	}
	_splitpath(ROMFileName, drive, dir, fname, ext);
	_makepath(InitialROMFileDirectory, drive, dir, NULL, NULL);

	strcpy(tmpCharBuf, "RecentROMFileName1");
	for(i = 0; i < 10; i++) {
		sprintf(&tmpCharBuf[17], "%X", i + 1);
		tmpcharptr = get_config_string(cs.filedirectory, (const char *)tmpCharBuf);
		if(tmpcharptr[0] && strlen(tmpcharptr) < _MAX_PATH)
			strcpy(&RecentROMFileName[_MAX_PATH * i], tmpcharptr);
		else
			RecentROMFileName[_MAX_PATH * i] = 0;
	}

	tmpcharptr = get_config_string(cs.filedirectory, "SnapShotDirectory");
	if(tmpcharptr[0] && strlen((const char *)tmpcharptr) < _MAX_PATH)
		strcpy(tmpCharBuf, (const char *)tmpcharptr);
	else
		strcpy(tmpCharBuf, (const char *)GUI.FreezeFileDir);

	if(Options.HomeDirectoryMoved)
		ChangeWinHomeDirectory(tmpCharBuf, (const char *)Options.HomeDirectory, (const char *)Options.LastHomeDirectory, _MAX_PATH);

	if(access((const char *)tmpCharBuf, 0) == 0)
		strcpy(GUI.FreezeFileDir, (const char *)tmpCharBuf);
	_splitpath(GUI.FreezeFileDir, drive, dir, fname, ext);
	if(dir[0] && fname[0] == 0) {
		dir[strlen(dir) - 1] = 0;
	}
	_makepath(GUI.FreezeFileDir, drive, dir, fname, ext);
	
	tmpcharptr = get_config_string(cs.filedirectory, "ScreenShotDirectory");
	if(tmpcharptr[0] && strlen((const char *)tmpcharptr) < _MAX_PATH)
		strcpy(tmpCharBuf, (const char *)tmpcharptr);
	else
		strcpy(tmpCharBuf, (const char *)Memory.ScreenShotDirectory);

	if(Options.HomeDirectoryMoved)
		ChangeWinHomeDirectory(tmpCharBuf, (const char *)Options.HomeDirectory, (const char *)Options.LastHomeDirectory, _MAX_PATH);
	
	if(access((const char *)tmpCharBuf, 0) == 0)
		strcpy(Memory.ScreenShotDirectory, (const char *)tmpCharBuf);
	_splitpath(Memory.ScreenShotDirectory, drive, dir, fname, ext);
	if(dir[0] && fname[0] == 0) {
		dir[strlen(dir) - 1] = 0;
	}
	_makepath(Memory.ScreenShotDirectory, drive, dir, fname, ext);

	tmpcharptr = get_config_string(cs.filedirectory, "SPCDumpDirectory");
	if(tmpcharptr[0] && strlen((const char *)tmpcharptr) < _MAX_PATH)
		strcpy(tmpCharBuf, (const char *)tmpcharptr);
	else
		strcpy(tmpCharBuf, (const char *)Memory.SPCDumpDirectory);

	if(Options.HomeDirectoryMoved)
		ChangeWinHomeDirectory(tmpCharBuf, (const char *)Options.HomeDirectory, (const char *)Options.LastHomeDirectory, _MAX_PATH);
	
	if(access((const char *)tmpCharBuf, 0) == 0)
		strcpy(Memory.SPCDumpDirectory, (const char *)tmpCharBuf);
	_splitpath(Memory.SPCDumpDirectory, drive, dir, fname, ext);
	if(dir[0] && fname[0] == 0) {
		dir[strlen(dir) - 1] = 0;
	}
	_makepath(Memory.SPCDumpDirectory, drive, dir, fname, ext);

	tmpcharptr = get_config_string(cs.filedirectory, "BSX");
	if(tmpcharptr[0] && strlen((const char *)tmpcharptr) < _MAX_PATH)
		strcpy(tmpCharBuf, (const char *)tmpcharptr);
	else
		strcpy(tmpCharBuf, (const char *)Memory.BSXBIOSROMFileName);

	if(Options.HomeDirectoryMoved)
		ChangeWinHomeDirectory(tmpCharBuf, (const char *)Options.HomeDirectory, (const char *)Options.LastHomeDirectory, _MAX_PATH);

	strcpy(Memory.BSXBIOSROMFileName, (const char *)tmpCharBuf);

	tmpcharptr = get_config_string(cs.filedirectory, "SFT");
	if(tmpcharptr[0] && strlen((const char *)tmpcharptr) < _MAX_PATH)
		strcpy(tmpCharBuf, (const char *)tmpcharptr);
	else
		strcpy(tmpCharBuf, (const char *)Memory.SFTBIOSROMFileName);

	if(Options.HomeDirectoryMoved)
		ChangeWinHomeDirectory(tmpCharBuf, (const char *)Options.HomeDirectory, (const char *)Options.LastHomeDirectory, _MAX_PATH);

	strcpy(Memory.SFTBIOSROMFileName, (const char *)tmpCharBuf);


	/* Read [ControllerOption] */
	strcpy(tmpCharBuf, "JoystickConnected0");
	for(i = 0; i < 5; i++) {
		sprintf(&tmpCharBuf[17], "%d", i);
		Settings.JoystickConnected[i] = (bool8)get_config_int((int)Settings.JoystickConnected[i],
															  cs.ControllerOption,
															  (const char *)tmpCharBuf);
	}

	Settings.Mouse = (uint8)get_config_int((int)Settings.Mouse, cs.ControllerOption, "SnesMouse");
	Settings.SuperScope = (uint8)get_config_int((int)Settings.SuperScope, cs.ControllerOption, "SnesSuperScope");
	Settings.MultiPlayer5 = (uint8)get_config_int((int)Settings.MultiPlayer5, cs.ControllerOption, "SnesMultiPlayer5");
	Settings.Justifier = (uint8)get_config_int((int)Settings.Justifier, cs.ControllerOption, "SnesJustifier");
	Settings.SecondJustifier = (uint8)get_config_int((int)Settings.SecondJustifier, cs.ControllerOption, "SnesJustifier2");
	i = get_config_int((int)Settings.ControllerOption, cs.ControllerOption, "DefaultPlugedInputDevice");
	if(i == 0 && Settings.MultiPlayer5)
		Settings.ControllerOption = SNES_MULTIPLAYER5;
	else if(i == 1)
		Settings.ControllerOption = SNES_JOYPAD;
	else if(i == 2 && Settings.Mouse)
		Settings.ControllerOption = SNES_MOUSE_SWAPPED;
	else if(i == 3 && Settings.Mouse)
		Settings.ControllerOption = SNES_MOUSE;
	else if(i == 4 && Settings.SuperScope)
		Settings.ControllerOption = SNES_SUPERSCOPE;
	else if(i == 5 && Settings.Justifier)
		Settings.ControllerOption = SNES_JUSTIFIER;
	else if(i == 6 && Settings.SecondJustifier)
		Settings.ControllerOption = SNES_JUSTIFIER_2;
	else
		Settings.ControllerOption = SNES_JOYPAD;

	i = get_config_int((int)(Options.JoyReadRateMask + 1), cs.ControllerOption, "JoyReadRate");
	Options.JoyReadRateMask = (u32)((i == 1 || i == 2 || i == 4 || i == 8) ? (i - 1) : Options.JoyReadRateMask);
	GUI.DIuse = (BOOL)get_config_int((int)GUI.DIuse, cs.ControllerOption, "DirectInput");

	/* Read [joypadA1 2 3 4 5] */
	for(i = 0; i < 5; i++) {
		JoypadA[i].Left = (WORD)get_config_int((int)JoypadA[i].Left, cs.joypadA[i], cs.button[0]);
		JoypadA[i].Right = (WORD)get_config_int((int)JoypadA[i].Right, cs.joypadA[i], cs.button[1]);
		JoypadA[i].Up = (WORD)get_config_int((int)JoypadA[i].Up, cs.joypadA[i], cs.button[2]);
		JoypadA[i].Down = (WORD)get_config_int((int)JoypadA[i].Down, cs.joypadA[i], cs.button[3]);
		JoypadA[i].Start = (WORD)get_config_int((int)JoypadA[i].Start, cs.joypadA[i], cs.button[4]);
		JoypadA[i].Select = (WORD)get_config_int((int)JoypadA[i].Select, cs.joypadA[i], cs.button[5]);
		JoypadA[i].A = (WORD)get_config_int((int)JoypadA[i].A, cs.joypadA[i], cs.button[6]);
		JoypadA[i].B = (WORD)get_config_int((int)JoypadA[i].B, cs.joypadA[i], cs.button[7]);
		JoypadA[i].X = (WORD)get_config_int((int)JoypadA[i].X, cs.joypadA[i], cs.button[8]);
		JoypadA[i].Y = (WORD)get_config_int((int)JoypadA[i].Y, cs.joypadA[i], cs.button[9]);
		JoypadA[i].L = (WORD)get_config_int((int)JoypadA[i].L, cs.joypadA[i], cs.button[10]);
		JoypadA[i].R = (WORD)get_config_int((int)JoypadA[i].R, cs.joypadA[i], cs.button[11]);
		JoypadA[i].Turbo_Left = (get_config_int((int)JoypadA[i].Turbo_Left, cs.joypadA[i], cs.button[12]) ? TRUE : FALSE);
		JoypadA[i].Turbo_Right = (get_config_int((int)JoypadA[i].Turbo_Right, cs.joypadA[i], cs.button[13]) ? TRUE : FALSE);
		JoypadA[i].Turbo_Up = (get_config_int((int)JoypadA[i].Turbo_Up, cs.joypadA[i], cs.button[14]) ? TRUE : FALSE);
		JoypadA[i].Turbo_Down = (get_config_int((int)JoypadA[i].Turbo_Down, cs.joypadA[i], cs.button[15]) ? TRUE : FALSE);
		JoypadA[i].Turbo_Start = (get_config_int((int)JoypadA[i].Turbo_Start, cs.joypadA[i], cs.button[16]) ? TRUE : FALSE);
		JoypadA[i].Turbo_Select = (get_config_int((int)JoypadA[i].Turbo_Select, cs.joypadA[i], cs.button[17]) ? TRUE : FALSE);
		JoypadA[i].Turbo_A = (get_config_int((int)JoypadA[i].Turbo_A, cs.joypadA[i], cs.button[18]) ? TRUE : FALSE);
		JoypadA[i].Turbo_B = (get_config_int((int)JoypadA[i].Turbo_B, cs.joypadA[i], cs.button[19]) ? TRUE : FALSE);
		JoypadA[i].Turbo_X = (get_config_int((int)JoypadA[i].Turbo_X, cs.joypadA[i], cs.button[20]) ? TRUE : FALSE);
		JoypadA[i].Turbo_Y = (get_config_int((int)JoypadA[i].Turbo_Y, cs.joypadA[i], cs.button[21]) ? TRUE : FALSE);
		JoypadA[i].Turbo_L = (get_config_int((int)JoypadA[i].Turbo_L, cs.joypadA[i], cs.button[22]) ? TRUE : FALSE);
		JoypadA[i].Turbo_R = (get_config_int((int)JoypadA[i].Turbo_R, cs.joypadA[i], cs.button[23]) ? TRUE : FALSE);
	}

	/* Read [FunctionCodeA] */
	strcpy(tmpCharBuf, "Code0");
	for(i = 0; i < 8; i++) {
		sprintf(&tmpCharBuf[4], "%d", i);
		FunctionCodeA[i] = (DWORD)get_config_int((int)FunctionCodeA[i], cs.functioncodeA, (const char *)tmpCharBuf);
	}

	/* Read [joypadB1 2 3 4 5] */
	for(i = 0; i < 5; i++) {
		JoypadB[i].Left = (WORD)get_config_int((int)JoypadB[i].Left, cs.joypadB[i], cs.button[0]);
		JoypadB[i].Right = (WORD)get_config_int((int)JoypadB[i].Right, cs.joypadB[i], cs.button[1]);
		JoypadB[i].Up = (WORD)get_config_int((int)JoypadB[i].Up, cs.joypadB[i], cs.button[2]);
		JoypadB[i].Down = (WORD)get_config_int((int)JoypadB[i].Down, cs.joypadB[i], cs.button[3]);
		JoypadB[i].Start = (WORD)get_config_int((int)JoypadB[i].Start, cs.joypadB[i], cs.button[4]);
		JoypadB[i].Select = (WORD)get_config_int((int)JoypadB[i].Select, cs.joypadB[i], cs.button[5]);
		JoypadB[i].A = (WORD)get_config_int((int)JoypadB[i].A, cs.joypadB[i], cs.button[6]);
		JoypadB[i].B = (WORD)get_config_int((int)JoypadB[i].B, cs.joypadB[i], cs.button[7]);
		JoypadB[i].X = (WORD)get_config_int((int)JoypadB[i].X, cs.joypadB[i], cs.button[8]);
		JoypadB[i].Y = (WORD)get_config_int((int)JoypadB[i].Y, cs.joypadB[i], cs.button[9]);
		JoypadB[i].L = (WORD)get_config_int((int)JoypadB[i].L, cs.joypadB[i], cs.button[10]);
		JoypadB[i].R = (WORD)get_config_int((int)JoypadB[i].R, cs.joypadB[i], cs.button[11]);
		JoypadB[i].Turbo_Left = (get_config_int((int)JoypadB[i].Turbo_Left, cs.joypadB[i], cs.button[12]) ? TRUE : FALSE);
		JoypadB[i].Turbo_Right = (get_config_int((int)JoypadB[i].Turbo_Right, cs.joypadB[i], cs.button[13]) ? TRUE : FALSE);
		JoypadB[i].Turbo_Up = (get_config_int((int)JoypadB[i].Turbo_Up, cs.joypadB[i], cs.button[14]) ? TRUE : FALSE);
		JoypadB[i].Turbo_Down = (get_config_int((int)JoypadB[i].Turbo_Down, cs.joypadB[i], cs.button[15]) ? TRUE : FALSE);
		JoypadB[i].Turbo_Start = (get_config_int((int)JoypadB[i].Turbo_Start, cs.joypadB[i], cs.button[16]) ? TRUE : FALSE);
		JoypadB[i].Turbo_Select = (get_config_int((int)JoypadB[i].Turbo_Select, cs.joypadB[i], cs.button[17]) ? TRUE : FALSE);
		JoypadB[i].Turbo_A = (get_config_int((int)JoypadB[i].Turbo_A, cs.joypadB[i], cs.button[18]) ? TRUE : FALSE);
		JoypadB[i].Turbo_B = (get_config_int((int)JoypadB[i].Turbo_B, cs.joypadB[i], cs.button[19]) ? TRUE : FALSE);
		JoypadB[i].Turbo_X = (get_config_int((int)JoypadB[i].Turbo_X, cs.joypadB[i], cs.button[20]) ? TRUE : FALSE);
		JoypadB[i].Turbo_Y = (get_config_int((int)JoypadB[i].Turbo_Y, cs.joypadB[i], cs.button[21]) ? TRUE : FALSE);
		JoypadB[i].Turbo_L = (get_config_int((int)JoypadB[i].Turbo_L, cs.joypadB[i], cs.button[22]) ? TRUE : FALSE);
		JoypadB[i].Turbo_R = (get_config_int((int)JoypadB[i].Turbo_R, cs.joypadB[i], cs.button[23]) ? TRUE : FALSE);
	}

	/* Read [FunctionCodeB] */
	strcpy(tmpCharBuf, "Code0");
	for(i = 0; i < 8; i++) {
		sprintf(&tmpCharBuf[4], "%d", i);
		FunctionCodeB[i] = (DWORD)get_config_int((int)FunctionCodeB[i], cs.functioncodeB, (const char *)tmpCharBuf);
	}

	/* Read [gui] */
	i = get_config_int(GUI.Language, cs.gui, "Language");
	GUI.Language = (BYTE)((i == 1 || i == 0) ? i : GUI.Language);

	GUI.WindowRectSetting.left = get_config_int(-0x7fffffff, cs.gui, "WindowRectLeft");
	GUI.WindowRectSetting.right = get_config_int(-0x7fffffff, cs.gui, "WindowRectRight");
	GUI.WindowRectSetting.top = get_config_int(-0x7fffffff, cs.gui, "WindowRectTop");
	GUI.WindowRectSetting.bottom = get_config_int(-0x7fffffff, cs.gui, "WindowRectBottom");
	if(GUI.WindowRectSetting.left == -0x7fffffff ||
	   GUI.WindowRectSetting.right == -0x7fffffff ||
	   GUI.WindowRectSetting.top == -0x7fffffff ||
	   GUI.WindowRectSetting.bottom == -0x7fffffff)
		GUI.WindowRectSetting.left = GUI.WindowRectSetting.right = GUI.WindowRectSetting.top = GUI.WindowRectSetting.bottom = -1;
	else {
		if((GUI.WindowRectSetting.right - GUI.WindowRectSetting.left) < GUI.DefaultWindowSizeW) {
			GUI.WindowRectSetting.right = (GUI.WindowRectSetting.left + GUI.DefaultWindowSizeW);
		}
		if((GUI.WindowRectSetting.bottom - GUI.WindowRectSetting.top) < GUI.DefaultWindowSizeH) {
			GUI.WindowRectSetting.bottom = (GUI.WindowRectSetting.top + GUI.DefaultWindowSizeH);
			GUI.NeedWindowSizeAddition = 2;
		}
	}

	GUI.FileBrowseWindow = (unsigned char)get_config_int((int)GUI.FileBrowseWindow, cs.gui, "FileBrowseWindow");
	
	uosxplorerposition.WindowRect.left = get_config_int(uosxplorerposition.WindowRect.left, cs.gui, "uosXpWindowRectLeft");
	uosxplorerposition.WindowRect.right = get_config_int(uosxplorerposition.WindowRect.right, cs.gui, "uosXpWindowRectRight");
	uosxplorerposition.WindowRect.top = get_config_int(uosxplorerposition.WindowRect.top, cs.gui, "uosXpWindowRectTop");
	uosxplorerposition.WindowRect.bottom = get_config_int(uosxplorerposition.WindowRect.bottom, cs.gui, "uosXpWindowRectBottom");
	uosxplorerposition.Maximize = (BOOL)get_config_int(uosxplorerposition.Maximize, cs.gui, "uosXpMaximize");
	uosxplorerposition.VSplitBarPos0 = get_config_int(uosxplorerposition.VSplitBarPos0, cs.gui, "uosXpVSplitBarPos0");
	uosxplorerposition.ColumnWidth0 = get_config_int(uosxplorerposition.ColumnWidth0, cs.gui, "uosXpColumnWidth0");
	uosxplorerposition.ColumnWidth1 = get_config_int(uosxplorerposition.ColumnWidth1, cs.gui, "uosXpColumnWidth1");
	uosxplorerposition.ColumnWidth2 = get_config_int(uosxplorerposition.ColumnWidth2, cs.gui, "uosXpColumnWidth2");
	uosxplorerposition.ColumnWidth3 = get_config_int(uosxplorerposition.ColumnWidth3, cs.gui, "uosXpColumnWidth3");

	/* Read [screenshot] */
	i = get_config_int(Options.SaveImagefileFormat, cs.screenshot, "SaveImagefileFormat");
	Options.SaveImagefileFormat = (0 <= i && i <= 3) ? i : Options.SaveImagefileFormat;
	Options.ReduceTheColorTo256IfWithin = (u8)get_config_int((int)Options.ReduceTheColorTo256IfWithin,
															 cs.screenshot,
															 "ReduceTheColorTo256IfWithin");
	Options.ImagefileHiresStretch = (u8)get_config_int((int)Options.ImagefileHiresStretch,
														  cs.screenshot,
														  "ImagefileHiresStretch");
	Options.RLEcompression256bitmap = (u8)get_config_int((int)Options.RLEcompression256bitmap,
														 cs.screenshot,
														 "RLEcompression256bitmap");

	/* Read [debug] */
	Options.DisplayScreenBufferAll = (u8)get_config_int((int)Options.DisplayScreenBufferAll,
														cs.debug,
														"DisplayScreenBufferAll");

	/* Read [option] */
	Settings.ApplyCheats = (bool8)get_config_int((int)Settings.ApplyCheats, cs.option, "ApplyCheats");
	Settings.DisplayFrameRate = (bool8)get_config_int((int)Settings.DisplayFrameRate, cs.option, "ShowFPS");
	Settings.Mute = (bool8)get_config_int((int)Settings.Mute, cs.option, "MuteSound");
	Settings.AutoSaveDelay = (int32)get_config_int((int)Settings.AutoSaveDelay, cs.option, "AutoSaveDelay");
	Settings.DisableIRQCycleCount = (bool8)get_config_int((int)Settings.DisableIRQCycleCount, cs.option, "DisableIRQCycleCount");
	Xxxcdda.Enable = (bool8)get_config_int((int)Xxxcdda.Enable, cs.option, "UseCDDA");
	i = get_config_int((int)Xxxcdda.Drv, cs.option, "CDDrv");
	Xxxcdda.Drv = (uint32)((0 <= i && i <= 26) ? i : Xxxcdda.Drv);

	return;
}

void write_port_config()
{
	int i, c;
    char drive [_MAX_DRIVE + 1];
    char dir [_MAX_DIR + 1];
    char fname [_MAX_FNAME + 1];
    char ext [_MAX_EXT + 1];
	char tmpCharBuf[_MAX_PATH + 1];

	/* Write [windows] */
	switch(GUI.PriorityClass) {
	case IDLE_PRIORITY_CLASS: i = 0; break;
	case NORMAL_PRIORITY_CLASS: i = 1; break;
	case HIGH_PRIORITY_CLASS: i = 2; break;
	case REALTIME_PRIORITY_CLASS: i = 3; break;
	default: i = 1;  break;
	}
	set_config_int(cs.windows, "PriorityClass", i);

	switch(GUI.ThreadPriority) {
	case THREAD_PRIORITY_LOWEST: i = 0; break;
	case THREAD_PRIORITY_BELOW_NORMAL: i = 1; break;
	case THREAD_PRIORITY_NORMAL: i = 2; break;
	case THREAD_PRIORITY_ABOVE_NORMAL: i = 3; break;
	case THREAD_PRIORITY_HIGHEST: i = 4; break;
	case THREAD_PRIORITY_IDLE: i = 5; break;
	case THREAD_PRIORITY_TIME_CRITICAL: i = 6; break;
	default: i = 2; break;
	}
	set_config_int(cs.windows, "ThreadPriority", i);

	set_config_int(cs.windows, "WindowTopMost", (int)GUI.WindowTopMost);
	set_config_int(cs.windows, "Inactive_X", (int)Options.inactive_x);

	/* Write [graphics] */
	set_config_int(cs.graphics, "Fullscreen", (int)GUI.FullScreen);
	set_config_int(cs.graphics, "DoubleRendering", (int)GUI.DoubleRendering);
	set_config_int(cs.graphics, "FullscreenDisplayModeIndexNormal16", (int)GUI.FullscreenDisplayModeIndexNormal16);
	set_config_int(cs.graphics, "FullscreenDisplayModeIndexDouble16", (int)GUI.FullscreenDisplayModeIndexDouble16);
	set_config_int(cs.graphics, "FullscreenDisplayModeIndexNormal8", (int)GUI.FullscreenDisplayModeIndexNormal8);
	set_config_int(cs.graphics, "FullscreenDisplayModeIndexDouble8", (int)GUI.FullscreenDisplayModeIndexDouble8);
	set_config_int(cs.graphics, "DoubleRenderingModes16", (int)GUI.DoubleRenderingModes16);
	set_config_int(cs.graphics, "DoubleRenderingModes8", (int)GUI.DoubleRenderingModes8);
	set_config_int(cs.graphics, "DirectScreenRendering", (int)GUI.dRendering);
	set_config_int(cs.graphics, "DisableHardwareScale", (int)DirectX.DisableHardwareScale);
	set_config_int(cs.graphics, "DoubleBuffering", (int)GUI.DoubleBuffered);
	set_config_int(cs.graphics, "ForceWindowedDirectDrawClipper", (int)GUI.ForceWindowedDirectDrawClipper);
	set_config_int(cs.graphics, "OffScreenVRAM", (int)DirectX.OffScreenVRAM);
	set_config_int(cs.graphics, "BackBufferVRAM", (int)DirectX.BackBufferVRAM);
	set_config_int(cs.graphics, "GFXengine2", (int)Settings.GFXengine2);
	set_config_int(cs.graphics, "wait_for_vsync", (int)DirectX.wait_for_vsync);
	set_config_int(cs.graphics, "stretch", (int)GUI.Stretch);
	set_config_int(cs.graphics, "RenderSixteenBit", (int)Settings.SixteenBit);
	set_config_int(cs.graphics, "Transparency", (int)Settings.Transparency);
	set_config_int(cs.graphics, "BGLayering", (int)Settings.BGLayering);
	set_config_int(cs.graphics, "DisableGraphicWindows", (int)Settings.DisableGraphicWindows);
	set_config_int(cs.graphics, "DisableHDMA", (int)Settings.DisableHDMA);
	set_config_int(cs.graphics, "hires", (int)GUI.SupportHiRes);
	set_config_int(cs.graphics, "Mode7Interpolate", (int)Settings.Mode7Interpolate);


	/* Write [sound] */
	set_config_int(cs.sound, "SoundRate", Options.SoundRate);

	switch(Options.SoundBit) {
	case 8: i = 0; break;
	case 16: i = 1; break;
	default: i = 1;  break;
	}
	set_config_int(cs.sound, "SoundBit", i);


	switch(Options.SoundChn) {
	case 1: i = 0; break;
	case 2: i = 1; break;
	default: i = 1;  break;
	}
	set_config_int(cs.sound, "Stereo", i);

	set_config_int(cs.sound, "DirectSound", (int)GUI.DSuse);
	set_config_int(cs.sound, "DirectSoundNotify", (int)GUI.DirectSoundNotify);
	set_config_int(cs.sound, "APUEnabled", (int)Settings.NextAPUEnabled);
	set_config_int(cs.sound, "InterpolatedSound", Settings.InterpolatedSound);
	set_config_int(cs.sound, "LowPassFilter", (int)Settings.LowPassFilter);
	set_config_int(cs.sound, "SimpleFilter", (int)Settings.SimpleFilter);
	set_config_int(cs.sound, "SoundBufferLength", (int)Settings.SoundBufferSize);
	set_config_int(cs.sound, "SoundMixInterval", (int)Settings.SoundMixInterval);
	set_config_int(cs.sound, "SoundGlobalFocus", (int)GUI.SoundGlobalFocus);
	set_config_int(cs.sound, "SoundEnvelopeHeightReading", (int)Settings.SoundEnvelopeHeightReading);
	set_config_int(cs.sound, "DisableSoundEcho", (int)Settings.DisableSoundEcho);
	set_config_int(cs.sound, "DisableMasterVolume", (int)Settings.DisableMasterVolume);
	set_config_int(cs.sound, "VolumeLevel", Options.VolumeLevel);
#if 0
	set_config_int(cs.sound, "DisableSampleCaching", (int)Settings.DisableSampleCaching);
	set_config_int(cs.sound, "SampleDecodingMethod", (int)Settings.AltSampleDecode);
#endif
	set_config_int(cs.sound, "Shutdown", (int)(Settings.ShutdownMaster ? 0 : 1));
	set_config_int(cs.sound, "SoundSkipMethod", (int)Settings.SoundSkipMethod);
	set_config_int(cs.sound, "SoundSync", (int)Settings.SoundSync);
	set_config_int(cs.sound, "ReverseStereo", (int)Settings.ReverseStereo);
#if 0
	set_config_int(cs.sound, "FixFrequency", (int)Options.FixFrequency);
#endif

	/* Write [cpu] */
	set_config_int(cs.cpu, "CyclesPercentage", Settings.CyclesPercentage);


	/* Write [timer] */
	if (Settings.SkipFrames != AUTO_FRAMERATE)
		set_config_int(cs.timer, "SkipFrames", (int)(Settings.SkipFrames - 1));
	else
		set_config_string(cs.timer, "SkipFrames", "");
	set_config_int(cs.timer, "AutoMaxSkipFrames", (int)Settings.AutoMaxSkipFrames);
	set_config_int(cs.timer, "TurboSkipFrames", (int)Settings.TurboSkipFrames);
	set_config_int(cs.timer, "NTSCtiming", (int)Settings.FrameTimeNTSC);
	set_config_int(cs.timer, "PALtiming", (int)Settings.FrameTimePAL);


	/* Write [FileDirectory] */
	set_config_string(cs.filedirectory, "HomeDirectory", Options.HomeDirectory);

	set_config_string(cs.filedirectory, "LastROMFileName", ROMFileName);
	strcpy(tmpCharBuf, "RecentROMFileName1");
	for(i = 0; i < 10; i++) {
		sprintf(&tmpCharBuf[17], "%X", i + 1);
		set_config_string(cs.filedirectory, (const char *)tmpCharBuf, &RecentROMFileName[_MAX_PATH * i]);
	}

	_splitpath(GUI.FreezeFileDir, drive, dir, fname, ext);
	if(dir[0] == 0)
		_makepath (GUI.FreezeFileDir, drive, "\\", NULL, NULL);
	else
		_makepath (GUI.FreezeFileDir, drive, dir, fname, ext);
	set_config_string(cs.filedirectory, "SnapShotDirectory", GUI.FreezeFileDir);

	_splitpath(Memory.ScreenShotDirectory, drive, dir, fname, ext);
	if(dir[0] == 0)
		_makepath (Memory.ScreenShotDirectory, drive, "\\", NULL, NULL);
	else
		_makepath (Memory.ScreenShotDirectory, drive, dir, fname, ext);
	set_config_string(cs.filedirectory, "ScreenShotDirectory", Memory.ScreenShotDirectory);

	_splitpath(Memory.SPCDumpDirectory, drive, dir, fname, ext);
	if(dir[0] == 0)
		_makepath (Memory.SPCDumpDirectory, drive, "\\", NULL, NULL);
	else
		_makepath (Memory.SPCDumpDirectory, drive, dir, fname, ext);
	set_config_string(cs.filedirectory, "SPCDumpDirectory", Memory.SPCDumpDirectory);

	set_config_string(cs.filedirectory, "BSX", Memory.BSXBIOSROMFileName);
	set_config_string(cs.filedirectory, "SFT", Memory.SFTBIOSROMFileName);

	/* Write [ControllerOption] */
	strcpy(tmpCharBuf, "JoystickConnected0");
	for(i = 0; i < 5; i++) {
		sprintf(&tmpCharBuf[17], "%d", i);
		set_config_int(cs.ControllerOption, (const char *)tmpCharBuf, (int)Settings.JoystickConnected[i]);
	}

	set_config_int(cs.ControllerOption, "SnesMouse", (int)Settings.Mouse);
	set_config_int(cs.ControllerOption, "SnesSuperScope", (int)Settings.SuperScope);
	set_config_int(cs.ControllerOption, "SnesMultiPlayer5", (int)Settings.MultiPlayer5);
	set_config_int(cs.ControllerOption, "SnesJustifier", (int)Settings.Justifier);
	set_config_int(cs.ControllerOption, "SnesJustifier2", (int)Settings.SecondJustifier);


	switch(Settings.ControllerOption){
	case SNES_MULTIPLAYER5: i = 0; break;
	case SNES_JOYPAD: i = 1; break;
	case SNES_MOUSE_SWAPPED: i = 2; break;
	case SNES_MOUSE: i = 3; break;
	case SNES_SUPERSCOPE: i = 4; break;
	case SNES_JUSTIFIER: i = 5; break;
	case SNES_JUSTIFIER_2: i = 6; break;
	default: i = 1; break;
	}
	set_config_int(cs.ControllerOption, "DefaultPlugedInputDevice", i);
	set_config_int(cs.ControllerOption, "JoyReadRate", (int)(Options.JoyReadRateMask + 1));
	set_config_int(cs.ControllerOption, "DirectInput", (int)GUI.DIuse);

	/* Write [joypadA1 2 3 4 5] */
	for(i = 0; i < 5; i++) {
		set_config_int(cs.joypadA[i], cs.button[0], (int)JoypadA[i].Left);
		set_config_int(cs.joypadA[i], cs.button[1], (int)JoypadA[i].Right);
		set_config_int(cs.joypadA[i], cs.button[2], (int)JoypadA[i].Up);
		set_config_int(cs.joypadA[i], cs.button[3], (int)JoypadA[i].Down);
		set_config_int(cs.joypadA[i], cs.button[4], (int)JoypadA[i].Start);
		set_config_int(cs.joypadA[i], cs.button[5], (int)JoypadA[i].Select);
		set_config_int(cs.joypadA[i], cs.button[6], (int)JoypadA[i].A);
		set_config_int(cs.joypadA[i], cs.button[7], (int)JoypadA[i].B);
		set_config_int(cs.joypadA[i], cs.button[8], (int)JoypadA[i].X);
		set_config_int(cs.joypadA[i], cs.button[9], (int)JoypadA[i].Y);
		set_config_int(cs.joypadA[i], cs.button[10], (int)JoypadA[i].L);
		set_config_int(cs.joypadA[i], cs.button[11], (int)JoypadA[i].R);
		set_config_int(cs.joypadA[i], cs.button[12], (int)JoypadA[i].Turbo_Left);
		set_config_int(cs.joypadA[i], cs.button[13], (int)JoypadA[i].Turbo_Right);
		set_config_int(cs.joypadA[i], cs.button[14], (int)JoypadA[i].Turbo_Up);
		set_config_int(cs.joypadA[i], cs.button[15], (int)JoypadA[i].Turbo_Down);
		set_config_int(cs.joypadA[i], cs.button[16], (int)JoypadA[i].Turbo_Start);
		set_config_int(cs.joypadA[i], cs.button[17], (int)JoypadA[i].Turbo_Select);
		set_config_int(cs.joypadA[i], cs.button[18], (int)JoypadA[i].Turbo_A);
		set_config_int(cs.joypadA[i], cs.button[19], (int)JoypadA[i].Turbo_B);
		set_config_int(cs.joypadA[i], cs.button[20], (int)JoypadA[i].Turbo_X);
		set_config_int(cs.joypadA[i], cs.button[21], (int)JoypadA[i].Turbo_Y);
		set_config_int(cs.joypadA[i], cs.button[22], (int)JoypadA[i].Turbo_L);
		set_config_int(cs.joypadA[i], cs.button[23], (int)JoypadA[i].Turbo_R);
	}

	/* Write [FunctionCodeA] */
	strcpy(tmpCharBuf, "Code0");
	for(i = 0; i < 8; i++) {
		sprintf(&tmpCharBuf[4], "%d", i);
		set_config_int(cs.functioncodeA, (const char *)tmpCharBuf, (int)FunctionCodeA[i]);
	}

	/* Write [joypadB1 2 3 4 5] */
	for(i = 0; i < 5; i++) {
		set_config_int(cs.joypadB[i], cs.button[0], (int)JoypadB[i].Left);
		set_config_int(cs.joypadB[i], cs.button[1], (int)JoypadB[i].Right);
		set_config_int(cs.joypadB[i], cs.button[2], (int)JoypadB[i].Up);
		set_config_int(cs.joypadB[i], cs.button[3], (int)JoypadB[i].Down);
		set_config_int(cs.joypadB[i], cs.button[4], (int)JoypadB[i].Start);
		set_config_int(cs.joypadB[i], cs.button[5], (int)JoypadB[i].Select);
		set_config_int(cs.joypadB[i], cs.button[6], (int)JoypadB[i].A);
		set_config_int(cs.joypadB[i], cs.button[7], (int)JoypadB[i].B);
		set_config_int(cs.joypadB[i], cs.button[8], (int)JoypadB[i].X);
		set_config_int(cs.joypadB[i], cs.button[9], (int)JoypadB[i].Y);
		set_config_int(cs.joypadB[i], cs.button[10], (int)JoypadB[i].L);
		set_config_int(cs.joypadB[i], cs.button[11], (int)JoypadB[i].R);
		set_config_int(cs.joypadB[i], cs.button[12], (int)JoypadB[i].Turbo_Left);
		set_config_int(cs.joypadB[i], cs.button[13], (int)JoypadB[i].Turbo_Right);
		set_config_int(cs.joypadB[i], cs.button[14], (int)JoypadB[i].Turbo_Up);
		set_config_int(cs.joypadB[i], cs.button[15], (int)JoypadB[i].Turbo_Down);
		set_config_int(cs.joypadB[i], cs.button[16], (int)JoypadB[i].Turbo_Start);
		set_config_int(cs.joypadB[i], cs.button[17], (int)JoypadB[i].Turbo_Select);
		set_config_int(cs.joypadB[i], cs.button[18], (int)JoypadB[i].Turbo_A);
		set_config_int(cs.joypadB[i], cs.button[19], (int)JoypadB[i].Turbo_B);
		set_config_int(cs.joypadB[i], cs.button[20], (int)JoypadB[i].Turbo_X);
		set_config_int(cs.joypadB[i], cs.button[21], (int)JoypadB[i].Turbo_Y);
		set_config_int(cs.joypadB[i], cs.button[22], (int)JoypadB[i].Turbo_L);
		set_config_int(cs.joypadB[i], cs.button[23], (int)JoypadB[i].Turbo_R);
	}

	/* Write [FunctionCodeB] */
	strcpy(tmpCharBuf, "Code0");
	for(i = 0; i < 8; i++) {
		sprintf(&tmpCharBuf[4], "%d", i);
		set_config_int(cs.functioncodeB, (const char *)tmpCharBuf, (int)FunctionCodeB[i]);
	}

	/* Write [gui] */
	set_config_int(cs.gui, "Language", (int)GUI.Language);

	set_config_int(cs.gui, "WindowRectLeft", (int)GUI.WindowRectSetting.left);
	set_config_int(cs.gui, "WindowRectRight", (int)GUI.WindowRectSetting.right);
	set_config_int(cs.gui, "WindowRectTop", (int)GUI.WindowRectSetting.top);
	set_config_int(cs.gui, "WindowRectBottom", (int)GUI.WindowRectSetting.bottom);

	set_config_int(cs.gui, "FileBrowseWindow", (int)GUI.FileBrowseWindow);

	set_config_int(cs.gui, "uosXpWindowRectLeft", (int)uosxplorerposition.WindowRect.left);
	set_config_int(cs.gui, "uosXpWindowRectRight", (int)uosxplorerposition.WindowRect.right);
	set_config_int(cs.gui, "uosXpWindowRectTop", (int)uosxplorerposition.WindowRect.top);
	set_config_int(cs.gui, "uosXpWindowRectBottom", (int)uosxplorerposition.WindowRect.bottom);
	set_config_int(cs.gui, "uosXpMaximize", (int)uosxplorerposition.Maximize);
	set_config_int(cs.gui, "uosXpVSplitBarPos0", (int)uosxplorerposition.VSplitBarPos0);
	set_config_int(cs.gui, "uosXpColumnWidth0", (int)uosxplorerposition.ColumnWidth0);
	set_config_int(cs.gui, "uosXpColumnWidth1", (int)uosxplorerposition.ColumnWidth1);
	set_config_int(cs.gui, "uosXpColumnWidth2", (int)uosxplorerposition.ColumnWidth2);
	set_config_int(cs.gui, "uosXpColumnWidth3", (int)uosxplorerposition.ColumnWidth3);


	/* Write [screenshot] */
	set_config_int(cs.screenshot, "SaveImagefileFormat", Options.SaveImagefileFormat);
	set_config_int(cs.screenshot, "ReduceTheColorTo256", (int)Options.ReduceTheColorTo256);
	set_config_int(cs.screenshot, "ReduceTheColorTo256IfWithin", (int)Options.ReduceTheColorTo256IfWithin);
	set_config_int(cs.screenshot, "ImagefileHiresStretch", (int)Options.ImagefileHiresStretch);
	set_config_int(cs.screenshot, "RLEcompression256bitmap", (int)Options.RLEcompression256bitmap);

	/* Write [debug] */
	set_config_int(cs.debug, "DisplayScreenBufferAll", (int)Options.DisplayScreenBufferAll);


	/* Write [option] */
	set_config_int(cs.option, "ApplyCheats", (int)Settings.ApplyCheats);
	set_config_int(cs.option, "ShowFPS", (int)Settings.DisplayFrameRate);
	set_config_int(cs.option, "MuteSound", (int)Settings.Mute);
    set_config_int(cs.option, "AutoSaveDelay", Settings.AutoSaveDelay);
    set_config_int(cs.option, "DisableIRQCycleCount", Settings.DisableIRQCycleCount);
    set_config_int(cs.option, "UseCDDA", Xxxcdda.Enable);
    set_config_int(cs.option, "CDDrv", Xxxcdda.Drv);

	return;
}

