#ifndef _UOSNESW_H_
#define _UOSNESW_H_

#include <stdlib.h>
#ifndef STRICT
  #define STRICT
#endif
#include <windows.h>
#include <commctrl.h>
#include <mmsystem.h>
#include "MeteredSection.h"
#include "resource.h"

typedef struct {
	HWND hWnd;
	HWND hStatusWnd;
	HMENU hMenu;
	HMENU hVolMenu;
	HMENU hSysMenu;
	HMENU hRecentGamesMenu;
	HINSTANCE hInstance;
	HCURSOR Blank;
	HCURSOR GunSight;
	HCURSOR Arrow;
	DWORD dwStyleWindowed;
	DWORD dwStyleFullScreen;
	DWORD dwExStyle;

	bool AppMenuConnect;

	long DefaultWindowSizeW;
	long DefaultWindowSizeH;
	long DefaultWindowSizeWW;
	long DefaultWindowSizeHH;
	long WindowSizeW;
	long WindowSizeH;
	RECT WindowRectSetting;

	//Status bar size
	unsigned char NeedWindowSizeAddition;
	//Client Rect, .left == 0 .top == 0
	RECT ClientRect;
	//Screen xy Client Rect
	RECT sClientRect;

	volatile LPMETERED_SECTION FrameTimerMeteredSection;

	BYTE Language;

	volatile bool ForcedPauseEmulation;
	volatile bool PauseEmulation;
	volatile bool StopEmulation;
	BOOL SoundGlobalFocus;
	bool PauseLock;

	int Scale;
	unsigned char SupportHiRes;
	unsigned char DoubleRendering;
    unsigned char dRendering;
	int Stretch;
	bool FullScreen;
	bool DoubleBuffered;
	int DoubleRenderingModes8;
	int DoubleRenderingModes16;
	int FullscreenDisplayModeIndexNormal16;
	int FullscreenDisplayModeIndexDouble16;
	int FullscreenDisplayModeIndexNormal8;
	int FullscreenDisplayModeIndexDouble8;
	int CurFullscreenDisplayModeIndex;
	unsigned char ForceWindowedDirectDrawClipper;

	bool NeedDepthConvert;
	DWORD ScreenDepth;

	int RedShift;
	int GreenShift;
	int BlueShift;

    RECT SizeHistory [10];
    unsigned int FlipCounter;

	char FreezeFileDir[_MAX_PATH];
	POINT MousePosition;
	int MouseX;
	int MouseY;
	bool IgnoreNextMouseMove;
	unsigned long MouseButtons;

	DWORD PriorityClass;
	int ThreadPriority;

	BOOL DIuse;
	BOOL DSuse;

	BOOL DirectSoundNotify;

	unsigned char FileBrowseWindow;
	unsigned char WindowTopMost;

	unsigned char SwitchToWindowed;
	unsigned char Exit;
} GUIData;

struct sLanguages {
	int idMenu;
	char *errInitDD;
	char *errModeDD;
	char *errInitSound;
	char *ApplyNeedRestart;
	char *errFrameTimer;
	char *S9xExitMessage;
	char *errMemoryInit;
	char *errSwitchGFX;
	char *errInitDI;
};

/*****************************************************************************/
/* uosnesw defines                                                           */
/*****************************************************************************/
#define ID_MAINSTATUSWINDOW 101

/*****************************************************************************/
/* Snes9x proc extern                                                        */
/*****************************************************************************/
extern "C" const char *S9xGetNumFilename (const char *dirstr,
										  const char *fext,
										  int *numsaved);

/*****************************************************************************/
/* uosnesw variables extern                                                  */
/*****************************************************************************/
extern "C" GUIData GUI;
extern "C" GUIData DefaultGUI;
extern struct sLanguages Languages[];
extern int superscope_turbo;
extern int superscope_pause;
extern unsigned char errConfigSwitch;
extern struct DDisplayMode DisplayMode[];

/*****************************************************************************/
/* uosnesw proc extern                                                       */
/*****************************************************************************/
BOOL OpenFile(HWND hWnd, char *FileName, char *FileTitle, char *InitialROMFileDirectory);
BOOL OpenFileEx(HWND hWnd, char *FileName, char *FileTitle, char *InitialROMFileDirectory);
void ConfigDlgProp(HWND hWnd);
unsigned char DisplaySNESCheatCodeWindow();
const char *S9xGetSPCFilename ();
char *S9xwGetSavedSPCNumberAndExtStr();
char *S9xwGetScreenImageFilename(char *ImageTypeExt);
char *S9xwGetSavedScreenImageNumberAndTypeStr();
bool InitUosnesw(void);
void DeinitUosnesw(void);
void S9xSetWindowPos();
void RefreshRectParams();
void DisplayStatusInfo();
unsigned char SwitchScreenMode(unsigned char Windowed);
void SetMenuStatus(HMENU hAppMenu, HMENU hSysMenu);
void SetRecentFileMenu();
void CurFullscreenDisplayModeIndexChange();
BOOL UosneswSetupFrameTimer(DWORD ms);

void DoAVIOpen(const char* filename);
void DoAVIClose(int reason);

#endif /* _UOSNESW_H_ */

