/*****************************************************************************/
/*  uosnes: Win32                                                            */
/*****************************************************************************/
#include "snes9x.h"
#include "uosnesw.h"
#include "memmap.h"
#include "cpuexec.h"
#include "cheats.h"
#include "display.h"
#include "snapshot.h"
#include "apu.h"
#include "soundux.h"
#include "snesapu.h"
#include "winutil.h"
#include "spcplay.h"
#include "commutil.h"
#include "cfgfile.h"
#include "windraw.h"
#include "uowdraw.h"
#include "uowinput.h"
#include "render.h"

#include <shellapi.h>
#include <io.h>
#include <direct.h>

#ifdef DEBUGGER
extern FILE *trace;
extern FILE *trace2;
static char *TracelogFilename = NULL;
#endif

//#define UOSNESW_TRACE

#ifdef UOSNESW_TRACE
static char *uowTracelogFilename = NULL;
FILE *tracex;
#endif

/*****************************************************************************/
/* uosnesw proc define                                                       */
/*****************************************************************************/
static void WinLoad();
static bool ROMLoadProc(char *FileName);
static void Draw1frame();
static void SetClipper(bool clip);
static void S9xMessage2 (const char *str, int TimeOut);
static void SetPriorityClassAndThreadPriority(DWORD priocl, int threadprio);
static bool8 S9xwCreateStatusBar();
static void S9xwDestroyStatusBar();
static void PauseExecution(bool pause, bool lock, bool clear_lock);
static void NullExecLoop();
static void UosneswClose();
static void AVI_Record(u8 *AVI_Recording);

/*****************************************************************************/
/* variables define                                                          */
/*****************************************************************************/
static void (*ExecLoop)(void);
static char *rom_filename = NULL;

static char FileTitle[_MAX_PATH] = {0};
char ROMFileName[_MAX_PATH] = {0};
char InitialROMFileDirectory[_MAX_PATH] = {0};
char RecentROMFileName[_MAX_PATH * 11] = {0};

/*****************************************************************************/
/* Global variables                                                          */
/*****************************************************************************/

GUIData GUI;
GUIData DefaultGUI;

char WindowTitleTextNormal_bak[] = "uosnes : Windows";
char WindowTitleTextNormal[] = "uosnes : Windows";
char WindowTitleTextPaused[] = "uosnes : - Paused";
char WindowTitleTextTurbo[] = "uosnes : - Turbo";
char WindowTitleText[256] = "uosnes : Windows";

static bool SPCLoadedFlag = FALSE;

struct sLanguages Languages[] = {
	{ IDR_MENU_US, 
	  "DirectX failed to initialize!", 
	  "DirectDraw failed to set the selected display mode!", 
	  "Sound failed to initialize, no sound will be played.",
	  "These settings won't take effect until you restart the emulator.",
	  "The frame timer failed to initialize, please do NOT select the automatic framerate option or uosnes will crash!",
	  "Anything error occured! uosnesw shutdown.",
	  "Memory allocation error! uosnesw shutdown.",
	  "Display Graphic mode settings failed! uosnesw shutdown.",
	  "DirectInput failed to initialize, WinAPI will be used."},
	{ IDR_MENU_JP, 
	  "DirectX Ɏs܂",
	  "DirectDraw fBXvC[hݒɎs܂",
	  "Sound Ɏs܂",
	  "These settings won't take effect until you restart the emulator.",
	  "^C}[Ɏs܂Aframerate(ftHg)̐ݒősꍇ̓NbV܂",
	  "̃G[NuosneswI܂",
	  "mۂɎs܂AI܂",
	  "fBXvCAOtBbN[h؂芷Ɏs܂AI܂",
	  "DirectInputɎs܂AWinAPIgp܂"}
	};

struct DDisplayMode DisplayMode [28] = {
	{ 256, 224, 8},
	{ 256, 224,16},
	{ 256, 240, 8},
	{ 256, 240,16},
	{ 320, 240, 8},
	{ 320, 240,16},
	{ 400, 300, 8},
	{ 400, 300,16},
	{ 512, 384, 8},
	{ 512, 384,16},
	{ 640, 400, 8},
	{ 640, 400,16},
	{ 512, 448, 8},
	{ 512, 448,16},
	{ 512, 478, 8},
	{ 512, 478,16},
	{ 640, 480, 8},
	{ 640, 480,16},
	{ 800, 600, 8},
	{ 800, 600,16},
	{1024, 768, 8},
	{1024, 768,16},
	{1152, 864, 8},
	{1152, 864,16},
	{1280, 1024, 8},
	{1280, 1024,16},
	{1600, 1200, 8},
	{1600, 1200,16}};

/*****************************************************************************/
/* uosnes Settings                                                           */
/*****************************************************************************/
static int sb_size[3] = {40, 130, 205};

/*****************************************************************************/
/* Work variables                                                            */
/*****************************************************************************/
static char tmpcharbuf[256];
static char OnScreenMessageStr[256] = {0};

/*****************************************************************************/
/* Procedures                                                                */
/*****************************************************************************/

static void NullExecLoop()
{
	return;
}

void RefreshRectParams()
{
	if(!GUI.hWnd)
		return;

	GetClientRect(GUI.hWnd, &GUI.ClientRect);

	if(GUI.hStatusWnd) {
		RECT strect;
		GetWindowRect(GUI.hStatusWnd, &strect);
		GUI.ClientRect.bottom -= (strect.bottom - strect.top);
		if(GUI.ClientRect.bottom <= GUI.ClientRect.top)
			GUI.ClientRect.top = GUI.ClientRect.bottom = 0;
	}

	POINT p;
	p.x = GUI.ClientRect.left;
	p.y = GUI.ClientRect.top;
	ClientToScreen (GUI.hWnd, &p);

	GUI.sClientRect.top = p.y;
	GUI.sClientRect.left = p.x;
	GUI.sClientRect.right  = GUI.sClientRect.left + (GUI.ClientRect.right - GUI.ClientRect.left);
	GUI.sClientRect.bottom = GUI.sClientRect.top + (GUI.ClientRect.bottom - GUI.ClientRect.top);
	DirectX.ClientRect = GUI.ClientRect;
	DirectX.sClientRect = GUI.sClientRect;
	return;
}


void CurFullscreenDisplayModeIndexChange()
{
	if(Settings.SixteenBit && GUI.DoubleRendering)
		GUI.CurFullscreenDisplayModeIndex = GUI.FullscreenDisplayModeIndexDouble16;
	else if(!Settings.SixteenBit && GUI.DoubleRendering)
		GUI.CurFullscreenDisplayModeIndex = GUI.FullscreenDisplayModeIndexDouble8;
	else if(Settings.SixteenBit && !GUI.DoubleRendering)
		GUI.CurFullscreenDisplayModeIndex = GUI.FullscreenDisplayModeIndexNormal16;
	else
		GUI.CurFullscreenDisplayModeIndex = GUI.FullscreenDisplayModeIndexNormal8;
}

void DisplayStatusInfo()
{
	if(!GUI.hStatusWnd)
		return;

	static char sb_string [30];
	static int32 ROMFramesPerSecond0;
	static uint32 DisplayedRenderedFrameCount0;
	
	if(GUI.StopEmulation || Settings.SPCPlaying) {
		wsprintf (sb_string, "xx/xx");
		SendMessage(GUI.hStatusWnd, SB_SETTEXT, (WPARAM)0 | 0, (LPARAM)(LPSTR)sb_string);
		ROMFramesPerSecond0 = 0;
		DisplayedRenderedFrameCount0 = 0;
	}
	else if(ROMFramesPerSecond0 != Memory.ROMFramesPerSecond ||
			DisplayedRenderedFrameCount0 != IPPU.DisplayedRenderedFrameCount) {
		wsprintf (sb_string, "%02d/%02d",
				  IPPU.DisplayedRenderedFrameCount,
				  (int) Memory.ROMFramesPerSecond);
		SendMessage(GUI.hStatusWnd, SB_SETTEXT, (WPARAM)0 | 0, (LPARAM)(LPSTR)sb_string);
		ROMFramesPerSecond0 = Memory.ROMFramesPerSecond;
		DisplayedRenderedFrameCount0 = IPPU.DisplayedRenderedFrameCount;
	}
}

void SwitchToGDI()
{
	GUI.FlipCounter = 0;
	IPPU.ColorsChanged = TRUE;
	if(DirectX.lpDDSPrimary2 != NULL) {
		DirectX.lpDD->FlipToGDISurface();
		DirectX.lpDDSPrimary2->SetPalette(NULL);
	}
}

void UpdateBackBuffer()
{
	GUI.FlipCounter = 0;
	if(DirectX.Windowed) {
		DirectX_ClearOffscreenSurface();
		UosneswScreenRedraw(GUI.hWnd);
		return;
	}
	SwitchToGDI();
	DirectX_ClearPrimarySurface();
	DirectX_ClearBackbufferSurface();
}

// screen messages
static char S9xInfoString[256] = {0};
static char OnScreenMessage[256] = {0};
static char ExitMenuMessage[256] = {0};
static char MouseEraseMessage[256] = {0};
static DWORD OnScreenMessageTimeOut = 0;
static DWORD ExitMenuTimeOut = 0;
static DWORD MouseEraseTimeOut = 0;
static bool OnScreenMessageTimerActiveFlag = FALSE;
static bool8 MinimizedFlag = 0;
static bool ncbuttondown_flag = 0;
static bool WindowActiveFlag = 0;
static bool SizingFlag = 0;

static void S9xMessage2 (const char *str, int TimeOut)
{
	//ExitMenuMessage
	if(!lstrcmp(str, "ExitMenu")) {
		lstrcpy(ExitMenuMessage, str);
		ExitMenuTimeOut = timeGetTime() + TimeOut;
	}
	//MouseEraseMessage
	else if(!lstrcmp(str, "EraseMouseCursor")) {
		lstrcpy(MouseEraseMessage, str);
		MouseEraseTimeOut = timeGetTime() + TimeOut;
	}
	//OnScreenMessage
	else {
		lstrcpy(OnScreenMessage, str);
		OnScreenMessageTimeOut = timeGetTime() + TimeOut;
		if(DirectX.Windowed) {
			SetWindowText(GUI.hWnd, OnScreenMessage);
		}
	}

	//set timer
	if(!OnScreenMessageTimerActiveFlag) {
		SetTimer(GUI.hWnd, 101, 100, NULL);
		OnScreenMessageTimerActiveFlag = TRUE;
	}
}

static inline BOOL EraseMouseCursor()
{
	if(IPPU.Controller != SNES_SUPERSCOPE &&
	   IPPU.Controller != SNES_JUSTIFIER &&
	   IPPU.Controller != SNES_JUSTIFIER_2 &&
	   !GUI.StopEmulation &&
	   !GUI.PauseEmulation &&
	   !Settings.SPCPlaying) {

		S9xMessage2 ("EraseMouseCursor", 1000);
		return true;
	}
	return false;
}

void OnScreenMessageUpdate()
{
	//ExitMenuMessage
	if(!lstrcmp(ExitMenuMessage, "ExitMenu") && timeGetTime() > ExitMenuTimeOut) {
		if((!MinimizedFlag || Settings.SPCPlaying) &&
		   !GUI.FullScreen &&
		   DirectX.Windowed &&
		   !GUI.PauseEmulation &&
		   WindowActiveFlag &&
		   !SizingFlag &&
		   !ncbuttondown_flag)
			PauseExecution(false, true, false);
		ExitMenuMessage[0] = 0;
		ExitMenuTimeOut = 0;
	}
	//MouseEraseMessage
	if(!lstrcmp(MouseEraseMessage, "EraseMouseCursor") && timeGetTime() > MouseEraseTimeOut) {
		if(IPPU.Controller != SNES_SUPERSCOPE &&
		   IPPU.Controller != SNES_JUSTIFIER &&
		   IPPU.Controller != SNES_JUSTIFIER_2 &&
		   !GUI.StopEmulation &&
		   !GUI.ForcedPauseEmulation &&
		   !GUI.PauseEmulation &&
		   !Settings.SPCPlaying)
			SetCursor(NULL);
		MouseEraseMessage[0] = 0;
		MouseEraseTimeOut = 0;
	}
	//OnScreenMessage
	if(OnScreenMessage[0] && timeGetTime() > OnScreenMessageTimeOut) {
		if(DirectX.Windowed)
		{
			SetWindowText(GUI.hWnd, WindowTitleText);
		}
		OnScreenMessage[0] = 0;
		OnScreenMessageTimeOut = 0;
	}
	if(!ExitMenuMessage[0] && !MouseEraseMessage[0] &&
	   !OnScreenMessage[0] && OnScreenMessageTimerActiveFlag) {
		KillTimer(GUI.hWnd, 101);
		OnScreenMessageTimerActiveFlag = FALSE;
	}
}

void S9xwKillMessageTimer()
{
	if(OnScreenMessageTimerActiveFlag) {
		KillTimer(GUI.hWnd, 101);
		OnScreenMessageTimerActiveFlag = FALSE;
	}
	if(DirectX.Windowed) {
		SetWindowText(GUI.hWnd, WindowTitleText);
	}
	ExitMenuMessage[0] = MouseEraseMessage[0] = OnScreenMessage[0] = 0;
	ExitMenuTimeOut = MouseEraseTimeOut = OnScreenMessageTimeOut = 0;
}

unsigned char SwitchScreenMode(unsigned char Windowed)
{
	bool SwitchDisplayMode = DirectX.Windowed != Windowed;

	CurFullscreenDisplayModeIndexChange();
	PauseExecution(true, true, false);

	if(!Windowed && DirectX.Windowed)
		SetWindowText(GUI.hWnd, WindowTitleText);

	//switch to fullscreen
	if(!Windowed) {
		S9xwDestroyStatusBar();
		if(GetMenu(GUI.hWnd) != NULL) {
			SetMenu(GUI.hWnd, NULL);
			GUI.AppMenuConnect = FALSE;
		}
		RefreshRectParams();
	}

	S9xGraphicsDeinit();

	if(!DirectX_SetDisplayMode(DisplayMode[GUI.CurFullscreenDisplayModeIndex].Width,
							   DisplayMode[GUI.CurFullscreenDisplayModeIndex].Height,
							   DisplayMode[GUI.CurFullscreenDisplayModeIndex].Depth,
							   Windowed, GUI.DoubleBuffered) && !Windowed) {

		DirectX_SetDisplayMode(DisplayMode[GUI.CurFullscreenDisplayModeIndex].Width,
							   DisplayMode[GUI.CurFullscreenDisplayModeIndex].Height,
							   DisplayMode[GUI.CurFullscreenDisplayModeIndex].Depth,
							   TRUE,
							   GUI.DoubleBuffered);
		GUI.ScreenDepth = (DWORD)DirectX.Depth;
		GUI.FullScreen = !DirectX.Windowed;
		S9xSetWindowPos();
		S9xwCreateStatusBar();
		if(GetMenu(GUI.hWnd) == NULL) {
			SetMenu(GUI.hWnd, GUI.hMenu);
			GUI.AppMenuConnect = TRUE;
		}
		RefreshRectParams();
		SetWindowText(GUI.hWnd, WindowTitleText);
		MessageBox(GUI.hWnd,
				   Languages[GUI.Language].errSwitchGFX,
				   "uosnes - Switch GFX mode",
				   MB_OK | MB_ICONSTOP);
		SetMenuStatus(GUI.hMenu, GUI.hSysMenu);
		PostMessage(GUI.hWnd, WM_CLOSE, 0, 0);
		PauseExecution(true, false, true);
		return FALSE;
	}
	GUI.ScreenDepth = (DWORD)DirectX.Depth;
	GUI.FullScreen = !DirectX.Windowed;

	S9xSetWinPixelFormat ();

	//failed
	if(!S9xGraphicsInit())
	{
		S9xGraphicsDeinit();
		DirectX_SetDisplayMode(DisplayMode[GUI.CurFullscreenDisplayModeIndex].Width,
							   DisplayMode[GUI.CurFullscreenDisplayModeIndex].Height,
							   DisplayMode[GUI.CurFullscreenDisplayModeIndex].Depth,
							   TRUE,
							   GUI.DoubleBuffered);
		GUI.ScreenDepth = (DWORD)DirectX.Depth;
		GUI.FullScreen = !DirectX.Windowed;
		S9xSetWindowPos();
		S9xwCreateStatusBar();
		if(GetMenu(GUI.hWnd) == NULL) {
			SetMenu(GUI.hWnd, GUI.hMenu);
			GUI.AppMenuConnect = TRUE;
		}
		RefreshRectParams();
		SetWindowText(GUI.hWnd, WindowTitleText);
		MessageBox(GUI.hWnd,
				   Languages[GUI.Language].errSwitchGFX,
				   "uosnes - Switch GFX mode",
				   MB_OK | MB_ICONSTOP);
		SetMenuStatus(GUI.hMenu, GUI.hSysMenu);
		PostMessage(GUI.hWnd, WM_CLOSE, 0, 0);
		PauseExecution(true, false, true);
		return FALSE;
	}

	S9xInitUpdate ();

	if(!GUI.StopEmulation && !Settings.SPCPlaying) {
		for (int c = 0; c < 256; c++)
			IPPU.ScreenColors [c] = c;
		S9xFixColourBrightness ();
		IPPU.ColorsChanged = TRUE;
		IPPU.RenderThisFrame = FALSE;
	}

	//for clear filter log
	ResetRenderMethod();

	if(DirectX.Windowed) {
		S9xSetInfoString ("");
		if(SwitchDisplayMode) {
			S9xSetWindowPos();
			// It set HWND_TOPMOST by timer
			GUI.SwitchToWindowed = TRUE;
			S9xMessage2 (WindowTitleText, 1000);
		}
		S9xwCreateStatusBar();
		if(GetMenu(GUI.hWnd) == NULL) {
			SetMenu(GUI.hWnd, GUI.hMenu);
			GUI.AppMenuConnect = TRUE;
		}
		RefreshRectParams();
		SetWindowText(GUI.hWnd, WindowTitleText);
	}
	else {
		RefreshRectParams();
	}

	PauseExecution(true, false, true);

	//Erase mouse cursor.
	EraseMouseCursor();

	return TRUE;
}

static void SetClipper(bool clip)
{
	if(GUI.Stretch == 1) {
		DirectX_SetClipper(clip,
						   GUI.ClientRect.right - GUI.ClientRect.left,
						   GUI.ClientRect.bottom - GUI.ClientRect.top,
						   GUI.WindowTopMost);
	}
	else if(GUI.Stretch == 2) {
		long dWidth, dHeight;
		dHeight = ExtendHeight ? 239 : 224;
		dWidth = 256;
		if(GUI.Scale > 0)
			dHeight *= 2;
		if(GUI.Scale > 0)
			dWidth *= 2;
		if((GUI.ClientRect.right - GUI.ClientRect.left) >= dWidth &&
			(GUI.ClientRect.bottom - GUI.ClientRect.top) >= (dHeight * ((GUI.ClientRect.right - GUI.ClientRect.left) / dWidth))) {
			dHeight = ExtendHeight ? 239 : 224;
			dWidth = 256;
			long scalemulw = ((GUI.ClientRect.right - GUI.ClientRect.left) / dWidth);
			long scalemulh = ((GUI.ClientRect.bottom - GUI.ClientRect.top) / dHeight);
			long scalemul = scalemulw < scalemulh ? scalemulw : scalemulh;
			dWidth *= scalemul;
			dHeight *= scalemul;
		}
		else if((GUI.ClientRect.bottom - GUI.ClientRect.top) >= dHeight &&
			(GUI.ClientRect.right - GUI.ClientRect.left) >= (dWidth * ((GUI.ClientRect.bottom - GUI.ClientRect.top) / dHeight))) {
			dHeight = ExtendHeight ? 239 : 224;
			dWidth = 256;
			long scalemulw = ((GUI.ClientRect.right - GUI.ClientRect.left) / dWidth);
			long scalemulh = ((GUI.ClientRect.bottom - GUI.ClientRect.top) / dHeight);
			long scalemul = scalemulw < scalemulh ? scalemulw : scalemulh;
			dWidth *= scalemul;
			dHeight *= scalemul;
		}
		else {
			if((GUI.ClientRect.right - GUI.ClientRect.left) < dWidth) {
				dWidth = GUI.ClientRect.right - GUI.ClientRect.left;
			}
			if((GUI.ClientRect.bottom - GUI.ClientRect.top) < dHeight) {
				dHeight = GUI.ClientRect.bottom - GUI.ClientRect.top;
			}
		}
		DirectX_SetClipper(clip, dWidth, dHeight, GUI.WindowTopMost);
	}
	else {
		long dWidth, dHeight;
		dHeight = ExtendHeight ? 239 : 224;
		dWidth = 256;
		if(GUI.Scale > 0)
			dHeight *= 2;
		if(GUI.Scale > 0)
			dWidth *= 2;
		DirectX_SetClipper(clip,
						   dWidth,
						   dHeight,
						   GUI.WindowTopMost);
	}
}

static void PauseExecution(bool pause, bool lock, bool clear_lock)
{
	if((!pause && !lock) || clear_lock)
		GUI.PauseLock = false;

	if(pause)
		S9xwKillMessageTimer();

	if((GUI.FullScreen && DirectX.Windowed) ||
	   GUI.PauseEmulation ||
	   GUI.PauseLock) {
		S9xSetSoundMute (TRUE);
		return;
	}

	if(pause && lock)
		GUI.PauseLock = true;

	if(SPCLoadedFlag && !pause) {
		Sleep(500);
		SPCLoadedFlag = FALSE;
	}

	GUI.ForcedPauseEmulation = pause;
	S9xSetSoundMute ((bool8)pause);

	SetClipper(pause);

	if(!pause)
		EraseMouseCursor();
}

bool UIEnter()
{
	PauseExecution(true, false, false);
	if(GUI.FullScreen && !DirectX.Windowed) {
		PauseExecution(true, true, false);
		if(SwitchScreenMode(TRUE)) {
			GUI.FullScreen = TRUE;
			SetClipper(TRUE);
			if(GUI.StopEmulation || Settings.SPCPlaying)
				S9xDrawScreenData();
			PauseExecution(true, false, true);
		}
		else
			return FALSE;
	}
	return TRUE;
}

void UIExit()
{
	if((DirectX.Windowed && !GUI.FullScreen) || (!DirectX.Windowed && GUI.FullScreen))
		PauseExecution(false, true, false);
}

void S9xwStateSave(char SaveSlotNum)
{
	if(GUI.StopEmulation || Settings.SPCPlaying || (GUI.PauseEmulation && GUI.FullScreen))
		return;
	char saveext [_MAX_EXT];
	char savemesj[] = "Slot #1 saved";
	char savemese[] = "Slot #1 saved";
	bool8 saveerr;

	lstrcpy(saveext, ".000");

	saveext[3] = (0x30 + SaveSlotNum - 1);
	savemesj[6] = savemese[6] = (0x30 + SaveSlotNum);
	PauseExecution(true, false, false);
	saveerr = S9xFreezeGame(S9xGetFilename(saveext));

	if(GUI.PauseEmulation)
		S9xSetSoundMute (TRUE);
	else
		PauseExecution(false, true, false);

#if 0
	if(saveerr)
		S9xMessage2 (GUI.Language ? savemesj : savemese, 2000);
	else
		S9xMessage2 (GUI.Language ? "Error!" : "Error!", 2000);
#endif
}

void S9xwStateLoad(int SaveSlotNum)
{
	if(GUI.StopEmulation || Settings.SPCPlaying || (GUI.PauseEmulation && GUI.FullScreen))
		return;
	char loadext [_MAX_EXT];
	char loadmesj[] = "Slot #1 loaded";
	char loadmese[] = "Slot #1 loaded";
	bool8 loaderr;

	lstrcpy(loadext, ".000");

	loadext[3] = (0x30 + SaveSlotNum - 1);
	loadmesj[6] = loadmese[6] = (0x30 + SaveSlotNum);

	PauseExecution(true, false, false);
	loaderr = S9xUnfreezeGame(S9xGetFilename(loadext));
	if(GUI.PauseEmulation)
		S9xSetSoundMute (TRUE);
	else
		PauseExecution(false, true, false);
#if 0
	if(loaderr)
		S9xMessage2 (GUI.Language ? loadmesj : loadmese, 2000);
	else
		S9xMessage2 (GUI.Language ? "Error!" : "Error!", 2000);
#endif
}

void S9xwStateSaveReplay()
{
	if(GUI.StopEmulation || Settings.SPCPlaying || (GUI.PauseEmulation && GUI.FullScreen))
		return;
	bool8 saveerr;

	PauseExecution(true, false, false);
	saveerr = S9xFreezeGame(S9xGetFilename(".rpb"));
	if(GUI.PauseEmulation)
		S9xSetSoundMute (TRUE);
	else
		PauseExecution(false, true, false);

	if(saveerr)
        {
		S9xMessage2 (GUI.Language ? "Movie Rec Start" : "Movie Rec Start", 2000);
        }
	else
        {
		S9xMessage2 (GUI.Language ? "Error!" : "Error!", 2000);
	        XxxMovie.Replay_play = false;
	        XxxMovie.Replay_rec = false;
        }
}

void S9xwStateLoadReplay()
{
	if(GUI.StopEmulation || Settings.SPCPlaying || (GUI.PauseEmulation && GUI.FullScreen))
		return;

	bool8 loaderr;
	PauseExecution(true, false, false);
	loaderr = S9xUnfreezeGame(S9xGetFilename(".rpb"));
	if(GUI.PauseEmulation)
		S9xSetSoundMute (TRUE);
	else
		PauseExecution(false, true, false);
	if(loaderr) {
		S9xMessage2 (GUI.Language ? "Movie Play Start" : "Movie Play Start", 2000);
	}
	else {
		S9xMessage2 (GUI.Language ? "Error!" : "Error!", 2000);
		XxxMovie.Replay_play = false;
		XxxMovie.Replay_rec = false;
	}
}

static void AVI_Record(u8 *AVI_Recording)
{
	if(GUI.StopEmulation || Settings.SPCPlaying || (GUI.PauseEmulation && GUI.FullScreen))
		return;
	if(AVI_Recording)
		DoAVIClose(0);
	else
		DoAVIOpen(S9xwGetScreenImageFilename((char *)".avi"));
	*AVI_Recording = !*AVI_Recording;
}

LRESULT CALLBACK WinProc(HWND hWnd,
						 UINT uMsg,
						 WPARAM wParam,
						 LPARAM lParam)
{
	static bool NeedScreenImage = 1;
	static bool NeedJoystickInit = 1;
	static bool ScreenRedraw_OK = FALSE;
	static HDROP hDrop;
	//static RECT SizingClip;
	static HRGN hRgn1, hRgn2, hRgn3;

	switch( uMsg)
	{
	case WM_CREATE:
		RefreshRectParams();
		//inactivate IME
		ImeEnable(hWnd, FALSE);
		DragAcceptFiles(hWnd, TRUE); //set drag&drop
		WindowActiveFlag = 1;
		if(!GUI.Exit && __argc > 1) {
			//get long filename
			if(!GetLongFileName(rom_filename, ROMFileName, _MAX_PATH))
				rom_filename = NULL;
		}
		else {
			rom_filename = NULL;
		}
		if(GUI.Exit) {
			MessageBox(GUI.hWnd,
					   Languages[GUI.Language].errMemoryInit,
					   "uosnes - Memory Init",
					   MB_OK | MB_ICONSTOP);
			PostMessage( hWnd, WM_CLOSE, 0, 0);
		}
		SetMenuStatus(GUI.hMenu, GUI.hSysMenu);
		//SetCursor(GUI.Arrow);
		break;

	//get status of SNES mouse superscope
	case WM_LBUTTONDOWN:
		if((IPPU.Controller == SNES_MOUSE ||
			IPPU.Controller == SNES_MOUSE_SWAPPED) &&
		   !GUI.StopEmulation &&
		   !GUI.ForcedPauseEmulation &&
		   !GUI.PauseEmulation &&
		   !Settings.SPCPlaying)
			SetCursor(NULL);
		else {
			if((IPPU.Controller == SNES_SUPERSCOPE ||
				IPPU.Controller == SNES_JUSTIFIER ||
				IPPU.Controller == SNES_JUSTIFIER_2) &&
			   !GUI.StopEmulation &&
			   !GUI.ForcedPauseEmulation &&
			   !GUI.PauseEmulation &&
			   !Settings.SPCPlaying)
				SetCursor(GUI.GunSight);
			else
				SetCursor(GUI.Arrow);

			EraseMouseCursor();
		}
		GUI.MouseButtons |= 1;
		break;

	case WM_LBUTTONUP:
		GUI.MouseButtons &= ~1;
		break;

	case WM_RBUTTONDOWN:
		if((IPPU.Controller == SNES_MOUSE ||
			IPPU.Controller == SNES_MOUSE_SWAPPED) &&
		   !GUI.StopEmulation &&
		   !GUI.ForcedPauseEmulation &&
		   !GUI.PauseEmulation &&
		   !Settings.SPCPlaying)
			SetCursor(NULL);
		else {
			if((IPPU.Controller == SNES_SUPERSCOPE ||
				IPPU.Controller == SNES_JUSTIFIER ||
				IPPU.Controller == SNES_JUSTIFIER_2) &&
			   !GUI.StopEmulation &&
			   !GUI.ForcedPauseEmulation &&
			   !GUI.PauseEmulation &&
			   !Settings.SPCPlaying)
				SetCursor(GUI.GunSight);
			else
				SetCursor(GUI.Arrow);

			EraseMouseCursor();
		}
		GUI.MouseButtons |= 2;
		break;

	case WM_RBUTTONUP:
		GUI.MouseButtons &= ~2;
		break;

	case WM_MBUTTONDOWN:
		if((IPPU.Controller == SNES_MOUSE ||
			IPPU.Controller == SNES_MOUSE_SWAPPED) &&
		   !GUI.StopEmulation &&
		   !GUI.ForcedPauseEmulation &&
		   !GUI.PauseEmulation &&
		   !Settings.SPCPlaying)
			SetCursor(NULL);
		else {
			if((IPPU.Controller == SNES_SUPERSCOPE ||
				IPPU.Controller == SNES_JUSTIFIER ||
				IPPU.Controller == SNES_JUSTIFIER_2) &&
			   !GUI.StopEmulation &&
			   !GUI.ForcedPauseEmulation &&
			   !GUI.PauseEmulation &&
			   !Settings.SPCPlaying)
				SetCursor(GUI.GunSight);
			else
				SetCursor(GUI.Arrow);

			EraseMouseCursor();
		}
		GUI.MouseButtons |= 4;
		break;

	case WM_MBUTTONUP:
		GUI.MouseButtons &= ~4;
		break;

	case WM_MOUSEMOVE:
            if (!GUI.IgnoreNextMouseMove)
            {
                POINT p;
                p.x = (int16) (lParam & 0xffff);
                p.y = (int16) ((lParam >> 16) & 0xffff);
                ClientToScreen (GUI.hWnd, &p);
                if ((!Settings.ForcedPause && !Settings.StopEmulation && 
                     !Settings.Paused && !Settings.SPCPlaying) &&
                    (IPPU.Controller == SNES_MOUSE ||
                     IPPU.Controller == SNES_MOUSE_SWAPPED))
                {
                    POINT middle;
                    RECT size;
                    
					size = GUI.ClientRect;
                    middle.x = (size.right - size.left) >> 1;
                    middle.y = (size.bottom - size.top) >> 1;
                    ClientToScreen (GUI.hWnd, &middle);
                    GUI.MouseX += p.x - middle.x;
                    GUI.MouseY += p.y - middle.y;
                    SetCursorPos (middle.x, middle.y);
                    GUI.IgnoreNextMouseMove = TRUE;
                }
                else
                {
                    GUI.MouseX = p.x;
                    GUI.MouseY = p.y;
                }
            }
            else
                GUI.IgnoreNextMouseMove = FALSE;

		if((IPPU.Controller == SNES_MOUSE ||
			IPPU.Controller == SNES_MOUSE_SWAPPED) &&
		   !GUI.StopEmulation &&
		   !GUI.ForcedPauseEmulation &&
		   !GUI.PauseEmulation &&
		   !Settings.SPCPlaying)
			SetCursor(NULL);
		else {
			if((GUI.MousePosition.x + 2) <= (LONG)LOWORD(lParam) || (GUI.MousePosition.y + 2) <= (LONG)HIWORD(lParam) ||
				(GUI.MousePosition.x - 2) >= (LONG)LOWORD(lParam) || (GUI.MousePosition.y - 2) >= (LONG)HIWORD(lParam)) {

				if((IPPU.Controller == SNES_SUPERSCOPE ||
					IPPU.Controller == SNES_JUSTIFIER ||
					IPPU.Controller == SNES_JUSTIFIER_2) &&
				   !GUI.StopEmulation &&
				   !GUI.ForcedPauseEmulation &&
				   !GUI.PauseEmulation &&
				   !Settings.SPCPlaying)
					SetCursor(GUI.GunSight);
				else
					SetCursor(GUI.Arrow);

				GUI.MousePosition.x = (int16) (lParam & 0xffff);
				GUI.MousePosition.y = (int16) ((lParam >> 16) & 0xffff);
			}
			else
				return 0;

			EraseMouseCursor();
		}
		break;

	case WM_SETCURSOR:
		break;

	case WM_NCMOUSEMOVE:
		GUI.MouseButtons = 0;
		break;

	case WM_TIMER:
		if(!DirectX.Windowed && OnScreenMessage[0]) {
			lstrcpy(S9xInfoString, OnScreenMessage);
			S9xSetInfoString (S9xInfoString);
			OnScreenMessage[0] = 0;
			OnScreenMessageTimeOut = 0;
		}
		else if(OnScreenMessage[0] || ExitMenuMessage[0] || MouseEraseMessage[0])
			OnScreenMessageUpdate();

		//set HWND_TOPMOST after switch screen mode
		if(GUI.SwitchToWindowed) {
			GUI.SwitchToWindowed = FALSE;
			if(GUI.WindowTopMost && GetForegroundWindow() == hWnd)
				SetWindowPos(hWnd, HWND_TOPMOST, 0, 0, 0, 0, SWP_NOMOVE | SWP_NOSIZE);
		}
		break;

	case WM_EXITMENULOOP:
		S9xMessage2("ExitMenu", 200);
		break;

	case WM_MOVE:
		RefreshRectParams();
		break;

	case WM_MOVING:
		RefreshRectParams();
		break;

	case WM_ACTIVATE:
		switch(LOWORD(wParam))
		{
			case WA_ACTIVE: case WA_CLICKACTIVE:
				WindowActiveFlag = 1;

				if(GUI.WindowTopMost) {
					SetWindowPos(hWnd, HWND_TOPMOST, 0, 0, 0, 0, SWP_NOMOVE | SWP_NOSIZE);
				}
				else {
					SetWindowPos(hWnd, HWND_NOTOPMOST, 0, 0, 0, 0, SWP_NOMOVE | SWP_NOSIZE);
				}

				if(!GUI.StopEmulation)
					SetPriorityClassAndThreadPriority(GUI.PriorityClass, GUI.ThreadPriority);
				else
					SetPriorityClassAndThreadPriority(NORMAL_PRIORITY_CLASS, THREAD_PRIORITY_NORMAL);
				if(!GUI.FullScreen && DirectX.Windowed && !ncbuttondown_flag && !MinimizedFlag) {
					PauseExecution(false, true, false);
				}
				break;
			
			case WA_INACTIVE:
				{
					HWND hActive, hTop, hChild;
					hActive = GetForegroundWindow();
					WindowActiveFlag = 0;

					if((hTop = hActive)) {
						for(; (hChild = GetParent(hTop)); hTop = hChild);
					}
					
					if(GUI.WindowTopMost && hActive && hTop != hWnd && GetWindow(hActive, GW_HWNDNEXT)) {
						SetWindowPos(hWnd, hActive, 0, 0, 0, 0, SWP_NOMOVE | SWP_NOSIZE);
					}
					else {
						SetWindowPos(hWnd, HWND_NOTOPMOST, 0, 0, 0, 0, SWP_NOMOVE | SWP_NOSIZE);
					}

					if(Settings.SPCPlaying && MinimizedFlag) {
						PauseExecution(false, true, false);
					}
					else {
						if(hTop == hWnd || !Options.inactive_x) {
							SetPriorityClassAndThreadPriority(NORMAL_PRIORITY_CLASS, THREAD_PRIORITY_NORMAL);
							PauseExecution(true, false, false);
						}
						else
							SetClipper(TRUE);
					}
				}
				break;

			default:
				break;
		}
		break;

/*
	case WM_ACTIVATEAPP:
		if(wParam && !GUI.FullScreen && DirectX.Windowed && !ncbuttondown_flag && !MinimizedFlag) {
			WindowActiveFlag = 1;
			PauseExecution(false, true, false);
		}
		else if(!wParam && !Settings.SPCPlaying) {
			WindowActiveFlag = 0;
			PauseExecution(true, false, false);
		}
		break;
*/

	case WM_DROPFILES:
		/* drag&drop */
		if(GUI.PauseEmulation)
			break;
		{
			SetAbsoluteForegroundWindow(hWnd);
			hDrop=(HDROP)wParam;
			DragQueryFile(hDrop, 0, ROMFileName, _MAX_PATH);
			DragFinish(hDrop);
			PauseExecution(true, false, false);
			UpdateBackBuffer();
			ROMLoadProc(ROMFileName);
			if(!GUI.StopEmulation)
				SetPriorityClassAndThreadPriority(GUI.PriorityClass, GUI.ThreadPriority);
			else
				SetPriorityClassAndThreadPriority(NORMAL_PRIORITY_CLASS, THREAD_PRIORITY_NORMAL);
			PauseExecution(false, true, false);
			EraseMouseCursor();
		}
		break;

	case WM_KEYDOWN:
		switch(wParam)
		{
		case VK_ESCAPE:
			//window mode
			if(DirectX.Windowed && !GUI.FullScreen) {
				if(GetMenu(GUI.hWnd) == NULL) {
					SetMenu(GUI.hWnd, GUI.hMenu);
					RefreshRectParams();
					GUI.AppMenuConnect = TRUE;
					DrawMenuBar(GUI.hWnd);
				}
				else {
					SetMenu(GUI.hWnd, NULL);
					RefreshRectParams();
					GUI.AppMenuConnect = FALSE;
				}
				RECT rc = GUI.ClientRect;
				HDC hdc = GetDC(GUI.hWnd);
				FillRect(hdc, &rc, (HBRUSH)GetStockObject(BLACK_BRUSH));
				ReleaseDC(GUI.hWnd, hdc);
				SetMenuStatus(GUI.hMenu, GUI.hSysMenu);
				if(GUI.StopEmulation || Settings.SPCPlaying)
					UosneswScreenRedraw(hWnd);
			}
			//full screen mode
			else if(!DirectX.Windowed && GUI.FullScreen) {
				if(SwitchScreenMode(TRUE)) {
					GUI.FullScreen = TRUE;
					SetClipper(TRUE);
					if(GUI.StopEmulation || Settings.SPCPlaying)
						S9xDrawScreenData();
					PauseExecution(true, false, true);
				}
			}
			else if(DirectX.Windowed && GUI.FullScreen && !GUI.StopEmulation) {
				if(SwitchScreenMode(FALSE))
					PauseExecution(false, true, false);
				else
					break;
			}
			break;

		//State save load
		case VK_F1:
		case VK_F2:
		case VK_F3:
		case VK_F4:
		case VK_F5:
		case VK_F6:
		case VK_F7:
		case VK_F8:
		case VK_F9:
			if(GUI.StopEmulation || Settings.SPCPlaying)
				break;
			//load
			if((GetKeyState(VK_SHIFT) & 0x8000) == 0) {
				wsprintf(tmpcharbuf, ".%03d", wParam - VK_F1);
				if(GetFileAttributes(S9xGetFilename(tmpcharbuf)) == 0xffffffff)
					break;
				S9xwStateLoad(wParam - VK_F1 + 1);
			}
			//save
			else {
				S9xwStateSave(wParam - VK_F1 + 1);
			}
			break;

		default:
			break;
		}
		break;

	case WM_SYSKEYUP:
		switch(wParam)
		{
			case VK_RETURN:
				if((DirectX.Windowed && DirectX.Depth == 8) || Settings.SPCPlaying)
					break;
				PauseExecution(true, false, false);

				if(GUI.FullScreen && DirectX.Windowed || (!GUI.FullScreen && DirectX.Windowed && GUI.StopEmulation))
					GUI.FullScreen = !GUI.FullScreen;
				// to full screen
				else if(!GUI.FullScreen && DirectX.Windowed && !GUI.StopEmulation) {
					if(!SwitchScreenMode(FALSE))
						break;
				}
				// to windowed
				else if(GUI.FullScreen && !DirectX.Windowed && !GUI.StopEmulation) {
					if(!SwitchScreenMode(TRUE))
						break;
				}
				PauseExecution(false, true, false);
				break;

			default:
				break;
		}
		break;

	case WM_COMMAND:
		switch(LOWORD(wParam))
		{
		case ID_FILE_OPEN:
			if(GUI.PauseEmulation || !UIEnter())
				break;
			PauseExecution(true, true, false);
			if(GetFileAttributes(InitialROMFileDirectory) == 0xffffffff) {
				char drive [_MAX_DRIVE + 1];
				char dir [_MAX_DIR + 1];
				char fname [_MAX_FNAME + 1];
				char ext [_MAX_EXT + 1];

				if(strlen((const char *)Options.HomeDirectory) < _MAX_PATH - 7)
					strcpy(ROMFileName, (const char *)Options.HomeDirectory);
				else
					strcpy(ROMFileName, "c:\\");

				_splitpath(ROMFileName, drive, dir, fname, ext);
				if(fname[0])
					lstrcat(ROMFileName, "\\a.smc");
				else
					lstrcat(ROMFileName, "a.smc");
				_splitpath(ROMFileName, drive, dir, fname, ext);
				_makepath(InitialROMFileDirectory, drive, dir, NULL, NULL);
			}
			if ((GUI.FileBrowseWindow == 0 && OpenFile(hWnd, ROMFileName, FileTitle, InitialROMFileDirectory)) ||
				(GUI.FileBrowseWindow == 1 && OpenFileEx(hWnd, ROMFileName, FileTitle, InitialROMFileDirectory))) {
				UpdateBackBuffer();
				ROMLoadProc(ROMFileName);
				if(!GUI.StopEmulation)
					SetPriorityClassAndThreadPriority(GUI.PriorityClass, GUI.ThreadPriority);
				else
					SetPriorityClassAndThreadPriority(NORMAL_PRIORITY_CLASS, THREAD_PRIORITY_NORMAL);
			}
			PauseExecution(true, false, true);
			UIExit();
			EraseMouseCursor();
			break;

		case ID_FILE_RECENT1:
		case ID_FILE_RECENT2:
		case ID_FILE_RECENT3:
		case ID_FILE_RECENT4:
		case ID_FILE_RECENT5:
		case ID_FILE_RECENT6:
		case ID_FILE_RECENT7:
		case ID_FILE_RECENT8:
		case ID_FILE_RECENT9:
		case ID_FILE_RECENTA:
			if(GUI.PauseEmulation)
				break;
			UpdateBackBuffer();
			PauseExecution(true, false, false);
			ROMLoadProc(&RecentROMFileName[_MAX_PATH * (LOWORD(wParam) - ID_FILE_RECENT1)]);
			if(!GUI.StopEmulation)
				SetPriorityClassAndThreadPriority(GUI.PriorityClass, GUI.ThreadPriority);
			else
				SetPriorityClassAndThreadPriority(NORMAL_PRIORITY_CLASS, THREAD_PRIORITY_NORMAL);
			PauseExecution(false, true, false);
			break;

		case ID_FILE_RESET:
			if(GUI.StopEmulation || Settings.SPCPlaying || GUI.PauseEmulation)
				break;
			PauseExecution(true, false, false);
			S9xReset(TRUE);

			// Original
			if(Xxxcdda.Enable)
				cdda_stop();

#ifdef UNCO_FULL_TEAM
			if(Xxxbsx.BsxRomCheck) {
				BSX_CLEAR ();
				BSX_TIMESET (); 
			}
#endif
			UosneswScreenInit();
			if(GUI.FullScreen && DirectX.Windowed)
			{
				if(!SwitchScreenMode(FALSE))
					break;
			}
			else
				UpdateBackBuffer();
			PauseExecution(false, true, false);
			break;

		case ID_FILE_SOFTRESET:
			if(GUI.StopEmulation || Settings.SPCPlaying || GUI.PauseEmulation)
				break;
			PauseExecution(true, false, false);
			S9xReset(FALSE);

			// Original
			if(Xxxcdda.Enable)
				cdda_stop();

#ifdef UNCO_FULL_TEAM
			if(Xxxbsx.BsxRomCheck) {
				BSX_CLEAR ();
				BSX_TIMESET (); 
			}
#endif

			UosneswScreenInit();
			if(GUI.FullScreen && DirectX.Windowed)
			{
				if(!SwitchScreenMode(FALSE))
					break;
			}
			else
				UpdateBackBuffer();
			PauseExecution(false, true, false);
			break;

		case ID_FILE_BACKTOIDLE:
			if(GUI.StopEmulation)
				break;

			if(!GUI.StopEmulation && ExecLoop == S9xMainLoop) {
				Memory.SaveSRAM( S9xGetFilename(".srm"));
				S9xSaveCheatFile(S9xGetFilename(".cht"));
				if(Xxxcdda.Enable)
					cdda_exit(); // Original
				XXX_REPLAY_END ();
			}

			S9xReset(TRUE);
			GUI.StopEmulation = TRUE;
			ExecLoop = NullExecLoop;
			SPCLoadedFlag = FALSE;
			Settings.SPCPlaying = FALSE;
			DirectX.ForceClipper = TRUE;

			// FullScreen Mode
			if(!DirectX.Windowed) {
				PauseExecution(true, true, false);
				if(SwitchScreenMode(TRUE)) {
					GUI.FullScreen = TRUE;
					SetClipper(TRUE);
					if(GUI.StopEmulation || Settings.SPCPlaying)
						S9xDrawScreenData();
					PauseExecution(true, false, true);
				}
				else
					break;
			}
			// Windowed Mode
			else {
				PauseExecution(true, true, false);
				SetClipper(TRUE);
				if(GUI.StopEmulation || Settings.SPCPlaying)
					S9xDrawScreenData();
				PauseExecution(true, false, true);
			}

			SetMenuStatus(GUI.hMenu, GUI.hSysMenu);
			DisplayStatusInfo();
			UosneswScreenRedraw(hWnd);
			SetCursor(GUI.Arrow);
			break;

		case ID_FILE_SPCDUMP:
			if(GUI.StopEmulation || Settings.SPCPlaying || (GUI.PauseEmulation && GUI.FullScreen))
				break;
			spc_is_dumping = 1;
			break;

		case ID_FILE_ZSTSAVE:
			if(GUI.StopEmulation || Settings.SPCPlaying || (GUI.PauseEmulation && GUI.FullScreen))
				break;
			{
				uint8 zstsaveerr;
				PauseExecution(true, false, false);
				extern bool8 S9xFreezeZSNES (const char *filename);
				zstsaveerr = S9xFreezeZSNES(S9xGetFilename(".zst"));
				if(GUI.PauseEmulation)
					S9xSetSoundMute (TRUE);
				else
					PauseExecution(false, true, false);
				if(zstsaveerr)
					S9xMessage2 (GUI.Language ? ".zst Z[u" : ".zst saved", 2000);
				else
					S9xMessage2 (GUI.Language ? "G[!" : "Error!", 2000);
			}
			break;

		case ID_FILE_SCREENSHOT:
			if(GUI.StopEmulation || Settings.SPCPlaying || (GUI.PauseEmulation && GUI.FullScreen))
				break;
			{
				PauseExecution(true, true, false);

				const char *fext;

				//Select image file format.
				switch (Options.SaveImagefileFormat) {
				case 0:
					fext = ".bmp";
					break;
					
				case 1:
					fext = ".pcx";
					break;
				
				case 2:
					fext = ".gif";
					break;
					
				case 3:
					fext = ".png";
					break;
				
				default:
					fext = ".bmp";
					break;
				}

				bool8 ErrResult = S9xTakeScreenShot(S9xwGetScreenImageFilename((char *)fext),
													Options.ReduceTheColorTo256,
													Options.ReduceTheColorTo256IfWithin,
													Options.ImagefileHiresStretch,
													Options.RLEcompression256bitmap);

				if(ErrResult) {
					lstrcpy(OnScreenMessageStr, S9xwGetSavedScreenImageNumberAndTypeStr());
					lstrcat(OnScreenMessageStr, GUI.Language ? " Z[u" : " saved");
				}
				else
					lstrcpy(OnScreenMessageStr, GUI.Language ? "G[!" : "Error!");
				PauseExecution(false, false, false);
				S9xMessage2 (OnScreenMessageStr, 2000);
			}
			break;

		case ID_FILE_WRITE_MOVIE:
			break;

		case ID_FILE_WRITE_AVI:
			//AVI_Record(&Options.AVI_Recording);
			break;

		case ID_OPTION_TOGGLE:
			{
				Options.toggle ^= TRUE;
#ifndef DEBUGGER
				if(Options.toggle)
					S9xMessage2 (GUI.Language ? "toggle I" : "toggle on", 2000);
				else
					S9xMessage2 (GUI.Language ? "toggle It" : "toggle off", 2000);
#else
			  if(GUI.StopEmulation || Settings.SPCPlaying || GUI.PauseEmulation)
				break;
				
				if(!trace && !(CPU.Flags & TRACE_FLAG)) {
					int logsavednum;
					TracelogFilename = (char *)S9xGetNumFilename(GUI.FreezeFileDir, ".log", &logsavednum);
					
					if(TracelogFilename)
						trace = fopen (TracelogFilename, "wb");
					if(trace)
						CPU.Flags |= TRACE_FLAG;
					if(trace && (CPU.Flags & TRACE_FLAG)) {
						lstrcpy((LPTSTR)OnScreenMessageStr, (LPCTSTR)S9xBasename(TracelogFilename));
						lstrcat(OnScreenMessageStr, " tracing");
						S9xMessage2 (OnScreenMessageStr, 2000);
					}
				}
				else if(trace && (CPU.Flags & TRACE_FLAG)) {
					CPU.Flags ^= TRACE_FLAG;
					fclose(trace);
					trace = NULL;
					if(!trace && !(CPU.Flags & TRACE_FLAG)) {
						lstrcpy((LPTSTR)OnScreenMessageStr, (LPCTSTR)S9xBasename(TracelogFilename));
						lstrcat(OnScreenMessageStr, " tracing off");
						S9xMessage2 (OnScreenMessageStr, 2000);
					}
				}
#endif
#ifdef UOSNESW_TRACE
			  if(GUI.StopEmulation || Settings.SPCPlaying || GUI.PauseEmulation)
				break;
				
				if(!tracex) {
					int logsavednum;
					uowTracelogFilename = (char *)S9xGetNumFilename(GUI.FreezeFileDir, ".log", &logsavednum);
					if(uowTracelogFilename)
						tracex = fopen (uowTracelogFilename, "wb");
					if(tracex) {
						lstrcpy((LPTSTR)OnScreenMessageStr, (LPCTSTR)S9xBasename(uowTracelogFilename));
						lstrcat(OnScreenMessageStr, " tracing");
						S9xMessage2 (OnScreenMessageStr, 2000);
					}
				}
				else if(tracex) {
					fclose(tracex);
					tracex = NULL;
					if(!tracex) {
						lstrcpy((LPTSTR)OnScreenMessageStr, (LPCTSTR)S9xBasename(uowTracelogFilename));
						lstrcat(OnScreenMessageStr, " tracing off");
						S9xMessage2 (OnScreenMessageStr, 2000);
					}
				}

#endif
			}
			break;

		case ID_FILE_SA1TRACE:
			{
#ifdef DEBUGGER
			  if(GUI.StopEmulation || Settings.SPCPlaying || GUI.PauseEmulation)
				break;
				
				if(!trace2 && !(SA1.Flags & TRACE_FLAG)) {
					int logsavednum;
					TracelogFilename = (char *)S9xGetNumFilename(GUI.FreezeFileDir, ".log", &logsavednum);
					
					if(TracelogFilename)
						trace2 = fopen (TracelogFilename, "wb");
					if(trace2)
						SA1.Flags |= TRACE_FLAG;
					if(trace2 && (SA1.Flags & TRACE_FLAG)) {
						lstrcpy((LPTSTR)OnScreenMessageStr, (LPCTSTR)S9xBasename(TracelogFilename));
						lstrcat(OnScreenMessageStr, " tracing");
						S9xMessage2 (OnScreenMessageStr, 2000);
					}
				}
				else if(trace2 && (SA1.Flags & TRACE_FLAG)) {
					SA1.Flags ^= TRACE_FLAG;
					fclose(trace2);
					trace2 = NULL;
					if(!trace2 && !(SA1.Flags & TRACE_FLAG)) {
						lstrcpy((LPTSTR)OnScreenMessageStr, (LPCTSTR)S9xBasename(TracelogFilename));
						lstrcat(OnScreenMessageStr, " tracing off");
						S9xMessage2 (OnScreenMessageStr, 2000);
					}
				}
#endif
			}
			break;

		case ID_FILE_EXIT:
			PostMessage(hWnd, WM_CLOSE, 0, 0);
			break;

		case ID_OPTION_DOUBLE:
			{
				if(GUI.PauseEmulation)
					break;
				GUI.DoubleRendering = !GUI.DoubleRendering;
				if(!GUI.DoubleRendering) {
					if(Settings.SixteenBit)
						GUI.DoubleRenderingModes16 = GUI.Scale;
					else
						GUI.DoubleRenderingModes8 = GUI.Scale;
					GUI.Scale = 0;
					Settings.SupportHiRes = FALSE;
				}
				else {
					ResetRenderMethod();
					GUI.Scale = (Settings.SixteenBit ? GUI.DoubleRenderingModes16 : GUI.DoubleRenderingModes8);
					Settings.SupportHiRes = GUI.SupportHiRes;
				}
				//Window mode
				if(DirectX.Windowed) {
					PauseExecution(true, true, false);
					RECT rc = GUI.ClientRect;
					HDC hdc = GetDC(GUI.hWnd);
					FillRect(hdc, &rc, (HBRUSH)GetStockObject(BLACK_BRUSH));
					ReleaseDC(GUI.hWnd, hdc);
					S9xGraphicsDeinit();
					//error
					if(!S9xGraphicsInit())
					{
						S9xGraphicsDeinit();
						SetWindowText(GUI.hWnd, WindowTitleText);
						MessageBox(GUI.hWnd,
								   Languages[GUI.Language].errSwitchGFX,
								   "uosnes - Switch GFX mode",
								   MB_OK | MB_ICONSTOP);
						SetMenuStatus(GUI.hMenu, GUI.hSysMenu);
						PostMessage( GUI.hWnd, WM_CLOSE, 0, 0);
						break;
					}
					S9xInitUpdate ();
					if(GUI.StopEmulation || Settings.SPCPlaying)
						S9xDrawScreenData();
					PauseExecution(true, false, true);
				}
				else {
					if(!SwitchScreenMode(FALSE))
						break;
				}
				PauseExecution(false, true, false);
			}
			break;

		case ID_OPTION_ADJUSTWINDOW:
			{
				if(!DirectX.Windowed || GUI.PauseEmulation)
					break;
				RECT rc, rcWindow;
				GetWindowRect(hWnd, &rcWindow);
				//Window size addjust
				if((rcWindow.right - rcWindow.left) != (GUI.DoubleRendering ? GUI.DefaultWindowSizeWW : GUI.DefaultWindowSizeW) ||
					(rcWindow.bottom - rcWindow.top) != (GUI.DoubleRendering ? GUI.DefaultWindowSizeHH : GUI.DefaultWindowSizeH)) {
					PauseExecution(true, true, false);
					rcWindow.right = (GUI.DoubleRendering ? GUI.DefaultWindowSizeWW : GUI.DefaultWindowSizeW);
					rcWindow.bottom = (GUI.DoubleRendering ? GUI.DefaultWindowSizeHH : GUI.DefaultWindowSizeH);
					MoveWindow(hWnd, rcWindow.left, rcWindow.top, rcWindow.right, rcWindow.bottom, TRUE);
					RefreshRectParams();
					rc = GUI.ClientRect;
					HDC hdc = GetDC(GUI.hWnd);
					FillRect(hdc, &rc, (HBRUSH)GetStockObject(BLACK_BRUSH));
					ReleaseDC(GUI.hWnd, hdc);
					//save window size
					GetWindowRect(hWnd, &GUI.WindowRectSetting);
					if(GUI.StopEmulation || Settings.SPCPlaying)
						S9xDrawScreenData();
					PauseExecution(true, false, true);
					PauseExecution(false, true, false);
					break;
				}
				GUI.DoubleRendering = !GUI.DoubleRendering;
				if(!GUI.DoubleRendering) {
					if(Settings.SixteenBit)
						GUI.DoubleRenderingModes16 = GUI.Scale;
					else
						GUI.DoubleRenderingModes8 = GUI.Scale;
					GUI.Scale = 0;
					Settings.SupportHiRes = FALSE;
				}
				else {
					ResetRenderMethod();
					GUI.Scale = (Settings.SixteenBit ? GUI.DoubleRenderingModes16 : GUI.DoubleRenderingModes8);
					Settings.SupportHiRes = GUI.SupportHiRes;
				}
				PauseExecution(true, true, false);
				GetWindowRect(hWnd, &rcWindow);
				rcWindow.right = (GUI.DoubleRendering ? GUI.DefaultWindowSizeWW : GUI.DefaultWindowSizeW);
				rcWindow.bottom = (GUI.DoubleRendering ? GUI.DefaultWindowSizeHH : GUI.DefaultWindowSizeH);
				MoveWindow(hWnd, rcWindow.left, rcWindow.top, rcWindow.right, rcWindow.bottom, TRUE);
				RefreshRectParams();
				rc = GUI.ClientRect;
				HDC hdc = GetDC(GUI.hWnd);
				FillRect(hdc, &rc, (HBRUSH)GetStockObject(BLACK_BRUSH));
				ReleaseDC(GUI.hWnd, hdc);
				// save window size
				GetWindowRect(hWnd, &GUI.WindowRectSetting);

				S9xGraphicsDeinit();
				// error
				if(!S9xGraphicsInit())
				{
					S9xGraphicsDeinit();
					SetWindowText(GUI.hWnd, WindowTitleText);
					MessageBox(GUI.hWnd,
							   Languages[GUI.Language].errSwitchGFX,
							   "uosnes - Switch GFX mode",
							   MB_OK | MB_ICONSTOP);
					SetMenuStatus(GUI.hMenu, GUI.hSysMenu);
					PostMessage( GUI.hWnd, WM_CLOSE, 0, 0);
					break;
				}
				S9xInitUpdate ();
				if(GUI.StopEmulation || Settings.SPCPlaying)
					S9xDrawScreenData();
				PauseExecution(false, false, false);
			}
			break;

		case ID_OPTION_STRETCH:
			PauseExecution(true, false, false);
			if(GUI.Stretch == 1)
				GUI.Stretch = 0;
			else
				GUI.Stretch = 1;
			ResetRenderMethod();
			if(DirectX.Windowed) {
				RECT rc = GUI.ClientRect;
				HDC hdc = GetDC(GUI.hWnd);
				FillRect(hdc, &rc, (HBRUSH)GetStockObject(BLACK_BRUSH));
				ReleaseDC(GUI.hWnd, hdc);
				if(GUI.StopEmulation || Settings.SPCPlaying)
					S9xDrawScreenData();
			}
			else
				UpdateBackBuffer();
			PauseExecution(false, true, false);
			break;

		case ID_OPTION_SCALESTRETCH:
			PauseExecution(true, false, false);
			if(GUI.Stretch == 2)
				GUI.Stretch = 0;
			else
				GUI.Stretch = 2;
			ResetRenderMethod();
			if(DirectX.Windowed) {
				RECT rc = GUI.ClientRect;
				HDC hdc = GetDC(GUI.hWnd);
				FillRect(hdc, &rc, (HBRUSH)GetStockObject(BLACK_BRUSH));
				ReleaseDC(GUI.hWnd, hdc);
				if(GUI.StopEmulation || Settings.SPCPlaying)
					S9xDrawScreenData();
			}
			else
				UpdateBackBuffer();
			PauseExecution(false, true, false);
			break;

		case ID_OPTION_CONFIG:
			if(GUI.PauseEmulation || !UIEnter())
				break;
			ConfigDlgProp(hWnd);
			if(errConfigSwitch)
				break;
			UIExit();
			EraseMouseCursor();
			break;

		case ID_OPTION_CHEATCODE:
			if(GUI.StopEmulation || Settings.SPCPlaying || !UIEnter())
				break;
			DisplaySNESCheatCodeWindow();
			UIExit();
			EraseMouseCursor();
			SetMenuStatus(GUI.hMenu, GUI.hSysMenu);
			break;

		case ID_OPTION_FULLSCREEN:
			if((DirectX.Windowed && DirectX.Depth == 8) || Settings.SPCPlaying)
				break;	
			PauseExecution(true, false, false);
			if(GUI.FullScreen && DirectX.Windowed || (!GUI.FullScreen && DirectX.Windowed && GUI.StopEmulation))
				GUI.FullScreen = !GUI.FullScreen;
			// switch to full screen
			else if(!GUI.FullScreen && DirectX.Windowed && !GUI.StopEmulation) {
				if(!SwitchScreenMode(FALSE))
					break;
			}
			// switch to windowed
			else if(GUI.FullScreen && !DirectX.Windowed && !GUI.StopEmulation) {
				if(!SwitchScreenMode(TRUE))
					break;
			}
			PauseExecution(false, true, false);
			break;

		case ID_OPTION_FPS:
			if(Settings.DisplayFrameRate)
				Settings.DisplayFrameRate = 0;
			else
				Settings.DisplayFrameRate = 1;
			break;

		//{[ύX
		case ID_OPTION_VLUP:
			if(Options.VolumeLevel < 5) {
				++Options.VolumeLevel;
				SetAPUDSPAmp(FIXED_POINT * Options.VolumeLevel);
			}
			lstrcpy(OnScreenMessageStr, "Level ");
			wsprintf(OnScreenMessageStr + lstrlen(OnScreenMessageStr), "%d ", Options.VolumeLevel);
			lstrcat(OnScreenMessageStr, GUI.Language ? "{[Up" : "Volume Up");
			S9xMessage2 (OnScreenMessageStr, 2000);
			break;

		case ID_OPTION_VLDOWN:
			if(Options.VolumeLevel > 1) {
				--Options.VolumeLevel;
				SetAPUDSPAmp(FIXED_POINT * Options.VolumeLevel);
			}
			lstrcpy(OnScreenMessageStr, "Level ");
			wsprintf(OnScreenMessageStr + lstrlen(OnScreenMessageStr), "%d ", Options.VolumeLevel);
			lstrcat(OnScreenMessageStr, GUI.Language ? "{[Down" : "Volume Down");
			S9xMessage2 (OnScreenMessageStr, 2000);
			break;

		case ID_OPTION_VL1:
			Options.VolumeLevel = 1;
			SetAPUDSPAmp(FIXED_POINT * Options.VolumeLevel);
			break;

		case ID_OPTION_VL2:
			Options.VolumeLevel = 2;
			SetAPUDSPAmp(FIXED_POINT * Options.VolumeLevel);
			break;

		case ID_OPTION_VL3:
			Options.VolumeLevel = 3;
			SetAPUDSPAmp(FIXED_POINT * Options.VolumeLevel);
			break;

		case ID_OPTION_VL4:
			Options.VolumeLevel = 4;
			SetAPUDSPAmp(FIXED_POINT * Options.VolumeLevel);
			break;

		case ID_OPTION_VL5:
			Options.VolumeLevel = 5;
			SetAPUDSPAmp(FIXED_POINT * Options.VolumeLevel);
			break;

		case ID_OPTION_JP:
			if(!Options.JPenvFlag)
				break;
			PauseExecution(true, true, false);
			GUI.Language = !GUI.Language;
			if(DirectX.Windowed && GetMenu( GUI.hWnd) != NULL) {
				SetMenu( GUI.hWnd, NULL);
				RefreshRectParams();
				GUI.AppMenuConnect = FALSE;
				if(GUI.hRecentGamesMenu)
					DestroyMenu(GUI.hRecentGamesMenu);
				GUI.hRecentGamesMenu = 0;
				DestroyMenu(GUI.hMenu);
				GUI.hMenu = LoadMenu((HINSTANCE)GetWindowLong(hWnd, GWL_HINSTANCE),
									 MAKEINTRESOURCE( Languages[ GUI.Language].idMenu));
				InsertMenu(GetSubMenu(GUI.hMenu, 1),
						   6, MF_BYPOSITION,
						   ID_OPTION_JP,
						   GUI.Language ? "{ UI(&U)\tCtrl+U" : "English &UI\tCtrl+U");
				SetMenu( GUI.hWnd, GUI.hMenu);
				RefreshRectParams();
				GUI.AppMenuConnect = TRUE;
				DrawMenuBar(GUI.hWnd);
			}
			else {
				if(GUI.hRecentGamesMenu)
					DestroyMenu(GUI.hRecentGamesMenu);
				GUI.hRecentGamesMenu = 0;
				DestroyMenu(GUI.hMenu);
				GUI.AppMenuConnect = FALSE;
				GUI.hMenu = LoadMenu((HINSTANCE)GetWindowLong(hWnd, GWL_HINSTANCE), MAKEINTRESOURCE( Languages[ GUI.Language].idMenu));
				InsertMenu(GetSubMenu(GUI.hMenu, 1),
						   6,
						   MF_BYPOSITION,
						   ID_OPTION_JP,
						   GUI.Language ? "{ UI(&U)\tCtrl+U" : "English &UI\tCtrl+U");
			}
			//add volume menu
			DeleteMenu(GUI.hSysMenu, 0, MF_BYPOSITION);
			DeleteMenu(GUI.hSysMenu, 0, MF_BYPOSITION);
			GUI.hVolMenu = LoadMenu((HINSTANCE)GetWindowLong(hWnd, GWL_HINSTANCE), MAKEINTRESOURCE(IDR_VOLMENU));
			InsertMenu(GUI.hSysMenu,
					   0,
					   MF_BYPOSITION | MF_POPUP,
					   (UINT)GetSubMenu(GUI.hVolMenu, 0),
					   (GUI.Language ? "{[x(&V)" : "&Volume Level"));
			InsertMenu(GUI.hSysMenu, 1, MF_BYPOSITION | MFT_SEPARATOR, 0, 0);
			PauseExecution(false, false, false);
			break;

		case ID_OPTION_MUTE:
			Settings.Mute = !Settings.Mute;
			if(Settings.Mute)
				S9xMessage2 (GUI.Language ? "TEhobt@vC It" : "Mute Sound", 2000);
			else
				S9xMessage2 (GUI.Language ? "TEhobt@vC I" : "Dis Mute Sound", 2000);
			break;
		//
		//Snes9x ݒύXL[
		//
		case ID_OPTION_SETTINGS_KEY_0:
			Settings.DisableHDMA = !Settings.DisableHDMA;
			if(Settings.DisableHDMA)
				S9xMessage2 (GUI.Language ? "HDMA G~[V It" : "HDMA emulation off", 2000);
			else
				S9xMessage2 (GUI.Language ? "HDMA G~[V I" : "HDMA emulation on", 2000);
			break;

		case ID_OPTION_SETTINGS_KEY_1:
			if(GUI.StopEmulation || Settings.SPCPlaying || GUI.PauseEmulation)
				break;
			PPU.BG_Forced ^= 1;
			if(PPU.BG_Forced & 1)
				S9xMessage2 (GUI.Language ? "BG#0 It" : "BG#0 off", 2000);
			else
				S9xMessage2 (GUI.Language ? "BG#0 I" : "BG#0 on", 2000);
			break;

		case ID_OPTION_SETTINGS_KEY_2:
			if(GUI.StopEmulation || Settings.SPCPlaying || GUI.PauseEmulation)
				break;
			PPU.BG_Forced ^= 2;
			if(PPU.BG_Forced & 2)
				S9xMessage2 (GUI.Language ? "BG#1 It" : "BG#1 off", 2000);
			else
				S9xMessage2 (GUI.Language ? "BG#1 I" : "BG#1 on", 2000);
			break;

		case ID_OPTION_SETTINGS_KEY_3:
			if(GUI.StopEmulation || Settings.SPCPlaying || GUI.PauseEmulation)
				break;
			PPU.BG_Forced ^= 4;
			if(PPU.BG_Forced & 4)
				S9xMessage2 (GUI.Language ? "BG#2 It" : "BG#2 off", 2000);
			else
				S9xMessage2 (GUI.Language ? "BG#2 I" : "BG#2 on", 2000);
			break;

		case ID_OPTION_SETTINGS_KEY_4:
			if(GUI.StopEmulation || Settings.SPCPlaying || GUI.PauseEmulation)
				break;
			PPU.BG_Forced ^= 8;
			if(PPU.BG_Forced & 8)
				S9xMessage2 (GUI.Language ? "BG#3 It" : "BG#3 off", 2000);
			else
				S9xMessage2 (GUI.Language ? "BG#3 I" : "BG#3 on", 2000);
			break;

		case ID_OPTION_SETTINGS_KEY_5:
			if(GUI.StopEmulation || Settings.SPCPlaying || GUI.PauseEmulation)
				break;
			PPU.BG_Forced ^= 16;
			if(PPU.BG_Forced & 16)
				S9xMessage2 (GUI.Language ? "XvCg It" : "Sprites off", 2000);
			else
				S9xMessage2 (GUI.Language ? "XvCg I" : "Sprites on", 2000);
			break;

		case ID_OPTION_SETTINGS_KEY_6:
			Settings.SwapJoypads = !Settings.SwapJoypads;
			if(Settings.SwapJoypads)
				S9xMessage2 (GUI.Language ? "Joypad swapping I" : "Joypad swapping on", 2000);
			else
				S9xMessage2 (GUI.Language ? "Joypad swapping It" : "Joypad swapping off", 2000);
			break;

		case ID_OPTION_SETTINGS_KEY_7:
			if(GUI.StopEmulation || Settings.SPCPlaying || GUI.PauseEmulation)
				break;
			S9xNextController ();
			if(IPPU.Controller == SNES_MULTIPLAYER5) {
				S9xMessage2 (GUI.Language ? "Multiplayer 5 I #0" : "Multiplayer 5 on #0", 2000);
				if(!GUI.ForcedPauseEmulation)
					EraseMouseCursor();
			}
			else if(IPPU.Controller == SNES_JOYPAD) {
				S9xMessage2 (GUI.Language ? "Joypad I #0" : "Joypad on #0", 2000);
				if(!GUI.ForcedPauseEmulation)
					EraseMouseCursor();
			}
			else if(IPPU.Controller == SNES_MOUSE_SWAPPED) {
				S9xMessage2 (GUI.Language ? "Mouse I #1" : "Mouse on #1", 2000);
				if(!GUI.ForcedPauseEmulation)
					EraseMouseCursor();
			}
			else if(IPPU.Controller == SNES_MOUSE) {
				S9xMessage2 (GUI.Language ? "Mouse I #0" : "Mouse on #0", 2000);
				if(!GUI.ForcedPauseEmulation)
					EraseMouseCursor();
			}
			else if(IPPU.Controller == SNES_SUPERSCOPE) {
				S9xMessage2 (GUI.Language ? "Superscope I #1" : "Superscope on #1", 2000);
				if(!GUI.ForcedPauseEmulation && !GUI.StopEmulation && !Settings.SPCPlaying && !GUI.PauseEmulation)
					SetCursor(GUI.GunSight);
			}
			else if(IPPU.Controller == SNES_JUSTIFIER) {
				S9xMessage2 (GUI.Language ? "Justifier I #0" : "Justifier on #0", 2000);
				if(!GUI.ForcedPauseEmulation && !GUI.StopEmulation && !Settings.SPCPlaying && !GUI.PauseEmulation)
					SetCursor(GUI.GunSight);
			}
			else if(IPPU.Controller == SNES_JUSTIFIER_2) {
				S9xMessage2 (GUI.Language ? "Justifier I #1" : "Justifier on #1", 2000);
				if(!GUI.ForcedPauseEmulation && !GUI.StopEmulation && !Settings.SPCPlaying && !GUI.PauseEmulation)
					SetCursor(GUI.GunSight);
			}
			break;

		case ID_OPTION_SETTINGS_KEY_8:
			Settings.BGLayering = !Settings.BGLayering;
			if(Settings.BGLayering)
				S9xMessage2 (GUI.Language ? "Backgroung layering hack I" : "Backgroung layering hack on", 2000);
			else
				S9xMessage2 (GUI.Language ? "Backgroung layering hack It" : "Backgroung layering hack off", 2000);
			break;

		case ID_OPTION_SETTINGS_KEY_9:
			if( Settings.SixteenBit)
			{
				Settings.Transparency = !Settings.Transparency;
				if(Settings.Transparency)
					S9xMessage2 (GUI.Language ? " I" : "Transparency effects on", 2000);
				else
					S9xMessage2 (GUI.Language ? " It" : "Transparency effects off", 2000);
			}
			break;

		case ID_OPTION_SETTINGS_KEY_BACK:
			Settings.DisableGraphicWindows = !Settings.DisableGraphicWindows;
			if(Settings.DisableGraphicWindows)
				S9xMessage2 (GUI.Language ? "Graphic clip windows It" : "Graphic clip windows off", 2000);
			else
				S9xMessage2 (GUI.Language ? "Graphic clip windows I" : "Graphic clip windows on", 2000);
			break;

		case ID_OPTION_SETTINGS_KEY_TURBO:
			//^[{[h
			Settings.TurboMode = !Settings.TurboMode;
			if(Settings.TurboMode) {
				lstrcpy(WindowTitleTextNormal, WindowTitleTextTurbo);
				if(!GUI.PauseEmulation)
					lstrcpy(WindowTitleText, WindowTitleTextTurbo);
				lstrcpy(OnScreenMessageStr, GUI.Language ? "^[{[h I (XLbv " : "Turbo Mode on (Skip ");
				wsprintf(&OnScreenMessageStr[lstrlen(OnScreenMessageStr)], "%d)", Settings.TurboSkipFrames);
				S9xMessage2 (OnScreenMessageStr, 2000);
			}
			else {
				lstrcpy(WindowTitleTextNormal, WindowTitleTextNormal_bak);
				if(!GUI.PauseEmulation)
					lstrcpy(WindowTitleText, WindowTitleTextNormal_bak);
				S9xMessage2 (GUI.Language ? "^[{[h It" : "Turbo Mode off", 2000);
			}
			break;

		case ID_OPTION_SETTINGS_KEY_TURBOFRAMESKIPINC:
			if(Settings.TurboSkipFrames < 15)
				Settings.TurboSkipFrames++;
			else
				Settings.TurboSkipFrames = 15;
			lstrcpy(OnScreenMessageStr, GUI.Language ? "^[{XLbvt[ " : "TurboSkipFrames ");
			wsprintf(&OnScreenMessageStr[lstrlen(OnScreenMessageStr)], "%d", Settings.TurboSkipFrames);
			S9xMessage2 (OnScreenMessageStr, 2000);
			break;

		case ID_OPTION_SETTINGS_KEY_TURBOFRAMESKIPDEC:
			if(Settings.TurboSkipFrames > 0)
				Settings.TurboSkipFrames--;
			else
				Settings.TurboSkipFrames = 0;
			lstrcpy(OnScreenMessageStr, GUI.Language ? "^[{XLbvt[ " : "TurboSkipFrames ");
			wsprintf(&OnScreenMessageStr[lstrlen(OnScreenMessageStr)], "%d", Settings.TurboSkipFrames);
			S9xMessage2 (OnScreenMessageStr, 2000);
			break;

		case ID_OPTION_SETTINGS_KEY_PAUSE:
			if(!GUI.PauseEmulation) {
				PauseExecution(true, false, false);
				GUI.PauseEmulation = TRUE;
				lstrcpy(WindowTitleText, WindowTitleTextPaused);
				SetMenuStatus(GUI.hMenu, GUI.hSysMenu);
				HMENU hMenu = GetMenu(hWnd);
				S9xMessage2 (GUI.Language ? "Pause I" : "Pause on", 2000);
				SetCursor(GUI.Arrow);
			}
			else {
				GUI.PauseEmulation = FALSE;
				PauseExecution(false, true, false);
				lstrcpy(WindowTitleText, WindowTitleTextNormal);
				SetMenuStatus(GUI.hMenu, GUI.hSysMenu);
				S9xMessage2 (GUI.Language ? "Pause It" : "Pause off", 2000);
				if(!GUI.ForcedPauseEmulation)
					EraseMouseCursor();
			}
			break;

		case ID_OPTION_SETTINGS_KEY_APPLYCHEATS:
			Settings.ApplyCheats = !Settings.ApplyCheats;
			if(Settings.ApplyCheats)
				S9xMessage2 (GUI.Language ? "`[gR[hL" : "Cheat code on", 2000);
			else
				S9xMessage2 (GUI.Language ? "`[gR[h" : "Cheat code off", 2000);
			break;

		case ID_OPTION_SNESJOYPAD:
			if(GUI.StopEmulation || Settings.SPCPlaying || GUI.PauseEmulation)
				break;
			IPPU.Controller = SNES_JOYPAD;
			S9xMessage2 (GUI.Language ? "Joypad I #0" : "Joypad on #0", 2000);
			if(!GUI.ForcedPauseEmulation)
				EraseMouseCursor();
			break;

		case ID_OPTION_SNESMULTIPLAYER5:
			if(GUI.StopEmulation || Settings.SPCPlaying || GUI.PauseEmulation || !Settings.MultiPlayer5)
				break;
			IPPU.Controller = SNES_MULTIPLAYER5;
			S9xMessage2 (GUI.Language ? "Multiplayer 5 I #0" : "Multiplayer 5 on #0", 2000);
			if(!GUI.ForcedPauseEmulation)
				EraseMouseCursor();
			break;

		case ID_OPTION_SNESMOUSE1:
			if(GUI.StopEmulation || Settings.SPCPlaying || GUI.PauseEmulation || !Settings.Mouse)
				break;
			IPPU.Controller = SNES_MOUSE_SWAPPED;
			S9xMessage2 (GUI.Language ? "Mouse I #1" : "Mouse on #1", 2000);
			if(!GUI.ForcedPauseEmulation)
				EraseMouseCursor();
			break;

		case ID_OPTION_SNESMOUSE0:
			if(GUI.StopEmulation || Settings.SPCPlaying || GUI.PauseEmulation || !Settings.Mouse)
				break;
			IPPU.Controller = SNES_MOUSE;
			S9xMessage2 (GUI.Language ? "Mouse I #0" : "Mouse on #0", 2000);
			if(!GUI.ForcedPauseEmulation)
				EraseMouseCursor();
			break;

		case ID_OPTION_SNESSUPERSCOPE:
			if(GUI.StopEmulation || Settings.SPCPlaying || GUI.PauseEmulation || !Settings.SuperScope)
				break;
			IPPU.Controller = SNES_SUPERSCOPE;
			S9xMessage2 (GUI.Language ? "Superscope I #1" : "Superscope on #1", 2000);
			if(!GUI.ForcedPauseEmulation && !GUI.StopEmulation && !Settings.SPCPlaying && !GUI.PauseEmulation)
				SetCursor(GUI.GunSight);
			break;

		case ID_OPTION_SNESJUSTIFIER:
			if(GUI.StopEmulation || Settings.SPCPlaying || GUI.PauseEmulation || !Settings.Justifier)
				break;
			IPPU.Controller = SNES_JUSTIFIER;
			S9xMessage2 (GUI.Language ? "Justifier I #0" : "Justifier on #0", 2000);
			if(!GUI.ForcedPauseEmulation && !GUI.StopEmulation && !Settings.SPCPlaying && !GUI.PauseEmulation)
				SetCursor(GUI.GunSight);
			break;

		case ID_OPTION_SNESJUSTIFIER_2:
			if(GUI.StopEmulation || Settings.SPCPlaying || GUI.PauseEmulation || !Settings.SecondJustifier)
				break;
			IPPU.Controller = SNES_JUSTIFIER_2;
			S9xMessage2 (GUI.Language ? "Justifier I #1" : "Justifier on #1", 2000);
			if(!GUI.ForcedPauseEmulation && !GUI.StopEmulation && !Settings.SPCPlaying && !GUI.PauseEmulation)
				SetCursor(GUI.GunSight);
			break;

		//ԃZ[u
		case ID_FILE_SAVESLOT_1:
		case ID_FILE_SAVESLOT_2:
		case ID_FILE_SAVESLOT_3:
		case ID_FILE_SAVESLOT_4:
		case ID_FILE_SAVESLOT_5:
		case ID_FILE_SAVESLOT_6:
		case ID_FILE_SAVESLOT_7:
		case ID_FILE_SAVESLOT_8:
		case ID_FILE_SAVESLOT_9:
			S9xwStateSave(LOWORD(wParam) - ID_FILE_SAVESLOT_1 + 1);
			break;

		//ԃ[h
		case ID_FILE_LOADSLOT_1:
		case ID_FILE_LOADSLOT_2:
		case ID_FILE_LOADSLOT_3:
		case ID_FILE_LOADSLOT_4:
		case ID_FILE_LOADSLOT_5:
		case ID_FILE_LOADSLOT_6:
		case ID_FILE_LOADSLOT_7:
		case ID_FILE_LOADSLOT_8:
		case ID_FILE_LOADSLOT_9:
			S9xwStateLoad(LOWORD(wParam) - ID_FILE_LOADSLOT_1 + 1);
			break;

		//Toggle Sound Channel ON OFF
		case ID_OPTION_SETTINGS_KEY_SPCCHANNEL0:
		case ID_OPTION_SETTINGS_KEY_SPCCHANNEL1:
		case ID_OPTION_SETTINGS_KEY_SPCCHANNEL2:
		case ID_OPTION_SETTINGS_KEY_SPCCHANNEL3:
		case ID_OPTION_SETTINGS_KEY_SPCCHANNEL4:
		case ID_OPTION_SETTINGS_KEY_SPCCHANNEL5:
		case ID_OPTION_SETTINGS_KEY_SPCCHANNEL6:
		case ID_OPTION_SETTINGS_KEY_SPCCHANNEL7:
			if(GUI.StopEmulation || GUI.PauseEmulation)
				break;
			
			S9xSetSoundControl (so.sound_switch ^ (int)(1 << (LOWORD(wParam) - ID_OPTION_SETTINGS_KEY_SPCCHANNEL0)));
			lstrcpy(OnScreenMessageStr, GUI.Language ? "TEh`l " : "Sound Channel ");
			wsprintf(OnScreenMessageStr + lstrlen(OnScreenMessageStr),
					 "%d ",
					 (LOWORD(wParam) - ID_OPTION_SETTINGS_KEY_SPCCHANNEL0));
			lstrcat(OnScreenMessageStr,
					(so.sound_switch & (int)(1 << (LOWORD(wParam) - ID_OPTION_SETTINGS_KEY_SPCCHANNEL0))) ? "ON" : "OFF");
			S9xMessage2 (OnScreenMessageStr, 2000);
			break;

		case ID_FUNCTIONCODE:
			switch(LOWORD(lParam)) {

			case MF_SAVE1:
			case MF_SAVE2:
				//Slot 1-2 save
				S9xwStateSave(LOWORD(lParam) - MF_SAVE1 + 1);
				break;

			case MF_LOAD1:
			case MF_LOAD2:
				//Slot 1-2 load
				wsprintf(tmpcharbuf, ".%03d", LOWORD(lParam) - MF_LOAD1);
				if(GetFileAttributes(S9xGetFilename(tmpcharbuf)) != 0xffffffff)
					S9xwStateLoad(LOWORD(lParam) - MF_LOAD1 + 1);
				break;

			case MF_TURBO:
				//Toggle Turbo Mode
				Settings.TurboMode = !Settings.TurboMode;
				if(Settings.TurboMode) {
					lstrcpy(WindowTitleTextNormal, WindowTitleTextTurbo);
					lstrcpy(WindowTitleText, WindowTitleTextTurbo);
					lstrcpy(OnScreenMessageStr, GUI.Language ? "^[{[h I (XLbv " : "Turbo Mode on (Skip ");
					wsprintf(&OnScreenMessageStr[lstrlen(OnScreenMessageStr)], "%d)", Settings.TurboSkipFrames);
					S9xMessage2 (OnScreenMessageStr, 2000);
				}
				else {
					lstrcpy(WindowTitleTextNormal, WindowTitleTextNormal_bak);
					lstrcpy(WindowTitleText, WindowTitleTextNormal_bak);
					S9xMessage2 (GUI.Language ? "^[{[h It" : "Turbo Mode off", 2000);
				}
				break;

			case MF_TURBOPAUSEFWD:
				//Press Turbo Mode
				Settings.TurboMode = !Settings.TurboMode;
				break;

			case MF_RESET:
				//Reset
				PauseExecution(true, false, false);
				S9xReset(TRUE);
#ifdef UNCO_FULL_TEAM
				BSX_TIMESET (); // Original
#endif
				UosneswScreenInit();
				if(GUI.FullScreen && DirectX.Windowed) {
					if(!SwitchScreenMode(FALSE))
						break;
				}
				else
					UpdateBackBuffer();
				PauseExecution(false, true, false);
				break;

			case MF_SOFTRESET:
				//Soft Reset
				PauseExecution(true, false, false);
				S9xReset(FALSE);
#ifdef UNCO_FULL_TEAM
				BSX_TIMESET (); // Original
#endif
				UosneswScreenInit();
				if(GUI.FullScreen && DirectX.Windowed) {
					if(!SwitchScreenMode(FALSE))
						break;
				}
				else
					UpdateBackBuffer();
				PauseExecution(false, true, false);
				break;

			case MF_SPCDUMP:
				//SPC dump
				spc_is_dumping = 1;
#if 0
				ErrResult = S9xwSPCDump(S9xGetSPCFilename(), FALSE);
				if(ErrResult) {
					lstrcpy(OnScreenMessageStr, S9xwGetSavedSPCNumberAndExtStr());
					lstrcat(OnScreenMessageStr, GUI.Language ? " Z[u" : " saved");
				}
				else
					lstrcpy(OnScreenMessageStr, GUI.Language ? "G[!" : "Error!");
				S9xMessage2 (OnScreenMessageStr, 2000);
#endif
				break;

			case MF_SCREENSHOT:
				//Screenshot
				{
					PauseExecution(true, true, false);

					const char *fext;

					//Select image file format.
					switch (Options.SaveImagefileFormat) {
					case 0:
						fext = ".bmp";
						break;
					
					case 1:
						fext = ".pcx";
						break;
				
					case 2:
						fext = ".gif";
						break;
					
					case 3:
						fext = ".png";
						break;
				
					default:
						fext = ".bmp";
						break;
					}

					bool8 ErrResult = S9xTakeScreenShot(S9xwGetScreenImageFilename((char *)fext),
														Options.ReduceTheColorTo256,
														Options.ReduceTheColorTo256IfWithin,
														Options.ImagefileHiresStretch,
														Options.RLEcompression256bitmap);

					if(ErrResult) {
						lstrcpy(OnScreenMessageStr, S9xwGetSavedScreenImageNumberAndTypeStr());
						lstrcat(OnScreenMessageStr, GUI.Language ? " Z[u" : " saved");
					}
					else
						lstrcpy(OnScreenMessageStr, GUI.Language ? "G[!" : "Error!");

					PauseExecution(false, false, false);
					S9xMessage2 (OnScreenMessageStr, 2000);
				}
				break;

			case MF_XXX01:
#ifdef UNCO_FULL_TEAM
				if(Xxxbsx.BsxRomCheck) BSX_WORK ();
#endif
				XXX_ROMCHEAT_CODE (ROMCHEAT_SELECT);
				break;

			case MF_XXX02:
#ifdef UNCO_FULL_TEAM
				if(Xxxbsx.BsxRomCheck) BSX_TIMESKIP ();
#endif
				XXX_ROMCHEAT_CODE (ROMCHEAT_CODE);
				break;

			case MF_XXX03:
#ifdef UNCO_FULL_TEAM
				if(Xxxbsx.BsxRomCheck) BSX_TIMEBACK ();
#endif
				Xxxcode.CheatNumBackFlag=1;
				XXX_ROMCHEAT_CODE (ROMCHEAT_SELECT);
				Xxxcode.CheatNumBackFlag=0;
				break;

			case MF_XXX04:
#ifdef UNCO_FULL_TEAM
				if(Xxxbsx.BsxRomCheck) BSX_WORKEXTRA ();
#endif
				if(SNESGameFixes.VoicerKun) {
					Xxxcdda.VoicerCDChange = TRUE;
					lstrcpy(OnScreenMessageStr, "Disc Change");
					S9xMessage2 (OnScreenMessageStr, 2000);
				}
				break;

			case MF_XXX05:
			    if(Settings.FrameTimeNTSC == 16 && Settings.FrameTimePAL == 20) {
					Xxxsystem.SpeedEnable ^= 1;

					if(!Xxxsystem.SpeedEnable) {
						if(Settings.PAL)
							Settings.FrameTime = 20;
						else
							Settings.FrameTime = 16;
					}
					else if(Xxxsystem.Speedflag == 0) {
						if(Settings.PAL)
							Settings.FrameTime = 15;
						else
							Settings.FrameTime = 12;
					}
					else if(Xxxsystem.Speedflag == 1) {
						if(Settings.PAL)
							Settings.FrameTime = 12;
						else
							Settings.FrameTime = 10;
					}
					else if(Xxxsystem.Speedflag == 2) {
						if(Settings.PAL)
							Settings.FrameTime = 10;
						else
							Settings.FrameTime = 8;
					}
					else if(Xxxsystem.Speedflag == 3) {
						if(Settings.PAL)
							Settings.FrameTime = 80;
						else
							Settings.FrameTime = 64;
					}
					else if(Xxxsystem.Speedflag == 4) {
						if(Settings.PAL)
							Settings.FrameTime = 40;
						else
							Settings.FrameTime = 32;
					}
					else if(Xxxsystem.Speedflag == 5) {
						if(Settings.PAL)
							Settings.FrameTime = 30;
						else
							Settings.FrameTime = 24;
					}
					
					if(!UosneswSetupFrameTimer((DWORD)Settings.FrameTime)) {
						MessageBox(GUI.hWnd,
								   Languages[GUI.Language].errFrameTimer,
								   "uosnes - Frame Timer",
								   MB_OK | MB_ICONINFORMATION);
					}

					lstrcpy(OnScreenMessageStr, "Change Game Speed ");
					wsprintf(OnScreenMessageStr + lstrlen(OnScreenMessageStr), "%d ", Settings.FrameTime);
					lstrcat(OnScreenMessageStr, GUI.Language ? "ms" : "ms");
					S9xMessage2 (OnScreenMessageStr, 2000);
			    }
				break;

			case MF_XXX06:
			    if(Settings.FrameTimeNTSC == 16 && Settings.FrameTimePAL == 20) {
					if(Xxxsystem.Speedflag < 5) 
						Xxxsystem.Speedflag++;
					else
						Xxxsystem.Speedflag=0;

			        if(Settings.PAL) {
						if(Xxxsystem.Speedflag == 0)
							S9xMessage2 (GUI.Language ?
										 "XXX KEY 5 [Change Game Speed 15 ms]" : "XXX KEY 5 [Change Game Speed 15 ms]", 2000);
						else if(Xxxsystem.Speedflag == 1)
							S9xMessage2 (GUI.Language ?
										 "XXX KEY 5 [Change Game Speed 12 ms]" : "XXX KEY 5 [Change Game Speed 12 ms]", 2000);
						else if(Xxxsystem.Speedflag == 2)
							S9xMessage2 (GUI.Language ?
										 "XXX KEY 5 [Change Game Speed 10 ms]" : "XXX KEY 5 [Change Game Speed 10 ms]", 2000);
						else if(Xxxsystem.Speedflag == 3)
							S9xMessage2 (GUI.Language ?
										 "XXX KEY 5 [Change Game Speed 80 ms]" : "XXX KEY 5 [Change Game Speed 80 ms]", 2000);
						else if(Xxxsystem.Speedflag == 4)
							S9xMessage2 (GUI.Language ?
										 "XXX KEY 5 [Change Game Speed 40 ms]" : "XXX KEY 5 [Change Game Speed 40 ms]", 2000);
						else if(Xxxsystem.Speedflag == 5)
							S9xMessage2 (GUI.Language ?
										 "XXX KEY 5 [Change Game Speed 30 ms]" : "XXX KEY 5 [Change Game Speed 30 ms]", 2000);
			        }
			        else {
						if(Xxxsystem.Speedflag == 0)
							S9xMessage2 (GUI.Language ?
										 "XXX KEY 5 [Change Game Speed 12 ms]" : "XXX KEY 5 [Change Game Speed 12 ms]", 2000);
						else if(Xxxsystem.Speedflag == 1)
							S9xMessage2 (GUI.Language ?
										 "XXX KEY 5 [Change Game Speed 10 ms]" : "XXX KEY 5 [Change Game Speed 10 ms]", 2000);
						else if(Xxxsystem.Speedflag == 2)
							S9xMessage2 (GUI.Language ?
										 "XXX KEY 5 [Change Game Speed 8 ms]" : "XXX KEY 5 [Change Game Speed 8 ms]", 2000);
						else if(Xxxsystem.Speedflag == 3)
							S9xMessage2 (GUI.Language ?
										 "XXX KEY 5 [Change Game Speed 64 ms]" : "XXX KEY 5 [Change Game Speed 64 ms]", 2000);
						else if(Xxxsystem.Speedflag == 4)
							S9xMessage2 (GUI.Language ?
										 "XXX KEY 5 [Change Game Speed 32 ms]" : "XXX KEY 5 [Change Game Speed 32 ms]", 2000);
						else if(Xxxsystem.Speedflag == 5)
							S9xMessage2 (GUI.Language ?
										 "XXX KEY 5 [Change Game Speed 24 ms]" : "XXX KEY 5 [Change Game Speed 24 ms]", 2000);
			        }
			    }
				break;

			case MF_XXX07:
				if(XxxMovie.Replay_play==false && XxxMovie.Replay_rec==false) {
					XxxMovie.Replay_rec = true;
					XxxMovie.Replay_play = false;
					XxxMovie.Replay_count = 0;
					S9xwStateSaveReplay();
					XXX_REPLAY_START();
				}
				else {
					if(XxxMovie.Replay_rec==true)
						S9xMessage2 (GUI.Language ? "Movie Rec Stop" : "Movie Rec Stop", 2000);

					if(XxxMovie.Replay_play==true)
						S9xMessage2 (GUI.Language ? "Movie Play Stop" : "Movie Play Stop", 2000);

					XXX_REPLAY_END ();
				}
				break;

			case MF_XXX08:
				if(XxxMovie.Replay_play==false && XxxMovie.Replay_rec==false) {
					XxxMovie.Replay_play = true;
					XxxMovie.Replay_rec = false;
					XxxMovie.Def_NormalSnap = TRUE;
					S9xwStateLoadReplay();
					if(XxxMovie.Replay_play)
						XXX_REPLAY_LOAD ();
					XXX_REPLAY_START();
				}
				else {
					if(XxxMovie.Replay_rec==true)
						S9xMessage2 (GUI.Language ? "Movie Rec Stop" : "Movie Rec Stop", 2000);

					if(XxxMovie.Replay_play==true)
						S9xMessage2 (GUI.Language ? "Movie Play Stop" : "Movie Play Stop", 2000);

					XXX_REPLAY_END ();
				}
				break;

			case MF_XXX09:
				if(XxxMovie.Replay_play==true || XxxMovie.Replay_rec==true) {
					if(XxxMovie.Replay_rec==true)
						S9xMessage2 (GUI.Language ? "Movie Rec Stop" : "Movie Rec Stop", 2000);

					if(XxxMovie.Replay_play==true)
						S9xMessage2 (GUI.Language ? "Movie Play Stop" : "Movie Play Stop", 2000);

					XXX_REPLAY_END ();
				}
				break;

			case MF_XXX10:
				break;

			case MF_SSTURBO:
				superscope_turbo ^= 1;
				break;

			case MF_SSPAUSE:
				superscope_pause = TRUE;
				break;
			}
			break;
		}
		//WM_COMMAND
		break;

	case WM_ENTERMENULOOP:
		if(!UIEnter())
			break;
		SetMenuStatus(GUI.hMenu, GUI.hSysMenu);
		SwitchToGDI();
		DrawMenuBar(GUI.hWnd);
		break;

	case WM_NCLBUTTONDOWN:
		S9xwKillMessageTimer();
		if(!GUI.FullScreen && DirectX.Windowed && wParam == HTCAPTION)
		{
			ncbuttondown_flag = 1;
			PauseExecution(true, false, false);
		}
		break;

	case WM_PAINT:
		if(NeedJoystickInit) {
			NeedJoystickInit = 0;
			UosneswJoystickInit();
		}
		if(NeedScreenImage && !GUI.Exit) {
			NeedScreenImage = 0;
			S9xDrawScreenData();
			SetClipper(TRUE);
			UosneswScreenRedraw(hWnd);
		}
		if(rom_filename && !GUI.Exit) {
			rom_filename = NULL;
			PauseExecution(true, false, false);
			ROMLoadProc(ROMFileName);
			if(!GUI.StopEmulation)
				SetPriorityClassAndThreadPriority(GUI.PriorityClass, GUI.ThreadPriority);
			else
				SetPriorityClassAndThreadPriority(NORMAL_PRIORITY_CLASS, THREAD_PRIORITY_NORMAL);
			PauseExecution(false, true, false);
			EraseMouseCursor();
		}
		
		if(!DirectX.Windowed)
			break;

		if(ScreenRedraw_OK == FALSE) {
			ScreenRedraw_OK = TRUE;
			break;
		}

		if(GUI.StopEmulation || GUI.PauseEmulation || GUI.ForcedPauseEmulation || Settings.SPCPlaying)
			UosneswScreenRedraw(hWnd);
		break;

	case WM_CAPTURECHANGED:
		if(!GUI.FullScreen && DirectX.Windowed && ncbuttondown_flag)
		{
			ncbuttondown_flag = 0;
			PauseExecution(false, true, false);
		}
		break;

	// user is moving window
	case WM_ENTERSIZEMOVE:
		if(!GUI.FullScreen && DirectX.Windowed)
			PauseExecution(true, false, false);
		break;

	case WM_EXITSIZEMOVE:
		SizingFlag = FALSE;
		if(!GUI.FullScreen && DirectX.Windowed) {
			// save window size
			GetWindowRect(hWnd, &GUI.WindowRectSetting);
			PauseExecution(false, true, false);
		}
		break;

	case WM_SIZE:
		RefreshRectParams();
		if(GUI.hStatusWnd) {
			RECT clrect, strect;
			GetWindowRect(GUI.hStatusWnd, &strect);
			GetClientRect(hWnd, &clrect);
			MoveWindow(GUI.hStatusWnd, clrect.left, clrect.bottom - (strect.bottom - strect.top),
					   LOWORD(lParam), (strect.bottom - strect.top), TRUE);
			GetClientRect(GUI.hStatusWnd, &strect);
			sb_size[2] = strect.right - strect.left;
			SendMessage(GUI.hStatusWnd, SB_SETPARTS, (WPARAM)3, (LPARAM)(LPINT)sb_size);
			InvalidateRgn(GUI.hStatusWnd, NULL, TRUE);
		}
		switch(wParam)
		{
			case SIZE_MINIMIZED:
				MinimizedFlag = 1;
				break;

			case SIZE_RESTORED:
				if(MinimizedFlag == 2 && DirectX.Windowed && !GUI.FullScreen && !GUI.StopEmulation) {
					MinimizedFlag = 0;
					PauseExecution(true, false, false);
					if(!SwitchScreenMode(FALSE))
						break;
					PauseExecution(false, true, false);
				}
				//EChETCYύXɃQ[oȂ悤ɂ
				else if(!SizingFlag && !GUI.FullScreen && DirectX.Windowed && !GUI.StopEmulation)
					PauseExecution(false, true, false);
				if(SizingFlag && DirectX.Windowed) {
					RECT rc = GUI.ClientRect;
					long RedrawDstH = ExtendHeight ? 239 : 224;
					long RedrawDstW = 256;
					if(GUI.Scale > 0)
						RedrawDstH *= 2;
					if(GUI.Scale > 0)
						RedrawDstW *= 2;
					if(GUI.Stretch == 2) {
						if((rc.right - rc.left) >= RedrawDstW &&
							(rc.bottom - rc.top) >= (RedrawDstH * ((rc.right - rc.left) / RedrawDstW))) {
							RedrawDstH = ExtendHeight ? 239 : 224;
							RedrawDstW = 256;
							long scalemulw = ((rc.right - rc.left) / RedrawDstW);
							long scalemulh = ((rc.bottom - rc.top) / RedrawDstH);
							long scalemul = scalemulw < scalemulh ? scalemulw : scalemulh;
							RedrawDstW *= scalemul;
							RedrawDstH *= scalemul;
						}
						else if((rc.bottom - rc.top) >= RedrawDstH &&
							(rc.right - rc.left) >= (RedrawDstW * ((rc.bottom - rc.top) / RedrawDstH))) {
							RedrawDstH = ExtendHeight ? 239 : 224;
							RedrawDstW = 256;
							long scalemulw = ((rc.right - rc.left) / RedrawDstW);
							long scalemulh = ((rc.bottom - rc.top) / RedrawDstH);
							long scalemul = scalemulw < scalemulh ? scalemulw : scalemulh;
							RedrawDstW *= scalemul;
							RedrawDstH *= scalemul;
						}
						else {
							if((rc.right - rc.left) < RedrawDstW) {
								RedrawDstW = rc.right - rc.left;
							}
							if((rc.bottom - rc.top) < RedrawDstH) {
								RedrawDstH = rc.bottom - rc.top;
							}
						}
					}
					if(GUI.Stretch != 1 && (RedrawDstW < (rc.right - rc.left) || RedrawDstH < (rc.bottom - rc.top))) {
						hRgn1 = CreateRectRgn(0, 0, 1, 1);
						hRgn2 = CreateRectRgn(rc.left, rc.top, rc.right, rc.bottom);
						if(RedrawDstW < (rc.right - rc.left)) {
							rc.left = ((rc.right - rc.left) - RedrawDstW) / 2;
							rc.right = rc.left + RedrawDstW;
						}
						if(RedrawDstH < (rc.bottom - rc.top)) {
							rc.top = ((rc.bottom - rc.top) - RedrawDstH) / 2;
							rc.bottom = rc.top + RedrawDstH;
						}
						hRgn3 = CreateRectRgn(rc.left, rc.top, rc.right, rc.bottom);
						CombineRgn(hRgn1, hRgn2, hRgn3, RGN_XOR);
						DeleteObject(hRgn2);
						DeleteObject(hRgn3);
						HDC hdc = GetDC(hWnd);
						SelectClipRgn(hdc, hRgn1);
						rc = GUI.ClientRect;
						FillRect(hdc, &rc, (HBRUSH)GetStockObject(BLACK_BRUSH));
						DeleteObject(hRgn1);
						ReleaseDC(hWnd, hdc);
						UosneswScreenRedraw(hWnd);
					}
					else if((rc.right - rc.left) || (rc.bottom - rc.top))
						UosneswScreenRedraw(hWnd);
				}
				MinimizedFlag = 0;
				break;
			
			default:
				break;
		}
		break;

	case WM_DISPLAYCHANGE:
		break;

	case WM_WINDOWPOSCHANGING:
//		((LPWINDOWPOS)lParam)->hwndInsertAfter = HWND_TOPMOST;
		break;

	case WM_SIZING:
		RefreshRectParams();
		if(!DirectX.Windowed || MinimizedFlag)
			break;
		else if(!SizingFlag)
		{
			PauseExecution(true, false, false);
			SizingFlag = TRUE;
		}
		break;
		
	case WM_CLOSE:
		PauseExecution(true, true, false);
		SetPriorityClassAndThreadPriority(NORMAL_PRIORITY_CLASS, THREAD_PRIORITY_NORMAL);
		DragAcceptFiles(hWnd, FALSE); //hbOhbv
		//save window size
		if(DirectX.Windowed && !MinimizedFlag)
			GetWindowRect(hWnd, &GUI.WindowRectSetting);
		S9xwKillMessageTimer();
		UosneswClose();
		DestroyWindow(hWnd);
		return 0;

	case WM_DESTROY:
		PostQuitMessage(0);
		break;

	case WM_SYSCOMMAND:
		switch( LOWORD(wParam))
		{
		case ID_OPTION_VL1:
			Options.VolumeLevel = 1;
			SetAPUDSPAmp(FIXED_POINT * Options.VolumeLevel);
			return DefWindowProc( hWnd, uMsg, wParam, lParam);

		case ID_OPTION_VL2:
			Options.VolumeLevel = 2;
			SetAPUDSPAmp(FIXED_POINT * Options.VolumeLevel);
			return DefWindowProc( hWnd, uMsg, wParam, lParam);

		case ID_OPTION_VL3:
			Options.VolumeLevel = 3;
			SetAPUDSPAmp(FIXED_POINT * Options.VolumeLevel);
			return DefWindowProc( hWnd, uMsg, wParam, lParam);

		case ID_OPTION_VL4:
			Options.VolumeLevel = 4;
			SetAPUDSPAmp(FIXED_POINT * Options.VolumeLevel);
			return DefWindowProc( hWnd, uMsg, wParam, lParam);

		case ID_OPTION_VL5:
			Options.VolumeLevel = 5;
			SetAPUDSPAmp(FIXED_POINT * Options.VolumeLevel);
			return DefWindowProc( hWnd, uMsg, wParam, lParam);
		}
		switch(wParam & 0xfff0) // & to catch double-click on title bar maximize
		{
			case SC_MINIMIZE:
				if(!GUI.FullScreen && DirectX.Windowed && !Settings.SPCPlaying)
					PauseExecution(true, false, false);
				MinimizedFlag = 1;
				break;

			case SC_MAXIMIZE:
				if(MinimizedFlag) {
					if(!Settings.SPCPlaying)
						MinimizedFlag = 2;
					SendMessage(hWnd, WM_SYSCOMMAND, (WPARAM)SC_RESTORE, 0);
				}
				else if(DirectX.Windowed &&
						!GUI.FullScreen &&
						!GUI.StopEmulation &&
						!GUI.ForcedPauseEmulation &&
						!Settings.SPCPlaying &&
						!(DirectX.Windowed &&
						  DirectX.Depth == 8)) {
					PauseExecution(true, false, false);
					if(!SwitchScreenMode(FALSE))
						break;
					PauseExecution(false, true, false);
				}
				return 0;

			case SC_RESTORE:
				if(MinimizedFlag == 1)
					MinimizedFlag = 0;
				break;
			
			default:
				break;
		}
		break;

	default:
		break;
	}
	return DefWindowProc(hWnd, uMsg, wParam, lParam);
}


void S9xwSPCDumpMessages(bool8 err)
{
	if(err) {
		lstrcpy(OnScreenMessageStr, S9xwGetSavedSPCNumberAndExtStr());
		lstrcat(OnScreenMessageStr, GUI.Language ? " Z[u" : " saved");
	}
	else
		lstrcpy(OnScreenMessageStr, GUI.Language ? "G[!" : "Error!");
	S9xMessage2 (OnScreenMessageStr, 2000);
}

/*****************************************************************************/
/* WinInit                                                                   */
/*****************************************************************************/

#if 1 // G[\
static LPTOP_LEVEL_EXCEPTION_FILTER pass_thru_filter;
static LONG CALLBACK exception_filter(struct _EXCEPTION_POINTERS *info);

static LONG CALLBACK exception_filter(struct _EXCEPTION_POINTERS *info)
{
	// exit
	return 1;
}
#endif

static LPCTSTR uosneswlpszClassName = "uosnesw: WndClass";

BOOL WinInit( HINSTANCE hInstance)
{
	WNDCLASSEX wndclass_main;
	POINT p;

	wndclass_main.cbSize = sizeof(WNDCLASSEX);
	wndclass_main.style = 0;
	wndclass_main.lpfnWndProc = WinProc;
	wndclass_main.cbClsExtra = 0;
	wndclass_main.cbWndExtra = 0;
	wndclass_main.hInstance = hInstance;
	//wndclass_main.hIcon = LoadIcon(hInstance, MAKEINTRESOURCE(OTOKO_ICON));
	wndclass_main.hIcon = LoadIcon(hInstance, MAKEINTRESOURCE(UOSXW_ICON32));
	wndclass_main.hCursor = NULL;
	wndclass_main.hbrBackground = (HBRUSH)GetStockObject(BLACK_BRUSH);
	wndclass_main.lpszMenuName = 0;
	wndclass_main.lpszClassName = uosneswlpszClassName;
	//wndclass_main.hIconSm = NULL;
	wndclass_main.hIconSm = LoadIcon(hInstance, MAKEINTRESOURCE(UOSXW_ICON16));

#if 1 // G[\
	pass_thru_filter = SetUnhandledExceptionFilter(exception_filter);
#endif

	GUI.hInstance = hInstance;

	if(!RegisterClassEx(&wndclass_main))
		return FALSE;
	
	if((GUI.hMenu = LoadMenu(hInstance, MAKEINTRESOURCE(Languages[GUI.Language].idMenu))) == NULL) {
		UnregisterClass(wndclass_main.lpszClassName, hInstance);
		return FALSE;
	}
	if((GUI.hVolMenu = LoadMenu( hInstance, MAKEINTRESOURCE(IDR_VOLMENU))) == NULL) {
		DestroyMenu(GUI.hMenu);
		UnregisterClass(wndclass_main.lpszClassName, hInstance);
		return FALSE;
	}
	if(Options.JPenvFlag)
		InsertMenu(GetSubMenu(GUI.hMenu, 1),
				   6,
				   MF_BYPOSITION,
				   ID_OPTION_JP,
				   GUI.Language ? "{ UI(&U)\tCtrl+U" : "English &UI\tCtrl+U");

	RECT rc;

	if(GUI.WindowTopMost) {
		rc.left = 0;
		rc.top = 0;
		rc.right = GetSystemMetrics(SM_CXSCREEN);
		rc.bottom = GetSystemMetrics(SM_CYSCREEN);
	}
	else {
		SystemParametersInfo(SPI_GETWORKAREA, 0, &rc, 0);
	}

	//If it not set window rect setting or invalid setting
	if((GUI.WindowRectSetting.left == -1 &&
		GUI.WindowRectSetting.right == -1 &&
		GUI.WindowRectSetting.top == -1 &&
		GUI.WindowRectSetting.bottom == -1) ||
	   (GUI.WindowRectSetting.right - GUI.WindowRectSetting.left) < GUI.DefaultWindowSizeW ||
	   (GUI.WindowRectSetting.bottom - GUI.WindowRectSetting.top) < GUI.DefaultWindowSizeH) {

		GUI.WindowSizeW = GUI.DefaultWindowSizeW;
		GUI.WindowSizeH = GUI.DefaultWindowSizeH;
		p = *GetWindowPosCenter(GUI.WindowSizeW, GUI.WindowSizeH, GUI.WindowTopMost);
		GUI.WindowRectSetting.left = p.x;
		GUI.WindowRectSetting.top = p.y;
		GUI.WindowRectSetting.right = (p.x + GUI.WindowSizeW);
		GUI.WindowRectSetting.bottom = (p.y + GUI.WindowSizeH);
		//Xe[^Xo[EChETCYcɐL΂Kv
		GUI.NeedWindowSizeAddition = 1;
	}
	//ǂݍ񂾃EChEʒuݒ肪Ɨ̈̈ʒuTCYƔrĖꍇ
	else if((rc.right - 50) < GUI.WindowRectSetting.left ||
			(rc.bottom - 50) < GUI.WindowRectSetting.top ||
			rc.top > GUI.WindowRectSetting.top || GUI.WindowRectSetting.right < 50) {

		GUI.WindowSizeW = (GUI.WindowRectSetting.right - GUI.WindowRectSetting.left);
		GUI.WindowSizeH = (GUI.WindowRectSetting.bottom - GUI.WindowRectSetting.top);
		p = *GetWindowPosCenter(GUI.WindowSizeW, GUI.WindowSizeH, GUI.WindowTopMost);
		GUI.WindowRectSetting.left = p.x;
		GUI.WindowRectSetting.top = p.y;
		GUI.WindowRectSetting.right = (p.x + GUI.WindowSizeW);
		GUI.WindowRectSetting.bottom = (p.y + GUI.WindowSizeH);
	}
	//ǂݍ񂾃EChETCYʒuݒŃEChE
	else {
		GUI.WindowSizeW = (GUI.WindowRectSetting.right - GUI.WindowRectSetting.left);
		GUI.WindowSizeH = (GUI.WindowRectSetting.bottom - GUI.WindowRectSetting.top);
		p.x = GUI.WindowRectSetting.left;
		p.y = GUI.WindowRectSetting.top;
	}

	if((GUI.hWnd = CreateWindowEx(
		GUI.dwExStyle,
		uosneswlpszClassName,
		WindowTitleText,
		GUI.dwStyleWindowed,
		p.x,
		p.y,
		GUI.WindowSizeW, GUI.WindowSizeH,
		NULL,
		NULL,
		hInstance,
		NULL)) == NULL) {
		UnregisterClass(wndclass_main.lpszClassName, hInstance);
		return FALSE;
	}

	InitCommonControls();

	//j[Zbg
	SetMenu( GUI.hWnd, GUI.hMenu);
	GUI.AppMenuConnect = TRUE;

	GUI.hSysMenu = GetSystemMenu(GUI.hWnd, FALSE);
	/* svȃVXej[폜 */
//	for (int i = 2; i < 3; i++)
//		DeleteMenu(GUI.hSysMenu, i, MF_BYPOSITION);
		InsertMenu(GUI.hSysMenu,
				   0,
				   MF_BYPOSITION | MF_POPUP,
				   (UINT)GetSubMenu(GUI.hVolMenu, 0),
				   (GUI.Language ? "{[x(&V)" : "&Volume Level"));
		InsertMenu(GUI.hSysMenu, 1, MF_BYPOSITION | MFT_SEPARATOR, 0, 0);

	S9xwCreateStatusBar();

	if(GUI.hStatusWnd) {
		RECT strect;
		GetWindowRect(GUI.hStatusWnd, &strect);
		GUI.DefaultWindowSizeH += (strect.bottom - strect.top);
		GUI.DefaultWindowSizeHH += (strect.bottom - strect.top);
	}

	return TRUE;
}

static bool8 S9xwCreateStatusBar()
{
	if(!GUI.hWnd || !GUI.hInstance || GUI.hStatusWnd)
		return FALSE;

	GUI.hStatusWnd = CreateStatusWindow(WS_CHILD | WS_VISIBLE | CCS_BOTTOM | SBARS_SIZEGRIP, // EBhEX^C
										NULL, // Pɕ\镶
										GUI.hWnd, // eEBhEnh
										ID_MAINSTATUSWINDOW // Xe[^Xo[̂hc
										);

	if(GUI.hStatusWnd) {
		RECT strect;
//		HICON hIcon;
		GetClientRect(GUI.hStatusWnd, &strect);
		sb_size[2] = strect.right - strect.left;
		SendMessage(GUI.hStatusWnd, SB_SETPARTS, (WPARAM)3, (LPARAM)(LPINT)sb_size);
//		hIcon = (HICON)LoadImage(GUI.hInstance, MAKEINTRESOURCE(ONPU_ICON), IMAGE_ICON, 16, 16, LR_DEFAULTCOLOR);
		//#define SB_SETICON 1039
//		SendMessage(GUI.hStatusWnd, 1039, (WPARAM)2, (LPARAM)hIcon);
		DisplayStatusInfo();
		//ftHgݒEChETCYɃXe[^Xo[
		if(GUI.NeedWindowSizeAddition == 1) {
			POINT p;
			GUI.NeedWindowSizeAddition = 0;
			GetWindowRect(GUI.hStatusWnd, &strect);
			GUI.WindowSizeH = GUI.WindowSizeH + (strect.bottom - strect.top);
			p = *GetWindowPosCenter(GUI.WindowSizeW, GUI.WindowSizeH, GUI.WindowTopMost);
			GUI.WindowRectSetting.left = p.x;
			GUI.WindowRectSetting.top = p.y;
			GUI.WindowRectSetting.right = (p.x + GUI.WindowSizeW);
			GUI.WindowRectSetting.bottom = (p.y + GUI.WindowSizeH);
			MoveWindow(GUI.hWnd, GUI.WindowRectSetting.left, GUI.WindowRectSetting.top,
						GUI.WindowSizeW, GUI.WindowSizeH, TRUE);
		}
		else if(GUI.NeedWindowSizeAddition == 2) {
			GUI.NeedWindowSizeAddition = 0;
			GetWindowRect(GUI.hStatusWnd, &strect);
			GUI.WindowSizeH = GUI.WindowSizeH + (strect.bottom - strect.top);
			GUI.WindowRectSetting.bottom += (strect.bottom - strect.top);
			MoveWindow(GUI.hWnd, GUI.WindowRectSetting.left, GUI.WindowRectSetting.top,
						GUI.WindowSizeW, GUI.WindowSizeH, TRUE);
		}
		RefreshRectParams();
		UpdateWindow(GUI.hStatusWnd);
		return TRUE;
	}
	else {
		RefreshRectParams();
		return FALSE;
	}
}

void S9xwDestroyStatusBar()
{
	if(!GUI.hStatusWnd)
		return;
	DestroyWindow(GUI.hStatusWnd);
	GUI.hStatusWnd = NULL;
	RefreshRectParams();
	return;
}

/*****************
 default settings
*****************/
BOOL GUI_SoundGlobalFocus_def = TRUE;
unsigned char GUI_ForceWindowedDirectDrawClipper_def = FALSE;
unsigned char GUI_dRendering_def = FALSE;
bool GUI_DoubleBuffered_def = FALSE;
DWORD GUI_PriorityClass_def = NORMAL_PRIORITY_CLASS;
int GUI_ThreadPriority_def = THREAD_PRIORITY_NORMAL;
bool8 GUI_SupportHiRes_def = TRUE;
unsigned char GUI_FileBrowseWindow_def = TRUE;
unsigned char GUI_WindowTopMost_def = TRUE;
unsigned char GUI_DoubleRendering_def = FALSE;
int GUI_DoubleRenderingModes16_def = 2;
int GUI_DoubleRenderingModes8_def = 2;
int GUI_FullscreenDisplayModeIndexNormal16_def = 5;
int GUI_FullscreenDisplayModeIndexDouble16_def = 17;
int GUI_FullscreenDisplayModeIndexNormal8_def = 4;
int GUI_FullscreenDisplayModeIndexDouble8_def = 16;
BOOL GUI_DIuse_def = TRUE;
BOOL GUI_DSuse_def = TRUE;
BOOL GUI_DirectSoundNotify_def = FALSE;

static void WinLoad()
{
    char filename [_MAX_PATH + 1];
    char drive [_MAX_DRIVE + 1];
    char dir [_MAX_DIR + 1];
    char fname [_MAX_FNAME + 1];
    char ext [_MAX_EXT + 1];

	S9xLoadDefaultSettings ();

	//set ROM directry
	if(strlen((const char *)Options.HomeDirectory) < _MAX_PATH - 7)
		strcpy(ROMFileName, (const char *)Options.HomeDirectory);
	else
		strcpy(ROMFileName, "c:\\");
	_splitpath(ROMFileName, drive, dir, fname, ext);
	if(fname[0])
		lstrcat(ROMFileName, "\\a.smc");
	else
		lstrcat(ROMFileName, "a.smc");
	_splitpath(ROMFileName, drive, dir, fname, ext);
	_makepath(InitialROMFileDirectory, drive, dir, NULL, NULL);


	//set snapshot ScreenShot SPC directry
	if(strlen((const char *)Options.HomeDirectory) < _MAX_PATH - 10)
		strcpy(GUI.FreezeFileDir, (const char *)Options.HomeDirectory);
	else
		strcpy(GUI.FreezeFileDir, "c:\\");
	_splitpath(GUI.FreezeFileDir, drive, dir, fname, ext);
	if(fname[0])
		lstrcat(GUI.FreezeFileDir, "\\snesnaps");
	else
		lstrcat(GUI.FreezeFileDir, "snesnaps");
	lstrcpy(Memory.ScreenShotDirectory, GUI.FreezeFileDir);
	lstrcpy(Memory.SPCDumpDirectory, GUI.FreezeFileDir);

	//Satellav.smc
	if(strlen((const char *)Options.HomeDirectory) < _MAX_PATH - 14)
		strcpy(Memory.BSXBIOSROMFileName, (const char *)Options.HomeDirectory);
	else
		strcpy(Memory.BSXBIOSROMFileName, "c:\\");
	_splitpath(Memory.BSXBIOSROMFileName, drive, dir, fname, ext);
	if(fname[0])
		lstrcat(Memory.BSXBIOSROMFileName, "\\Satellav.smc");
	else
		lstrcat(Memory.BSXBIOSROMFileName, "Satellav.smc");

	//SFTbase.smc
	if(strlen((const char *)Options.HomeDirectory) < _MAX_PATH - 13)
		strcpy(Memory.SFTBIOSROMFileName, (const char *)Options.HomeDirectory);
	else
		strcpy(Memory.SFTBIOSROMFileName, "c:\\");
	_splitpath(Memory.SFTBIOSROMFileName, drive, dir, fname, ext);
	if(fname[0])
		lstrcat(Memory.SFTBIOSROMFileName, "\\SFTbase.smc");
	else
		lstrcat(Memory.SFTBIOSROMFileName, "SFTbase.smc");

	GUI.dwStyleWindowed = WS_OVERLAPPED | WS_CAPTION | WS_SYSMENU | WS_MINIMIZEBOX |
		                  WS_MAXIMIZEBOX | WS_VISIBLE | WS_THICKFRAME | WS_CLIPCHILDREN;

	GUI.dwStyleFullScreen = WS_POPUP | WS_VISIBLE;

	GUI.WindowRectSetting.left = -1;
	GUI.WindowRectSetting.right = -1;
	GUI.WindowRectSetting.top = -1;
	GUI.WindowRectSetting.bottom = -1;

	RECT rc;

	//calcurate x1 window size
	SetRect(&rc, 0, 0, 256, 239);
	AdjustWindowRect(&rc, GUI.dwStyleWindowed, TRUE);
	GUI.DefaultWindowSizeW = rc.right - rc.left;
	GUI.DefaultWindowSizeH = rc.bottom - rc.top;

	//calcurate x2 window size
	SetRect(&rc, 0, 0, 512, 478);
	AdjustWindowRect(&rc, GUI.dwStyleWindowed, TRUE);
	GUI.DefaultWindowSizeWW = rc.right - rc.left;
	GUI.DefaultWindowSizeHH = rc.bottom - rc.top;

	//default settings
	GUI.DoubleRendering = GUI_DoubleRendering_def;
	GUI.DoubleRenderingModes16 = GUI_DoubleRenderingModes16_def;
	GUI.DoubleRenderingModes8 = GUI_DoubleRenderingModes8_def;

	GUI.FullscreenDisplayModeIndexNormal16 = GUI_FullscreenDisplayModeIndexNormal16_def;
	GUI.FullscreenDisplayModeIndexDouble16 = GUI_FullscreenDisplayModeIndexDouble16_def;
	GUI.FullscreenDisplayModeIndexNormal8 = GUI_FullscreenDisplayModeIndexNormal8_def;
	GUI.FullscreenDisplayModeIndexDouble8 = GUI_FullscreenDisplayModeIndexDouble8_def;

	GUI.ForceWindowedDirectDrawClipper = GUI_ForceWindowedDirectDrawClipper_def;

	GUI.ScreenDepth = 16;
	GUI.Scale = 0;
	GUI.DoubleBuffered = GUI_DoubleBuffered_def;
	GUI.PauseEmulation = FALSE;
	GUI.ForcedPauseEmulation = FALSE;
	GUI.FullScreen = FALSE;
	GUI.Stretch = 0;
	GUI.SupportHiRes = GUI_SupportHiRes_def;
	GUI.dRendering = GUI_dRendering_def;


	//Sound Settings
	GUI.SoundGlobalFocus = GUI_SoundGlobalFocus_def;

	//LangID 0x0411 Japanese
	Options.JPenvFlag = (GetSystemDefaultLangID() == 0x0411 ? 1 : 0);
	GUI.Language = (GetSystemDefaultLangID() == 0x0411 ? 1 : 0);

    GUI.FlipCounter = 0;
	GUI.PriorityClass = GUI_PriorityClass_def;
	GUI.ThreadPriority = GUI_ThreadPriority_def;

	GUI.FileBrowseWindow = GUI_FileBrowseWindow_def;
	GUI.WindowTopMost = GUI_WindowTopMost_def;

	GUI.DIuse = GUI_DIuse_def;
	GUI.DSuse = GUI_DSuse_def;

	GUI.DirectSoundNotify = GUI_DirectSoundNotify_def;

	DirectX_Initialize0();

	//ݒt@Cǂݍ
	read_config();

	lstrcpy(FileTitle, S9xBasename((const char *)ROMFileName));

	//Command Line
	rom_filename = S9xParseArgs (__argv, __argc);

	//mkdir
	if(access((const char *)GUI.FreezeFileDir, 0))
		mkdir((const char *)GUI.FreezeFileDir);
	if(access((const char *)Memory.ScreenShotDirectory, 0))
		mkdir((const char *)Memory.ScreenShotDirectory);
	if(access((const char *)Memory.SPCDumpDirectory, 0))
		mkdir((const char *)Memory.SPCDumpDirectory);

	S9xSetHCycles (Settings.CyclesPercentage);

	if(Settings.ForceTransparency == 1 && Settings.ForceNoTransparency == 0) {
		Settings.Transparency = TRUE;
	}
	else if(Settings.ForceTransparency == 0 && Settings.ForceNoTransparency == 1) {
		Settings.Transparency = FALSE;
	}
	else {
		if(Settings.ForceTransparency == 1) {
			Settings.ForceNoTransparency = 0;
			Settings.Transparency = TRUE;
		}
		else {
			Settings.ForceNoTransparency = 1;
			Settings.Transparency = FALSE;
		}
	}

	//Sound Settings
	Settings.SoundPlaybackRate = (uint32)SoundRates[Options.SoundRate];
	Settings.SixteenBitSound = Options.SoundBit == 16 ? TRUE : FALSE;
	Settings.Stereo = Options.SoundChn == 2 ? TRUE : FALSE;

	GUI.dwExStyle = GUI.WindowTopMost ? WS_EX_TOPMOST : 0;

	if(GUI.DoubleRendering) {
		GUI.Scale = (Settings.SixteenBit ? GUI.DoubleRenderingModes16 : GUI.DoubleRenderingModes8);
		Settings.SupportHiRes = GUI.SupportHiRes;
	}

	if(!Options.JPenvFlag)
		GUI.Language = 0;

	if(!GUI.dRendering)
		DirectX.ForceWindowedDirectDrawClipper = GUI.ForceWindowedDirectDrawClipper;
	else
		DirectX.ForceWindowedDirectDrawClipper = FALSE;

	//Check MMX CPU
	//cpu_mmx = IsMMXEnabled();
	SelectRenderingCodes();
	MakeTurboStatus();

	//Switch GFXengine
	S9xSwitchGFXengine(Settings.GFXengine2);
}

/* ROMLoadProc */
static bool ROMLoadProc(char *FileName)
{
	char drive [_MAX_DRIVE + 1];
	char dir [_MAX_DIR + 1];
	char fname [_MAX_FNAME + 1];
	char ext [_MAX_EXT + 1];
	char *eext;

	if(Options.AVI_Recording)
		AVI_Record(&Options.AVI_Recording);

	//set filename for GetOpenFileName
	lstrcpy(InitialROMFileDirectory, FileName);
	_splitpath (InitialROMFileDirectory, drive, dir, fname, ext);
	_makepath(InitialROMFileDirectory, drive, dir, NULL, NULL);
	lstrcpy(FileTitle, fname);
	lstrcat(FileTitle, ext);
	if(FileName != ROMFileName)
		lstrcpy(ROMFileName, FileName);

	if(!GUI.StopEmulation && ExecLoop == S9xMainLoop) {
		Memory.SaveSRAM( S9xGetFilename(".srm"));
		S9xSaveCheatFile(S9xGetFilename(".cht"));
		if(Xxxcdda.Enable)
			cdda_exit(); // Original
		XXX_REPLAY_END ();
	}
	eext = GetFilenameExt(FileName);
	if((!strcasecmp(eext, ".spc") || !strcasecmp(eext, ".sp1") ||
		!strcasecmp(eext, ".sp2") || !strcasecmp(eext, ".sp3") ||
		!strcasecmp(eext, ".sp4") || !strcasecmp(eext, ".sp5") ||
		!strcasecmp(eext, ".sp6") || !strcasecmp(eext, ".sp7") ||
		!strcasecmp(eext, ".sp8") || !strcasecmp(eext, ".sp9"))) {

		Memory.ClearForced ();

		GUI.StopEmulation = !LoadSPC(ROMFileName);
		if(!GUI.StopEmulation) {
			ExecLoop = SPCPlayMainLoop;
			SPCLoadedFlag = TRUE;
			GUI.FullScreen = FALSE;
			SetMenuStatus(GUI.hMenu, GUI.hSysMenu);
			DirectX.ForceClipper = TRUE;
			S9xDrawScreenData();
			DisplayStatusInfo();
			UosneswScreenRedraw(GUI.hWnd);
			if(!UosneswSetupFrameTimer((DWORD)Settings.FrameTime)) {
				MessageBox(GUI.hWnd,
						   Languages[GUI.Language].errFrameTimer,
						   "uosnes - Frame Timer",
						   MB_OK | MB_ICONINFORMATION);
			}
			return TRUE;
		}
		else {
			GUI.FullScreen = FALSE;
			SetMenuStatus(GUI.hMenu, GUI.hSysMenu);
			DirectX.ForceClipper = TRUE;
			S9xDrawScreenData();
			DisplayStatusInfo();
			UosneswScreenRedraw(GUI.hWnd);
			return FALSE;
		}
	}

	GUI.StopEmulation = !Memory.LoadROM(FileName);

#if 0
	if(!trace && !(CPU.Flags & TRACE_FLAG)) {
		int logsavednum;
		TracelogFilename = (char *)S9xGetNumFilename(GUI.FreezeFileDir, ".log", &logsavednum);
		
		if(TracelogFilename)
			trace = fopen (TracelogFilename, "wb");
		if(trace)
			CPU.Flags |= TRACE_FLAG;
		if(trace && (CPU.Flags & TRACE_FLAG)) {
			lstrcpy((LPTSTR)OnScreenMessageStr, (LPCTSTR)S9xBasename(TracelogFilename));
			lstrcat(OnScreenMessageStr, " tracing");
			S9xMessage2 (OnScreenMessageStr, 2000);
		}
	}
	else if(trace && (CPU.Flags & TRACE_FLAG)) {
		CPU.Flags ^= TRACE_FLAG;
		fclose(trace);
		trace = NULL;
		if(!trace && !(CPU.Flags & TRACE_FLAG)) {
			lstrcpy((LPTSTR)OnScreenMessageStr, (LPCTSTR)S9xBasename(TracelogFilename));
			lstrcat(OnScreenMessageStr, " tracing off");
			S9xMessage2 (OnScreenMessageStr, 2000);
		}
	}
#endif

	Memory.ClearForced ();

	if(!GUI.StopEmulation) {
		Memory.LoadSRAM(S9xGetFilename(".srm"));

		// Original
		if(Xxxcdda.Enable) {
			cdda_open();
			cdda_stop();
		}

#ifdef UNCO_FULL_TEAM
		if(Xxxbsx.BsxRomCheck) {
			BSX_CLEAR ();
			BSX_SRAMFIRST ();
		}
#endif

		XXX_ROMCHEAT_CODE (ROMCHEAT_CLEAR); // Original
		ExecLoop = S9xMainLoop;
	}
	else {
		SetMenuStatus(GUI.hMenu, GUI.hSysMenu);
		DirectX.ForceClipper = FALSE;
		DisplayStatusInfo();
		return FALSE;
	}
	//force fullscreen if it's in 256 color.
	if(DirectX.Windowed && DirectX.Depth == 8)
		GUI.FullScreen = TRUE;

	UosneswScreenInit();

	//fullscreen mode.
	if(GUI.FullScreen && DirectX.Windowed) {
		if(!SwitchScreenMode(FALSE)) {
			DirectX.ForceClipper = FALSE;
			DisplayStatusInfo();
			return FALSE;
		}
	}

	SetMenuStatus(GUI.hMenu, GUI.hSysMenu);
	DirectX.ForceClipper = FALSE;
	DisplayStatusInfo();
	if(!UosneswSetupFrameTimer((DWORD)Settings.FrameTime)) {
		MessageBox(GUI.hWnd,
				   Languages[GUI.Language].errFrameTimer,
				   "uosnes - Frame Timer",
				   MB_OK | MB_ICONINFORMATION);
	}
	return TRUE;
}

void S9xSetWindowPos()
{
	SetWindowPos(GUI.hWnd,
				 GUI.WindowTopMost ? HWND_TOPMOST : HWND_NOTOPMOST,
				 GUI.WindowRectSetting.left,
				 GUI.WindowRectSetting.top, 
				 GUI.WindowRectSetting.right - GUI.WindowRectSetting.left,
				 GUI.WindowRectSetting.bottom - GUI.WindowRectSetting.top,
				 SWP_DRAWFRAME|SWP_FRAMECHANGED);
	RefreshRectParams();
}

static void Draw1frame()
{
	if(GUI.StopEmulation || Settings.SPCPlaying)
		return;
	UosneswScreenRedraw(GUI.hWnd);
}

static void SetPriorityClassAndThreadPriority(DWORD priocl, int threadprio)
{
	SetPriorityClass(GetCurrentProcess(), priocl);
	SetThreadPriority(GetCurrentThread(), threadprio);
}

/*****************************************************************************/
/* WinMain                                                                   */
/*****************************************************************************/

int WINAPI WinMain(HINSTANCE hInstance,
				   HINSTANCE hPrevInstance,
				   LPSTR lpCmdLine,
				   int nCmdShow)
{
	ExecLoop = NullExecLoop;

    FillMemory((PVOID)&GUI, sizeof(GUI), 0);
    FillMemory((PVOID)&DirectX, sizeof(DirectX), 0);

	//SetThreadPriority(GetCurrentThread(), THREAD_PRIORITY_HIGHEST);

	GUI.StopEmulation = TRUE;

	WinLoad();
	WinInit(hInstance);

	GUI.FrameTimerMeteredSection = CreateMeteredSection(0, 10, "uosnes - FrameTimerMeteredSection");

	if(GUI.FrameTimerMeteredSection == NULL ||
	   !UosneswSetupFrameTimer((DWORD)Settings.FrameTime)) {
		MessageBox(GUI.hWnd,
				   Languages[GUI.Language].errFrameTimer,
				   "uosnes - Frame Timer",
				   MB_OK | MB_ICONINFORMATION);
	}

	//if(GUI.FrameTimerMeteredSection)
	//	GUI.FrameTimerMeteredSection = OpenMeteredSection("uosnes - FrameTimerMeteredSection");

	if(!InitUosnesw())
		GUI.Exit = TRUE;

	GUI.Blank = LoadCursor (hInstance, MAKEINTRESOURCE (IDC_CURSOR_BLANK));
	GUI.GunSight = LoadCursor (hInstance, MAKEINTRESOURCE (IDC_CURSOR_GUNSIGHT));
	GUI.Arrow = LoadCursor (NULL, IDC_ARROW);

	MSG msg;
	HWND hWnd = GUI.hWnd;
	HACCEL Accelerators = LoadAccelerators(hInstance, MAKEINTRESOURCE(AACCEL));

	for(;;) {
		while (GUI.StopEmulation || GUI.PauseEmulation || GUI.ForcedPauseEmulation ||
			   PeekMessage(&msg, NULL, 0, 0, PM_NOREMOVE)) {
			if(!GetMessage(&msg, NULL, 0, 0))
				goto loop_exit;
			if (!TranslateAccelerator(hWnd, Accelerators, &msg)) {
				TranslateMessage(&msg);
				DispatchMessage(&msg);
			}
		}
		if(!GUI.StopEmulation && !GUI.PauseEmulation && !GUI.ForcedPauseEmulation)
			ExecLoop();
	}
loop_exit:
	return msg.wParam;
}

static void UosneswClose()
{
	UosneswSetupFrameTimer(0);

	if(GUI.FrameTimerMeteredSection) {
		CloseMeteredSection(GUI.FrameTimerMeteredSection);
		GUI.FrameTimerMeteredSection = NULL;
	}

	if(!GUI.StopEmulation && ExecLoop == S9xMainLoop) {
		Memory.SaveSRAM(S9xGetFilename(".srm"));
		S9xSaveCheatFile(S9xGetFilename(".cht"));
              if(Xxxcdda.Enable)
				  cdda_exit(); // Original
              XXX_REPLAY_END ();
	}

	/* End */
	DeinitUosnesw();

	// delete menu
	if(!GUI.AppMenuConnect)
		DestroyMenu(GUI.hMenu);
	if(GUI.hRecentGamesMenu)
		DestroyMenu(GUI.hRecentGamesMenu);
	if(GUI.hVolMenu)
		DestroyMenu(GUI.hVolMenu);

	exit_configfile();
}

/*****************************************************************************/

