#include "snes9x.h"
#include "soundux.h"
#include "ppu.h"
#include "apu.h"
#include "snesapu.h"
#include "display.h"
#include "uosnesw.h"
#include "windraw.h"
#include "cfgdlg.h"

static char tmpcharbuf[256];

//proc
static void SNESEmulationDlgCtrlSet(HWND hWnd);
static void SneseDlgSetSubClass(HWND hWnd);
static void SneseDlgReleaseSubClass();

//graphics
bool8 GUI_SupportHiRes_cpy;
bool8 Settings_SixteenBit_cpy;
bool8 Settings_Transparency_cpy;
bool8 Settings_GFXengine2_cpy;
static bool8 Settings_Mode7Interpolate_cpy;
static bool8 Settings_BGLayering_cpy;
static bool8 Settings_DisableGraphicWindows_cpy;
static bool8 Settings_DisableHDMA_cpy;
static bool DirectX_wait_for_vsync_cpy;

//sound
static bool8 Settings_AltSampleDecode_cpy;
static bool8 Settings_FixFrequency_cpy;
static int Settings_InterpolatedSound_cpy;
static bool8 Settings_LowPassFilter_cpy;
static bool8 Settings_DisableSampleCaching_cpy;
static bool8 Settings_NextAPUEnabled_cpy;
static bool8 Settings_DisableSoundEcho_cpy;
static bool8 Settings_ReverseStereo_cpy;
static bool8 Settings_SoundSync_cpy;
static bool8 Settings_DisableMasterVolume_cpy;
static bool8 Settings_SoundEnvelopeHeightReading_cpy;
static uint8 Settings_SoundSkipMethod_cpy;

//CPU
static bool8 Settings_ShutdownMaster_cpy;

//controller
static uint32 Settings_ControllerOption_cpy;
static bool8 Settings_MultiPlayer5_cpy;
static bool8 Settings_Mouse_cpy;
static bool8 Settings_SuperScope_cpy;
static bool8 Settings_Justifier_cpy;
static bool8 Settings_SecondJustifier_cpy;
static u32 Options_JoyReadRateMask_cpy;

//timing
static uint32 Settings_SkipFrames_cpy;
static uint32 Settings_AutoMaxSkipFrames_cpy;
static int Settings_CyclesPercentage_cpy;
static uint32 Settings_FrameTimePAL_cpy;
static uint32 Settings_FrameTimeNTSC_cpy;

//auto save sram
static int32 Settings_AutoSaveDelay_cpy; // Original
static void SetSnesDefaultPlugedInputDeviceCombo(HWND hWnd);
static uint32 GetControllerOptionByComboindex(LRESULT conboindex);

//default settings
extern bool8 GUI_SupportHiRes_def;

void SNESEmulationSettingsLoad()
{
	//graphics
	GUI_SupportHiRes_cpy = GUI.SupportHiRes;
	Settings_Mode7Interpolate_cpy = Settings.Mode7Interpolate;
	Settings_SixteenBit_cpy = Settings.SixteenBit;
	Settings_Transparency_cpy = Settings.Transparency;
	Settings_BGLayering_cpy = Settings.BGLayering;
	Settings_DisableGraphicWindows_cpy = Settings.DisableGraphicWindows;
	Settings_DisableHDMA_cpy = Settings.DisableHDMA;
	Settings_GFXengine2_cpy = Settings.GFXengine2;
	DirectX_wait_for_vsync_cpy = DirectX.wait_for_vsync;

	//sound
	Settings_InterpolatedSound_cpy = Settings.InterpolatedSound;
	Settings_LowPassFilter_cpy = Settings.LowPassFilter;
	Settings_DisableSampleCaching_cpy = Settings.DisableSampleCaching;
	Settings_FixFrequency_cpy = Settings.FixFrequency;
	Settings_AltSampleDecode_cpy = Settings.AltSampleDecode;
	Settings_NextAPUEnabled_cpy = Settings.NextAPUEnabled;
	Settings_DisableSoundEcho_cpy = Settings.DisableSoundEcho;
	Settings_ReverseStereo_cpy = Settings.ReverseStereo;
	Settings_SoundSync_cpy = Settings.SoundSync;
	Settings_DisableMasterVolume_cpy = Settings.DisableMasterVolume;
	Settings_SoundEnvelopeHeightReading_cpy = Settings.SoundEnvelopeHeightReading;
	Settings_SoundSkipMethod_cpy = Settings.SoundSkipMethod;

	//cpu
	Settings_ShutdownMaster_cpy = Settings.ShutdownMaster;

	//controller
	Settings_ControllerOption_cpy = Settings.ControllerOption;
	Settings_MultiPlayer5_cpy = Settings.MultiPlayer5;
	Settings_Mouse_cpy = Settings.Mouse;
	Settings_SuperScope_cpy = Settings.SuperScope;
	Settings_Justifier_cpy = Settings.Justifier;
	Settings_SecondJustifier_cpy = Settings.SecondJustifier;
	Options_JoyReadRateMask_cpy = Options.JoyReadRateMask;

	//timing
	Settings_SkipFrames_cpy = Settings.SkipFrames;
	Settings_AutoMaxSkipFrames_cpy = Settings.AutoMaxSkipFrames;
	Settings_CyclesPercentage_cpy = Settings.CyclesPercentage;
	Settings_FrameTimePAL_cpy = Settings.FrameTimePAL;
	Settings_FrameTimeNTSC_cpy = Settings.FrameTimeNTSC;

	//AutoSave
	Settings_AutoSaveDelay_cpy = Settings.AutoSaveDelay;

}

static HWND hSNESEmulationDlg;

void SNESEmulationDefaultSettingsLoad()
{
	//graphics
	GUI_SupportHiRes_cpy = GUI_SupportHiRes_def;
	Settings_Mode7Interpolate_cpy = DefaultSettings.Mode7Interpolate;
	Settings_SixteenBit_cpy = DefaultSettings.SixteenBit;
	Settings_Transparency_cpy = DefaultSettings.Transparency;
	Settings_BGLayering_cpy = DefaultSettings.BGLayering;
	Settings_DisableGraphicWindows_cpy = DefaultSettings.DisableGraphicWindows;
	Settings_DisableHDMA_cpy = DefaultSettings.DisableHDMA;
	Settings_GFXengine2_cpy = DefaultSettings.GFXengine2;
	DirectX_wait_for_vsync_cpy = DirectX_wait_for_vsync_def;

	//sound
	Settings_InterpolatedSound_cpy = DefaultSettings.InterpolatedSound;
	Settings_LowPassFilter_cpy = DefaultSettings.LowPassFilter;
	Settings_DisableSampleCaching_cpy = DefaultSettings.DisableSampleCaching;
	Settings_FixFrequency_cpy = DefaultSettings.FixFrequency;
	Settings_AltSampleDecode_cpy = DefaultSettings.AltSampleDecode;
	Settings_NextAPUEnabled_cpy = DefaultSettings.NextAPUEnabled;
	Settings_DisableSoundEcho_cpy = DefaultSettings.DisableSoundEcho;
	Settings_ReverseStereo_cpy = DefaultSettings.ReverseStereo;
	Settings_SoundSync_cpy = DefaultSettings.SoundSync;
	Settings_DisableMasterVolume_cpy = DefaultSettings.DisableMasterVolume;
	Settings_SoundEnvelopeHeightReading_cpy = DefaultSettings.SoundEnvelopeHeightReading;
	Settings_SoundSkipMethod_cpy = DefaultSettings.SoundSkipMethod;

	//cpu
	Settings_ShutdownMaster_cpy = DefaultSettings.ShutdownMaster;

	//controller
	Settings_ControllerOption_cpy = DefaultSettings.ControllerOption;
	Settings_MultiPlayer5_cpy = DefaultSettings.MultiPlayer5;
	Settings_Mouse_cpy = DefaultSettings.Mouse;
	Settings_SuperScope_cpy = DefaultSettings.SuperScope;
	Settings_Justifier_cpy = DefaultSettings.Justifier;
	Settings_SecondJustifier_cpy = DefaultSettings.SecondJustifier;
	Options_JoyReadRateMask_cpy = DefaultOptions.JoyReadRateMask;

	//timing
	Settings_SkipFrames_cpy = DefaultSettings.SkipFrames;
	Settings_AutoMaxSkipFrames_cpy = DefaultSettings.AutoMaxSkipFrames;
	Settings_CyclesPercentage_cpy = DefaultSettings.CyclesPercentage;
	Settings_FrameTimePAL_cpy = DefaultSettings.FrameTimePAL;
	Settings_FrameTimeNTSC_cpy = DefaultSettings.FrameTimeNTSC;

	//AutoSave Original
	Settings_AutoSaveDelay_cpy = DefaultSettings.AutoSaveDelay;

	SNESEmulationDlgCtrlSet(hSNESEmulationDlg);
}


static char APUEnabledMessage_US[] = "Sound emulation setting chenged to enabled\nsound will generate after Reset.";
static char APUEnabledMessage_JP[] = "TEhG~[VLɐݒύX܂\nZbgɏԂɔf܂";
static char APUDisabledMessage_US[] = "Sound emulation setting chenged to disabled\nsound will generate after Reset in case the setting will be enabled again, would you continue?";
static char APUDisabledMessage_JP[] = "TEhG~[VɐݒύX܂\n߂ėLɂꍇ̓ZbgɏԂɔfɂȂ܂Aɂ܂H";

void SNESEmulationSettingsSave()
{
	short tmpVolume;
	uint32 tmpnumval;

	Settings.Mode7Interpolate = Settings_Mode7Interpolate_cpy;
	Settings.BGLayering = Settings_BGLayering_cpy;
	Settings.DisableGraphicWindows = Settings_DisableGraphicWindows_cpy;
	Settings.DisableHDMA = Settings_DisableHDMA_cpy;
	DirectX.wait_for_vsync = DirectX_wait_for_vsync_cpy;
	Settings.InterpolatedSound = Settings_InterpolatedSound_cpy;
	Settings.LowPassFilter = Settings_LowPassFilter_cpy;
	Settings.FixFrequency = Settings_FixFrequency_cpy;
	Settings.DisableSampleCaching = Settings_DisableSampleCaching_cpy;
	Settings.AltSampleDecode = Settings_AltSampleDecode_cpy;
	Settings.AutoMaxSkipFrames = Settings_AutoMaxSkipFrames_cpy;

	if(Settings_NextAPUEnabled_cpy != Settings.NextAPUEnabled) {
		if(!GUI.StopEmulation && !Settings.SPCPlaying && Settings_NextAPUEnabled_cpy) {
			MessageBox(hSNESEmulationDlg
					   , GUI.Language ? APUEnabledMessage_JP : APUEnabledMessage_US,
					   "uosnes - Enabled sound emulation", MB_OK | MB_ICONINFORMATION);
			Settings.NextAPUEnabled = TRUE;
		}
		else if(!GUI.StopEmulation && !Settings.SPCPlaying && !Settings_NextAPUEnabled_cpy) {
			if(IDOK == MessageBox(hSNESEmulationDlg,
								  GUI.Language ? APUDisabledMessage_JP : APUDisabledMessage_US,
								  "uosnes - Disabled sound emulation",
								  MB_OKCANCEL | MB_ICONQUESTION)) {
				//kill APU executing
				IAPU.APUExecuting = Settings.APUEnabled = Settings.NextAPUEnabled = FALSE;
				S9xResetAPU ();
			}
			else {
				Settings_NextAPUEnabled_cpy = TRUE;
				SendMessage(GetDlgItem(hSNESEmulationDlg, IDC_CHECK_APUENABLED),
							BM_SETCHECK,
							(WPARAM)(Settings_NextAPUEnabled_cpy ? 1 : 0),
							0);
			}
		}
		else
			Settings.APUEnabled = Settings.NextAPUEnabled = Settings_NextAPUEnabled_cpy;
	}

	// SNESAPU options
	int opts_cpy =
		(Settings_ReverseStereo_cpy ? DSP_REVERSE : 0) |
		(Settings_DisableSoundEcho_cpy ? DSP_NOECHO : 0);

	int opts =
		(Settings.ReverseStereo ? DSP_REVERSE : 0) |
		(Settings.DisableSoundEcho ? DSP_NOECHO : 0);

	if(opts != opts_cpy) {
		Settings.DisableSoundEcho = Settings_DisableSoundEcho_cpy;
		if(Settings_ReverseStereo_cpy != Settings.ReverseStereo) {
			tmpVolume = SoundData.master_volume [0];
			SoundData.master_volume [0] = SoundData.master_volume [1];
			SoundData.master_volume [1] = tmpVolume;
			tmpVolume = SoundData.echo_volume [0];
			SoundData.echo_volume [0] = SoundData.echo_volume [1];
			SoundData.echo_volume [1] = tmpVolume;
			Settings.ReverseStereo = Settings_ReverseStereo_cpy;
		}

		opts = opts_cpy;

		//SNESAPU
		SetAPUDSPOpt(MIX_INT,
					 so.stereo ? 2 : 1,
					 so.sixteen_bit ? 16 : 8,
					 so.playback_rate,
					 Settings.InterpolatedSound,
					 opts);
	}

	Settings.SoundSync = Settings_SoundSync_cpy;
	Settings.DisableMasterVolume = Settings_DisableMasterVolume_cpy;
	Settings.SoundEnvelopeHeightReading = Settings_SoundEnvelopeHeightReading_cpy;
	if(!GUI.StopEmulation && !(!Settings.Shutdown && Settings.ShutdownMaster))
		Settings.Shutdown = Settings.ShutdownMaster = Settings_ShutdownMaster_cpy;
	else
		Settings.ShutdownMaster = Settings_ShutdownMaster_cpy;
	Settings.SoundSkipMethod = Settings_SoundSkipMethod_cpy;
	if(!GUI.StopEmulation && !Settings.SPCPlaying && 
		(Settings.ControllerOption != Settings_ControllerOption_cpy ||
		 Settings.MultiPlayer5 != Settings_MultiPlayer5_cpy ||
		 Settings.Mouse != Settings_Mouse_cpy || 
		 Settings.Justifier != Settings_Justifier_cpy ||
		 Settings.SecondJustifier != Settings_SecondJustifier_cpy ||
		 Settings.SuperScope != Settings_SuperScope_cpy)) {
		if(!(!Settings.MultiPlayer5Master && Settings.MultiPlayer5))
			Settings.MultiPlayer5Master = Settings_MultiPlayer5_cpy;
		if(!(!Settings.MouseMaster && Settings.Mouse))
			Settings.MouseMaster = Settings_Mouse_cpy;
		if(!(!Settings.SuperScopeMaster && Settings.SuperScope))
			Settings.SuperScopeMaster = Settings_SuperScope_cpy;
		if(!(!Settings.JustifierMaster && Settings.Justifier))
			Settings.JustifierMaster = Settings_Justifier_cpy;
		if(!(!Settings.JustifierMaster && Settings.SecondJustifier))
			Settings.JustifierMaster = Settings_SecondJustifier_cpy;
		if (Settings_ControllerOption_cpy == 0)
			IPPU.Controller = SNES_MAX_CONTROLLER_OPTIONS - 1;
		else
			IPPU.Controller = Settings_ControllerOption_cpy - 1;
		S9xNextController ();
	}
	Settings.ControllerOption = Settings_ControllerOption_cpy;
	Settings.MultiPlayer5 = Settings_MultiPlayer5_cpy;
	Settings.Mouse = Settings_Mouse_cpy;
	Settings.SuperScope = Settings_SuperScope_cpy;
	Settings.Justifier = Settings_Justifier_cpy;
	Settings.SecondJustifier = Settings_SecondJustifier_cpy;

	Options.JoyReadRateMask = Options_JoyReadRateMask_cpy;
	Settings.SkipFrames = Settings_SkipFrames_cpy;

	//CyclePercentage
	GetWindowText(GetDlgItem(hSNESEmulationDlg, IDC_EDIT_CYCLEPERCENTAGE), tmpcharbuf, 255);
	tmpnumval = (uint32)atoi(tmpcharbuf);
	if(tmpnumval >= 1 && tmpnumval <= 199) {
		Settings_CyclesPercentage_cpy = (int)tmpnumval;
		if(!GUI.StopEmulation && Settings.H_Max_normal == (long)(SNES_CYCLES_PER_SCANLINE * Settings.CyclesPercentage / 100))
			S9xSetHCycles (Settings_CyclesPercentage_cpy);
		Settings.CyclesPercentage = Settings_CyclesPercentage_cpy;
	}
	else
		Settings_CyclesPercentage_cpy = Settings.CyclesPercentage;
	wsprintf(tmpcharbuf, "%d", Settings_CyclesPercentage_cpy);
	SetWindowText(GetDlgItem(hSNESEmulationDlg, IDC_EDIT_CYCLEPERCENTAGE), tmpcharbuf);

	//PAL timing ms
	GetWindowText(GetDlgItem(hSNESEmulationDlg, IDC_EDIT_PAL), tmpcharbuf, 255);
	tmpnumval = (uint32)atoi(tmpcharbuf);
	if(tmpnumval >= 1 && tmpnumval <= 999) {
		Settings_FrameTimePAL_cpy = tmpnumval;
		if(!GUI.StopEmulation && !Settings.SPCPlaying && Settings.FrameTimePAL == Settings.FrameTime) {
			Settings.FrameTime = Settings_FrameTimePAL_cpy;
			if(!UosneswSetupFrameTimer((DWORD)Settings.FrameTime)) {
				MessageBox(GUI.hWnd,
						   Languages[GUI.Language].errFrameTimer,
						   "uosnes - Frame Timer",
						   MB_OK | MB_ICONINFORMATION);
			}
		}
		Settings.FrameTimePAL = Settings_FrameTimePAL_cpy;
	}
	else {
		Settings_FrameTimePAL_cpy = Settings.FrameTimePAL;
	}
	wsprintf(tmpcharbuf, "%d", Settings_FrameTimePAL_cpy);
	SetWindowText(GetDlgItem(hSNESEmulationDlg, IDC_EDIT_PAL), tmpcharbuf);

	//NTSC timing ms
	GetWindowText(GetDlgItem(hSNESEmulationDlg, IDC_EDIT_NTSC), tmpcharbuf, 255);
	tmpnumval = (uint32)atoi(tmpcharbuf);
	if(tmpnumval >= 1 && tmpnumval <= 999) {
		Settings_FrameTimeNTSC_cpy = tmpnumval;
		if(!GUI.StopEmulation && !Settings.SPCPlaying && Settings.FrameTimeNTSC == Settings.FrameTime) {
			Settings.FrameTime = Settings_FrameTimeNTSC_cpy;
			if(!UosneswSetupFrameTimer((DWORD)Settings.FrameTime)) {
				MessageBox(GUI.hWnd,
						   Languages[GUI.Language].errFrameTimer,
						   "uosnes - Frame Timer",
						   MB_OK | MB_ICONINFORMATION);
			}
		}
		Settings.FrameTimeNTSC = Settings_FrameTimeNTSC_cpy;
	}
	else {
		Settings_FrameTimeNTSC_cpy = Settings.FrameTimeNTSC;
	}
	wsprintf(tmpcharbuf, "%d", Settings_FrameTimeNTSC_cpy);
	SetWindowText(GetDlgItem(hSNESEmulationDlg, IDC_EDIT_NTSC), tmpcharbuf);

	GetWindowText(GetDlgItem(hSNESEmulationDlg, IDC_EDIT_AUTOSAVESRAM), tmpcharbuf, 255);
	tmpnumval = (int32)atoi(tmpcharbuf);
	if(tmpnumval >= 0 && tmpnumval <= 9999999) {
		Settings.AutoSaveDelay = Settings_AutoSaveDelay_cpy = tmpnumval;
	}
	else {
		Settings_AutoSaveDelay_cpy = Settings.AutoSaveDelay;
	}
	wsprintf(tmpcharbuf, "%d", Settings_AutoSaveDelay_cpy);
	SetWindowText(GetDlgItem(hSNESEmulationDlg, IDC_EDIT_AUTOSAVESRAM), tmpcharbuf);
}

static char *InterpolatedSound_US[] = {"None",
									   "Linear",
									   "Cubic",
									   "Gaussian"};

static char *InterpolatedSound_JP[] = {"",
									   "`",
									   "L[rbN",
									   "KEX"};

static char *SoundSkipMethodStr[] = {"Method 0", "Method 1", "Method 2", "Method 3"};
static char *JoyReadRateStr_US[] = {"1 frame", "2 frame", "4 frame", "8 frame"};
static char *JoyReadRateStr_JP[] = {"1 t[", "2 t[", "4 t[", "8 t["};

static char *SkipFramesStr_US[] = {"Auto FrameSkip", "0 FrameSkip",
								   "1 FrameSkip", "2 FrameSkip",
								   "3 FrameSkip", "4 FrameSkip",
								   "5 FrameSkip", "6 FrameSkip",
								   "7 FrameSkip", "8 FrameSkip",
								   "9 FrameSkip"};

static char *SkipFramesStr_JP[] = {"t[XLbv", "0 t[XLbv",
								   "1 t[XLbv", "2 t[XLbv",
								   "3 t[XLbv", "4 t[XLbv",
								   "5 t[XLbv", "6 t[XLbv",
								   "7 t[XLbv", "8 t[XLbv",
								   "9 t[XLbv"};

static char *AutoMaxSkipFramesStr[] = {"Max 0", "Max 1", "Max 2", "Max 3", "Max 4", "Max 5",
									   "Max 6", "Max 7", "Max 8", "Max 9", "Max 10"};

LRESULT CALLBACK SNESEmulationDlgProc(HWND hWnd, UINT uMsg,WPARAM wParam, LPARAM lParam)
{
	switch (uMsg) {
	case WM_INITDIALOG:
		{
			int i;
			hSNESEmulationDlg = hWnd;
			for(i = 0; i < 4; i++)
				SendMessage(GetDlgItem(hWnd, IDC_COMBO_INTERPOLATEDSOUND),
							CB_INSERTSTRING,
							(WPARAM)i,
							(LPARAM)(GUI.Language ? InterpolatedSound_JP[i] : InterpolatedSound_US[i]));
			
			for(i = 0; i < 4; i++)
				SendMessage(GetDlgItem(hWnd, IDC_COMBO_SOUNDSKIPMETHOD),
							CB_INSERTSTRING,
							(WPARAM)i,
							(LPARAM)SoundSkipMethodStr[i]);

			for(i = 0; i < 4; i++)
				SendMessage(GetDlgItem(hWnd, IDC_COMBO_JOYREADRATE),
							CB_INSERTSTRING,
							(WPARAM)i,
							(LPARAM)(GUI.Language ? JoyReadRateStr_JP[i] : JoyReadRateStr_US[i]));

			//timing
			for(i = 0; i < 11; i++)
				SendMessage(GetDlgItem(hWnd, IDC_COMBO_FRAMESKIP),
							CB_INSERTSTRING,
							(WPARAM)i,
							(LPARAM)(GUI.Language ? SkipFramesStr_JP[i] : SkipFramesStr_US[i]));

			for(i = 0; i < 11; i++)
				SendMessage(GetDlgItem(hWnd, IDC_COMBO_AUTOMAXSKIPFRAMES),
							CB_INSERTSTRING,
							(WPARAM)i,
							(LPARAM)(AutoMaxSkipFramesStr[i]));

			SNESEmulationDlgCtrlSet(hWnd);
		}
		break;

	case WM_COMMAND:
		switch (LOWORD(wParam)) {
		case IDC_CHECK_MODE7INTERPOLATE:
		case IDC_CHECK_HIRES:
		case IDC_CHECK_GFX16:
		case IDC_CHECK_TRANSPARENCY:
		case IDC_CHECK_BGLAYERING:
		case IDC_CHECK_GFXW:
		case IDC_CHECK_HDMA:
		case IDC_CHECK_VSYNC:
		case IDC_CHECK_GFXENGINE2:
		case IDC_CHECK_LOWPASSFILTER:

		case IDC_CHECK_FIXFREQUENCY:
		case IDC_CHECK_DISABLESAMPLECACHING:
		case IDC_CHECK_APUENABLED:
		case IDC_CHECK_SOUNDECHO:
		case IDC_CHECK_REVERSESTEREO:
		case IDC_CHECK_SOUNDSYNC:
		case IDC_CHECK_MASTERVOLUME:
		case IDC_CHECK_SOUNDENVELOPEHEIGHTREADING:
				
		case IDC_CHECK_SHUTDOWN:
		case IDC_CHECK_SNESMOUSE:
		case IDC_CHECK_SNESSUPERSCOPE:
		case IDC_CHECK_SNESJUSTIFIER:
		case IDC_CHECK_SNESJUSTIFIER_2:
		case IDC_CHECK_SNESMULTIPLAYER5:
			if(HIWORD(wParam) == BN_CLICKED) {
				bool8 tmpVal = (bool8)(IsDlgButtonChecked(hWnd, (int)LOWORD(wParam)) == BST_CHECKED);
				if(LOWORD(wParam) == IDC_CHECK_MODE7INTERPOLATE)
					Settings_Mode7Interpolate_cpy = tmpVal;
				else if(LOWORD(wParam) == IDC_CHECK_HIRES)
					GUI_SupportHiRes_cpy = tmpVal;
				else if(LOWORD(wParam) == IDC_CHECK_GFX16)
					{
						Settings_SixteenBit_cpy = tmpVal;
						if(Settings_SixteenBit_cpy) {
							EnableWindow(GetDlgItem(hWnd, IDC_CHECK_TRANSPARENCY), TRUE);
						}
						else {
							EnableWindow(GetDlgItem(hWnd, IDC_CHECK_TRANSPARENCY), FALSE);
						}
					}
				else if(LOWORD(wParam) == IDC_CHECK_GFXENGINE2)
					{
						Settings_GFXengine2_cpy = tmpVal;
					}
				else if(LOWORD(wParam) == IDC_CHECK_TRANSPARENCY)
					{
						Settings_Transparency_cpy = tmpVal;
					}
				else if(LOWORD(wParam) == IDC_CHECK_BGLAYERING)
					{
						Settings_BGLayering_cpy = tmpVal;
					}
				else if(LOWORD(wParam) == IDC_CHECK_GFXW)
					{
						Settings_DisableGraphicWindows_cpy = !tmpVal;
					}
				else if(LOWORD(wParam) == IDC_CHECK_HDMA)
					{
						Settings_DisableHDMA_cpy = !tmpVal;
					}
				else if(LOWORD(wParam) == IDC_CHECK_VSYNC)
					{
						DirectX_wait_for_vsync_cpy = (tmpVal ? TRUE : FALSE);
					}
				else if(LOWORD(wParam) == IDC_CHECK_LOWPASSFILTER)
					Settings_LowPassFilter_cpy = tmpVal;
				else if(LOWORD(wParam) == IDC_CHECK_FIXFREQUENCY)
					Settings_FixFrequency_cpy = tmpVal;
				else if(LOWORD(wParam) == IDC_CHECK_DISABLESAMPLECACHING)
					Settings_DisableSampleCaching_cpy = tmpVal;
				else if(LOWORD(wParam) == IDC_CHECK_APUENABLED) {
					Settings_NextAPUEnabled_cpy = tmpVal;
					EnableWindow(GetDlgItem(hWnd, IDC_COMBO_SOUNDSKIPMETHOD), !Settings_NextAPUEnabled_cpy ? TRUE : FALSE);
				}
				else if(LOWORD(wParam) == IDC_CHECK_SOUNDECHO)
					Settings_DisableSoundEcho_cpy = !tmpVal;
				else if(LOWORD(wParam) == IDC_CHECK_REVERSESTEREO)
					Settings_ReverseStereo_cpy = tmpVal;
				else if(LOWORD(wParam) == IDC_CHECK_SOUNDSYNC)
					Settings_SoundSync_cpy = tmpVal;
				else if(LOWORD(wParam) == IDC_CHECK_MASTERVOLUME)
					Settings_DisableMasterVolume_cpy = !tmpVal;
				else if(LOWORD(wParam) == IDC_CHECK_SOUNDENVELOPEHEIGHTREADING)
					Settings_SoundEnvelopeHeightReading_cpy = tmpVal;
				else if(LOWORD(wParam) == IDC_CHECK_SHUTDOWN)
					Settings_ShutdownMaster_cpy = tmpVal;
				else if(LOWORD(wParam) == IDC_CHECK_SNESMOUSE) {
					Settings_Mouse_cpy = tmpVal;
					SetSnesDefaultPlugedInputDeviceCombo(hWnd);
				}
				else if(LOWORD(wParam) == IDC_CHECK_SNESSUPERSCOPE) {
					Settings_SuperScope_cpy = tmpVal;
					SetSnesDefaultPlugedInputDeviceCombo(hWnd);
				}
				else if(LOWORD(wParam) == IDC_CHECK_SNESJUSTIFIER) {
					Settings_Justifier_cpy = tmpVal;
					SetSnesDefaultPlugedInputDeviceCombo(hWnd);
				}
				else if(LOWORD(wParam) == IDC_CHECK_SNESJUSTIFIER_2) {
					Settings_SecondJustifier_cpy = tmpVal;
					SetSnesDefaultPlugedInputDeviceCombo(hWnd);
				}
				else if(LOWORD(wParam) == IDC_CHECK_SNESMULTIPLAYER5) {
					Settings_MultiPlayer5_cpy = tmpVal;
					SetSnesDefaultPlugedInputDeviceCombo(hWnd);
				}
				ConfigDlgSettingsChanged(hWnd);
			}
			break;

		case IDC_COMBO_SOUNDSKIPMETHOD:
		case IDC_COMBO_SNESDEFAULTPLUGEDINPUTDEVICE:
		case IDC_COMBO_JOYREADRATE:
		case IDC_COMBO_FRAMESKIP:
		case IDC_COMBO_AUTOMAXSKIPFRAMES:
		case IDC_COMBO_INTERPOLATEDSOUND:
			if(HIWORD(wParam) == CBN_SELENDOK) {
				int i = (int)SendMessage(GetDlgItem(hWnd, (int)LOWORD(wParam)), CB_GETCURSEL, 0, 0);
				if(LOWORD(wParam) == IDC_COMBO_SOUNDSKIPMETHOD)
					Settings_SoundSkipMethod_cpy = (uint8)i;
				else if(LOWORD(wParam) == IDC_COMBO_SNESDEFAULTPLUGEDINPUTDEVICE)
					Settings_ControllerOption_cpy = (uint32)GetControllerOptionByComboindex((LRESULT)i);
				else if(LOWORD(wParam) == IDC_COMBO_JOYREADRATE) {
					if(i == 0)
						Options_JoyReadRateMask_cpy = 0;
					else if(i == 1)
						Options_JoyReadRateMask_cpy = 1;
					else if(i == 2)
						Options_JoyReadRateMask_cpy = 3;
					else if(i == 3)
						Options_JoyReadRateMask_cpy = 7;
					else
						Options_JoyReadRateMask_cpy = 3;
				}
				else if(LOWORD(wParam) == IDC_COMBO_FRAMESKIP) {
					if(i == 0)
						Settings_SkipFrames_cpy = AUTO_FRAMERATE;
					else if(i >= 1 && i <= 10)
						Settings_SkipFrames_cpy = (uint32)i;
					else
						Settings_SkipFrames_cpy = AUTO_FRAMERATE;
					EnableWindow(GetDlgItem(hWnd, IDC_COMBO_AUTOMAXSKIPFRAMES),
								 (Settings_SkipFrames_cpy == AUTO_FRAMERATE) ? TRUE : FALSE);
				}
				else if(LOWORD(wParam) == IDC_COMBO_AUTOMAXSKIPFRAMES) {
					Settings_AutoMaxSkipFrames_cpy = (uint32)i;
				}
				else if(LOWORD(wParam) == IDC_COMBO_INTERPOLATEDSOUND) {
					Settings_InterpolatedSound_cpy = i;
				}
				if(Settings_SoundSkipMethod_cpy != Settings.SoundSkipMethod ||
				   Settings_ControllerOption_cpy != Settings.ControllerOption ||
				   Options_JoyReadRateMask_cpy != Options.JoyReadRateMask ||
				   Settings_SkipFrames_cpy != Settings.SkipFrames ||
				   Settings_AutoMaxSkipFrames_cpy != Settings.AutoMaxSkipFrames ||
				   Settings_InterpolatedSound_cpy != Settings.InterpolatedSound) {
					ConfigDlgSettingsChanged(hWnd);
				}
			}
			break;

		case IDC_EDIT_CYCLEPERCENTAGE:
		case IDC_EDIT_NTSC:
		case IDC_EDIT_PAL:
		case IDC_EDIT_AUTOSAVESRAM: // Original
			if(HIWORD(wParam) == EN_CHANGE) {
				ConfigDlgSettingsChanged(hWnd);
			}
			break;

		default:
			break;
		}
		break;

	case WM_NOTIFY:
		switch(((NMHDR *)lParam)->code) {
		case PSN_APPLY:
			ConfigDlgSettingsSave();
			break;

		case PSN_HELP:
			ConfigDlgDefaultSettingsLoad(hWnd);
			break;

		case PSN_QUERYCANCEL:
			SneseDlgReleaseSubClass();
			break;

		case PSN_SETACTIVE:
			StartPageIndex = 1;
			SneseDlgSetSubClass(hWnd);
			break;

		case PSN_KILLACTIVE:
			SneseDlgReleaseSubClass();
			break;

		default:
			break;
		}
		break;

	default:
		break;
	}
	return FALSE;
}

static void SNESEmulationDlgCtrlSet(HWND hWnd)
{
	//sound
	SendMessage(GetDlgItem(hWnd, IDC_COMBO_INTERPOLATEDSOUND), CB_SETCURSEL, (WPARAM)Settings_InterpolatedSound_cpy, 0);

	SendMessage(GetDlgItem(hWnd, IDC_CHECK_LOWPASSFILTER), BM_SETCHECK, (WPARAM)(Settings_LowPassFilter_cpy ? 1 : 0), 0);
	EnableWindow(GetDlgItem(hWnd, IDC_CHECK_LOWPASSFILTER), FALSE);

	SendMessage(GetDlgItem(hWnd, IDC_CHECK_FIXFREQUENCY), BM_SETCHECK, (WPARAM)(Settings_FixFrequency_cpy ? 1 : 0), 0);
	SendMessage(GetDlgItem(hWnd, IDC_CHECK_DISABLESAMPLECACHING), BM_SETCHECK, (WPARAM)(Settings_DisableSampleCaching_cpy ? 1 : 0), 0);
	EnableWindow(GetDlgItem(hWnd, IDC_CHECK_DISABLESAMPLECACHING), (!Settings_AltSampleDecode_cpy ? TRUE : FALSE));
	SendMessage(GetDlgItem(hWnd, IDC_CHECK_APUENABLED), BM_SETCHECK, (WPARAM)(Settings_NextAPUEnabled_cpy ? 1 : 0), 0);
	SendMessage(GetDlgItem(hWnd, IDC_CHECK_SOUNDECHO), BM_SETCHECK, (WPARAM)(Settings_DisableSoundEcho_cpy ? 0 : 1), 0);
	SendMessage(GetDlgItem(hWnd, IDC_CHECK_REVERSESTEREO), BM_SETCHECK, (WPARAM)(Settings_ReverseStereo_cpy ? 1 : 0), 0);
	SendMessage(GetDlgItem(hWnd, IDC_CHECK_SOUNDSYNC), BM_SETCHECK, (WPARAM)(Settings_SoundSync_cpy ? 1 : 0), 0);
	SendMessage(GetDlgItem(hWnd, IDC_CHECK_MASTERVOLUME), BM_SETCHECK, (WPARAM)(Settings_DisableMasterVolume_cpy ? 0 : 1), 0);
	SendMessage(GetDlgItem(hWnd, IDC_CHECK_SOUNDENVELOPEHEIGHTREADING),
				BM_SETCHECK,
				(WPARAM)(Settings_SoundEnvelopeHeightReading_cpy ? 1 : 0),
				0);

	SendMessage(GetDlgItem(hWnd, IDC_COMBO_SOUNDSKIPMETHOD), CB_SETCURSEL, (WPARAM)Settings_SoundSkipMethod_cpy, 0);
	EnableWindow(GetDlgItem(hWnd, IDC_COMBO_SOUNDSKIPMETHOD), !Settings_NextAPUEnabled_cpy ? TRUE : FALSE);

	//cpu
	SendMessage(GetDlgItem(hWnd, IDC_CHECK_SHUTDOWN), BM_SETCHECK, (WPARAM)(Settings_ShutdownMaster_cpy ? 1 : 0), 0);

	//graphics
	SendMessage(GetDlgItem(hWnd, IDC_CHECK_MODE7INTERPOLATE), BM_SETCHECK, (WPARAM)(Settings_Mode7Interpolate_cpy ? 1 : 0), 0);
	SendMessage(GetDlgItem(hWnd, IDC_CHECK_HIRES), BM_SETCHECK, (WPARAM)(GUI_SupportHiRes_cpy ? 1 : 0), 0);
	SendMessage(GetDlgItem(hWnd, IDC_CHECK_GFXENGINE2), BM_SETCHECK, (WPARAM)(Settings_GFXengine2_cpy ? 1 : 0), 0);
	SendMessage(GetDlgItem(hWnd, IDC_CHECK_GFX16), BM_SETCHECK, (WPARAM)(Settings_SixteenBit_cpy ? 1 : 0), 0);
	SendMessage(GetDlgItem(hWnd, IDC_CHECK_TRANSPARENCY), BM_SETCHECK, (WPARAM)(Settings_Transparency_cpy ? 1 : 0), 0);
	EnableWindow(GetDlgItem(hWnd, IDC_CHECK_TRANSPARENCY), Settings_SixteenBit_cpy ? TRUE : FALSE);
	SendMessage(GetDlgItem(hWnd, IDC_CHECK_BGLAYERING), BM_SETCHECK, (WPARAM)(Settings_BGLayering_cpy ? 1 : 0), 0);
	SendMessage(GetDlgItem(hWnd, IDC_CHECK_GFXW), BM_SETCHECK, (WPARAM)(Settings_DisableGraphicWindows_cpy ? 0 : 1), 0);
	SendMessage(GetDlgItem(hWnd, IDC_CHECK_HDMA), BM_SETCHECK, (WPARAM)(Settings_DisableHDMA_cpy ? 0 : 1), 0);
	SendMessage(GetDlgItem(hWnd, IDC_CHECK_VSYNC), BM_SETCHECK, (WPARAM)(DirectX_wait_for_vsync_cpy ? 1 : 0), 0);

	//controller
	SetSnesDefaultPlugedInputDeviceCombo(hWnd);
	SendMessage(GetDlgItem(hWnd, IDC_CHECK_SNESMOUSE), BM_SETCHECK, (WPARAM)(Settings_Mouse_cpy ? 1 : 0), 0);
	SendMessage(GetDlgItem(hWnd, IDC_CHECK_SNESSUPERSCOPE), BM_SETCHECK, (WPARAM)(Settings_SuperScope_cpy ? 1 : 0), 0);
	SendMessage(GetDlgItem(hWnd, IDC_CHECK_SNESJUSTIFIER), BM_SETCHECK, (WPARAM)(Settings_Justifier_cpy ? 1 : 0), 0);
	SendMessage(GetDlgItem(hWnd, IDC_CHECK_SNESJUSTIFIER_2), BM_SETCHECK, (WPARAM)(Settings_SecondJustifier_cpy ? 1 : 0), 0);
	SendMessage(GetDlgItem(hWnd, IDC_CHECK_SNESMULTIPLAYER5), BM_SETCHECK, (WPARAM)(Settings_MultiPlayer5_cpy ? 1 : 0), 0);

	if(Options_JoyReadRateMask_cpy == 0)
		SendMessage(GetDlgItem(hWnd, IDC_COMBO_JOYREADRATE), CB_SETCURSEL, 0, 0);
	else if(Options_JoyReadRateMask_cpy == 1)
		SendMessage(GetDlgItem(hWnd, IDC_COMBO_JOYREADRATE), CB_SETCURSEL, 1, 0);
	else if(Options_JoyReadRateMask_cpy == 3)
		SendMessage(GetDlgItem(hWnd, IDC_COMBO_JOYREADRATE), CB_SETCURSEL, 2, 0);
	else if(Options_JoyReadRateMask_cpy == 7)
		SendMessage(GetDlgItem(hWnd, IDC_COMBO_JOYREADRATE), CB_SETCURSEL, 3, 0);
	else
		SendMessage(GetDlgItem(hWnd, IDC_COMBO_JOYREADRATE), CB_SETCURSEL, 2, 0);

	if(Settings_SkipFrames_cpy == AUTO_FRAMERATE)
		SendMessage(GetDlgItem(hWnd, IDC_COMBO_FRAMESKIP), CB_SETCURSEL, 0, 0);
	else if(Settings_SkipFrames_cpy >= 1 && Settings_SkipFrames_cpy <= 10)
		SendMessage(GetDlgItem(hWnd, IDC_COMBO_FRAMESKIP), CB_SETCURSEL, (WPARAM)(Settings_SkipFrames_cpy), 0);
	else {
		SendMessage(GetDlgItem(hWnd, IDC_COMBO_FRAMESKIP), CB_SETCURSEL, 0, 0);
		Settings_SkipFrames_cpy = Settings.SkipFrames = AUTO_FRAMERATE;
	}

	SendMessage(GetDlgItem(hWnd, IDC_COMBO_AUTOMAXSKIPFRAMES), CB_SETCURSEL, (WPARAM)Settings_AutoMaxSkipFrames_cpy, 0);
	EnableWindow(GetDlgItem(hWnd, IDC_COMBO_AUTOMAXSKIPFRAMES), (Settings_SkipFrames_cpy == AUTO_FRAMERATE) ? TRUE : FALSE);

	//CyclesPercentage
	SendMessage(GetDlgItem(hWnd, IDC_EDIT_CYCLEPERCENTAGE), EM_SETLIMITTEXT, 3, 0);
	SendMessage(GetDlgItem(hWnd, IDC_EDIT_PAL), EM_SETLIMITTEXT, 3, 0);
	SendMessage(GetDlgItem(hWnd, IDC_EDIT_NTSC), EM_SETLIMITTEXT, 3, 0);
	if(Settings_CyclesPercentage_cpy >= 1 && Settings_CyclesPercentage_cpy <= 199) {
		wsprintf(tmpcharbuf, "%d", Settings_CyclesPercentage_cpy);
		SetWindowText(GetDlgItem(hWnd, IDC_EDIT_CYCLEPERCENTAGE), tmpcharbuf);
	}
	else {
		Settings_CyclesPercentage_cpy = Settings.CyclesPercentage = 100;
		wsprintf(tmpcharbuf, "%d", Settings_CyclesPercentage_cpy);
		SetWindowText(GetDlgItem(hWnd, IDC_EDIT_CYCLEPERCENTAGE), tmpcharbuf);
	}
	wsprintf(tmpcharbuf, "%d", Settings_FrameTimePAL_cpy);
	SetWindowText(GetDlgItem(hWnd, IDC_EDIT_PAL), tmpcharbuf);
	wsprintf(tmpcharbuf, "%d", Settings_FrameTimeNTSC_cpy);
	SetWindowText(GetDlgItem(hWnd, IDC_EDIT_NTSC), tmpcharbuf);

	// Original
	SendMessage(GetDlgItem(hWnd, IDC_EDIT_AUTOSAVESRAM), EM_SETLIMITTEXT, 6, 0);
	wsprintf(tmpcharbuf, "%d", Settings_AutoSaveDelay_cpy);
	SetWindowText(GetDlgItem(hWnd, IDC_EDIT_AUTOSAVESRAM), tmpcharbuf);


	//not suported yet
	//EnableWindow(GetDlgItem(hWnd, IDC_CHECK_GFXENGINE2), FALSE);
}

static char *SnesDeviceStr_US[] = {"MultiPlayer5",
								   "Joypad",
								   "Mouse #1",
								   "Mouse #0",
								   "Super scope",
								   "Justifier",
								   "Justifier2"};

static char *SnesDeviceStr_JP[] = {"}`vC[5",
								   "WCpbh",
								   "}EX #1",
								   "}EX #0",
								   "X[p[XR[v",
								   "Justifier",
								   "Justifier2"};

static void SetSnesDefaultPlugedInputDeviceCombo(HWND hWnd)
{
	int joycomboi;
	int i3 = 0;
	SendMessage(GetDlgItem(hWnd, IDC_COMBO_SNESDEFAULTPLUGEDINPUTDEVICE), CB_RESETCONTENT, 0, 0);
	//MultiPlayer5
	if(Settings_MultiPlayer5_cpy) {
		SendMessage(GetDlgItem(hWnd, IDC_COMBO_SNESDEFAULTPLUGEDINPUTDEVICE),
					CB_INSERTSTRING,
					(WPARAM)i3,
					(LPARAM)(GUI.Language ? SnesDeviceStr_JP[0] : SnesDeviceStr_US[0]));
		++i3;
	}
	//Joypad
	SendMessage(GetDlgItem(hWnd, IDC_COMBO_SNESDEFAULTPLUGEDINPUTDEVICE),
				CB_INSERTSTRING,
				(WPARAM)i3,
				(LPARAM)(GUI.Language ? SnesDeviceStr_JP[1] : SnesDeviceStr_US[1]));
	++i3;
	if(Settings_Mouse_cpy) {
		//Mouse Swapped
		SendMessage(GetDlgItem(hWnd, IDC_COMBO_SNESDEFAULTPLUGEDINPUTDEVICE),
					CB_INSERTSTRING,
					(WPARAM)i3,
					(LPARAM)(GUI.Language ? SnesDeviceStr_JP[2] : SnesDeviceStr_US[2]));
		++i3;
		//Mouse
		SendMessage(GetDlgItem(hWnd, IDC_COMBO_SNESDEFAULTPLUGEDINPUTDEVICE),
					CB_INSERTSTRING,
					(WPARAM)i3,
					(LPARAM)(GUI.Language ? SnesDeviceStr_JP[3] : SnesDeviceStr_US[3]));
		++i3;
	}
	if(Settings_SuperScope_cpy) {
		//Super scope
		SendMessage(GetDlgItem(hWnd, IDC_COMBO_SNESDEFAULTPLUGEDINPUTDEVICE),
					CB_INSERTSTRING,
					(WPARAM)i3,
					(LPARAM)(GUI.Language ? SnesDeviceStr_JP[4] : SnesDeviceStr_US[4]));
		++i3;
	}
	if(Settings_Justifier_cpy) {
		//Justifier
		SendMessage(GetDlgItem(hWnd, IDC_COMBO_SNESDEFAULTPLUGEDINPUTDEVICE),
					CB_INSERTSTRING,
					(WPARAM)i3,
					(LPARAM)(GUI.Language ? SnesDeviceStr_JP[5] : SnesDeviceStr_US[5]));
		++i3;
	}
	if(Settings_SecondJustifier_cpy) {
		//Justifier2
		SendMessage(GetDlgItem(hWnd, IDC_COMBO_SNESDEFAULTPLUGEDINPUTDEVICE),
					CB_INSERTSTRING,
					(WPARAM)i3,
					(LPARAM)(GUI.Language ? SnesDeviceStr_JP[6] : SnesDeviceStr_US[6]));
	}
	i3 = 0;

	if(Settings_ControllerOption_cpy == SNES_MULTIPLAYER5 && Settings_MultiPlayer5_cpy) {
		SendMessage(GetDlgItem(hWnd, IDC_COMBO_SNESDEFAULTPLUGEDINPUTDEVICE), CB_SETCURSEL, (WPARAM)i3, 0);
		return;
	}
	if(Settings_MultiPlayer5_cpy)
		++i3;
	if(Settings_ControllerOption_cpy == SNES_JOYPAD) {
		SendMessage(GetDlgItem(hWnd, IDC_COMBO_SNESDEFAULTPLUGEDINPUTDEVICE), CB_SETCURSEL, (WPARAM)i3, 0);
		return;
	}
	joycomboi = i3;
	++i3;
	if(Settings_ControllerOption_cpy == SNES_MOUSE_SWAPPED && Settings_Mouse_cpy) {
		SendMessage(GetDlgItem(hWnd, IDC_COMBO_SNESDEFAULTPLUGEDINPUTDEVICE), CB_SETCURSEL, (WPARAM)i3, 0);
		return;
	}
	if(Settings_Mouse_cpy)
		++i3;
	if(Settings_ControllerOption_cpy == SNES_MOUSE && Settings_Mouse_cpy) {
		SendMessage(GetDlgItem(hWnd, IDC_COMBO_SNESDEFAULTPLUGEDINPUTDEVICE), CB_SETCURSEL, (WPARAM)i3, 0);
		return;
	}
	if(Settings_Mouse_cpy)
		++i3;
	if(Settings_ControllerOption_cpy == SNES_SUPERSCOPE && Settings_SuperScope_cpy) {
		SendMessage(GetDlgItem(hWnd, IDC_COMBO_SNESDEFAULTPLUGEDINPUTDEVICE), CB_SETCURSEL, (WPARAM)i3, 0);
		return;
	}
	if(Settings_SuperScope_cpy)
		++i3;
	if(Settings_ControllerOption_cpy == SNES_JUSTIFIER && Settings_Justifier_cpy) {
		SendMessage(GetDlgItem(hWnd, IDC_COMBO_SNESDEFAULTPLUGEDINPUTDEVICE), CB_SETCURSEL, (WPARAM)i3, 0);
		return;
	}
	if(Settings_Justifier_cpy)
		++i3;
	if(Settings_ControllerOption_cpy == SNES_JUSTIFIER_2 && Settings_SecondJustifier_cpy) {
		SendMessage(GetDlgItem(hWnd, IDC_COMBO_SNESDEFAULTPLUGEDINPUTDEVICE), CB_SETCURSEL, (WPARAM)i3, 0);
		return;
	}
	SendMessage(GetDlgItem(hWnd, IDC_COMBO_SNESDEFAULTPLUGEDINPUTDEVICE), CB_SETCURSEL, (WPARAM)joycomboi, 0);
	Settings_ControllerOption_cpy = Settings.ControllerOption = SNES_JOYPAD;
	if(!GUI.StopEmulation && !Settings.SPCPlaying)
		IPPU.Controller = Settings_ControllerOption_cpy;
}

static uint32 GetControllerOptionByComboindex(LRESULT conboindex)
{
	if(Settings_MultiPlayer5_cpy && conboindex == 0)
		return SNES_MULTIPLAYER5;

	if(Settings_MultiPlayer5_cpy && conboindex == 1)
		return SNES_JOYPAD;
	if(!Settings_MultiPlayer5_cpy && conboindex == 0)
		return SNES_JOYPAD;
	
	if(Settings_MultiPlayer5_cpy && Settings_Mouse_cpy && conboindex == 2)
		return SNES_MOUSE_SWAPPED;
	if(!Settings_MultiPlayer5_cpy && Settings_Mouse_cpy && conboindex == 1)
		return SNES_MOUSE_SWAPPED;

	if(Settings_MultiPlayer5_cpy && Settings_Mouse_cpy && conboindex == 3)
		return SNES_MOUSE;
	if(!Settings_MultiPlayer5_cpy && Settings_Mouse_cpy && conboindex == 2)
		return SNES_MOUSE;

	if(Settings_MultiPlayer5_cpy && Settings_Mouse_cpy && Settings_SuperScope_cpy && conboindex == 4)
		return SNES_SUPERSCOPE;
	if(!Settings_MultiPlayer5_cpy && Settings_Mouse_cpy && Settings_SuperScope_cpy && conboindex == 3)
		return SNES_SUPERSCOPE;
	if(Settings_MultiPlayer5_cpy && !Settings_Mouse_cpy && Settings_SuperScope_cpy && conboindex == 2)
		return SNES_SUPERSCOPE;
	if(!Settings_MultiPlayer5_cpy && !Settings_Mouse_cpy && Settings_SuperScope_cpy && conboindex == 1)
		return SNES_SUPERSCOPE;

	if(Settings_MultiPlayer5_cpy && Settings_Mouse_cpy && Settings_SuperScope_cpy && Settings_Justifier_cpy && conboindex == 5)
		return SNES_JUSTIFIER;
	if(!Settings_MultiPlayer5_cpy && Settings_Mouse_cpy && Settings_SuperScope_cpy && Settings_Justifier_cpy && conboindex == 4)
		return SNES_JUSTIFIER;
	if(Settings_MultiPlayer5_cpy && Settings_Mouse_cpy && !Settings_SuperScope_cpy && Settings_Justifier_cpy && conboindex == 4)
		return SNES_JUSTIFIER;
	if(Settings_MultiPlayer5_cpy && !Settings_Mouse_cpy && Settings_SuperScope_cpy && Settings_Justifier_cpy && conboindex == 3)
		return SNES_JUSTIFIER;
	if(!Settings_MultiPlayer5_cpy && Settings_Mouse_cpy && !Settings_SuperScope_cpy && Settings_Justifier_cpy && conboindex == 3)
		return SNES_JUSTIFIER;
	if(!Settings_MultiPlayer5_cpy && !Settings_Mouse_cpy && Settings_SuperScope_cpy && Settings_Justifier_cpy && conboindex == 2)
		return SNES_JUSTIFIER;
	if(Settings_MultiPlayer5_cpy && !Settings_Mouse_cpy && !Settings_SuperScope_cpy && Settings_Justifier_cpy && conboindex == 2)
		return SNES_JUSTIFIER;
	if(!Settings_MultiPlayer5_cpy && !Settings_Mouse_cpy && !Settings_SuperScope_cpy && Settings_Justifier_cpy && conboindex == 1)
		return SNES_JUSTIFIER;


	if(Settings_MultiPlayer5_cpy && Settings_Mouse_cpy &&
	   Settings_SuperScope_cpy && Settings_Justifier_cpy &&
	   Settings_SecondJustifier_cpy &&
	   conboindex == 6)
		return SNES_JUSTIFIER_2;

	if(!Settings_MultiPlayer5_cpy && Settings_Mouse_cpy &&
	   Settings_SuperScope_cpy && Settings_Justifier_cpy &&
	   Settings_SecondJustifier_cpy &&
	   conboindex == 5)
		return SNES_JUSTIFIER_2;

	if(Settings_MultiPlayer5_cpy && Settings_Mouse_cpy &&
	   !Settings_SuperScope_cpy && Settings_Justifier_cpy &&
	   Settings_SecondJustifier_cpy &&
	   conboindex == 5)
		return SNES_JUSTIFIER_2;

	if(Settings_MultiPlayer5_cpy && Settings_Mouse_cpy &&
	   Settings_SuperScope_cpy && !Settings_Justifier_cpy &&
	   Settings_SecondJustifier_cpy &&
	   conboindex == 5)
		return SNES_JUSTIFIER_2;

	if(Settings_MultiPlayer5_cpy && !Settings_Mouse_cpy &&
	   Settings_SuperScope_cpy && Settings_Justifier_cpy &&
	   Settings_SecondJustifier_cpy &&
	   conboindex == 4)
		return SNES_JUSTIFIER_2;

	if(!Settings_MultiPlayer5_cpy && Settings_Mouse_cpy &&
	   !Settings_SuperScope_cpy && Settings_Justifier_cpy &&
	   Settings_SecondJustifier_cpy &&
	   conboindex == 4)
		return SNES_JUSTIFIER_2;

	if(!Settings_MultiPlayer5_cpy && Settings_Mouse_cpy &&
	   Settings_SuperScope_cpy && !Settings_Justifier_cpy &&
	   Settings_SecondJustifier_cpy &&
	   conboindex == 4)
		return SNES_JUSTIFIER_2;

	if(Settings_MultiPlayer5_cpy && Settings_Mouse_cpy &&
	   !Settings_SuperScope_cpy && !Settings_Justifier_cpy &&
	   Settings_SecondJustifier_cpy &&
	   conboindex == 4)
		return SNES_JUSTIFIER_2;

	if(!Settings_MultiPlayer5_cpy && !Settings_Mouse_cpy &&
	   Settings_SuperScope_cpy && Settings_Justifier_cpy &&
	   Settings_SecondJustifier_cpy &&
	   conboindex == 3)
		return SNES_JUSTIFIER_2;

	if(Settings_MultiPlayer5_cpy && !Settings_Mouse_cpy &&
	   !Settings_SuperScope_cpy && Settings_Justifier_cpy &&
	   Settings_SecondJustifier_cpy &&
	   conboindex == 3)
		return SNES_JUSTIFIER_2;

	if(Settings_MultiPlayer5_cpy && !Settings_Mouse_cpy &&
	   Settings_SuperScope_cpy && !Settings_Justifier_cpy &&
	   Settings_SecondJustifier_cpy &&
	   conboindex == 3)
		return SNES_JUSTIFIER_2;

	if(!Settings_MultiPlayer5_cpy && Settings_Mouse_cpy &&
	   !Settings_SuperScope_cpy && !Settings_Justifier_cpy &&
	   Settings_SecondJustifier_cpy &&
	   conboindex == 3)
		return SNES_JUSTIFIER_2;

	if(!Settings_MultiPlayer5_cpy && !Settings_Mouse_cpy &&
	   !Settings_SuperScope_cpy && Settings_Justifier_cpy &&
	   Settings_SecondJustifier_cpy &&
	   conboindex == 2)
		return SNES_JUSTIFIER_2;

	if(!Settings_MultiPlayer5_cpy && !Settings_Mouse_cpy &&
	   Settings_SuperScope_cpy && !Settings_Justifier_cpy &&
	   Settings_SecondJustifier_cpy &&
	   conboindex == 2)
		return SNES_JUSTIFIER_2;

	if(Settings_MultiPlayer5_cpy && !Settings_Mouse_cpy &&
	   !Settings_SuperScope_cpy && !Settings_Justifier_cpy &&
	   Settings_SecondJustifier_cpy &&
	   conboindex == 2)
		return SNES_JUSTIFIER_2;

	if(!Settings_MultiPlayer5_cpy && !Settings_Mouse_cpy &&
	   !Settings_SuperScope_cpy && !Settings_Justifier_cpy &&
	   Settings_SecondJustifier_cpy &&
	   conboindex == 1)
		return SNES_JUSTIFIER_2;

	return SNES_JOYPAD;
}

static WNDPROC Edit_CyclesPercentage;
static WNDPROC Edit_FrameTimePAL;
static WNDPROC Edit_FrameTimeNTSC;
static HWND hEdit_CyclesPercentage;
static HWND hEdit_FrameTimePAL;
static HWND hEdit_FrameTimeNTSC;

// Original
static WNDPROC Edit_AutoSaveDelay;
static HWND hEdit_AutoSaveDelay;


static LRESULT CALLBACK SneseEditSubProc(HWND hWnd, UINT uMsg, WPARAM wParam, LPARAM lParam)
{
	switch (uMsg) {
		case WM_CHAR:
			if((LOWORD(wParam) >= '0' && LOWORD(wParam) <= '9') || LOWORD(wParam) == VK_BACK)
				break;
			return 0;

		default:
			break;

	}
	if(hWnd == hEdit_CyclesPercentage)
		return (CallWindowProc(Edit_CyclesPercentage, hWnd, uMsg, wParam, lParam));
	if(hWnd == hEdit_FrameTimePAL)
		return (CallWindowProc(Edit_FrameTimePAL, hWnd, uMsg, wParam, lParam));
	if(hWnd == hEdit_FrameTimeNTSC)
		return (CallWindowProc(Edit_FrameTimeNTSC, hWnd, uMsg, wParam, lParam));
	// Original
	if(hWnd == hEdit_AutoSaveDelay)
		return (CallWindowProc(Edit_AutoSaveDelay, hWnd, uMsg, wParam, lParam));
	return 0;
}

static void SneseDlgSetSubClass(HWND hWnd)
{
	hEdit_CyclesPercentage = GetDlgItem(hWnd, IDC_EDIT_CYCLEPERCENTAGE);
	hEdit_FrameTimePAL = GetDlgItem(hWnd, IDC_EDIT_PAL);
	hEdit_FrameTimeNTSC = GetDlgItem(hWnd, IDC_EDIT_NTSC);
	Edit_CyclesPercentage = (WNDPROC)GetWindowLong(hEdit_CyclesPercentage, GWL_WNDPROC);
	Edit_FrameTimePAL = (WNDPROC)GetWindowLong(hEdit_FrameTimePAL, GWL_WNDPROC);
	Edit_FrameTimeNTSC = (WNDPROC)GetWindowLong(hEdit_FrameTimeNTSC, GWL_WNDPROC);
	SetWindowLong(hEdit_CyclesPercentage, GWL_WNDPROC, (LONG)SneseEditSubProc);
	SetWindowLong(hEdit_FrameTimePAL, GWL_WNDPROC, (LONG)SneseEditSubProc);
	SetWindowLong(hEdit_FrameTimeNTSC, GWL_WNDPROC, (LONG)SneseEditSubProc);

	// Original
	hEdit_AutoSaveDelay = GetDlgItem(hWnd, IDC_EDIT_AUTOSAVESRAM);
	Edit_AutoSaveDelay = (WNDPROC)GetWindowLong(hEdit_AutoSaveDelay, GWL_WNDPROC);
	SetWindowLong(hEdit_AutoSaveDelay, GWL_WNDPROC, (LONG)SneseEditSubProc);
}

static void SneseDlgReleaseSubClass()
{
	SetWindowLong(hEdit_CyclesPercentage, GWL_WNDPROC, (LONG)Edit_CyclesPercentage);
	SetWindowLong(hEdit_FrameTimePAL, GWL_WNDPROC, (LONG)Edit_FrameTimePAL);
	SetWindowLong(hEdit_FrameTimeNTSC, GWL_WNDPROC, (LONG)Edit_FrameTimeNTSC);
	SetWindowLong(hEdit_AutoSaveDelay, GWL_WNDPROC, (LONG)Edit_AutoSaveDelay); // Original
}

