#include "snes9x.h"
#include "gfx.h"
#include "uosnesw.h"
#include "windraw.h"
#include "render.h"
#include "commutil.h"
#include "cfgdlg.h"
#include "uowsound.h"

static char tmpcharbuf[256];

//proc
static void SettingsDlgCtrlSet();
static void Scale2X16RadioCtrlSet(HWND hWnd);
static void Scale2X8RadioCtrlSet(HWND hWnd);
static void SettingsDlgSetSubClass(HWND hWnd);
static void SettingsDlgReleaseSubClass();

//sound settings
static int Options_SoundRate_cpy;
static int Options_SoundBit_cpy;
static int Options_SoundChn_cpy;
static int Settings_SoundBufferSize_cpy;
static int Settings_SoundMixInterval_cpy;
static BOOL GUI_DSuse_cpy;
static BOOL GUI_DirectSoundNotify_cpy;
static BOOL GUI_SoundGlobalFocus_cpy;

//Display settings
static int GUI_DoubleRenderingModes16_cpy;
static int GUI_DoubleRenderingModes8_cpy;
static unsigned char GUI_ForceWindowedDirectDrawClipper_cpy;
static unsigned char GUI_dRendering_cpy;
static unsigned char DirectX_DisableHardwareScale_cpy;
static bool GUI_DoubleBuffered_cpy;
static bool DirectX_OffScreenVRAM_cpy;
static bool DirectX_BackBufferVRAM_cpy;

//Thread
static DWORD GUI_PriorityClass_cpy;
static int GUI_ThreadPriority_cpy;

//Window
static unsigned char GUI_WindowTopMost_cpy;

//Valuable extern
extern bool8 GUI_SupportHiRes_cpy;
extern bool8 Settings_SixteenBit_cpy;
extern bool8 Settings_GFXengine2_cpy;

extern unsigned char errConfigSwitch;
extern bool8 Settings_Transparency_cpy;

//proc extern
extern void S9xDrawScreenImage();

/*****************
 default settings
*****************/
extern int GUI_DoubleRenderingModes16_def;
extern int GUI_DoubleRenderingModes8_def;
extern unsigned char GUI_ForceWindowedDirectDrawClipper_def;
extern unsigned char GUI_dRendering_def;
extern bool GUI_DoubleBuffered_def;
extern DWORD GUI_PriorityClass_def;
extern int GUI_ThreadPriority_def;
extern unsigned char GUI_WindowTopMost_def;
extern BOOL GUI_DSuse_def;
extern BOOL GUI_DirectSoundNotify_def;
static BOOL GUI_SoundGlobalFocus_def;

void S9xwSettingsLoad()
{
	//sound settings
	Options_SoundRate_cpy = Options.SoundRate;
	Options_SoundBit_cpy = Options.SoundBit;
	Options_SoundChn_cpy = Options.SoundChn;
	GUI_SoundGlobalFocus_cpy = GUI.SoundGlobalFocus;
	Settings_SoundBufferSize_cpy = Settings.SoundBufferSize;
	Settings_SoundMixInterval_cpy = Settings.SoundMixInterval;

	//Display settings
	GUI_DoubleRenderingModes16_cpy = GUI.DoubleRenderingModes16;
	GUI_DoubleRenderingModes8_cpy = GUI.DoubleRenderingModes8;
	GUI_ForceWindowedDirectDrawClipper_cpy = GUI.ForceWindowedDirectDrawClipper;
	GUI_dRendering_cpy = GUI.dRendering;
	DirectX_DisableHardwareScale_cpy = DirectX.DisableHardwareScale;
	GUI_DoubleBuffered_cpy = GUI.DoubleBuffered;
	DirectX_OffScreenVRAM_cpy = DirectX.OffScreenVRAM;
	DirectX_BackBufferVRAM_cpy = DirectX.BackBufferVRAM;

	//Thread
	GUI_PriorityClass_cpy = GUI.PriorityClass;
	GUI_ThreadPriority_cpy = GUI.ThreadPriority;

	//Stream API
	GUI_DSuse_cpy = GUI.DSuse;
	GUI_DirectSoundNotify_cpy = GUI.DirectSoundNotify;

	//Window
	GUI_WindowTopMost_cpy = GUI.WindowTopMost;
}

static HWND hSettingsDlg;

void S9xwDefaultSettingsLoad()
{
	//sound settings
	Options_SoundRate_cpy = DefaultOptions.SoundRate;
	Options_SoundBit_cpy = DefaultOptions.SoundBit;
	Options_SoundChn_cpy = DefaultOptions.SoundChn;
	GUI_SoundGlobalFocus_cpy = GUI_SoundGlobalFocus_def;
	Settings_SoundBufferSize_cpy = DefaultSettings.SoundBufferSize;
	Settings_SoundMixInterval_cpy = DefaultSettings.SoundMixInterval;

	//Display settings
	GUI_DoubleRenderingModes16_cpy = GUI_DoubleRenderingModes16_def;
	GUI_DoubleRenderingModes8_cpy = GUI_DoubleRenderingModes8_def;
	GUI_ForceWindowedDirectDrawClipper_cpy = GUI_ForceWindowedDirectDrawClipper_def;
	GUI_dRendering_cpy = GUI_dRendering_def;
	DirectX_DisableHardwareScale_cpy = DirectX_DisableHardwareScale_def;
	GUI_DoubleBuffered_cpy = GUI_DoubleBuffered_def;
	DirectX_OffScreenVRAM_cpy = DirectX_OffScreenVRAM_def;
	DirectX_BackBufferVRAM_cpy = DirectX_BackBufferVRAM_def;

	//Stream API
	GUI_DSuse_cpy = GUI_DSuse_def;
	GUI_DirectSoundNotify_cpy = GUI_DirectSoundNotify_def;

	//Thread
	GUI_PriorityClass_cpy = GUI_PriorityClass_def;
	GUI_ThreadPriority_cpy = GUI_ThreadPriority_def;

	//Window
	GUI_WindowTopMost_cpy = GUI_WindowTopMost_def;

	SettingsDlgCtrlSet();
}

void S9xwSettingsSave()
{
	int tmpnumval;

	SelectRenderingCodes();
	GUI.ForceWindowedDirectDrawClipper = GUI_ForceWindowedDirectDrawClipper_cpy;
	GUI.dRendering = GUI_dRendering_cpy;
	if(GUI.dRendering)
		DirectX.ForceWindowedDirectDrawClipper = FALSE;
	else
		DirectX.ForceWindowedDirectDrawClipper = GUI.ForceWindowedDirectDrawClipper;
	DirectX.DisableHardwareScale = DirectX_DisableHardwareScale_cpy;
	GUI.DoubleBuffered = GUI_DoubleBuffered_cpy;
	DirectX.BackBufferVRAM = DirectX_BackBufferVRAM_cpy;
	Settings.Transparency = Settings_Transparency_cpy;
	if(GUI_DoubleRenderingModes16_cpy != GUI.DoubleRenderingModes16 ||
	   GUI_DoubleRenderingModes8_cpy != GUI.DoubleRenderingModes8 ||
	   GUI_SupportHiRes_cpy != GUI.SupportHiRes ||
	   Settings.SixteenBit != Settings_SixteenBit_cpy ||
	   DirectX.OffScreenVRAM != DirectX_OffScreenVRAM_cpy) {

		GUI.DoubleRenderingModes16 = GUI_DoubleRenderingModes16_cpy;
		GUI.DoubleRenderingModes8 = GUI_DoubleRenderingModes8_cpy;
		DirectX.OffScreenVRAM = DirectX_OffScreenVRAM_cpy;
		GUI.SupportHiRes = GUI_SupportHiRes_cpy;
		if(Settings.GFXengine2 != Settings_GFXengine2_cpy ||
		   Settings.SixteenBit != Settings_SixteenBit_cpy) {
			Settings.SixteenBit = Settings_SixteenBit_cpy;
			Settings.GFXengine2 = Settings_GFXengine2_cpy;
			S9xSwitchGFXengine(Settings.GFXengine2);
		}
		if(!GUI.DoubleRendering) {
			GUI.Scale = 0;
			Settings.SupportHiRes = FALSE;
		}
		else {
			//2xSaI[hւ̐؂芷̏ꍇ̃XN[obt@NA΍
			ResetRenderMethod();
			GUI.Scale = (Settings.SixteenBit ? GUI.DoubleRenderingModes16 : GUI.DoubleRenderingModes8);
			Settings.SupportHiRes = GUI.SupportHiRes;
		}
		if(GUI.FullScreen)
			{
				if(!(errConfigSwitch = !SwitchScreenMode(TRUE)))
					GUI.FullScreen = TRUE;
			}
		else
			{
				if(!(errConfigSwitch = !SwitchScreenMode(TRUE)))
					GUI.FullScreen = FALSE;
			}
		if(!errConfigSwitch && (GUI.StopEmulation || Settings.SPCPlaying))
			S9xDrawScreenData();
	}

	if(Settings.GFXengine2 != Settings_GFXengine2_cpy) {
		Settings.GFXengine2 = Settings_GFXengine2_cpy;
		S9xSwitchGFXengine(Settings.GFXengine2);
	}

	//MixInterval
	GetWindowText(GetDlgItem(hSettingsDlg, IDC_EDIT_SOUNDMIXINTERVAL), tmpcharbuf, 255);
	tmpnumval = (int)atoi(tmpcharbuf);
	if(tmpnumval >= 1 && tmpnumval <= 999) {
		Settings_SoundMixInterval_cpy = tmpnumval;
	}
	else {
		Settings_SoundMixInterval_cpy = Settings.SoundMixInterval;
	}

	if(Options.SoundRate != Options_SoundRate_cpy ||
	   Options.SoundBit != Options_SoundBit_cpy ||
	   Options.SoundChn != Options_SoundChn_cpy ||
	   Settings.SoundBufferSize != Settings_SoundBufferSize_cpy ||
	   Settings.SoundMixInterval != Settings_SoundMixInterval_cpy ||
	   GUI.DSuse != GUI_DSuse_cpy ||
	   GUI.SoundGlobalFocus != GUI_SoundGlobalFocus_cpy ||
	   GUI.DirectSoundNotify != GUI_DirectSoundNotify_cpy) {

		Options.SoundRate = Options_SoundRate_cpy;
		Options.SoundBit = Options_SoundBit_cpy;
		Options.SoundChn = Options_SoundChn_cpy;
		Settings.SoundBufferSize = Settings_SoundBufferSize_cpy;
		Settings.SoundMixInterval = Settings_SoundMixInterval_cpy;
		GUI.DSuse = GUI_DSuse_cpy;
		GUI.SoundGlobalFocus = GUI_SoundGlobalFocus_cpy;
		GUI.DirectSoundNotify = GUI_DirectSoundNotify_cpy;

		UosneswSetupSound(SoundRates[Options.SoundRate],
						  Options.SoundBit == 16,
						  Options.SoundChn == 2);
		
		GUI_DSuse_cpy = GUI.DSuse;
		GUI_DirectSoundNotify_cpy = GUI.DirectSoundNotify;
	}
	GUI.PriorityClass = GUI_PriorityClass_cpy;
	GUI.ThreadPriority = GUI_ThreadPriority_cpy;
	GUI.WindowTopMost = GUI_WindowTopMost_cpy;
}


static char *SoundRateStr[] = {"8000Hz", "11025Hz", "22050Hz", "32000Hz", "44100Hz", "48000Hz"};

static char *SoundBitStr[] = {"8bit", "16bit"};

static char *SoundChnStr[] = {"mono", "stereo"};

static char *SoundBufferLengthStr[] = {"2 interval",
									   "3 interval",
									   "4 interval",
									   "5 interval",
									   "6 interval",
									   "7 interval",
									   "8 interval",
									   "9 interval"};

static char *SoundAPI[] = {"waveOutSound",
						   "DirectSound"};

static char *PriorityClassStr[] = {"IDLE_PRIORITY_CLASS",
								   "NORMAL_PRIORITY_CLASS",
								   "HIGH_PRIORITY_CLASS",
								   "REALTIME_PRIORITY_CLASS"};

static char *ThreadPriorityStr[] = {"THREAD_PRIORITY_LOWEST",
									"THREAD_PRIORITY_BELOW_NORMAL",
									"THREAD_PRIORITY_NORMAL",
									"THREAD_PRIORITY_ABOVE_NORMAL",
									"THREAD_PRIORITY_HIGHEST",
									"THREAD_PRIORITY_IDLE",
									"THREAD_PRIORITY_TIME_CRITICAL"};

LRESULT CALLBACK SettingsDlgProc(HWND hWnd, UINT uMsg,WPARAM wParam, LPARAM lParam)
{
	switch (uMsg) {
	case WM_INITDIALOG:
		{
			int i;
			hSettingsDlg = hWnd;
			//Sound Rate
			for (i = 0; i < 6; i++)
				SendMessage(GetDlgItem(hWnd, IDC_COMBO_SOUNDRATE),
							CB_INSERTSTRING,
							(WPARAM)i,
							(LPARAM)SoundRateStr[i]);

			//Sound Bit
			for (i = 0; i < 2; i++)
				SendMessage(GetDlgItem(hWnd, IDC_COMBO_SOUNDBIT),
							CB_INSERTSTRING,
							(WPARAM)i,
							(LPARAM)SoundBitStr[i]);

			//Sound Chn
			for (i = 0; i < 2; i++)
				SendMessage(GetDlgItem(hWnd, IDC_COMBO_SOUNDCHN),
							CB_INSERTSTRING,
							(WPARAM)i,
							(LPARAM)SoundChnStr[i]);

			//SoundBufferLengthR{{bNXɃeLXgZbg
			for (i = 0; i < 8; i++)
				SendMessage(GetDlgItem(hWnd, IDC_COMBO_SOUNDBUFFERLENGTH),
							CB_INSERTSTRING,
							(WPARAM)i,
							(LPARAM)SoundBufferLengthStr[i]);

			//Stream API
			for (i = 0; i < 2; i++)
				SendMessage(GetDlgItem(hWnd, IDC_COMBO_SOUNDAPI),
							CB_INSERTSTRING,
							(WPARAM)i,
							(LPARAM)SoundAPI[i]);

			//Thread
			for (i = 0; i < 4; i++)
				SendMessage(GetDlgItem(hWnd, IDC_COMBO_PRIORITYCLASS),
							CB_INSERTSTRING,
							(WPARAM)i,
							(LPARAM)PriorityClassStr[i]);

			for (i = 0; i < 7; i++)
				SendMessage(GetDlgItem(hWnd, IDC_COMBO_THREADPRIORITY),
							CB_INSERTSTRING,
							(WPARAM)i,
							(LPARAM)ThreadPriorityStr[i]);
			
			SettingsDlgCtrlSet();
		}
		break;

	case WM_COMMAND:
		switch (LOWORD(wParam)) {
		case IDC_RADIO_2X_HARDWARE:
		case IDC_RADIO_2X_SOFTWARE:
		case IDC_RADIO_2X_SCANLINES:
		case IDC_RADIO_2X_EAGLE:
		case IDC_RADIO_2X_SAI:
		case IDC_RADIO_SUPER_2X_SAI:
		case IDC_RADIO_SCALE_2X_SAI:
		case IDC_RADIO_2X_TVMODE:
		case IDC_RADIO_2X_HQ2X:
		case IDC_RADIO_2X_LQ2X:

		case IDC_CHECK_RENDERING_ASMMMX:
		case IDC_CHECK_FORCEWINDOWEDDIRECTDRAWCLIPPER:
		case IDC_CHECK_DOUBLEBUFFERING:
		case IDC_CHECK_DIRECTSCREENRENDERING:
		case IDC_CHECK_DISABLEHARDWARESCALE:
		case IDC_CHECK_OFFSCREENVRAM:
		case IDC_CHECK_BACKBUFFERVRAM:
		case IDC_CHECK_WINDOWTOPMOST:
		case IDC_CHECK_DIRECTSOUNDNOTIFY:
		case IDC_CHECK_SOUNDGLOBALFOCUS:
			if(HIWORD(wParam) == BN_CLICKED) {
				bool8 tmpVal = (bool8)(IsDlgButtonChecked(hWnd, (int)LOWORD(wParam)) == BST_CHECKED);
				if(LOWORD(wParam) == IDC_RADIO_2X_HARDWARE ||
				   LOWORD(wParam) == IDC_RADIO_2X_SOFTWARE ||
				   LOWORD(wParam) == IDC_RADIO_2X_SCANLINES ||
				   LOWORD(wParam) == IDC_RADIO_2X_EAGLE ||
				   LOWORD(wParam) == IDC_RADIO_2X_SAI ||
				   LOWORD(wParam) == IDC_RADIO_SUPER_2X_SAI ||
				   LOWORD(wParam) == IDC_RADIO_SCALE_2X_SAI ||
				   LOWORD(wParam) == IDC_RADIO_2X_TVMODE ||
				   LOWORD(wParam) == IDC_RADIO_2X_HQ2X ||
				   LOWORD(wParam) == IDC_RADIO_2X_LQ2X) {
					if(LOWORD(wParam) == IDC_RADIO_2X_HARDWARE) {
						if(Settings_SixteenBit_cpy)
							GUI_DoubleRenderingModes16_cpy = 1;
						else
							GUI_DoubleRenderingModes8_cpy = 1;
					}
					else if(LOWORD(wParam) == IDC_RADIO_2X_SOFTWARE) {
						if(Settings_SixteenBit_cpy)
							GUI_DoubleRenderingModes16_cpy = 2;
						else
							GUI_DoubleRenderingModes8_cpy = 2;
					}
					else if(LOWORD(wParam) == IDC_RADIO_2X_SCANLINES) {
						if(Settings_SixteenBit_cpy)
							GUI_DoubleRenderingModes16_cpy = 3;
						else
							GUI_DoubleRenderingModes8_cpy = 3;
					}
					else if(LOWORD(wParam) == IDC_RADIO_2X_EAGLE)
						GUI_DoubleRenderingModes16_cpy = 4;
					else if(LOWORD(wParam) == IDC_RADIO_2X_SAI)
						GUI_DoubleRenderingModes16_cpy = 5;
					else if(LOWORD(wParam) == IDC_RADIO_SUPER_2X_SAI)
						GUI_DoubleRenderingModes16_cpy = 6;
					else if(LOWORD(wParam) == IDC_RADIO_SCALE_2X_SAI)
						GUI_DoubleRenderingModes16_cpy = 7;
					else if(LOWORD(wParam) == IDC_RADIO_2X_TVMODE)
						GUI_DoubleRenderingModes16_cpy = 8;
					else if(LOWORD(wParam) == IDC_RADIO_2X_HQ2X)
						GUI_DoubleRenderingModes16_cpy = 9;
					else if(LOWORD(wParam) == IDC_RADIO_2X_LQ2X)
						GUI_DoubleRenderingModes16_cpy = 10;

					SendMessage(GetDlgItem(hWnd, IDC_RADIO_2X_HARDWARE),
								BM_SETCHECK,
								LOWORD(wParam) == IDC_RADIO_2X_HARDWARE ? 1 : 0,
								0);

					SendMessage(GetDlgItem(hWnd, IDC_RADIO_2X_SOFTWARE),
								BM_SETCHECK,
								LOWORD(wParam) == IDC_RADIO_2X_SOFTWARE ? 1 : 0,
								0);

					SendMessage(GetDlgItem(hWnd, IDC_RADIO_2X_SCANLINES),
								BM_SETCHECK,
								LOWORD(wParam) == IDC_RADIO_2X_SCANLINES ?  1 : 0,
								0);

					SendMessage(GetDlgItem(hWnd, IDC_RADIO_2X_EAGLE),
								BM_SETCHECK,
								LOWORD(wParam) == IDC_RADIO_2X_EAGLE ?  1 : 0,
								0);

					SendMessage(GetDlgItem(hWnd, IDC_RADIO_2X_SAI),
								BM_SETCHECK,
								LOWORD(wParam) == IDC_RADIO_2X_SAI ?  1 : 0,
								0);

					SendMessage(GetDlgItem(hWnd, IDC_RADIO_SUPER_2X_SAI),
								BM_SETCHECK,
								LOWORD(wParam) == IDC_RADIO_SUPER_2X_SAI ?  1 : 0,
								0);

					SendMessage(GetDlgItem(hWnd, IDC_RADIO_SCALE_2X_SAI),
								BM_SETCHECK,
								LOWORD(wParam) == IDC_RADIO_SCALE_2X_SAI ?  1 : 0,
								0);

					SendMessage(GetDlgItem(hWnd, IDC_RADIO_2X_TVMODE),
								BM_SETCHECK,
								LOWORD(wParam) == IDC_RADIO_2X_TVMODE ?  1 : 0,
								0);

					SendMessage(GetDlgItem(hWnd, IDC_RADIO_2X_HQ2X),
								BM_SETCHECK,
								LOWORD(wParam) == IDC_RADIO_2X_HQ2X ?  1 : 0,
								0);

					SendMessage(GetDlgItem(hWnd, IDC_RADIO_2X_LQ2X),
								BM_SETCHECK,
								LOWORD(wParam) == IDC_RADIO_2X_LQ2X ?  1 : 0,
								0);

					EnableWindow(GetDlgItem(hWnd, IDC_CHECK_DISABLEHARDWARESCALE),
								 (Settings_SixteenBit_cpy ? (GUI_DoubleRenderingModes16_cpy == 1) :
								  (GUI_DoubleRenderingModes8_cpy == 1)) ? FALSE : TRUE);

					if(GUI_DoubleRenderingModes16_cpy == GUI.DoubleRenderingModes16 &&
					   GUI_DoubleRenderingModes8_cpy == GUI.DoubleRenderingModes8)
						break;
				}
				else if(LOWORD(wParam) == IDC_CHECK_FORCEWINDOWEDDIRECTDRAWCLIPPER)
					{
						GUI_ForceWindowedDirectDrawClipper_cpy = tmpVal;
					}
				else if(LOWORD(wParam) == IDC_CHECK_DOUBLEBUFFERING)
					{
						GUI_DoubleBuffered_cpy = (tmpVal ? TRUE : FALSE);
					}
				else if(LOWORD(wParam) == IDC_CHECK_DIRECTSCREENRENDERING)
					{
						GUI_dRendering_cpy = tmpVal;
						EnableWindow(GetDlgItem(hWnd, IDC_CHECK_FORCEWINDOWEDDIRECTDRAWCLIPPER),
									 GUI_dRendering_cpy ? FALSE : TRUE);
					}
				else if(LOWORD(wParam) == IDC_CHECK_DISABLEHARDWARESCALE)
					{
						DirectX_DisableHardwareScale_cpy = (unsigned char)tmpVal;
					}
				else if(LOWORD(wParam) == IDC_CHECK_OFFSCREENVRAM)
					{
						DirectX_OffScreenVRAM_cpy = (tmpVal ? TRUE : FALSE);
					}
				else if(LOWORD(wParam) == IDC_CHECK_BACKBUFFERVRAM)
					{
						DirectX_BackBufferVRAM_cpy = (tmpVal ? TRUE : FALSE);
					}
				else if(LOWORD(wParam) == IDC_CHECK_WINDOWTOPMOST)
					{
						GUI_WindowTopMost_cpy = (unsigned char)tmpVal;
					}
				else if(LOWORD(wParam) == IDC_CHECK_DIRECTSOUNDNOTIFY)
					{
						GUI_DirectSoundNotify_cpy = (BOOL)tmpVal;
					}
				else if(LOWORD(wParam) == IDC_CHECK_SOUNDGLOBALFOCUS)
					{
						GUI_SoundGlobalFocus_cpy = (BOOL)tmpVal;
					}
				ConfigDlgSettingsChanged(hWnd);
			}
			break;

		case IDC_COMBO_SOUNDRATE:
		case IDC_COMBO_SOUNDBIT:
		case IDC_COMBO_SOUNDCHN:
		case IDC_COMBO_SOUNDBUFFERLENGTH:
		case IDC_COMBO_SOUNDAPI:
		case IDC_COMBO_PRIORITYCLASS:
		case IDC_COMBO_THREADPRIORITY:
			if(HIWORD(wParam) == CBN_SELENDOK) {
				int i = (int)SendMessage(GetDlgItem(hWnd, (int)LOWORD(wParam)),
									 CB_GETCURSEL,
									 0,
									 0);
				if(LOWORD(wParam) == IDC_COMBO_SOUNDRATE)
					Options_SoundRate_cpy = i;
				else if(LOWORD(wParam) == IDC_COMBO_SOUNDBIT) {
					if(i == 0)
						Options_SoundBit_cpy = 8;
					else if(i == 1)
						Options_SoundBit_cpy = 16;
					else
						Options_SoundBit_cpy = Options.SoundBit;
				}
				else if(LOWORD(wParam) == IDC_COMBO_SOUNDCHN) {
					if(i == 0)
						Options_SoundChn_cpy = 1;
					else if(i == 1)
						Options_SoundChn_cpy = 2;
					else
						Options_SoundChn_cpy = Options.SoundChn;
				}
				else if(LOWORD(wParam) == IDC_COMBO_SOUNDBUFFERLENGTH)
					Settings_SoundBufferSize_cpy = i + 2;
				else if(LOWORD(wParam) == IDC_COMBO_SOUNDAPI) {
					GUI_DSuse_cpy = (BOOL)i;
					EnableWindow(GetDlgItem(hSettingsDlg, IDC_CHECK_DIRECTSOUNDNOTIFY),
								 GUI_DSuse_cpy == 0 ? FALSE : TRUE);
				}
				else if(LOWORD(wParam) == IDC_COMBO_PRIORITYCLASS) {
					if(i == 0)
						GUI_PriorityClass_cpy = IDLE_PRIORITY_CLASS;
					else if(i == 1)
						GUI_PriorityClass_cpy = NORMAL_PRIORITY_CLASS;
					else if(i == 2)
						GUI_PriorityClass_cpy = HIGH_PRIORITY_CLASS;
					else if(i == 3)
						GUI_PriorityClass_cpy = REALTIME_PRIORITY_CLASS;
				}
				else if(LOWORD(wParam) == IDC_COMBO_THREADPRIORITY) {
					if(i == 0)
						GUI_ThreadPriority_cpy = THREAD_PRIORITY_LOWEST;
					else if(i == 1)
						GUI_ThreadPriority_cpy = THREAD_PRIORITY_BELOW_NORMAL;
					else if(i == 2)
						GUI_ThreadPriority_cpy = THREAD_PRIORITY_NORMAL;
					else if(i == 3)
						GUI_ThreadPriority_cpy = THREAD_PRIORITY_ABOVE_NORMAL;
					else if(i == 4)
						GUI_ThreadPriority_cpy = THREAD_PRIORITY_HIGHEST;
					else if(i == 5)
						GUI_ThreadPriority_cpy = THREAD_PRIORITY_IDLE;
					else if(i == 6)
						GUI_ThreadPriority_cpy = THREAD_PRIORITY_TIME_CRITICAL;
				}
				if(Options_SoundRate_cpy != Options.SoundRate ||
				   Options_SoundBit_cpy != Options.SoundBit ||
				   Options_SoundChn_cpy != Options.SoundChn ||
				   Settings_SoundBufferSize_cpy != Settings.SoundBufferSize ||
				   Settings_SoundMixInterval_cpy != Settings.SoundMixInterval ||
				   GUI_DSuse_cpy != GUI.DSuse ||
				   GUI_PriorityClass_cpy != GUI.PriorityClass ||
				   GUI_ThreadPriority_cpy != GUI.ThreadPriority) {
					ConfigDlgSettingsChanged(hWnd);
				}
			}
			break;

		case IDC_EDIT_SOUNDMIXINTERVAL:
			if(HIWORD(wParam) == EN_CHANGE) {
				ConfigDlgSettingsChanged(hWnd);
			}
			break;

		default:
			break;
		}
		break;

	case WM_NOTIFY:
		switch(((NMHDR *)lParam)->code) {
		case PSN_APPLY:
			ConfigDlgSettingsSave();
			break;

		case PSN_HELP:
			ConfigDlgDefaultSettingsLoad(hWnd);
			break;

		case PSN_QUERYCANCEL:
			SettingsDlgReleaseSubClass();
			break;

		case PSN_SETACTIVE:
			if(Settings_SixteenBit_cpy)
				Scale2X16RadioCtrlSet(hWnd);
			else
				Scale2X8RadioCtrlSet(hWnd);
			EnableWindow(GetDlgItem(hWnd, IDC_CHECK_DISABLEHARDWARESCALE),
						 (Settings_SixteenBit_cpy ?
						  (GUI_DoubleRenderingModes16_cpy == 1) :
						  (GUI_DoubleRenderingModes8_cpy == 1)) ?
						 FALSE : TRUE);
			StartPageIndex = 0;
			SettingsDlgSetSubClass(hWnd);
			break;

		case PSN_KILLACTIVE:
			SettingsDlgReleaseSubClass();
			break;

		default:
			break;
		}
		break;

	default:
		break;
	}
	return FALSE;
}

static void SettingsDlgCtrlSet()
{
	int i, c;
	
	if(!hSettingsDlg)
		return;

	SendMessage(GetDlgItem(hSettingsDlg, IDC_COMBO_SOUNDRATE),
				CB_SETCURSEL,
				(WPARAM)Options_SoundRate_cpy,
				0);

	switch(Options_SoundBit_cpy) {
	case 8: i = 0; break;
	case 16: i = 1; break;
	default: i = 1;  break;
	}
	SendMessage(GetDlgItem(hSettingsDlg, IDC_COMBO_SOUNDBIT),
				CB_SETCURSEL,
				(WPARAM)i,
				0);

	switch(Options_SoundChn_cpy) {
	case 1: i = 0; break;
	case 2: i = 1; break;
	default: i = 1;  break;
	}
	SendMessage(GetDlgItem(hSettingsDlg, IDC_COMBO_SOUNDCHN),
				CB_SETCURSEL,
				(WPARAM)i,
				0);

	SendMessage(GetDlgItem(hSettingsDlg, IDC_COMBO_SOUNDBUFFERLENGTH),
				CB_SETCURSEL,
				(WPARAM)(Settings_SoundBufferSize_cpy - 2),
				0);


	SendMessage(GetDlgItem(hSettingsDlg, IDC_COMBO_SOUNDAPI),
				CB_SETCURSEL,
				(WPARAM)GUI_DSuse_cpy,
				0);

	//MixInterval
	SendMessage(GetDlgItem(hSettingsDlg, IDC_EDIT_SOUNDMIXINTERVAL), EM_SETLIMITTEXT, 3, 0);
	wsprintf(tmpcharbuf, "%d", Settings_SoundMixInterval_cpy);
	SetWindowText(GetDlgItem(hSettingsDlg, IDC_EDIT_SOUNDMIXINTERVAL), tmpcharbuf);

	if(Settings_SixteenBit_cpy)
		Scale2X16RadioCtrlSet(hSettingsDlg);
	else
		Scale2X8RadioCtrlSet(hSettingsDlg);

	SendMessage(GetDlgItem(hSettingsDlg, IDC_CHECK_FORCEWINDOWEDDIRECTDRAWCLIPPER),
				BM_SETCHECK,
				(WPARAM)(GUI_ForceWindowedDirectDrawClipper_cpy ? 1 : 0),
				0);

	SendMessage(GetDlgItem(hSettingsDlg, IDC_CHECK_DOUBLEBUFFERING),
				BM_SETCHECK,
				(WPARAM)(GUI_DoubleBuffered_cpy ? 1 : 0),
				0);

	SendMessage(GetDlgItem(hSettingsDlg, IDC_CHECK_DIRECTSCREENRENDERING),
				BM_SETCHECK,
				(WPARAM)(GUI_dRendering_cpy ? 1 : 0),
				0);

	SendMessage(GetDlgItem(hSettingsDlg, IDC_CHECK_DISABLEHARDWARESCALE),
				BM_SETCHECK,
				(WPARAM)(DirectX_DisableHardwareScale_cpy ? 1 : 0),
				0);

	SendMessage(GetDlgItem(hSettingsDlg, IDC_CHECK_OFFSCREENVRAM),
				BM_SETCHECK,
				(WPARAM)(DirectX_OffScreenVRAM_cpy ? 1 : 0),
				0);

	SendMessage(GetDlgItem(hSettingsDlg, IDC_CHECK_BACKBUFFERVRAM),
				BM_SETCHECK,
				(WPARAM)(DirectX_BackBufferVRAM_cpy ? 1 : 0),
				0);

	SendMessage(GetDlgItem(hSettingsDlg, IDC_CHECK_WINDOWTOPMOST),
				BM_SETCHECK,
				(WPARAM)(GUI_WindowTopMost_cpy ? 1 : 0),
				0);

	SendMessage(GetDlgItem(hSettingsDlg, IDC_CHECK_DIRECTSOUNDNOTIFY),
				BM_SETCHECK,
				(WPARAM)(GUI_DirectSoundNotify_cpy ? 1 : 0),
				0);

	SendMessage(GetDlgItem(hSettingsDlg, IDC_CHECK_SOUNDGLOBALFOCUS),
				BM_SETCHECK,
				(WPARAM)(GUI_SoundGlobalFocus_cpy ? 1 : 0),
				0);

	EnableWindow(GetDlgItem(hSettingsDlg, IDC_CHECK_FORCEWINDOWEDDIRECTDRAWCLIPPER),
				 GUI_dRendering_cpy ? FALSE : TRUE);

	EnableWindow(GetDlgItem(hSettingsDlg, IDC_CHECK_DISABLEHARDWARESCALE),
				 (Settings_SixteenBit_cpy ? (GUI_DoubleRenderingModes16_cpy == 1) :
				  (GUI_DoubleRenderingModes8_cpy == 1)) ? FALSE : TRUE);

	EnableWindow(GetDlgItem(hSettingsDlg, IDC_CHECK_DIRECTSOUNDNOTIFY),
				 GUI_DSuse_cpy == 0 ? FALSE : TRUE);

	if(GUI_PriorityClass_cpy == IDLE_PRIORITY_CLASS)
		i = 0;
	else if(GUI_PriorityClass_cpy == NORMAL_PRIORITY_CLASS)
		i = 1;
	else if(GUI_PriorityClass_cpy == HIGH_PRIORITY_CLASS)
		i = 2;
	else if(GUI_PriorityClass_cpy == REALTIME_PRIORITY_CLASS)
		i = 3;
	else
		i = 1;
	SendMessage(GetDlgItem(hSettingsDlg, IDC_COMBO_PRIORITYCLASS),
				CB_SETCURSEL,
				(WPARAM)i,
				0);

	if(GUI_ThreadPriority_cpy == THREAD_PRIORITY_LOWEST)
		i = 0;
	else if(GUI_ThreadPriority_cpy == THREAD_PRIORITY_BELOW_NORMAL)
		i = 1;
	else if(GUI_ThreadPriority_cpy == THREAD_PRIORITY_NORMAL)
		i = 2;
	else if(GUI_ThreadPriority_cpy == THREAD_PRIORITY_ABOVE_NORMAL)
		i = 3;
	else if(GUI_ThreadPriority_cpy == THREAD_PRIORITY_HIGHEST)
		i = 4;
	else if(GUI_ThreadPriority_cpy == THREAD_PRIORITY_IDLE)
		i = 5;
	else if(GUI_ThreadPriority_cpy == THREAD_PRIORITY_TIME_CRITICAL)
		i = 6;
	else
		i = 2;
	SendMessage(GetDlgItem(hSettingsDlg, IDC_COMBO_THREADPRIORITY),
				CB_SETCURSEL,
				(WPARAM)i,
				0);
}

static WNDPROC Edit_MixInterval;
static HWND hEdit_MixInterval;

static LRESULT CALLBACK SettingsEditSubProc(HWND hWnd, UINT uMsg, WPARAM wParam, LPARAM lParam)
{
	switch (uMsg) {
	case WM_CHAR:
		if((LOWORD(wParam) >= '0' && LOWORD(wParam) <= '9') || LOWORD(wParam) == VK_BACK)
			break;
		return 0;

	default:
		break;

	}
	if(hWnd == hEdit_MixInterval && Edit_MixInterval)
		return (CallWindowProc(Edit_MixInterval, hWnd, uMsg, wParam, lParam));
	return 0;
}

static void SettingsDlgSetSubClass(HWND hWnd)
{
	hEdit_MixInterval = GetDlgItem(hWnd, IDC_EDIT_SOUNDMIXINTERVAL);
	Edit_MixInterval = (WNDPROC)GetWindowLong(hEdit_MixInterval, GWL_WNDPROC);
	SetWindowLong(hEdit_MixInterval, GWL_WNDPROC, (LONG)SettingsEditSubProc);
}

static void SettingsDlgReleaseSubClass()
{
	SetWindowLong(hEdit_MixInterval, GWL_WNDPROC, (LONG)Edit_MixInterval);
}

static void Scale2X16RadioCtrlSet(HWND hWnd)
{
	SendMessage(GetDlgItem(hWnd, IDC_RADIO_2X_HARDWARE),
				BM_SETCHECK,
				(WPARAM)((GUI_DoubleRenderingModes16_cpy == 1) ? 1 : 0),
				0);

	SendMessage(GetDlgItem(hWnd, IDC_RADIO_2X_SOFTWARE),
				BM_SETCHECK,
				(WPARAM)((GUI_DoubleRenderingModes16_cpy == 2) ? 1 : 0),
				0);

	SendMessage(GetDlgItem(hWnd, IDC_RADIO_2X_SCANLINES),
				BM_SETCHECK,
				(WPARAM)((GUI_DoubleRenderingModes16_cpy == 3) ? 1 : 0),
				0);

	SendMessage(GetDlgItem(hWnd, IDC_RADIO_2X_EAGLE),
				BM_SETCHECK,
				(WPARAM)((GUI_DoubleRenderingModes16_cpy == 4) ? 1 : 0),
				0);

	SendMessage(GetDlgItem(hWnd, IDC_RADIO_2X_SAI),
				BM_SETCHECK,
				(WPARAM)((GUI_DoubleRenderingModes16_cpy == 5) ? 1 : 0),
				0);

	SendMessage(GetDlgItem(hWnd, IDC_RADIO_SUPER_2X_SAI),
				BM_SETCHECK,
				(WPARAM)((GUI_DoubleRenderingModes16_cpy == 6) ? 1 : 0),
				0);

	SendMessage(GetDlgItem(hWnd, IDC_RADIO_SCALE_2X_SAI),
				BM_SETCHECK,
				(WPARAM)((GUI_DoubleRenderingModes16_cpy == 7) ? 1 : 0),
				0);

	SendMessage(GetDlgItem(hWnd, IDC_RADIO_2X_TVMODE),
				BM_SETCHECK,
				(WPARAM)((GUI_DoubleRenderingModes16_cpy == 8) ? 1 : 0),
				0);

	SendMessage(GetDlgItem(hWnd, IDC_RADIO_2X_HQ2X),
				BM_SETCHECK,
				(WPARAM)((GUI_DoubleRenderingModes16_cpy == 9) ? 1 : 0),
				0);

	SendMessage(GetDlgItem(hWnd, IDC_RADIO_2X_LQ2X),
				BM_SETCHECK,
				(WPARAM)((GUI_DoubleRenderingModes16_cpy == 10) ? 1 : 0),
				0);

	EnableWindow(GetDlgItem(hWnd, IDC_RADIO_2X_EAGLE), TRUE);
	EnableWindow(GetDlgItem(hWnd, IDC_RADIO_2X_SAI), TRUE);
	EnableWindow(GetDlgItem(hWnd, IDC_RADIO_SUPER_2X_SAI), TRUE);
	EnableWindow(GetDlgItem(hWnd, IDC_RADIO_SCALE_2X_SAI), TRUE);
	EnableWindow(GetDlgItem(hWnd, IDC_RADIO_2X_TVMODE), TRUE);
	EnableWindow(GetDlgItem(hWnd, IDC_RADIO_2X_HQ2X), TRUE);
	EnableWindow(GetDlgItem(hWnd, IDC_RADIO_2X_LQ2X), TRUE);
}

static void Scale2X8RadioCtrlSet(HWND hWnd)
{
	SendMessage(GetDlgItem(hWnd, IDC_RADIO_2X_HARDWARE),
				BM_SETCHECK,
				(WPARAM)((GUI_DoubleRenderingModes8_cpy == 1) ? 1 : 0),
				0);

	SendMessage(GetDlgItem(hWnd, IDC_RADIO_2X_SOFTWARE),
				BM_SETCHECK,
				(WPARAM)((GUI_DoubleRenderingModes8_cpy == 2) ? 1 : 0),
				0);

	SendMessage(GetDlgItem(hWnd, IDC_RADIO_2X_SCANLINES),
				BM_SETCHECK,
				(WPARAM)((GUI_DoubleRenderingModes8_cpy == 3) ? 1 : 0),
				0);

	SendMessage(GetDlgItem(hWnd, IDC_RADIO_2X_EAGLE), BM_SETCHECK, 0, 0);
	SendMessage(GetDlgItem(hWnd, IDC_RADIO_2X_SAI), BM_SETCHECK, 0, 0);
	SendMessage(GetDlgItem(hWnd, IDC_RADIO_SUPER_2X_SAI), BM_SETCHECK, 0, 0);
	SendMessage(GetDlgItem(hWnd, IDC_RADIO_SCALE_2X_SAI), BM_SETCHECK, 0, 0);
	SendMessage(GetDlgItem(hWnd, IDC_RADIO_2X_TVMODE), BM_SETCHECK, 0, 0);
	SendMessage(GetDlgItem(hWnd, IDC_RADIO_2X_HQ2X), BM_SETCHECK, 0, 0);
	SendMessage(GetDlgItem(hWnd, IDC_RADIO_2X_LQ2X), BM_SETCHECK, 0, 0);
	EnableWindow(GetDlgItem(hWnd, IDC_RADIO_2X_EAGLE), FALSE);
	EnableWindow(GetDlgItem(hWnd, IDC_RADIO_2X_SAI), FALSE);
	EnableWindow(GetDlgItem(hWnd, IDC_RADIO_SUPER_2X_SAI), FALSE);
	EnableWindow(GetDlgItem(hWnd, IDC_RADIO_SCALE_2X_SAI), FALSE);
	EnableWindow(GetDlgItem(hWnd, IDC_RADIO_2X_TVMODE), FALSE);
	EnableWindow(GetDlgItem(hWnd, IDC_RADIO_2X_HQ2X), FALSE);
	EnableWindow(GetDlgItem(hWnd, IDC_RADIO_2X_LQ2X), FALSE);
}

