#include "snes9x.h"
#include "uosnesw.h"
#include "cfgdlg.h"

static int Options_SaveImagefileFormat_cpy;
static u8 Options_ReduceTheColorTo256_cpy;
static u8 Options_ReduceTheColorTo256IfWithin_cpy;
static u8 Options_ImagefileHiresStretch_cpy;
static u8 Options_RLEcompression256bitmap_cpy;
static u8 Options_DisplayScreenBufferAll_cpy;

static unsigned char Xxxcdda_Enable_cpy;
static unsigned char Xxxcdda_Drv_cpy;
static unsigned char GUI_FileBrowseWindow_cpy;
static bool8 Settings_DisableIRQCycleCount_cpy;
static u8 Options_inactive_x_cpy;

/*****************
 default settings
*****************/
extern unsigned char GUI_FileBrowseWindow_def;

static void OtherDlgCtrlSet(HWND hWnd);

void OtherSettingsLoad()
{
	Options_SaveImagefileFormat_cpy = Options.SaveImagefileFormat;
	Options_ReduceTheColorTo256_cpy = Options.ReduceTheColorTo256;
	Options_ReduceTheColorTo256IfWithin_cpy = Options.ReduceTheColorTo256IfWithin;
	Options_ImagefileHiresStretch_cpy = Options.ImagefileHiresStretch;
	Options_RLEcompression256bitmap_cpy = Options.RLEcompression256bitmap;
	Options_DisplayScreenBufferAll_cpy = Options.DisplayScreenBufferAll;
	Options_inactive_x_cpy = Options.inactive_x;

	Xxxcdda_Enable_cpy = Xxxcdda.Enable; // Original
	Xxxcdda_Drv_cpy = Xxxcdda.Drv; // Original
	Settings_DisableIRQCycleCount_cpy = Settings.DisableIRQCycleCount; // Original

	GUI_FileBrowseWindow_cpy = GUI.FileBrowseWindow;
}

static HWND hOtherDlg;

void OtherDefaultSettingsLoad()
{
	Options_SaveImagefileFormat_cpy = DefaultOptions.SaveImagefileFormat;
	Options_ReduceTheColorTo256_cpy = DefaultOptions.ReduceTheColorTo256;
	Options_ReduceTheColorTo256IfWithin_cpy = DefaultOptions.ReduceTheColorTo256IfWithin;
	Options_ImagefileHiresStretch_cpy = DefaultOptions.ImagefileHiresStretch;
	Options_RLEcompression256bitmap_cpy = DefaultOptions.RLEcompression256bitmap;
	Options_DisplayScreenBufferAll_cpy = DefaultOptions.DisplayScreenBufferAll;
	Options_inactive_x_cpy = DefaultOptions.inactive_x;

	Xxxcdda_Enable_cpy = OPTIONS_XXX_CDDAENABLE; // Original
	Xxxcdda_Drv_cpy = OPTIONS_XXX_CDDADRV; // Original

	Settings_DisableIRQCycleCount_cpy = DefaultSettings.DisableIRQCycleCount;

	GUI_FileBrowseWindow_cpy = GUI_FileBrowseWindow_def;

	OtherDlgCtrlSet(hOtherDlg);
}

void OtherSettingsSave()
{
	Options.SaveImagefileFormat = Options_SaveImagefileFormat_cpy;
	//Options.ReduceTheColorTo256 = Options_ReduceTheColorTo256_cpy;
	Options.ReduceTheColorTo256IfWithin = Options_ReduceTheColorTo256IfWithin_cpy;
	Options.ImagefileHiresStretch = Options_ImagefileHiresStretch_cpy;
	Options.RLEcompression256bitmap = Options_RLEcompression256bitmap_cpy;
	Options.DisplayScreenBufferAll = Options_DisplayScreenBufferAll_cpy;
	Options.inactive_x = Options_inactive_x_cpy;
	GUI.FileBrowseWindow = GUI_FileBrowseWindow_cpy;
	Settings.DisableIRQCycleCount = Settings_DisableIRQCycleCount_cpy; // Original

	// Original
	if(Xxxcdda_Drv_cpy != Xxxcdda.Drv) {
		cdda_exit();
		Xxxcdda.Drv = Xxxcdda_Drv_cpy;
		cdda_open();
		cdda_stop();
	}

	if(Xxxcdda_Enable_cpy != Xxxcdda.Enable) {
		if(Xxxcdda.Enable)
			cdda_exit();
		else {
			cdda_open();
			cdda_stop();
		}
		Xxxcdda.Enable = Xxxcdda_Enable_cpy;
	}
}

LRESULT CALLBACK OtherDlgProc(HWND hWnd, UINT uMsg,WPARAM wParam, LPARAM lParam)
{
	static char *combostrCdDrvFunc[] = {"A:",
										"B:",
										"C:",
										"D:",
										"E:",
										"F:",
										"G:",
										"H:",
										"I:",
										"J:",
										"K:",
										"L:",
										"M:",
										"N:",
										"O:",
										"P:",
										"Q:",
										"R:",
										"S:",
										"T:",
										"U:",
										"V:",
										"W:",
										"X:",
										"Y:",
										"Z:"};

	static int i;

	switch (uMsg) {
		case WM_INITDIALOG:
			hOtherDlg = hWnd;

			// Original
			for (i = 0; i < 26; i++ ) {
				SendMessage(GetDlgItem(hWnd, IDC_CDDRV_COMBO),
							CB_INSERTSTRING,
							(WPARAM)i,
							(LPARAM)(combostrCdDrvFunc[i]));
			}

			OtherDlgCtrlSet(hWnd);
			break;

		case WM_COMMAND:
			switch (LOWORD(wParam)) {
				case IDC_RADIO_SAVEIMAGEFILEFORMAT_BMP:
				case IDC_RADIO_SAVEIMAGEFILEFORMAT_PCX:
				case IDC_RADIO_SAVEIMAGEFILEFORMAT_GIF:
				case IDC_RADIO_SAVEIMAGEFILEFORMAT_PNG:
				case IDC_CHECK_REDUCETHECOLORTO256IFWITHIN:
				case IDC_CHECK_REDUCETHECOLORTO256:
				case IDC_CHECK_HIRESSTRETCH:
				case IDC_CHECK_RLECOMPRESSION256BITMAP:
				case IDC_CHECK_DISPLAYSCREENBUFFERALL:
				case IDC_CHECK_UOSXPLORER:
				case IDC_CHECK_INACTIVE_X:
					if(HIWORD(wParam) == BN_CLICKED) {
						bool8 tmpVal = (bool8)(IsDlgButtonChecked(hWnd, (int)LOWORD(wParam)) == BST_CHECKED);
						if(LOWORD(wParam) == IDC_RADIO_SAVEIMAGEFILEFORMAT_BMP ||
								LOWORD(wParam) == IDC_RADIO_SAVEIMAGEFILEFORMAT_PCX ||
								LOWORD(wParam) == IDC_RADIO_SAVEIMAGEFILEFORMAT_GIF ||
								LOWORD(wParam) == IDC_RADIO_SAVEIMAGEFILEFORMAT_PNG) {
							if(LOWORD(wParam) == IDC_RADIO_SAVEIMAGEFILEFORMAT_BMP) {
								Options_SaveImagefileFormat_cpy = 0;
								EnableWindow(GetDlgItem(hWnd, IDC_CHECK_REDUCETHECOLORTO256IFWITHIN), TRUE);
								EnableWindow(GetDlgItem(hWnd, IDC_CHECK_RLECOMPRESSION256BITMAP), TRUE);
								//EnableWindow(GetDlgItem(hWnd, IDC_CHECK_REDUCETHECOLORTO256), TRUE);
							}
							else if(LOWORD(wParam) == IDC_RADIO_SAVEIMAGEFILEFORMAT_PCX) {
								Options_SaveImagefileFormat_cpy = 1;
								EnableWindow(GetDlgItem(hWnd, IDC_CHECK_REDUCETHECOLORTO256IFWITHIN), TRUE);
								EnableWindow(GetDlgItem(hWnd, IDC_CHECK_RLECOMPRESSION256BITMAP), FALSE);
								//EnableWindow(GetDlgItem(hWnd, IDC_CHECK_REDUCETHECOLORTO256), TRUE);
							}
							else if(LOWORD(wParam) == IDC_RADIO_SAVEIMAGEFILEFORMAT_GIF) {
								Options_SaveImagefileFormat_cpy = 2;
								EnableWindow(GetDlgItem(hWnd, IDC_CHECK_REDUCETHECOLORTO256IFWITHIN), FALSE);
								EnableWindow(GetDlgItem(hWnd, IDC_CHECK_RLECOMPRESSION256BITMAP), FALSE);
								//EnableWindow(GetDlgItem(hWnd, IDC_CHECK_REDUCETHECOLORTO256), FALSE);
							}
							else if(LOWORD(wParam) == IDC_RADIO_SAVEIMAGEFILEFORMAT_PNG) {
								Options_SaveImagefileFormat_cpy = 3;
								EnableWindow(GetDlgItem(hWnd, IDC_CHECK_REDUCETHECOLORTO256IFWITHIN), TRUE);
								EnableWindow(GetDlgItem(hWnd, IDC_CHECK_RLECOMPRESSION256BITMAP), FALSE);
								//EnableWindow(GetDlgItem(hWnd, IDC_CHECK_REDUCETHECOLORTO256), TRUE);
							}
							SendMessage(GetDlgItem(hWnd, IDC_RADIO_SAVEIMAGEFILEFORMAT_BMP),
										BM_SETCHECK,
										(WPARAM)(Options_SaveImagefileFormat_cpy == 0 ? 1 : 0),
										0);
							SendMessage(GetDlgItem(hWnd, IDC_RADIO_SAVEIMAGEFILEFORMAT_PCX),
										BM_SETCHECK,
										(WPARAM)(Options_SaveImagefileFormat_cpy == 1 ? 1 : 0),
										0);
							SendMessage(GetDlgItem(hWnd, IDC_RADIO_SAVEIMAGEFILEFORMAT_GIF),
										BM_SETCHECK,
										(WPARAM)(Options_SaveImagefileFormat_cpy == 2 ? 1 : 0),
										0);
							SendMessage(GetDlgItem(hWnd, IDC_RADIO_SAVEIMAGEFILEFORMAT_PNG),
										BM_SETCHECK,
										(WPARAM)(Options_SaveImagefileFormat_cpy == 3 ? 1 : 0),
										0);
							if(Options.SaveImagefileFormat == Options_SaveImagefileFormat_cpy)
								break;
						}
						else if(LOWORD(wParam) == IDC_CHECK_REDUCETHECOLORTO256)
							Options_ReduceTheColorTo256_cpy = (u8)tmpVal;
						else if(LOWORD(wParam) == IDC_CHECK_REDUCETHECOLORTO256IFWITHIN)
							Options_ReduceTheColorTo256IfWithin_cpy = (u8)tmpVal;
						else if(LOWORD(wParam) == IDC_CHECK_HIRESSTRETCH)
							Options_ImagefileHiresStretch_cpy = (u8)tmpVal;
						else if(LOWORD(wParam) == IDC_CHECK_RLECOMPRESSION256BITMAP)
							Options_RLEcompression256bitmap_cpy = (u8)tmpVal;
						else if(LOWORD(wParam) == IDC_CHECK_DISPLAYSCREENBUFFERALL)
							Options_DisplayScreenBufferAll_cpy = (u8)tmpVal;
						else if(LOWORD(wParam) == IDC_CHECK_INACTIVE_X)
							Options_inactive_x_cpy = (u8)tmpVal;
						else if(LOWORD(wParam) == IDC_CHECK_UOSXPLORER)
							GUI_FileBrowseWindow_cpy = tmpVal;
						ConfigDlgSettingsChanged(hWnd);
					}
					break;

					// Original
				case IDC_CHECK_USECDDA:
					if(HIWORD(wParam) == BN_CLICKED) {
						bool8 tmpVal = (bool8)(IsDlgButtonChecked(hWnd, (int)LOWORD(wParam)) == BST_CHECKED);
                                                if(LOWORD(wParam) == IDC_CHECK_USECDDA)
							Xxxcdda_Enable_cpy = tmpVal;
						ConfigDlgSettingsChanged(hWnd);
					}
					break;

				case IDC_CDDRV_COMBO:
					if(HIWORD(wParam) == CBN_SELENDOK) {
						if(LOWORD(wParam) == IDC_CDDRV_COMBO)
						       i = (int)SendMessage(GetDlgItem(hWnd, (int)LOWORD(wParam)), CB_GETCURSEL, 0, 0);
							Xxxcdda_Drv_cpy = (uint8)i;
 						if(Xxxcdda_Drv_cpy != Xxxcdda.Drv)
						ConfigDlgSettingsChanged(hWnd);
					}
					break;

				case IDC_CHECK_DISABLE_IRQ_CYCLECOUNT:
					if(HIWORD(wParam) == BN_CLICKED) {
						bool8 tmpVal = (bool8)(IsDlgButtonChecked(hWnd, (int)LOWORD(wParam)) == BST_CHECKED);
                                                if(LOWORD(wParam) == IDC_CHECK_DISABLE_IRQ_CYCLECOUNT)
							Settings_DisableIRQCycleCount_cpy = tmpVal;
						ConfigDlgSettingsChanged(hWnd);
					}
					break;
					// Original
					
				default:
					break;
			}
			break;

		case WM_NOTIFY:
			switch(((NMHDR *)lParam)->code) {
				case PSN_APPLY:
					ConfigDlgSettingsSave();
					break;

				case PSN_HELP:
					ConfigDlgDefaultSettingsLoad(hWnd);
					break;

				case PSN_QUERYCANCEL:
					break;

				case PSN_SETACTIVE:
					EnableWindow(GetDlgItem(hWnd, IDC_CHECK_REDUCETHECOLORTO256IFWITHIN),
								 Options_SaveImagefileFormat_cpy != 2 ? TRUE : FALSE);
					//EnableWindow(GetDlgItem(hWnd, IDC_CHECK_REDUCETHECOLORTO256),
					//Options_SaveImagefileFormat_cpy != 2 ? TRUE : FALSE);
					StartPageIndex = 4;
					break;

				default:
					break;
			}
			break;

		default:
			break;
	}
	return FALSE;
}

static void OtherDlgCtrlSet(HWND hWnd)
{
	SendMessage(GetDlgItem(hWnd, IDC_RADIO_SAVEIMAGEFILEFORMAT_BMP),
				BM_SETCHECK,
				(WPARAM)(Options_SaveImagefileFormat_cpy == 0 ? 1 : 0),
				0);

	SendMessage(GetDlgItem(hWnd, IDC_RADIO_SAVEIMAGEFILEFORMAT_PCX),
				BM_SETCHECK,
				(WPARAM)(Options_SaveImagefileFormat_cpy == 1 ? 1 : 0),
				0);

	SendMessage(GetDlgItem(hWnd, IDC_RADIO_SAVEIMAGEFILEFORMAT_GIF),
				BM_SETCHECK,
				(WPARAM)(Options_SaveImagefileFormat_cpy == 2 ? 1 : 0),
				0);

	SendMessage(GetDlgItem(hWnd, IDC_RADIO_SAVEIMAGEFILEFORMAT_PNG),
				BM_SETCHECK,
				(WPARAM)(Options_SaveImagefileFormat_cpy == 3 ? 1 : 0),
				0);

	SendMessage(GetDlgItem(hWnd, IDC_CHECK_REDUCETHECOLORTO256),
				BM_SETCHECK,
				(WPARAM)(Options_ReduceTheColorTo256_cpy ? 1 : 0),
				0);

	SendMessage(GetDlgItem(hWnd, IDC_CHECK_REDUCETHECOLORTO256IFWITHIN),
				BM_SETCHECK,
				(WPARAM)(Options_ReduceTheColorTo256IfWithin_cpy ? 1 : 0),
				0);

	SendMessage(GetDlgItem(hWnd, IDC_CHECK_HIRESSTRETCH),
				BM_SETCHECK,
				(WPARAM)(Options_ImagefileHiresStretch_cpy ? 1 : 0),
				0);

	SendMessage(GetDlgItem(hWnd, IDC_CHECK_RLECOMPRESSION256BITMAP),
				BM_SETCHECK,
				(WPARAM)(Options_RLEcompression256bitmap_cpy ? 1 : 0),
				0);

	SendMessage(GetDlgItem(hWnd, IDC_CHECK_DISPLAYSCREENBUFFERALL),
				BM_SETCHECK,
				(WPARAM)(Options_DisplayScreenBufferAll_cpy ? 1 : 0),
				0);

	SendMessage(GetDlgItem(hWnd, IDC_CHECK_USECDDA),
				BM_SETCHECK,
				(WPARAM)(Xxxcdda_Enable_cpy ? 1 : 0),
				0);

	SendMessage(GetDlgItem(hWnd, IDC_CDDRV_COMBO),
				CB_SETCURSEL,
				(WPARAM)Xxxcdda.Drv,
				0);

	SendMessage(GetDlgItem(hWnd, IDC_CHECK_DISABLE_IRQ_CYCLECOUNT),
				BM_SETCHECK,
				(WPARAM)(Settings_DisableIRQCycleCount_cpy ? 1 : 0),
				0);

	SendMessage(GetDlgItem(hWnd, IDC_CHECK_UOSXPLORER),
				BM_SETCHECK,
				(WPARAM)(GUI_FileBrowseWindow_cpy ? 1 : 0),
				0);

	SendMessage(GetDlgItem(hWnd, IDC_CHECK_INACTIVE_X),
				BM_SETCHECK,
				(WPARAM)(Options_inactive_x_cpy ? 1 : 0),
				0);

	EnableWindow(GetDlgItem(hWnd, IDC_CHECK_REDUCETHECOLORTO256IFWITHIN),
				 Options_SaveImagefileFormat_cpy != 2 ? TRUE : FALSE);

	EnableWindow(GetDlgItem(hWnd, IDC_CHECK_REDUCETHECOLORTO256),
				 Options_SaveImagefileFormat_cpy != 2 ? TRUE : FALSE);

	EnableWindow(GetDlgItem(hWnd, IDC_CHECK_RLECOMPRESSION256BITMAP),
				 (Options_SaveImagefileFormat_cpy == 0) ? TRUE : FALSE);

	EnableWindow(GetDlgItem(hWnd, IDC_CHECK_DISPLAYSCREENBUFFERALL),
				 GUI.DoubleRendering ? TRUE : FALSE);

	//not supported yet
	EnableWindow(GetDlgItem(hWnd, IDC_CHECK_REDUCETHECOLORTO256), FALSE);
}
