#include "snes9x.h"
#include "memmap.h"
#include "uosnesw.h"
#include <commdlg.h>
#include "winutil.h"
#include "explorer.h"

static char *CBMemtypeStr_JP[] ={" F", "LoROM", "HiROM"};
static char *CBFormatStr_JP[] ={"̫ϯ F", "ذޖ", "ذދ", "ذ2"};
static char *CBVideoSystemStr_JP[] ={"޵ F", "PALw", "NTSCw"};
static char *CBHeaderStr_JP[] ={"ͯ F", "ͯޖ", "ͯޗL苭"};
static char CBAPURAMInitialValueStr_JP[] = "APURAM 0x%02X ر";
static char CBSRAMInitialValueStr_JP[] = "SRAM 0x%02X ر";

static char *CBMemtypeStr_US[] ={"Memory type Auto detect", "Force LoROM", "Force HiROM"};
static char *CBFormatStr_US[] ={"ROM format Auto detect", "Force not interleaved", "Force interleaved", "Force InterleavedMode2"};
static char *CBVideoSystemStr_US[] ={"Video system Auto detect", "Force PAL", "Force NTSC"};
static char *CBHeaderStr_US[] ={"ROM header Auto detect", "Force no header", "Force header"};
static char CBAPURAMInitialValueStr_US[] = "APURAM 0x%02X Clear";
static char CBSRAMInitialValueStr_US[] = "SRAM 0x%02X Clear";

static char tmpcharbuf[256];

LRESULT CALLBACK GetOpenFileNameHook(HWND hWnd, UINT uMsg,WPARAM wParam, LPARAM lParam)
{
//	static DWORD Style;
	static int i;
	switch (uMsg) {
		case WM_INITDIALOG:
			//OFN_EXPLOREȐꍇ͐eEChEnh擾
//			Style = GetWindowLong(GetParent(hWnd), GWL_EXSTYLE );
//			Style &= ~(WS_EX_CONTEXTHELP);
//			SetWindowLong(GetParent(hWnd), GWL_EXSTYLE, Style);
			for(i = 0; i < 3; i++)
				SendMessage(GetDlgItem(hWnd, IDC_COMBO_MEMTYPE),
							CB_INSERTSTRING,
							(WPARAM)i,
							(LPARAM)(GUI.Language ? CBMemtypeStr_JP[i] : CBMemtypeStr_US[i]));
			SendMessage(GetDlgItem(hWnd, IDC_COMBO_MEMTYPE), CB_SETCURSEL, 0, 0);

			for(i = 0; i < 4; i++)
				SendMessage(GetDlgItem(hWnd, IDC_COMBO_FORMAT),
							CB_INSERTSTRING,
							(WPARAM)i,
							(LPARAM)(GUI.Language ? CBFormatStr_JP[i] : CBFormatStr_US[i]));
			SendMessage(GetDlgItem(hWnd, IDC_COMBO_FORMAT), CB_SETCURSEL, 0, 0);

			for(i = 0; i < 3; i++)
				SendMessage(GetDlgItem(hWnd, IDC_COMBO_VIDEOSYSTEM),
							CB_INSERTSTRING,
							(WPARAM)i,
							(LPARAM)(GUI.Language ? CBVideoSystemStr_JP[i] : CBVideoSystemStr_US[i]));
			SendMessage(GetDlgItem(hWnd, IDC_COMBO_VIDEOSYSTEM), CB_SETCURSEL, 0, 0);

			for(i = 0; i < 3; i++)
				SendMessage(GetDlgItem(hWnd, IDC_COMBO_HEADER),
							CB_INSERTSTRING,
							(WPARAM)i,
							(LPARAM)(GUI.Language ? CBHeaderStr_JP[i] : CBHeaderStr_US[i]));
			SendMessage(GetDlgItem(hWnd, IDC_COMBO_HEADER), CB_SETCURSEL, 0, 0);

			for(i = 0; i < 2; i++) {
				wsprintf((LPTSTR)tmpcharbuf,
						 (LPCTSTR)(GUI.Language ? CBAPURAMInitialValueStr_JP : CBAPURAMInitialValueStr_US),
						 Settings.APURAMInitialValues[i]);
				SendMessage(GetDlgItem(hWnd, IDC_COMBO_APURAMINITIALVALUE),
							CB_INSERTSTRING,
							(WPARAM)i,
							(LPARAM)tmpcharbuf);
			}
			SendMessage(GetDlgItem(hWnd, IDC_COMBO_APURAMINITIALVALUE), CB_SETCURSEL, 0, 0);

			for(i = 0; i < 4; i++) {
				wsprintf((LPTSTR)tmpcharbuf,
						 (LPCTSTR)(GUI.Language ? CBSRAMInitialValueStr_JP : CBSRAMInitialValueStr_US),
						 Settings.SRAMInitialValues[i]);
				SendMessage(GetDlgItem(hWnd, IDC_COMBO_SRAMINITIALVALUE),
							CB_INSERTSTRING,
							(WPARAM)i,
							(LPARAM)tmpcharbuf);
			}
			SendMessage(GetDlgItem(hWnd, IDC_COMBO_SRAMINITIALVALUE), CB_SETCURSEL, 0, 0);
			break;

		case WM_COMMAND:
			switch (LOWORD(wParam)) {
				case IDC_COMBO_MEMTYPE:
				case IDC_COMBO_FORMAT:
				case IDC_COMBO_VIDEOSYSTEM:
				case IDC_COMBO_HEADER:
				case IDC_COMBO_APURAMINITIALVALUE:
					if(HIWORD(wParam) == CBN_SELENDOK) {
						i = (int)SendMessage(GetDlgItem(hWnd, (int)LOWORD(wParam)), CB_GETCURSEL, 0, 0);
						if(LOWORD(wParam) == IDC_COMBO_MEMTYPE) {
							if(i == 0) {
								Settings.ForceLoROM = Settings.ForceHiROM = 0;
							}
							else if(i == 1) {
								Settings.ForceLoROM = 1;
								Settings.ForceHiROM = 0;
							}
							else if(i == 2) {
								Settings.ForceLoROM = 0;
								Settings.ForceHiROM = 1;
							}
							else {
								Settings.ForceLoROM = Settings.ForceHiROM = 0;
							}
						}
						else if(LOWORD(wParam) == IDC_COMBO_FORMAT) {
							if(i == 0) {
								Settings.ForceInterleaved = Settings.ForceInterleaved2 = Settings.ForceNotInterleaved = 0;
							}
							else if(i == 1) {
								Settings.ForceInterleaved = Settings.ForceInterleaved2 = 0;
								Settings.ForceNotInterleaved = 1;
							}
							else if(i == 2) {
								Settings.ForceInterleaved = 1;
								Settings.ForceInterleaved2 = Settings.ForceNotInterleaved = 0;
							}
							else if(i == 3) {
								Settings.ForceInterleaved = Settings.ForceNotInterleaved = 0;
								Settings.ForceInterleaved2 = 1;
							}
							else {
								Settings.ForceInterleaved = Settings.ForceInterleaved2 = Settings.ForceNotInterleaved = 0;
							}
						}
						else if(LOWORD(wParam) == IDC_COMBO_VIDEOSYSTEM) {
							if(i == 0) {
								Settings.ForcePAL = Settings.ForceNTSC = 0;
							}
							else if(i == 1) {
								Settings.ForcePAL = 1;
								Settings.ForceNTSC = 0;
							}
							else if(i == 2) {
								Settings.ForcePAL = 0;
								Settings.ForceNTSC = 1;
							}
							else {
								Settings.ForcePAL = Settings.ForceNTSC = 0;
							}
						}
						else if(LOWORD(wParam) == IDC_COMBO_HEADER) {
							if(i == 0) {
								Settings.ForceHeader = Settings.ForceNoHeader = 0;
							}
							else if(i == 1) {
								Settings.ForceNoHeader = 1;
								Settings.ForceHeader = 0;
							}
							else if(i == 2) {
								Settings.ForceNoHeader = 0;
								Settings.ForceHeader = 1;
							}
							else {
								Settings.ForceHeader = Settings.ForceNoHeader = 0;
							}
						}
						else if(LOWORD(wParam) == IDC_COMBO_APURAMINITIALVALUE) {
							if(i == 0) {
								Settings.APURAMInitialValue = Settings.APURAMInitialValues[i];
							}
							else if(i == 1) {
								Settings.APURAMInitialValue = Settings.APURAMInitialValues[i];
							}
							else {
								Settings.APURAMInitialValue = DefaultSettings.APURAMInitialValue;
							}
						}
						else if(LOWORD(wParam) == IDC_COMBO_SRAMINITIALVALUE) {
							if(i == 0) {
								Settings.SRAMInitialValue = Settings.SRAMInitialValues[i];
							}
							else if(i == 1) {
								Settings.SRAMInitialValue = Settings.SRAMInitialValues[i];
							}
							else if(i == 2) {
								Settings.SRAMInitialValue = Settings.SRAMInitialValues[i];
							}
							else if(i == 3) {
								Settings.SRAMInitialValue = Settings.SRAMInitialValues[i];
							}
							else {
								Settings.SRAMInitialValue = DefaultSettings.SRAMInitialValue;
							}
						}
					}
					break;
			}
			break;

		default:
			break;
	}
	return FALSE;
}

//#define OFN_ENABLESIZING             0x00800000

BOOL OpenFile(HWND hWnd, char *FileName, char *FileTitle, char *InitialROMFileDirectory)
{
	OPENFILENAME ofn;
	BOOL ret;
	FillMemory((PVOID)&ofn, sizeof(ofn), 0);

	ofn.lStructSize = sizeof(ofn);
	ofn.hwndOwner = hWnd;
	ofn.hInstance = (HINSTANCE)GetWindowLong(hWnd, GWL_HINSTANCE);
	ofn.lpstrFilter = "All Supported Types\0*.smc;*.sfc;*.swc;*.fig;*.078;*.zip;*.jma;*.lzh;*.rar;*.cab;*.1;*.spc;*.sp1;*.sp2;*.sp3;*.sp4;*.sp5;*.sp6;*.sp7;*.sp8;*.sp9\0All files(*.*)\0*.*\0\0";
	ofn.lpstrFile = FileName;
	ofn.nMaxFile = _MAX_PATH;
	ofn.Flags = OFN_FILEMUSTEXIST | OFN_HIDEREADONLY | OFN_NONETWORKBUTTON | OFN_EXPLORER |
	0x00800000 | OFN_ENABLEHOOK | OFN_ENABLETEMPLATE;
	ofn.lpstrDefExt = "smc";
	ofn.nMaxFileTitle = _MAX_PATH;
	ofn.lpstrFileTitle = FileTitle;
	ofn.lpstrTitle = (GUI.Language ? "ǂݍ" : "Open ROM");
	ofn.lpfnHook = (LPOFNHOOKPROC)GetOpenFileNameHook;
	ofn.lpstrInitialDir = InitialROMFileDirectory;
	ofn.lpTemplateName = MAKEINTRESOURCE(GUI.Language ? IDD_GETOPENFILENAMECUSTDIALOG_JP : IDD_GETOPENFILENAMECUSTDIALOG_US);

	ImeEnable(hWnd, TRUE);
	ret = GetOpenFileName(&ofn);
	ImeEnable(hWnd, FALSE);

	if(!ret)
		Memory.ClearForced();
	return ret;
}

OPENFILENAMEEXPLORERPOS uosxplorerposition = {
	/* RECT WindowRect */
	{-1, -1, -1, -1},
	/* Maximize */
	FALSE,
	/* Minimize */
	FALSE,
	/* VSplitBarPos0 */
	-1,
	/* ColumnWidth0 */
	-1,
	/* ColumnWidth1 */
	-1,
	/* ColumnWidth2 */
	-1,
	/* ColumnWidth3 */
	-1
};

/*******************************
 Original explorer style dialog 
*******************************/

static LRESULT CALLBACK GetOpenFileNameExplorerHook(HWND hWnd, UINT uMsg,WPARAM wParam, LPARAM lParam)
{
	static HWND hOkButton, hCancelButton, hMemTypeCombo, hFormatCombo, hVideoSystemCombo, hHeaderCombo,
				hAPURAMInitialValueCombo, hSRAMInitialValueCombo;
	static LPOPENFILENAMEEXPLORER lpofne;
	switch (uMsg) {
		case WM_INITDIALOG:
			{
				hOkButton = NULL;
				hCancelButton = NULL;
				hMemTypeCombo = NULL;
				hFormatCombo = NULL;
				hVideoSystemCombo = NULL;
				hHeaderCombo = NULL;
				hAPURAMInitialValueCombo = NULL;
				hSRAMInitialValueCombo = NULL;
				lpofne = NULL;

				lpofne = (LPOPENFILENAMEEXPLORER)lParam;
				HFONT hFont = (HFONT)SendMessage(hWnd, WM_GETFONT, 0, 0);

				hOkButton = CreateWindow(
					(LPCTSTR)"BUTTON",
					(LPCTSTR)(GUI.Language ? "J(&O)" : "&Open"),
					WS_CHILD | WS_TABSTOP | WS_VISIBLE | WS_CLIPSIBLINGS,
					0, 0, 0, 0,
					hWnd,
					(HMENU)IDOK,
					(HINSTANCE)GetWindowLong(hWnd, GWL_HINSTANCE),
					NULL
				);

				if(hOkButton && hFont)
					SendMessage(hOkButton, WM_SETFONT, (WPARAM)hFont, 0);

				hCancelButton = CreateWindow(
					(LPCTSTR)"BUTTON",
					(LPCTSTR)(GUI.Language ? "LZ" : "Cancel"),
					WS_CHILD | WS_TABSTOP | WS_VISIBLE | WS_CLIPSIBLINGS,
					0, 0, 0, 0,
					hWnd,
					(HMENU)IDCANCEL,
					(HINSTANCE)GetWindowLong(hWnd, GWL_HINSTANCE),
					NULL
				);

				if(hCancelButton && hFont)
					SendMessage(hCancelButton, WM_SETFONT, (WPARAM)hFont, 0);

				hMemTypeCombo = CreateWindow(
					(LPCTSTR)"COMBOBOX",
					(LPCTSTR)"",
					WS_CHILD | CBS_DROPDOWNLIST | WS_VSCROLL | WS_TABSTOP | WS_VISIBLE | WS_CLIPSIBLINGS,
					0, 0, 0, 0,
					hWnd,
					(HMENU)IDC_COMBO_MEMTYPE,
					(HINSTANCE)GetWindowLong(hWnd, GWL_HINSTANCE),
					NULL
				);

				if(hMemTypeCombo && hFont)
					SendMessage(hMemTypeCombo, WM_SETFONT, (WPARAM)hFont, 0);

				hFormatCombo = CreateWindow(
					(LPCTSTR)"COMBOBOX",
					(LPCTSTR)"",
					WS_CHILD | CBS_DROPDOWNLIST | WS_VSCROLL | WS_TABSTOP | WS_VISIBLE | WS_CLIPSIBLINGS,
					0, 0, 0, 0,
					hWnd,
					(HMENU)IDC_COMBO_FORMAT,
					(HINSTANCE)GetWindowLong(hWnd, GWL_HINSTANCE),
					NULL
				);

				if(hFormatCombo && hFont)
					SendMessage(hFormatCombo, WM_SETFONT, (WPARAM)hFont, 0);

				hVideoSystemCombo = CreateWindow(
					(LPCTSTR)"COMBOBOX",
					(LPCTSTR)"",
					WS_CHILD | CBS_DROPDOWNLIST | WS_VSCROLL | WS_TABSTOP | WS_VISIBLE | WS_CLIPSIBLINGS,
					0, 0, 0, 0,
					hWnd,
					(HMENU)IDC_COMBO_VIDEOSYSTEM,
					(HINSTANCE)GetWindowLong(hWnd, GWL_HINSTANCE),
					NULL
				);

				if(hVideoSystemCombo && hFont)
					SendMessage(hVideoSystemCombo, WM_SETFONT, (WPARAM)hFont, 0);

				hHeaderCombo = CreateWindow(
					(LPCTSTR)"COMBOBOX",
					(LPCTSTR)"",
					WS_CHILD | CBS_DROPDOWNLIST | WS_VSCROLL | WS_TABSTOP | WS_VISIBLE | WS_CLIPSIBLINGS,
					0, 0, 0, 0,
					hWnd,
					(HMENU)IDC_COMBO_HEADER,
					(HINSTANCE)GetWindowLong(hWnd, GWL_HINSTANCE),
					NULL
				);

				if(hHeaderCombo && hFont)
					SendMessage(hHeaderCombo, WM_SETFONT, (WPARAM)hFont, 0);

				hAPURAMInitialValueCombo = CreateWindow(
					(LPCTSTR)"COMBOBOX",
					(LPCTSTR)"",
					WS_CHILD | CBS_DROPDOWNLIST | WS_VSCROLL | WS_TABSTOP | WS_VISIBLE | WS_CLIPSIBLINGS,
					0, 0, 0, 0,
					hWnd,
					(HMENU)IDC_COMBO_APURAMINITIALVALUE,
					(HINSTANCE)GetWindowLong(hWnd, GWL_HINSTANCE),
					NULL
				);

				if(hAPURAMInitialValueCombo && hFont)
					SendMessage(hAPURAMInitialValueCombo, WM_SETFONT, (WPARAM)hFont, 0);

				hSRAMInitialValueCombo = CreateWindow(
					(LPCTSTR)"COMBOBOX",
					(LPCTSTR)"",
					WS_CHILD | CBS_DROPDOWNLIST | WS_VSCROLL | WS_TABSTOP | WS_VISIBLE | WS_CLIPSIBLINGS,
					0, 0, 0, 0,
					hWnd,
					(HMENU)IDC_COMBO_SRAMINITIALVALUE,
					(HINSTANCE)GetWindowLong(hWnd, GWL_HINSTANCE),
					NULL
				);
				
				if(hSRAMInitialValueCombo && hFont)
					SendMessage(hSRAMInitialValueCombo, WM_SETFONT, (WPARAM)hFont, 0);
				
				int i;
				
				for(i = 0; i < 3; i++)
					SendMessage(GetDlgItem(hWnd, IDC_COMBO_MEMTYPE),
								CB_INSERTSTRING,
								(WPARAM)i,
								(LPARAM)(GUI.Language ? CBMemtypeStr_JP[i] : CBMemtypeStr_US[i]));
				SendMessage(GetDlgItem(hWnd, IDC_COMBO_MEMTYPE), CB_SETCURSEL, 0, 0);

				for(i = 0; i < 4; i++)
					SendMessage(GetDlgItem(hWnd, IDC_COMBO_FORMAT),
								CB_INSERTSTRING,
								(WPARAM)i,
								(LPARAM)(GUI.Language ? CBFormatStr_JP[i] : CBFormatStr_US[i]));
				SendMessage(GetDlgItem(hWnd, IDC_COMBO_FORMAT), CB_SETCURSEL, 0, 0);

				for(i = 0; i < 3; i++)
					SendMessage(GetDlgItem(hWnd, IDC_COMBO_VIDEOSYSTEM),
								CB_INSERTSTRING,
								(WPARAM)i,
								(LPARAM)(GUI.Language ? CBVideoSystemStr_JP[i] : CBVideoSystemStr_US[i]));
				SendMessage(GetDlgItem(hWnd, IDC_COMBO_VIDEOSYSTEM), CB_SETCURSEL, 0, 0);

				for(i = 0; i < 3; i++)
					SendMessage(GetDlgItem(hWnd, IDC_COMBO_HEADER),
								CB_INSERTSTRING,
								(WPARAM)i,
								(LPARAM)(GUI.Language ? CBHeaderStr_JP[i] : CBHeaderStr_US[i]));
				SendMessage(GetDlgItem(hWnd, IDC_COMBO_HEADER), CB_SETCURSEL, 0, 0);

				for(i = 0; i < 2; i++) {
					wsprintf((LPTSTR)tmpcharbuf,
							 (LPCTSTR)(GUI.Language ? CBAPURAMInitialValueStr_JP : CBAPURAMInitialValueStr_US),
							 Settings.APURAMInitialValues[i]);
					SendMessage(GetDlgItem(hWnd, IDC_COMBO_APURAMINITIALVALUE),
								CB_INSERTSTRING,
								(WPARAM)i,
								(LPARAM)tmpcharbuf);
				}
				SendMessage(GetDlgItem(hWnd, IDC_COMBO_APURAMINITIALVALUE), CB_SETCURSEL, 0, 0);

				for(i = 0; i < 4; i++) {
					wsprintf((LPTSTR)tmpcharbuf,
							 (LPCTSTR)(GUI.Language ? CBSRAMInitialValueStr_JP : CBSRAMInitialValueStr_US),
							 Settings.SRAMInitialValues[i]);
					SendMessage(GetDlgItem(hWnd, IDC_COMBO_SRAMINITIALVALUE),
								CB_INSERTSTRING,
								(WPARAM)i,
								(LPARAM)tmpcharbuf);
				}
				SendMessage(GetDlgItem(hWnd, IDC_COMBO_SRAMINITIALVALUE), CB_SETCURSEL, 0, 0);
			}
			break;

		case WM_VSCROLL:
			break;

		case WM_SIZE:
			{
				RECT rc;
				HDWP hdwp;
				int framex = GetSystemMetrics(SM_CXSIZEFRAME);
				int framey = GetSystemMetrics(SM_CYSIZEFRAME);
				
				GetWindowRect(hMemTypeCombo, &rc);
				int ComboHeight = rc.bottom - rc.top;
				int BottomSpaceHeight = ComboHeight * 3 + framey * 4;
				int MinClientWidht = (int)lpofne->MinWidth - framex * 2;
				int ComboHalfWidth = (MinClientWidht - (framex * 4)) / 5;
				int combolistheight;
				
				GetClientRect(hWnd, &rc);
				SendMessage(hWnd, EXP_SETCLIENTSPACE, 0, MAKELPARAM((WORD)BottomSpaceHeight, 0));
				if(!(hdwp = BeginDeferWindowPos(8)))
					break;
				
				combolistheight = SendMessage(hMemTypeCombo,
											  CB_GETITEMHEIGHT,
											  (WPARAM)-1, 0) * SendMessage(hMemTypeCombo, CB_GETCOUNT, 0, 0) + ComboHeight;
				DeferWindowPos(hdwp, hMemTypeCombo, NULL, rc.left + (ComboHalfWidth * 2) * 0 + framex * 1,
							   rc.bottom - ((BottomSpaceHeight < (rc.bottom - rc.top)) ?
											BottomSpaceHeight : 0) + framey * 1 + ComboHeight * 0,
							   (ComboHalfWidth * 2), combolistheight, SWP_NOACTIVATE | SWP_NOZORDER);
				combolistheight = SendMessage(hFormatCombo,
											  CB_GETITEMHEIGHT,
											  (WPARAM)-1, 0) * SendMessage(hFormatCombo, CB_GETCOUNT, 0, 0) + ComboHeight;
				DeferWindowPos(hdwp, hFormatCombo, NULL, rc.left + (ComboHalfWidth * 2) * 1 + framex * 2,
							   rc.bottom - ((BottomSpaceHeight < (rc.bottom - rc.top)) ?
											BottomSpaceHeight : 0) + framey * 1 + ComboHeight * 0,
							   (ComboHalfWidth * 2), combolistheight, SWP_NOACTIVATE | SWP_NOZORDER);

				combolistheight = SendMessage(hVideoSystemCombo,
											  CB_GETITEMHEIGHT,
											  (WPARAM)-1, 0) * SendMessage(hVideoSystemCombo, CB_GETCOUNT, 0, 0) + ComboHeight;
				DeferWindowPos(hdwp, hVideoSystemCombo, NULL, rc.left + (ComboHalfWidth * 2) * 0 + framex * 1,
							   rc.bottom - ((BottomSpaceHeight < (rc.bottom - rc.top)) ?
											BottomSpaceHeight : 0) + framey * 2 + ComboHeight * 1,
							   (ComboHalfWidth * 2), combolistheight, SWP_NOACTIVATE | SWP_NOZORDER);
				combolistheight = SendMessage(hHeaderCombo,
											  CB_GETITEMHEIGHT,
											  (WPARAM)-1, 0) * SendMessage(hHeaderCombo, CB_GETCOUNT, 0, 0) + ComboHeight;
				DeferWindowPos(hdwp, hHeaderCombo, NULL, rc.left + (ComboHalfWidth * 2) * 1 + framex * 2,
							   rc.bottom - ((BottomSpaceHeight < (rc.bottom - rc.top)) ?
											BottomSpaceHeight : 0) + framey * 2 + ComboHeight * 1,
							   (ComboHalfWidth * 2), combolistheight, SWP_NOACTIVATE | SWP_NOZORDER);

				combolistheight = SendMessage(hAPURAMInitialValueCombo,
											  CB_GETITEMHEIGHT,
											  (WPARAM)-1, 0) * SendMessage(hAPURAMInitialValueCombo, CB_GETCOUNT, 0, 0) + ComboHeight;
				DeferWindowPos(hdwp, hAPURAMInitialValueCombo, NULL, rc.left + (ComboHalfWidth * 2) * 0 + framex * 1,
							   rc.bottom - ((BottomSpaceHeight < (rc.bottom - rc.top)) ?
											BottomSpaceHeight : 0) + framey * 3 + ComboHeight * 2,
							   (ComboHalfWidth * 2), combolistheight, SWP_NOACTIVATE | SWP_NOZORDER);
				combolistheight = SendMessage(hSRAMInitialValueCombo,
											  CB_GETITEMHEIGHT,
											  (WPARAM)-1, 0) * SendMessage(hSRAMInitialValueCombo, CB_GETCOUNT, 0, 0) + ComboHeight;
				DeferWindowPos(hdwp, hSRAMInitialValueCombo, NULL, rc.left + (ComboHalfWidth * 2) * 1 + framex * 2,
							   rc.bottom - ((BottomSpaceHeight < (rc.bottom - rc.top)) ?
											BottomSpaceHeight : 0) + framey * 3 + ComboHeight * 2,
							   (ComboHalfWidth * 2), combolistheight, SWP_NOACTIVATE | SWP_NOZORDER);

				DeferWindowPos(hdwp, hOkButton, NULL, rc.left + (ComboHalfWidth * 2) * 2 + framex * 3,
							   rc.bottom - ((BottomSpaceHeight < (rc.bottom - rc.top)) ?
											BottomSpaceHeight : 0) + framey * 1 + ComboHeight * 0,
							   ComboHalfWidth, ComboHeight, SWP_NOACTIVATE | SWP_NOZORDER);
				DeferWindowPos(hdwp, hCancelButton, NULL, rc.left + (ComboHalfWidth * 2) * 2 + framex * 3,
							   rc.bottom - ((BottomSpaceHeight < (rc.bottom - rc.top)) ?
											BottomSpaceHeight : 0) + framey * 2 + ComboHeight * 1,
							   ComboHalfWidth, ComboHeight, SWP_NOACTIVATE | SWP_NOZORDER);
				
				EndDeferWindowPos(hdwp);
			}
			break;

		case WM_COMMAND:
			switch (LOWORD(wParam)) {
				case IDC_COMBO_MEMTYPE:
				case IDC_COMBO_FORMAT:
				case IDC_COMBO_VIDEOSYSTEM:
				case IDC_COMBO_HEADER:
				case IDC_COMBO_APURAMINITIALVALUE:
				case IDC_COMBO_SRAMINITIALVALUE:
					if(HIWORD(wParam) == CBN_SELENDOK) {
						int i = (int)SendMessage(GetDlgItem(hWnd, (int)LOWORD(wParam)),
												 CB_GETCURSEL, 0, 0);
						if(LOWORD(wParam) == IDC_COMBO_MEMTYPE) {
							if(i == 0) {
								Settings.ForceLoROM = Settings.ForceHiROM = 0;
							}
							else if(i == 1) {
								Settings.ForceLoROM = 1;
								Settings.ForceHiROM = 0;
							}
							else if(i == 2) {
								Settings.ForceLoROM = 0;
								Settings.ForceHiROM = 1;
							}
							else {
								Settings.ForceLoROM = Settings.ForceHiROM = 0;
							}
						}
						else if(LOWORD(wParam) == IDC_COMBO_FORMAT) {
							if(i == 0) {
								Settings.ForceInterleaved = Settings.ForceInterleaved2 = Settings.ForceNotInterleaved = 0;
							}
							else if(i == 1) {
								Settings.ForceInterleaved = Settings.ForceInterleaved2 = 0;
								Settings.ForceNotInterleaved = 1;
							}
							else if(i == 2) {
								Settings.ForceInterleaved = 1;
								Settings.ForceInterleaved2 = Settings.ForceNotInterleaved = 0;
							}
							else if(i == 3) {
								Settings.ForceInterleaved = Settings.ForceNotInterleaved = 0;
								Settings.ForceInterleaved2 = 1;
							}
							else {
								Settings.ForceInterleaved = Settings.ForceInterleaved2 = Settings.ForceNotInterleaved = 0;
							}
						}
						else if(LOWORD(wParam) == IDC_COMBO_VIDEOSYSTEM) {
							if(i == 0) {
								Settings.ForcePAL = Settings.ForceNTSC = 0;
							}
							else if(i == 1) {
								Settings.ForcePAL = 1;
								Settings.ForceNTSC = 0;
							}
							else if(i == 2) {
								Settings.ForcePAL = 0;
								Settings.ForceNTSC = 1;
							}
							else {
								Settings.ForcePAL = Settings.ForceNTSC = 0;
							}
						}
						else if(LOWORD(wParam) == IDC_COMBO_HEADER) {
							if(i == 0) {
								Settings.ForceHeader = Settings.ForceNoHeader = 0;
							}
							else if(i == 1) {
								Settings.ForceNoHeader = 1;
								Settings.ForceHeader = 0;
							}
							else if(i == 2) {
								Settings.ForceNoHeader = 0;
								Settings.ForceHeader = 1;
							}
							else {
								Settings.ForceHeader = Settings.ForceNoHeader = 0;
							}
						}
						else if(LOWORD(wParam) == IDC_COMBO_APURAMINITIALVALUE) {
							if(i == 0) {
								Settings.APURAMInitialValue = Settings.APURAMInitialValues[i];
							}
							else if(i == 1) {
								Settings.APURAMInitialValue = Settings.APURAMInitialValues[i];
							}
							else {
								Settings.APURAMInitialValue = DefaultSettings.APURAMInitialValue;
							}
						}
						else if(LOWORD(wParam) == IDC_COMBO_SRAMINITIALVALUE) {
							if(i == 0) {
								Settings.SRAMInitialValue = Settings.SRAMInitialValues[i];
							}
							else if(i == 1) {
								Settings.SRAMInitialValue = Settings.SRAMInitialValues[i];
							}
							else if(i == 2) {
								Settings.SRAMInitialValue = Settings.SRAMInitialValues[i];
							}
							else if(i == 3) {
								Settings.SRAMInitialValue = Settings.SRAMInitialValues[i];
							}
							else {
								Settings.SRAMInitialValue = DefaultSettings.SRAMInitialValue;
							}
						}
					}
					break;

				case IDCANCEL:
					break;
			}
			break;

		case WM_DESTROY:
			break;
			
		default:
			break;
	}
	return FALSE;
}

BOOL OpenFileEx(HWND hWnd, char *FileName, char *FileTitle, char *InitialROMFileDirectory)
{
	static LPCSTR FilterStrings[] = {".smc", ".sfc", ".swc", ".fig", ".078", ".058", ".zip", ".jma", ".lzh",
									".rar", ".cab", ".1", ".spc", ".sp1", ".sp2", ".sp3", ".sp4",
									".sp5", ".sp6", ".sp7", ".sp8", ".sp9", NULL};

	OPENFILENAMEEXPLORER ofne;
	BOOL ret;

	FillMemory((PVOID)&ofne, sizeof(ofne), 0);

	ofne.lStructSize = sizeof(ofne);
	ofne.hwndOwner = hWnd;
	ofne.hInstance = (HINSTANCE)GetWindowLong(hWnd, GWL_HINSTANCE);
	ofne.FilterStrings = FilterStrings;
	ofne.FilterTitle = GUI.Language ? "Ή`" : "Supported Types";
	ofne.FilterOn = TRUE;
	ofne.lpstrFile = FileName;
	ofne.nMaxFile = _MAX_PATH;
	ofne.nMaxFileTitle = _MAX_PATH;
	ofne.lpstrFileTitle = FileTitle;
	ofne.lpstrTitle = "uosXplorer";
	ofne.lpstrInitialDir = InitialROMFileDirectory;
	ofne.hIcon = LoadIcon(ofne.hInstance, MAKEINTRESOURCE(EXP_ICON));
	ofne.Flags = OFNE_ENABLEHOOK;
	ofne.lpfnHook = GetOpenFileNameExplorerHook;
	ofne.lpOfnePos = &uosxplorerposition;
	ofne.Japanese = (GUI.Language ? TRUE : FALSE);
	ofne.MinWidth = 500;
	ofne.MinHeight = 375;
	ofne.DisableArchiveShellFolder = TRUE;

//	ofne.lpTemplateName = GUI.Language ? MAKEINTRESOURCE(IDD_DIALOGTEMPLATE_JP) : MAKEINTRESOURCE(IDD_DIALOGTEMPLATE_US);

	ImeEnable(hWnd, TRUE);
	ret = GetOpenFileNameExplorer(&ofne);
	ImeEnable(hWnd, FALSE);

	if(!ret)
		Memory.ClearForced();
	return ret;
}

