#include "snes9x.h"
#include "uosnesw.h"
#include <dinput.h>
#include "wininput.h"
#include "uowinput.h"
#include "cfgdlg.h"

extern LRESULT CALLBACK SubPropProc(HWND hWnd, UINT uMsg,WPARAM wParam, LPARAM lParam);
extern HWND hProp;
extern WNDPROC PropProc;

static void SetJoyButtonCode(HWND hFocus, WORD KeyCode);
static void SetJoyButtonText(HWND hWnd, WORD KeyCode);

static void JoyDlgCtlSet();
static void SetSubClass();
static void ReleaseSubClass(HWND hWnd);

static int ComboNo;
volatile static BOOL JoyStatusReading;
static BOOL JoyDlgTimerActive = false;

static HBRUSH SelectedEditBkRed = 0;
static HBRUSH SelectedEditBkGreen = 0;
static HBRUSH SelectedEditBkBlue = 0;
static HBRUSH SelectedEditBkYello = 0;
static HBRUSH SelectedEditBkGray = 0;
static HBRUSH SelectedEditBkLightGray = 0;
static HBRUSH SelectedEditBkOrange = 0;

static HWND hJoypadDlg;

static HWND hEdit_Left, hEdit_Right, hEdit_Up, hEdit_Down, hEdit_Start, hEdit_Select,
	hEdit_A, hEdit_B, hEdit_X, hEdit_Y, hEdit_L, hEdit_R,
	hEdit_FunctionCode0, hEdit_FunctionCode1, hEdit_FunctionCode2, hEdit_FunctionCode3,
	hEdit_FunctionCode4, hEdit_FunctionCode5, hEdit_FunctionCode6, hEdit_FunctionCode7, hFocus;

static SJoypad Joypad_cpy[5];
static DWORD FunctionCode_cpy[8];
static bool8 Settings_JoystickConnected_cpy[5];

static BOOL GUI_DIuse_cpy;
extern BOOL GUI_DIuse_def;

void JoySettingsLoad()
{
	int i;

	GUI_DIuse_cpy = GUI.DIuse;

	for (i = 0; i < 5; i++ ) {
		Joypad_cpy[i] = GUI_DIuse_cpy ? JoypadB[i] : JoypadA[i];
		Settings_JoystickConnected_cpy[i] = Settings.JoystickConnected[i];
	}
	for (i = 0; i < 8; i++) {
		FunctionCode_cpy[i] = GUI_DIuse_cpy ? FunctionCodeB[i] : FunctionCodeA[i];
	}
}

void JoyDefaultSettingsLoad()
{
	GUI_DIuse_cpy = GUI_DIuse_def;
	JoyDlgCtlSet();
}

void JoySettingsSave()
{
	int i;
	for (i = 0; i < 5; i++) {
		if(GUI.DIuse)
			JoypadB[i] = Joypad_cpy[i];
		else
			JoypadA[i] = Joypad_cpy[i];
		Settings.JoystickConnected[i] = Settings_JoystickConnected_cpy[i];
	}

	for (i = 0; i < 8; i++) {
		if(GUI.DIuse)
			FunctionCodeB[i] = FunctionCode_cpy[i];
		else
			FunctionCodeA[i] = FunctionCode_cpy[i];
	}
	if(GUI_DIuse_cpy != GUI.DIuse) {
		GUI.DIuse = GUI_DIuse_cpy;
		UosneswJoystickInit();
		GUI_DIuse_cpy = GUI.DIuse;
	}
	MakeTurboStatus();

	for (i = 0; i < 5; i++) {
		Joypad_cpy[i] = GUI_DIuse_cpy ? JoypadB[i] : JoypadA[i];
	}
	for (i = 0; i < 8; i++) {
		FunctionCode_cpy[i] = GUI_DIuse_cpy ? FunctionCodeB[i] : FunctionCodeA[i];
	}
}

static char *combostr[] = {"Joypad #1", "Joypad #2", "Joypad #3", "Joypad #4", "Joypad #5"};
static char *combostrDIorWinAPI[] = {"WindowsAPI", "DirectInput"};
static char *combostrFunctionCode_JP[] = {"Xbg 1 Z[u",
										  "Xbg 2 Z[u",
										  "Xbg 1 [h",
										  "Xbg 2 [h",
										  "^[{[h",
										  "^[{ || >>",
										  "Zbg",
										  "\x83\x5ctgZbg",
										  "SPCzo",
										  "XN[Vbg",
										  "Xxx Key 1",
										  "Xxx Key 2",
										  "Xxx Key 3",
										  "Xxx Key 4",
										  "Xxx Key 5",
										  "Xxx Key 6",
										  "Xxx Key 7",
										  "Xxx Key 8",
										  "Xxx Key 9",
										  "Xxx Key 10",
										  "Sscope Turbo",
										  "Sscope Pause"};

static char *combostrFunctionCode_US[] = {"Slot 1 save",
										  "Slot 2 save",
										  "Slot 1 load",
										  "Slot 2 load",
										  "Turbo Mode",
										  "Turbo || >>",
										  "Reset",
										  "SoftReset",
										  "SPC dump",
										  "Screenshot",
										  "Xxx Key 1",
										  "Xxx Key 2",
										  "Xxx Key 3",
										  "Xxx Key 4",
										  "Xxx Key 5",
										  "Xxx Key 6",
										  "Xxx Key 7",
										  "Xxx Key 8",
										  "Xxx Key 9",
										  "Xxx Key 10",
										  "Sscope Turbo",
										  "Sscope Pause"};

//Joypad Configurasion
LRESULT CALLBACK JoypadDlgProc(HWND hWnd, UINT uMsg,WPARAM wParam, LPARAM lParam)
{
	switch (uMsg) {
	case WM_INITDIALOG:
		{
			int i;
			hJoypadDlg = hWnd;
			// save edit window handle.
			hEdit_Left = GetDlgItem(hWnd, IDC_EDIT_LEFT);
			hEdit_Right = GetDlgItem(hWnd, IDC_EDIT_RIGHT);
			hEdit_Up = GetDlgItem(hWnd, IDC_EDIT_UP);
			hEdit_Down = GetDlgItem(hWnd, IDC_EDIT_DOWN);
			hEdit_Start = GetDlgItem(hWnd, IDC_EDIT_START);
			hEdit_Select = GetDlgItem(hWnd, IDC_EDIT_SELECT);
			hEdit_A = GetDlgItem(hWnd, IDC_EDIT_A);
			hEdit_B = GetDlgItem(hWnd, IDC_EDIT_B);
			hEdit_X = GetDlgItem(hWnd, IDC_EDIT_X);
			hEdit_Y = GetDlgItem(hWnd, IDC_EDIT_Y);
			hEdit_L = GetDlgItem(hWnd, IDC_EDIT_L);
			hEdit_R = GetDlgItem(hWnd, IDC_EDIT_R);
			hEdit_FunctionCode0 = GetDlgItem(hWnd, IDC_EDIT_FUNCTIONCODE0);
			hEdit_FunctionCode1 = GetDlgItem(hWnd, IDC_EDIT_FUNCTIONCODE1);
			hEdit_FunctionCode2 = GetDlgItem(hWnd, IDC_EDIT_FUNCTIONCODE2);
			hEdit_FunctionCode3 = GetDlgItem(hWnd, IDC_EDIT_FUNCTIONCODE3);
			hEdit_FunctionCode4 = GetDlgItem(hWnd, IDC_EDIT_FUNCTIONCODE4);
			hEdit_FunctionCode5 = GetDlgItem(hWnd, IDC_EDIT_FUNCTIONCODE5);
			hEdit_FunctionCode6 = GetDlgItem(hWnd, IDC_EDIT_FUNCTIONCODE6);
			hEdit_FunctionCode7 = GetDlgItem(hWnd, IDC_EDIT_FUNCTIONCODE7);

			for (i = 0; i < 5; i++) {
				SendMessage(GetDlgItem(hWnd, IDC_CTRLCOMBO),
							CB_INSERTSTRING,
							(WPARAM)i,
							(LPARAM)combostr[i]);
			}
				
			for (i = 0; i < 2; i++) {
				SendMessage(GetDlgItem(hWnd, IDC_INPUTCOMBO),
							CB_INSERTSTRING,
							(WPARAM)i,
							(LPARAM)combostrDIorWinAPI[i]);
			}
			
			
			//set text FunctionCode combo
			for (i = 0; i < 22; i++) {
				SendMessage(GetDlgItem(hWnd, IDC_FUNCTIONCODECOMBO0),
							CB_INSERTSTRING,
							(WPARAM)i,
							(LPARAM)(GUI.Language ? combostrFunctionCode_JP[i] : combostrFunctionCode_US[i]));
			}
			for (i = 0; i < 22; i++) {
				SendMessage(GetDlgItem(hWnd, IDC_FUNCTIONCODECOMBO1),
							CB_INSERTSTRING,
							(WPARAM)i,
							(LPARAM)(GUI.Language ? combostrFunctionCode_JP[i] : combostrFunctionCode_US[i]));
			}
			for (i = 0; i < 22; i++) {
				SendMessage(GetDlgItem(hWnd, IDC_FUNCTIONCODECOMBO2),
							CB_INSERTSTRING,
							(WPARAM)i,
							(LPARAM)(GUI.Language ? combostrFunctionCode_JP[i] : combostrFunctionCode_US[i]));
			}
			for (i = 0; i < 22; i++) {
				SendMessage(GetDlgItem(hWnd, IDC_FUNCTIONCODECOMBO3),
							CB_INSERTSTRING,
							(WPARAM)i,
							(LPARAM)(GUI.Language ? combostrFunctionCode_JP[i] : combostrFunctionCode_US[i]));
			}
			for (i = 0; i < 22; i++) {
				SendMessage(GetDlgItem(hWnd, IDC_FUNCTIONCODECOMBO4),
							CB_INSERTSTRING,
							(WPARAM)i,
							(LPARAM)(GUI.Language ? combostrFunctionCode_JP[i] : combostrFunctionCode_US[i]));
			}
			for (i = 0; i < 22; i++) {
				SendMessage(GetDlgItem(hWnd, IDC_FUNCTIONCODECOMBO5),
							CB_INSERTSTRING,
							(WPARAM)i,
							(LPARAM)(GUI.Language ? combostrFunctionCode_JP[i] : combostrFunctionCode_US[i]));
			}
			for (i = 0; i < 22; i++) {
				SendMessage(GetDlgItem(hWnd, IDC_FUNCTIONCODECOMBO6),
							CB_INSERTSTRING,
							(WPARAM)i,
							(LPARAM)(GUI.Language ? combostrFunctionCode_JP[i] : combostrFunctionCode_US[i]));
			}
			for (i = 0; i < 22; i++) {
				SendMessage(GetDlgItem(hWnd, IDC_FUNCTIONCODECOMBO7),
							CB_INSERTSTRING,
							(WPARAM)i,
							(LPARAM)(GUI.Language ? combostrFunctionCode_JP[i] : combostrFunctionCode_US[i]));
			}
			
			// set control window
			JoyDlgCtlSet();
		}
		break;

	case WM_CTLCOLORSTATIC:
		{
			HBRUSH SelectedEditBk = 0;
			if(hEdit_Left == (HWND)lParam ||
			   hEdit_Right == (HWND)lParam ||
			   hEdit_Up == (HWND)lParam ||
			   hEdit_Down == (HWND)lParam)
				SelectedEditBk = SelectedEditBkGray;
			else if(hEdit_Start == (HWND)lParam ||
					hEdit_Select == (HWND)lParam ||
					hEdit_L == (HWND)lParam ||
					hEdit_R == (HWND)lParam)
				SelectedEditBk = SelectedEditBkLightGray;
			else if(hEdit_A == (HWND)lParam)
				SelectedEditBk = SelectedEditBkRed;
			else if(hEdit_B == (HWND)lParam)
				SelectedEditBk = SelectedEditBkYello;
			else if(hEdit_X == (HWND)lParam)
				SelectedEditBk = SelectedEditBkBlue;
			else if(hEdit_Y == (HWND)lParam)
				SelectedEditBk = SelectedEditBkGreen;
			else if(hEdit_FunctionCode0 == (HWND)lParam ||
					hEdit_FunctionCode1 == (HWND)lParam ||
					hEdit_FunctionCode2 == (HWND)lParam ||
					hEdit_FunctionCode3 == (HWND)lParam ||
					hEdit_FunctionCode4 == (HWND)lParam ||
					hEdit_FunctionCode5 == (HWND)lParam ||
					hEdit_FunctionCode6 == (HWND)lParam ||
					hEdit_FunctionCode7 == (HWND)lParam)
				SelectedEditBk = SelectedEditBkOrange;

			if(SelectedEditBk) {
				if(GetFocus() == (HWND)lParam) {
					SetBkMode((HDC)wParam, TRANSPARENT);
					return (long)SelectedEditBk;
				}
				return (long)GetStockObject(WHITE_BRUSH);
			}
		}
		break;
		
	case WM_COMMAND:
		switch (LOWORD(wParam)) {
		case IDC_EDIT_UP:
		case IDC_EDIT_DOWN:
		case IDC_EDIT_LEFT:
		case IDC_EDIT_RIGHT:
		case IDC_EDIT_A:
		case IDC_EDIT_B:
		case IDC_EDIT_X:
		case IDC_EDIT_Y:
		case IDC_EDIT_L:
		case IDC_EDIT_R:
		case IDC_EDIT_SELECT:
		case IDC_EDIT_START:
		case IDC_EDIT_FUNCTIONCODE0:
		case IDC_EDIT_FUNCTIONCODE1:
		case IDC_EDIT_FUNCTIONCODE2:
		case IDC_EDIT_FUNCTIONCODE3:
		case IDC_EDIT_FUNCTIONCODE4:
		case IDC_EDIT_FUNCTIONCODE5:
		case IDC_EDIT_FUNCTIONCODE6:
		case IDC_EDIT_FUNCTIONCODE7:
			if(HIWORD(wParam) == EN_KILLFOCUS || HIWORD(wParam) == EN_SETFOCUS)
				InvalidateRgn((HWND)lParam, NULL, TRUE);
			break;

		case IDC_CTRLCOMBO:
			if(HIWORD(wParam) == CBN_SELENDOK) {
				ComboNo = (int)SendMessage(GetDlgItem(hWnd, IDC_CTRLCOMBO), CB_GETCURSEL, 0, 0);
				JoyDlgCtlSet();
			}
			break;

		case IDC_JOYENABLE_CHECK:
			if(HIWORD(wParam) == BN_CLICKED) {
				Settings_JoystickConnected_cpy[ComboNo] = (bool8)IsDlgButtonChecked(hWnd, (int)LOWORD(wParam)) == BST_CHECKED;
				ConfigDlgSettingsChanged(hWnd);
			}
			break;
			
		case IDC_INPUTCOMBO:
			if(HIWORD(wParam) == CBN_SELENDOK) {
				if(SendMessage(GetDlgItem(hWnd, IDC_INPUTCOMBO), CB_GETCURSEL, 0, 0) == 1) {
					GUI_DIuse_cpy = TRUE;
					if(GUI_DIuse_cpy != GUI.DIuse) {
						MessageBox(hWnd,
								   GUI.Language ?
								   "ݒKpDirectInputL[{^RtBOo悤ɂȂ܂B" :
								   "Apply this setting, then \"DirectInput KeyButton Config\" will be enabled.",
								   "uosnes - Input Config",
								   MB_OK | MB_ICONINFORMATION);
						ConfigDlgSettingsChanged(hWnd);
					}
				}
				else if(SendMessage(GetDlgItem(hWnd, IDC_INPUTCOMBO), CB_GETCURSEL, 0, 0) == 0) {
					GUI_DIuse_cpy = FALSE;
					if(GUI_DIuse_cpy != GUI.DIuse) {
						MessageBox(hWnd,
								   GUI.Language ? "ݒKpWindowsAPIL[{^RtBOo悤ɂȂ܂B" :
								   "Apply this setting, then \"WindowsAPI KeyButton Config\" will be enabled.",
								   "uosnes - Input Config",
								   MB_OK | MB_ICONINFORMATION);
						ConfigDlgSettingsChanged(hWnd);
					}
				}
			}
			break;

		case IDC_FUNCTIONCODECOMBO0:
		case IDC_FUNCTIONCODECOMBO1:
		case IDC_FUNCTIONCODECOMBO2:
		case IDC_FUNCTIONCODECOMBO3:
		case IDC_FUNCTIONCODECOMBO4:
		case IDC_FUNCTIONCODECOMBO5:
		case IDC_FUNCTIONCODECOMBO6:
		case IDC_FUNCTIONCODECOMBO7:
			if(HIWORD(wParam) == CBN_SELENDOK) {
				int i = LOWORD(wParam) - IDC_FUNCTIONCODECOMBO0;
				
				FunctionCode_cpy[i] = (SendMessage(GetDlgItem(hWnd, (int)LOWORD(wParam)),
												   CB_GETCURSEL, 0, 0) << 16) + LOWORD(FunctionCode_cpy[i]);
					
				if(FunctionCode_cpy[i] != (GUI.DIuse ? FunctionCodeB[i] : FunctionCodeA[i]))
					ConfigDlgSettingsChanged(hWnd);
			}
			break;
			
			//Check Turbo
		case IDC_CHECK_TURBO_LEFT:
		case IDC_CHECK_TURBO_RIGHT:
		case IDC_CHECK_TURBO_UP:
		case IDC_CHECK_TURBO_DOWN:
		case IDC_CHECK_TURBO_START:
		case IDC_CHECK_TURBO_SELECT:
		case IDC_CHECK_TURBO_A:
		case IDC_CHECK_TURBO_B:
		case IDC_CHECK_TURBO_X:
		case IDC_CHECK_TURBO_Y:
		case IDC_CHECK_TURBO_L:
		case IDC_CHECK_TURBO_R:
			if(HIWORD(wParam) == BN_CLICKED) {
				switch(LOWORD(wParam)) {
				case IDC_CHECK_TURBO_LEFT:
					Joypad_cpy[ComboNo].Turbo_Left = IsDlgButtonChecked(hWnd, (int)LOWORD(wParam)) == BST_CHECKED;
					break;

				case IDC_CHECK_TURBO_RIGHT:
					Joypad_cpy[ComboNo].Turbo_Right = IsDlgButtonChecked(hWnd, (int)LOWORD(wParam)) == BST_CHECKED;
					break;

				case IDC_CHECK_TURBO_UP:
					Joypad_cpy[ComboNo].Turbo_Up = IsDlgButtonChecked(hWnd, (int)LOWORD(wParam)) == BST_CHECKED;
					break;

				case IDC_CHECK_TURBO_DOWN:
					Joypad_cpy[ComboNo].Turbo_Down = IsDlgButtonChecked(hWnd, (int)LOWORD(wParam)) == BST_CHECKED;
					break;

				case IDC_CHECK_TURBO_START:
					Joypad_cpy[ComboNo].Turbo_Start = IsDlgButtonChecked(hWnd, (int)LOWORD(wParam)) == BST_CHECKED;
					break;

				case IDC_CHECK_TURBO_SELECT:
					Joypad_cpy[ComboNo].Turbo_Select = IsDlgButtonChecked(hWnd, (int)LOWORD(wParam)) == BST_CHECKED;
					break;

				case IDC_CHECK_TURBO_A:
					Joypad_cpy[ComboNo].Turbo_A = IsDlgButtonChecked(hWnd, (int)LOWORD(wParam)) == BST_CHECKED;
					break;

				case IDC_CHECK_TURBO_B:
					Joypad_cpy[ComboNo].Turbo_B = IsDlgButtonChecked(hWnd, (int)LOWORD(wParam)) == BST_CHECKED;
					break;

				case IDC_CHECK_TURBO_X:
					Joypad_cpy[ComboNo].Turbo_X = IsDlgButtonChecked(hWnd, (int)LOWORD(wParam)) == BST_CHECKED;
					break;

				case IDC_CHECK_TURBO_Y:
					Joypad_cpy[ComboNo].Turbo_Y = IsDlgButtonChecked(hWnd, (int)LOWORD(wParam)) == BST_CHECKED;
					break;

				case IDC_CHECK_TURBO_L:
					Joypad_cpy[ComboNo].Turbo_L = IsDlgButtonChecked(hWnd, (int)LOWORD(wParam)) == BST_CHECKED;
					break;

				case IDC_CHECK_TURBO_R:
					Joypad_cpy[ComboNo].Turbo_R = IsDlgButtonChecked(hWnd, (int)LOWORD(wParam)) == BST_CHECKED;
					break;

				default:
					break;
				}
				ConfigDlgSettingsChanged(hWnd);
			}
			break;

		default:
			break;
		}
		break;

	case WM_NOTIFY:
		switch(((NMHDR *)lParam)->code) {
		case PSN_APPLY:
			ConfigDlgSettingsSave();
			break;

		case PSN_HELP:
			ConfigDlgDefaultSettingsLoad(hWnd);
			break;

		case PSN_QUERYCANCEL:
			ReleaseSubClass(hWnd);
			break;

		case PSN_SETACTIVE:
			StartPageIndex = 2;
			JoyStatusReading = false;

			//create color brush
			if(!SelectedEditBkRed)
				SelectedEditBkRed = CreateSolidBrush(RGB(0xff, 0x00, 0x00));
			if(!SelectedEditBkGreen)
				SelectedEditBkGreen = CreateSolidBrush(RGB(0x00, 0xff, 0x00));
			if(!SelectedEditBkBlue)
				SelectedEditBkBlue = CreateSolidBrush(RGB(0x00, 0x00, 0xff));
			if(!SelectedEditBkYello)
				SelectedEditBkYello = CreateSolidBrush(RGB(0xff, 0xff, 0x00));
			if(!SelectedEditBkGray)
				SelectedEditBkGray = CreateSolidBrush(RGB(0x66, 0x66, 0x66));
			if(!SelectedEditBkLightGray)
				SelectedEditBkLightGray = CreateSolidBrush(RGB(0x99, 0x99, 0x99));
			if(!SelectedEditBkOrange)
				SelectedEditBkOrange = CreateSolidBrush(RGB(0xff, 0xa5, 0x00));

			//set timer for reading joystatus
			if(!JoyDlgTimerActive && SetTimer(hWnd, 100, 50, NULL))
				JoyDlgTimerActive = true;

			//subclass control window
			SetSubClass();
			break;
				
		case PSN_KILLACTIVE:
			ReleaseSubClass(hWnd);
			break;

		default:
			break;
		}
		break;

	case WM_TIMER:
		if(JoyStatusReading)
			break;
		{
			WORD jb;
			JoyStatusReading = true;
			if((jb = GetJoyButtonCode()) || (jb = GetKeyButtonCode()))
				SetJoyButtonCode(GetFocus(), jb);
			JoyStatusReading = false;
		}
		break;

	default:
		break;
	}
	return FALSE;
}

static void SetJoyButtonText(HWND hWnd, WORD KeyCode)
{
	char strbuf[256];
	GetJoyKeybuttonString(KeyCode, strbuf, 256);
	SetWindowText(hWnd, strbuf);
}

static void SetJoyButtonCode(HWND hFocus, WORD KeyCode)
{
	if(GUI.DIuse) {
		// Check for windows keys
		if(KeyCode == DIK_CAPITAL || KeyCode == DIK_LWIN ||
		   KeyCode == DIK_RWIN    || KeyCode == DIK_APPS ||
		   KeyCode == DIK_LMENU   || KeyCode == DIK_RMENU ||

		   // Check for uosnes keys
		   (KeyCode >= DIK_F1       && KeyCode <= DIK_F9) ||
		   (KeyCode >= DIK_1        && KeyCode <= DIK_0) ||
		    KeyCode == DIK_F11      || KeyCode == DIK_F12 ||
		    KeyCode == DIK_ESCAPE   || KeyCode == DIK_LCONTROL ||
		    KeyCode == DIK_RCONTROL || KeyCode == DIK_LSHIFT ||
		    KeyCode == DIK_RSHIFT   || KeyCode == DIK_TAB ||
		    KeyCode == DIK_BACK     || KeyCode == DIK_PAUSE) {
			return;
		}
	}
	else {
		// Check for windows keys
		if(KeyCode == VK_MENU  || KeyCode == VK_LMENU ||
		   KeyCode == VK_RMENU || KeyCode == VK_CAPITAL ||
		   KeyCode == VK_LWIN  || KeyCode == VK_RWIN ||
		   KeyCode == VK_APPS  ||

		   // Check for uosnes keys
		   (KeyCode >= VK_F1       && KeyCode <= VK_F9) ||
		   (KeyCode >= '0'         && KeyCode <= '9') ||
		    KeyCode == VK_F11      || KeyCode == VK_F12 ||
		    KeyCode == VK_ESCAPE   || KeyCode == VK_CONTROL ||
		    KeyCode == VK_LCONTROL || KeyCode == VK_RCONTROL ||
		    KeyCode == VK_SHIFT    || KeyCode == VK_LSHIFT ||
		    KeyCode == VK_RSHIFT   || KeyCode == VK_TAB ||
		    KeyCode == VK_BACK     || KeyCode == VK_PAUSE) {
			return;
		}
	}

	WORD *jbp = NULL;
	HWND hFocus_next = 0;

	if(hEdit_Up == hFocus) {
		jbp = &Joypad_cpy[ComboNo].Up;
		hFocus_next = hEdit_Down;
	}
	else if(hEdit_Down == hFocus) {
		jbp = &Joypad_cpy[ComboNo].Down;
		hFocus_next = hEdit_Left;
	}
	else if(hEdit_Left == hFocus) {
		jbp = &Joypad_cpy[ComboNo].Left;
		hFocus_next = hEdit_Right;
	}
	else if(hEdit_Right == hFocus) {
		jbp = &Joypad_cpy[ComboNo].Right;
		hFocus_next = hEdit_A;
	}
	else if(hEdit_A == hFocus) {
		jbp = &Joypad_cpy[ComboNo].A;
		hFocus_next = hEdit_B;
	}
	else if(hEdit_B == hFocus) {
		jbp = &Joypad_cpy[ComboNo].B;
		hFocus_next = hEdit_X;
	}
	else if(hEdit_X == hFocus) {
		jbp = &Joypad_cpy[ComboNo].X;
		hFocus_next = hEdit_Y;
	}
	else if(hEdit_Y == hFocus) {
		jbp = &Joypad_cpy[ComboNo].Y;
		hFocus_next = hEdit_Select;
	}
	else if(hEdit_Select == hFocus) {
		jbp = &Joypad_cpy[ComboNo].Select;
		hFocus_next = hEdit_Start;
	}
	else if(hEdit_Start == hFocus) {
		jbp = &Joypad_cpy[ComboNo].Start;
		hFocus_next = hEdit_L;
	}
	else if(hEdit_L == hFocus) {
		jbp = &Joypad_cpy[ComboNo].L;
		hFocus_next = hEdit_R;
	}
	else if(hEdit_R == hFocus) {
		jbp = &Joypad_cpy[ComboNo].R;
		hFocus_next = GetDlgItem(hProp, ID_APPLY_NOW);
	}
	else if(hEdit_FunctionCode0 == hFocus) {
		jbp = (WORD *)&FunctionCode_cpy[0];
		hFocus_next = hEdit_FunctionCode1;
	}
	else if(hEdit_FunctionCode1 == hFocus) {
		jbp = (WORD *)&FunctionCode_cpy[1];
		hFocus_next = hEdit_FunctionCode2;
	}
	else if(hEdit_FunctionCode2 == hFocus) {
		jbp = (WORD *)&FunctionCode_cpy[2];
		hFocus_next = hEdit_FunctionCode3;
	}
	else if(hEdit_FunctionCode3 == hFocus) {
		jbp = (WORD *)&FunctionCode_cpy[3];
		hFocus_next = hEdit_FunctionCode4;
	}
	else if(hEdit_FunctionCode4 == hFocus) {
		jbp = (WORD *)&FunctionCode_cpy[4];
		hFocus_next = hEdit_FunctionCode5;
	}
	else if(hEdit_FunctionCode5 == hFocus) {
		jbp = (WORD *)&FunctionCode_cpy[5];
		hFocus_next = hEdit_FunctionCode6;
	}
	else if(hEdit_FunctionCode6 == hFocus) {
		jbp = (WORD *)&FunctionCode_cpy[6];
		hFocus_next = hEdit_FunctionCode7;
	}
	else if(hEdit_FunctionCode7 == hFocus) {
		jbp = (WORD *)&FunctionCode_cpy[7];
		hFocus_next = GetDlgItem(hProp, ID_APPLY_NOW);
	}
	else
		return;

	// Check di delete key
	if(GUI.DIuse && KeyCode == DIK_DELETE) {
		KeyCode = 0;
	}
	// Check mm delete key
	else if(!GUI.DIuse && KeyCode == VK_DELETE){
		KeyCode = 0;
	}

	// check duplicate and setting
	int J;
	HWND hEdit_duplicate = 0;
	BOOL found_duplicate = false;
	if(!found_duplicate && KeyCode) {
		for(J = 0; J < 5; J++) {
			if(KeyCode == Joypad_cpy[J].Left) {
				Joypad_cpy[J].Left = *jbp;
				hEdit_duplicate = (J == ComboNo ? hEdit_Left : 0);
				found_duplicate = true;
				break;
			}
			if(KeyCode == Joypad_cpy[J].Right) {
				Joypad_cpy[J].Right = *jbp;
				hEdit_duplicate = (J == ComboNo ? hEdit_Right : 0);
				found_duplicate = true;
				break;
			}
			if(KeyCode == Joypad_cpy[J].Up) {
				Joypad_cpy[J].Up = *jbp;
				hEdit_duplicate = (J == ComboNo ? hEdit_Up : 0);
				found_duplicate = true;
				break;
			}
			if(KeyCode == Joypad_cpy[J].Down) {
				Joypad_cpy[J].Down = *jbp;
				hEdit_duplicate = (J == ComboNo ? hEdit_Down : 0);
				found_duplicate = true;
				break;
			}
			if(KeyCode == Joypad_cpy[J].Select) {
				Joypad_cpy[J].Select = *jbp;
				hEdit_duplicate = (J == ComboNo ? hEdit_Select : 0);
				found_duplicate = true;
				break;
			}
			if(KeyCode == Joypad_cpy[J].Start) {
				Joypad_cpy[J].Start = *jbp;
				hEdit_duplicate = (J == ComboNo ? hEdit_Start : 0);
				found_duplicate = true;
				break;
			}
			if(KeyCode == Joypad_cpy[J].A) {
				Joypad_cpy[J].A = *jbp;
				hEdit_duplicate = (J == ComboNo ? hEdit_A : 0);
				found_duplicate = true;
				break;
			}
			if(KeyCode == Joypad_cpy[J].B) {
				Joypad_cpy[J].B = *jbp;
				hEdit_duplicate = (J == ComboNo ? hEdit_B : 0);
				found_duplicate = true;
				break;
			}
			if(KeyCode == Joypad_cpy[J].X) {
				Joypad_cpy[J].X = *jbp;
				hEdit_duplicate = (J == ComboNo ? hEdit_X : 0);
				found_duplicate = true;
				break;
			}
			if(KeyCode == Joypad_cpy[J].Y) {
				Joypad_cpy[J].Y = *jbp;
				hEdit_duplicate = (J == ComboNo ? hEdit_Y : 0);
				found_duplicate = true;
				break;
			}
			if(KeyCode == Joypad_cpy[J].L) {
				Joypad_cpy[J].L = *jbp;
				hEdit_duplicate = (J == ComboNo ? hEdit_L : 0);
				found_duplicate = true;
				break;
			}
			if(KeyCode == Joypad_cpy[J].R) {
				Joypad_cpy[J].R = *jbp;
				hEdit_duplicate = (J == ComboNo ? hEdit_R : 0);
				found_duplicate = true;
				break;
			}
		}
	}

	if(!found_duplicate && KeyCode) {
		if(KeyCode == LOWORD(FunctionCode_cpy[0])) {
			FunctionCode_cpy[0] =  (FunctionCode_cpy[0] & 0xffff0000) | *jbp;
			hEdit_duplicate = hEdit_FunctionCode0;
			found_duplicate = true;
		}
		else if(KeyCode == LOWORD(FunctionCode_cpy[1])) {
			FunctionCode_cpy[1] =  (FunctionCode_cpy[1] & 0xffff0000) | *jbp;
			hEdit_duplicate = hEdit_FunctionCode1;
			found_duplicate = true;
		}
		else if(KeyCode == LOWORD(FunctionCode_cpy[2])) {
			FunctionCode_cpy[2] =  (FunctionCode_cpy[2] & 0xffff0000) | *jbp;
			hEdit_duplicate = hEdit_FunctionCode2;
			found_duplicate = true;
		}
		else if(KeyCode == LOWORD(FunctionCode_cpy[3])) {
			FunctionCode_cpy[3] =  (FunctionCode_cpy[3] & 0xffff0000) | *jbp;
			hEdit_duplicate = hEdit_FunctionCode3;
			found_duplicate = true;
		}
		else if(KeyCode == LOWORD(FunctionCode_cpy[4])) {
			FunctionCode_cpy[4] =  (FunctionCode_cpy[4] & 0xffff0000) | *jbp;
			hEdit_duplicate = hEdit_FunctionCode4;
			found_duplicate = true;
		}
		else if(KeyCode == LOWORD(FunctionCode_cpy[5])) {
			FunctionCode_cpy[5] =  (FunctionCode_cpy[5] & 0xffff0000) | *jbp;
			hEdit_duplicate = hEdit_FunctionCode5;
			found_duplicate = true;
		}
		else if(KeyCode == LOWORD(FunctionCode_cpy[6])) {
			FunctionCode_cpy[6] =  (FunctionCode_cpy[6] & 0xffff0000) | *jbp;
			hEdit_duplicate = hEdit_FunctionCode6;
			found_duplicate = true;
		}
		else if(KeyCode == LOWORD(FunctionCode_cpy[7])) {
			FunctionCode_cpy[7] =  (FunctionCode_cpy[7] & 0xffff0000) | *jbp;
			hEdit_duplicate = hEdit_FunctionCode7;
			found_duplicate = true;
		}
	}

	if(hEdit_duplicate)
		SetJoyButtonText(hEdit_duplicate, *jbp);
	*jbp = KeyCode;
	SetJoyButtonText(hFocus, KeyCode);

	SetFocus(hFocus_next);
	ConfigDlgSettingsChanged(GetParent(hFocus));
}

bool IsButtonConfigFocused(HWND hFocus)
{
	if(hEdit_Up == hFocus            || hEdit_Down == hFocus ||
	   hEdit_Left == hFocus          || hEdit_Right == hFocus ||
	   hEdit_A == hFocus             || hEdit_B == hFocus ||
	   hEdit_X == hFocus             || hEdit_Y == hFocus ||
	   hEdit_Select == hFocus        || hEdit_Start == hFocus ||
	   hEdit_L == hFocus             || hEdit_R == hFocus ||
	   hEdit_FunctionCode0 == hFocus || hEdit_FunctionCode1 == hFocus ||
	   hEdit_FunctionCode2 == hFocus || hEdit_FunctionCode3 == hFocus ||
	   hEdit_FunctionCode4 == hFocus || hEdit_FunctionCode5 == hFocus ||
	   hEdit_FunctionCode6 == hFocus || hEdit_FunctionCode7 == hFocus) {
		return TRUE;
	}
	return FALSE;
}

static void JoyDlgCtlSet()
{
	if(!hJoypadDlg)
		return;

	SendMessage(GetDlgItem(hJoypadDlg, IDC_CTRLCOMBO), CB_SETCURSEL, (WPARAM)ComboNo, 0);
	SendMessage(GetDlgItem(hJoypadDlg, IDC_INPUTCOMBO), CB_SETCURSEL, (WPARAM)(GUI_DIuse_cpy ? 1 : 0), 0);

	SendMessage(GetDlgItem(hJoypadDlg, IDC_FUNCTIONCODECOMBO0), CB_SETCURSEL, (WPARAM)(HIWORD(FunctionCode_cpy[0])), 0);
	SendMessage(GetDlgItem(hJoypadDlg, IDC_FUNCTIONCODECOMBO1), CB_SETCURSEL, (WPARAM)(HIWORD(FunctionCode_cpy[1])), 0);
	SendMessage(GetDlgItem(hJoypadDlg, IDC_FUNCTIONCODECOMBO2), CB_SETCURSEL, (WPARAM)(HIWORD(FunctionCode_cpy[2])), 0);
	SendMessage(GetDlgItem(hJoypadDlg, IDC_FUNCTIONCODECOMBO3), CB_SETCURSEL, (WPARAM)(HIWORD(FunctionCode_cpy[3])), 0);
	SendMessage(GetDlgItem(hJoypadDlg, IDC_FUNCTIONCODECOMBO4), CB_SETCURSEL, (WPARAM)(HIWORD(FunctionCode_cpy[4])), 0);
	SendMessage(GetDlgItem(hJoypadDlg, IDC_FUNCTIONCODECOMBO5), CB_SETCURSEL, (WPARAM)(HIWORD(FunctionCode_cpy[5])), 0);
	SendMessage(GetDlgItem(hJoypadDlg, IDC_FUNCTIONCODECOMBO6), CB_SETCURSEL, (WPARAM)(HIWORD(FunctionCode_cpy[6])), 0);
	SendMessage(GetDlgItem(hJoypadDlg, IDC_FUNCTIONCODECOMBO7), CB_SETCURSEL, (WPARAM)(HIWORD(FunctionCode_cpy[7])), 0);

	//Set joystick connected check
	SendMessage(GetDlgItem(hJoypadDlg, IDC_JOYENABLE_CHECK), BM_SETCHECK, (WPARAM)(Settings_JoystickConnected_cpy[ComboNo] ? 1 : 0), 0);

	//Set Turbo check
	SendMessage(GetDlgItem(hJoypadDlg, IDC_CHECK_TURBO_LEFT), BM_SETCHECK, (WPARAM)(Joypad_cpy[ComboNo].Turbo_Left ? 1 : 0), 0);
	SendMessage(GetDlgItem(hJoypadDlg, IDC_CHECK_TURBO_RIGHT), BM_SETCHECK, (WPARAM)(Joypad_cpy[ComboNo].Turbo_Right ? 1 : 0), 0);
	SendMessage(GetDlgItem(hJoypadDlg, IDC_CHECK_TURBO_UP), BM_SETCHECK, (WPARAM)(Joypad_cpy[ComboNo].Turbo_Up ? 1 : 0), 0);
	SendMessage(GetDlgItem(hJoypadDlg, IDC_CHECK_TURBO_DOWN), BM_SETCHECK, (WPARAM)(Joypad_cpy[ComboNo].Turbo_Down ? 1 : 0), 0);
	SendMessage(GetDlgItem(hJoypadDlg, IDC_CHECK_TURBO_START), BM_SETCHECK, (WPARAM)(Joypad_cpy[ComboNo].Turbo_Start ? 1 : 0), 0);
	SendMessage(GetDlgItem(hJoypadDlg, IDC_CHECK_TURBO_SELECT), BM_SETCHECK, (WPARAM)(Joypad_cpy[ComboNo].Turbo_Select ? 1 : 0), 0);
	SendMessage(GetDlgItem(hJoypadDlg, IDC_CHECK_TURBO_A), BM_SETCHECK, (WPARAM)(Joypad_cpy[ComboNo].Turbo_A ? 1 : 0), 0);
	SendMessage(GetDlgItem(hJoypadDlg, IDC_CHECK_TURBO_B), BM_SETCHECK, (WPARAM)(Joypad_cpy[ComboNo].Turbo_B ? 1 : 0), 0);
	SendMessage(GetDlgItem(hJoypadDlg, IDC_CHECK_TURBO_X), BM_SETCHECK, (WPARAM)(Joypad_cpy[ComboNo].Turbo_X ? 1 : 0), 0);
	SendMessage(GetDlgItem(hJoypadDlg, IDC_CHECK_TURBO_Y), BM_SETCHECK, (WPARAM)(Joypad_cpy[ComboNo].Turbo_Y ? 1 : 0), 0);
	SendMessage(GetDlgItem(hJoypadDlg, IDC_CHECK_TURBO_L), BM_SETCHECK, (WPARAM)(Joypad_cpy[ComboNo].Turbo_L ? 1 : 0), 0);
	SendMessage(GetDlgItem(hJoypadDlg, IDC_CHECK_TURBO_R), BM_SETCHECK, (WPARAM)(Joypad_cpy[ComboNo].Turbo_R ? 1 : 0), 0);

	//Display key button text
	SetJoyButtonText(hEdit_Left, Joypad_cpy[ComboNo].Left);
	SetJoyButtonText(hEdit_Right, Joypad_cpy[ComboNo].Right);
	SetJoyButtonText(hEdit_Up, Joypad_cpy[ComboNo].Up);
	SetJoyButtonText(hEdit_Down, Joypad_cpy[ComboNo].Down);
	SetJoyButtonText(hEdit_Start, Joypad_cpy[ComboNo].Start);
	SetJoyButtonText(hEdit_Select, Joypad_cpy[ComboNo].Select);
	SetJoyButtonText(hEdit_A, Joypad_cpy[ComboNo].A);
	SetJoyButtonText(hEdit_B, Joypad_cpy[ComboNo].B);
	SetJoyButtonText(hEdit_X, Joypad_cpy[ComboNo].X);
	SetJoyButtonText(hEdit_Y, Joypad_cpy[ComboNo].Y);
	SetJoyButtonText(hEdit_L, Joypad_cpy[ComboNo].L);
	SetJoyButtonText(hEdit_R, Joypad_cpy[ComboNo].R);

	SetJoyButtonText(hEdit_FunctionCode0, LOWORD(FunctionCode_cpy[0]));
	SetJoyButtonText(hEdit_FunctionCode1, LOWORD(FunctionCode_cpy[1]));
	SetJoyButtonText(hEdit_FunctionCode2, LOWORD(FunctionCode_cpy[2]));
	SetJoyButtonText(hEdit_FunctionCode3, LOWORD(FunctionCode_cpy[3]));
	SetJoyButtonText(hEdit_FunctionCode4, LOWORD(FunctionCode_cpy[4]));
	SetJoyButtonText(hEdit_FunctionCode5, LOWORD(FunctionCode_cpy[5]));
	SetJoyButtonText(hEdit_FunctionCode6, LOWORD(FunctionCode_cpy[6]));
	SetJoyButtonText(hEdit_FunctionCode7, LOWORD(FunctionCode_cpy[7]));
}

static void SetSubClass()
{
	SetWindowLong(hProp, GWL_WNDPROC, (LONG)SubPropProc);
}

static void ReleaseSubClass(HWND hWnd)
{
	if(JoyDlgTimerActive) {
		KillTimer(hWnd, 100);
		JoyDlgTimerActive = false;
	}

	if(SelectedEditBkRed) {
		DeleteObject(SelectedEditBkRed);
		SelectedEditBkRed = 0;
	}
	if(SelectedEditBkGreen) {
		DeleteObject(SelectedEditBkGreen);
		SelectedEditBkGreen = 0;
	}
	if(SelectedEditBkBlue) {
		DeleteObject(SelectedEditBkBlue);
		SelectedEditBkBlue = 0;
	}
	if(SelectedEditBkYello) {
		DeleteObject(SelectedEditBkYello);
		SelectedEditBkYello = 0;
	}
	if(SelectedEditBkGray) {
		DeleteObject(SelectedEditBkGray);
		SelectedEditBkGray = 0;
	}
	if(SelectedEditBkLightGray) {
		DeleteObject(SelectedEditBkLightGray);
		SelectedEditBkLightGray = 0;
	}
	if(SelectedEditBkOrange) {
		DeleteObject(SelectedEditBkOrange);
		SelectedEditBkOrange = 0;
	}

	SetWindowLong(hProp, GWL_WNDPROC, (LONG)PropProc);
}

