#include "memmap.h"
#include "uosnesw.h"
#include <commdlg.h>
#include <shlobj.h>
#include "cfgdlg.h"
#include "winutil.h"
#include "commutil.h"

extern char ROMFileName[];
extern char InitialROMFileDirectory[];

extern "C" const char *S9xBasename (const char *f);
LRESULT CALLBACK BrowseHook(HWND hWnd, UINT uMsg,WPARAM wParam, LPARAM lParam);
static BOOL DirectoryDlgOpenFile(HWND hWnd, char *FileName,
								 char *FileTitle, char *InitialFileDirectory,
								 LPCSTR filterstring, LPCSTR defext, LPCSTR title);

static char InitialROMFileDirectory_cpy[_MAX_PATH];
static char GUI_FreezeFileDir_cpy[_MAX_PATH];
static char Memory_ScreenShotDirectory_cpy[_MAX_PATH];
static char Memory_SPCDumpDirectory_cpy[_MAX_PATH];
static char Memory_BSXBIOSROMFileName_cpy[_MAX_PATH];
static char Memory_SFTBIOSROMFileName_cpy[_MAX_PATH];
static char InitialBIOSFileDirectory[_MAX_PATH];
static char BIOSFileTitle[_MAX_PATH];

void DirectorySettingsLoad()
{
	char drive [_MAX_DRIVE + 1];
	char dir [_MAX_DIR + 1];
	char fname [_MAX_FNAME + 1];
	char ext [_MAX_EXT + 1];

	lstrcpy(InitialROMFileDirectory_cpy, InitialROMFileDirectory);
	lstrcpy(GUI_FreezeFileDir_cpy, GUI.FreezeFileDir);
	lstrcpy(Memory_ScreenShotDirectory_cpy, Memory.ScreenShotDirectory);
	lstrcpy(Memory_SPCDumpDirectory_cpy, Memory.SPCDumpDirectory);
	lstrcpy(Memory_BSXBIOSROMFileName_cpy, Memory.BSXBIOSROMFileName);
	lstrcpy(Memory_SFTBIOSROMFileName_cpy, Memory.SFTBIOSROMFileName);

	lstrcpy(InitialBIOSFileDirectory, Memory_BSXBIOSROMFileName_cpy);
	_splitpath (InitialBIOSFileDirectory, drive, dir, fname, ext);
	_makepath(InitialBIOSFileDirectory, drive, dir, NULL, NULL);

	lstrcpy(BIOSFileTitle, S9xBasename((const char *)Memory_BSXBIOSROMFileName_cpy));
}

void DirectorySettingsSave()
{
	char drive [_MAX_DRIVE + 1];
	char dir [_MAX_DIR + 1];
	char fname [_MAX_FNAME + 1];
	char ext [_MAX_EXT + 1];

	if(lstrcmp(InitialROMFileDirectory, InitialROMFileDirectory_cpy) &&
	   lstrlen(InitialROMFileDirectory_cpy) <= (_MAX_PATH - 7)) {
		lstrcpy(InitialROMFileDirectory, InitialROMFileDirectory_cpy);
		lstrcpy(ROMFileName, InitialROMFileDirectory_cpy);
		_splitpath (ROMFileName, drive, dir, fname, ext);
		_makepath(ROMFileName, drive, dir, "a", ".smc");
	}
	lstrcpy(GUI.FreezeFileDir, GUI_FreezeFileDir_cpy);
	lstrcpy(Memory.ScreenShotDirectory, Memory_ScreenShotDirectory_cpy);
	lstrcpy(Memory.SPCDumpDirectory, Memory_SPCDumpDirectory_cpy);
	lstrcpy(Memory.BSXBIOSROMFileName, Memory_BSXBIOSROMFileName_cpy);
	lstrcpy(Memory.SFTBIOSROMFileName, Memory_SFTBIOSROMFileName_cpy);
}

LRESULT CALLBACK DirectoryDlgProc(HWND hWnd, UINT uMsg,WPARAM wParam, LPARAM lParam)
{
	switch (uMsg) {
	case WM_INITDIALOG:
		{
			char filename [_MAX_PATH + 1];
			char drive [_MAX_DRIVE + 1];
			char dir [_MAX_DIR + 1];
			char fname [_MAX_FNAME + 1];
			char ext [_MAX_EXT + 1];

			lstrcpy(filename, InitialROMFileDirectory_cpy);
			_splitpath(filename, drive, dir, fname, ext);
			_makepath (filename, drive, dir, fname, ext);
			SetWindowText(GetDlgItem(hWnd, IDC_DIR_ROM), filename);

			lstrcpy(filename, GUI_FreezeFileDir_cpy);
			_splitpath(filename, drive, dir, fname, ext);
			if(dir[0] == 0)
				_makepath (filename, drive, "\\", NULL, NULL);
			else
				_makepath (filename, drive, dir, fname, ext);
			SetWindowText(GetDlgItem(hWnd, IDC_DIR_SAVE), filename);

			lstrcpy(filename, Memory_ScreenShotDirectory_cpy);
			_splitpath(filename, drive, dir, fname, ext);
			if(dir[0] == 0)
				_makepath (filename, drive, "\\", NULL, NULL);
			else
				_makepath (filename, drive, dir, fname, ext);
			SetWindowText(GetDlgItem(hWnd, IDC_DIR_SCREEN), filename);

			lstrcpy(filename, Memory_SPCDumpDirectory_cpy);
			_splitpath(filename, drive, dir, fname, ext);
			if(dir[0] == 0)
				_makepath (filename, drive, "\\", NULL, NULL);
			else
				_makepath (filename, drive, dir, fname, ext);
			SetWindowText(GetDlgItem(hWnd, IDC_DIR_SPC), filename);

			SetWindowText(GetDlgItem(hWnd, IDC_DIR_BSXBIOS), Memory_BSXBIOSROMFileName_cpy);
			SetWindowText(GetDlgItem(hWnd, IDC_DIR_SFTBIOS), Memory_SFTBIOSROMFileName_cpy);
		}
		break;

	case WM_COMMAND:
		switch (LOWORD(wParam)) {
		case IDC_DIR_ROM:
		case IDC_DIR_SAVE:
		case IDC_DIR_SCREEN:
		case IDC_DIR_SPC:
		case IDC_DIR_BSXBIOS:
		case IDC_DIR_SFTBIOS:
			if(HIWORD(wParam) == EN_CHANGE) {
				ConfigDlgSettingsChanged(hWnd);
			}
			break;

		case IDC_BUTTON_DIR_ROM:
		case IDC_BUTTON_DIR_SAVE:
		case IDC_BUTTON_DIR_SCREEN:
		case IDC_BUTTON_DIR_SPC:
			{
				char BrowseDir[_MAX_PATH + 1];
				char InitialBrowseDir[_MAX_PATH + 1];
				char drive [_MAX_DRIVE + 1];
				char dir [_MAX_DIR + 1];
				char fname [_MAX_FNAME + 1];
				char ext [_MAX_EXT + 1];
				int idctrl = IDC_DIR_ROM;
				BROWSEINFO bi;
				FillMemory(&bi, sizeof(BROWSEINFO), 0x00);

				switch(LOWORD(wParam))
					{
					case IDC_BUTTON_DIR_ROM:
						bi.lpszTitle = (GUI.Language ? "ǂݍ݃tH_I" : "Select ROM Folder");
						idctrl = IDC_DIR_ROM;
						lstrcpy(InitialBrowseDir, InitialROMFileDirectory_cpy);
						break;

					case IDC_BUTTON_DIR_SAVE:
						bi.lpszTitle = (GUI.Language ? "Z[ut@CۑtH_I" : "Select Save Folder");
						idctrl = IDC_DIR_SAVE;
						lstrcpy(InitialBrowseDir, GUI_FreezeFileDir_cpy);
						break;

					case IDC_BUTTON_DIR_SCREEN:
						bi.lpszTitle = (GUI.Language ? "XN[VbgۑtH_I" : "Select Screen shot Save Folder");
						idctrl = IDC_DIR_SCREEN;
						lstrcpy(InitialBrowseDir, Memory_ScreenShotDirectory_cpy);
						break;

					case IDC_BUTTON_DIR_SPC:
						bi.lpszTitle = (GUI.Language ? "SPCۑtH_I" : "Select SPC Save Folder");
						idctrl = IDC_DIR_SPC;
						lstrcpy(InitialBrowseDir, Memory_SPCDumpDirectory_cpy);
						break;
					}
				_splitpath(InitialBrowseDir, drive, dir, fname, ext);
				if(dir[0] == 0)
					_makepath (InitialBrowseDir, drive, "\\", NULL, NULL);
				else
					_makepath (InitialBrowseDir, drive, dir, fname, ext);
				bi.hwndOwner = hWnd;
				bi.ulFlags = BIF_RETURNONLYFSDIRS | BIF_DONTGOBELOWDOMAIN;
				LPITEMIDLIST lpiil;
				bi.lpfn = (BFFCALLBACK)BrowseHook;
				bi.lParam=(LPARAM)InitialBrowseDir;
						
				if((lpiil = SHBrowseForFolder(&bi)))
					{
						if(SHGetPathFromIDList(lpiil, BrowseDir) ) {
							SetWindowText(GetDlgItem(hWnd, idctrl), BrowseDir);
							//remove slash
							if(idctrl != IDC_DIR_ROM) {
								_splitpath(InitialBrowseDir, drive, dir, fname, ext);
								if(dir[0] && fname[0] == 0) {
									dir[lstrlen(dir) - 1] = 0;
								}
								_makepath (InitialBrowseDir, drive, dir, fname, ext);
							}
							if(idctrl == IDC_DIR_ROM)
								lstrcpy(InitialROMFileDirectory_cpy, BrowseDir);
							else if(idctrl == IDC_DIR_SAVE)
								lstrcpy(GUI_FreezeFileDir_cpy, BrowseDir);
							else if(idctrl == IDC_DIR_SCREEN)
								lstrcpy(Memory_ScreenShotDirectory_cpy, BrowseDir);
							else if(idctrl == IDC_DIR_SPC)
								lstrcpy(Memory_SPCDumpDirectory_cpy, BrowseDir);
						}
						CoTaskMemFree(lpiil );
					}
				break;
			}
			break;

		case IDC_BUTTON_DIR_BSXBIOS:
			if (DirectoryDlgOpenFile(hWnd, Memory_BSXBIOSROMFileName_cpy, BIOSFileTitle, InitialBIOSFileDirectory,
									 "SNES ROM File\0*.smc;*.sfc;*.swc;*.fig;*.078;*.058\0All files(*.*)\0*.*\0\0",
									 "smc", (GUI.Language ?
											 "Ter[ BS-X BIOSt@CI" : "Select Satellaview BS-X BIOS File"))) {

				char drive [_MAX_DRIVE + 1];
				char dir [_MAX_DIR + 1];
				char fname [_MAX_FNAME + 1];
				char ext [_MAX_EXT + 1];

				SetWindowText(GetDlgItem(hWnd, IDC_DIR_BSXBIOS), Memory_BSXBIOSROMFileName_cpy);
				lstrcpy(InitialBIOSFileDirectory, Memory_BSXBIOSROMFileName_cpy);
				_splitpath (InitialBIOSFileDirectory, drive, dir, fname, ext);
				_makepath(InitialBIOSFileDirectory, drive, dir, NULL, NULL);
				lstrcpy(BIOSFileTitle, S9xBasename((const char *)Memory_BSXBIOSROMFileName_cpy));
			}
			break;

		case IDC_BUTTON_DIR_SFTBIOS:
			if (DirectoryDlgOpenFile(hWnd, Memory_SFTBIOSROMFileName_cpy, BIOSFileTitle, InitialBIOSFileDirectory,
									 "SNES ROM File\0*.smc;*.sfc;*.swc;*.fig;*.078;*.058\0All files(*.*)\0*.*\0\0",
									 "smc", (GUI.Language ?
											 "X[t@~^[{ BIOSt@CI" : "Select Sufami Turbo BIOS File"))) {

				char drive [_MAX_DRIVE + 1];
				char dir [_MAX_DIR + 1];
				char fname [_MAX_FNAME + 1];
				char ext [_MAX_EXT + 1];

				SetWindowText(GetDlgItem(hWnd, IDC_DIR_SFTBIOS), Memory_SFTBIOSROMFileName_cpy);
				lstrcpy(InitialBIOSFileDirectory, Memory_SFTBIOSROMFileName_cpy);
				_splitpath (InitialBIOSFileDirectory, drive, dir, fname, ext);
				_makepath(InitialBIOSFileDirectory, drive, dir, NULL, NULL);
				lstrcpy(BIOSFileTitle, S9xBasename((const char *)Memory_SFTBIOSROMFileName_cpy));
			}
			break;

		default:
			break;
		}
		break;

	case WM_CTLCOLORSTATIC:
		if((HWND)lParam == GetDlgItem(hWnd, IDC_DIR_ROM) || (HWND)lParam == GetDlgItem(hWnd, IDC_DIR_SAVE)
		   || (HWND)lParam == GetDlgItem(hWnd, IDC_DIR_SCREEN) || (HWND)lParam == GetDlgItem(hWnd, IDC_DIR_SPC)
		   || (HWND)lParam == GetDlgItem(hWnd, IDC_DIR_BSXBIOS) || (HWND)lParam == GetDlgItem(hWnd, IDC_DIR_SFTBIOS))
			return (long)GetStockObject(WHITE_BRUSH);
		break;

	case WM_NOTIFY:
		switch(((NMHDR *)lParam)->code) {
		case PSN_APPLY:
			ConfigDlgSettingsSave();
			break;

		case PSN_HELP:
			ConfigDlgDefaultSettingsLoad(hWnd);
			break;

		case PSN_QUERYCANCEL:
			break;

		case PSN_SETACTIVE:
			StartPageIndex = 3;
			break;

		default:
			break;
		}
		break;

	default:
		break;
	}
	return FALSE;
}

static BOOL DirectoryDlgOpenFile(HWND hWnd, char *FileName, char *FileTitle,
								 char *InitialFileDirectory, LPCSTR filterstring,
								 LPCSTR defext, LPCSTR title)
{
	OPENFILENAME ofn;
	BOOL ret;
	
	FillMemory((PVOID)&ofn, sizeof(ofn), 0);
	ofn.lStructSize = sizeof(ofn);
	ofn.hwndOwner = hWnd;
	ofn.hInstance = (HINSTANCE)GetWindowLong(hWnd, GWL_HINSTANCE);
	ofn.lpstrFilter = filterstring;
	ofn.lpstrFile = FileName;
	ofn.nMaxFile = _MAX_PATH;
	ofn.Flags = OFN_FILEMUSTEXIST | OFN_HIDEREADONLY | OFN_NONETWORKBUTTON | OFN_EXPLORER;//OFN_ENABLEHOOK
	ofn.lpstrDefExt = defext;
	ofn.nMaxFileTitle = _MAX_PATH;
	ofn.lpstrFileTitle = FileTitle;
	ofn.lpstrTitle = title;
	ofn.lpstrInitialDir = InitialFileDirectory;
	
	ImeEnable(GUI.hWnd, TRUE);
	ret = GetOpenFileName(&ofn);
	ImeEnable(GUI.hWnd, FALSE);
	return ret;
}

LRESULT CALLBACK BrowseHook(HWND hWnd, UINT uMsg,WPARAM wParam, LPARAM lParam)
{
	//	static DWORD Style;
	switch (uMsg) {
	case BFFM_INITIALIZED:
		SendMessage(hWnd,BFFM_SETSELECTION,(WPARAM)TRUE,lParam);
#if 0
		Style = GetWindowLong(hWnd, GWL_EXSTYLE );
		Style &= ~(WS_EX_CONTEXTHELP);
		SetWindowLong(hWnd, GWL_EXSTYLE, Style);
#endif
		break;

	default:
		break;
	}
	return FALSE;
}

