#include "uosnesw.h"
#include "memmap.h"
#include "display.h"
#include "cheats.h"
//#include <richedit.h>

extern SCheatData Cheat;
static char tmpcharbuf[256];

static LRESULT CALLBACK SNESCheatDlgProc(HWND hWnd, UINT uMsg, WPARAM wParam, LPARAM lParam);
static LRESULT CALLBACK SNESCheatEnterEditSubProc(HWND hWnd, UINT uMsg, WPARAM wParam, LPARAM lParam);
static LRESULT CALLBACK SNESCheatListSubProc(HWND hWnd, UINT uMsg, WPARAM wParam, LPARAM lParam);
static void SetSNESCheatList();
static void InsertSNESCheatList(int listindex);

unsigned char DisplaySNESCheatCodeWindow()
{
	if(!GUI.hInstance || !GUI.hWnd)
		return FALSE;
//	HINSTANCE hRtLib = LoadLibrary("RICHED32.DLL");
//	if(!hRtLib)
//		return FALSE;

	DialogBox(GUI.hInstance, GUI.Language ? (MAKEINTRESOURCE(IDD_DIALOG_CHEATCODE_JP)) : (MAKEINTRESOURCE(IDD_DIALOG_CHEATCODE_US)), GUI.hWnd, (DLGPROC)SNESCheatDlgProc);

//	if(hRtLib)
//		FreeLibrary(hRtLib);
	return TRUE;
}

#define ID_SNESCHEATSTATUSWINDOW 102

//Work variables
static LV_COLUMN lvcol;
static LV_HITTESTINFO lvhti;

//control handle and proc
static HWND hSNESCheatList;
static WNDPROC SNESCheatList;
static HWND hEdit_SNESCheatEnter;
static WNDPROC Edit_SNESCheatEnter;
static HWND hSNESCheatStatusWnd;

static LRESULT CALLBACK SNESCheatDlgProc(HWND hWnd, UINT uMsg, WPARAM wParam, LPARAM lParam)
{
	static unsigned char MessageTimerActive = FALSE;
	switch (uMsg) {
		
		case WM_INITDIALOG:
			hEdit_SNESCheatEnter = GetDlgItem(hWnd, IDC_EDIT_SNESCHEATENTER);
			SetFocus(hEdit_SNESCheatEnter);
			if(!hSNESCheatStatusWnd) {
				hSNESCheatStatusWnd = CreateStatusWindow(
				WS_CHILD | WS_VISIBLE | CCS_BOTTOM,
				NULL,
				hWnd,
				ID_SNESCHEATSTATUSWINDOW
				);
				SendMessage(hSNESCheatStatusWnd, SB_SIMPLE, TRUE, 0);
			}
			hSNESCheatList = GetDlgItem(hWnd, IDC_LIST_SNESCHEAT);
			SNESCheatList = (WNDPROC)GetWindowLong(hSNESCheatList, GWL_WNDPROC);
			SetWindowLong(hSNESCheatList, GWL_WNDPROC, (LONG)SNESCheatListSubProc);

			lvcol.mask = LVCF_FMT | LVCF_WIDTH | LVCF_TEXT | LVCF_SUBITEM;
			lvcol.fmt = LVCFMT_LEFT;
			lvcol.cx = 60;
			lvcol.pszText = (LPTSTR)(GUI.Language ? "/" : "On/Off");
			lvcol.iSubItem = 0;
			ListView_InsertColumn(hSNESCheatList, 0, &lvcol);
			
			lvcol.cx = 65;
			lvcol.pszText = (LPTSTR)(GUI.Language ? "ڽ" : "Addr");
			lvcol.iSubItem = 1;
			ListView_InsertColumn(hSNESCheatList, 1, &lvcol);
			
			lvcol.cx = 90;
			lvcol.pszText = (LPTSTR)(GUI.Language ? "ݒ肷l" : "CV");
			lvcol.iSubItem = 2;
			ListView_InsertColumn(hSNESCheatList, 2, &lvcol);
			
			lvcol.cx = 90;
			lvcol.pszText = (LPTSTR)(GUI.Language ? "ݒO̒l" : "PV");
			lvcol.iSubItem = 3;
			ListView_InsertColumn(hSNESCheatList, 3, &lvcol);
			
			SetSNESCheatList();
			
			SendMessage(hEdit_SNESCheatEnter, EM_SETLIMITTEXT, 8, 0);
			Edit_SNESCheatEnter = (WNDPROC)GetWindowLong(hEdit_SNESCheatEnter, GWL_WNDPROC);
			SetWindowLong(hEdit_SNESCheatEnter, GWL_WNDPROC, (LONG)SNESCheatEnterEditSubProc);

			EnableWindow(GetDlgItem(hWnd, IDC_BUTTON_SNESCHEATADD), FALSE);
			EnableWindow(GetDlgItem(hWnd, IDC_BUTTON_SNESCHEATDELETE), FALSE);

			SendMessage(GetDlgItem(hWnd, IDC_CHECK_APLLYCHEATS), BM_SETCHECK, (WPARAM)(Settings.ApplyCheats ? 1 : 0), 0);
			break;
		
		case WM_COMMAND:
			switch (LOWORD(wParam)) {

				case IDC_CHECK_APLLYCHEATS:
					Settings.ApplyCheats = (bool8)(IsDlgButtonChecked(hWnd, (int)LOWORD(wParam)) == BST_CHECKED);
					if(Settings.ApplyCheats)
						S9xApplyCheats ();
					else
						S9xRemoveCheats ();
					break;

				case IDOK:
					if(GetFocus() == hEdit_SNESCheatEnter) {
						int len = GetWindowTextLength(hEdit_SNESCheatEnter);
						if(len == 8)
							PostMessage (hWnd, WM_COMMAND, IDC_BUTTON_SNESCHEATADD, 0);
					}
					break;

				case IDCANCEL:
					if(hSNESCheatStatusWnd) {
						DestroyWindow(hSNESCheatStatusWnd);
						hSNESCheatStatusWnd = NULL;
					}
					SetWindowLong(hEdit_SNESCheatEnter, GWL_WNDPROC, (LONG)Edit_SNESCheatEnter);
					SetWindowLong(hSNESCheatList, GWL_WNDPROC, (LONG)SNESCheatList);
					if(MessageTimerActive) {
						KillTimer(hWnd, 110);
						MessageTimerActive = FALSE;
					}
					EndDialog(hWnd, IDCANCEL);
					break;

				case IDC_EDIT_SNESCHEATENTER:
					if(HIWORD(wParam) == EN_CHANGE) {
						int len = GetWindowTextLength((HWND)lParam);
						if(len == 8)
							EnableWindow(GetDlgItem(hWnd, IDC_BUTTON_SNESCHEATADD), TRUE);
						else
							EnableWindow(GetDlgItem(hWnd, IDC_BUTTON_SNESCHEATADD), FALSE);
					}
					break;

				case IDC_BUTTON_SNESCHEATADD:
					{
						int len = GetWindowTextLength(hEdit_SNESCheatEnter);
						if(len == 8 && Cheat.num_cheats < MAX_CHEATS) {
							uint32 addr;
							uint8 byte;
							unsigned char cheatcodestr[9] = {0};
							uint32 cheatcode = 0;
							GetWindowText(hEdit_SNESCheatEnter, (LPTSTR)cheatcodestr, 9);
							for(int i = 0; i < 8; i++) {
								if(cheatcodestr[7 - i] >= 0x30 && cheatcodestr[7 - i] <= 0x39)
									cheatcode |= (cheatcodestr[7 - i] & 0x0f) << (i * 4);
								else if(cheatcodestr[7 - i] >= 0x41 && cheatcodestr[7 - i] <= 0x46)
									cheatcode |= (cheatcodestr[7 - i] - 55) << (i * 4);
								else if(cheatcodestr[7 - i] >= 0x61 && cheatcodestr[7 - i] <= 0x66)
									cheatcode |= (cheatcodestr[7 - i] - 87) << (i * 4);
							}
							addr = cheatcode >> 8;
							byte = (uint8)(cheatcode & 0xff);
							S9xAddCheat (TRUE, TRUE, addr, byte);
							InsertSNESCheatList((int)(Cheat.num_cheats - 1));
							ListView_SetItemState(hSNESCheatList, (int)(Cheat.num_cheats - 1), LVIS_FOCUSED, LVIS_FOCUSED);
							ListView_EnsureVisible(hSNESCheatList, (int)(Cheat.num_cheats - 1), FALSE);
						}
					}
					break;

				case IDC_BUTTON_SNESCHEATDELETE:
					{
						int lastdeleted = -1;
						int focused = -1;
						int itemcount = ListView_GetItemCount(hSNESCheatList);
						for(int i = 0; i < itemcount; i++) {
							if(ListView_GetItemState(hSNESCheatList, i, LVIS_SELECTED)) {
								if(ListView_GetItemState(hSNESCheatList, i, LVIS_FOCUSED))
									focused = i;
								S9xDeleteCheat((uint32)i);
								ListView_DeleteItem(hSNESCheatList, i);
								lastdeleted = i;
								i--;
								itemcount--;
							}
						}
						if(lastdeleted >= 0 && lastdeleted < itemcount) {
							ListView_SetItemState(hSNESCheatList, lastdeleted, LVIS_SELECTED, LVIS_SELECTED);
							if(focused != -1)
								ListView_SetItemState(hSNESCheatList, lastdeleted, LVIS_FOCUSED, LVIS_FOCUSED);
						}
						else if(lastdeleted >= 1 && lastdeleted == itemcount) {
							ListView_SetItemState(hSNESCheatList, (lastdeleted - 1), LVIS_SELECTED, LVIS_SELECTED);
							if(focused != -1)
								ListView_SetItemState(hSNESCheatList, (lastdeleted - 1), LVIS_FOCUSED, LVIS_FOCUSED);
						}
						if(ListView_GetItemCount(hSNESCheatList))
							SetFocus(hSNESCheatList);
						else
							SetFocus(hEdit_SNESCheatEnter);
					}
					break;

				default:
					break;
			}
			break;

		case WM_TIMER:
			if(MessageTimerActive) {
				KillTimer(hWnd, 110);
				MessageTimerActive = FALSE;
			}
			SendMessage(hSNESCheatStatusWnd, SB_SETTEXT, 255 | 0, (WPARAM)"");
			break;

		case WM_SIZE:
			if(hSNESCheatStatusWnd) {
				RECT clrect, strect;
				GetWindowRect(hSNESCheatStatusWnd, &strect);
				GetClientRect(hWnd, &clrect);
				MoveWindow(hSNESCheatStatusWnd, clrect.left, clrect.bottom - (strect.bottom - strect.top),
							LOWORD(lParam), (strect.bottom - strect.top), TRUE);
				InvalidateRgn(hSNESCheatStatusWnd, NULL, TRUE);
			}
			break;

		case WM_NOTIFY:
			if((int)wParam == IDC_LIST_SNESCHEAT) {
				switch (((LV_DISPINFO *)lParam)->hdr.code)
				{
					case LVN_ITEMCHANGED:
						if(ListView_GetSelectedCount(((LV_DISPINFO *)lParam)->hdr.hwndFrom))
							EnableWindow(GetDlgItem(hWnd, IDC_BUTTON_SNESCHEATDELETE), TRUE);
						else
							EnableWindow(GetDlgItem(hWnd, IDC_BUTTON_SNESCHEATDELETE), FALSE);
						break;
					
					case LVN_KEYDOWN:
						if((((LV_KEYDOWN *)lParam)->wVKey) == VK_DELETE) {
							PostMessage (hWnd, WM_COMMAND, IDC_BUTTON_SNESCHEATDELETE, 0);
						}
						break;

					case LVN_COLUMNCLICK:
						if((((NM_LISTVIEW *)lParam)->iSubItem) == 0) {
							LPTSTR onstr = (LPTSTR)(GUI.Language ? "" : "On");
							LPTSTR offstr = (LPTSTR)(GUI.Language ? "" : "Off");
							int itemcount = ListView_GetItemCount(hSNESCheatList);
							for(int i = 0; i < itemcount; i++) {
								if(ListView_GetItemState(hSNESCheatList, i, LVIS_SELECTED)) {
									if((uint32)i < Cheat.num_cheats && Cheat.c [i].enabled) {
										Cheat.c [i].enabled = FALSE;
									}
									else if ((uint32)i < Cheat.num_cheats && !Cheat.c [i].enabled){
										Cheat.c [i].enabled = TRUE;
									}
									ListView_SetItemText(hSNESCheatList, i, 0, (Cheat.c [i].enabled ? onstr : offstr));
								}
							}
						}
						break;

					case NM_DBLCLK:
						{
							GetCursorPos((LPPOINT)&lvhti.pt);
							ScreenToClient(((LV_DISPINFO *)lParam)->hdr.hwndFrom, &lvhti.pt);
							ListView_HitTest(((LV_DISPINFO *)lParam)->hdr.hwndFrom, &lvhti);
							if (lvhti.flags & LVHT_ONITEM) {
								LPTSTR onstr = (LPTSTR)(GUI.Language ? "" : "On");
								LPTSTR offstr = (LPTSTR)(GUI.Language ? "" : "Off");
								if((uint32)lvhti.iItem < Cheat.num_cheats && Cheat.c [lvhti.iItem].enabled) {
									Cheat.c [lvhti.iItem].enabled = FALSE;
								}
								else if ((uint32)lvhti.iItem < Cheat.num_cheats && !Cheat.c [lvhti.iItem].enabled){
									Cheat.c [lvhti.iItem].enabled = TRUE;
								}
								ListView_SetItemText(((LV_DISPINFO *)lParam)->hdr.hwndFrom, lvhti.iItem, 0, (Cheat.c [lvhti.iItem].enabled ? onstr : offstr));
							}
						}
						break;

					case NM_SETFOCUS:
						if(ListView_GetSelectedCount(((LV_DISPINFO *)lParam)->hdr.hwndFrom))
							EnableWindow(GetDlgItem(hWnd, IDC_BUTTON_SNESCHEATDELETE), TRUE);
						else
							EnableWindow(GetDlgItem(hWnd, IDC_BUTTON_SNESCHEATDELETE), FALSE);
						break;

					case NM_KILLFOCUS:
						if(ListView_GetSelectedCount(((LV_DISPINFO *)lParam)->hdr.hwndFrom) && GetFocus() == GetDlgItem(hWnd, IDC_BUTTON_SNESCHEATDELETE))
							EnableWindow(GetDlgItem(hWnd, IDC_BUTTON_SNESCHEATDELETE), TRUE);
						else
							EnableWindow(GetDlgItem(hWnd, IDC_BUTTON_SNESCHEATDELETE), FALSE);
						break;
					
					default:
						break;
				}
			}
			break;

		default:
			break;
	}
	return FALSE;
}

static LRESULT CALLBACK SNESCheatEnterEditSubProc(HWND hWnd, UINT uMsg, WPARAM wParam, LPARAM lParam)
{
	switch (uMsg) {
		case WM_CHAR:
			if((LOWORD(wParam) >= '0' && LOWORD(wParam) <= '9') || (LOWORD(wParam) >= 'a' && LOWORD(wParam) <= 'f')
				|| (LOWORD(wParam) >= 'A' && LOWORD(wParam) <= 'F') || LOWORD(wParam) == VK_BACK) {
				break;
			}
			return 0;

		default:
			break;

	}
	if(Edit_SNESCheatEnter)
		return (CallWindowProc(Edit_SNESCheatEnter, hWnd, uMsg, wParam, lParam));
	return 0;
}

static LRESULT CALLBACK SNESCheatListSubProc(HWND hWnd, UINT uMsg, WPARAM wParam, LPARAM lParam)
{
	switch (uMsg) {
		case WM_PAINT:
			break;

		default:
			break;

	}
	if(SNESCheatList)
		return CallWindowProc(SNESCheatList, hWnd, uMsg, wParam, lParam);
	return 0;
}

static void InsertSNESCheatList(int listindex)
{
	if(Cheat.num_cheats <= (uint32)listindex || listindex < 0)
		return;

	LV_ITEM item;

	FillMemory((PVOID)&item, sizeof(LV_ITEM), 0);

	LPTSTR onstr = (LPTSTR)(GUI.Language ? "" : "On");
	LPTSTR offstr = (LPTSTR)(GUI.Language ? "" : "Off");

	item.mask = LVIF_TEXT;
	item.pszText = Cheat.c [listindex].enabled ? onstr : offstr;
	item.iItem = listindex;
	item.iSubItem = 0;
	ListView_InsertItem(hSNESCheatList, &item);

	wsprintf(tmpcharbuf, "%06X", Cheat.c [listindex].address);
	item.pszText = tmpcharbuf;
	item.iSubItem = 1;
	ListView_SetItem(hSNESCheatList, &item);

	wsprintf(tmpcharbuf, "%02X", Cheat.c [listindex].byte);
	item.pszText = tmpcharbuf;
	item.iSubItem = 2;
	ListView_SetItem(hSNESCheatList, &item);

	if(Cheat.c [listindex].saved)
		wsprintf(tmpcharbuf, "%02X", Cheat.c [listindex].saved_byte);
	else
		wsprintf(tmpcharbuf, (GUI.Language ? "Ȃ" : "None"));
	item.pszText = tmpcharbuf;
	item.iSubItem = 3;
	ListView_SetItem(hSNESCheatList, &item);
	return;
}

static void SetSNESCheatList()
{
	if(!hSNESCheatList)
		return;

	ListView_DeleteAllItems(hSNESCheatList);

	uint32 i;
	for (i = 0; i < Cheat.num_cheats; i++) {
		InsertSNESCheatList((int)i);
	}
	if(ListView_GetItemCount(hSNESCheatList))
		ListView_SetItemState(hSNESCheatList, 0, LVIS_FOCUSED, LVIS_FOCUSED);
	return;
}

