#include "uosnesw.h"

HWND hProp;
WNDPROC PropProc;
UINT StartPageIndex = 0;
unsigned char errConfigSwitch = FALSE;

extern LRESULT CALLBACK JoypadDlgProc(HWND hWnd, UINT uMsg,WPARAM wParam, LPARAM lParam);
extern LRESULT CALLBACK SNESEmulationDlgProc(HWND hWnd, UINT uMsg,WPARAM wParam, LPARAM lParam);
extern LRESULT CALLBACK DirectoryDlgProc(HWND hWnd, UINT uMsg,WPARAM wParam, LPARAM lParam);
extern LRESULT CALLBACK SettingsDlgProc(HWND hWnd, UINT uMsg,WPARAM wParam, LPARAM lParam);
extern LRESULT CALLBACK OtherDlgProc(HWND hWnd, UINT uMsg,WPARAM wParam, LPARAM lParam);
extern bool IsButtonConfigFocused(HWND hFocus);

//LRESULT CALLBACK BrowseHook(HWND hWnd, UINT uMsg,WPARAM wParam, LPARAM lParam);
//extern LRESULT CALLBACK GetOpenFileNameHook(HWND hWnd, UINT uMsg,WPARAM wParam, LPARAM lParam)

LRESULT CALLBACK SubPropProc(HWND hWnd, UINT uMsg,WPARAM wParam, LPARAM lParam)
{
	switch (uMsg) {
	case WM_COMMAND:
		switch (LOWORD(wParam)) {
		case IDOK:
			if(!IsButtonConfigFocused(GetFocus()))
				break;
			return 0;
		default:
			break;
		}
		break;

	default:
		break;
	}
	if(PropProc)
		return (CallWindowProc(PropProc, hWnd, uMsg, wParam, lParam));
	else
		return 0;
}

//vpeB[V[g쐬ɌĂ΂
static int CALLBACK InitPropProc(HWND hWnd, UINT uMsg, LPARAM lParam)
{
	static DWORD Style;

	switch (uMsg) {
		case PSCB_INITIALIZED:
			// ftHgłĂwv{^폜
			Style = GetWindowLong(hWnd,GWL_EXSTYLE);
			Style &= ~(WS_EX_CONTEXTHELP);
			SetWindowLong(hWnd,GWL_EXSTYLE,Style);
			SetWindowText(GetDlgItem(hWnd,IDHELP), GUI.Language ? "ݒ胍[h" : "Load default");
			hProp = hWnd;
			PropProc = (WNDPROC)GetWindowLong(hWnd,GWL_WNDPROC);
			break;
		
		default:
			break;
	}
	return 0;
}

extern void S9xwSettingsLoad();
extern void SNESEmulationSettingsLoad();
extern void JoySettingsLoad();
extern void DirectorySettingsLoad();
extern void OtherSettingsLoad();

extern void S9xwSettingsSave();
extern void SNESEmulationSettingsSave();
extern void JoySettingsSave();
extern void DirectorySettingsSave();
extern void OtherSettingsSave();

extern void S9xwDefaultSettingsLoad();
extern void SNESEmulationDefaultSettingsLoad();
extern void JoyDefaultSettingsLoad();
extern void OtherDefaultSettingsLoad();

static unsigned char ConfigDlgSettingsSaved;
static unsigned char ConfigDlgDefaultSettingsLoaded;

static void ConfigDlgSettingsLoad()
{
	S9xwSettingsLoad();
	SNESEmulationSettingsLoad();
	JoySettingsLoad();
	DirectorySettingsLoad();
	OtherSettingsLoad();
	ConfigDlgSettingsSaved = FALSE;
	ConfigDlgDefaultSettingsLoaded = FALSE;
}

void ConfigDlgSettingsSave()
{
	if(ConfigDlgSettingsSaved)
		return;
	ConfigDlgSettingsSaved = TRUE;
	S9xwSettingsSave();
	SNESEmulationSettingsSave();
	JoySettingsSave();
	DirectorySettingsSave();
	OtherSettingsSave();
}

void ConfigDlgDefaultSettingsLoad(HWND hWnd)
{
	if(ConfigDlgDefaultSettingsLoaded)
		return;
	ConfigDlgDefaultSettingsLoaded = TRUE;
	S9xwDefaultSettingsLoad();
	SNESEmulationDefaultSettingsLoad();
	JoyDefaultSettingsLoad();
	OtherDefaultSettingsLoad();
	PropSheet_Changed(hProp, hWnd);
	ConfigDlgSettingsSaved = FALSE;
}

void ConfigDlgSettingsChanged(HWND hWnd)
{
	PropSheet_Changed(hProp, hWnd);
	ConfigDlgSettingsSaved = FALSE;
	ConfigDlgDefaultSettingsLoaded = FALSE;
}

void ConfigDlgProp(HWND hWnd)
{
	HINSTANCE hInst;
	PROPSHEETPAGE psp;
	PROPSHEETHEADER psh;
	HPROPSHEETPAGE hpsp[5];

	errConfigSwitch = FALSE;

	hInst = (HINSTANCE)GetWindowLong(hWnd, GWL_HINSTANCE);

	psp.dwSize = sizeof(PROPSHEETPAGE);
	psp.dwFlags = PSP_DEFAULT | PSP_HASHELP;
	psp.hInstance = hInst;

	psp.pszTemplate = MAKEINTRESOURCE(GUI.Language ? SETTINGS_DIALOG_JP : SETTINGS_DIALOG_US);
	psp.pfnDlgProc = (DLGPROC)SettingsDlgProc;
	hpsp[0] = CreatePropertySheetPage(&psp);

	psp.pszTemplate = MAKEINTRESOURCE(GUI.Language ? SNESEMULATION_DIALOG_JP : SNESEMULATION_DIALOG_US);
	psp.pfnDlgProc = (DLGPROC)SNESEmulationDlgProc;
	hpsp[1] = CreatePropertySheetPage(&psp);

	psp.pszTemplate = MAKEINTRESOURCE(GUI.Language ? JOYPAD_DIALOG_JP : JOYPAD_DIALOG_US);
	psp.pfnDlgProc = (DLGPROC)JoypadDlgProc;
	hpsp[2] = CreatePropertySheetPage(&psp);

	psp.pszTemplate = MAKEINTRESOURCE(GUI.Language ? DIRECTORY_DIALOG_JP : DIRECTORY_DIALOG_US);
	psp.pfnDlgProc = (DLGPROC)DirectoryDlgProc;
	hpsp[3] = CreatePropertySheetPage(&psp);

	psp.pszTemplate = MAKEINTRESOURCE(GUI.Language ? OTHER_DIALOG_JP : OTHER_DIALOG_US);
	psp.pfnDlgProc = (DLGPROC)OtherDlgProc;
	hpsp[4] = CreatePropertySheetPage(&psp);

	FillMemory((PVOID)&psh, sizeof(PROPSHEETHEADER), 0);
	psh.dwSize = sizeof(PROPSHEETHEADER);
	psh.dwFlags = PSH_USEICONID | PSH_USECALLBACK;
	psh.hInstance = hInst;
	psh.hwndParent = hWnd;
	psh.pszIcon = MAKEINTRESOURCE(SETTINGS_ICON);
	psh.nPages = 5;
	psh.nStartPage = StartPageIndex;
	psh.phpage = hpsp;
	psh.pfnCallback = InitPropProc;
	psh.pszCaption = (GUI.Language ? "ݒ" : "Configuration Settings");

	ConfigDlgSettingsLoad();

	PropertySheet(&psh);
	return;
}
