#include "snes9x.h"
#include "uosnesw.h"
#include "cdda.h"

static	DWORD	MCIDEVID = 0;

void CDROM_MCIPlayCD(void)
{
	MCI_PLAY_PARMS mciPlay;

	DWORD dwFlags;
 
	dwFlags = MCI_FROM | MCI_TO | MCI_NOTIFY;
	mciPlay.dwCallback = 0;
	mciPlay.dwFrom = MCI_MAKE_TMSF(Xxxcdda.Soundlink_cd_track, 0, 0, 0);
	mciPlay.dwTo = MCI_MAKE_TMSF(Xxxcdda.Soundlink_cd_track + 1, 0, 0, 0);

//	if (Xxxcdda.Soundlink_cd_track < Xxxcdda.Max_Soundlink_cd_track)
//		::mciSendCommand(MCIDEVID, MCI_PLAY, MCI_FROM | MCI_TO | MCI_NOTIFY, (DWORD)&mciPlay);
//	else
		::mciSendCommand(MCIDEVID, MCI_PLAY, MCI_FROM | MCI_NOTIFY, (DWORD)&mciPlay);
}

void CDROM_MCIOpenCD(void)
{
	MCI_OPEN_PARMS mciOpen;
	MCI_SET_PARMS  mciSet;
	MCI_STATUS_PARMS mciStatus;

	TCHAR szElementName[4];
	TCHAR szAliasName[32];
	DWORD dwFlags;
	DWORD dwAliasCount = GetCurrentTime();
	DWORD dwRet;

	if ( !MCIDEVID ) {
		ZeroMemory(&mciOpen, sizeof(mciOpen));
		mciOpen.lpstrDeviceType = (LPTSTR)MCI_DEVTYPE_CD_AUDIO;
		wsprintf( szElementName, "%c:", 0x41+Xxxcdda.Drv);
		wsprintf( szAliasName, TEXT("CD%lu:"), dwAliasCount );
		mciOpen.lpstrElementName = szElementName;
		mciOpen.lpstrAlias = szAliasName;
		dwFlags = MCI_OPEN_ELEMENT | MCI_OPEN_SHAREABLE | MCI_OPEN_ALIAS | MCI_OPEN_TYPE | MCI_OPEN_TYPE_ID | MCI_WAIT;
		dwRet = mciSendCommand(0, MCI_OPEN, dwFlags, (DWORD)(LPVOID)&mciOpen);
		if ( dwRet == MMSYSERR_NOERROR ) {
			MCIDEVID = mciOpen.wDeviceID;
		}
			MCIDEVID = mciOpen.wDeviceID;
		if ( MCIDEVID ) {
			dwFlags = MCI_SET_AUDIO | MCI_SET_ON | MCI_SET_TIME_FORMAT | MCI_WAIT;
			mciSet.dwCallback = 0;
	              mciSet.dwTimeFormat = MCI_FORMAT_TMSF;
			mciSet.dwAudio = MCI_SET_AUDIO_ALL;
			dwRet = mciSendCommand(MCIDEVID, MCI_SET, dwFlags, (DWORD)(LPVOID)&mciSet);
		}
	}

	mciStatus.dwItem = MCI_STATUS_NUMBER_OF_TRACKS;
	if (::mciSendCommand(MCIDEVID, MCI_STATUS, MCI_STATUS_ITEM | MCI_WAIT, (DWORD)&mciStatus)) {
		::mciSendCommand(MCIDEVID, MCI_CLOSE, MCI_WAIT, 0);
		return;
	}
	Xxxcdda.Max_Soundlink_cd_track = mciStatus.dwReturn;
}

void CDROM_MCIStopCD(void)
{
	MCI_GENERIC_PARMS  mciParam;
	mciParam.dwCallback = 0;
	mciSendCommand(MCIDEVID, MCI_STOP, MCI_NOTIFY, (DWORD)(LPVOID)&mciParam);
}

void CDROM_MCICloseCD(void)
{
      if(MCIDEVID){
       CDROM_MCIStopCD();
	MCI_GENERIC_PARMS  mciParam;
	mciParam.dwCallback = 0;
	mciSendCommand(MCIDEVID, MCI_CLOSE, MCI_WAIT, 0);
       MCIDEVID = 0;}
}


