/*
  Copyright (C) 2004 sanmaiwashi
*/

#ifndef _UOSNES_H_
#define _UOSNES_H_

#include "common.h"
#include "port.h"

typedef struct {
	u8 JPenvFlag;
	u32 JoyReadRateMask;
	int VolumeLevel;
	u8 inactive_x;

	//Sound
	int SoundRate;
	int SoundBit;
	int SoundChn;

	//screenshot
	int SaveImagefileFormat;
	u8 ReduceTheColorTo256;
	u8 ReduceTheColorTo256IfWithin;
	u8 ImagefileHiresStretch;
	u8 RLEcompression256bitmap;

	//debug settings
	u8 DisplayScreenBufferAll;

	//condition
	u8 AVI_Recording;
	u8 MovieRecording;
	u8 toggle;

	//directory
	char HomeDirectory[1024];
	char LastHomeDirectory[1024];
	u8   HomeDirectoryMoved;
} OOptions;

typedef struct {
	const char *windows;
	const char *graphics;
	const char *sound;
	const char *cpu;
	const char *timer;
	const char *filedirectory;
	const char *ControllerOption;
	const char *joypadA[5];
	const char *joypadB[5];
	const char *button[24];
	const char *functioncodeA;
	const char *functioncodeB;
	const char *gui;
	const char *screenshot;
	const char *debug;
	const char *option;
} Scs;

START_EXTERN_C
void read_config();
void read_port_config();
void write_port_config();
extern const char version_string[];
extern const char bug_report_url[];
extern OOptions Options;
extern OOptions DefaultOptions;
extern Scs cs;
extern int SoundRates[];
#ifndef __WIN32__
extern int __argc;
extern char **__argv;
#endif
void LoadDefaultSettings ();
END_EXTERN_C

#endif /* _UOSNES_H_ */

