/*
  Copyright (C) 2004 sanmaiwashi
*/

#ifdef HAVE_CONFIG_H
	#include <config.h>
#endif

#include "uosnes.h"
#include "snes9x.h"
#ifdef __WIN32__
	#include "uosnesw.h"
#endif

const char version_string[] = PACKAGE_VERSION;
const char bug_report_url[] = PACKAGE_BUGREPORT;

OOptions Options;
OOptions DefaultOptions;

Scs cs = {
	"windows",//windows
	"graphics",//graphics
	"sound",//sound
	"cpu",//cpu
	"timer",//timer
	"FileDirectory",//FileDirectory
	"ControllerOption",//ControllerOption
	{"joypadA1", "joypadA2","joypadA3", "joypadA4", "joypadA5"},//joypadA
	{"joypadB1", "joypadB2","joypadB3", "joypadB4", "joypadB5"},//joypadB
	{"Left",//button
	 "Right",
	 "Up",
	 "Down",
	 "StartButton",
	 "SelectButton",
	 "AButton",
	 "BButton",
	 "XButton",
	 "YButton",
	 "LButton",
	 "RButton",
	 "Left_Turbo",
	 "Right_Turbo",
	 "Up_Turbo",
	 "Down_Turbo",
	 "StartButton_Turbo",
	 "SelectButton_Turbo",
	 "AButton_Turbo",
	 "BButton_Turbo",
	 "XButton_Turbo",
	 "YButton_Turbo",
	 "LButton_Turbo",
	 "RButton_Turbo"},
	"FunctionCodeA",//functioncodeA
	"FunctionCodeB",//functioncodeB
	"gui",//gui
	"screenshot",//screenshot
	"debug",//debug
	"option"//option
};

int SoundRates[6] = {
	8000,
	11025,
	22050,
	32000,
	44100,
	48000};

#ifndef __WIN32__
int __argc;
char **__argv;
#endif

#if 0
#ifndef __WIN32__
int main (int argc, char **argv) {
	__argc = argc;
	__argv = argv;
#else
int WINAPI WinMain(HINSTANCE hInstance,
				   HINSTANCE hPrevInstance,
				   LPSTR lpCmdLine,
				   int nCmdShow) {
#endif
#ifndef __WIN32__
    return 0;
#else
	return msg.wParam;
#endif
}
#endif

void LoadDefaultSettings ()
{
	memset(&Options, 0, sizeof(Options));
	memset(&DefaultOptions, 0, sizeof(DefaultOptions));

	DefaultOptions.JPenvFlag = 0;
	DefaultOptions.JoyReadRateMask = 0;
	DefaultOptions.VolumeLevel = 1;
	DefaultOptions.inactive_x = FALSE;

	//Sound
	DefaultOptions.SoundRate = 3;
	DefaultOptions.SoundBit = 16;
	DefaultOptions.SoundChn = 2;

	//screenshot
	DefaultOptions.SaveImagefileFormat = 0;
	DefaultOptions.ReduceTheColorTo256 = FALSE;
	DefaultOptions.ReduceTheColorTo256IfWithin = TRUE;
	DefaultOptions.ImagefileHiresStretch = TRUE;
	DefaultOptions.RLEcompression256bitmap = FALSE;

	//SNES debug settings
	DefaultOptions.DisplayScreenBufferAll = FALSE;

	//condition
	DefaultOptions.AVI_Recording = FALSE;
	DefaultOptions.MovieRecording = FALSE;
	DefaultOptions.toggle = FALSE;

	//directory
#ifdef __WIN32__
	GetCurrentDirectory(1024, DefaultOptions.HomeDirectory);
#else
	strcpy(DefaultOptions.HomeDirectory, "~/.uosnes");
#endif
	strcpy(DefaultOptions.LastHomeDirectory, DefaultOptions.HomeDirectory);
	DefaultOptions.HomeDirectoryMoved = FALSE;

	Options = DefaultOptions;
}

