#ifdef HAVE_CONFIG_H
#  include <config.h>
#endif

#include "snes9x.h"
#include "memmap.h"
#include "soundux.h"
#include "display.h"
#ifdef HAVE_IO_H
#include <io.h>
#elif HAVE_SYS_IO_H
#include <sys/io.h>
#endif
#include "cfgfile.h"
#include "cfgtpl.h"
#include "commutil.h"

static char cfgfilename[_MAX_PATH + 1];

//RevID for refresh config
static int RevID = 89;

static void write_config();

void read_config()
{
	//create fullpath of config.
	int len = strlen(__argv[0]);
	if(len > _MAX_PATH)
		return;
	strcpy(cfgfilename, __argv[0]);
	strcpy(cfgfilename + (len - 4), ".ini");
	
	if(!load_configfile(cfgfilename,
						config_data,
						write_config)) {
		if(!configfile_cannot_create) {
			write_config();
			flush_configfile();
		}
		return;
	}

	read_port_config();

	/* check RevID */
	if(RevID != get_config_int(0, cs.option, "RevID")) {
		remove((const char *)cfgfilename);
		if(!load_configfile(cfgfilename,
							config_data,
							write_config)) {
			if(!configfile_cannot_create) {
				write_config();
				flush_configfile();
			}
		}
	}
	return;
}

static void write_config()
{
	if(configfile_cannot_create)
		return;

	write_port_config();

    set_config_int(cs.option, "RevID", RevID);
	return;
}

