// (c)sanmaiwashi
// http://toriniku.sourceforge.net/

#include "memmap.h"
#include "xband.h"

extern FILE *trace;

//#define XBAND_DEBUG

#ifdef XBAND_DEBUG
const static char xband_log_name[] = "xband.log";
static FILE *xband_fs = NULL;
#endif

//if(!trace && Address == 0xFBC1B2 && Byte == 0x00) {
//	trace = fopen ("xbandtrace.log", "w");
//	CPU.Flags |= TRACE_FLAG;
//}

uint8 GetXBAND(uint32 Address)
{
	uint8 Byte = Memory.SRAM[Address & 0xFFFF];
	switch((Address & 0xF0FFFF)) {
		case 0xF0C1B2:
			//Byte == 0x00
			//Byte = Memory.SRAM[(Address & xband_addr_mask)];
			Byte = 0x46;
			break;
		
		case 0xF0C1B6:
			Byte &= 0x7F;
			break;
		
		case 0xF0C1BA:
			Byte &= 0x7F;
			break;
		
		case 0xF0C1BE:
			Byte &= 0xFE;
			break;
	}
#ifdef XBAND_DEBUG
	if(!xband_fs)
		xband_fs = fopen(xband_log_name, "w");
	fprintf(xband_fs, "Address %06X r Byte %02X\n", (unsigned int)Address, (unsigned int)Byte);
#endif
	return Byte;
}

void SetXBAND(uint8 Byte, uint32 Address)
{
	switch((Address & 0xF0FFFF)) {
		case 0xF0FC02:
			break;
		
		case 0xF0FE00:
			break;
		
		default:
			Memory.SRAM[Address & 0xFFFF] = Byte;
			break;
	}
#ifdef XBAND_DEBUG
	if(!xband_fs)
		xband_fs = fopen(xband_log_name, "w");
	fprintf(xband_fs, "Address %06X w Byte %02X\n", (unsigned int)Address, (unsigned int)Byte);
#endif
	return;
}

uint8 *GetBasePointerXBAND(uint32 Address)
{
	return Memory.SRAM;
}

uint8 *GetMemPointerXBAND(uint32 Address)
{
	return (Memory.SRAM + (Address & 0xFFFF));
}

void ResetXBAND(bool8 full)
{
	return;
}

