/*
  Copyright (C) 2004 sanmaiwashi
*/

#include "snes9x.h"
#include "memmap.h"
#include "cpuexec.h"
#include "apu.h"
#include "soundux.h"
#include "snesapu.h"
#include "gfx.h"
#include "spcplay.h"

static SAPURegisters BackupAPURegisters;
static uint8 BackupAPURAM[65536];
static uint8 BackupAPUExtraRAM[64];
static uint8 BackupDSPRAM[128];

#define SPC700SS (SPC700HZ/50)
#define T64K     (SPC700HZ/64000)
#define T8K      (SPC700HZ/8000)
#define T64KC    (SPC700HZ/50/T64K)
#define T8KC     (SPC700HZ/50/T8K)

void SPCPlayMainLoop(void)
{
	// APU_LOOP
	for(int a = 0; a < T8KC; a++) {
		for(int b = 0; b < (T8K / T64K); b++) {
			if(IAPU.APUExecuting) {
				for(int c = 0; c < T64K; c++) {
					APU_EXECUTE1();
					if(IAPU.APUExecuting == FALSE)
						break;
				}
			}

			if (APU.TimerEnabled [2]) {
				APU.Timer [2]++;
				if (APU.Timer [2] >= APU.TimerTarget [2]) {
					IAPU.RAM [0xff] = (IAPU.RAM [0xff] + 1) & 0xf;
					APU.Timer [2] -= APU.TimerTarget [2];
#ifdef SPC700_SHUTDOWN
					IAPU.WaitCounter = 1;
					IAPU.APUExecuting = Settings.APUEnabled;
#endif
				}
			}

			//SNESAPU
			EXT.t64Cnt++;
		}
		if (APU.TimerEnabled [0]) {
			APU.Timer [0]++;
			if (APU.Timer [0] >= APU.TimerTarget [0]) {
				IAPU.RAM [0xfd] = (IAPU.RAM [0xfd] + 1) & 0xf;
				APU.Timer [0] -= APU.TimerTarget [0];
#ifdef SPC700_SHUTDOWN
				IAPU.WaitCounter = 1;
				IAPU.APUExecuting = Settings.APUEnabled;
#endif
			}
		}
		if (APU.TimerEnabled [1]) {
			APU.Timer [1]++;
			if (APU.Timer [1] >= APU.TimerTarget [1]) {
				IAPU.RAM [0xfe] = (IAPU.RAM [0xfe] + 1) & 0xf;
				APU.Timer [1] -= APU.TimerTarget [1];
#ifdef SPC700_SHUTDOWN
				IAPU.WaitCounter = 1;
				IAPU.APUExecuting = Settings.APUEnabled;
#endif
			}
		}
	}
	S9xSyncSpeed();
}

// Restore SPC Load State
static void RestoreSPC()
{
	int i;

	APURegisters.PC = BackupAPURegisters.PC;
	APURegisters.YA.B.A = BackupAPURegisters.YA.B.A;
	APURegisters.X = BackupAPURegisters.X;
	APURegisters.YA.B.Y = BackupAPURegisters.YA.B.Y;
	APURegisters.P = BackupAPURegisters.P;
	APURegisters.S = BackupAPURegisters.S;
	memcpy(IAPU.RAM, BackupAPURAM, 65536);
	memcpy(APU.ExtraRAM, BackupAPUExtraRAM, 64);
	memcpy(APU.DSP, BackupDSPRAM, 128);

	IAPU.PC = IAPU.RAM + APURegisters.PC;
	S9xAPUUnpackStatus();
	if (APUCheckDirectPage ())
		IAPU.DirectPage = IAPU.RAM + 0x100;
	else
		IAPU.DirectPage = IAPU.RAM;

	S9xSetAPUControl (IAPU.RAM[0xf1]);

	memcpy(&IAPU.RAM[0xffc0], &BackupAPURAM[0xffc0], 0x40);

	for(i = 0; i < 4; i++) {
		//APU.OutPorts [i] = BackupAPURAM[0xf4 + i];
		IAPU.RAM[0xf4 + i] = BackupAPURAM[0xf4 + i];
	}

	for(i = 0; i < 3; i++)
		IAPU.RAM [0xfd + i] = BackupAPURAM[0xfd + i] & 0xf;

	IAPU.Scanline = 0;
	RestoreSPCFile();
}

// Load SPC file
bool8 LoadSPC(const char *pszFileName)
{
	FILE *file;
	char temp[64];

	if((file = fopen(pszFileName, "rb")) == NULL)
		return FALSE;

	memset(&SNESGameFixes, 0, sizeof(SNESGameFixes));

	Settings.APURAMInitialValueMaster = Settings.APURAMInitialValue;
	Settings.APURAMInitialValue = DefaultSettings.APURAMInitialValue;

	Settings.SRAMInitialValueMaster = Settings.SRAMInitialValue;
	Settings.SRAMInitialValue = DefaultSettings.SRAMInitialValue;

	Settings.RAMInitialValueMaster = Settings.RAMInitialValue;
	Settings.RAMInitialValue = DefaultSettings.RAMInitialValue;

	Settings.SPCPlaying = TRUE;

	Settings.PAL = TRUE;
	Settings.FrameTime = Settings.FrameTimePAL;
	Memory.ROMFramesPerSecond = 50;

	//S9xResetAPU();
	S9xReset(TRUE);

	fseek(file, 37, SEEK_SET);
	fread(&BackupAPURegisters.PC, 2, 1, file);
	fread(&BackupAPURegisters.YA.B.A, 1, 1, file);
	fread(&BackupAPURegisters.X, 1, 1, file);
	fread(&BackupAPURegisters.YA.B.Y, 1, 1, file);
	fread(&BackupAPURegisters.P, 1, 1, file);
	fread(&BackupAPURegisters.S, 1, 1, file);
	fseek(file, 256, SEEK_SET);
	fread(BackupAPURAM, 65536, 1, file);
	fread(BackupDSPRAM, 128, 1, file);
	fread(temp, 64, 1, file);
	fread(BackupAPUExtraRAM, 64, 1, file);

	fclose(file);
	RestoreSPC();

	return TRUE;
}

