#ifndef _SNESAPU_H_
#define _SNESAPU_H_

//**************************************************************************************************
// Defines

//Mixing routines (see source for additional notes)
#define	MIX_NONE    0							//No mixing
#define	MIX_INT     1							//Use integer instructions
#define	MIX_FLOAT   3							//Use floating-point instructions

//DSP options ----------------------------------
#define	DSP_ANALOG  0x01						//Simulate analog anomalies
#define	DSP_OLDSMP  0x02						//Traditional ADPCM routine
#define	DSP_SURND   0x04						//"Surround" sound
#define	DSP_REVERSE 0x08						//Reverse stereo samples
#define	DSP_NOECHO  0x10						//Disable echo (must not be bit 0 or 5, see disEcho)

//Mixing flags
#define	MFLG_MUTE   0x01						//Mute voice
#define	MFLG_KOFF   0x04						//Voice is in the process of keying off
#define	MFLG_OFF    0x08						//Voice is currently inactive
#define	MFLG_END    0x10						//End block was just played
#define	MFLG_SSRC   0x20						//StartSrc

// Envelope precision -------------------------
#define E_SHIFT     8		// Amount to shift envelope to get 8-bit signed value

typedef struct {
    //Waveform --------
	uint16   bStart;		//-> start block
	uint16   bMixStart;		//-> start block
	uint16   bCur;			//-> current block
	uint8    bHdr;			//Block Header for current block
	volatile uint8  mFlg;	//Mixing flags (see MixF)

    //Envelope --------
	volatile uint8  eMode;	//[3-0] Current mode (see EnvM)
							//[6-4] ADSR mode to switch into from Gain
							//[7]   Envelope is idle
	volatile uint8  eRIdx;	//Index in RateTab (0-31)
	volatile uint32 eRate;	//Rate of envelope adjustment (16.16)
	volatile uint32 eDec;	//Pitch Decimal (.16)
	volatile int32  eVal;	//Current envelope value
	volatile int32  eAdj;	//Amount to adjust envelope height
	volatile int32  eDest;	//Envelope Destination

    //Samples ---------
    int16  sBuf[32];		// 32 + 32 bytes for decompressed sample blocks
    uint8  sIdx;			//-> current sample in sBuf
 	int32  sP1;				//Last sample decompressed (prev1)
	int32  sP2;				//Second to last sample (prev2)

    //Mixing ----------
 	int32	mChnL;			//Channel Volume (-24.7)
	int32	mChnR;			// "  "
	uint32	mOrgP;			//Original pitch rate converted from the DSP (16.16)
	uint32	mOrgRate;		//Pitch Rate before modulation (16.16)
	uint32	mRate;			//Pitch Rate after modulation (16.16)
	uint32	mDec;			//Pitch Decimal (.16) (used as delta for interpolation)
	int32	mOut;			//Last sample output before chn vol (used for pitch mod)
} VoiceMix;

START_EXTERN_C
extern VoiceMix mix[8];//Mixing structures for each voice
extern uint32 t64CntS;// 64kHz counter (increased every 64kHz pulse) by sample count

void InitAPUDSP();
void ResetAPUDSP();
void SetAPUDSPOpt(int mix, int chn, int bits, int32 rate, int inter, int opts);
void StoreAPUDSP();
void RestoreAPUDSP();
void RestoreSPCFile();
void SetAPUDSPAmp(int32 amp);
void *EmuAPUDSP(void *pBuf, int32 size);
void APUDSPIn(uint8 address, uint8 data);
END_EXTERN_C

#endif

