#include "snapshot.h"
#include "snaporig.h"
#include "memmap.h"
#include "snes9x.h"
#include "65c816.h"
#include "ppu.h"
#include "cpuexec.h"
#include "display.h"
#include "apu.h"
#include "soundux.h"
#include "sa1.h"
#include "srtc.h"
#include <string.h>

bool8 S9xFreezeZSNES (const char *filename)
{
	unsigned long ZstDataSize = 0x48 + 0xbcb + 0x20000 + 0x10000 + (Settings.APUEnabled ? (0x10000 + 0x66c) : 0);
	uint8 *ZstData = (uint8 *) malloc (ZstDataSize);
	if(!ZstData)
		return FALSE;
	FILE *fs;
	if (!(fs = fopen (filename, "wb"))) {
		free ((char *) ZstData);
		return (FALSE);
	}
	memset(ZstData, 0, ZstDataSize);
/*
NEWSYM zsmesg,  db 'ZSNES Save State File V0.6',26
NEWSYM versn,   db 60   ; version #/100
NEWSYM curcyc,  db 0    ; cycles left in scanline
NEWSYM curypos, dw 0    ; current y position
NEWSYM cacheud, db 1    ; update cache every ? frames
NEWSYM ccud,    db 0    ; current cache increment
NEWSYM intrset, db 0    ; interrupt set
NEWSYM cycpl,   db 0    ; cycles per scanline
NEWSYM cycphb,  db 0    ; cycles per hblank
NEWSYM spcon,   db 0    ; SPC Enable (1=enabled)
NEWSYM stackand, dw 01FFh ; value to and stack to keep it from going to the wrong area
NEWSYM stackor,  dw 0100h ; value to or stack to keep it from going to the wrong area

; 65816 registers

NEWSYM xat,      dw 0
NEWSYM xdbt,     db 0
NEWSYM xpbt,     db 0
NEWSYM xst,      dw 0
NEWSYM xdt,      dw 0
NEWSYM xxt,      dw 0
NEWSYM xyt,      dw 0
NEWSYM xp,       db 0
NEWSYM xe,       db 0
NEWSYM xpc,      dw 0
NEWSYM xirqb,    db 0           ; which bank the irqs start at
NEWSYM debugger, db 0              ; Start with debugger (1=yes,0=no)
NEWSYM Curtableaddr,  dd 0                 ; Current table address
NEWSYM curnmi,   db 0           ; if in NMI(1) or not(0)
; pharos - equ hack *sigh*
num2writecpureg equ $-zsmesg
ALIGN32
NEWSYM cycpbl,  dd 110  ; percentage left of CPU/SPC to run  (3.58 = 175)
NEWSYM cycpblt, dd 110  ; percentage of CPU/SPC to run
*/
	//offset
	//000000: NEWSYM zsmesg,  db 'ZSNES Save State File V0.6',26
	strncpy((char *)ZstData, "ZSNES Save State File V0.6", 26);
	*(uint8 *)(&ZstData[0x1a]) = 26;
	//00001b: NEWSYM versn,   db 60   ; version #/100
	*(uint8 *)(&ZstData[0x1b]) = 60;
	//00001c: NEWSYM curcyc,  db 0    ; cycles left in scanline
	*(uint8 *)(&ZstData[0x1c]) = 228;
	//00001d: NEWSYM curypos, dw 0    ; current y position
	*(uint16 *)(&ZstData[0x1d]) = (uint16)CPU.V_Counter;
	//00001f: NEWSYM cacheud, db 1    ; update cache every ? frames
	*(uint8 *)(&ZstData[0x1f]) = 1;
	//000020: NEWSYM ccud,    db 0    ; current cache increment
	*(uint8 *)(&ZstData[0x20]) = 0;
	//000021: NEWSYM intrset, db 0    ; interrupt set
	*(uint8 *)(&ZstData[0x21]) = 0;
	//000022: NEWSYM cycpl,   db 0    ; cycles per scanline
	*(uint8 *)(&ZstData[0x22]) = 228;
	//000023: NEWSYM cycphb,  db 0    ; cycles per hblank
	*(uint8 *)(&ZstData[0x23]) = 56;
	//000024: NEWSYM spcon,   db 0    ; SPC Enable (1=enabled)
	*(uint8 *)(&ZstData[0x24]) = Settings.APUEnabled;
	//000025: NEWSYM stackand, dw 01FFh ; value to and stack to keep it from going to the wrong area
	*(uint16 *)(&ZstData[0x25]) = 0x1fff;
	//000027: NEWSYM stackor,  dw 0100h ; value to or stack to keep it from going to the wrong area
	*(uint16 *)(&ZstData[0x27]) = 0x0100;
	//000029: NEWSYM xat,      dw 0
	*(uint16 *)(&ZstData[0x29]) = Registers.A.W;
	//00002b: NEWSYM xdbt,     db 0
	*(uint8 *)(&ZstData[0x2b]) = Registers.DB;
	//00002c: NEWSYM xpbt,     db 0
	*(uint8 *)(&ZstData[0x2c]) = Registers.PB;
	//00002d: NEWSYM xst,      dw 0
	*(uint16 *)(&ZstData[0x2d]) = Registers.S.W;
	//00002f: NEWSYM xdt,      dw 0
	*(uint16 *)(&ZstData[0x2f]) = Registers.D.W;
	//000031: NEWSYM xxt,      dw 0
	*(uint16 *)(&ZstData[0x31]) = Registers.X.W;
	//000033: NEWSYM xyt,      dw 0
	*(uint16 *)(&ZstData[0x33]) = Registers.Y.W;
	//000035: NEWSYM xp,       db 0
	//000036: NEWSYM xe,       db 0
	*(uint16 *)(&ZstData[0x35]) = Registers.P.W;
	//000037: NEWSYM xpc,      dw 0
	*(uint16 *)(&ZstData[0x37]) = Registers.PC;
	//000039: NEWSYM xirqb,    db 0           ; which bank the irqs start at
	*(uint8 *)(&ZstData[0x39]) = (uint8)(S9xGetWord(0xffee) & 0xff);
	//00003a: NEWSYM debugger, db 0              ; Start with debugger (1=yes,0=no)
	*(uint8 *)(&ZstData[0x3a]) = 0;
	//00003b: NEWSYM Curtableaddr,  dd 0                 ; Current table address
	*(uint32 *)(&ZstData[0x3b]) = 0;
	//00003f: NEWSYM curnmi,   db 0           ; if in NMI(1) or not(0)
	*(uint8 *)(&ZstData[0x3f]) = CPU.NMIActive;
	//000040: NEWSYM cycpbl,  dd 110  ; percentage left of CPU/SPC to run  (3.58 = 175)
	*(uint32 *)(&ZstData[0x40]) = 110;
	//000044: NEWSYM cycpblt, dd 110  ; percentage of CPU/SPC to run
	*(uint32 *)(&ZstData[0x44]) = 110;

/*
NEWSYM sndrot,    db 0             ; rotates to use A,X or Y for sound skip
NEWSYM sndrot2,   db 0             ; rotates a random value for sound skip
NEWSYM INTEnab,   db 0             ; enables NMI(7)/VIRQ(5)/HIRQ(4)/JOY(0)
NEWSYM NMIEnab,   db 1             ; controlled in e65816 loop.  Sets to 81h
NEWSYM VIRQLoc,   dw 0             ; VIRQ Y location
NEWSYM vidbright, db 0             ; screen brightness (0 .. 15)
NEWSYM previdbr,  db 0             ; previous screen brightness
NEWSYM forceblnk, db 80h           ; force blanking on/off ($80=on)
NEWSYM objptr,    dd 0             ; pointer to object data in VRAM
NEWSYM objptrn,   dd 0             ; pointer2 to object data in VRAM
NEWSYM objsize1,  db 1             ; 1 = 8dot, 4=16 dot, 16=32 dot, 64=64dot
NEWSYM objsize2,  db 4             ; large object size
NEWSYM objmovs1,  db 2             ; number of bytes to move/paragraph
NEWSYM objadds1,  dw 14            ; number of bytes to add/paragraph
NEWSYM objmovs2,  db 2             ; number of bytes to move/paragraph
NEWSYM objadds2,  dw 14            ; number of bytes to add/paragraph
NEWSYM oamaddrt,  dw 0             ; oam address
NEWSYM oamaddrs,  dw 0             ; oam address at beginning of vblank
NEWSYM objhipr,   db 0             ; highest priority object #
NEWSYM bgmode,    db 0             ; graphics mode ( 0 .. 7 )
NEWSYM bg3highst, db 0             ; is 1 if background 3 has the highest priority
NEWSYM bgtilesz,  db 0             ; 0 = 8x8, 1 = 16x16, bit 0=bg1,bit1=bg2,etc
NEWSYM mosaicon,  db 0             ; mosaic on, bit 0=bg1,bit1=bg2, etc
NEWSYM mosaicsz,  db 0             ; mosaic size in pixels
NEWSYM bg1ptr,    dw 0             ; pointer to background1
NEWSYM bg2ptr,    dw 0             ; pointer to background2
NEWSYM bg3ptr,    dw 0             ; pointer to background3
NEWSYM bg4ptr,    dw 0             ; pointer to background4
NEWSYM bg1ptrb,   dw 0             ; pointer to background1
NEWSYM bg2ptrb,   dw 0             ; pointer to background2
NEWSYM bg3ptrb,   dw 0             ; pointer to background3
NEWSYM bg4ptrb,   dw 0             ; pointer to background4
NEWSYM bg1ptrc,   dw 0             ; pointer to background1
NEWSYM bg2ptrc,   dw 0             ; pointer to background2
NEWSYM bg3ptrc,   dw 0             ; pointer to background3
NEWSYM bg4ptrc,   dw 0             ; pointer to background4
NEWSYM bg1ptrd,   dw 0             ; pointer to background1
NEWSYM bg2ptrd,   dw 0             ; pointer to background2
NEWSYM bg3ptrd,   dw 0             ; pointer to background3
NEWSYM bg4ptrd,   dw 0             ; pointer to background4
NEWSYM bg1scsize, db 0             ; bg #1 screen size (0=1x1,1=1x2,2=2x1,3=2x2)
NEWSYM bg2scsize, db 0             ; bg #2 screen size (0=1x1,1=1x2,2=2x1,3=2x2)
NEWSYM bg3scsize, db 0             ; bg #3 screen size (0=1x1,1=1x2,2=2x1,3=2x2)
NEWSYM bg4scsize, db 0             ; bg #4 screen size (0=1x1,1=1x2,2=2x1,3=2x2)
NEWSYM bg1objptr, dw 0             ; pointer to tiles in background1
NEWSYM bg2objptr, dw 0             ; pointer to tiles in background2
NEWSYM bg3objptr, dw 0             ; pointer to tiles in background3
NEWSYM bg4objptr, dw 0             ; pointer to tiles in background4
NEWSYM bg1scrolx, dw 0             ; background 1 x position
NEWSYM bg2scrolx, dw 0             ; background 2 x position
NEWSYM bg3scrolx, dw 0             ; background 3 x position
NEWSYM bg4scrolx, dw 0             ; background 4 x position
NEWSYM bg1sx,     dw 0             ; Temporary Variable for Debugging purposes
NEWSYM bg1scroly, dw 0             ; background 1 y position
NEWSYM bg2scroly, dw 0             ; background 2 y position
NEWSYM bg3scroly, dw 0             ; background 3 y position
NEWSYM bg4scroly, dw 0             ; background 4 y position
NEWSYM addrincr,  dw 2             ; vram increment (2,64,128,256)
NEWSYM vramincr,  db 0             ; 0 = inrement at 2118/2139, 1 = 2119,213A
NEWSYM vramread,  db 0             ; 0 = address set, 1 = already read once
NEWSYM vramaddr,  dd 0             ; vram address
NEWSYM cgaddr,    dw 0             ; cg (palette) address
NEWSYM cgmod,     db 0             ; if cgram is modified or not
NEWSYM scrnon,    dw 0             ; main & sub screen on
NEWSYM scrndist,  db 0             ; which background is disabled
NEWSYM resolutn,  dw 224           ; screen resolution
NEWSYM multa,     db 0             ; multiplier A
NEWSYM diva,      dw 0             ; divisor C
NEWSYM divres,    dw 0             ; quotent of divc/divb
NEWSYM multres,   dw 0             ; result of multa * multb/remainder of divc/divb
NEWSYM latchx,    dw 0             ; latched x value
NEWSYM latchy,    dw 0             ; latched y value
NEWSYM latchxr,   db 0             ; low or high byte read for x value
NEWSYM latchyr,   db 0             ; low or high byte read for y value
NEWSYM frskipper, db 0             ; used to control frame skipping
NEWSYM winl1,     db 0             ; window 1 left position
NEWSYM winr1,     db 0             ; window 1 right position
NEWSYM winl2,     db 0             ; window 2 left position
NEWSYM winr2,     db 0             ; window 2 right position
NEWSYM winbg1en,  db 0             ; Win1 on (IN/OUT) or Win2 on (IN/OUT) on BG1
NEWSYM winbg2en,  db 0             ; Win1 on (IN/OUT) or Win2 on (IN/OUT) on BG2
NEWSYM winbg3en,  db 0             ; Win1 on (IN/OUT) or Win2 on (IN/OUT) on BG3
NEWSYM winbg4en,  db 0             ; Win1 on (IN/OUT) or Win2 on (IN/OUT) on BG4
NEWSYM winobjen,  db 0             ; Win1 on (IN/OUT) or Win2 on (IN/OUT) on sprites
NEWSYM wincolen,  db 0             ; Win1 on (IN/OUT) or Win2 on (IN/OUT) on backarea
NEWSYM winlogica, db 0             ; Window logic type for BG1 to 4
NEWSYM winlogicb, db 0             ; Window logic type for Sprites and Backarea
NEWSYM winenabm,  db 0             ; Window logic enable for main screen
NEWSYM winenabs,  db 0             ; Window logic enable for sub screen
NEWSYM mode7set,  db 0             ; mode 7 settings
NEWSYM mode7A,    dw 0             ; A value for Mode 7
NEWSYM mode7B,    dw 0             ; B value for Mode 7
NEWSYM mode7C,    dw 0             ; C value for Mode 7
NEWSYM mode7D,    dw 0             ; D value for Mode 7
NEWSYM mode7X0,   dw 0             ; Center X for Mode 7
NEWSYM mode7Y0,   dw 0             ; Center Y for Mode 7
NEWSYM JoyAPos,   db 0             ; Old-Style Joystick Read Position for Joy 1 & 3
NEWSYM JoyBPos,   db 0             ; Old-Style Joystick Read Position for Joy 2 & 4
NEWSYM compmult,  dd 0             ; Complement Multiplication for Mode 7
NEWSYM joyalt,    db 0             ; temporary joystick alternation

NEWSYM wramrwadr, dd 0             ; continuous read/write to wram address
NEWSYM dmadata, times 129 db 0h  ; dma data (written from ports 43xx)
NEWSYM irqon,     db 0             ; if IRQ has been called (80h) or not (0)
NEWSYM nexthdma,  db 0             ; HDMA data to execute once vblank ends
NEWSYM curhdma,   db 0             ; Currently executed hdma
NEWSYM hdmadata, times 8*19 db 0   ; 4 dword register addresses, # of bytes to
                           ; transfer/line, address increment (word)
NEWSYM hdmatype,  db 0             ; if first time executing hdma or not
NEWSYM coladdr,   db 0             ; red value of color to add
NEWSYM coladdg,   db 0             ; green value of color to add
NEWSYM coladdb,   db 0             ; blue value of color to add
NEWSYM colnull,   db 0             ; keep this 0 (when accessing colors by dword)
NEWSYM scaddset,  db 0             ; screen/fixed color addition settings
NEWSYM scaddtype, db 0             ; which screen to add/sub
NEWSYM Voice0Disabl2, db 1         ; Disable Voice 0
NEWSYM Voice1Disabl2, db 1         ; Disable Voice 1
NEWSYM Voice2Disabl2, db 1         ; Disable Voice 2
NEWSYM Voice3Disabl2, db 1         ; Disable Voice 3
NEWSYM Voice4Disabl2, db 1         ; Disable Voice 4
NEWSYM Voice5Disabl2, db 1         ; Disable Voice 5
NEWSYM Voice6Disabl2, db 1         ; Disable Voice 6
NEWSYM Voice7Disabl2, db 1         ; Disable Voice 7

NEWSYM oamram,  times 1024 db 0    ; OAMRAM (544 bytes)
NEWSYM cgram,   times 512 db 0     ; CGRAM
NEWSYM pcgram,  times 512 db 0     ; Previous CGRAM

NEWSYM vraminctype,  db 0

; New variables
NEWSYM vramincby8on,   db 0        ; if increment by 8 is on
NEWSYM vramincby8left, db 0        ; how many left
NEWSYM vramincby8totl, db 0        ; how many in total (32,64,128)
NEWSYM vramincby8rowl, db 0        ; how many left in that row (start at 8)
NEWSYM vramincby8ptri, dw 0        ; increment by how many when rowl = 0

NEWSYM nexthprior,     db 0
NEWSYM doirqnext,      db 0

NEWSYM vramincby8var,  dw 0
NEWSYM screstype,      db 0
NEWSYM extlatch,       db 0
NEWSYM cfield,         db 0
NEWSYM interlval,      db 0

NEWSYM HIRQLoc,   dw 0             ; HIRQ X location

NEWSYM KeyOnStA, db 0
NEWSYM KeyOnStB, db 0

NEWSYM SDD1BankA, db 0
NEWSYM SDD1BankB, db 1
NEWSYM SDD1BankC, db 2
NEWSYM SDD1BankD, db 3

NEWSYM tempdat, times 484 db 0     ; expandable area
*/
	//offset
	//000048: NEWSYM sndrot,    db 0             ; rotates to use A,X or Y for sound skip
	*(uint8 *)(&ZstData[0x48]) = 0;
	//000049: NEWSYM sndrot2,   db 0             ; rotates a random value for sound skip
	*(uint8 *)(&ZstData[0x49]) = 0;
	//00004a: NEWSYM INTEnab,   db 0             ; enables NMI(7)/VIRQ(5)/HIRQ(4)/JOY(0)
	*(uint8 *)(&ZstData[0x4a]) = ((PPU.HTimerEnabled ? 0x10 : 0) | (PPU.VTimerEnabled ? 0x20 : 0) | (CPU.NMIActive ? 0x80 : 0) | (Memory.FillRAM[0x4200] & 1));
	//00004b: NEWSYM NMIEnab,   db 1             ; controlled in e65816 loop.  Sets to 81h
	*(uint8 *)(&ZstData[0x4b]) = Memory.FillRAM [0x4210];
	//00004c: NEWSYM VIRQLoc,   dw 0             ; VIRQ Y location
	*(uint16 *)(&ZstData[0x4c]) = PPU.IRQVBeamPos;
	//00004e: NEWSYM vidbright, db 0             ; screen brightness (0 .. 15)
	*(uint8 *)(&ZstData[0x4e]) = PPU.Brightness;
	//00004f: NEWSYM previdbr,  db 0             ; previous screen brightness
	*(uint8 *)(&ZstData[0x4f]) = 0;
	//000050: NEWSYM forceblnk, db 80h           ; force blanking on/off ($80=on)
	*(uint8 *)(&ZstData[0x50]) = (PPU.ForcedBlanking ? 0x80 : 0);
	//000051: NEWSYM objptr,    dd 0             ; pointer to object data in VRAM
	*(uint32 *)(&ZstData[0x51]) = (uint32)(PPU.OBJNameBase);
	//000055: NEWSYM objptrn,   dd 0             ; pointer2 to object data in VRAM
	*(uint32 *)(&ZstData[0x55]) = (uint32)(PPU.OBJNameSelect + PPU.OBJNameBase);

	//000059: NEWSYM objsize1,  db 1             ; 1 = 8dot, 4=16 dot, 16=32 dot, 64=64dot
	//00005a: NEWSYM objsize2,  db 4             ; large object size
	//00005b: NEWSYM objmovs1,  db 2             ; number of bytes to move/paragraph
	//00005c: NEWSYM objadds1,  dw 14            ; number of bytes to add/paragraph
	//00005e: NEWSYM objmovs2,  db 2             ; number of bytes to move/paragraph
	//00005f: NEWSYM objadds2,  dw 14            ; number of bytes to add/paragraph
	switch (PPU.OBJSizeSelect)
	{
		case 0:
			*(uint8 *)(&ZstData[0x59]) = 1;
			*(uint8 *)(&ZstData[0x5a]) = 4;
			*(uint8 *)(&ZstData[0x5b]) = 2;
			*(uint16 *)(&ZstData[0x5c]) = 14;
			*(uint8 *)(&ZstData[0x5e]) = 2;
			*(uint16 *)(&ZstData[0x5f]) = 14;
			break;

		case 1:
			*(uint8 *)(&ZstData[0x59]) = 1;
			*(uint8 *)(&ZstData[0x5a]) = 16;
			*(uint8 *)(&ZstData[0x5b]) = 2;
			*(uint16 *)(&ZstData[0x5c]) = 14;
			*(uint8 *)(&ZstData[0x5e]) = 4;
			*(uint16 *)(&ZstData[0x5f]) = 12;
			break;

		case 2:
			*(uint8 *)(&ZstData[0x59]) = 1;
			*(uint8 *)(&ZstData[0x5a]) = 64;
			*(uint8 *)(&ZstData[0x5b]) = 2;
			*(uint16 *)(&ZstData[0x5c]) = 14;
			*(uint8 *)(&ZstData[0x5e]) = 8;
			*(uint16 *)(&ZstData[0x5f]) = 8;
			break;

		case 3:
			*(uint8 *)(&ZstData[0x59]) = 4;
			*(uint8 *)(&ZstData[0x5a]) = 16;
			*(uint8 *)(&ZstData[0x5b]) = 2;
			*(uint16 *)(&ZstData[0x5c]) = 14;
			*(uint8 *)(&ZstData[0x5e]) = 4;
			*(uint16 *)(&ZstData[0x5f]) = 12;
			break;

		case 4:
			*(uint8 *)(&ZstData[0x59]) = 4;
			*(uint8 *)(&ZstData[0x5a]) = 64;
			*(uint8 *)(&ZstData[0x5b]) = 2;
			*(uint16 *)(&ZstData[0x5c]) = 14;
			*(uint8 *)(&ZstData[0x5e]) = 8;
			*(uint16 *)(&ZstData[0x5f]) = 8;
			break;

		case 5:
			*(uint8 *)(&ZstData[0x59]) = 16;
			*(uint8 *)(&ZstData[0x5a]) = 64;
			*(uint8 *)(&ZstData[0x5b]) = 4;
			*(uint16 *)(&ZstData[0x5c]) = 12;
			*(uint8 *)(&ZstData[0x5e]) = 8;
			*(uint16 *)(&ZstData[0x5f]) = 8;
			break;

		case 6:
			*(uint8 *)(&ZstData[0x59]) = 1;
			*(uint8 *)(&ZstData[0x5a]) = 4;
			*(uint8 *)(&ZstData[0x5b]) = 2;
			*(uint16 *)(&ZstData[0x5c]) = 14;
			*(uint8 *)(&ZstData[0x5e]) = 2;
			*(uint16 *)(&ZstData[0x5f]) = 14;
			break;

		case 7:
			*(uint8 *)(&ZstData[0x59]) = 1;
			*(uint8 *)(&ZstData[0x5a]) = 4;
			*(uint8 *)(&ZstData[0x5b]) = 2;
			*(uint16 *)(&ZstData[0x5c]) = 14;
			*(uint8 *)(&ZstData[0x5e]) = 2;
			*(uint16 *)(&ZstData[0x5f]) = 14;
			break;

		default:
			*(uint8 *)(&ZstData[0x59]) = 16;
			*(uint8 *)(&ZstData[0x5a]) = 64;
			*(uint8 *)(&ZstData[0x5b]) = 4;
			*(uint16 *)(&ZstData[0x5c]) = 12;
			*(uint8 *)(&ZstData[0x5e]) = 8;
			*(uint16 *)(&ZstData[0x5f]) = 8;
			break;
	}
	//000061: NEWSYM oamaddrt,  dw 0
	*(uint16 *)(&ZstData[0x61]) = PPU.OAMAddr;
	//000063: NEWSYM oamaddrs,  dw 0             ; oam address at beginning of vblank
	*(uint16 *)(&ZstData[0x63]) = PPU.SavedOAMAddr;
	//000065: NEWSYM objhipr,   db 0             ; highest priority object #
	*(uint8 *)(&ZstData[0x65]) = PPU.FirstSprite;
	//000066: NEWSYM bgmode,    db 0             ; graphics mode ( 0 .. 7 )
	*(uint8 *)(&ZstData[0x66]) = PPU.BGMode;
	//000067: NEWSYM bg3highst, db 0             ; is 1 if background 3 has the highest priority
	*(uint8 *)(&ZstData[0x67]) = PPU.BG3Priority;
	//000068: NEWSYM bgtilesz,  db 0             ; 0 = 8x8, 1 = 16x16, bit 0=bg1,bit1=bg2,etc
	*(uint8 *)(&ZstData[0x68]) = (uint8)((Memory.FillRAM [0x2105] >> 4) & 0x0f);
	//000069: NEWSYM mosaicon,  db 0             ; mosaic on, bit 0=bg1,bit1=bg2, etc
	*(uint8 *)(&ZstData[0x69]) = PPU.Mosaic - 1;
	//00006a: NEWSYM mosaicsz,  db 0             ; mosaic size in pixels
	*(uint8 *)(&ZstData[0x6a]) = (uint8)((PPU.BGMosaic[0] & 1) |
												((PPU.BGMosaic[1] << 1) & 2) |
												((PPU.BGMosaic[2] << 2) & 4) |
												((PPU.BGMosaic[3] << 3) & 8));
	//00006b: NEWSYM bg1ptr,    dw 0             ; pointer to background1
	*(uint16 *)(&ZstData[0x6b]) = (uint16)(PPU.BG[0].SCBase << 1);
	//00006d: NEWSYM bg2ptr,    dw 0             ; pointer to background2
	*(uint16 *)(&ZstData[0x6d]) = (uint16)(PPU.BG[1].SCBase << 1);
	//00006f: NEWSYM bg3ptr,    dw 0             ; pointer to background3
	*(uint16 *)(&ZstData[0x6f]) = (uint16)(PPU.BG[2].SCBase << 1);
	//000071: NEWSYM bg4ptr,    dw 0             ; pointer to background4
	*(uint16 *)(&ZstData[0x71]) = (uint16)(PPU.BG[3].SCBase << 1);
	//000073: NEWSYM bg1ptrb,   dw 0             ; pointer to background1
	*(uint16 *)(&ZstData[0x73]) = (uint16)(PPU.BG[0].SCBase << 1);
	//000075: NEWSYM bg2ptrb,   dw 0             ; pointer to background2
	*(uint16 *)(&ZstData[0x75]) = (uint16)(PPU.BG[1].SCBase << 1);
	//000077: NEWSYM bg3ptrb,   dw 0             ; pointer to background3
	*(uint16 *)(&ZstData[0x77]) = (uint16)(PPU.BG[2].SCBase << 1);
	//000079: NEWSYM bg4ptrb,   dw 0             ; pointer to background4
	*(uint16 *)(&ZstData[0x79]) = (uint16)(PPU.BG[3].SCBase << 1);
	//00007b: NEWSYM bg1ptrc,   dw 0             ; pointer to background1
	*(uint16 *)(&ZstData[0x7b]) = (uint16)(PPU.BG[0].SCBase << 1);
	//00007d: NEWSYM bg2ptrc,   dw 0             ; pointer to background2
	*(uint16 *)(&ZstData[0x7d]) = (uint16)(PPU.BG[1].SCBase << 1);
	//00007f: NEWSYM bg3ptrc,   dw 0             ; pointer to background3
	*(uint16 *)(&ZstData[0x7f]) = (uint16)(PPU.BG[2].SCBase << 1);
	//000081: NEWSYM bg4ptrc,   dw 0             ; pointer to background4
	*(uint16 *)(&ZstData[0x81]) = (uint16)(PPU.BG[3].SCBase << 1);
	//000083: NEWSYM bg1ptrd,   dw 0             ; pointer to background1
	*(uint16 *)(&ZstData[0x83]) = (uint16)(PPU.BG[0].SCBase << 1);
	//000085: NEWSYM bg2ptrd,   dw 0             ; pointer to background2
	*(uint16 *)(&ZstData[0x85]) = (uint16)(PPU.BG[1].SCBase << 1);
	//000087: NEWSYM bg3ptrd,   dw 0             ; pointer to background3
	*(uint16 *)(&ZstData[0x87]) = (uint16)(PPU.BG[2].SCBase << 1);
	//000089: NEWSYM bg4ptrd,   dw 0             ; pointer to background4
	*(uint16 *)(&ZstData[0x89]) = (uint16)(PPU.BG[3].SCBase << 1);
	//00008b: NEWSYM bg1scsize, db 0             ; bg #1 screen size (0=1x1,1=1x2,2=2x1,3=2x2)
	*(uint8 *)(&ZstData[0x8b]) = (uint8)(PPU.BG[0].SCSize & 0xff);
	//00008c: NEWSYM bg2scsize, db 0             ; bg #2 screen size (0=1x1,1=1x2,2=2x1,3=2x2)
	*(uint8 *)(&ZstData[0x8c]) = (uint8)(PPU.BG[1].SCSize & 0xff);
	//00008d: NEWSYM bg3scsize, db 0             ; bg #3 screen size (0=1x1,1=1x2,2=2x1,3=2x2)
	*(uint8 *)(&ZstData[0x8d]) = (uint8)(PPU.BG[2].SCSize & 0xff);
	//00008e: NEWSYM bg4scsize, db 0             ; bg #4 screen size (0=1x1,1=1x2,2=2x1,3=2x2)
	*(uint8 *)(&ZstData[0x8e]) = (uint8)(PPU.BG[3].SCSize & 0xff);

	switch (PPU.BG[0].SCSize)
	{
		case 1:
			//000073: NEWSYM bg1ptrb,   dw 0             ; pointer to background1
			*(uint16 *)(&ZstData[0x73]) += 0x800;
			//000083: NEWSYM bg1ptrd,   dw 0             ; pointer to background1
			*(uint16 *)(&ZstData[0x83]) += 0x800;
			break;

		case 2:
			//00007b: NEWSYM bg1ptrc,   dw 0             ; pointer to background1
			*(uint16 *)(&ZstData[0x7b]) += 0x800;
			//000083: NEWSYM bg1ptrd,   dw 0             ; pointer to background1
			*(uint16 *)(&ZstData[0x83]) += 0x800;
			break;

		case 3:
			//000073: NEWSYM bg1ptrb,   dw 0             ; pointer to background1
			*(uint16 *)(&ZstData[0x73]) += 0x800;
			//00007b: NEWSYM bg1ptrc,   dw 0             ; pointer to background1
			*(uint16 *)(&ZstData[0x7b]) += 0x1000;
			//000083: NEWSYM bg1ptrd,   dw 0             ; pointer to background1
			*(uint16 *)(&ZstData[0x83]) += 0x1800;
			break;

		default:
			break;
	}
	switch (PPU.BG[1].SCSize)
	{
		case 1:
			//000075: NEWSYM bg2ptrb,   dw 0             ; pointer to background2
			*(uint16 *)(&ZstData[0x75]) += 0x800;
			//000085: NEWSYM bg2ptrd,   dw 0             ; pointer to background2
			*(uint16 *)(&ZstData[0x85]) += 0x800;
			break;

		case 2:
			//00007d: NEWSYM bg2ptrc,   dw 0             ; pointer to background2
			*(uint16 *)(&ZstData[0x7d]) += 0x800;
			//000085: NEWSYM bg2ptrd,   dw 0             ; pointer to background2
			*(uint16 *)(&ZstData[0x85]) += 0x800;
			break;

		case 3:
			//000075: NEWSYM bg2ptrb,   dw 0             ; pointer to background2
			*(uint16 *)(&ZstData[0x75]) += 0x800;
			//00007d: NEWSYM bg2ptrc,   dw 0             ; pointer to background2
			*(uint16 *)(&ZstData[0x7d]) += 0x1000;
			//000085: NEWSYM bg2ptrd,   dw 0             ; pointer to background2
			*(uint16 *)(&ZstData[0x85]) += 0x1800;
			break;

		default:
			break;
	}
	switch (PPU.BG[2].SCSize)
	{
		case 1:
			//000077: NEWSYM bg3ptrb,   dw 0             ; pointer to background3
			*(uint16 *)(&ZstData[0x77]) += 0x800;
			//000087: NEWSYM bg3ptrd,   dw 0             ; pointer to background3
			*(uint16 *)(&ZstData[0x87]) += 0x800;
			break;

		case 2:
			//00007f: NEWSYM bg3ptrc,   dw 0             ; pointer to background3
			*(uint16 *)(&ZstData[0x7f]) += 0x800;
			//000087: NEWSYM bg3ptrd,   dw 0             ; pointer to background3
			*(uint16 *)(&ZstData[0x87]) += 0x800;
			break;

		case 3:
			//000077: NEWSYM bg3ptrb,   dw 0             ; pointer to background3
			*(uint16 *)(&ZstData[0x77]) += 0x800;
			//00007f: NEWSYM bg3ptrc,   dw 0             ; pointer to background3
			*(uint16 *)(&ZstData[0x7f]) += 0x1000;
			//000087: NEWSYM bg3ptrd,   dw 0             ; pointer to background3
			*(uint16 *)(&ZstData[0x87]) += 0x1800;
			break;

		default:
			break;
	}
	switch (PPU.BG[3].SCSize)
	{
		case 1:
			//000079: NEWSYM bg4ptrb,   dw 0             ; pointer to background4
			*(uint16 *)(&ZstData[0x79]) += 0x800;
			//000089: NEWSYM bg4ptrd,   dw 0             ; pointer to background4
			*(uint16 *)(&ZstData[0x89]) += 0x800;
			break;

		case 2:
			//000081: NEWSYM bg4ptrc,   dw 0             ; pointer to background4
			*(uint16 *)(&ZstData[0x81]) += 0x800;
			//000089: NEWSYM bg4ptrd,   dw 0             ; pointer to background4
			*(uint16 *)(&ZstData[0x89]) += 0x800;
			break;

		case 3:
			//000079: NEWSYM bg4ptrb,   dw 0             ; pointer to background4
			*(uint16 *)(&ZstData[0x79]) += 0x800;
			//000081: NEWSYM bg4ptrc,   dw 0             ; pointer to background4
			*(uint16 *)(&ZstData[0x81]) += 0x1000;
			//000089: NEWSYM bg4ptrd,   dw 0             ; pointer to background4
			*(uint16 *)(&ZstData[0x89]) += 0x1800;
			break;

		default:
			break;
	}
	//00008f: NEWSYM bg1objptr, dw 0             ; pointer to tiles in background1
	*(uint16 *)(&ZstData[0x8f]) = (uint16)((Memory.FillRAM [0x210b] & 0x0f) << 13);
	//000091: NEWSYM bg2objptr, dw 0             ; pointer to tiles in background2
	*(uint16 *)(&ZstData[0x91]) = (uint16)((Memory.FillRAM [0x210b] & 0xf0) << 9);
	//000093: NEWSYM bg3objptr, dw 0             ; pointer to tiles in background3
	*(uint16 *)(&ZstData[0x93]) = (uint16)((Memory.FillRAM [0x210c] & 0x0f) << 13);
	//000095: NEWSYM bg4objptr, dw 0             ; pointer to tiles in background4
	*(uint16 *)(&ZstData[0x95]) = (uint16)((Memory.FillRAM [0x210c] & 0xf0) << 9);
	//000097: NEWSYM bg1scrolx, dw 0             ; background 1 x position
	*(uint16 *)(&ZstData[0x97]) = PPU.BG[0].HOffset;
	//000099: NEWSYM bg2scrolx, dw 0             ; background 2 x position
	*(uint16 *)(&ZstData[0x99]) = PPU.BG[1].HOffset;
	//00009b: NEWSYM bg3scrolx, dw 0             ; background 3 x position
	*(uint16 *)(&ZstData[0x9b]) = PPU.BG[2].HOffset;
	//00009d: NEWSYM bg4scrolx, dw 0             ; background 4 x position
	*(uint16 *)(&ZstData[0x9d]) = PPU.BG[3].HOffset;
	//00009f: NEWSYM bg1sx,     dw 0             ; Temporary Variable for Debugging purposes
	*(uint16 *)(&ZstData[0x9f]) = (uint16)(Memory.FillRAM [0x212a]);
	//0000a1: NEWSYM bg1scroly, dw 0             ; background 1 y position
	*(uint16 *)(&ZstData[0xa1]) = PPU.BG[0].VOffset;
	//0000a3: NEWSYM bg2scroly, dw 0             ; background 2 y position
	*(uint16 *)(&ZstData[0xa3]) = PPU.BG[1].VOffset;
	//0000a5: NEWSYM bg3scroly, dw 0             ; background 3 y position
	*(uint16 *)(&ZstData[0xa5]) = PPU.BG[2].VOffset;
	//0000a7: NEWSYM bg4scroly, dw 0             ; background 4 y position
	*(uint16 *)(&ZstData[0xa7]) = PPU.BG[3].VOffset;
	//0000a9: NEWSYM addrincr,  dw 2             ; vram increment (2,64,128,256)
	*(uint16 *)(&ZstData[0xa9]) = (uint16)PPU.VMA.Increment << 1;
	//0000ab: NEWSYM vramincr,  db 0             ; 0 = inrement at 2118/2139, 1 = 2119,213A
	*(uint8 *)(&ZstData[0xab]) = PPU.VMA.High;
	//0000ac: NEWSYM vramread,  db 0             ; 0 = address set, 1 = already read once
	*(uint8 *)(&ZstData[0xac]) = (uint8)(0)/*(uint8)(IPPU.FirstVRAMRead ? 0 : 1)*/;
	//0000ad: NEWSYM vramaddr,  dd 0             ; vram address
	*(uint32 *)(&ZstData[0xad]) = (uint32)PPU.VMA.Address;
	//0000b1: NEWSYM cgaddr,    dw 0             ; cg (palette) address
	*(uint16 *)(&ZstData[0xb1]) = (uint16)PPU.CGADD;
	//0000b3: NEWSYM cgmod,     db 0             ; if cgram is modified or not
	*(uint8 *)(&ZstData[0xb3]) = (uint8)IPPU.ColorsChanged;
	//0000b4: NEWSYM scrnon,    dw 0             ; main & sub screen on
	*(uint16 *)(&ZstData[0xb4]) = *(uint16 *)(&Memory.FillRAM [0x212c]);
	//0000b6: NEWSYM scrndist,  db 0             ; which background is disabled
	*(uint8 *)(&ZstData[0xb6]) = 0;
	//0000b7: NEWSYM resolutn,  dw 224           ; screen resolution
	*(uint16 *)(&ZstData[0xb7]) = PPU.ScreenHeight;
	//0000b9: NEWSYM multa,     db 0             ; multiplier A
	*(uint8 *)(&ZstData[0xb9]) = Memory.FillRAM [0x4202];
	//0000ba: NEWSYM diva,      dw 0             ; divisor C
	*(uint16 *)(&ZstData[0xba]) = *(uint16 *)(&Memory.FillRAM [0x4204]);
	//0000bc: NEWSYM divres,    dw 0             ; quotent of divc/divb
	*(uint16 *)(&ZstData[0xbc]) = *(uint16 *)(&Memory.FillRAM [0x4214]);
	//0000be: NEWSYM multres,   dw 0             ; result of multa * multb/remainder of divc/divb
	*(uint16 *)(&ZstData[0xbe]) = *(uint16 *)(&Memory.FillRAM [0x4216]);
	//0000c0: NEWSYM latchx,    dw 0             ; latched x value
	*(uint16 *)(&ZstData[0xc0]) = PPU.HBeamPosLatched;
	//0000c2: NEWSYM latchy,    dw 0             ; latched y value
	*(uint16 *)(&ZstData[0xc2]) = PPU.VBeamPosLatched;
	//0000c4: NEWSYM latchxr,   db 0             ; low or high byte read for x value
	*(uint8 *)(&ZstData[0xc4]) = PPU.HBeamFlip;
	//0000c5: NEWSYM latchyr,   db 0             ; low or high byte read for y value
	*(uint8 *)(&ZstData[0xc5]) = PPU.VBeamFlip;
	//0000c6: NEWSYM frskipper, db 0             ; used to control frame skipping
	*(uint8 *)(&ZstData[0xc6]) = 0;
	//0000c7: NEWSYM winl1,     db 0             ; window 1 left position
	*(uint8 *)(&ZstData[0xc7]) = PPU.Window1Left;
	//0000c8: NEWSYM winr1,     db 0             ; window 1 right position
	*(uint8 *)(&ZstData[0xc8]) = PPU.Window1Right;
	//0000c9: NEWSYM winl2,     db 0             ; window 2 left position
	*(uint8 *)(&ZstData[0xc9]) = PPU.Window2Left;
	//0000ca: NEWSYM winr2,     db 0             ; window 2 right position
	*(uint8 *)(&ZstData[0xca]) = PPU.Window2Right;
	//0000cb: NEWSYM winbg1en,  db 0             ; Win1 on (IN/OUT) or Win2 on (IN/OUT) on BG1
	*(uint8 *)(&ZstData[0xcb]) = Memory.FillRAM[0x2123] & 0x0f;
	//0000cc: NEWSYM winbg2en,  db 0             ; Win1 on (IN/OUT) or Win2 on (IN/OUT) on BG2
	*(uint8 *)(&ZstData[0xcc]) = ((Memory.FillRAM[0x2123] & 0xf0) >> 4);
	//0000cd: NEWSYM winbg3en,  db 0             ; Win1 on (IN/OUT) or Win2 on (IN/OUT) on BG3
	*(uint8 *)(&ZstData[0xcd]) = Memory.FillRAM[0x2124] & 0x0f;
	//0000ce: NEWSYM winbg4en,  db 0             ; Win1 on (IN/OUT) or Win2 on (IN/OUT) on BG4
	*(uint8 *)(&ZstData[0xce]) = ((Memory.FillRAM[0x2124] & 0xf0) >> 4);
	//0000cf: NEWSYM winobjen,  db 0             ; Win1 on (IN/OUT) or Win2 on (IN/OUT) on sprites
	*(uint8 *)(&ZstData[0xcf]) = Memory.FillRAM[0x2125] & 0x0f;
	//0000d0: NEWSYM wincolen,  db 0             ; Win1 on (IN/OUT) or Win2 on (IN/OUT) on backarea
	*(uint8 *)(&ZstData[0xd0]) = ((Memory.FillRAM[0x2125] & 0xf0) >> 4);
	//0000d1: NEWSYM winlogica, db 0             ; Window logic type for BG1 to 4
	*(uint8 *)(&ZstData[0xd1]) = Memory.FillRAM[0x212a];
	//0000d2: NEWSYM winlogicb, db 0             ; Window logic type for Sprites and Backarea
	*(uint8 *)(&ZstData[0xd2]) = Memory.FillRAM[0x212b];
	//0000d3: NEWSYM winenabm,  db 0             ; Window logic enable for main screen
	*(uint8 *)(&ZstData[0xd3]) = Memory.FillRAM[0x212e];
	//0000d4: NEWSYM winenabs,  db 0             ; Window logic enable for sub screen
	*(uint8 *)(&ZstData[0xd4]) = Memory.FillRAM[0x212f];
	//0000d5: NEWSYM mode7set,  db 0             ; mode 7 settings
	*(uint8 *)(&ZstData[0xd5]) = Memory.FillRAM[0x211a];
	//0000d6: NEWSYM mode7A,    dw 0             ; A value for Mode 7
	*(short *)(&ZstData[0xd6]) = PPU.MatrixA;
	//0000d8: NEWSYM mode7B,    dw 0             ; B value for Mode 7
	*(short *)(&ZstData[0xd8]) = PPU.MatrixB;
	//0000da: NEWSYM mode7C,    dw 0             ; C value for Mode 7
	*(short *)(&ZstData[0xda]) = PPU.MatrixC;
	//0000dc: NEWSYM mode7D,    dw 0             ; D value for Mode 7
	*(short *)(&ZstData[0xdc]) = PPU.MatrixD;
	//0000de: NEWSYM mode7X0,   dw 0             ; Center X for Mode 7
	*(short *)(&ZstData[0xde]) = PPU.CentreX;
	//0000e0: NEWSYM mode7Y0,   dw 0             ; Center Y for Mode 7
	*(short *)(&ZstData[0xe0]) = PPU.CentreY;
	//0000e2: NEWSYM JoyAPos,   db 0             ; Old-Style Joystick Read Position for Joy 1 & 3
	*(uint8 *)(&ZstData[0xe2]) = 0;
	//0000e3: NEWSYM JoyBPos,   db 0             ; Old-Style Joystick Read Position for Joy 2 & 4
	*(uint8 *)(&ZstData[0xe3]) = 0;
	//0000e4: NEWSYM compmult,  dd 0             ; Complement Multiplication for Mode 7
	*(uint8 *)(&ZstData[0xe4]) = Memory.FillRAM [0x2134];
	*(uint8 *)(&ZstData[0xe5]) = Memory.FillRAM [0x2135];
	*(uint8 *)(&ZstData[0xe6]) = Memory.FillRAM [0x2136];
	*(uint8 *)(&ZstData[0xe7]) = 0;
	//0000e8: NEWSYM joyalt,    db 0             ; temporary joystick alternation
	*(uint8 *)(&ZstData[0xe8]) = 0;
	//0000e9: NEWSYM wramrwadr, dd 0             ; continuous read/write to wram address
	*(uint32 *)(&ZstData[0xe9]) = PPU.WRAM;
	//0000ed: NEWSYM dmadata, times 129 db 0h  ; dma data (written from ports 43xx)
	memmove(&ZstData[0xed], &Memory.FillRAM[0x4300], 0x81);
	//00016e: NEWSYM irqon,     db 0             ; if IRQ has been called (80h) or not (0)
	*(uint8 *)(&ZstData[0x16e]) = (((CPU.IRQActive & PPU_V_BEAM_IRQ_SOURCE) && (CPU.IRQActive & PPU_H_BEAM_IRQ_SOURCE)) ? 0x80 : 0);
	//00016f: NEWSYM nexthdma,  db 0             ; HDMA data to execute once vblank ends
	*(uint8 *)(&ZstData[0x16f]) = Memory.FillRAM[0x420c];
	//000170: NEWSYM curhdma,   db 0             ; Currently executed hdma
	*(uint8 *)(&ZstData[0x170]) = Memory.FillRAM[0x420c];
	//000171: NEWSYM hdmadata, times 8*19 db 0   ; 4 dword register addresses, # of bytes to
	//                                           ; transfer/line, address increment (word)
	//000209: NEWSYM hdmatype,  db 0             ; if first time executing hdma or not
	*(uint8 *)(&ZstData[0x209]) = Memory.FillRAM[0x420c];
	//00020a: NEWSYM coladdr,   db 0             ; red value of color to add
	*(uint8 *)(&ZstData[0x20a]) = PPU.FixedColourRed;
	//00020b: NEWSYM coladdg,   db 0             ; green value of color to add
	*(uint8 *)(&ZstData[0x20b]) = PPU.FixedColourGreen;
	//00020c: NEWSYM coladdb,   db 0             ; blue value of color to add
	*(uint8 *)(&ZstData[0x20c]) = PPU.FixedColourBlue;
	//00020d: NEWSYM colnull,   db 0             ; keep this 0 (when accessing colors by dword)
	*(uint8 *)(&ZstData[0x20d]) = 0;
	//00020e: NEWSYM scaddset,  db 0             ; screen/fixed color addition settings
	*(uint8 *)(&ZstData[0x20e]) = Memory.FillRAM[0x2130];
	//00020f: NEWSYM scaddtype, db 0             ; which screen to add/sub
	*(uint8 *)(&ZstData[0x20f]) = Memory.FillRAM[0x2131];
	//000210: NEWSYM Voice0Disabl2, db 1         ; Disable Voice 0
	*(uint8 *)(&ZstData[0x210]) = 1;
	//000211: NEWSYM Voice1Disabl2, db 1         ; Disable Voice 1
	*(uint8 *)(&ZstData[0x211]) = 1;
	//000212: NEWSYM Voice2Disabl2, db 1         ; Disable Voice 2
	*(uint8 *)(&ZstData[0x212]) = 1;
	//000213: NEWSYM Voice3Disabl2, db 1         ; Disable Voice 3
	*(uint8 *)(&ZstData[0x213]) = 1;
	//000214: NEWSYM Voice4Disabl2, db 1         ; Disable Voice 4
	*(uint8 *)(&ZstData[0x214]) = 1;
	//000215: NEWSYM Voice5Disabl2, db 1         ; Disable Voice 5
	*(uint8 *)(&ZstData[0x215]) = 1;
	//000216: NEWSYM Voice6Disabl2, db 1         ; Disable Voice 6
	*(uint8 *)(&ZstData[0x216]) = 1;
	//000217: NEWSYM Voice7Disabl2, db 1         ; Disable Voice 7
	*(uint8 *)(&ZstData[0x217]) = 1;
	//000218: NEWSYM oamram,  times 1024 db 0    ; OAMRAM (544 bytes)
	memmove (&ZstData[0x218], PPU.OAMData, 544);
	//000618: NEWSYM cgram,   times 512 db 0     ; CGRAM
	memmove (&ZstData[0x618], PPU.CGDATA, 512);
	//000818: NEWSYM pcgram,  times 512 db 0     ; Previous CGRAM
	memmove (&ZstData[0x618], PPU.CGDATA, 512);
	//000a18: NEWSYM vraminctype,  db 0
	*(uint8 *)(&ZstData[0xa18]) = Memory.FillRAM[0x2115];
	//000a19: NEWSYM vramincby8on,   db 0        ; if increment by 8 is on
	*(uint8 *)(&ZstData[0xa19]) = (Memory.FillRAM[0x2115] & 0x0c) != 0;
	//000a1b: NEWSYM vramincby8totl, db 0        ; how many in total (32,64,128)
	*(uint8 *)(&ZstData[0xa1b]) = (uint8)(PPU.VMA.Shift & 0xff);

	//not complete..
	switch (Memory.FillRAM[0x2115] & 0x0c)
	{
		case 4:
			//000a1a: NEWSYM vramincby8left, db 0        ; how many left
			*(uint8 *)(&ZstData[0xa1a]) = 1;
			//000a1d: NEWSYM vramincby8ptri, dw 0        ; increment by how many when rowl = 0
			*(uint16 *)(&ZstData[0xa1d]) = 65535-511;
			//000a21: NEWSYM vramincby8var,  dw 0
			*(uint16 *)(&ZstData[0xa21]) = 256+128+64;
			break;

		case 8:
			//000a1a: NEWSYM vramincby8left, db 0        ; how many left
			*(uint8 *)(&ZstData[0xa1a]) = 1;
			//000a1d: NEWSYM vramincby8ptri, dw 0        ; increment by how many when rowl = 0
			*(uint16 *)(&ZstData[0xa1d]) = 65535-1023;
			//000a21: NEWSYM vramincby8var,  dw 0
			*(uint16 *)(&ZstData[0xa21]) = 512+256+128;
			break;

		case 12:
			//000a1a: NEWSYM vramincby8left, db 0        ; how many left
			*(uint8 *)(&ZstData[0xa1a]) = 1;
			//000a1d: NEWSYM vramincby8ptri, dw 0        ; increment by how many when rowl = 0
			*(uint16 *)(&ZstData[0xa1d]) = 65535-2047;
			//000a21: NEWSYM vramincby8var,  dw 0
			*(uint16 *)(&ZstData[0xa21]) = 1024+512+256;
			break;

		default:
			//000a1a: NEWSYM vramincby8left, db 0        ; how many left
			*(uint8 *)(&ZstData[0xa1a]) = 0;
			//000a1d: NEWSYM vramincby8ptri, dw 0        ; increment by how many when rowl = 0
			*(uint16 *)(&ZstData[0xa1d]) = 0;
			//000a21: NEWSYM vramincby8var,  dw 0
			*(uint16 *)(&ZstData[0xa21]) = 0;
			break;
	}
	//000a1c: NEWSYM vramincby8rowl, db 0        ; how many left in that row (start at 8)
	*(uint8 *)(&ZstData[0xa1c]) = 1;
	//000a1f: NEWSYM nexthprior,     db 0
	*(uint8 *)(&ZstData[0xa1f]) = PPU.OAMPriorityRotation;
	//000a20: NEWSYM doirqnext,      db 0
	*(uint8 *)(&ZstData[0xa20]) = 0;
	//000a23: NEWSYM screstype,      db 0
	*(uint8 *)(&ZstData[0xa23]) = 0;
	//000a24: NEWSYM extlatch,       db 0
	*(uint8 *)(&ZstData[0xa24]) = 0;
	//000a25: NEWSYM cfield,         db 0
	*(uint8 *)(&ZstData[0xa25]) = 0;
	//000a26: NEWSYM interlval,      db 0
	*(uint8 *)(&ZstData[0xa26]) = Memory.FillRAM [0x2133];
	//000a27: NEWSYM HIRQLoc,   dw 0             ; HIRQ X location
	*(uint16 *)(&ZstData[0xa27]) = *(uint16 *)(&Memory.FillRAM [0x4207]);
	//000a29: NEWSYM KeyOnStA, db 0
	*(uint8 *)(&ZstData[0xa29]) = 0;
	//000a2a: NEWSYM KeyOnStB, db 0
	*(uint8 *)(&ZstData[0xa2a]) = 0;
	//000a2b: NEWSYM SDD1BankA, db 0
	*(uint8 *)(&ZstData[0xa2b]) = 0;
	//000a2c: NEWSYM SDD1BankB, db 1
	*(uint8 *)(&ZstData[0xa2c]) = 1;
	//000a2d: NEWSYM SDD1BankC, db 2
	*(uint8 *)(&ZstData[0xa2d]) = 2;
	//000a2e: NEWSYM SDD1BankD, db 3
	*(uint8 *)(&ZstData[0xa2e]) = 3;
	//000a2f: NEWSYM tempdat, times 484 db 0     ; expandable area

	//000c13: NEWSYM wramdataa, times 65536 db 0
	//        NEWSYM ram7fa,    times 65536 db 0
	memmove(&ZstData[0xc13], Memory.RAM, 128 * 1024);
	//020c13: NEWSYM vram,          dd 0              ; vram = 65536
	//        NEWSYM vrama,       times 65536 db 0
	memmove(&ZstData[0x20c13], Memory.VRAM, 64 * 1024);

/*
NEWSYM spcRam,   times 65472 db 0FFh  ; Pointer to the SPC's RAM
; copy #1
; THE SPC ROM :)
   db 0CDh,0EFh,0BDh,0E8h,000h,0C6h,01Dh,0D0h,0FCh,08Fh,0AAh,0F4h,08Fh,0BBh,0F5h,078h
   db 0CCh,0F4h,0D0h,0FBh,02Fh,019h,0EBh,0F4h,0D0h,0FCh,07Eh,0F4h,0D0h,00Bh,0E4h,0F5h
   db 0CBh,0F4h,0D7h,000h,0FCh,0D0h,0F3h,0ABh,001h,010h,0EFh,07Eh,0F4h,010h,0EBh,0BAh
   db 0F6h,0DAh,000h,0BAh,0F4h,0C4h,0F4h,0DDh,05Dh,0D0h,0DBh,01Fh,000h,000h,0C0h,0FFh
   db 0AAh,0BBh,0CCh,0DDh,0EEh,0FFh,000h,011h,022h,033h,044h,055h,066h,077h,088h,099h

NEWSYM spcPCRam,
         dd 0     ; Program Counter (with spcRam added)
NEWSYM spcA,
         db 0     ; The A register (general purpose)
         db 0
         db 0
         db 0
NEWSYM spcX,
         db 0     ; The X register (general purpose)
         db 0
         db 0
         db 0
NEWSYM spcY,
         db 0     ; The Y register (general purpose)
         db 0
         db 0
         db 0
NEWSYM spcP,
         db 0     ; The processor status byte (Removed for each flags)
         db 0     ; NZ are not always processed...
         db 0
         db 0
NEWSYM spcNZ,
         db 0     ; The processor NZ flag (little speed up hack :) )
         db 0
         db 0
         db 0


;spcNF    db 0     ; The Negative Flag  128 or 127
;spcOF    db 0     ; The Overflow Flag   64 or 191
;spcDPF   db 0     ; Direct Page Flag    32 or 223
;spcUF    db 0     ; The Unused Flag ?   16 or 239
;spcHCF   db 0     ; The Half Carry Flag  8 or 247
;spcIF    db 0     ; The interrupt flag   4 or 251
;spcZF    db 0     ; The Zero Flag        2 or 253
;spcCF    db 0     ; The Carry Flag       1 or 254

NEWSYM spcS,     dd 1FFh   ; The stack pointer (always from 100 to 1FF) (added Ram)
NEWSYM spcRamDP, dd 0     ; The direct page pointer 
NEWSYM spcCycle, dd 0     ; The Cycle Counter
NEWSYM reg1read, db 0     ; read from 65816
NEWSYM reg2read, db 0     ; read from 65816
NEWSYM reg3read, db 0     ; read from 65816
NEWSYM reg4read, db 0     ; read from 65816
NEWSYM timeron,  db 0     ; timer0 on
NEWSYM timincr0, db 0     ; # of ticks before incrementing
NEWSYM timincr1, db 0     ; # of ticks before incrementing
NEWSYM timincr2, db 0     ; # of ticks before incrementing
NEWSYM timinl0,  db 0     ; ticks left before incrementing
NEWSYM timinl1,  db 0     ; ticks left before incrementing
NEWSYM timinl2,  db 0     ; ticks left before incrementing
NEWSYM timrcall, db 0     ; alternating bit 0 to correctly timer timer1 & 2 to 8000hz

NEWSYM spcextraram, times 64 db 0 ; extra ram, used for tcall

NEWSYM FutureExpandS,  times 256-64 db 0

spcsave equ $-spcRam
; pharos equ hack *sigh*
NEWSYM PHspcsave, dd spcsave

; copy #2
NEWSYM SPCROM
   db 0CDh,0EFh,0BDh,0E8h,000h,0C6h,01Dh,0D0h,0FCh,08Fh,0AAh,0F4h,08Fh,0BBh,0F5h,078h
   db 0CCh,0F4h,0D0h,0FBh,02Fh,019h,0EBh,0F4h,0D0h,0FCh,07Eh,0F4h,0D0h,00Bh,0E4h,0F5h
   db 0CBh,0F4h,0D7h,000h,0FCh,0D0h,0F3h,0ABh,001h,010h,0EFh,07Eh,0F4h,010h,0EBh,0BAh
   db 0F6h,0DAh,000h,0BAh,0F4h,0C4h,0F4h,0DDh,05Dh,0D0h,0DBh,01Fh,000h,000h,0C0h,0FFh
*/

	if (Settings.APUEnabled)
	{
		//030c13: NEWSYM spcRam,   times 65472 db 0FFh  ; Pointer to the SPC's RAM
		//        ; copy #1
		//        ; THE SPC ROM :)
		//           db 0CDh,0EFh,0BDh,0E8h,000h,0C6h,01Dh,0D0h,0FCh,08Fh,0AAh,0F4h,08Fh,0BBh,0F5h,078h
		//           db 0CCh,0F4h,0D0h,0FBh,02Fh,019h,0EBh,0F4h,0D0h,0FCh,07Eh,0F4h,0D0h,00Bh,0E4h,0F5h
		//           db 0CBh,0F4h,0D7h,000h,0FCh,0D0h,0F3h,0ABh,001h,010h,0EFh,07Eh,0F4h,010h,0EBh,0BAh
		//           db 0F6h,0DAh,000h,0BAh,0F4h,0C4h,0F4h,0DDh,05Dh,0D0h,0DBh,01Fh,000h,000h,0C0h,0FFh
		memmove(&ZstData[0x30c13], IAPU.RAM, 0x10000);
		//040c13:    db 0AAh,0BBh,0CCh,0DDh,0EEh,0FFh,000h,011h,022h,033h,044h,055h,066h,077h,088h,099h
		static unsigned char zsapuromjunk[] = {0xaa, 0xbb, 0xcc, 0xdd, 0xee, 0xff, 0x00, 0x11, 0x22, 0x33, 0x44, 0x55, 0x66, 0x77, 0x88, 0x99};
		memmove(&ZstData[0x40c13], zsapuromjunk, 16);
		//040c23: NEWSYM spcPCRam,
		//                 dd 0     ; Program Counter (with spcRam added)
		*(uint32 *)(&ZstData[0x40c23]) = (uint32)APURegisters.PC;
		//040c27: NEWSYM spcA,
		//                 db 0     ; The A register (general purpose)
		//                 db 0
		//                 db 0
		//                 db 0
		*(uint8 *)(&ZstData[0x40c27]) = APURegisters.YA.B.A;
		//040c2b: NEWSYM spcX,
		//                 db 0     ; The X register (general purpose)
		//                 db 0
		//                 db 0
		//                 db 0
		*(uint8 *)(&ZstData[0x40c2b]) = APURegisters.X;
		//040c2f: NEWSYM spcY,
		//                 db 0     ; The Y register (general purpose)
		//                 db 0
		//                 db 0
		//                 db 0
		*(uint8 *)(&ZstData[0x40c2f]) = APURegisters.YA.B.Y;
		//040c33: NEWSYM spcP,
		//                 db 0     ; The processor status byte (Removed for each flags)
		//                 db 0     ; NZ are not always processed...
		//                 db 0
		//                 db 0
		*(uint8 *)(&ZstData[0x40c33]) = APURegisters.P;
		//040c37: NEWSYM spcNZ,
		//                 db 0     ; The processor NZ flag (little speed up hack :) )
		//                 db 0
		//                 db 0
		//                 db 0


		//040c3b: NEWSYM spcS,     dd 1FFh   ; The stack pointer (always from 100 to 1FF) (added Ram)
		*(uint32 *)(&ZstData[0x40c3b]) = (uint32)(APURegisters.S | 0x100);
		//040c3f: NEWSYM spcRamDP, dd 0     ; The direct page pointer 
		
		//040c43: NEWSYM spcCycle, dd 0     ; The Cycle Counter
		*(int32 *)(&ZstData[0x40c43]) = APU.Cycles;
		//040c47: NEWSYM reg1read, db 0     ; read from 65816
		*(uint8 *)(&ZstData[0x40c47]) = APU.OutPorts [0];
		//040c48: NEWSYM reg2read, db 0     ; read from 65816
		*(uint8 *)(&ZstData[0x40c48]) = APU.OutPorts [1];
		//040c49: NEWSYM reg3read, db 0     ; read from 65816
		*(uint8 *)(&ZstData[0x40c49]) = APU.OutPorts [2];
		//040c4a: NEWSYM reg4read, db 0     ; read from 65816
		*(uint8 *)(&ZstData[0x40c4a]) = APU.OutPorts [3];
		//040c4b: NEWSYM timeron,  db 0     ; timer0 on
		*(uint8 *)(&ZstData[0x40c4b]) = (uint8)((APU.TimerEnabled[0] ? 1 : 0) | (APU.TimerEnabled[1] ? 2 : 0) | (APU.TimerEnabled [2] ? 4 : 0));
		//040c4c: NEWSYM timincr0, db 0     ; # of ticks before incrementing
		*(uint8 *)(&ZstData[0x40c4c]) = (uint8)(APU.TimerValueWritten[0] ? (IAPU.RAM [0xfa]) : 0);
		//040c4d: NEWSYM timincr1, db 0     ; # of ticks before incrementing
		*(uint8 *)(&ZstData[0x40c4d]) = (uint8)(APU.TimerValueWritten[1] ? (IAPU.RAM [0xfb]) : 0);
		//040c4e: NEWSYM timincr2, db 0     ; # of ticks before incrementing
		*(uint8 *)(&ZstData[0x40c4e]) = (uint8)(APU.TimerValueWritten[2] ? (IAPU.RAM [0xfc]) : 0);
		//040c4f: NEWSYM timinl0,  db 0     ; ticks left before incrementing
		*(uint8 *)(&ZstData[0x40c4f]) = (uint8)(APU.Timer[0] & 0xff);
		//040c50: NEWSYM timinl1,  db 0     ; ticks left before incrementing
		*(uint8 *)(&ZstData[0x40c50]) = (uint8)(APU.Timer[1] & 0xff);
		//040c51: NEWSYM timinl2,  db 0     ; ticks left before incrementing
		*(uint8 *)(&ZstData[0x40c51]) = (uint8)(APU.Timer[2] & 0xff);
		//040c52: NEWSYM timrcall, db 0     ; alternating bit 0 to correctly timer timer1 & 2 to 8000hz
		
		//040c53: NEWSYM spcextraram, times 64 db 0 ; extra ram, used for tcall
		memmove (&ZstData[0x40c53], APU.ExtraRAM, 64);
		//040c93: NEWSYM FutureExpandS,  times 256-64 db 0
		
/*

NEWSYM BRRBuffer, times 32 db 0   ; The BRR Decode Buffer

NEWSYM BRRPlace0, dd 0             ; Place in the BRRBuffer for Voice 0
NEWSYM BRRTemp0,  dd 0             ; Keep this 0
NEWSYM BRRPlace1, dd 0             ; Place in the BRRBuffer for Voice 0
NEWSYM BRRTemp1,  dd 0             ; Keep this 0
NEWSYM BRRPlace2, dd 0             ; Place in the BRRBuffer for Voice 0
NEWSYM BRRTemp2,  dd 0             ; Keep this 0
NEWSYM BRRPlace3, dd 0             ; Place in the BRRBuffer for Voice 0
NEWSYM BRRTemp3,  dd 0             ; Keep this 0
NEWSYM BRRPlace4, dd 0             ; Place in the BRRBuffer for Voice 0
NEWSYM BRRTemp4,  dd 0             ; Keep this 0
NEWSYM BRRPlace5, dd 0             ; Place in the BRRBuffer for Voice 0
NEWSYM BRRTemp5,  dd 0             ; Keep this 0
NEWSYM BRRPlace6, dd 0             ; Place in the BRRBuffer for Voice 0
NEWSYM BRRTemp6,  dd 0             ; Keep this 0
NEWSYM BRRPlace7, dd 0             ; Place in the BRRBuffer for Voice 0
NEWSYM BRRTemp7,  dd 0             ; Keep this 0

NEWSYM Voice0Freq, dd 1            ; Frequency of Voice 0 (Delta Freq)
NEWSYM Voice1Freq, dd 1            ; Frequency of Voice 1 (Delta Freq)
NEWSYM Voice2Freq, dd 1            ; Frequency of Voice 2 (Delta Freq)
NEWSYM Voice3Freq, dd 1            ; Frequency of Voice 3 (Delta Freq)
NEWSYM Voice4Freq, dd 1            ; Frequency of Voice 4 (Delta Freq)
NEWSYM Voice5Freq, dd 1            ; Frequency of Voice 5 (Delta Freq)
NEWSYM Voice6Freq, dd 1            ; Frequency of Voice 6 (Delta Freq)
NEWSYM Voice7Freq, dd 1            ; Frequency of Voice 7 (Delta Freq)

; appears to only be used in dspproc.asm
Voice0Pitch dw 1            ; Previous Pitch for Voice 0
Voice1Pitch dw 1            ; Previous Pitch for Voice 1
Voice2Pitch dw 1            ; Previous Pitch for Voice 2
Voice3Pitch dw 1            ; Previous Pitch for Voice 3
Voice4Pitch dw 1            ; Previous Pitch for Voice 4
Voice5Pitch dw 1            ; Previous Pitch for Voice 5
Voice6Pitch dw 1            ; Previous Pitch for Voice 6
Voice7Pitch dw 1            ; Previous Pitch for Voice 7


NEWSYM Voice0Status,   db 0 ; 0=Not Playing 1=Playing
NEWSYM Voice1Status,   db 0 
NEWSYM Voice2Status,   db 0
NEWSYM Voice3Status,   db 0
NEWSYM Voice4Status,   db 0
NEWSYM Voice5Status,   db 0
NEWSYM Voice6Status,   db 0
NEWSYM Voice7Status,   db 0

NEWSYM Voice0Ptr,      dd 0 ; Ptr to Next BRR Block to be played
NEWSYM Voice1Ptr,      dd 0
NEWSYM Voice2Ptr,      dd 0
NEWSYM Voice3Ptr,      dd 0
NEWSYM Voice4Ptr,      dd 0
NEWSYM Voice5Ptr,      dd 0
NEWSYM Voice6Ptr,      dd 0
NEWSYM Voice7Ptr,      dd 0
NEWSYM Voice0LoopPtr,  dd 0 ; Ptr to Loop BRR Block to be played
NEWSYM Voice1LoopPtr,  dd 0 ; Ptr to Loop BRR Block to be played
NEWSYM Voice2LoopPtr,  dd 0 ; Ptr to Loop BRR Block to be played
NEWSYM Voice3LoopPtr,  dd 0 ; Ptr to Loop BRR Block to be played
NEWSYM Voice4LoopPtr,  dd 0 ; Ptr to Loop BRR Block to be played
NEWSYM Voice5LoopPtr,  dd 0 ; Ptr to Loop BRR Block to be played
NEWSYM Voice6LoopPtr,  dd 0 ; Ptr to Loop BRR Block to be played
NEWSYM Voice7LoopPtr,  dd 0 ; Ptr to Loop BRR Block to be played

NEWSYM Voice0BufPtr,  dd 0 ; Ptr to Buffer Block to be played
NEWSYM Voice1BufPtr,  dd 0 ; Ptr to Buffer Block to be played
NEWSYM Voice2BufPtr,  dd 0 ; Ptr to Buffer Block to be played
NEWSYM Voice3BufPtr,  dd 0 ; Ptr to Buffer Block to be played
NEWSYM Voice4BufPtr,  dd 0 ; Ptr to Buffer Block to be played
NEWSYM Voice5BufPtr,  dd 0 ; Ptr to Buffer Block to be played
NEWSYM Voice6BufPtr,  dd 0 ; Ptr to Buffer Block to be played
NEWSYM Voice7BufPtr,  dd 0 ; Ptr to Buffer Block to be played

NEWSYM SoundCounter,   dd 0 ; Counter used for sound generation
NEWSYM SoundCounter2,  dd 0 ; Counter used for sound generation
NEWSYM Voice0Prev0,    dd 0 
NEWSYM Voice1Prev0,    dd 0 
NEWSYM Voice2Prev0,    dd 0 
NEWSYM Voice3Prev0,    dd 0 
NEWSYM Voice4Prev0,    dd 0 
NEWSYM Voice5Prev0,    dd 0 
NEWSYM Voice6Prev0,    dd 0 
NEWSYM Voice7Prev0,    dd 0 
NEWSYM Voice0Prev1,    dd 0 
NEWSYM Voice1Prev1,    dd 0 
NEWSYM Voice2Prev1,    dd 0 
NEWSYM Voice3Prev1,    dd 0 
NEWSYM Voice4Prev1,    dd 0 
NEWSYM Voice5Prev1,    dd 0 
NEWSYM Voice6Prev1,    dd 0 
NEWSYM Voice7Prev1,    dd 0 

NEWSYM Voice0Loop,     db 0
NEWSYM Voice1Loop,     db 0
NEWSYM Voice2Loop,     db 0
NEWSYM Voice3Loop,     db 0
NEWSYM Voice4Loop,     db 0
NEWSYM Voice5Loop,     db 0
NEWSYM Voice6Loop,     db 0
NEWSYM Voice7Loop,     db 0

NEWSYM Voice0End,      db 0
NEWSYM Voice1End,      db 0
NEWSYM Voice2End,      db 0
NEWSYM Voice3End,      db 0
NEWSYM Voice4End,      db 0
NEWSYM Voice5End,      db 0
NEWSYM Voice6End,      db 0
NEWSYM Voice7End,      db 0

NEWSYM Voice0Noise,    db 1
NEWSYM Voice1Noise,    db 1
NEWSYM Voice2Noise,    db 1
NEWSYM Voice3Noise,    db 1
NEWSYM Voice4Noise,    db 1
NEWSYM Voice5Noise,    db 1
NEWSYM Voice6Noise,    db 1
NEWSYM Voice7Noise,    db 1

NEWSYM Voice0Volume,   db 0
NEWSYM Voice1Volume,   db 0
NEWSYM Voice2Volume,   db 0
NEWSYM Voice3Volume,   db 0
NEWSYM Voice4Volume,   db 0
NEWSYM Voice5Volume,   db 0
NEWSYM Voice6Volume,   db 0
NEWSYM Voice7Volume,   db 0

NEWSYM Voice0VolumeR,   db 0
NEWSYM Voice1VolumeR,   db 0
NEWSYM Voice2VolumeR,   db 0
NEWSYM Voice3VolumeR,   db 0
NEWSYM Voice4VolumeR,   db 0
NEWSYM Voice5VolumeR,   db 0
NEWSYM Voice6VolumeR,   db 0
NEWSYM Voice7VolumeR,   db 0

NEWSYM Voice0VolumeL,   db 0
NEWSYM Voice1VolumeL,   db 0
NEWSYM Voice2VolumeL,   db 0
NEWSYM Voice3VolumeL,   db 0
NEWSYM Voice4VolumeL,   db 0
NEWSYM Voice5VolumeL,   db 0
NEWSYM Voice6VolumeL,   db 0
NEWSYM Voice7VolumeL,   db 0

NEWSYM Voice0Env,      db 1
NEWSYM Voice1Env,      db 1
NEWSYM Voice2Env,      db 1
NEWSYM Voice3Env,      db 1
NEWSYM Voice4Env,      db 1
NEWSYM Voice5Env,      db 1
NEWSYM Voice6Env,      db 1
NEWSYM Voice7Env,      db 1

NEWSYM Voice0Out,      db 0
NEWSYM Voice1Out,      db 0
NEWSYM Voice2Out,      db 0
NEWSYM Voice3Out,      db 0
NEWSYM Voice4Out,      db 0
NEWSYM Voice5Out,      db 0
NEWSYM Voice6Out,      db 0
NEWSYM Voice7Out,      db 0

; 1 Attack, 2 Decrease,3 Sustain, 0 Gain
NEWSYM Voice0State,   db 0
NEWSYM Voice1State,   db 0
NEWSYM Voice2State,   db 0
NEWSYM Voice3State,   db 0
NEWSYM Voice4State,   db 0
NEWSYM Voice5State,   db 0
NEWSYM Voice6State,   db 0
NEWSYM Voice7State,   db 0

NEWSYM Voice0Time,     dd 1
NEWSYM Voice1Time,     dd 1
NEWSYM Voice2Time,     dd 1
NEWSYM Voice3Time,     dd 1
NEWSYM Voice4Time,     dd 1
NEWSYM Voice5Time,     dd 1
NEWSYM Voice6Time,     dd 1
NEWSYM Voice7Time,     dd 1

NEWSYM Voice0Attack,   dd 1
NEWSYM Voice1Attack,   dd 1
NEWSYM Voice2Attack,   dd 1
NEWSYM Voice3Attack,   dd 1
NEWSYM Voice4Attack,   dd 1
NEWSYM Voice5Attack,   dd 1
NEWSYM Voice6Attack,   dd 1
NEWSYM Voice7Attack,   dd 1

NEWSYM Voice0Decay, dd 1
NEWSYM Voice1Decay, dd 1
NEWSYM Voice2Decay, dd 1
NEWSYM Voice3Decay, dd 1
NEWSYM Voice4Decay, dd 1
NEWSYM Voice5Decay, dd 1
NEWSYM Voice6Decay, dd 1
NEWSYM Voice7Decay, dd 1

NEWSYM Voice0SustainL, db 1
NEWSYM Voice1SustainL, db 1
NEWSYM Voice2SustainL, db 1
NEWSYM Voice3SustainL, db 1
NEWSYM Voice4SustainL, db 1
NEWSYM Voice5SustainL, db 1
NEWSYM Voice6SustainL, db 1
NEWSYM Voice7SustainL, db 1

NEWSYM Voice0SustainL2, db 1
NEWSYM Voice1SustainL2, db 1
NEWSYM Voice2SustainL2, db 1
NEWSYM Voice3SustainL2, db 1
NEWSYM Voice4SustainL2, db 1
NEWSYM Voice5SustainL2, db 1
NEWSYM Voice6SustainL2, db 1
NEWSYM Voice7SustainL2, db 1

NEWSYM Voice0SustainR, dd 1
NEWSYM Voice1SustainR, dd 1
NEWSYM Voice2SustainR, dd 1
NEWSYM Voice3SustainR, dd 1
NEWSYM Voice4SustainR, dd 1
NEWSYM Voice5SustainR, dd 1
NEWSYM Voice6SustainR, dd 1
NEWSYM Voice7SustainR, dd 1

NEWSYM Voice0SustainR2, dd 1
NEWSYM Voice1SustainR2, dd 1
NEWSYM Voice2SustainR2, dd 1
NEWSYM Voice3SustainR2, dd 1
NEWSYM Voice4SustainR2, dd 1
NEWSYM Voice5SustainR2, dd 1
NEWSYM Voice6SustainR2, dd 1
NEWSYM Voice7SustainR2, dd 1

NEWSYM Voice0IncNumber,  dd 1
NEWSYM Voice1IncNumber,  dd 1
NEWSYM Voice2IncNumber,  dd 1
NEWSYM Voice3IncNumber,  dd 1
NEWSYM Voice4IncNumber,  dd 1
NEWSYM Voice5IncNumber,  dd 1
NEWSYM Voice6IncNumber,  dd 1
NEWSYM Voice7IncNumber,  dd 1

NEWSYM Voice0SLenNumber,  dd 0
NEWSYM Voice1SLenNumber,  dd 0
NEWSYM Voice2SLenNumber,  dd 0
NEWSYM Voice3SLenNumber,  dd 0
NEWSYM Voice4SLenNumber,  dd 0
NEWSYM Voice5SLenNumber,  dd 0
NEWSYM Voice6SLenNumber,  dd 0
NEWSYM Voice7SLenNumber,  dd 0

NEWSYM Voice0SEndNumber,  dd 0
NEWSYM Voice1SEndNumber,  dd 0
NEWSYM Voice2SEndNumber,  dd 0
NEWSYM Voice3SEndNumber,  dd 0
NEWSYM Voice4SEndNumber,  dd 0
NEWSYM Voice5SEndNumber,  dd 0
NEWSYM Voice6SEndNumber,  dd 0
NEWSYM Voice7SEndNumber,  dd 0

NEWSYM Voice0SEndLNumber,  dd 0
NEWSYM Voice1SEndLNumber,  dd 0
NEWSYM Voice2SEndLNumber,  dd 0
NEWSYM Voice3SEndLNumber,  dd 0
NEWSYM Voice4SEndLNumber,  dd 0
NEWSYM Voice5SEndLNumber,  dd 0
NEWSYM Voice6SEndLNumber,  dd 0
NEWSYM Voice7SEndLNumber,  dd 0

NEWSYM Voice0DecreaseNumber,  dd 1
NEWSYM Voice1DecreaseNumber,  dd 1
NEWSYM Voice2DecreaseNumber,  dd 1
NEWSYM Voice3DecreaseNumber,  dd 1
NEWSYM Voice4DecreaseNumber,  dd 1
NEWSYM Voice5DecreaseNumber,  dd 1
NEWSYM Voice6DecreaseNumber,  dd 1
NEWSYM Voice7DecreaseNumber,  dd 1

NEWSYM Voice0EnvInc,          dd 1
NEWSYM Voice1EnvInc,          dd 1
NEWSYM Voice2EnvInc,          dd 1
NEWSYM Voice3EnvInc,          dd 1
NEWSYM Voice4EnvInc,          dd 1
NEWSYM Voice5EnvInc,          dd 1
NEWSYM Voice6EnvInc,          dd 1
NEWSYM Voice7EnvInc,          dd 1

; 0 = Direct, 1 = Increase, 2 = Increase2, 3 = Decrease, 4 = Decrease2
NEWSYM Voice0GainType,       db 0
NEWSYM Voice1GainType,       db 0
NEWSYM Voice2GainType,       db 0
NEWSYM Voice3GainType,       db 0
NEWSYM Voice4GainType,       db 0
NEWSYM Voice5GainType,       db 0
NEWSYM Voice6GainType,       db 0
NEWSYM Voice7GainType,       db 0

NEWSYM Voice0GainTime,       dd 1
NEWSYM Voice1GainTime,       dd 1
NEWSYM Voice2GainTime,       dd 1
NEWSYM Voice3GainTime,       dd 1
NEWSYM Voice4GainTime,       dd 1
NEWSYM Voice5GainTime,       dd 1
NEWSYM Voice6GainTime,       dd 1
NEWSYM Voice7GainTime,       dd 1

NEWSYM Voice0Starting,          db 0
NEWSYM Voice1Starting,          db 0
NEWSYM Voice2Starting,          db 0
NEWSYM Voice3Starting,          db 0
NEWSYM Voice4Starting,          db 0
NEWSYM Voice5Starting,          db 0
NEWSYM Voice6Starting,          db 0
NEWSYM Voice7Starting,          db 0

NEWSYM Freqdisp,        dd 0
NEWSYM SBRateb,         dd 0

NEWSYM Voice0Looped,            db 0
NEWSYM Voice1Looped,            db 0
NEWSYM Voice2Looped,            db 0
NEWSYM Voice3Looped,            db 0
NEWSYM Voice4Looped,            db 0
NEWSYM Voice5Looped,            db 0
NEWSYM Voice6Looped,            db 0
NEWSYM Voice7Looped,            db 0

VoiceNoiseEn times 8 db 0
NEWSYM GainDecBendDataPos, times 8 db 0
NEWSYM GainDecBendDataTime, times 8 dd 0
NEWSYM GainDecBendDataDat, times 8 db 0

NEWSYM AdsrBlocksLeft, times 8 db 0
NEWSYM AdsrNextTimeDepth, times 8 dd 0

TimeTemp   dd 0,0,0,0,0,0,0,0   ; 104 bytes
IncNTemp   dd 0,0,0,0,0,0,0,0
EnvITemp   dd 0,0,0,0,0,0,0,0
StatTemp   dd 0,0

NEWSYM FutureExpand,   times 44 db 0
; pharos equ hack *sigh*
marksave:

*/
		//040d53: NEWSYM BRRBuffer, times 32 db 0   ; The BRR Decode Buffer
		
		//04117f: NEWSYM DSPMem, times 256 db 0
		memmove (&ZstData[0x4117f], APU.DSP, 0x80);
	}
#if 0
	if (Settings.SuperFX)
	{
	    fread (::SRAM, 1, 64 * 1024, fs);
	    fseek (fs, 64 * 1024, SEEK_CUR);
	    fread (Memory.FillRAM + 0x7000, 1, 692, fs);
	}
	if (Settings.SA1)
	{
	    fread (t, 1, 2741, fs);
	    S9xSetSA1 (t [4], 0x2200);  // Control
	    S9xSetSA1 (t [12], 0x2203);	// ResetV low
	    S9xSetSA1 (t [13], 0x2204); // ResetV hi
	    S9xSetSA1 (t [14], 0x2205); // NMI low
	    S9xSetSA1 (t [15], 0x2206); // NMI hi
	    S9xSetSA1 (t [16], 0x2207); // IRQ low
	    S9xSetSA1 (t [17], 0x2208); // IRQ hi
	    S9xSetSA1 (((READ_DWORD (&t [28]) - (4096*1024-0x6000))) >> 13, 0x2224);
	    S9xSetSA1 (t [36], 0x2201);
	    S9xSetSA1 (t [41], 0x2209);

	    SA1Registers.A.W = READ_DWORD (&t [592]);
	    SA1Registers.X.W = READ_DWORD (&t [596]);
	    SA1Registers.Y.W = READ_DWORD (&t [600]);
	    SA1Registers.D.W = READ_DWORD (&t [604]);
	    SA1Registers.DB  = t [608];
	    SA1Registers.PB  = t [612];
	    SA1Registers.S.W = READ_DWORD (&t [616]);
	    SA1Registers.PC  = READ_DWORD (&t [636]);
	    SA1Registers.P.W = t [620] | (t [624] << 8);

	    memmove (&Memory.FillRAM [0x3000], t + 692, 2 * 1024);

	    fread (::SRAM, 1, 64 * 1024, fs);
	    fseek (fs, 64 * 1024, SEEK_CUR);
	    S9xFixSA1AfterSnapshotLoad ();
	}
	fclose (fs);

	Memory.FixROMSpeed ();
	IPPU.ColorsChanged = TRUE;
	IPPU.OBJChanged = TRUE;
	CPU.InDMA = FALSE;
	S9xFixColourBrightness ();
	IPPU.RenderThisFrame = FALSE;

	S9xFixSoundAfterSnapshotLoad ();
	ICPU.ShiftedPB = Registers.PB << 16;
	ICPU.ShiftedDB = Registers.DB << 16;
	S9xSetPCBase (ICPU.ShiftedPB + Registers.PC);
	S9xUnpackStatus ();
	S9xFixCycles ();
	S9xReschedule ();
#ifdef ZSNES_FX
	if (Settings.SuperFX)
	    S9xSuperFXPostLoadState ();
#endif
	return (TRUE);
    }
#endif
	if(!fwrite(ZstData, ZstDataSize, 1, fs)) {
		free ((char *) ZstData);
		fclose (fs);
		remove(filename);
		return (FALSE);
	}
	free ((char *) ZstData);
	fclose (fs);
	return (TRUE);
}
