/*********************************************************************************************/
/*                                                                                           */
/*********************************************************************************************/

/* This source code is must be "Shift-JIS" charset for Japanese cart name */
/*  */
/* ̧߰н */

#include "snes9x.h"
#include "memmap.h"
#include "ppu.h"
#include "display.h"
#include "apu.h"
#include "soundux.h"

void ROMSETEXTRA ()
{
// uosnes Start

    int i, c;

#if 0
	if(strcmp (Memory.ROMName, "LIGHT FANTASY") == 0) {
		// Banks 70->7d 0x8000-0xffff, S-RAM
		for (c = 0; c < 0x0e; c++) {
			for(i = 8; i < 16; i++) {
				Memory.Map [(c << 4) + 0x700 + i] = (uint8 *) Memory.MAP_LOROM_SRAM;
				Memory.BlockIsRAM [(c << 4) + 0x700 + i] = TRUE;
				Memory.BlockIsROM [(c << 4) + 0x700 + i] = FALSE;
			}
		}
		Memory.WriteProtectROM ();
	}
#endif

    if(strcmp (Memory.ROMName, "DRAGON KNIGHT 4") == 0) {
		for (c = 0; c < 0x10; c++)
		{
			Memory.Map [c + 0x7d0] = ::SRAM + (((c >> 4) & 1) << 16);
			Memory.BlockIsRAM [c + 0x7d0] = TRUE;
			Memory.BlockIsROM [c + 0x7d0] = FALSE;
		}
		Memory.WriteProtectROM ();
	}

    if (strcmp (Memory.ROMName, "TAIKYOKU-IGO Goliath") == 0 ||
		strcmp (Memory.ROMName, "Big Sky Trooper") == 0 ||
		strcmp (Memory.ROMName, "DANTE SFC") == 0) {
		// Banks 70->7e, S-RAM
		for (c = 0; c < 0x80; c++){
			Memory.Map [c + 0xf00] = (uint8 *) Memory.MAP_LOROM_SRAM;
			Memory.BlockIsRAM [c + 0xf00] = TRUE;
			Memory.BlockIsROM [c + 0xf00] = FALSE;
		}
		Memory.WriteProtectROM ();
	}

    if(strcmp (Memory.ROMName, "GOGO ACKMAN2") == 0 || strcmp (Memory.ROMName, "GOGO ACKMAN3") == 0 ||
 	strcmp (Memory.ROMName, "HOME ALONE") == 0 || strcmp (Memory.ROMName, "ް ڲ") == 0 ||
 	strcmp (Memory.ROMName, "FURI-FURI GIRLS") == 0 || strcmp (Memory.ROMName, "GALAXY ROBO") == 0 || 
 	strcmp (Memory.ROMName, "SFX ŲĶɶ 1") == 0 || strcmp (Memory.ROMName, "·ޮݶ޲ ϱެ") == 0 ||
 	strcmp (Memory.ROMName, "ACCELEBRID") == 0)
	{		
		// Banks 00->3f and 80->bf
		for (c = 0; c < 0x400; c += 16)
		{
			Memory.Map [c + 6] = Memory.Map [c + 0x806] = SRAM;
			Memory.Map [c + 7] = Memory.Map [c + 0x807] = SRAM;
			Memory.BlockIsROM [c + 6] = Memory.BlockIsROM [c + 0x806] = FALSE;
			Memory.BlockIsROM [c + 7] = Memory.BlockIsROM [c + 0x807] = FALSE;
			Memory.BlockIsRAM [c + 6] = Memory.BlockIsRAM [c + 0x806] = TRUE;
			Memory.BlockIsRAM [c + 7] = Memory.BlockIsRAM [c + 0x807] = TRUE;
		}
		Memory.WriteProtectROM ();
	}

    if ((Memory.HiROM && strncmp ((char *) &Memory.ROM [0xffb0], "DE", 2) == 0) ||
	(!Memory.HiROM && strncmp ((char *) &Memory.ROM [0x7fb0], "DE", 2) == 0) ||
       (Memory.HiROM && strncmp ((char *) &Memory.ROM [0xffb0], "16", 2) == 0) ||
	(!Memory.HiROM && strncmp ((char *) &Memory.ROM [0x7fb0], "16", 2) == 0) ||
	strcmp (Memory.ROMName, "SUPER FORMATION SOCCE") == 0)
	IAPU.OneCycle = 20;

    if ((Memory.HiROM && ROM [0xffda] == 0xde)||(Memory.LoROM && ROM [0x7fda] == 0xde))
	IAPU.OneCycle = 20;

    if ((Memory.HiROM && ROM [0xffda] == 0x16)||(Memory.LoROM && ROM [0x7fda] == 0x16))
	IAPU.OneCycle = 20;

    if (strcmp (Memory.ROMName, "SUPER SOCCER") == 0 ||
	strcmp (Memory.ROMName, "F1 POLE POSITION") == 0 ||
	strcmp (Memory.ROMName, "HOOK") == 0 ||
	strcmp (Memory.ROMName, "SFڽݸ") == 0 ||
	strcmp (Memory.ROMName, "SUPER EMPIRE STRIKES") == 0)
	IAPU.OneCycle = ONE_APU_CYCLE_HUMAN;

    if (strcmp (Memory.ROMName, "EARTHWORM JIM 2") == 0 ||
	strcmp (Memory.ROMName, "ULTIMATE KOMBAT 3") == 0 ||
	strncmp (Memory.ROMName, "MORTAL KOMBAT 3", 15) == 0)
	IAPU.OneCycle = 30;

    if (strcmp (Memory.ROMName, "CHRONO TRIGGER") == 0 ||
	strcmp (Memory.ROMName, "PANIC BOMBER WORLD") == 0)
	IAPU.OneCycle = 12;

    if (strcmp (Memory.ROMName, "ZENKI TENCHIMEIDOU") == 0)
	IAPU.OneCycle = 13;

    if (strcmp (Memory.ROMName, "MORTAL KOMBAT") == 0)
	IAPU.OneCycle = 15;

    if (strcmp (Memory.ROMName, "RENDERING RANGER R2") == 0)
	IAPU.OneCycle = 15;

	// Street Racer
	//if (strcmp (Memory.ROMId, "ASRJ") == 0)
	//	IAPU.OneCycle = 20;

    if (strcmp (Memory.ROMName, "DRAGON KNIGHT 4") == 0 ||
	strcmp (Memory.ROMName, "LITTLE MAGIC") == 0 ||
	strcmp (Memory.ROMName, "NHL STANLEY CUP") == 0 ||
	strcmp (Memory.ROMName, "SUPER HOCKEY") == 0 ||
	strcmp (Memory.ROMName, "CYBER KNIGHT 2") == 0 ||
	strcmp (Memory.ROMName, "ެݸɵެ  1") == 0 ||
	strcmp (Memory.ROMName, "ݼɳ") == 0 ||
	(Memory.LoROM && strncmp ((char *) &Memory.ROM [0x7fc0], "X-MEN   ", 8) == 0))
	IAPU.OneCycle = 20;

    if (strcmp (Memory.ROMName, "CACOMA KNIGHT") == 0 ||
	strcmp (Memory.ROMName, "POWER RANGERS FIGHT") == 0)
	CPU.NMITriggerPoint = 45;

#if 0
    if (strcmp (Memory.ROMName, "TETRIS&Dr.MARIO") == 0 || 
        strcmp (Memory.ROMName, "Dr.MARIO") == 0 || 
        strcmp (Memory.ROMName, "JIGSAW PARTY") == 0 || 
        strcmp (Memory.ROMName, "SUPER PICROSS") == 0 || 
        strcmp (Memory.ROMName, "KIRBY NO KIRA KIZZU") == 0 || 
        strcmp (Memory.ROMName, "BLOCK") == 0 ||
        strcmp (Memory.ROMName, "GANSO PACHINKO OU") == 0 || 
        strcmp (Memory.ROMName, "URANAI") == 0 || 
        strcmp (Memory.ROMName, "޷ʲ") == 0 || 
        strcmp (Memory.ROMName, "SUPER KYOUTEI") == 0 || 
        strcmp (Memory.ROMName, "SUPER KYOUTEI 2") == 0 || 
        strcmp (Memory.ROMName, "JANJYU GAKUEN 2") == 0 || 
        strcmp (Memory.ROMName, "SUPERGOMOKUSYOGI") == 0 || 
        strcmp (Memory.ROMName, "HANAFUDAOU          ?") == 0 || 
        strcmp (Memory.ROMName, "SUPER CASTLES") == 0 || 
        strcmp (Memory.ROMName, "HONKAKUHA IGO GOSEI") == 0 || 
        strcmp (Memory.ROMName, "SUPER HARISUTA 2") == 0 || 
        strcmp (Memory.ROMName, "DOKAPON GAIDEN") == 0 || 
        strcmp (Memory.ROMName, "޶ 321") == 0 || 
        strcmp (Memory.ROMName, " ޶ 4") == 0 || 
        strcmp (Memory.ROMName, "˯ݺڸ 1 ̼") == 0 || 
        strcmp (Memory.ROMName, "˯ݺڸ 2 ̼") == 0 || 
        strcmp (Memory.ROMName, "˯ݺڸ3޲") == 0 || 
        strcmp (Memory.ROMName, "˯ݺڸ4׸") == 0 || 
        strcmp (Memory.ROMName, "SUPER BOMBLISS") == 0) 
    {
	Settings.MultiPlayer5Master = FALSE;
	Settings.MouseMaster = FALSE;
	Settings.SuperScopeMaster = FALSE;
	Settings.JustifierMaster = FALSE;
    }
#endif

	if(strcmp (Memory.ROMName, "ALIENS vs. PREDATOR") == 0 ||
          strcmp (Memory.ROMName, "ALIEN vs. PREDATOR") == 0)
		SNESGameFixes.alienVSpredetorFix = TRUE;

	if(strcmp (Memory.ROMName, "VS.ڸ") == 0 ||
          strcmp (Memory.ROMName, " ϰެ ĳʲ") == 0 ||
          strcmp (Memory.ROMName, "SUUCHIIPAI") == 0)
		SNESGameFixes.TouhaidenControllerFix = TRUE;

       SNESGameFixes.DerbyStallion = strncmp (Memory.ROMName, "DERBY STALLION",14) == 0;

	   //DMA hack
       SNESGameFixes.LetsPachi = strncmp (Memory.ROMName, "LETs PACHINKO",13) == 0;
       SNESGameFixes.ShinnichiFix = strcmp (Memory.ROMName, "ݼinĳް") == 0;
	   SNESGameFixes.SD_gundam_gaiden2_entaku_no_kishi = strcmp (Memory.ROMName, "SFC ޲ 2") == 0;
	   SNESGameFixes.All_JapanProWrestle = strcmp (Memory.ROMName, "ALL JAPANPROWRSTLE") == 0;
	   SNESGameFixes.NBABullsVsBlazersPB = strcmp (Memory.ROMName, "NBA ޽ް") == 0;
	   SNESGameFixes.ikari_no_yousai = strcmp (Memory.ROMName, "IKARI NO YOUSAI") == 0 ||
		   (Settings.BS && strcmp (Memory.ROMName, "{̗v") == 0);

       SNESGameFixes.Panepon_SoundFix = strncmp (Memory.ROMName, "  ",11) == 0 ||
			      strncmp (Memory.ROMName, "ق'98",12) == 0 ||
			      strncmp (Memory.ROMName, "֯BS",16) == 0 ||
			      strncmp (Memory.ROMName, "TETRIS ATTACK",13) == 0;

       SNESGameFixes.PPU4212_Hack = strcmp (Memory.ROMName, "Cu-On-Pa SFC") == 0 ||
			   strncmp (Memory.ROMName, "NIpar",14) == 0;

       SNESGameFixes.VoicerKun = strncmp (Memory.ROMName, "EMIT Vol.",9) == 0 ||
			   strncmp (Memory.ROMName, "ݼުذ ޫ̧ް",21) == 0;

	SNESGameFixes.Uniracers = strcmp (Memory.ROMName, "UNIRACERS") == 0;

       SNESGameFixes.APU_Disable = (Memory.LoROM && strncmp ((char *) &Memory.ROM [0x7fc0], "BS ",8) == 0) ||
			   (strncmp ((char *) &Memory.ROM [0x7fc0], "BSϲè߹",11) == 0);

//	SNESGameFixes.OLD_S9xAPUSetEndOfSample = strncmp (Memory.ROMName, "TERRANIGMA ",11) == 0 ||
//			   strncmp (Memory.ROMName, "TENCHI-JPN",10) == 0;

//	SNESGameFixes.OLD_S9xAPUSetEndOfSample = FALSE;
	SNESGameFixes.OLD_S9xAPUSetEndOfSample = TRUE;
	if(SNESGameFixes.Panepon_SoundFix) SNESGameFixes.OLD_S9xAPUSetEndOfSample = FALSE;

#if 1
       Settings.DisableIRQCycleCount = strncmp (Memory.ROMName, "SD F1 GRAND PRIX",16) == 0 ||
			      strcmp (Memory.ROMName, "YOSSY'S ISLAND") == 0 ||
			      strcmp (Memory.ROMName, "YOSHI'S ISLAND") == 0 ||
			      strcmp (Memory.ROMName, "CLOCK TOWER SFX") == 0 ||
			      strcmp (Memory.ROMName, "ELFARIA2") == 0 ||
			      strcmp (Memory.ROMName, "F-ZERO") == 0 ||
			      strcmp (Memory.ROMName, "SOLSTICE 2") == 0 ||
			      strcmp (Memory.ROMName, "EQUINOX") == 0 ||
			      strncmp (Memory.ROMName, "BS F-ZERO ",10) == 0 ||
			      strcmp (Memory.ROMName, "BSF-ZERO2׸è") == 0 ||
			      strcmp (Memory.ROMName, "Street Fighter 2") == 0 ;
#endif
	   Settings.DisableIRQCycleCount = TRUE;
	   if(strcmp (Memory.ROMName, "TRAVERSE") == 0 || strncmp (Memory.ROMName, "DERBY STALLION",14) == 0)
		   Settings.DisableIRQCycleCount = FALSE;

	SNESGameFixes.XXX_IRQVBeamPos = 0;
	if(strncmp (Memory.ROMName, "DERBY STALLION",14) == 0 ||
          strncmp ((char *) &Memory.ROM [0x7fc0], "HOME IMPROVEMENT",16) == 0) 
		SNESGameFixes.XXX_IRQVBeamPos = 224;

	if (strcmp (Memory.ROMName, "SFX ŲĶɶ 1") == 0)
		Settings.SRAMInitialValueMaster = 0x6b;

	if(strcmp (Memory.ROMName, "ACCELEBRID") == 0 ||
	   strcmp (Memory.ROMName, "HOME ALONE") == 0 ||
	   strcmp (Memory.ROMName, "GOGO ACKMAN2") == 0 ||
	   strcmp (Memory.ROMName, "GOGO ACKMAN3") == 0 ||
	   strcmp (Memory.ROMName, "·ޮݶ޲ ϱެ") == 0 ||
	   strcmp (Memory.ROMName, "FURI-FURI GIRLS") == 0)
		Settings.SRAMInitialValueMaster = 0x60;

	if(strcmp (Memory.ROMName, "SUPER DRIFT OUT") == 0 ||
	   strcmp(Memory.ROMName, "SATAN IS OUR FATHER!") == 0 ||
	   strcmp (Memory.ROMName, "goemon 4") == 0)
		Settings.SRAMInitialValueMaster = 0x00;

	if (Memory.HiROM && strncmp ((char *) &Memory.ROM [0xffc0], "Bahamut Lagoon", 14) == 0) 
		Settings.RAMInitialValueMaster = 0xaa;

	if (Memory.HiROM && strncmp ((char *) &Memory.ROM [0xffc0], "¥ޥ׼", 19) == 0 ||
	   Memory.LoROM && strncmp ((char *) &Memory.ROM [0x7fc0], "STAR FOX", 8) == 0 || 
	   Memory.LoROM && strncmp ((char *) &Memory.ROM [0x7fc0], "HUMAN GRANDPRIX 3", 17) == 0 || 
	   Memory.LoROM && strncmp ((char *) &Memory.ROM [0x7fc0], "MUHAMMAD ALI BOXING", 19) == 0 ||
	   strcmp (Memory.ROMName, "SUPER PINBALL") == 0)
		Settings.RAMInitialValueMaster = 0;

#if 0
    if (strcmp (Memory.ROMName, "ԸҶݾ") == 0
    	|| strcmp (Memory.ROMName, "KENTOUOU WORLDCHAMPIO") == 0
    	|| strcmp (Memory.ROMName, "TKO SUPERCHAMPIONSHIP") == 0
    	|| strcmp (Memory.ROMName, "TKO SUPER CHAMPIONSHI") == 0
    	|| strcmp (Memory.ROMName, "GANBA LEAGUE") == 0
    	|| strcmp (Memory.ROMName, "ASCII DARK LAW") == 0
    	|| strcmp (Memory.ROMName, "HORAI-GAKUEN") == 0
    	|| strcmp (Memory.ROMName, "BOMBUZAL") == 0
   	|| strcmp (Memory.ROMName, "ʵ حŲ LOP 1") == 0
   	|| strcmp (Memory.ROMName, "SUPER PINBALL2") == 0
   	|| strcmp (Memory.ROMName, "ϰު׽") == 0
   	|| strcmp (Memory.ROMName, "PANIC BOMBER WORLD") == 0
   	|| strcmp (Memory.ROMName, "IHATOVO STORY") == 0
    	|| strcmp (Memory.ROMName, "WANDERERS FROM YS") == 0
   	|| strcmp (Memory.ROMName, "گ ذް") == 0
   	|| strcmp (Memory.ROMName, "گ ذް2") == 0
    	|| strcmp (Memory.ROMName, "THOROUGHBRED BREEDER3") == 0
    	|| strcmp (Memory.ROMName, "TEITOKU NO KETSUDAN") == 0
    	|| strcmp (Memory.ROMName, "SUPER ROYAL BLOOD") == 0
    	|| strcmp (Memory.ROMName, "SHVC NOBU4") == 0
    	|| strcmp (Memory.ROMName, "SUPER SANGOKUSHI 2") == 0
    	|| strcmp (Memory.ROMName, "SUPER ZENKOKUBAN") == 0
    	|| strcmp (Memory.ROMName, "SANGOKUSHI 3") == 0
    	|| strcmp (Memory.ROMName, "SUPER GENTYOUHISHI") == 0)
        Settings.APURAMInitialValueMaster = 0;
#endif

    if (Memory.LoROM && strncmp ((char *) &Memory.ROM [0x7fc0], "WILD TRAX", 9) == 0 ||
        Memory.LoROM && strncmp ((char *) &Memory.ROM [0x7fc0], "Stunt Race FX", 13) == 0 ||
        Memory.LoROM && strncmp ((char *) &Memory.ROM [0x7fc0], "YOSSY'S ISLAND", 14) == 0 ||
        Memory.LoROM && ROM [0x7fd9] == 1 && strncmp ((char *) &Memory.ROM [0x7fc0], "YOSHI'S ISLAND", 14) == 0 ||
        Memory.LoROM && strncmp ((char *) &Memory.ROM [0x7fc0], "STAR FOX  ", 10) == 0 ||
        Memory.LoROM && strncmp ((char *) &Memory.ROM [0x7fc0], "STAR FOX 2", 10) == 0 ||
        Memory.LoROM && strncmp ((char *) &Memory.ROM [0x7fc0], "STAR WING ", 10) == 0)
       CPU.TriedInterleavedMode2 = TRUE;

//    if (strcmp (Memory.ROMName, "SILVASAGA2") == 0)
//	Settings.WrestlemaniaArcade = TRUE;

#if 0
    if (strcmp (Memory.ROMName, "IHATOVO STORY") == 0 ||
        strcmp (Memory.ROMName, "SFX ϼ޶ٰĸ1") == 0)
	Settings.Normalsnap = 1; 
#endif

    if (strcmp (Memory.ROMName, "WAYNE GRETZKY AND THE") == 0)
	Settings.MultiPlayer5Master = TRUE;

    if (strcmp (Memory.ROMName, "FURAI NO SIREN") == 0 ||
        strcmp (Memory.ROMName, "ULTIMATE KOMBAT 3") == 0 ||
        strcmp (Memory.ROMName, "MORTAL KOMBAT 3 R2.1") == 0)
	SNESGameFixes.SoundEnvelopeHeightReading2 = TRUE;

    Settings.LatchedInterlace_Fix = 0;

    if (strcmp (Memory.ROMName, "FIRE PROWREST SPECIAL") == 0 || strcmp (Memory.ROMName, "S FORMATION SOCCER FD") == 0 ||
        strcmp (Memory.ROMName, "S FORMATION SOCCER 94") == 0 || strcmp (Memory.ROMName, "޼ޮڽװ") == 0)
       Settings.LatchedInterlace_Fix = 1;

    if (strcmp (Memory.ROMName, "OLIVIA'S MYSTERY") == 0 || strcmp (Memory.ROMName, "ARYOL") == 0 ||
        strcmp (Memory.ROMName, "SUUCHIIPAI") == 0)
       Settings.LatchedInterlace_Fix = 2;

#if 0
    if (strcmp (Memory.ROMName, "ZELDANODENSETSU") == 0 ||
        strcmp (Memory.ROMName, "THE LEGEND OF ZELDA") == 0 ||
        strcmp (Memory.ROMName, "LA LEGENDE DE ZELDA") == 0 ||
        strcmp (Memory.ROMName, "FINAL FIGHT") == 0 ||
        strcmp (Memory.ROMName, "FINAL FIGHT GUY") == 0 ||
        //strcmp (Memory.ROMName, "CHRONO TRIGGER") == 0 ||
        strcmp (Memory.ROMName, "OEKAKILOGIC_01") == 0 ||
        strcmp (Memory.ROMName, "ACCELEBRID") == 0)
       Settings.H_Max = (100 * SNES_CYCLES_PER_SCANLINE) / 108;

    if (strcmp (Memory.ROMName, "SHINING SCORPION") == 0 ||
        strcmp (Memory.ROMName, "HOKUTO NO KEN 7") == 0)
       Settings.H_Max = (105 * SNES_CYCLES_PER_SCANLINE) / 100;

    if (strncmp ((char *) &Memory.ROM [0x7fc0], "DERBY STALLION",14) == 0 ||
        strncmp ((char *) &Memory.ROM [0x7fc0], "SUPER BIKKURIMAN",16) == 0 ||
        strncmp ((char *) &Memory.ROM [0xffc0], " G1ذ",12) == 0 ||
        strncmp ((char *) &Memory.ROM [0x7fc0], "JIKKYOU-PROWRESTLING",20) == 0 ||
        Memory.LoROM && strncmp ((char *) &Memory.ROM [0x7fc0], "Ys5   ", 6) == 0 ||
        Memory.LoROM && strncmp ((char *) &Memory.ROM [0x7fc0], "Ys5EXPERT",9) == 0) 
        Settings.H_Max = (195 * SNES_CYCLES_PER_SCANLINE) / 100;

    if (strcmp (Memory.ROMName, "SFX URUTORASEBUN") == 0)
       Settings.H_Max = (100 * SNES_CYCLES_PER_SCANLINE) / 98;

    if (strcmp (Memory.ROMName, "BATTLETOADS D.D.") == 0)
       Settings.H_Max = (100 * SNES_CYCLES_PER_SCANLINE) / 105;

    if (strcmp (Memory.ROMName, "MASOUKISHIN") == 0)
       Settings.H_Max = (102 * SNES_CYCLES_PER_SCANLINE) / 100;

    if (strcmp (Memory.ROMName, "ڲ԰") == 0)
       Settings.H_Max = (101 * SNES_CYCLES_PER_SCANLINE) / 100;
#endif

    Settings.MAX_NTSC_VCOUNTER = 262;
    Settings.MAX_PAL_VCOUNTER = 312;

#if 0
    if(strcmp (Memory.ROMName, "DRAGON KNIGHT 4") == 0 ||
        strcmp (Memory.ROMName, "UMIHARAKAWASE") == 0)
       Settings.MAX_NTSC_VCOUNTER = 261;

    if (strcmp (Memory.ROMName, "RETURN OF DOUBLE DRAG") == 0 ||
        strcmp (Memory.ROMName, "SUPER DOUBLE DRAGON") == 0 ||
        strcmp (Memory.ROMName, "FIREEMBLEM5") == 0 ||
        strcmp (Memory.ROMName, "FIREEMBLEM5ROM") == 0 ||
        strcmp (Memory.ROMName, "FINAL FANTASY 5") == 0 ||
        strcmp (Memory.ROMName, "FINAL FANTASY 6") == 0 ||
        strcmp (Memory.ROMName, "DRAGONQUEST3") == 0 ||
        strcmp (Memory.ROMName, "DRAGONQUEST6") == 0 ||
        strcmp (Memory.ROMName, "UFO KAMEN YAKISOBAN") == 0 ||
        strcmp (Memory.ROMName, "FIGHTING ELEVEN") == 0 ||
        strcmp (Memory.ROMName, " ޻ 4") == 0 ||
        strcmp (Memory.ROMName, "TRAVERSE") == 0 ||
        strcmp (Memory.ROMName, "TOKIMEKI MEMORIAL") == 0 ||
        strcmp (Memory.ROMName, "FINAL FIGHT") == 0 ||
        strcmp (Memory.ROMName, "FINAL FIGHT GUY") == 0 ||
        strcmp (Memory.ROMName, "CHRONO TRIGGER") == 0)
       Settings.MAX_NTSC_VCOUNTER = 265;

    if (strcmp (Memory.ROMName, "SeikenDensetsu3") == 0 ||
        strcmp (Memory.ROMName, "SeikenDensetsu3Sample") == 0)
       Settings.MAX_NTSC_VCOUNTER = 266;

    if (strcmp (Memory.ROMName, "HU TENGAI MAKYO ZERO") == 0 ||
        strcmp (Memory.ROMName, "JUMP TENGAIMAKYO ZERO") == 0)
       Settings.MAX_NTSC_VCOUNTER = 267;

    if (strcmp (Memory.ROMName, "DIGITAL DEVIL STORY") == 0 ||
        strcmp (Memory.ROMName, "OTHELLO WORLD") == 0)
       Settings.MAX_NTSC_VCOUNTER = 275;
#endif

    if (strcmp (Memory.ROMName, "GET IN THE HOLE") == 0)
    {
       ROM [0x17bb7] = ROM [0x17bb8] = 0xea;
       ROM [0x17bba] = 0;
    }

    if (strcmp (Memory.ROMName, "GALAXY ROBO") == 0)
    {
       ROM [0xc5b6] = ROM [0xc5b7] = ROM [0xc5b8] = ROM [0xc5b9] = 0xea;
       ROM [0xc5be] = ROM [0xc5bf] = ROM [0xc5c0] = ROM [0xc5c1] = 0xea;
       ROM [0x7227] = ROM [0x7228] = 0xea;
    }
}

