/*********************************************************************************************/
/*                                                                                           */
/*********************************************************************************************/

#include "snes9x.h"
#include "memmap.h"
#include "ppu.h"
#include "display.h"
#include "apu.h"
#include "soundux.h"
#include "snapshot.h"

void XXX_REPLAY_LOAD ()
{
 	STREAM f_replay;
 	if ((f_replay = OPEN_STREAM (S9xGetFilename (".rpa"), "rb")))
 	{
 	 	READ_STREAM (XxxMovie.REPLAY_RAM, 0x400000, f_replay);
 	 	CLOSE_STREAM(f_replay);
 	}
}

void XXX_REPLAY_SAVE ()
{
 	STREAM f_replay;
 	if ((f_replay = OPEN_STREAM (S9xGetFilename (".rpa"), "wb")))
 	{
	 	WRITE_STREAM (XxxMovie.REPLAY_RAM, 0x400000, f_replay);
	 	CLOSE_STREAM(f_replay);
 	}
}

#define REPLAY_COUNT_ADD_SKIP 0x10
#define REPLAY_DATA_TOTAL (14)
#define REPLAY_SAME_ADD (0xe)

void REPLAY_BYTE_SET ()
{
   XxxMovie.replay_data[0] = Memory.FillRAM[0x4218];
   XxxMovie.replay_data[1] = Memory.FillRAM[0x4219];
   XxxMovie.replay_data[2] = Memory.FillRAM[0x421a];
   XxxMovie.replay_data[3] = Memory.FillRAM[0x421b];
   XxxMovie.replay_data[4] = Memory.FillRAM[0x421c];
   XxxMovie.replay_data[5] = Memory.FillRAM[0x421d];
   XxxMovie.replay_data[6] = Memory.FillRAM[0x421e];
   XxxMovie.replay_data[7] = Memory.FillRAM[0x421f];

   XxxMovie.replay_data[8] = XxxMovie.replay_data_dummy;
   XxxMovie.replay_data[9] = XxxMovie.replay_data_dummy;
   XxxMovie.replay_data[10] = XxxMovie.replay_data_dummy;
   XxxMovie.replay_data[11] = XxxMovie.replay_data_dummy;
   XxxMovie.replay_data[12] = XxxMovie.replay_data_dummy;
   XxxMovie.replay_data[13] = XxxMovie.replay_data_dummy;

//   XxxMovie.replay_data[**] = (uint8)(XxxMovie.replay_data_dummy);
//   XxxMovie.replay_data[**] = (uint8)(XxxMovie.replay_data_dummy >> 8);

}

void REPLAY_BYTE_GET ()
{
   Memory.FillRAM[0x4218] = XxxMovie.replay_data[0];
   Memory.FillRAM[0x4219] = XxxMovie.replay_data[1];
   Memory.FillRAM[0x421a] = XxxMovie.replay_data[2];
   Memory.FillRAM[0x421b] = XxxMovie.replay_data[3];
   Memory.FillRAM[0x421c] = XxxMovie.replay_data[4];
   Memory.FillRAM[0x421d] = XxxMovie.replay_data[5];
   Memory.FillRAM[0x421e] = XxxMovie.replay_data[6];
   Memory.FillRAM[0x421f] = XxxMovie.replay_data[7];

   XxxMovie.replay_data_dummy = XxxMovie.replay_data[8];
   XxxMovie.replay_data_dummy = XxxMovie.replay_data[9];
   XxxMovie.replay_data_dummy = XxxMovie.replay_data[10];
   XxxMovie.replay_data_dummy = XxxMovie.replay_data[11];
   XxxMovie.replay_data_dummy = XxxMovie.replay_data[12];
   XxxMovie.replay_data_dummy = XxxMovie.replay_data[13];

//   XxxMovie.replay_data_dummy = XxxMovie.replay_data[**] + (XxxMovie.replay_data[**] << 8);

}

#define REPLAY_RECODE_A_MACRO \
for (int i = 0; i < REPLAY_DATA_TOTAL; i += 1) \
{ \
  XxxMovie.REPLAY_RAM[XxxMovie.REPLAY_RAM_COUNT+i] = XxxMovie.replay_data_temp [i] = XxxMovie.replay_data[i]; \
}

#define REPLAY_RECODE_B_MACRO \
for (int i = 0; i < REPLAY_DATA_TOTAL; i += 1) \
{ \
  if(XxxMovie.replay_data_temp [i] != XxxMovie.replay_data[i]) change_byte = true; \
}

#define REPLAY_RECODE_C_MACRO \
XxxMovie.REPLAY_RAM[XxxMovie.REPLAY_RAM_COUNT+REPLAY_SAME_ADD] = (uint8)(XxxMovie.replay_data_count); \
XxxMovie.REPLAY_RAM[XxxMovie.REPLAY_RAM_COUNT+REPLAY_SAME_ADD+1] = (uint8)(XxxMovie.replay_data_count >> 8);

#define REPLAY_PLAY_A_MACRO \
for (int i = 0; i < REPLAY_DATA_TOTAL; i += 1) \
{ \
  XxxMovie.replay_data[i] = XxxMovie.replay_data_temp [i] = XxxMovie.REPLAY_RAM[XxxMovie.REPLAY_RAM_COUNT+i]; \
}

#define REPLAY_PLAY_B_MACRO \
for (int i = 0; i < REPLAY_DATA_TOTAL; i += 1) \
{ \
  XxxMovie.replay_data[i] = XxxMovie.replay_data_temp [i]; \
}

#define REPLAY_PLAY_C_MACRO \
XxxMovie.replay_data_count  = ((XxxMovie.REPLAY_RAM[XxxMovie.REPLAY_RAM_COUNT+REPLAY_SAME_ADD]) + \
                                (XxxMovie.REPLAY_RAM[XxxMovie.REPLAY_RAM_COUNT+REPLAY_SAME_ADD+1] << 8));

void XXX_REPLAY_START ()
{
   if(XxxMovie.Replay_rec == TRUE)
   {
      bool8 change_byte = false;

      REPLAY_BYTE_SET ();
      REPLAY_RECODE_B_MACRO

      if(XxxMovie.Replay_count == 0)
      {
	   ZeroMemory (XxxMovie.REPLAY_RAM, 0x400000);
	   for (int i = 0; i < REPLAY_DATA_TOTAL; i += 1)
	   {
                XxxMovie.replay_data_temp [i]=0;
	   }
	   XxxMovie.replay_data_count = 0;
      }
      else
      if(XxxMovie.Replay_count == 1)
      {
	   REPLAY_RECODE_A_MACRO
	   XxxMovie.replay_data_count = 0;
      }
      else
      if(XxxMovie.replay_data_count > 0xFFFF || change_byte)
      {
	   XxxMovie.replay_data_count  -= 1;
	   REPLAY_RECODE_C_MACRO

	   XxxMovie.REPLAY_RAM_COUNT += REPLAY_COUNT_ADD_SKIP;

	   REPLAY_RECODE_A_MACRO
	   XxxMovie.replay_data_count = 0;
      }

      XxxMovie.replay_data_count += 1;
      XxxMovie.Replay_count += 1;

      if(XxxMovie.REPLAY_RAM_COUNT > 0x3fff00) XXX_REPLAY_END ();
   }
   else
   if(XxxMovie.Replay_play == true)
   {
	XxxMovie.REPLAY_RAM_COUNT_MAX = XxxMovie.REPLAY_RAM[0x3FFFFD]
	 + (XxxMovie.REPLAY_RAM[0x3FFFFE] << 8)
	 + (XxxMovie.REPLAY_RAM[0x3FFFFF] << 16);

      if(XxxMovie.Replay_count == 0)
      {
	   XxxMovie.replay_data_count = 0;
      }
      else
      if(XxxMovie.replay_data_count == 0)
      {
	   REPLAY_PLAY_A_MACRO
	   REPLAY_PLAY_C_MACRO
	   XxxMovie.REPLAY_RAM_COUNT += REPLAY_COUNT_ADD_SKIP;
      }
      else
      {
	   REPLAY_PLAY_B_MACRO
	   XxxMovie.replay_data_count  -= 1;
      }

      REPLAY_BYTE_GET ();

      XxxMovie.Replay_count += 1;

      if(XxxMovie.REPLAY_RAM_COUNT_MAX < XxxMovie.REPLAY_RAM_COUNT)
      {
	   XXX_REPLAY_END ();
	   GFX.InfoStringTimeout = 100;
	   GFX.InfoString=("Movie Play Finished");
      }
   }

}

void XXX_REPLAY_END ()
{
   if(XxxMovie.Replay_rec == true)
   {
      REPLAY_BYTE_SET ();

      REPLAY_RECODE_A_MACRO
      REPLAY_RECODE_C_MACRO

      XxxMovie.REPLAY_RAM[0x3FFFF8] = (uint8)(XxxMovie.Replay_count);
      XxxMovie.REPLAY_RAM[0x3FFFF9] = (uint8)(XxxMovie.Replay_count >> 8);
      XxxMovie.REPLAY_RAM[0x3FFFFA] = (uint8)(XxxMovie.Replay_count >> 16);
      XxxMovie.REPLAY_RAM[0x3FFFFB] = (uint8)(XxxMovie.Replay_count >> 24);

      XxxMovie.REPLAY_RAM[0x3FFFFD] = (uint8)(XxxMovie.REPLAY_RAM_COUNT);
      XxxMovie.REPLAY_RAM[0x3FFFFE] = (uint8)(XxxMovie.REPLAY_RAM_COUNT >> 8);
      XxxMovie.REPLAY_RAM[0x3FFFFF] = (uint8)(XxxMovie.REPLAY_RAM_COUNT >> 16);

      XXX_REPLAY_SAVE ();

      XxxMovie.Replay_rec = false;
      XxxMovie.Replay_count = 0;
      XxxMovie.replay_data_count = 0;
      XxxMovie.REPLAY_RAM_COUNT_MAX = 0;
      XxxMovie.REPLAY_RAM_COUNT = 0;
   }
   else
   if(XxxMovie.Replay_play == true)
   {
      XxxMovie.Replay_play = false;
      XxxMovie.Replay_count = 0;
      XxxMovie.replay_data_count = 0;
      XxxMovie.REPLAY_RAM_COUNT_MAX = 0;
      XxxMovie.REPLAY_RAM_COUNT = 0;
   }
}
