/*******************************************************************************
  Snes9x - Portable Super Nintendo Entertainment System (TM) emulator.
 
  (c) Copyright 1996 - 2002 Gary Henderson (gary.henderson@ntlworld.com) and
                            Jerremy Koot (jkoot@snes9x.com)

  (c) Copyright 2001 - 2004 John Weidman (jweidman@slip.net)

  (c) Copyright 2002 - 2004 Brad Jorsch (anomie@users.sourceforge.net),
                            funkyass (funkyass@spam.shaw.ca),
                            Joel Yliluoma (http://iki.fi/bisqwit/)
                            Kris Bleakley (codeviolation@hotmail.com),
                            Matthew Kendora,
                            Nach (n-a-c-h@users.sourceforge.net),
                            Peter Bortas (peter@bortas.org) and
                            zones (kasumitokoduck@yahoo.com)

  C4 x86 assembler and some C emulation code
  (c) Copyright 2000 - 2003 zsKnight (zsknight@zsnes.com),
                            _Demo_ (_demo_@zsnes.com), and Nach

  C4 C++ code
  (c) Copyright 2003 Brad Jorsch

  DSP-1 emulator code
  (c) Copyright 1998 - 2004 Ivar (ivar@snes9x.com), _Demo_, Gary Henderson,
                            John Weidman, neviksti (neviksti@hotmail.com),
                            Kris Bleakley, Andreas Naive

  DSP-2 emulator code
  (c) Copyright 2003 Kris Bleakley, John Weidman, neviksti, Matthew Kendora, and
                     Lord Nightmare (lord_nightmare@users.sourceforge.net

  OBC1 emulator code
  (c) Copyright 2001 - 2004 zsKnight, pagefault (pagefault@zsnes.com) and
                            Kris Bleakley
  Ported from x86 assembler to C by sanmaiwashi

  SPC7110 and RTC C++ emulator code
  (c) Copyright 2002 Matthew Kendora with research by
                     zsKnight, John Weidman, and Dark Force

  S-DD1 C emulator code
  (c) Copyright 2003 Brad Jorsch with research by
                     Andreas Naive and John Weidman
 
  S-RTC C emulator code
  (c) Copyright 2001 John Weidman
  
  ST010 C++ emulator code
  (c) Copyright 2003 Feather, Kris Bleakley, John Weidman and Matthew Kendora

  Super FX x86 assembler emulator code 
  (c) Copyright 1998 - 2003 zsKnight, _Demo_, and pagefault 

  Super FX C emulator code 
  (c) Copyright 1997 - 1999 Ivar, Gary Henderson and John Weidman


  SH assembler code partly based on x86 assembler code
  (c) Copyright 2002 - 2004 Marcus Comstedt (marcus@mc.pp.se) 

 
  Specific ports contains the works of other authors. See headers in
  individual files.
 
  Snes9x homepage: http://www.snes9x.com
 
  Permission to use, copy, modify and distribute Snes9x in both binary and
  source form, for non-commercial purposes, is hereby granted without fee,
  providing that this license information and copyright notice appear with
  all copies and any derived work.
 
  This software is provided 'as-is', without any express or implied
  warranty. In no event shall the authors be held liable for any damages
  arising from the use of this software.
 
  Snes9x is freeware for PERSONAL USE only. Commercial users should
  seek permission of the copyright holders first. Commercial use includes
  charging money for Snes9x or software derived from Snes9x.
 
  The copyright holders request that bug fixes and improvements to the code
  should be forwarded to them so everyone can benefit from the modifications
  in future versions.
 
  Super NES and Super Nintendo Entertainment System are trademarks of
  Nintendo Co., Limited and its subsidiary companies.
*******************************************************************************/

#ifndef _PPU_H_
#define _PPU_H_

#define FIRST_VISIBLE_LINE 1

extern uint8 GetBank;
extern uint16 SignExtend [2];

#define TILE_2BIT 0
#define TILE_4BIT 1
#define TILE_8BIT 2

#define MAX_2BIT_TILES 4096
#define MAX_4BIT_TILES 2048
#define MAX_8BIT_TILES 1024

#define PPU_H_BEAM_IRQ_SOURCE	(1 << 0)
#define PPU_V_BEAM_IRQ_SOURCE	(1 << 1)
#define GSU_IRQ_SOURCE		(1 << 2)
#define SA1_IRQ_SOURCE		(1 << 7)
#define SA1_DMA_IRQ_SOURCE	(1 << 5)

struct ClipData {
    uint32  Count [6];
    uint32  Left [6][6];
    uint32  Right [6][6];
};

struct InternalPPU {
    bool8  ColorsChanged;
    uint8  HDMA;
    bool8  HDMAStarted;
    uint8  MaxBrightness;
    bool8  LatchedBlanking;
    bool8  OBJChanged;
    bool8  RenderThisFrame;
    bool8  DirectColourMapsNeedRebuild;
    uint32 FrameCount;
    uint32 RenderedFramesCount;
    uint32 DisplayedRenderedFrameCount;
    uint32 SkippedFrames;
    uint32 FrameSkip;
    uint8  *TileCache [3];
    uint8  *TileCached [3];
#ifdef CORRECT_VRAM_READS
    uint16 VRAMReadBuffer;
#else
    bool8  FirstVRAMRead;
#endif
    bool8  DoubleHeightPixels;
    bool8  Interlace;
    bool8  InterlaceSprites;
    bool8  DoubleWidthPixels;
    int    RenderedScreenHeight;
    int    RenderedScreenWidth;
    uint32 Red [256];
    uint32 Green [256];
    uint32 Blue [256];
    uint8  *XB;
    uint16 ScreenColors [256];
    int	   PreviousLine;
    int	   CurrentLine;
    int	   Controller;
    uint32 Joypads[5];
    uint32 SuperScope;
    uint32 Mouse[2];
    int    PrevMouseX[2];
    int    PrevMouseY[2];
    struct ClipData Clip [2];
};

struct SOBJ
{
    short  HPos;
    uint16 VPos;
    uint16 Name;
    uint8  VFlip;
    uint8  HFlip;
    uint8  Priority;
    uint8  Palette;
    uint8  Size;
};

struct SPPU {
    uint8  BGMode;
    uint8  BG3Priority;
    uint8  Brightness;

    struct {
	bool8 High;
	uint8 Increment;
	uint16 Address;
	uint16 Mask1;
	uint16 FullGraphicCount;
	uint16 Shift;
    } VMA;

    struct {
	uint16 SCBase;
	uint16 VOffset;
	uint16 HOffset;
	uint8 BGSize;
	uint16 NameBase;
	uint16 SCSize;
    } BG [4];

    bool8  CGFLIP;
    uint16 CGDATA [256]; 
    uint8  FirstSprite;
    uint8  LastSprite;
    struct SOBJ OBJ [128];
    uint8  OAMPriorityRotation;
    uint16 OAMAddr;
    uint8  RangeTimeOver;

    uint8  OAMFlip;
    uint16 OAMTileAddress;
    uint16 IRQVBeamPos;
    uint16 IRQHBeamPos;
    uint16 VBeamPosLatched;
    uint16 HBeamPosLatched;

    uint8  HBeamFlip;
    uint8  VBeamFlip;
    uint8  HVBeamCounterLatched;

    short  MatrixA;
    short  MatrixB;
    short  MatrixC;
    short  MatrixD;
    short  CentreX;
    short  CentreY;
    uint8  Joypad1ButtonReadPos;
    uint8  Joypad2ButtonReadPos;

    uint8  CGADD;
    uint8  FixedColourRed;
    uint8  FixedColourGreen;
    uint8  FixedColourBlue;
    uint16 SavedOAMAddr;
    uint16 ScreenHeight;
    uint32 WRAM;
    uint8  BG_Forced;
    bool8  ForcedBlanking;
    bool8  OBJThroughMain;
    bool8  OBJThroughSub;
    uint8  OBJSizeSelect;
    uint16 OBJNameBase;
    bool8  OBJAddition;
    uint8  OAMReadFlip;
    uint8  OAMData [512 + 32];
    bool8  VTimerEnabled;
    bool8  HTimerEnabled;
    short  HTimerPosition;
    uint8  Mosaic;
    bool8  BGMosaic [4];
    bool8  Mode7HFlip;
    bool8  Mode7VFlip;
    uint8  Mode7Repeat;
    uint8  Window1Left;
    uint8  Window1Right;
    uint8  Window2Left;
    uint8  Window2Right;
    uint8  ClipCounts [6];
    uint8  ClipWindowOverlapLogic [6];
    uint8  ClipWindow1Enable [6];
    uint8  ClipWindow2Enable [6];
    bool8  ClipWindow1Inside [6];
    bool8  ClipWindow2Inside [6];
    bool8  RecomputeClipWindows;
    uint8  CGFLIPRead;
    uint16 OBJNameSelect;
    bool8  Need16x8Mulitply;
    uint8  Joypad3ButtonReadPos;
    uint8  MouseSpeed[2];

    // XXX Do these need to be added to snapshot.cpp?
    uint8 BGnxOFSbyte;
    uint8 OpenBus1;
    uint8 OpenBus2;
};

#define CLIP_OR 0
#define CLIP_AND 1
#define CLIP_XOR 2
#define CLIP_XNOR 3

struct SDMA {
    bool8  TransferDirection;
    bool8  AAddressFixed;
    bool8  AAddressDecrement;
    uint8  TransferMode;

    uint8  ABank;
    uint16 AAddress;
    uint16 Address;
    uint8  BAddress;

    // General DMA only:
    uint16 TransferBytes;

    // H-DMA only:
    bool8  HDMAIndirectAddressing;
    uint16 IndirectAddress;
    uint8  IndirectBank;
    uint8  Repeat;
    uint8  LineCount;
    uint8  FirstLine;
};

START_EXTERN_C
void S9xUpdateScreen ();
void S9xResetPPU (bool8 full);
void S9xFixColourBrightness ();
void S9xUpdateJoypads ();
void S9xProcessMouse(int which1);
void S9xSuperFXExec ();

void S9xSetPPU (uint8 Byte, uint16 Address);
uint8 S9xGetPPU (uint16 Address);
void S9xSetCPU (uint8 Byte, uint16 Address);
uint8 S9xGetCPU (uint16 Address);

void S9xInitC4 ();
void S9xSetC4 (uint8 Byte, uint16 Address);
uint8 S9xGetC4 (uint16 Address);
void S9xSetC4RAM (uint8 Byte, uint16 Address);
uint8 S9xGetC4RAM (uint16 Address);

extern struct SPPU PPU;
extern struct SDMA DMA [8];
extern struct InternalPPU IPPU;

extern uint8 IPPU_MaxBrightness;
extern uint16 PPU_CGDATA []; 
END_EXTERN_C

#include "gfx.h"
#include "memmap.h"

typedef struct{
	uint8 _5C77;
	uint8 _5C78;
	uint8 _5A22;
} SnesModel;

extern SnesModel Model;
extern SnesModel M1SNES;
extern SnesModel M2SNES;

#define MAX_5C77_VERSION 0x01
#define MAX_5C78_VERSION 0x03
#define MAX_5A22_VERSION 0x02

STATIC inline uint8 REGISTER_4212()
{
    GetBank = 0;
    if (CPU.V_Counter >= PPU.ScreenHeight + FIRST_VISIBLE_LINE &&
	CPU.V_Counter < PPU.ScreenHeight + FIRST_VISIBLE_LINE + 3)
	GetBank = 1;

    GetBank |= CPU.Cycles >= Settings.HBlankStart ? 0x40 : 0;

    if (CPU.V_Counter >= PPU.ScreenHeight + FIRST_VISIBLE_LINE)
	GetBank |= 0x80; /* XXX: 0x80 or 0xc0 ? */
    return (GetBank);
}

STATIC inline void FLUSH_REDRAW ()
{
	//if(!(IPPU.RenderThisFrame == FALSE && IPPU.PreviousLine == 0 && IPPU.CurrentLine == 0))
	if (IPPU.PreviousLine != IPPU.CurrentLine)
		S9xUpdateScreen ();
}

STATIC inline void CLEAR_REDRAW ()
{
	if(IPPU.PreviousLine != CPU.V_Counter &&
	   CPU.V_Counter > SNES_HEIGHT &&
	   CPU.V_Counter <= SNES_HEIGHT_EXTENDED)
		S9xUpdateClearScreen ();
}

STATIC inline void REGISTER_2104 (uint8 byte)
{
	// OAM format
	// 4 bytes
	// 0byte X
	// 1byte Y
	//
	// 3-4 bytes
	// 0-8 bits pattern number
	// 9-11 bits palette number
	// 12-13 bits priority bits
	// 14 bit H-Flip
	// 15 bit V-Flip
	
	//"SUPER MAHJONG TAIKAI"
	if(PPU.OAMAddr >= 0x110 && CPU.InDMA) {
		if(PPU.OAMFlip & 1) {
			++PPU.OAMAddr;
		}
		PPU.OAMFlip ^= 1;
		return;
	}

	// byte access write 0x100-0x1FF(0x100-0x10F).
	if (PPU.OAMAddr & 0x100) {
		int addr = ((PPU.OAMAddr & 0x10f) << 1) + (PPU.OAMFlip & 1);
		if (byte != PPU.OAMData [addr]) {
			FLUSH_REDRAW ();
			PPU.OAMData [addr] = byte;
			IPPU.OBJChanged = TRUE;
			// X position high bit, and sprite size (x4)
			struct SOBJ *pObj = &PPU.OBJ [(addr & 0x1f) << 2];
			
			pObj->HPos = (pObj->HPos & 0xFF) | SignExtend[(byte >> 0) & 1];
			pObj++->Size = byte & 2;
			pObj->HPos = (pObj->HPos & 0xFF) | SignExtend[(byte >> 2) & 1];
			pObj++->Size = byte & 8;
			pObj->HPos = (pObj->HPos & 0xFF) | SignExtend[(byte >> 4) & 1];
			pObj++->Size = byte & 32;
			pObj->HPos = (pObj->HPos & 0xFF) | SignExtend[(byte >> 6) & 1];
			pObj->Size = byte & 128;
		}
		if(PPU.OAMFlip & 1) {
			++PPU.OAMAddr;
		}
		PPU.OAMFlip ^= 1;
	}
	else if(!(PPU.OAMFlip & 1)) {
		PPU.OAMFlip ^= 1;
	}
	// word access write 0x000-0x0FF.
	else {
		uint8 lowbyte = Memory.FillRAM [0x2104];
		uint8 highbyte = byte;
		
		//calc byte address for PPU.OAMData
		int addr = (PPU.OAMAddr & 0xff) << 1;
		
		if (lowbyte != PPU.OAMData [addr] || highbyte != PPU.OAMData [addr+1]) {
			FLUSH_REDRAW ();
			PPU.OAMData [addr] = lowbyte;
			PPU.OAMData [addr+1] = highbyte;
			IPPU.OBJChanged = TRUE;
			
			if (addr & 2) {
				// Tile
				PPU.OBJ[addr = (addr >> 2)].Name = (((uint16)highbyte << 8) | lowbyte) & 0x1ff;
				// priority, h and v flip.
				PPU.OBJ[addr].Palette = (highbyte >> 1) & 7;
				PPU.OBJ[addr].Priority = (highbyte >> 4) & 3;
				PPU.OBJ[addr].HFlip = (highbyte >> 6) & 1;
				PPU.OBJ[addr].VFlip = (highbyte >> 7) & 1;
			}
			else {
				// X position (low)
				PPU.OBJ[addr = (addr >> 2)].HPos &= 0xFF00;
				PPU.OBJ[addr].HPos |= lowbyte;
				// Sprite Y position
				PPU.OBJ[addr].VPos = highbyte;
			}
		}
		++PPU.OAMAddr;
		PPU.OAMFlip ^= 1;
	}
	Memory.FillRAM [0x2104] = byte;
}

STATIC inline void REGISTER_2118 (uint8 Byte)
{
    uint32 address;
    if (PPU.VMA.FullGraphicCount)
    {
	uint32 rem = PPU.VMA.Address & PPU.VMA.Mask1;
	address = (((PPU.VMA.Address & ~PPU.VMA.Mask1) +
			 (rem >> PPU.VMA.Shift) +
			 ((rem & (PPU.VMA.FullGraphicCount - 1)) << 3)) << 1) & 0xffff;
	Memory.VRAM [address] = Byte;
    }
    else
    {
	Memory.VRAM[address = (PPU.VMA.Address << 1) & 0xFFFF] = Byte;
    }
    IPPU.TileCached [TILE_2BIT][address >> 4] = FALSE;
    IPPU.TileCached [TILE_4BIT][address >> 5] = FALSE;
    IPPU.TileCached [TILE_8BIT][address >> 6] = FALSE;
    if (!PPU.VMA.High)
    {
#ifdef DEBUGGER
	if (Settings.TraceVRAM && !CPU.InDMA)
	{
	    printf ("VRAM write byte: $%04X (%d,%d)\n", PPU.VMA.Address,
		    Memory.FillRAM[0x2115] & 3,
		    (Memory.FillRAM [0x2115] & 0x0c) >> 2);
	}
#endif	
	PPU.VMA.Address += PPU.VMA.Increment;
    }
//    Memory.FillRAM [0x2118] = Byte;
}

//PPU.VMA.FullGraphicCount != 0
//
//00000100b Increment by 8 for 32 times (2-bit formation).
//0000h, 0008h, 0010h, 0018h, 0020h, 0028h, 0030h, 0038h,
//0040h, 0048h, 0050h, 0058h, 0060h, 0068h, 0070h, 0078h,
//0080h, 0088h, 0090h, 0098h, 00A0h, 00A8h, 00B0h, 00B8h,
//00C0h, 00C8h, 00D0h, 00D8h, 00E0h, 00E8h, 00F0h, 00F8h,
//
//0001h, 0009h, 0011h, 0019h, 0021h, 0029h, 0031h, 0039h,
//0041h, 0049h, 0051h, 0059h, 0061h, 0069h, 0071h, 0079h,
//0081h, 0089h, 0091h, 0099h, 00A1h, 00A9h, 00B1h, 00B9h,
//00C1h, 00C9h, 00D1h, 00D9h, 00E1h, 00E9h, 00F1h, 00F9h,
//
//0002h, 000Ah, 0012h, 001Ah, 0022h, 002Ah, 0032h, 003Ah,
//0042h, 004Ah, 0052h, 005Ah, 0062h, 006Ah, 0072h, 007Ah,
//0082h, 008Ah, 0092h, 009Ah, 00A2h, 00AAh, 00B2h, 00BAh,
//00C2h, 00CAh, 00D2h, 00DAh, 00E2h, 00EAh, 00F2h, 00FAh,
//
//0003h, 000Bh, 0013h, 001Bh, 0023h, 002Bh, 0033h, 003Bh,
//0043h, 004Bh, 0053h, 005Bh, 0063h, 006Bh, 0073h, 007Bh,
//0083h, 008Bh, 0093h, 009Bh, 00A3h, 00ABh, 00B3h, 00BBh,
//00C3h, 00CBh, 00D3h, 00DBh, 00E3h, 00EBh, 00F3h, 00FBh,
//
//0004h, 000Ch, 0014h, 001Ch, 0024h, 002Ch, 0034h, 003Ch,
//0044h, 004Ch, 0054h, 005Ch, 0064h, 006Ch, 0074h, 007Ch,
//0084h, 008Ch, 0094h, 009Ch, 00A4h, 00ACh, 00B4h, 00BCh,
//00C4h, 00CCh, 00D4h, 00DCh, 00E4h, 00ECh, 00F4h, 00FCh,
//
//0005h, 000Dh, 0015h, 001Dh, 0025h, 002Dh, 0035h, 003Dh,
//0045h, 004Dh, 0055h, 005Dh, 0065h, 006Dh, 0075h, 007Dh,
//0085h, 008Dh, 0095h, 009Dh, 00A5h, 00ADh, 00B5h, 00BDh,
//00C5h, 00CDh, 00D5h, 00DDh, 00E5h, 00EDh, 00F5h, 00FDh,
//
//0006h, 000Eh, 0016h, 001Eh, 0026h, 002Eh, 0036h, 003Eh,
//0046h, 004Eh, 0056h, 005Eh, 0066h, 006Eh, 0076h, 007Eh,
//0086h, 008Eh, 0096h, 009Eh, 00A6h, 00AEh, 00B6h, 00BEh,
//00C6h, 00CEh, 00D6h, 00DEh, 00E6h, 00EEh, 00F6h, 00FEh,
//
//0007h, 000Fh, 0017h, 001Fh, 0027h, 002Fh, 0037h, 003Fh,
//0047h, 004Fh, 0057h, 005Fh, 0067h, 006Fh, 0077h, 007Fh,
//0087h, 008Fh, 0097h, 009Fh, 00A7h, 00AFh, 00B7h, 00BFh,
//00C7h, 00CFh, 00D7h, 00DFh, 00E7h, 00EFh, 00F7h, 00FFh,
//
//
//0100h, 0108h, 0110h, 0118h, 0120h, 0128h, 0130h, 0138h,
//0140h, 0148h, 0150h, 0158h, 0160h, 0168h, 0170h, 0178h,
//0180h, 0188h, 0190h, 0198h, 01A0h, 01A8h, 01B0h, 01B8h,
//01C0h, 01C8h, 01D0h, 01D8h, 01E0h, 01E8h, 01F0h, 01F8h,
//
//0101h, 0109h, 0111h, 0119h, 0121h, 0129h, 0131h, 0139h,
//0141h, 0149h, 0151h, 0159h, 0161h, 0169h, 0171h, 0179h,
//0181h, 0189h, 0191h, 0199h, 01A1h, 01A9h, 01B1h, 01B9h,
//01C1h, 01C9h, 01D1h, 01D9h, 01E1h, 01E9h, 01F1h, 01F9h,
//
//0102h, 010Ah, 0112h, 011Ah, 0122h, 012Ah, 0132h, 013Ah,
//0142h, 014Ah, 0152h, 015Ah, 0162h, 016Ah, 0172h, 017Ah,
//0182h, 018Ah, 0192h, 019Ah, 01A2h, 01AAh, 01B2h, 01BAh,
//01C2h, 01CAh, 01D2h, 01DAh, 01E2h, 01EAh, 01F2h, 01FAh,
//
//0103h, 010Bh, 0113h, 011Bh, 0123h, 012Bh, 0133h, 013Bh,
//0143h, 014Bh, 0153h, 015Bh, 0163h, 016Bh, 0173h, 017Bh,
//0183h, 018Bh, 0193h, 019Bh, 01A3h, 01ABh, 01B3h, 01BBh,
//01C3h, 01CBh, 01D3h, 01DBh, 01E3h, 01EBh, 01F3h, 01FBh,
//
//0104h, 010Ch, 0114h, 011Ch, 0124h, 012Ch, 0134h, 013Ch,
//0144h, 014Ch, 0154h, 015Ch, 0164h, 016Ch, 0174h, 017Ch,
//0184h, 018Ch, 0194h, 019Ch, 01A4h, 01ACh, 01B4h, 01BCh,
//01C4h, 01CCh, 01D4h, 01DCh, 01E4h, 01ECh, 01F4h, 01FCh,
//
//0105h, 010Dh, 0115h, 011Dh, 0125h, 012Dh, 0135h, 013Dh,
//0145h, 014Dh, 0155h, 015Dh, 0165h, 016Dh, 0175h, 017Dh,
//0185h, 018Dh, 0195h, 019Dh, 01A5h, 01ADh, 01B5h, 01BDh,
//01C5h, 01CDh, 01D5h, 01DDh, 01E5h, 01EDh, 01F5h, 01FDh,
//
//0106h, 010Eh, 0116h, 011Eh, 0126h, 012Eh, 0136h, 013Eh,
//0146h, 014Eh, 0156h, 015Eh, 0166h, 016Eh, 0176h, 017Eh,
//0186h, 018Eh, 0196h, 019Eh, 01A6h, 01AEh, 01B6h, 01BEh,
//01C6h, 01CEh, 01D6h, 01DEh, 01E6h, 01EEh, 01F6h, 01FEh,
//
//0107h, 010Fh, 0117h, 011Fh, 0127h, 012Fh, 0137h, 013Fh,
//0147h, 014Fh, 0157h, 015Fh, 0167h, 016Fh, 0177h, 017Fh,
//0187h, 018Fh, 0197h, 019Fh, 01A7h, 01AFh, 01B7h, 01BFh,
//01C7h, 01CFh, 01D7h, 01DFh, 01E7h, 01EFh, 01F7h, 01FFh,
//
STATIC inline void REGISTER_2118_tile (uint8 Byte)
{
    uint32 address;
    uint32 rem = PPU.VMA.Address & PPU.VMA.Mask1;
    address = (((PPU.VMA.Address & ~PPU.VMA.Mask1) +
		 (rem >> PPU.VMA.Shift) +
		 ((rem & (PPU.VMA.FullGraphicCount - 1)) << 3)) << 1) & 0xffff;
    Memory.VRAM [address] = Byte;
    IPPU.TileCached [TILE_2BIT][address >> 4] = FALSE;
    IPPU.TileCached [TILE_4BIT][address >> 5] = FALSE;
    IPPU.TileCached [TILE_8BIT][address >> 6] = FALSE;
    if (!PPU.VMA.High)
	PPU.VMA.Address += PPU.VMA.Increment;
//    Memory.FillRAM [0x2118] = Byte;
}

STATIC inline void REGISTER_2118_linear (uint8 Byte)
{
    uint32 address;
    Memory.VRAM[address = (PPU.VMA.Address << 1) & 0xFFFF] = Byte;
    IPPU.TileCached [TILE_2BIT][address >> 4] = FALSE;
    IPPU.TileCached [TILE_4BIT][address >> 5] = FALSE;
    IPPU.TileCached [TILE_8BIT][address >> 6] = FALSE;
    if (!PPU.VMA.High)
	PPU.VMA.Address += PPU.VMA.Increment;
//    Memory.FillRAM [0x2118] = Byte;
}

STATIC inline void REGISTER_2119 (uint8 Byte)
{
    uint32 address;
    if (PPU.VMA.FullGraphicCount)
    {
	uint32 rem = PPU.VMA.Address & PPU.VMA.Mask1;
	address = ((((PPU.VMA.Address & ~PPU.VMA.Mask1) +
		    (rem >> PPU.VMA.Shift) +
		    ((rem & (PPU.VMA.FullGraphicCount - 1)) << 3)) << 1) + 1) & 0xFFFF;
	Memory.VRAM [address] = Byte;
    }
    else
    {
	Memory.VRAM[address = ((PPU.VMA.Address << 1) + 1) & 0xFFFF] = Byte;
    }
    IPPU.TileCached [TILE_2BIT][address >> 4] = FALSE;
    IPPU.TileCached [TILE_4BIT][address >> 5] = FALSE;
    IPPU.TileCached [TILE_8BIT][address >> 6] = FALSE;
    if (PPU.VMA.High)
    {
#ifdef DEBUGGER
	if (Settings.TraceVRAM && !CPU.InDMA)
	{
	    printf ("VRAM write word: $%04X (%d,%d)\n", PPU.VMA.Address,
		    Memory.FillRAM[0x2115] & 3,
		    (Memory.FillRAM [0x2115] & 0x0c) >> 2);
	}
#endif	
	PPU.VMA.Address += PPU.VMA.Increment;
    }
//    Memory.FillRAM [0x2119] = Byte;
}

STATIC inline void REGISTER_2119_tile (uint8 Byte)
{
    uint32 rem = PPU.VMA.Address & PPU.VMA.Mask1;
    uint32 address = ((((PPU.VMA.Address & ~PPU.VMA.Mask1) +
		    (rem >> PPU.VMA.Shift) +
		    ((rem & (PPU.VMA.FullGraphicCount - 1)) << 3)) << 1) + 1) & 0xFFFF;
    Memory.VRAM [address] = Byte;
    IPPU.TileCached [TILE_2BIT][address >> 4] = FALSE;
    IPPU.TileCached [TILE_4BIT][address >> 5] = FALSE;
    IPPU.TileCached [TILE_8BIT][address >> 6] = FALSE;
    if (PPU.VMA.High)
	PPU.VMA.Address += PPU.VMA.Increment;
//    Memory.FillRAM [0x2119] = Byte;
}

STATIC inline void REGISTER_2119_linear (uint8 Byte)
{
    uint32 address;
    Memory.VRAM[address = ((PPU.VMA.Address << 1) + 1) & 0xFFFF] = Byte;
    IPPU.TileCached [TILE_2BIT][address >> 4] = FALSE;
    IPPU.TileCached [TILE_4BIT][address >> 5] = FALSE;
    IPPU.TileCached [TILE_8BIT][address >> 6] = FALSE;
    if (PPU.VMA.High)
	PPU.VMA.Address += PPU.VMA.Increment;
//    Memory.FillRAM [0x2119] = Byte;
}

STATIC inline void REGISTER_2122(uint8 Byte)
{
    // CG-RAM (palette) write

    if (PPU.CGFLIP)
    {
	if ((Byte & 0x7f) != (PPU.CGDATA[PPU.CGADD] >> 8))
	{
	    if (Settings.SixteenBit)
		FLUSH_REDRAW ();
	    PPU.CGDATA[PPU.CGADD] &= 0x00FF;
	    PPU.CGDATA[PPU.CGADD] |= (Byte & 0x7f) << 8;
	    IPPU.ColorsChanged = TRUE;
	    if (Settings.SixteenBit)
	    {
		IPPU.Blue [PPU.CGADD] = IPPU.XB [(Byte >> 2) & 0x1f];
		IPPU.Green [PPU.CGADD] = IPPU.XB [(PPU.CGDATA[PPU.CGADD] >> 5) & 0x1f];
		IPPU.ScreenColors [PPU.CGADD] = (uint16) BUILD_PIXEL (IPPU.Red [PPU.CGADD],
							     IPPU.Green [PPU.CGADD],
							     IPPU.Blue [PPU.CGADD]);
	    }
	}
	PPU.CGADD++;
    }
    else
    {
	if (Byte != (uint8) (PPU.CGDATA[PPU.CGADD] & 0xff))
	{
	    if (Settings.SixteenBit)
		FLUSH_REDRAW ();
	    PPU.CGDATA[PPU.CGADD] &= 0x7F00;
	    PPU.CGDATA[PPU.CGADD] |= Byte;
	    IPPU.ColorsChanged = TRUE;
	    if (Settings.SixteenBit)
	    {
		IPPU.Red [PPU.CGADD] = IPPU.XB [Byte & 0x1f];
		IPPU.Green [PPU.CGADD] = IPPU.XB [(PPU.CGDATA[PPU.CGADD] >> 5) & 0x1f];
		IPPU.ScreenColors [PPU.CGADD] = (uint16) BUILD_PIXEL (IPPU.Red [PPU.CGADD],
							     IPPU.Green [PPU.CGADD],
							     IPPU.Blue [PPU.CGADD]);
	    }
	}
    }
    PPU.CGFLIP ^= 1;
//    Memory.FillRAM [0x2122] = Byte;
}

STATIC inline void REGISTER_2180(uint8 Byte)
{
    Memory.RAM[PPU.WRAM++] = Byte;
    PPU.WRAM &= 0x1FFFF;
    Memory.FillRAM [0x2180] = Byte;
}


//Platform specific input functions used by PPU.CPP
void JustifierButtons(uint32&);
bool JustifierOffscreen();

#endif

