/*******************************************************************************
  Snes9x - Portable Super Nintendo Entertainment System (TM) emulator.
 
  (c) Copyright 1996 - 2003 Gary Henderson (gary.henderson@ntlworld.com) and
                            Jerremy Koot (jkoot@snes9x.com)

  (c) Copyright 2002 - 2003 Matthew Kendora and
                            Brad Jorsch (anomie@users.sourceforge.net)
 

                      
  C4 x86 assembler and some C emulation code
  (c) Copyright 2000 - 2003 zsKnight (zsknight@zsnes.com),
                            _Demo_ (_demo_@zsnes.com), and
                            Nach (n-a-c-h@users.sourceforge.net)
                                          
  C4 C++ code
  (c) Copyright 2003 Brad Jorsch

  DSP-1 emulator code
  (c) Copyright 1998 - 2003 Ivar (ivar@snes9x.com), _Demo_, Gary Henderson,
                            John Weidman (jweidman@slip.net),
                            neviksti (neviksti@hotmail.com), and
                            Kris Bleakley (stinkfish@bigpond.com)
 
  DSP-2 emulator code
  (c) Copyright 2003 Kris Bleakley, John Weidman, neviksti, Matthew Kendora, and
                     Lord Nightmare (lord_nightmare@users.sourceforge.net

  OBC1 emulator code
  (c) Copyright 2001 - 2003 zsKnight, pagefault (pagefault@zsnes.com)
  Ported from x86 assembler to C by sanmaiwashi

  SPC7110 and RTC C++ emulator code
  (c) Copyright 2002 Matthew Kendora with research by
                     zsKnight, John Weidman, and Dark Force

  S-RTC C emulator code
  (c) Copyright 2001 John Weidman
  
  Super FX x86 assembler emulator code 
  (c) Copyright 1998 - 2003 zsKnight, _Demo_, and pagefault 

  Super FX C emulator code 
  (c) Copyright 1997 - 1999 Ivar and Gary Henderson.

  S-DD1 decompression code
  (c) Copyright 2003 Jose Luis Bravo

 
  Specific ports contains the works of other authors. See headers in
  individual files.
 
  Snes9x homepage: http://www.snes9x.com
 
  Permission to use, copy, modify and distribute Snes9x in both binary and
  source form, for non-commercial purposes, is hereby granted without fee,
  providing that this license information and copyright notice appear with
  all copies and any derived work.
 
  This software is provided 'as-is', without any express or implied
  warranty. In no event shall the authors be held liable for any damages
  arising from the use of this software.
 
  Snes9x is freeware for PERSONAL USE only. Commercial users should
  seek permission of the copyright holders first. Commercial use includes
  charging money for Snes9x or software derived from Snes9x.
 
  The copyright holders request that bug fixes and improvements to the code
  should be forwarded to them so everyone can benefit from the modifications
  in future versions.
 
  Super NES and Super Nintendo Entertainment System are trademarks of
  Nintendo Co., Limited and its subsidiary companies.
*******************************************************************************/
#include "asmstruc.h"
#include "asmops.h"
#include "spcops.h"

/* Asm notes: */
/* "%esi %edi %ebx" are preserved by C routine and returned. */

.globl MainAsmLoop

.text
	.align 4
.globl S9xMainLoop
S9xMainLoop:
		PUSH_REGISTERS
		LOAD_REGISTERS
		jmp .CHECK_FLAGS
	.align 4
.CHECK_FLAGS:
		testl $~0, Flags
		jz .OPEXEC
		movl Flags, %eax
		testl $NMI_FLAG, %eax
		jz .NO_NMI
#ifdef NEW_INTERRUPT_DELAY
		cmpl CYCLES, NMICycleCount
		jg .NO_NMI
#else
		decl NMICycleCount
		jnz .NO_NMI
#endif
		andl $~NMI_FLAG, %eax
		movl %eax, Flags
#ifdef NEW_INTERRUPT_DELAY
		movl $MAX_CYCLES, NMICycleCount
#endif
		testb $0xFF, WaitingForInterrupt
		jz .NO_WAI
		movb $0, WaitingForInterrupt
		incl PC
.NO_WAI:
		call S9xOpcode_NMI
.NO_NMI:
#ifdef DEBUGGER
		testl $BREAK_FLAG, Flags
		jz .NO_BREAK_POINTS
		pushl %esi
		pushl %ebx
		movl $S9xBreakpoint, %esi
		movb PB, %bl
		xorl %edx, %edx
		movl PC, %ecx
		subl PCBase, %ecx

.BREAK_CHECK_LOOP:
		movzwl %dx, %eax
		sall $2, %eax
		cmpb $0, S9xBreakpoint(%eax)
		je .BREAK_MATCH_FAILED
		cmpb %bl, 1(%esi, %eax)
		jne .BREAK_MATCH_FAILED
		movzwl 2(%esi, %eax), %eax
		cmpl %ecx, %eax
		jne .BREAK_MATCH_FAILED
		orb $DEBUG_MODE_FLAG, Flags
.BREAK_MATCH_FAILED:
		incw %dx
		cmpw $6, %dx
		jne .BREAK_CHECK_LOOP
		popl %ebx
		popl %esi
.NO_BREAK_POINTS:
#endif
		testl $IRQ_PENDING_FLAG, Flags
		jz .NO_PENDING_IRQ
		cmpl $0, IRQCycleCount
		jne .WAI_PROCEED
		cmpb $0, WaitingForInterrupt
		je .NOT_WAITING
		movb $0, WaitingForInterrupt
		incl PC
.NOT_WAITING:
		cmpb $0, IRQActive
		je .CLEAR_PENDING_IRQ_FLAG
		testb $IRQ, FLAGS
		jnz .NO_PENDING_IRQ
		cmpb $0, DisableIRQ
		jne .NO_PENDING_IRQ
		call S9xOpcode_IRQ
		jmp .NO_PENDING_IRQ

.CLEAR_PENDING_IRQ_FLAG:
		andl $~IRQ_PENDING_FLAG, Flags
		jmp .NO_PENDING_IRQ

.WAI_PROCEED:
		decl IRQCycleCount
		jnz .NO_PENDING_IRQ
		testb $IRQ, FLAGS
		jz .NO_PENDING_IRQ
#if 0
		cmpb $0, WaitingForInterrupt
		je .NO_WAI_PROCEED
		movb $0, WaitingForInterrupt
		incl PC
#endif
.NO_WAI_PROCEED:
		movl $1, IRQCycleCount

.NO_PENDING_IRQ:
#ifdef DEBUGGER
		movl Flags, %eax
		testl $DEBUG_MODE_FLAG,%eax
		jnz .SYNC_SPEED
#else
		movl Flags, %eax
#endif
		testl $SCAN_KEYS_FLAG, %eax
		jnz .SYNC_SPEED

#ifdef DEBUGGER
		testl $TRACE_FLAG, %eax
		jz .NO_TRACE
		STORE_REGISTERS
		ccall S9xTrace
		LOAD_REGISTERS
.NO_TRACE:
		movl Flags, %eax
		testl $SINGLE_STEP_FLAG, %eax
		jz .OPEXEC
		andl $~SINGLE_STEP_FLAG, %eax
		orl $DEBUG_MODE_FLAG, %eax
		movl %eax, Flags
#endif

.OPEXEC:
#ifdef CPU_SHUTDOWN
		movl PC, PCAtOpcodeStart
#endif	
		xorl %eax,%eax
		movb (PC), %al
		addl MemSpeed, CYCLES
		movl CPUOpcodes, %ecx
		incl PC
		jmp *(%ecx,%eax,4)
MainAsmLoop:
		testb $0xFF, SA1Executing
		jz .CHECK_EVENT
		STORE_REGISTERS
		call S9xSA1MainLoop
		LOAD_REGISTERS

.CHECK_EVENT:
		cmpl NextEvent, CYCLES
		jl .CHECK_APU_EVENT
		SAVE_CYCLES
		ccall S9xDoHBlankProcessing
		cmpl NextAPUTimerPos, CYCLES
		jl .CHECK_EVENT_LOAD_END
		ccall S9xAPUMainLoop
.CHECK_EVENT_LOAD_END:
		LOAD_CYCLES
		jmp .CHECK_FLAGS
	.align 4
.CHECK_APU_EVENT:
		cmpl NextAPUTimerPos, CYCLES
		jl .CHECK_EVENT_END
		SAVE_CYCLES
		ccall S9xAPUMainLoop
.CHECK_EVENT_END:
		jmp .CHECK_FLAGS

	.align 4
.SYNC_SPEED:
		STORE_REGISTERS
		movl Flags, %eax
		testl $SCAN_KEYS_FLAG, %eax
		jz .NO_SCAN_KEYS
		andl $~SCAN_KEYS_FLAG, %eax
		movl %eax, Flags
#ifdef DEBUGGER
		testl $FRAME_ADVANCE_FLAG, %eax
		jnz .NO_SCAN_KEYS
#endif
		ccall S9xSyncSpeed
.NO_SCAN_KEYS:
		POP_REGISTERS
		ret

