#include "snes9x.h"
#include "memmap.h"
#include "ppu.h"
#include "cpuexec.h"
#include "display.h"
#include "gfx.h"
#include "apu.h"
#include "cheats.h"

extern "C" {
void (*pS9xUpdateScreen)() = S9xUpdateScreen;
}

void DrawTile (uint32 Tile, uint32 Offset, uint32 StartLine,
	       uint32 LineCount);
void DrawClippedTile (uint32 Tile, uint32 Offset,
		      uint32 StartPixel, uint32 Width,
		      uint32 StartLine, uint32 LineCount);
void DrawLargePixel (uint32 Tile, uint32 Offset,
		     uint32 StartPixel, uint32 Pixels,
		     uint32 StartLine, uint32 LineCount);
void DrawTile16 (uint32 Tile, uint32 Offset, uint32 StartLine,
	         uint32 LineCount);
void DrawClippedTile16 (uint32 Tile, uint32 Offset,
		        uint32 StartPixel, uint32 Width,
		        uint32 StartLine, uint32 LineCount);
void DrawLargePixel16 (uint32 Tile, uint32 Offset,
		       uint32 StartPixel, uint32 Pixels,
		       uint32 StartLine, uint32 LineCount);

extern NormalTileRenderer DrawTilePtr;
extern ClippedTileRenderer DrawClippedTilePtr;
extern NormalTileRenderer DrawHiResTilePtr;
extern ClippedTileRenderer DrawHiResClippedTilePtr;
extern LargePixelRenderer DrawLargePixelPtr;

void S9xSwitchGFXengine(bool8 engine2flag)
{
		PPU.BG_Forced = 0;
		IPPU.OBJChanged = TRUE;
		IPPU.DirectColourMapsNeedRebuild = TRUE;
		GFX.PixSize = 1;
		if (Settings.SixteenBit)
		{
			DrawTilePtr = DrawTile16;
			DrawClippedTilePtr = DrawClippedTile16;
			DrawLargePixelPtr = DrawLargePixel16;
			DrawHiResTilePtr= DrawTile16;
			DrawHiResClippedTilePtr = DrawClippedTile16;
		}
		else
		{
			DrawTilePtr = DrawTile;
			DrawClippedTilePtr = DrawClippedTile;
			DrawLargePixelPtr = DrawLargePixel;
			DrawHiResTilePtr = DrawTile;
			DrawHiResClippedTilePtr = DrawClippedTile;
		}
		pS9xUpdateScreen = S9xUpdateScreen;

}

//#include <time.h>

int S9xCheckPixform()
{
	if(MAX_RED == MAX_RED_RGB565
		&& MAX_GREEN == MAX_GREEN_RGB565
		&& MAX_BLUE == MAX_BLUE_RGB565
		&& RED_LOW_BIT_MASK == RED_LOW_BIT_MASK_RGB565
		&& GREEN_LOW_BIT_MASK == GREEN_LOW_BIT_MASK_RGB565
		&& BLUE_LOW_BIT_MASK == BLUE_LOW_BIT_MASK_RGB565
		&& RED_HI_BIT_MASK == RED_HI_BIT_MASK_RGB565
		&& GREEN_HI_BIT_MASK == GREEN_HI_BIT_MASK_RGB565
		&& BLUE_HI_BIT_MASK == BLUE_HI_BIT_MASK_RGB565
		&& FIRST_COLOR_MASK == FIRST_COLOR_MASK_RGB565
		&& SECOND_COLOR_MASK == SECOND_COLOR_MASK_RGB565
		&& THIRD_COLOR_MASK == THIRD_COLOR_MASK_RGB565) {
		return RGB565;
	}
	else if(MAX_RED == MAX_RED_RGB555
		&& MAX_GREEN == MAX_GREEN_RGB555
		&& MAX_BLUE == MAX_BLUE_RGB555
		&& RED_LOW_BIT_MASK == RED_LOW_BIT_MASK_RGB555
		&& GREEN_LOW_BIT_MASK == GREEN_LOW_BIT_MASK_RGB555
		&& BLUE_LOW_BIT_MASK == BLUE_LOW_BIT_MASK_RGB555
		&& RED_HI_BIT_MASK == RED_HI_BIT_MASK_RGB555
		&& GREEN_HI_BIT_MASK == GREEN_HI_BIT_MASK_RGB555
		&& BLUE_HI_BIT_MASK == BLUE_HI_BIT_MASK_RGB555
		&& FIRST_COLOR_MASK == FIRST_COLOR_MASK_RGB555
		&& SECOND_COLOR_MASK == SECOND_COLOR_MASK_RGB555
		&& THIRD_COLOR_MASK == THIRD_COLOR_MASK_RGB555) {
		return RGB555;
	}
	else if(MAX_RED == MAX_RED_BGR565
		&& MAX_GREEN == MAX_GREEN_BGR565
		&& MAX_BLUE == MAX_BLUE_BGR565
		&& RED_LOW_BIT_MASK == RED_LOW_BIT_MASK_BGR565
		&& GREEN_LOW_BIT_MASK == GREEN_LOW_BIT_MASK_BGR565
		&& BLUE_LOW_BIT_MASK == BLUE_LOW_BIT_MASK_BGR565
		&& RED_HI_BIT_MASK == RED_HI_BIT_MASK_BGR565
		&& GREEN_HI_BIT_MASK == GREEN_HI_BIT_MASK_BGR565
		&& BLUE_HI_BIT_MASK == BLUE_HI_BIT_MASK_BGR565
		&& FIRST_COLOR_MASK == FIRST_COLOR_MASK_BGR565
		&& SECOND_COLOR_MASK == SECOND_COLOR_MASK_BGR565
		&& THIRD_COLOR_MASK == THIRD_COLOR_MASK_BGR565) {
		return BGR565;
	}
	else if(MAX_RED == MAX_RED_BGR555
		&& MAX_GREEN == MAX_GREEN_BGR555
		&& MAX_BLUE == MAX_BLUE_BGR555
		&& RED_LOW_BIT_MASK == RED_LOW_BIT_MASK_BGR555
		&& GREEN_LOW_BIT_MASK == GREEN_LOW_BIT_MASK_BGR555
		&& BLUE_LOW_BIT_MASK == BLUE_LOW_BIT_MASK_BGR555
		&& RED_HI_BIT_MASK == RED_HI_BIT_MASK_BGR555
		&& GREEN_HI_BIT_MASK == GREEN_HI_BIT_MASK_BGR555
		&& BLUE_HI_BIT_MASK == BLUE_HI_BIT_MASK_BGR555
		&& FIRST_COLOR_MASK == FIRST_COLOR_MASK_BGR555
		&& SECOND_COLOR_MASK == SECOND_COLOR_MASK_BGR555
		&& THIRD_COLOR_MASK == THIRD_COLOR_MASK_BGR555) {
		return BGR555;
	}
	else if(MAX_RED == MAX_RED_GBR565
		&& MAX_GREEN == MAX_GREEN_GBR565
		&& MAX_BLUE == MAX_BLUE_GBR565
		&& RED_LOW_BIT_MASK == RED_LOW_BIT_MASK_GBR565
		&& GREEN_LOW_BIT_MASK == GREEN_LOW_BIT_MASK_GBR565
		&& BLUE_LOW_BIT_MASK == BLUE_LOW_BIT_MASK_GBR565
		&& RED_HI_BIT_MASK == RED_HI_BIT_MASK_GBR565
		&& GREEN_HI_BIT_MASK == GREEN_HI_BIT_MASK_GBR565
		&& BLUE_HI_BIT_MASK == BLUE_HI_BIT_MASK_GBR565
		&& FIRST_COLOR_MASK == FIRST_COLOR_MASK_GBR565
		&& SECOND_COLOR_MASK == SECOND_COLOR_MASK_GBR565
		&& THIRD_COLOR_MASK == THIRD_COLOR_MASK_GBR565) {
		return GBR565;
	}
	else if(MAX_RED == MAX_RED_GBR555
		&& MAX_GREEN == MAX_GREEN_GBR555
		&& MAX_BLUE == MAX_BLUE_GBR555
		&& RED_LOW_BIT_MASK == RED_LOW_BIT_MASK_GBR555
		&& GREEN_LOW_BIT_MASK == GREEN_LOW_BIT_MASK_GBR555
		&& BLUE_LOW_BIT_MASK == BLUE_LOW_BIT_MASK_GBR555
		&& RED_HI_BIT_MASK == RED_HI_BIT_MASK_GBR555
		&& GREEN_HI_BIT_MASK == GREEN_HI_BIT_MASK_GBR555
		&& BLUE_HI_BIT_MASK == BLUE_HI_BIT_MASK_GBR555
		&& FIRST_COLOR_MASK == FIRST_COLOR_MASK_GBR555
		&& SECOND_COLOR_MASK == SECOND_COLOR_MASK_GBR555
		&& THIRD_COLOR_MASK == THIRD_COLOR_MASK_GBR555) {
		return GBR555;
	}
	else {
		return RGB565;
	}
}
