// debug
static int block;								// current block number
//extern int c;

// op control
static int8 DSP4_Logic;					// controls op flow

// projection format
static const int16 PLANE_START = 0x7fff;	// starting distance

static int16 view_plane;					// viewer location
static int16 far_plane;					// next milestone into screen
static int16 segments;						// # raster segments to draw
static int16 raster;							// current raster line

static int16 project_x;					// current x-position
static int16 project_y;					// current y-position

static int16 project_centerx;		// x-target of projection
static int16 project_centery;		// y-target of projection

static int16 project_x1;					// current x-distance
static int16 project_x1low;			// lower 16-bits
static int16 project_y1;					// current y-distance
static int16 project_y1low;			// lower 16-bits

static int16 project_x2;					// next projected x-distance
static int16 project_y2;					// next projected y-distance

static int16 project_pitchx;			// delta center
static int16 project_pitchxlow;	// lower 16-bits
static int16 project_pitchy;			// delta center
static int16 project_pitchylow;	// lower 16-bits

static int16 project_focalx;			// x-point of projection at viewer plane
static int16 project_focaly;			// y-point of projection at viewer plane

static int16 project_ptr;				// data structure pointer

// render window
static int16 center_x;						// x-center of viewport
static int16 center_y;						// y-center of viewport
static int16 viewport_left;			// x-left of viewport
static int16 viewport_right;			// x-right of viewport
static int16 viewport_top;				// y-top of viewport
static int16 viewport_bottom;		// y-bottom of viewport

// sprite structure
static int16 sprite_x;						// projected x-pos of sprite
static int16 sprite_y;						// projected y-pos of sprite
static int16 sprite_offset;			// data pointer offset
static int8 sprite_type;					// vehicle, terrain
static bool8 sprite_size;				// sprite size: 8x8 or 16x16

// path strips
static int16 path_clipRight[4];		// value to clip to for x>b
static int16 path_clipLeft[4];			// value to clip to for x<a
static int16 path_pos[4];					// x-positions of lanes
static int16 path_ptr[4];					// data structure pointers
static int16 path_raster[4];				// current raster
static int16 path_top[4];					// viewport_top

static int16 path_y[2];						// current y-position
static int16 path_x[2];						// current focals
static int16 path_plane[2];				// previous plane

// op09 window sorting
static int16 multi_index1;					// index counter
static int16 multi_index2;					// index counter
static bool8 op09_mode;						// window mode

// multi-op storage
static int16 multi_focaly[64];			// focal_y values
static int16 multi_farplane[4];		// farthest drawn distance
static int16 multi_raster[4];			// line where track stops

// OAM
static int8 op06_OAM[32];					// OAM (size,MSB) data
static int8 op06_index;						// index into OAM table
static int8 op06_offset;						// offset into OAM table

static short MaxTilesPerRow = 0;
static short RowCount[32];
