/*******************************************************************************
  Snes9x - Portable Super Nintendo Entertainment System (TM) emulator.
 
  (c) Copyright 1996 - 2002 Gary Henderson (gary.henderson@ntlworld.com) and
                            Jerremy Koot (jkoot@snes9x.com)

  (c) Copyright 2001 - 2004 John Weidman (jweidman@slip.net)

  (c) Copyright 2002 - 2004 Brad Jorsch (anomie@users.sourceforge.net),
                            funkyass (funkyass@spam.shaw.ca),
                            Joel Yliluoma (http://iki.fi/bisqwit/)
                            Kris Bleakley (codeviolation@hotmail.com),
                            Matthew Kendora,
                            Nach (n-a-c-h@users.sourceforge.net),
                            Peter Bortas (peter@bortas.org) and
                            zones (kasumitokoduck@yahoo.com)

  C4 x86 assembler and some C emulation code
  (c) Copyright 2000 - 2003 zsKnight (zsknight@zsnes.com),
                            _Demo_ (_demo_@zsnes.com), and Nach

  C4 C++ code
  (c) Copyright 2003 Brad Jorsch

  DSP-1 emulator code
  (c) Copyright 1998 - 2004 Ivar (ivar@snes9x.com), _Demo_, Gary Henderson,
                            John Weidman, neviksti (neviksti@hotmail.com),
                            Kris Bleakley, Andreas Naive

  DSP-2 emulator code
  (c) Copyright 2003 Kris Bleakley, John Weidman, neviksti, Matthew Kendora, and
                     Lord Nightmare (lord_nightmare@users.sourceforge.net

  OBC1 emulator code
  (c) Copyright 2001 - 2004 zsKnight, pagefault (pagefault@zsnes.com) and
                            Kris Bleakley
  Ported from x86 assembler to C by sanmaiwashi

  SPC7110 and RTC C++ emulator code
  (c) Copyright 2002 Matthew Kendora with research by
                     zsKnight, John Weidman, and Dark Force

  S-DD1 C emulator code
  (c) Copyright 2003 Brad Jorsch with research by
                     Andreas Naive and John Weidman
 
  S-RTC C emulator code
  (c) Copyright 2001 John Weidman
  
  ST010 C++ emulator code
  (c) Copyright 2003 Feather, Kris Bleakley, John Weidman and Matthew Kendora

  Super FX x86 assembler emulator code 
  (c) Copyright 1998 - 2003 zsKnight, _Demo_, and pagefault 

  Super FX C emulator code 
  (c) Copyright 1997 - 1999 Ivar, Gary Henderson and John Weidman


  SH assembler code partly based on x86 assembler code
  (c) Copyright 2002 - 2004 Marcus Comstedt (marcus@mc.pp.se) 

 
  Specific ports contains the works of other authors. See headers in
  individual files.
 
  Snes9x homepage: http://www.snes9x.com
 
  Permission to use, copy, modify and distribute Snes9x in both binary and
  source form, for non-commercial purposes, is hereby granted without fee,
  providing that this license information and copyright notice appear with
  all copies and any derived work.
 
  This software is provided 'as-is', without any express or implied
  warranty. In no event shall the authors be held liable for any damages
  arising from the use of this software.
 
  Snes9x is freeware for PERSONAL USE only. Commercial users should
  seek permission of the copyright holders first. Commercial use includes
  charging money for Snes9x or software derived from Snes9x.
 
  The copyright holders request that bug fixes and improvements to the code
  should be forwarded to them so everyone can benefit from the modifications
  in future versions.
 
  Super NES and Super Nintendo Entertainment System are trademarks of
  Nintendo Co., Limited and its subsidiary companies.
*******************************************************************************/

static uint16 DSP3_DataROM[1024] = {
	0x8000, 0x4000, 0x2000, 0x1000, 0x0800, 0x0400, 0x0200, 0x0100,
	0x0080, 0x0040, 0x0020, 0x0010, 0x0008, 0x0004, 0x0002, 0x0001,
	0x0002, 0x0004, 0x0008, 0x0010, 0x0020, 0x0040, 0x0080, 0x0100,
	0x0000, 0x000f, 0x0400, 0x0200, 0x0140, 0x0400, 0x0200, 0x0040,
	0x007d, 0x007e, 0x007e, 0x007b, 0x007c, 0x007d, 0x007b, 0x007c,
	0x0002, 0x0020, 0x0030, 0x0000, 0x000d, 0x0019, 0x0026, 0x0032,
	0x003e, 0x004a, 0x0056, 0x0062, 0x006d, 0x0079, 0x0084, 0x008e,
	0x0098, 0x00a2, 0x00ac, 0x00b5, 0x00be, 0x00c6, 0x00ce, 0x00d5,
	0x00dc, 0x00e2, 0x00e7, 0x00ec, 0x00f1, 0x00f5, 0x00f8, 0x00fb,
	0x00fd, 0x00ff, 0x0100, 0x0100, 0x0100, 0x00ff, 0x00fd, 0x00fb,
	0x00f8, 0x00f5, 0x00f1, 0x00ed, 0x00e7, 0x00e2, 0x00dc, 0x00d5,
	0x00ce, 0x00c6, 0x00be, 0x00b5, 0x00ac, 0x00a2, 0x0099, 0x008e,
	0x0084, 0x0079, 0x006e, 0x0062, 0x0056, 0x004a, 0x003e, 0x0032,
	0x0026, 0x0019, 0x000d, 0x0000, 0xfff3, 0xffe7, 0xffdb, 0xffce,
	0xffc2, 0xffb6, 0xffaa, 0xff9e, 0xff93, 0xff87, 0xff7d, 0xff72,
	0xff68, 0xff5e, 0xff54, 0xff4b, 0xff42, 0xff3a, 0xff32, 0xff2b,
	0xff25, 0xff1e, 0xff19, 0xff14, 0xff0f, 0xff0b, 0xff08, 0xff05,
	0xff03, 0xff01, 0xff00, 0xff00, 0xff00, 0xff01, 0xff03, 0xff05,
	0xff08, 0xff0b, 0xff0f, 0xff13, 0xff18, 0xff1e, 0xff24, 0xff2b,
	0xff32, 0xff3a, 0xff42, 0xff4b, 0xff54, 0xff5d, 0xff67, 0xff72,
	0xff7c, 0xff87, 0xff92, 0xff9e, 0xffa9, 0xffb5, 0xffc2, 0xffce,
	0xffda, 0xffe7, 0xfff3, 0x002b, 0x007f, 0x0020, 0x00ff, 0xff00,
	0xffbe, 0x0000, 0x0044, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
	0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
	0x0000, 0x0000, 0x0000, 0x0000, 0xffc1, 0x0001, 0x0002, 0x0045,
	0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
	0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
	0xffc5, 0x0003, 0x0004, 0x0005, 0x0047, 0x0000, 0x0000, 0x0000,
	0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
	0x0000, 0x0000, 0x0000, 0x0000, 0xffca, 0x0006, 0x0007, 0x0008,
	0x0009, 0x004a, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
	0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
	0xffd0, 0x000a, 0x000b, 0x000c, 0x000d, 0x000e, 0x004e, 0x0000,
	0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
	0x0000, 0x0000, 0x0000, 0x0000, 0xffd7, 0x000f, 0x0010, 0x0011,
	0x0012, 0x0013, 0x0014, 0x0053, 0x0000, 0x0000, 0x0000, 0x0000,
	0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
	0xffdf, 0x0015, 0x0016, 0x0017, 0x0018, 0x0019, 0x001a, 0x001b,
	0x0059, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
	0x0000, 0x0000, 0x0000, 0x0000, 0xffe8, 0x001c, 0x001d, 0x001e,
	0x001f, 0x0020, 0x0021, 0x0022, 0x0023, 0x0060, 0x0000, 0x0000,
	0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
	0xfff2, 0x0024, 0x0025, 0x0026, 0x0027, 0x0028, 0x0029, 0x002a,
	0x002b, 0x002c, 0x0068, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
	0x0000, 0x0000, 0x0000, 0x0000, 0xfffd, 0x002d, 0x002e, 0x002f,
	0x0030, 0x0031, 0x0032, 0x0033, 0x0034, 0x0035, 0x0036, 0x0071,
	0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
	0xffc7, 0x0037, 0x0038, 0x0039, 0x003a, 0x003b, 0x003c, 0x003d,
	0x003e, 0x003f, 0x0040, 0x0041, 0x007b, 0x0000, 0x0000, 0x0000,
	0x0000, 0x0000, 0x0000, 0x0000, 0xffd4, 0x0000, 0x0001, 0x0002,
	0x0003, 0x0004, 0x0005, 0x0006, 0x0007, 0x0008, 0x0009, 0x000a,
	0x000b, 0x0044, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
	0xffe2, 0x000c, 0x000d, 0x000e, 0x000f, 0x0010, 0x0011, 0x0012,
	0x0013, 0x0014, 0x0015, 0x0016, 0x0017, 0x0018, 0x0050, 0x0000,
	0x0000, 0x0000, 0x0000, 0x0000, 0xfff1, 0x0019, 0x001a, 0x001b,
	0x001c, 0x001d, 0x001e, 0x001f, 0x0020, 0x0021, 0x0022, 0x0023,
	0x0024, 0x0025, 0x0026, 0x005d, 0x0000, 0x0000, 0x0000, 0x0000,
	0xffcb, 0x0027, 0x0028, 0x0029, 0x002a, 0x002b, 0x002c, 0x002d,
	0x002e, 0x002f, 0x0030, 0x0031, 0x0032, 0x0033, 0x0034, 0x0035,
	0x006b, 0x0000, 0x0000, 0x0000, 0xffdc, 0x0000, 0x0001, 0x0002,
	0x0003, 0x0004, 0x0005, 0x0006, 0x0007, 0x0008, 0x0009, 0x000a,
	0x000b, 0x000c, 0x000d, 0x000e, 0x000f, 0x0044, 0x0000, 0x0000,
	0xffee, 0x0010, 0x0011, 0x0012, 0x0013, 0x0014, 0x0015, 0x0016,
	0x0017, 0x0018, 0x0019, 0x001a, 0x001b, 0x001c, 0x001d, 0x001e,
	0x001f, 0x0020, 0x0054, 0x0000, 0xffee, 0x0021, 0x0022, 0x0023,
	0x0024, 0x0025, 0x0026, 0x0027, 0x0028, 0x0029, 0x002a, 0x002b,
	0x002c, 0x002d, 0x002e, 0x002f, 0x0030, 0x0031, 0x0032, 0x0065,
	0xffbe, 0x0000, 0xfeac, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
	0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
	0x0000, 0x0000, 0x0000, 0x0000, 0xffc1, 0x0001, 0x0002, 0xfead,
	0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
	0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
	0xffc5, 0x0003, 0x0004, 0x0005, 0xfeaf, 0x0000, 0x0000, 0x0000,
	0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
	0x0000, 0x0000, 0x0000, 0x0000, 0xffca, 0x0006, 0x0007, 0x0008,
	0x0009, 0xfeb2, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
	0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
	0xffd0, 0x000a, 0x000b, 0x000c, 0x000d, 0x000e, 0xfeb6, 0x0000,
	0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
	0x0000, 0x0000, 0x0000, 0x0000, 0xffd7, 0x000f, 0x0010, 0x0011,
	0x0012, 0x0013, 0x0014, 0xfebb, 0x0000, 0x0000, 0x0000, 0x0000,
	0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
	0xffdf, 0x0015, 0x0016, 0x0017, 0x0018, 0x0019, 0x001a, 0x001b,
	0xfec1, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
	0x0000, 0x0000, 0x0000, 0x0000, 0xffe8, 0x001c, 0x001d, 0x001e,
	0x001f, 0x0020, 0x0021, 0x0022, 0x0023, 0xfec8, 0x0000, 0x0000,
	0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
	0xfff2, 0x0024, 0x0025, 0x0026, 0x0027, 0x0028, 0x0029, 0x002a,
	0x002b, 0x002c, 0xfed0, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
	0x0000, 0x0000, 0x0000, 0x0000, 0xfffd, 0x002d, 0x002e, 0x002f,
	0x0030, 0x0031, 0x0032, 0x0033, 0x0034, 0x0035, 0x0036, 0xfed9,
	0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
	0xffc7, 0x0037, 0x0038, 0x0039, 0x003a, 0x003b, 0x003c, 0x003d,
	0x003e, 0x003f, 0x0040, 0x0041, 0xfee3, 0x0000, 0x0000, 0x0000,
	0x0000, 0x0000, 0x0000, 0x0000, 0xffd4, 0x0000, 0x0001, 0x0002,
	0x0003, 0x0004, 0x0005, 0x0006, 0x0007, 0x0008, 0x0009, 0x000a,
	0x000b, 0xfeac, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
	0xffe2, 0x000c, 0x000d, 0x000e, 0x000f, 0x0010, 0x0011, 0x0012,
	0x0013, 0x0014, 0x0015, 0x0016, 0x0017, 0x0018, 0xfeb8, 0x0000,
	0x0000, 0x0000, 0x0000, 0x0000, 0xfff1, 0x0019, 0x001a, 0x001b,
	0x001c, 0x001d, 0x001e, 0x001f, 0x0020, 0x0021, 0x0022, 0x0023,
	0x0024, 0x0025, 0x0026, 0xfec5, 0x0000, 0x0000, 0x0000, 0x0000,
	0xffcb, 0x0027, 0x0028, 0x0029, 0x002a, 0x002b, 0x002c, 0x002d,
	0x002e, 0x002f, 0x0030, 0x0031, 0x0032, 0x0033, 0x0034, 0x0035,
	0xfed3, 0x0000, 0x0000, 0x0000, 0xffdc, 0x0000, 0x0001, 0x0002,
	0x0003, 0x0004, 0x0005, 0x0006, 0x0007, 0x0008, 0x0009, 0x000a,
	0x000b, 0x000c, 0x000d, 0x000e, 0x000f, 0xfeac, 0x0000, 0x0000,
	0xffee, 0x0010, 0x0011, 0x0012, 0x0013, 0x0014, 0x0015, 0x0016,
	0x0017, 0x0018, 0x0019, 0x001a, 0x001b, 0x001c, 0x001d, 0x001e,
	0x001f, 0x0020, 0xfebc, 0x0000, 0xffee, 0x0021, 0x0022, 0x0023,
	0x0024, 0x0025, 0x0026, 0x0027, 0x0028, 0x0029, 0x002a, 0x002b,
	0x002c, 0x002d, 0x002e, 0x002f, 0x0030, 0x0031, 0x0032, 0xfecd,
	0x0154, 0x0218, 0x0110, 0x00b0, 0x00cc, 0x00b0, 0x0088, 0x00b0,
	0x0044, 0x00b0, 0x0000, 0x00b0, 0x00fe, 0xff07, 0x0002, 0x00ff,
	0x00f8, 0x0007, 0x00fe, 0x00ee, 0x07ff, 0x0200, 0x00ef, 0xf800,
	0x0700, 0x00ee, 0xffff, 0xffff, 0xffff, 0x0000, 0x0000, 0x0001,
	0x0001, 0x0001, 0x0001, 0x0000, 0x0000, 0xffff, 0xffff, 0xffff,
	0xffff, 0x0000, 0x0000, 0x0001, 0x0001, 0x0001, 0x0001, 0x0000,
	0x0000, 0xffff, 0xffff, 0x0000, 0xffff, 0x0001, 0x0000, 0x0001,
	0x0001, 0x0000, 0x0000, 0xffff, 0xffff, 0xffff, 0xffff, 0x0000,
	0xffff, 0x0001, 0x0000, 0x0001, 0x0001, 0x0000, 0x0000, 0xffff,
	0xffff, 0xffff, 0x0000, 0x0000, 0x0000, 0x0044, 0x0088, 0x00cc,
	0x0110, 0x0154, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
	0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
	0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
	0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
	0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
	0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff
};

#ifdef __WIN32__
static void (__cdecl *SetDSP3)(void);
#else
static void (*SetDSP3)(void);
#endif

static uint16 DSP3_DR;
static uint16 DSP3_SR;
static uint16 DSP3_MemoryIndex;

static inline void DSP3_MemorySize()
{
	DSP3_DR = 0x0300;
	SetDSP3 = &DSP3_Reset;
}

static inline void DSP3_TestMemory()
{
	DSP3_DR = 0x0000;
	SetDSP3 = &DSP3_Reset;
}

static inline void DSP3_DumpDataROM()
{
	DSP3_DR = DSP3_DataROM[DSP3_MemoryIndex++];
	if (DSP3_MemoryIndex == 1024) 
		SetDSP3 = &DSP3_Reset;
}

static inline void DSP3_MemoryDump()
{
	DSP3_MemoryIndex = 0;
	SetDSP3 = &DSP3_DumpDataROM;
	DSP3_DumpDataROM();
}

static int16 DSP3_WinLo;
static int16 DSP3_WinHi;

static inline void DSP3_OP06()
{
	DSP3_WinLo = (uint8)(DSP3_DR);
	DSP3_WinHi = (uint8)(DSP3_DR >> 8);
	DSP3_Reset();
}

static inline void DSP3_OP03()
{
	int16 Lo = (uint8)(DSP3_DR);
	int16 Hi = (uint8)(DSP3_DR >> 8);
	int16 Ofs = (DSP3_WinLo * Hi << 1) + (Lo << 1);
	DSP3_DR = Ofs >> 1;
	SetDSP3 = &DSP3_Reset;
}

static int16 DSP3_AddLo;
static int16 DSP3_AddHi;

static inline void DSP3_OP07_B()
{
	int16 Ofs = (DSP3_WinLo * DSP3_AddHi << 1) + (DSP3_AddLo << 1);
	DSP3_DR = Ofs >> 1;
	SetDSP3 = &DSP3_Reset;
}

static inline void DSP3_OP07_A()
{
	int16 Lo = (uint8)(DSP3_DR);
	int16 Hi = (uint8)(DSP3_DR >> 8);

	if (Lo & 1)	Hi += (DSP3_AddLo & 1);

	DSP3_AddLo += Lo;
	DSP3_AddHi += Hi;

	if (DSP3_AddLo < 0) 
		DSP3_AddLo += DSP3_WinLo;
	else
		if (DSP3_AddLo >= DSP3_WinLo) 
			DSP3_AddLo -= DSP3_WinLo;

	if (DSP3_AddHi < 0) 
		DSP3_AddHi += DSP3_WinHi;
	else
		if (DSP3_AddHi >= DSP3_WinHi) 
			DSP3_AddHi -= DSP3_WinHi;

	DSP3_DR = DSP3_AddLo | (DSP3_AddHi << 8) | ((DSP3_AddHi >> 8) & 0xff);
	SetDSP3 = &DSP3_OP07_B;
}

static inline void DSP3_OP07()
{
	uint32 dataOfs = ((DSP3_DR << 1) + 0x03b2) & 0x03ff;

	DSP3_AddHi = DSP3_DataROM[dataOfs];
	DSP3_AddLo = DSP3_DataROM[dataOfs + 1];

	SetDSP3 = &DSP3_OP07_A;  
	DSP3_SR = 0x0080;
}

static uint16 DSP3_Codewords;
static uint16 DSP3_Outwords;
static uint16 DSP3_Symbol;
static uint16 DSP3_BitCount;
static uint16 DSP3_Index;
static uint16 DSP3_Codes[512];
static uint16 DSP3_BitsLeft;
static uint16 DSP3_ReqBits;
static uint16 DSP3_ReqData;
static uint16 DSP3_BitCommand;
static uint8  DSP3_BaseLength;
static uint16 DSP3_BaseCodes;
static uint16 DSP3_BaseCode;
static uint8  DSP3_CodeLengths[8];
static uint16 DSP3_CodeOffsets[8];
static uint16 DSP3_LZCode;
static uint8  DSP3_LZLength;

static uint16 DSP3_X;
static uint16 DSP3_Y;

static inline void DSP3_Coordinate()
{
	DSP3_Index++;

	switch (DSP3_Index)
	{
	case 3:
		{
			if (DSP3_DR == 0xffff)
				DSP3_Reset();
			break;
		}
	case 4:
		{
			DSP3_X = DSP3_DR;
			break;
		}
	case 5:
		{
			DSP3_Y = DSP3_DR;
			DSP3_DR = 1;
			break;
		}
	case 6:
		{
			DSP3_DR = DSP3_X;
			break;
		}
	case 7:
		{
			DSP3_DR = DSP3_Y;
			DSP3_Index = 0;
			break;
		}
	}
}

static uint8  DSP3_Bitmap[8];
static uint8  DSP3_Bitplane[8];
static uint16 DSP3_BMIndex;
static uint16 DSP3_BPIndex;
static uint16 DSP3_Count;

static inline void DSP3_Convert_A()
{
	if (DSP3_BMIndex < 8)
	{
		DSP3_Bitmap[DSP3_BMIndex++] = (uint8) (DSP3_DR);
		DSP3_Bitmap[DSP3_BMIndex++] = (uint8) (DSP3_DR >> 8);

		if (DSP3_BMIndex == 8)
		{
			for (short i=0; i < 8; i++)
				for (short j=0; j < 8; j++)
				{
					DSP3_Bitplane[j] <<= 1;
					DSP3_Bitplane[j] |= (DSP3_Bitmap[i] >> j) & 1;
				}

			DSP3_BPIndex = 0;
			DSP3_Count--;
		}
	}

	if (DSP3_BMIndex == 8)
	{
		if (DSP3_BPIndex == 8)
		{
			if (!DSP3_Count) DSP3_Reset();
			DSP3_BMIndex = 0;
		}
		else
		{
			DSP3_DR = DSP3_Bitplane[DSP3_BPIndex++];
			DSP3_DR |= DSP3_Bitplane[DSP3_BPIndex++] << 8;
		}
	}
}

static inline void DSP3_Convert()
{
	DSP3_Count = DSP3_DR;
	DSP3_BMIndex = 0;
	SetDSP3 = &DSP3_Convert_A;
}

static inline bool DSP3_GetBits(uint8 Count)
{
	if (!DSP3_BitsLeft)
	{
		DSP3_BitsLeft = Count;
		DSP3_ReqBits = 0;
	}

	do {
		if (!DSP3_BitCount)
		{
			DSP3_SR = 0xC0;
			return false;
		}

		DSP3_ReqBits <<= 1;
		if (DSP3_ReqData & 0x8000) DSP3_ReqBits++;
		DSP3_ReqData <<= 1;
        
		DSP3_BitCount--;
		DSP3_BitsLeft--;

	} while (DSP3_BitsLeft);

	return true;
}

static inline void DSP3_Decode_Data()
{
	if (!DSP3_BitCount)
	{
		if (DSP3_SR & 0x40)
		{
			DSP3_ReqData = DSP3_DR;
			DSP3_BitCount += 16;
		}
		else
		{
			DSP3_SR = 0xC0;
			return;
		}	
	}

	if (DSP3_LZCode == 1)
	{
		if (!DSP3_GetBits(1))
			return;

		if (DSP3_ReqBits)
			DSP3_LZLength = 12;
		else
			DSP3_LZLength = 8;

		DSP3_LZCode++;
	}

	if (DSP3_LZCode == 2)
	{
		if (!DSP3_GetBits(DSP3_LZLength))
			return;

		DSP3_LZCode = 0;
		DSP3_Outwords--;
		if (!DSP3_Outwords) SetDSP3 = &DSP3_Reset;

		DSP3_SR = 0x80;
		DSP3_DR = DSP3_ReqBits;
		return;
	}

	if (DSP3_BaseCode == 0xffff)
	{
		if (!DSP3_GetBits(DSP3_BaseLength))
			return;

		DSP3_BaseCode = DSP3_ReqBits;
	}

	if (!DSP3_GetBits(DSP3_CodeLengths[DSP3_BaseCode]))
		return;

	DSP3_Symbol = DSP3_Codes[DSP3_CodeOffsets[DSP3_BaseCode] + DSP3_ReqBits];
	DSP3_BaseCode = 0xffff;

	if (DSP3_Symbol & 0xff00)
	{
		DSP3_Symbol += 0x7f02;
		DSP3_LZCode++;
	}
	else
	{
		DSP3_Outwords--;
		if (!DSP3_Outwords) 
			SetDSP3 = &DSP3_Reset;
	}

	DSP3_SR = 0x80;
	DSP3_DR = DSP3_Symbol;
}

static inline void DSP3_Decode_Tree()
{
	if (!DSP3_BitCount)
	{
		DSP3_ReqData = DSP3_DR;
		DSP3_BitCount += 16;
	}

	if (!DSP3_BaseCodes)
	{
		DSP3_GetBits(1);
		if (DSP3_ReqBits)
		{
			DSP3_BaseLength = 3;
			DSP3_BaseCodes = 8;
		}
		else
		{
			DSP3_BaseLength = 2;
			DSP3_BaseCodes = 4;
		}
	}

	while (DSP3_BaseCodes)
	{
		if (!DSP3_GetBits(3))
			return;

		DSP3_ReqBits++;

		DSP3_CodeLengths[DSP3_Index] = (uint8) DSP3_ReqBits;
		DSP3_CodeOffsets[DSP3_Index] = DSP3_Symbol;
		DSP3_Index++;

		DSP3_Symbol += 1 << DSP3_ReqBits;
		DSP3_BaseCodes--;
	}

	DSP3_BaseCode = 0xffff;
	DSP3_LZCode = 0;

	SetDSP3 = &DSP3_Decode_Data;
	if (DSP3_BitCount) DSP3_Decode_Data();
}

static inline void DSP3_Decode_Symbols()
{
	DSP3_ReqData = DSP3_DR;
	DSP3_BitCount += 16;

	do {

		if (DSP3_BitCommand == 0xffff)
		{
			if (!DSP3_GetBits(2)) return;
			DSP3_BitCommand = DSP3_ReqBits;
		}

		switch (DSP3_BitCommand)
		{
		case 0:
			{
				if (!DSP3_GetBits(9)) return;
				DSP3_Symbol = DSP3_ReqBits;
				break;
			}
		case 1:
			{
				DSP3_Symbol++;
				break;
			}
		case 2:
			{
				if (!DSP3_GetBits(1)) return;
				DSP3_Symbol += 2 + DSP3_ReqBits;
				break;
			}
		case 3:
			{
				if (!DSP3_GetBits(4)) return;
				DSP3_Symbol += 4 + DSP3_ReqBits;
				break;
			}
		}

		DSP3_BitCommand = 0xffff;

		DSP3_Codes[DSP3_Index++] = DSP3_Symbol;
		DSP3_Codewords--;
		
	} while (DSP3_Codewords);

	DSP3_Index = 0;
	DSP3_Symbol = 0;
	DSP3_BaseCodes = 0;

	SetDSP3 = &DSP3_Decode_Tree;
	if (DSP3_BitCount) DSP3_Decode_Tree();
}

static inline void DSP3_Decode_A()
{
	DSP3_Outwords = DSP3_DR;
	SetDSP3 = &DSP3_Decode_Symbols;
	DSP3_BitCount = 0;
	DSP3_BitsLeft = 0;
	DSP3_Symbol = 0;
	DSP3_Index = 0;
	DSP3_BitCommand = 0xffff;
	DSP3_SR = 0xC0;
}

static inline void DSP3_Decode()
{
	DSP3_Codewords = DSP3_DR;
	SetDSP3 = &DSP3_Decode_A;
}

static inline void DSP3_Command()
{
	if (DSP3_DR < 0x40)
	{
		switch (DSP3_DR)
		{
		case 0x02: SetDSP3 = &DSP3_Coordinate; break;
		case 0x03: SetDSP3 = &DSP3_OP03; break;
		case 0x06: SetDSP3 = &DSP3_OP06; break;
		case 0x07: SetDSP3 = &DSP3_OP07; return;									 
		case 0x0f: SetDSP3 = &DSP3_TestMemory; break;
		case 0x18: SetDSP3 = &DSP3_Convert; break;
		case 0x1f: SetDSP3 = &DSP3_MemoryDump; break;
		case 0x2f: SetDSP3 = &DSP3_MemorySize; break;
		case 0x38: SetDSP3 = &DSP3_Decode; break;
		}
		DSP3_SR = 0x0080;
		DSP3_Index = 0;
	}
}

void DSP3_Reset()
{
	DSP3_DR = 0x0080;
	DSP3_SR = 0x0084;
	SetDSP3 = &DSP3_Command;
}

void DSP3SetByte(uint8 byte, uint16 address)
{
	if ((address & 0xC000) == 0x8000)
    {
		if (DSP3_SR & 0x04)
		{
			DSP3_DR = (DSP3_DR & 0xff00) + byte;
			(*SetDSP3)();
		}
		else
		{
			DSP3_SR ^= 0x10;

			if (DSP3_SR & 0x10)	
				DSP3_DR = (DSP3_DR & 0xff00) + byte;
			else
			{
				DSP3_DR = (DSP3_DR & 0x00ff) + (byte << 8);
				(*SetDSP3)();
			}	
		}
	}
}

uint8 DSP3GetByte(uint16 address)
{
	if ((address & 0xC000) == 0x8000)
    {
		uint8 byte;

		if (DSP3_SR & 0x04)
		{
			byte = (uint8) DSP3_DR;
			(*SetDSP3)();
		}
		else
		{
			DSP3_SR ^= 0x10;

			if (DSP3_SR & 0x10)	
				byte = (uint8) (DSP3_DR);
			else
			{
				byte = (uint8) (DSP3_DR >> 8);
				(*SetDSP3)();
			}
		}

		return byte;
	}

	return (uint8) DSP3_SR;
}
