/*******************************************************************************
  Snes9x - Portable Super Nintendo Entertainment System (TM) emulator.
 
  (c) Copyright 1996 - 2002 Gary Henderson (gary.henderson@ntlworld.com) and
                            Jerremy Koot (jkoot@snes9x.com)

  (c) Copyright 2001 - 2004 John Weidman (jweidman@slip.net)

  (c) Copyright 2002 - 2004 Brad Jorsch (anomie@users.sourceforge.net),
                            funkyass (funkyass@spam.shaw.ca),
                            Joel Yliluoma (http://iki.fi/bisqwit/)
                            Kris Bleakley (codeviolation@hotmail.com),
                            Matthew Kendora,
                            Nach (n-a-c-h@users.sourceforge.net),
                            Peter Bortas (peter@bortas.org) and
                            zones (kasumitokoduck@yahoo.com)

  C4 x86 assembler and some C emulation code
  (c) Copyright 2000 - 2003 zsKnight (zsknight@zsnes.com),
                            _Demo_ (_demo_@zsnes.com), and Nach

  C4 C++ code
  (c) Copyright 2003 Brad Jorsch

  DSP-1 emulator code
  (c) Copyright 1998 - 2004 Ivar (ivar@snes9x.com), _Demo_, Gary Henderson,
                            John Weidman, neviksti (neviksti@hotmail.com),
                            Kris Bleakley, Andreas Naive

  DSP-2 emulator code
  (c) Copyright 2003 Kris Bleakley, John Weidman, neviksti, Matthew Kendora, and
                     Lord Nightmare (lord_nightmare@users.sourceforge.net

  OBC1 emulator code
  (c) Copyright 2001 - 2004 zsKnight, pagefault (pagefault@zsnes.com) and
                            Kris Bleakley
  Ported from x86 assembler to C by sanmaiwashi

  SPC7110 and RTC C++ emulator code
  (c) Copyright 2002 Matthew Kendora with research by
                     zsKnight, John Weidman, and Dark Force

  S-DD1 C emulator code
  (c) Copyright 2003 Brad Jorsch with research by
                     Andreas Naive and John Weidman
 
  S-RTC C emulator code
  (c) Copyright 2001 John Weidman
  
  ST010 C++ emulator code
  (c) Copyright 2003 Feather, Kris Bleakley, John Weidman and Matthew Kendora

  Super FX x86 assembler emulator code 
  (c) Copyright 1998 - 2003 zsKnight, _Demo_, and pagefault 

  Super FX C emulator code 
  (c) Copyright 1997 - 1999 Ivar, Gary Henderson and John Weidman


  SH assembler code partly based on x86 assembler code
  (c) Copyright 2002 - 2004 Marcus Comstedt (marcus@mc.pp.se) 

 
  Specific ports contains the works of other authors. See headers in
  individual files.
 
  Snes9x homepage: http://www.snes9x.com
 
  Permission to use, copy, modify and distribute Snes9x in both binary and
  source form, for non-commercial purposes, is hereby granted without fee,
  providing that this license information and copyright notice appear with
  all copies and any derived work.
 
  This software is provided 'as-is', without any express or implied
  warranty. In no event shall the authors be held liable for any damages
  arising from the use of this software.
 
  Snes9x is freeware for PERSONAL USE only. Commercial users should
  seek permission of the copyright holders first. Commercial use includes
  charging money for Snes9x or software derived from Snes9x.
 
  The copyright holders request that bug fixes and improvements to the code
  should be forwarded to them so everyone can benefit from the modifications
  in future versions.
 
  Super NES and Super Nintendo Entertainment System are trademarks of
  Nintendo Co., Limited and its subsidiary companies.
*******************************************************************************/

#include "snes9x.h"
#include "memmap.h"
#include "cpuops.h"
#include "ppu.h"
#include "cpuexec.h"
#include "debug.h"
#include "snapshot.h"
#include "gfx.h"
#include "apu.h"
#include "soundux.h"
#include "dma.h"
#include "fxemu.h"
#include "sa1.h"
#include "spc7110.h"
#include "cheats.h"
#include "screenshot.h"

#ifdef DEBUGGER
#include "missing.h"
#endif

void S9xSetIRQ (uint32 source)
{
	CPU.IRQActive |= source;
	CPU.Flags |= IRQ_PENDING_FLAG;
	EXT.IRQCycleCount = Settings.DisableIRQCycleCount ? 0 : 3;

#if 1
	if (CheckFlag (IRQ) && CPU.WaitingForInterrupt) {
		// Force IRQ to trigger immediately after WAI - 
		// Final Fantasy Mystic Quest crashes without this.
		EXT.IRQCycleCount = 0;
		CPU.WaitingForInterrupt = FALSE;
		CPU.PC++;
	}
#endif
}

void S9xClearIRQ (uint32 source)
{
    CLEAR_IRQ_SOURCE (source);
}

void S9xDoHBlankProcessing ()
{
#ifdef CPU_SHUTDOWN
	// CPU.WaitCounter is and there is a case of 0.
	CPU.WaitCounter = 1;
#endif
	switch (CPU.WhichEvent) {
	case HBLANK_END_EVENT:
		S9xSetHVIRQ(Settings.HBlankEnd);
		break;

	case DRAM_REFRESH_EVENT:
		if (PPU.HTimerEnabled &&
			PPU.HTimerPosition >= Settings.dram_refresh_pos &&
			PPU.HTimerPosition < (Settings.dram_refresh_pos + Settings.dram_refresh_length)) {
			if(!PPU.VTimerEnabled)
				S9xSetIRQ (PPU_H_BEAM_IRQ_SOURCE);
			else if(CPU.V_Counter == PPU.IRQVBeamPos)
				S9xSetIRQ (PPU_H_BEAM_IRQ_SOURCE | PPU_V_BEAM_IRQ_SOURCE);
		}
		if(!CPU.InDMA) {
			CPU.Cycles += Settings.dram_refresh_length;
			S9xAPUMainLoop();
		}
		break;

	case HBLANK_START_EVENT:
		S9xSetHVIRQ(Settings.HBlankStart);

		//if (IPPU.HDMA && CPU.V_Counter <= PPU.ScreenHeight)
		if (IPPU.HDMA && CPU.V_Counter < PPU.ScreenHeight)
			IPPU.HDMA = S9xDoHDMA (IPPU.HDMA);
		break;

	case HBLANK_HMAX_EVENT:
		S9xSuperFXExec ();

		CPU.Cycles -= Settings.H_Max;
		APU.Cycles -= Settings.H_Max;
		EXT.NextAPUTimerPos -= Settings.H_Max;

#ifdef NEW_INTERRUPT_DELAY
		if(EXT.NMICycleCount < MAX_CYCLES)
			EXT.NMICycleCount -= Settings.H_Max;
#endif

#ifdef MK_APU
		if (IAPU.APUExecuting)
			S9xCatchupCount();
#endif

		CPU.NextEvent = 0;
		ICPU.Scanline++;

		CPU.V_Counter++;
		if (CPU.V_Counter == FIRST_VISIBLE_LINE) {
			Memory.FillRAM[0x4210] = Model._5A22;
			CPU.Flags &= ~NMI_FLAG;
#ifdef NEW_INTERRUPT_DELAY
			EXT.NMICycleCount = MAX_CYCLES;
#endif
			S9xStartScreenRefresh ();
		}
		else if (CPU.V_Counter == PPU.ScreenHeight + FIRST_VISIBLE_LINE) {
			// Start of V-blank
			IPPU.HDMA = 0;
			// Bits 7 and 6 of $4212 are computed when read in S9xGetPPU.
#ifdef DEBUGGER
			missing.dma_this_frame = 0;
#endif
			IPPU.MaxBrightness = PPU.Brightness;
			PPU.ForcedBlanking = (Memory.FillRAM [0x2100] >> 7) & 1;

			if(!PPU.ForcedBlanking) {
				PPU.OAMAddr = PPU.SavedOAMAddr;
				{
					uint8 tmp = 0;
					if(PPU.OAMPriorityRotation)
						tmp = (PPU.OAMAddr&0xFE)>>1;
					if((PPU.OAMFlip&1) || PPU.FirstSprite!=tmp) {
						PPU.FirstSprite=tmp;
						IPPU.OBJChanged=TRUE;
					}
				}
				PPU.OAMFlip = 0;
			}

			Memory.FillRAM[0x4210] = 0x80 |Model._5A22;
			if (Memory.FillRAM[0x4200] & 0x80) {
				CPU.NMIActive = TRUE;
				CPU.Flags |= NMI_FLAG;
#ifdef NEW_INTERRUPT_DELAY
				EXT.NMICycleCount = CPU.Cycles + DELAY_CYCLES;
#else
				EXT.NMICycleCount = CPU.NMITriggerPoint;
#endif
			}

#ifdef OLD_SNAPSHOT_CODE
			if (CPU.Flags & SAVE_SNAPSHOT_FLAG) {
				CPU.Flags &= ~SAVE_SNAPSHOT_FLAG;
				Registers.PC = CPU.PC - CPU.PCBase;
				S9xPackStatus ();
				S9xAPUPackStatus ();
				Snapshot (NULL);
			}
#endif
		}
		else if (CPU.V_Counter == PPU.ScreenHeight + 3) {
			S9xUpdateJoypads ();
		}
		else if (CPU.V_Counter >= (Settings.PAL ? Settings.MAX_PAL_VCOUNTER : Settings.MAX_NTSC_VCOUNTER) +
				 (((Memory.FillRAM[0x2133] & 1) && !(IPPU.FrameCount & 1)) ? 1 : 0)) {
			CPU.V_Counter = 0;
			IPPU.FrameCount++;
			Memory.FillRAM[0x213f] = ((uint8)IPPU.FrameCount << 7) | (Memory.FillRAM[0x213f] & 0x7f);
			PPU.RangeTimeOver = 0;
			CPU.NMIActive = FALSE;
			// derby stallion is bad.
			//CLEAR_IRQ_SOURCE (PPU_V_BEAM_IRQ_SOURCE | PPU_H_BEAM_IRQ_SOURCE);
			ICPU.Frame++;
			PPU.HVBeamCounterLatched = 0;
			S9xEndOfFrame();
			CPU.Flags |= SCAN_KEYS_FLAG;
		}

		if(!Settings.SixteenBit && CPU.V_Counter == PPU.ScreenHeight && IPPU.RenderThisFrame) {
			IPPU_MaxBrightness = IPPU.MaxBrightness;
			memcpy(PPU_CGDATA, PPU.CGDATA, sizeof(uint16) * 256);
		}

		if (CPU.V_Counter >= FIRST_VISIBLE_LINE &&
			CPU.V_Counter < PPU.ScreenHeight + FIRST_VISIBLE_LINE) {
			RenderLine (CPU.V_Counter - FIRST_VISIBLE_LINE);
		}

		//after RenderLine()
		if(CPU.V_Counter == SNES_HEIGHT_EXTENDED)
			S9xEndScreenRefresh ();

		EXT.Clock += Settings.H_Max;

		S9xFixEventCycles ();
		S9xFixSoundSyncCycles ();

		S9xSetHVIRQ(CPU.NextEvent);
		S9xSetVIRQ(CPU.V_Counter);

		//Cycles
		if(CPU.V_Counter == 0)
			S9xStartHDMA ();
		break;

	case HTIMER_BEFORE_EVENT:
	case HTIMER_AFTER_EVENT:
		S9xSetHVIRQ(PPU.HTimerPosition);
		break;
	}
	S9xReschedule ();
}

void S9xEndOfFrame ()
{
	if(IPPU.RenderThisFrame) {
		//take screenshot here.
		if(Settings.TakeScreenshot)
			S9xDoScreenshot(IPPU.RenderedScreenWidth, IPPU.RenderedScreenHeight);

		IPPU.RenderedFramesCount++;
	}

	S9xApplyCheats ();

#ifdef __WIN32__
	if(SNESGameFixes.VoicerKun)
		VOICERKUN_MEMORYFIX ();  // Original
#endif
	Xxx_Lock_Cheat();  // Original

#ifdef DEBUGGER
	if (CPU.Flags & FRAME_ADVANCE_FLAG) {
		if (ICPU.FrameAdvanceCount) {
			ICPU.FrameAdvanceCount--;
			IPPU.RenderThisFrame = TRUE;
			IPPU.FrameSkip = 0;
		}
		else {
			CPU.Flags &= ~FRAME_ADVANCE_FLAG;
			CPU.Flags |= DEBUG_MODE_FLAG;
		}
	}
#endif

	if (CPU.SRAMModified) {
		if (!CPU.AutoSaveTimer) {
			if (!(CPU.AutoSaveTimer = Settings.AutoSaveDelay * Memory.ROMFramesPerSecond))
				CPU.SRAMModified = FALSE;
		}
		else {
			if (!--CPU.AutoSaveTimer) {
				S9xAutoSaveSRAM ();
				CPU.SRAMModified = FALSE;
			}
		}
	}

	if ((IPPU.FrameCount + 1) % Memory.ROMFramesPerSecond == 0) {
		IPPU.DisplayedRenderedFrameCount = IPPU.RenderedFramesCount;
		IPPU.RenderedFramesCount = 0;
	}
}

